<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_samandehi' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_samandehi
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_iravada_samandehi_element', [ $this, 'wrapper_samandehi_element' ] );
			add_shortcode( 'iravada_samandehi', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

                'irava_samandehi_code'     		=> '',
				'class'			                => '',
				'id'			                => '',
                'hide_on_mobile'                => fusion_builder_default_visibility( 'array' ), 
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			
			$fusion_settings = fusion_get_fusion_settings();
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(),$args, 'iravada_samandehi' );
			$this->args = $defaults;

			ob_start();
				
			?>
				<div <?php echo FusionBuilder::attributes( 'iravada_samandehi_element' ); ?>><?php echo base64_decode($this->args['irava_samandehi_code']); ?></div>
			<?php

			return ob_get_clean();

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_samandehi_element() {
			$attr = [ 
				'class' => 'iravada_samandehi_element ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
			$attr['class'] .= ' ' . $this->args['class'];
			
			// PHP Code For Handle id
			$attr['id'] = $this->args['id'];
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );
            
			return $attr;
		}
	}
	new iravada_samandehi();
}

function iravada_samandehi_element() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_samandehi', 
            [
                'name'            => __( 'IRAva Samandehi Logo' , 'iravada' ),
                'shortcode'       => 'iravada_samandehi',
                'icon'            => 'iravada_elements_icon samandehi',
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

                        [
                            'type'        => 'raw_textarea',
                            'heading'     => __( 'Enter Your Samandehi Code', 'iravada' ),
                            'description' => __( 'In the box opposite, you can put the code received from Samandehi site to display the Samandehi logo.', 'iravada' ),
                            'param_name'  => 'irava_samandehi_code',
                            'value'       => '',
                        ],

						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_samandehi_element' );


