<?php

/**
 * Map shortcode to Fusion Builder.
 *
 * @since 1.0
 */
	
if ( ! class_exists( 'iravada_aparat' ) ) {

	/**
	 * Shortcode class.
	 *
	 * @since 1.0
	 */
	class iravada_aparat
    {

		/**
		 * An array of the shortcode arguments.
		 *
		 * @access protected
		 * @since 1.0
		 * @var array
		 */
		protected $args;

		protected $unique_class;

		public function __construct() {
			add_filter( 'fusion_attr_display_video_from_aparat', [ $this, 'wrapper_attr_aparat_video' ] );
			
			add_shortcode( 'iravada_aparat', [ $this, 'render' ] );
		}

		/**
		 * Gets the default values.
		 *
		 * @static
		 * @access public
		 * @since 2.0.0
		 * @return array
		 */
		public static function get_element_defaults() {
			global $fusion_settings;
			
			return [ 

				'class'			            			=> '',
				'id'			            			=> '',
                'hide_on_mobile'            			=> fusion_builder_default_visibility( 'array' ), 
                'display_video_from_aparat' 			=> '',
				'box_shadow_vertical'					=> '0px',
				'box_shadow_horizontal'					=> '0px',
				'box_shadow_blur'						=> '0px',
				'box_shadow_spread'						=> '0px',
				'box_shadow_color'						=> '',
				'box_shadow_style'						=> '',
				'box_shadow'							=> 'no',
				'border_top_aparat'    					=> '0px',
				'border_right_aparat'  					=> '0px',
				'border_bottom_aparat' 					=> '0px',
				'border_left_aparat'   					=> '0px',
				'iravada_aparat_box_border_color'		=> '#f4f4f4',
				'iravada_aparat_box_border_style'		=> '',
				'border_radius_top_left'      			=> '0px',
				'border_radius_top_right'     			=> '0px',
				'border_radius_bottom_right'  			=> '0px',
				'border_radius_bottom_left'   			=> '0px',
				
            ];
		}

		/**
		 * Render the shortcode
		 *
		 * @access public
		 * @since 1.0
		 * @param  array  $args    Shortcode parameters.
		 * @param  string $content Content between shortcode.
		 * @return string          HTML output.
		 */
		public function render( $args, $content = '' ) {
			$fusion_settings = fusion_get_fusion_settings();
			
			$defaults = FusionBuilder::set_shortcode_defaults( self::get_element_defaults(), $args, 'iravada_aparat' );
			
			$this->args = $defaults;

			ob_start();

                $aparat_video_url = $this->args['display_video_from_aparat'];
                $video_key = substr(strrchr($aparat_video_url, '/'), 1);

				?>
					<style>
						.iravada.h_iframe-aparat_embed_frame{position:relative;}
						.iravada.h_iframe-aparat_embed_frame .ratio{display:block;width:100%;height:auto;}
						.iravada.h_iframe-aparat_embed_frame iframe{position:absolute;top:0;left:0;width:100%;height:100%;}
					</style>
					<div class="iravada h_iframe-aparat_embed_frame">
						<span style="display: block;padding-top: 57%"></span>
						<iframe <?php echo FusionBuilder::attributes( 'display_video_from_aparat' ); ?> src="https://www.aparat.com/video/video/embed/videohash/<?php echo $video_key; ?>/vt/frame" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe>
					</div>

                <?php

			return ob_get_clean();

		}

		/**
		 * Builds the attributes array.
		 *
		 * @access public
		 * @since 1.0
		 * @return array
		 * 
		 */
		public function wrapper_attr_aparat_video() {
			$attr = [ 
				'class' => 'display_video_from_aparat ' . $this->unique_class,
				'style' => '' 
			];

			// PHP Code For Handle class
            if ( $this->args['class'] ) {
				$attr['class'] .= ' ' . $this->args['class'];
			}
			
			// PHP Code For Handle id
			if ( $this->args['id'] ) {
				$attr['id'] = $this->args['id'];
			}
			
			// PHP Code For Handle hide_on_mobile
            $attr = fusion_builder_visibility_atts( $this->args['hide_on_mobile'], $attr );

			// Box Shadow Of Video
			if( $this->args['box_shadow'] == 'yes' ) {
				$attr['style'] .= 'box-shadow: '. fusion_library()->sanitize->get_value_with_unit( $this->args['box_shadow_vertical'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['box_shadow_horizontal'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['box_shadow_blur'] ) .' '. fusion_library()->sanitize->get_value_with_unit( $this->args['box_shadow_spread'] ) .' '. $this->args['box_shadow_color'] .' '. $this->args['box_shadow_style'] .' !important;';
			}

			if( $this->args['border_top_aparat'] == '' ) {
				// Do Not Anything
			}else {
				$attr['style'] .= 'border-top:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_top_aparat'] ) .';'; 
			}

			if( $this->args['border_right_aparat'] == '' ) {
				// Do Not Anything
			}else {
				$attr['style'] .= 'border-right:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_right_aparat'] ) .';'; 
			}

			if( $this->args['border_bottom_aparat'] == '' ) {
				// Do Not Anything
			}else {
				$attr['style'] .= 'border-bottom:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_bottom_aparat'] ) .';'; 
			}
			
			if( $this->args['border_left_aparat'] == '' ) {
				// Do Not Anything
			}else {
				$attr['style'] .= 'border-left:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_left_aparat'] ) .';'; 
			}

			if( $this->args['iravada_aparat_box_border_color'] == '' ) {
				// Do Not Anything
			}else {
				$attr['style'] .= 'border-color:' .  $this->args['iravada_aparat_box_border_color'] .';'; 
			}
			
			$attr['style'] .= 'border-radius:' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_left'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_top_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_right'] ) . ' ' . fusion_library()->sanitize->get_value_with_unit( $this->args['border_radius_bottom_left'] ) .'; ';  
            
            $attr['style'] .= 'overflow: hidden;';  
			$attr['style'] .= 'zoom: 1.2;';  

			if( $this->args['iravada_aparat_box_border_style'] === 'a' ) {
				// Do Not Anything
			}else {
				$attr['style'] .= 'border-style: '. $this->args['iravada_aparat_box_border_style'] .';'; 
			}
            
			return $attr;
		}
	}
	new iravada_aparat();
}

function iravada_aparat_element() {

    fusion_builder_map( 
        fusion_builder_frontend_data( 
			'iravada_aparat', 
            [
                'name'            => __( 'IRAva Aparat' , 'iravada' ),
                'shortcode'       => 'iravada_aparat',
                'icon'            => 'iravada_elements_icon aparat',
                'allow_generator' => true,
                'params'          => 
                [

					// Start General Tab

                    [
                        'type'        => 'textfield',
                        'heading'     => __( 'Set Here Video Link On Aparat', 'iravada' ),
                        'description' => __( 'To view the video from the Aparat site, all you have to do is put the Aparat video link in the box below according to the format in order for the video to be displayed for you. Note that only the inserted link should be placed in the box below, otherwise the video will not be displayed. <strong>https://www.aparat.com/v/ABCDE</strong>', 'iravada' ),
                        'param_name'  => 'display_video_from_aparat',
                        'value'       => '',
                    ],

						[ 
							'type' => 'checkbox_button_set', 
							'heading' => esc_attr__( 'Element Visibility', 'fusion-builder' ), 
							'param_name' => 'hide_on_mobile', 
							'value' => fusion_builder_visibility_options( 'full' ), 
							'default' => fusion_builder_default_visibility( 'array' ), 
							'description' => esc_attr__( 
								'Choose to show or hide the element on small, medium or large screens. You can choose more than one at a time.', 
								'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS Class', 'fusion-builder' ), 
							'param_name' => 'class', 
							'value' => '', 
							'description' => esc_attr__( 'Add a class to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' )
						], 

						[ 
							'type' => 'textfield', 
							'heading' => esc_attr__( 'CSS ID', 'fusion-builder' ), 
							'param_name' => 'id', 
							'value' => '', 
							'description' => esc_attr__( 'Add an ID to the wrapping HTML element.', 'fusion-builder' ),
							'group' => esc_attr__( 'General', 'fusion-builder' ) 
						],

					/* End Genera Tab */

					/* Start Design Tab */

						[
							'type'             => 'dimension',
							'remove_from_atts' => true,
							'heading'          => esc_attr__( 'Border Size', 'fusion-builder' ),
							'description'      => esc_attr__( 'Controls the border size', 'fusion-builder' ),
							'param_name'       => 'border_sizes',
							'value'            => [
								'border_top_aparat'    => '',
								'border_right_aparat'  => '',
								'border_bottom_aparat' => '',
								'border_left_aparat'   => '',
							],
							'group'       => esc_html__( 'Design', 'fusion-builder' )
						],
						
						[ 
							'type'        => 'colorpickeralpha',
							'heading'     => esc_attr__( 'Border Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the border color', 'fusion-builder' ),
							'param_name'  => 'iravada_aparat_box_border_color',
							'value'       => '',
							'group'       => esc_html__( 'Design', 'fusion-builder' )
						],

						[
							'type'        => 'select',
							'heading'     => esc_attr__( 'Style', 'fusion-builder' ),
							'description' => __( 'Use this option to adjust the display style of the Video box, default: Simple line', 'iravada' ),
							'param_name'  => 'iravada_aparat_box_border_style',
							'value'       => [
								'a'        	  => __( 'Please select Border style', 'iravada' ),
								'solid'       => esc_attr__( 'Single Border Solid', 'fusion-builder' ),
								'dashed'      => esc_attr__( 'Single Border Dashed', 'fusion-builder' ),
								'dotted'      => esc_attr__( 'Single Border Dotted', 'fusion-builder' ),
							],
							'default'     => 'a',
							'group'       => esc_html__( 'Design', 'fusion-builder' )
						],

						[
							'type'        => 'dimension',
							'heading'     => esc_attr__( 'Border Radius', 'fusion-builder' ),
							'description' => esc_attr__( 'Enter values including any valid CSS unit, ex: 10px. IMPORTANT: In order to make border radius work in browsers, the overflow CSS rule of the column needs set to hidden. Thus, depending on the setup, some contents might get clipped.', 'fusion-builder' ),
							'param_name'  => 'iravada_aparat_box_border_radius',
							'value'       => [
								'border_radius_top_left'     => '',
								'border_radius_top_right'    => '',
								'border_radius_bottom_right' => '',
								'border_radius_bottom_left'  => '',
							],
							'group'       => esc_html__( 'Design', 'fusion-builder' )
						],

						[
							'type'        => 'radio_button_set',
							'heading'     => esc_attr__( 'Box Shadow', 'fusion-builder' ),
							'description' => esc_attr__( 'Set to "Yes" to enable box shadows.', 'fusion-builder' ),
							'param_name'  => 'box_shadow',
							'default'     => 'no',
							'group'       => esc_html__( 'Design', 'fusion-builder' ),
							'value'       => [
								'yes' => esc_attr__( 'Yes', 'fusion-builder' ),
								'no'  => esc_attr__( 'No', 'fusion-builder' ),
							],
							'callback'    => [],
						],
						[
							'type'             => 'dimension',
							'remove_from_atts' => true,
							'heading'          => esc_attr__( 'Box Shadow Position', 'fusion-builder' ),
							'description'      => esc_attr__( 'Set the vertical and horizontal position of the box shadow. Positive values put the shadow below and right of the box, negative values put it above and left of the box. In pixels, ex. 5px.', 'fusion-builder' ),
							'param_name'       => 'dimension_box_shadow',
							'value'            => [
								'box_shadow_horizontal' => '',
								'box_shadow_vertical'   => '',
							],
							'group'            => esc_html__( 'Design', 'fusion-builder' ),
							'dependency'       => [
								[
									'element'  => 'box_shadow',
									'value'    => 'yes',
									'operator' => '==',
								],
							],
							'callback'         => [],
						],
						[
							'type'        => 'range',
							'heading'     => esc_attr__( 'Box Shadow Blur Radius', 'fusion-builder' ),
							'description' => esc_attr__( 'Set the blur radius of the box shadow. In pixels.', 'fusion-builder' ),
							'param_name'  => 'box_shadow_blur',
							'value'       => '0',
							'min'         => '0',
							'max'         => '100',
							'step'        => '1',
							'group'       => esc_html__( 'Design', 'fusion-builder' ),
							'dependency'  => [
								[
									'element'  => 'box_shadow',
									'value'    => 'yes',
									'operator' => '==',
								],
							],
							'callback'    => [],
						],
						[
							'type'        => 'range',
							'heading'     => esc_attr__( 'Box Shadow Spread Radius', 'fusion-builder' ),
							'description' => esc_attr__( 'Set the spread radius of the box shadow. A positive value increases the size of the shadow, a negative value decreases the size of the shadow. In pixels.', 'fusion-builder' ),
							'param_name'  => 'box_shadow_spread',
							'value'       => '0',
							'min'         => '-100',
							'max'         => '100',
							'step'        => '1',
							'group'       => esc_html__( 'Design', 'fusion-builder' ),
							'dependency'  => [
								[
									'element'  => 'box_shadow',
									'value'    => 'yes',
									'operator' => '==',
								],
							],
							'callback'    => [],
						],
						[
							'type'        => 'colorpickeralpha',
							'heading'     => esc_attr__( 'Box Shadow Color', 'fusion-builder' ),
							'description' => esc_attr__( 'Controls the color of the box shadow.', 'fusion-builder' ),
							'param_name'  => 'box_shadow_color',
							'value'       => '',
							'group'       => esc_html__( 'Design', 'fusion-builder' ),
							'dependency'  => [
								[
									'element'  => 'box_shadow',
									'value'    => 'yes',
									'operator' => '==',
								],
							],
							'callback'    => [],
						],
						[
							'type'        => 'radio_button_set',
							'heading'     => esc_attr__( 'Box Shadow Style', 'fusion-builder' ),
							'description' => esc_attr__( 'Set the style of the box shadow to either be an outer or inner shadow.', 'fusion-builder' ),
							'param_name'  => 'box_shadow_style',
							'default'     => '',
							'group'       => esc_html__( 'Design', 'fusion-builder' ),
							'value'       => [
								''      => esc_attr__( 'Outer', 'fusion-builder' ),
								'inset' => esc_attr__( 'Inner', 'fusion-builder' ),
							],
							'dependency'  => [
								[
									'element'  => 'box_shadow',
									'value'    => 'yes',
									'operator' => '==',
								],
							],
							'callback'    => [],
						],

					/* End Design Tab */

                ]
            ]
        )
    );
}
add_action( 'fusion_builder_before_init', 'iravada_aparat_element' );

