<?php

if( !class_exists('Iranavada_Admin_Panel') ) {

    class Iranavada_Admin_Panel {

        public function __construct() {

            $this->iranavada_panel_css_url = get_stylesheet_directory_uri() . '/includes/admin-screens/assets/css';
            $this->iranavada_admin_screen_dir = get_stylesheet_directory() . '/includes/admin-screens/';

            $this->css_path    = get_stylesheet_directory_uri() . '/includes/admin-screens/assets/css';
            $this->js_path     = get_stylesheet_directory_uri() . '/includes/admin-screens/assets/js';

            // Admin Enqueue Scripts/Styles
            add_action( 'admin_enqueue_scripts', array($this, 'iranavada_enqueue_admin_scripts') );

            // Run All Required Files Needed
            $this->load_all_sections_needed();
        }

        // Wp Enqueue Admin Styles/Scripts
        public function iranavada_enqueue_admin_scripts() {

            // Get IPL License Activate Data
            $get_unserialize_data_ipl   = unserialize(get_option('ipl_active_data'));

            wp_enqueue_style('iranavada-panel-styles', $this->iranavada_panel_css_url . '/iravada-admin-styles.css', '', '5.0' );

            wp_register_script( 'irava-admin-script', $this->js_path . '/admin-scripts.js', '', '5.0', true );

            // Localize Script For Dashboard Script
            wp_localize_script( 'irava-admin-script', 'ir_admin_ajax_url', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
            wp_localize_script( 'irava-admin-script', 'wp_language', array( 'current_lang' => get_bloginfo('language') ) );
            
            if(get_option('ipl_active_data')) {

                wp_enqueue_script( 'ipl-public-script', $this->js_path . '/public-scripts.js', '', '5.0', true );
                wp_enqueue_script( 'ipl-md5-script', $this->js_path . '/jquery.md5.js', '', '5.0', true );

                // Localize Script For Public Scripts
                wp_localize_script( 'ipl-public-script', 'public_loaclize_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ), 'home_url' => home_url(), 'pid' => $get_unserialize_data_ipl->productid, 'oid' => $get_unserialize_data_ipl->orderid ) );
            }
        }

        // Load Admin Panels php
        public function load_all_sections_needed() {
            
            // Require Once IranAvada Dashboard
            require_once( $this->iranavada_admin_screen_dir . 'pages/iravada-dashboard.php' );
        }

    }new Iranavada_Admin_Panel();

}