// Query Select Tags Needed

// Get Register LicenseKey Button
const GetButtonRegisterClient = document.querySelector('#iranavada-register-license-button');

// Get Unregister LicenseKeyButton
const GetButtonUnregisterClient = document.querySelector('#iranavada-unregister-license-button');

// Get Register/Unregister Section Parent
const GetParentRegisterButton = document.querySelector('.iravada-ipl-register-license');

// Check Exists Register Button For Send Ajax Request
if( GetButtonRegisterClient ) {

  // Add Event Listener => Click For Send Ajax Request LicenseKey => Register
  GetButtonRegisterClient.addEventListener('click', RegisterLicenseAjax);

}

// Check Exists Unregister Button For Send Ajax Request
if( GetButtonUnregisterClient ) {

  // Add Event Listener => Click For Send Ajax Request LicenseKey => UnRegister
  GetButtonUnregisterClient.addEventListener('click', UnregisterLicenseAjax);

}

/* 
  * Function For Handle Ajax Request For Register LicenseKey On Dashboard => Admin Page
  * Register Action
*/
function RegisterLicenseAjax(e) {

  e.preventDefault();

  const GetLicenseKey = document.querySelector('#iranavada_activated_license').value;
  const GetNoticeSection = document.querySelector('.iravada-license-register-notice');
  const GetLicenseParentSection = document.querySelector('.iranavada-register-license');

  // Create p tag
  const CreateNoticeTag     = document.createElement('p');
  // const CreateCloseBarTag   = document.createElement('span');
  
  if( GetLicenseKey == '' ) {

    if( wp_language.current_lang == 'fa-IR' ) {

      // Create Warning Text For Empty Send License Field
      CreateNoticeTag.classList.add('iravada-license-register-notice', 'warning-notice');
      CreateNoticeTag.appendChild(document.createTextNode('فیلد لایسنس خالی می‌باشد'));
      GetLicenseParentSection.replaceChild(CreateNoticeTag, GetNoticeSection);

    }else {

      // Create Warning Text For Empty Send License Field
      CreateNoticeTag.classList.add('iravada-license-register-notice', 'warning-notice');
      CreateNoticeTag.appendChild(document.createTextNode('The license field is empty'));
      GetLicenseParentSection.replaceChild(CreateNoticeTag, GetNoticeSection);

    }

  }else {

    jQuery.ajax({
            
      url: ir_admin_ajax_url.ajax_url,
      data:{
          action: "iravada_reg_license_by_user",
          licensekey: GetLicenseKey,
      },
      cache: false,
      type: "POST",
      beforeSend: function(result) {
  
        if( wp_language.current_lang == 'fa-IR' ) {
          // Button Actions BeforeSend Ajax Request ==> FA
          jQuery(GetButtonRegisterClient).val('در حال ثبت لایسنس');
        }else {
          // Button Actions BeforeSend Ajax Request ==> EN And Other Languages
          jQuery(GetButtonRegisterClient).val('Registering license...');
        }
        GetParentRegisterButton.classList.add('add-loader');
  
      },
      success: function(result){
  
        // Start Add NoticeSection Register Result
  
          // IF For Check License Active
          if( result == 'LicenseActive' ) {
  
            if( wp_language.current_lang == 'fa-IR' ) {

              // Add Result Notice IF License OK
              CreateNoticeTag.classList.add('iravada-license-register-notice', 'success-notice');
              CreateNoticeTag.appendChild(document.createTextNode('قالب شما فعال شد، منتظر باشید ...'));
              GetLicenseParentSection.replaceChild(CreateNoticeTag, GetNoticeSection);

              // Change Button Value After Success Ajax Request
              jQuery(GetButtonRegisterClient).val('غیرفعال سازی لایسنس');

            }else {

              // Add Result Notice IF License OK
              CreateNoticeTag.classList.add('iravada-license-register-notice', 'success-notice');
              CreateNoticeTag.appendChild(document.createTextNode('Your template has been activated, please wait...'));
              GetLicenseParentSection.replaceChild(CreateNoticeTag, GetNoticeSection);

              // Change Button Value After Success Ajax Request
              jQuery(GetButtonRegisterClient).val('Deactivated Lisence');

            }

            // Add Unregister ID
            GetButtonRegisterClient.id = 'iranavada-unregister-license-button';
  
            // Add Unregister Class
            GetButtonRegisterClient.className = 'iranavada-unregister-license-button';

            // Reload For Active Theme
            setTimeout(function () {
              location.reload();
            }, 1000);
  
          }
  
          // IF For Check License Not Active OR License Empty
          if( result == 'LicenseNotActive' ) {
  
            if( wp_language.current_lang == 'fa-IR' ) {

              // Add Result Notice IF License Not OK
              CreateNoticeTag.classList.add('iravada-license-register-notice', 'error-notice');
              CreateNoticeTag.appendChild(document.createTextNode('لایسنس شما معتبر نیست'));
              GetLicenseParentSection.replaceChild(CreateNoticeTag, GetNoticeSection);
    
              // Change Button Value After Complate Ajax Request
              jQuery(GetButtonRegisterClient).val('ثبت لایسنس');

            }else {

              // Add Result Notice IF License Not OK
              CreateNoticeTag.classList.add('iravada-license-register-notice', 'error-notice');
              CreateNoticeTag.appendChild(document.createTextNode('Your license is not valid'));
              GetLicenseParentSection.replaceChild(CreateNoticeTag, GetNoticeSection);
    
              // Change Button Value After Complate Ajax Request
              jQuery(GetButtonRegisterClient).val('Register Lisence');

            }
  
          }
  
        // End Add NoticeSection Register Result
  
      },
      complete: function (result) {
        
        // Remove Add Loader Class For Remove Loading Animation
        GetParentRegisterButton.classList.remove('add-loader');

      },
  
    })

  }

}

/* 
  * Function For Handle Ajax Request For Register LicenseKey On Dashboard => Admin Page
  * UnRegister Action
*/
function UnregisterLicenseAjax(e) {

    e.preventDefault();
    
    // Get License Field For Return Empty
    const GetLicenseField = document.querySelector('#iranavada_activated_license');
    
    // CreateNoticeTag => p Element
    const CreateNoticeTag = document.createElement('p');
    
    // Get NoticeSection For Display Notice
    const GetNoticeSection = document.querySelector('.iravada-license-register-notice');
    
    // Get License Parent Section
    const GetLicenseParentSection = document.querySelector('.iranavada-register-license');

    jQuery.ajax({
            
      url: ir_admin_ajax_url.ajax_url,
      data:{
          action: "iravada_unregister_license",
      },
      cache: false,
      type: "POST",
      beforeSend: function(result) {
    
        if( wp_language.current_lang == 'fa-IR' ) {

          // Button Actions BeforeSend Ajax Request
          jQuery(GetButtonUnregisterClient).val('غیرفعالسازی...');

        }else {

          // Button Actions BeforeSend Ajax Request
          jQuery(GetButtonUnregisterClient).val('Deactivating...');

        }

        GetParentRegisterButton.classList.add('add-loader');
    
      },
      success: function(result){
    
        if( result == 'LicenseDeactivated' ) {
    
          if( wp_language.current_lang == 'fa-IR' ) {

            // Create Notice For Deactivated License
            CreateNoticeTag.classList.add('iravada-license-register-notice', 'warning-notice');
            CreateNoticeTag.appendChild(document.createTextNode('لایسنس شما غیرفعال شد، منتظر باشید ...'));
            GetLicenseParentSection.replaceChild(CreateNoticeTag, GetNoticeSection);
      
            // Change Button Value After Complate Ajax Request -> Deactive License
            jQuery(GetButtonUnregisterClient).val('ثبت لایسنس');
  
          }else {
  
            // Create Notice For Deactivated License
            CreateNoticeTag.classList.add('iravada-license-register-notice', 'warning-notice');
            CreateNoticeTag.appendChild(document.createTextNode('Your license has been deactivated, please wait...'));
            GetLicenseParentSection.replaceChild(CreateNoticeTag, GetNoticeSection);
      
            // Change Button Value After Complate Ajax Request -> Deactive License
            jQuery(GetButtonUnregisterClient).val('Register License');
  
          }
    
          // Add Unregister ID
          GetButtonUnregisterClient.id = 'iranavada-register-license-button';
    
          // Add Unregister Class
          GetButtonUnregisterClient.className = 'iranavada-register-license-button';
    
          // Return License Field Empty
          GetLicenseField.value = '';
    
          // Reload For Deactive Theme
          setTimeout(function () {
            location.reload();
          }, 1000);
    
        }
    
      },
      complete: function (result) {
    
        // Remove Add Loader Class For Remove Loading Animation
        GetParentRegisterButton.classList.remove('add-loader');
    
      },
    
    });

}

// Start Ajax Update Language Button

// Get Update Language Button
const GetUpdateLanguageButton = document.querySelector('.ipl-update-lang');

if( GetUpdateLanguageButton ) {

// Add Event Listener For Update Language Button
GetUpdateLanguageButton.addEventListener('click', IplUpdateLanguageIranavadaDashboard);

function IplUpdateLanguageIranavadaDashboard(e) {

  e.preventDefault();

  // Get Update Button Parent
  const GetUpdateLanguageButtonParent = document.querySelector('.lang-update-button');

  // Get Update Language Button
  const GetUpdateLanguageButton       = document.querySelector('.ipl-update-lang');

  // Create Update Language Notice Tag
  const CreateUpdateLangNoticeTag     = document.createElement('span');

  // Get Parent Of Update Language Notice Section
  const GetParentUpdateLanguageBTN    = document.querySelector('.iranavada-update-section');

  jQuery.ajax({
            
    url: ir_admin_ajax_url.ajax_url,
    data:{
        action: "ipl_update_languages",
    },
    cache: false,
    type: "POST",
    beforeSend: function(result) {

      // Add Class For Display Loading  ==> 'add-loader'
      GetUpdateLanguageButtonParent.classList.add('add-loader');

      // Change Update Language Button Value 
      GetUpdateLanguageButton.value = 'در حال بروزرسانی...';

    },
    success: function(result){

      if( result == 'UpdateLanguagesSuccessfully' ) {

        // Add Class For Display Loading  ==> 'add-loader'
        GetUpdateLanguageButtonParent.classList.remove('add-loader');

        // Change Update Language Button Value 
        GetUpdateLanguageButton.value = 'فایل‌های زبان آپدیت شد';

        // Create Class List/AppendChild and Appended Notice To Update Section Notice ==> Language Update
        CreateUpdateLangNoticeTag.classList.add('iravada-update-language-notice', 'success-notice');
        CreateUpdateLangNoticeTag.appendChild( document.createTextNode('فایل‌های زبان با موفقیت بروز شد، منتظر باشید ...') );
        GetParentUpdateLanguageBTN.append(CreateUpdateLangNoticeTag);

        // Reload For After Update Languages
        setTimeout(function () {
          location.reload();
        }, 1000);

      }

    },
    complete: function (result) {},

  });
  
}

// End Ajax Update Language Button

}
