<?php
// 1lang
function theme_enqueue_styles() {
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', [] );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles', 20 );

function avada_lang_setup() {
	$lang = get_stylesheet_directory() . '/languages';
	load_child_theme_textdomain( 'Avada', $lang );
}
add_action( 'after_setup_theme', 'avada_lang_setup' );

function iranavada_metadata() { ?><meta name="designer" content="IranAvada" /><?php }
add_action( 'wp_head', 'iranavada_metadata' );

function custom_admin_style() {
    wp_enqueue_style( 'iranavada-admin', get_stylesheet_directory_uri() . '/assets/rtl-admin.css', '', '2.12' );
}
add_action( 'admin_enqueue_scripts', 'custom_admin_style' );

function custom_demo_style() {
	wp_enqueue_style( 'iravada-demo-styles' , get_stylesheet_directory_uri() . '/assets/demo-styles.css', '', '7.8.2' );
	
	if( is_rtl() ) {
		wp_enqueue_style( 'iravada-rtl-styles' , get_stylesheet_directory_uri() . '/assets/rtl-styles.css', '', '3.5.19' );
	}
}
add_action( 'wp_print_styles', 'custom_demo_style' );

function live_pane() {
	if ( fusion_is_builder_frame() ) { 
		wp_enqueue_style( 'fusion_app_rtl_panel_css', get_stylesheet_directory_uri() . '/assets/rtl-panel.css', '', '1.9' );
	}
}
add_action( 'wp_enqueue_scripts', 'live_pane' , 1000 );

add_action( 'after_setup_theme' , 'ipl_och_updater' );
function ipl_och_updater() {
    // Metadata, Child Path, Child Folder
	$ChildthemeUpdater = Puc_v4_Factory::buildUpdateChecker(METADATAURL_1LCH, __FILE__, 'IranAvada-Child' );
}
require_once( get_stylesheet_directory() . '/includes/admin-screens/iranavada-admin.php' );
require_once( get_stylesheet_directory() . '/includes/updater-core/plugin-update-checker.php' );
define('updaterID', 19977);

if(!function_exists('is_plugin_active')) include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if ( is_plugin_active( 'fusion-builder/fusion-builder.php' ) ) {
	require_once( get_stylesheet_directory() . '/includes/iravada-elements/iravada-elements.php' );
}
