-- All In One WP Security & Firewall 4.4.10
-- MySQL dump
-- 2022-10-23 12:12:09

SET NAMES utf8;
SET foreign_key_checks = 0;

DROP TABLE IF EXISTS `a3rfa_aiowps_debug_log`;

CREATE TABLE `a3rfa_aiowps_debug_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_aiowps_events`;

CREATE TABLE `a3rfa_aiowps_events` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `event_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `event_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `ip_or_host` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `referer_info` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country_code` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `event_data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_aiowps_failed_logins`;

CREATE TABLE `a3rfa_aiowps_failed_logins` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `failed_login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_attempt_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_aiowps_global_meta`;

CREATE TABLE `a3rfa_aiowps_global_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date_time` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `meta_key1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_key5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value2` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value3` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value4` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta_value5` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_aiowps_login_activity`;

CREATE TABLE `a3rfa_aiowps_login_activity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `login_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `logout_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `login_country` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `browser_type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_aiowps_login_activity` VALUES("1","3","iravada","2021-11-24 12:38:11","1000-10-10 10:00:00","5.159.54.226","","");
INSERT INTO `a3rfa_aiowps_login_activity` VALUES("2","3","iravada","2021-11-27 19:44:22","1000-10-10 10:00:00","80.191.234.157","","");
INSERT INTO `a3rfa_aiowps_login_activity` VALUES("3","3","iravada","2022-02-18 16:49:49","2022-02-18 16:58:42","2.178.70.147","","");
INSERT INTO `a3rfa_aiowps_login_activity` VALUES("4","3","iravada","2022-03-12 21:21:23","1000-10-10 10:00:00","94.182.182.30","","");


DROP TABLE IF EXISTS `a3rfa_aiowps_login_lockdown`;

CREATE TABLE `a3rfa_aiowps_login_lockdown` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_login` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lockdown_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `release_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `failed_login_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `lock_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `unlock_key` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_aiowps_permanent_block`;

CREATE TABLE `a3rfa_aiowps_permanent_block` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `blocked_ip` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `block_reason` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `country_origin` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `blocked_date` datetime NOT NULL DEFAULT '1000-10-10 10:00:00',
  `unblock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_commentmeta`;

CREATE TABLE `a3rfa_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_comments`;

CREATE TABLE `a3rfa_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_duplicator_packages`;

CREATE TABLE `a3rfa_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS `a3rfa_fusion_form_entries`;

CREATE TABLE `a3rfa_fusion_form_entries` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `field_id` bigint(20) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `privacy` tinyint(1) DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_fusion_form_fields`;

CREATE TABLE `a3rfa_fusion_form_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `field_name` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_label` varchar(256) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_fusion_form_submissions`;

CREATE TABLE `a3rfa_fusion_form_submissions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `time` datetime NOT NULL,
  `source_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `ip` varchar(512) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_read` tinyint(1) DEFAULT NULL,
  `privacy_scrub_date` date DEFAULT NULL,
  `on_privacy_scrub` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_fusion_forms`;

CREATE TABLE `a3rfa_fusion_forms` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `views` bigint(20) DEFAULT '0',
  `submissions_count` bigint(20) DEFAULT '0',
  `data` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_fusion_forms` VALUES("1","787","25","0","");


DROP TABLE IF EXISTS `a3rfa_icl_content_status`;

CREATE TABLE `a3rfa_icl_content_status` (
  `rid` bigint(20) NOT NULL,
  `nid` bigint(20) NOT NULL,
  `timestamp` datetime NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_core_status`;

CREATE TABLE `a3rfa_icl_core_status` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `module` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `origin` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `target` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_flags`;

CREATE TABLE `a3rfa_icl_flags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_code` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `flag` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `from_template` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lang_code` (`lang_code`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_icl_flags` VALUES("1","ar","ar.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("2","bg","bg.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("3","bs","bs.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("4","ca","ca.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("5","cs","cs.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("6","cy","cy.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("7","da","da.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("8","de","de.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("9","el","el.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("10","en","en.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("11","eo","eo.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("12","es","es.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("13","et","et.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("14","eu","eu.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("15","fa","fa.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("16","fi","fi.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("17","fr","fr.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("18","ga","ga.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("19","he","he.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("20","hi","hi.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("21","hr","hr.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("22","hu","hu.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("23","hy","hy.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("24","id","id.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("25","is","is.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("26","it","it.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("27","ja","ja.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("28","ko","ko.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("29","ku","ku.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("30","la","la.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("31","lt","lt.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("32","lv","lv.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("33","mk","mk.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("34","mn","mn.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("35","ms","ms.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("36","mt","mt.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("37","nb","nb.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("38","ne","ne.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("39","nl","nl.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("40","pa","pa.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("41","pl","pl.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("42","pt-br","pt-br.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("43","pt-pt","pt-pt.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("44","qu","qu.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("45","ro","ro.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("46","ru","ru.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("47","sk","sk.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("48","sl","sl.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("49","so","so.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("50","sq","sq.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("51","sr","sr.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("52","sv","sv.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("53","ta","ta.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("54","th","th.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("55","tr","tr.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("56","uk","uk.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("57","ur","ur.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("58","uz","uz.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("59","vi","vi.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("60","yi","yi.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("61","zh-hans","zh-hans.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("62","zh-hant","zh-hant.png","0");
INSERT INTO `a3rfa_icl_flags` VALUES("63","zu","zu.png","0");


DROP TABLE IF EXISTS `a3rfa_icl_languages`;

CREATE TABLE `a3rfa_icl_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `english_name` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `major` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL,
  `default_locale` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tag` varchar(35) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `encode_url` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `english_name` (`english_name`)
) ENGINE=MyISAM AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_icl_languages` VALUES("1","en","English","1","1","en_US","en","0");
INSERT INTO `a3rfa_icl_languages` VALUES("2","es","Spanish","1","0","es_ES","es","0");
INSERT INTO `a3rfa_icl_languages` VALUES("3","de","German","1","0","de_DE","de","0");
INSERT INTO `a3rfa_icl_languages` VALUES("4","fr","French","1","0","fr_FR","fr","0");
INSERT INTO `a3rfa_icl_languages` VALUES("5","ar","Arabic","0","0","ar","ar","0");
INSERT INTO `a3rfa_icl_languages` VALUES("6","bs","Bosnian","0","0","","bs","0");
INSERT INTO `a3rfa_icl_languages` VALUES("7","bg","Bulgarian","0","0","bg_BG","bg","0");
INSERT INTO `a3rfa_icl_languages` VALUES("8","ca","Catalan","0","0","ca","ca","0");
INSERT INTO `a3rfa_icl_languages` VALUES("9","cs","Czech","0","0","cs_CZ","cs","0");
INSERT INTO `a3rfa_icl_languages` VALUES("10","sk","Slovak","0","0","sk_SK","sk","0");
INSERT INTO `a3rfa_icl_languages` VALUES("11","cy","Welsh","0","0","cy_GB","cy","0");
INSERT INTO `a3rfa_icl_languages` VALUES("12","da","Danish","1","0","da_DK","da","0");
INSERT INTO `a3rfa_icl_languages` VALUES("13","el","Greek","0","0","el","el","0");
INSERT INTO `a3rfa_icl_languages` VALUES("14","eo","Esperanto","0","0","eo_UY","eo","0");
INSERT INTO `a3rfa_icl_languages` VALUES("15","et","Estonian","0","0","et","et","0");
INSERT INTO `a3rfa_icl_languages` VALUES("16","eu","Basque","0","0","eu_ES","eu","0");
INSERT INTO `a3rfa_icl_languages` VALUES("17","fa","Persian","0","1","fa_IR","fa","0");
INSERT INTO `a3rfa_icl_languages` VALUES("18","fi","Finnish","0","0","fi","fi","0");
INSERT INTO `a3rfa_icl_languages` VALUES("19","ga","Irish","0","0","","ga","0");
INSERT INTO `a3rfa_icl_languages` VALUES("20","he","Hebrew","0","0","he_IL","he","0");
INSERT INTO `a3rfa_icl_languages` VALUES("21","hi","Hindi","0","0","","hi","0");
INSERT INTO `a3rfa_icl_languages` VALUES("22","hr","Croatian","0","0","hr_HR","hr","0");
INSERT INTO `a3rfa_icl_languages` VALUES("23","hu","Hungarian","0","0","hu_HU","hu","0");
INSERT INTO `a3rfa_icl_languages` VALUES("24","hy","Armenian","0","0","","hy","0");
INSERT INTO `a3rfa_icl_languages` VALUES("25","id","Indonesian","0","0","id_ID","id","0");
INSERT INTO `a3rfa_icl_languages` VALUES("26","is","Icelandic","0","0","is_IS","is","0");
INSERT INTO `a3rfa_icl_languages` VALUES("27","it","Italian","1","0","it_IT","it","0");
INSERT INTO `a3rfa_icl_languages` VALUES("28","ja","Japanese","1","0","ja","ja","0");
INSERT INTO `a3rfa_icl_languages` VALUES("29","ko","Korean","0","0","ko_KR","ko","0");
INSERT INTO `a3rfa_icl_languages` VALUES("30","ku","Kurdish","0","0","ku","ku","0");
INSERT INTO `a3rfa_icl_languages` VALUES("31","la","Latin","0","0","","la","0");
INSERT INTO `a3rfa_icl_languages` VALUES("32","lv","Latvian","0","0","lv_LV","lv","0");
INSERT INTO `a3rfa_icl_languages` VALUES("33","lt","Lithuanian","0","0","lt_LT","lt","0");
INSERT INTO `a3rfa_icl_languages` VALUES("34","mk","Macedonian","0","0","mk_MK","mk","0");
INSERT INTO `a3rfa_icl_languages` VALUES("35","mt","Maltese","0","0","","mt","0");
INSERT INTO `a3rfa_icl_languages` VALUES("36","mn","Mongolian","0","0","","mn","0");
INSERT INTO `a3rfa_icl_languages` VALUES("37","ne","Nepali","0","0","","ne","0");
INSERT INTO `a3rfa_icl_languages` VALUES("38","nl","Dutch","1","0","nl_NL","nl","0");
INSERT INTO `a3rfa_icl_languages` VALUES("39","nb","Norwegian Bokmål","0","0","nb_NO","nb","0");
INSERT INTO `a3rfa_icl_languages` VALUES("40","pa","Punjabi","0","0","","pa","0");
INSERT INTO `a3rfa_icl_languages` VALUES("41","pl","Polish","0","0","pl_PL","pl","0");
INSERT INTO `a3rfa_icl_languages` VALUES("42","pt-pt","Portuguese, Portugal","0","0","pt_PT","pt-pt","0");
INSERT INTO `a3rfa_icl_languages` VALUES("43","pt-br","Portuguese, Brazil","0","0","pt_BR","pt-br","0");
INSERT INTO `a3rfa_icl_languages` VALUES("44","qu","Quechua","0","0","","qu","0");
INSERT INTO `a3rfa_icl_languages` VALUES("45","ro","Romanian","0","0","ro_RO","ro","0");
INSERT INTO `a3rfa_icl_languages` VALUES("46","ru","Russian","1","0","ru_RU","ru","0");
INSERT INTO `a3rfa_icl_languages` VALUES("47","sl","Slovenian","0","0","sl_SI","sl","0");
INSERT INTO `a3rfa_icl_languages` VALUES("48","so","Somali","0","0","","so","0");
INSERT INTO `a3rfa_icl_languages` VALUES("49","sq","Albanian","0","0","","sq","0");
INSERT INTO `a3rfa_icl_languages` VALUES("50","sr","Serbian","0","0","sr_RS","sr","0");
INSERT INTO `a3rfa_icl_languages` VALUES("51","sv","Swedish","0","0","sv_SE","sv","0");
INSERT INTO `a3rfa_icl_languages` VALUES("52","ta","Tamil","0","0","","ta","0");
INSERT INTO `a3rfa_icl_languages` VALUES("53","th","Thai","0","0","th_TH","th","0");
INSERT INTO `a3rfa_icl_languages` VALUES("54","tr","Turkish","0","0","tr_TR","tr","0");
INSERT INTO `a3rfa_icl_languages` VALUES("55","uk","Ukrainian","0","0","uk_UA","uk","0");
INSERT INTO `a3rfa_icl_languages` VALUES("56","ur","Urdu","0","0","","ur","0");
INSERT INTO `a3rfa_icl_languages` VALUES("57","uz","Uzbek","0","0","uz_UZ","uz","0");
INSERT INTO `a3rfa_icl_languages` VALUES("58","vi","Vietnamese","0","0","vi_VN","vi","0");
INSERT INTO `a3rfa_icl_languages` VALUES("59","yi","Yiddish","0","0","","yi","0");
INSERT INTO `a3rfa_icl_languages` VALUES("60","zh-hans","Chinese (Simplified)","1","0","zh_CN","zh-hans","0");
INSERT INTO `a3rfa_icl_languages` VALUES("61","zu","Zulu","0","0","","zu","0");
INSERT INTO `a3rfa_icl_languages` VALUES("62","zh-hant","Chinese (Traditional)","1","0","zh_TW","zh-hant","0");
INSERT INTO `a3rfa_icl_languages` VALUES("63","ms","Malay","0","0","ms_MY","ms","0");


DROP TABLE IF EXISTS `a3rfa_icl_languages_translations`;

CREATE TABLE `a3rfa_icl_languages_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `display_language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `language_code` (`language_code`,`display_language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=3970 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_icl_languages_translations` VALUES("1","en","en","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2","en","es","Inglés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3","en","de","Englisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("4","en","fr","Anglais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("5","en","ar","الإنجليزية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("6","en","bs","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("7","en","bg","Английски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("8","en","ca","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("9","en","cs","Angličtina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("10","en","sk","Angličtina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("11","en","cy","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("12","en","da","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("13","en","el","Αγγλικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("14","en","eo","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("15","en","et","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("16","en","eu","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("17","en","fa","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("18","en","fi","englanti");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("19","en","ga","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("20","en","he","אנגלית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("21","en","hi","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("22","en","hr","Engleski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("23","en","hu","angol");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("24","en","hy","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("25","en","id","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("26","en","is","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("27","en","it","Inglese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("28","en","ja","英語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("29","en","ko","영어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("30","en","ku","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("31","en","la","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("32","en","lv","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("33","en","lt","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("34","en","mk","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("35","en","mt","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("36","en","mn","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("37","en","ne","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("38","en","nl","Engels");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("39","en","nb","Engelsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("40","en","pa","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("41","en","pl","angielski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("42","en","pt-pt","Inglês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("43","en","pt-br","Inglês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("44","en","qu","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("45","en","ro","Engleză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("46","en","ru","Английский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("47","en","sl","Angleščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("48","en","so","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("49","en","sq","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("50","en","sr","енглески");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("51","en","sv","Engelska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("52","en","ta","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("53","en","th","อังกฤษ");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("54","en","tr","İngilizce");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("55","en","uk","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("56","en","ur","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("57","en","uz","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("58","en","vi","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("59","en","yi","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("60","en","zh-hans","英语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("61","en","zu","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("62","en","zh-hant","英語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("63","en","ms","English");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("64","es","en","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("65","es","es","Español");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("66","es","de","Spanisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("67","es","fr","Espagnol");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("68","es","ar","الأسبانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("69","es","bs","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("70","es","bg","Испански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("71","es","ca","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("72","es","cs","Španělský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("73","es","sk","Španielčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("74","es","cy","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("75","es","da","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("76","es","el","Ισπανικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("77","es","eo","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("78","es","et","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("79","es","eu","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("80","es","fa","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("81","es","fi","espanja");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("82","es","ga","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("83","es","he","ספרדית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("84","es","hi","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("85","es","hr","španjolski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("86","es","hu","spanyol");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("87","es","hy","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("88","es","id","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("89","es","is","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("90","es","it","Spagnolo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("91","es","ja","スペイン語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("92","es","ko","스페인어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("93","es","ku","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("94","es","la","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("95","es","lv","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("96","es","lt","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("97","es","mk","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("98","es","mt","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("99","es","mn","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("100","es","ne","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("101","es","nl","Spaans");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("102","es","nb","Spansk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("103","es","pa","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("104","es","pl","hiszpański");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("105","es","pt-pt","Espanhol");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("106","es","pt-br","Espanhol");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("107","es","qu","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("108","es","ro","Spaniolă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("109","es","ru","Испанский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("110","es","sl","Španščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("111","es","so","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("112","es","sq","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("113","es","sr","шпански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("114","es","sv","Spanska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("115","es","ta","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("116","es","th","สเปน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("117","es","tr","İspanyolca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("118","es","uk","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("119","es","ur","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("120","es","uz","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("121","es","vi","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("122","es","yi","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("123","es","zh-hans","西班牙语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("124","es","zu","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("125","es","zh-hant","西班牙語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("126","es","ms","Spanish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("127","de","en","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("128","de","es","Alemán");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("129","de","de","Deutsch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("130","de","fr","Allemand");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("131","de","ar","الألمانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("132","de","bs","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("133","de","bg","Немски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("134","de","ca","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("135","de","cs","Němec");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("136","de","sk","Nemčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("137","de","cy","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("138","de","da","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("139","de","el","Γερμανικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("140","de","eo","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("141","de","et","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("142","de","eu","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("143","de","fa","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("144","de","fi","saksa");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("145","de","ga","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("146","de","he","גרמנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("147","de","hi","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("148","de","hr","Njemački");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("149","de","hu","német");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("150","de","hy","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("151","de","id","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("152","de","is","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("153","de","it","Tedesco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("154","de","ja","ドイツ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("155","de","ko","독어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("156","de","ku","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("157","de","la","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("158","de","lv","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("159","de","lt","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("160","de","mk","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("161","de","mt","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("162","de","mn","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("163","de","ne","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("164","de","nl","Duits");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("165","de","nb","Tysk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("166","de","pa","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("167","de","pl","niemiecki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("168","de","pt-pt","Alemão");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("169","de","pt-br","Alemão");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("170","de","qu","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("171","de","ro","Germană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("172","de","ru","Немецкий");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("173","de","sl","Nemščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("174","de","so","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("175","de","sq","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("176","de","sr","немачки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("177","de","sv","Tyska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("178","de","ta","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("179","de","th","เยอรมัน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("180","de","tr","Almanca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("181","de","uk","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("182","de","ur","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("183","de","uz","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("184","de","vi","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("185","de","yi","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("186","de","zh-hans","德语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("187","de","zu","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("188","de","zh-hant","德語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("189","de","ms","German");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("190","fr","en","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("191","fr","es","Francés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("192","fr","de","Französisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("193","fr","fr","Français");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("194","fr","ar","الفرنسية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("195","fr","bs","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("196","fr","bg","Френски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("197","fr","ca","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("198","fr","cs","Francouzština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("199","fr","sk","Francúzština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("200","fr","cy","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("201","fr","da","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("202","fr","el","Γαλλικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("203","fr","eo","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("204","fr","et","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("205","fr","eu","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("206","fr","fa","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("207","fr","fi","ranska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("208","fr","ga","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("209","fr","he","צרפתית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("210","fr","hi","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("211","fr","hr","Francuzi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("212","fr","hu","francia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("213","fr","hy","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("214","fr","id","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("215","fr","is","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("216","fr","it","Francese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("217","fr","ja","フランス語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("218","fr","ko","불어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("219","fr","ku","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("220","fr","la","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("221","fr","lv","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("222","fr","lt","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("223","fr","mk","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("224","fr","mt","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("225","fr","mn","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("226","fr","ne","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("227","fr","nl","Frans");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("228","fr","nb","Fransk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("229","fr","pa","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("230","fr","pl","francuski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("231","fr","pt-pt","Francês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("232","fr","pt-br","Francês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("233","fr","qu","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("234","fr","ro","Franceză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("235","fr","ru","Французский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("236","fr","sl","Francoščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("237","fr","so","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("238","fr","sq","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("239","fr","sr","француски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("240","fr","sv","Franska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("241","fr","ta","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("242","fr","th","ฝรั่งเศส");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("243","fr","tr","Fransızca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("244","fr","uk","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("245","fr","ur","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("246","fr","uz","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("247","fr","vi","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("248","fr","yi","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("249","fr","zh-hans","法语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("250","fr","zu","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("251","fr","zh-hant","法語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("252","fr","ms","French");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("253","ar","en","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("254","ar","es","Árabe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("255","ar","de","Arabisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("256","ar","fr","Arabe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("257","ar","ar","العربية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("258","ar","bs","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("259","ar","bg","Арабски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("260","ar","ca","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("261","ar","cs","Arabština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("262","ar","sk","Arabčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("263","ar","cy","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("264","ar","da","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("265","ar","el","Αραβικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("266","ar","eo","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("267","ar","et","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("268","ar","eu","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("269","ar","fa","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("270","ar","fi","arabia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("271","ar","ga","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("272","ar","he","ערבית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("273","ar","hi","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("274","ar","hr","Arapski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("275","ar","hu","arab");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("276","ar","hy","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("277","ar","id","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("278","ar","is","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("279","ar","it","Arabo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("280","ar","ja","アラビア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("281","ar","ko","아랍어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("282","ar","ku","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("283","ar","la","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("284","ar","lv","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("285","ar","lt","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("286","ar","mk","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("287","ar","mt","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("288","ar","mn","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("289","ar","ne","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("290","ar","nl","Arabisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("291","ar","nb","Arabisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("292","ar","pa","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("293","ar","pl","arabski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("294","ar","pt-pt","Árabe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("295","ar","pt-br","Árabe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("296","ar","qu","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("297","ar","ro","Arabică");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("298","ar","ru","Арабский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("299","ar","sl","Arabščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("300","ar","so","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("301","ar","sq","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("302","ar","sr","арапски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("303","ar","sv","Arabiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("304","ar","ta","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("305","ar","th","อารบิก");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("306","ar","tr","Arapça");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("307","ar","uk","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("308","ar","ur","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("309","ar","uz","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("310","ar","vi","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("311","ar","yi","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("312","ar","zh-hans","阿拉伯语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("313","ar","zu","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("314","ar","zh-hant","阿拉伯語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("315","ar","ms","Arabic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("316","bs","en","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("317","bs","es","Bosnio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("318","bs","de","Bosnisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("319","bs","fr","Bosnien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("320","bs","ar","البوسنية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("321","bs","bs","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("322","bs","bg","Босненски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("323","bs","ca","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("324","bs","cs","Bosenština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("325","bs","sk","Bosniačtina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("326","bs","cy","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("327","bs","da","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("328","bs","el","Βοσνιακα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("329","bs","eo","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("330","bs","et","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("331","bs","eu","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("332","bs","fa","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("333","bs","fi","bosnia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("334","bs","ga","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("335","bs","he","בוסנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("336","bs","hi","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("337","bs","hr","Bosanski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("338","bs","hu","bosnyák");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("339","bs","hy","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("340","bs","id","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("341","bs","is","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("342","bs","it","Bosniaco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("343","bs","ja","ボスニア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("344","bs","ko","보즈니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("345","bs","ku","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("346","bs","la","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("347","bs","lv","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("348","bs","lt","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("349","bs","mk","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("350","bs","mt","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("351","bs","mn","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("352","bs","ne","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("353","bs","nl","Bosnisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("354","bs","nb","Bosnisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("355","bs","pa","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("356","bs","pl","bośniacki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("357","bs","pt-pt","Bósnio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("358","bs","pt-br","Bósnio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("359","bs","qu","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("360","bs","ro","Bosniacă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("361","bs","ru","Боснийский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("362","bs","sl","Bosanski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("363","bs","so","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("364","bs","sq","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("365","bs","sr","босански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("366","bs","sv","Bosniska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("367","bs","ta","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("368","bs","th","บอสเนียน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("369","bs","tr","Boşnakça");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("370","bs","uk","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("371","bs","ur","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("372","bs","uz","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("373","bs","vi","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("374","bs","yi","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("375","bs","zh-hans","波斯尼亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("376","bs","zu","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("377","bs","zh-hant","波士尼亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("378","bs","ms","Bosnian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("379","bg","en","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("380","bg","es","Búlgaro");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("381","bg","de","Bulgarisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("382","bg","fr","Bulgare");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("383","bg","ar","البلغارية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("384","bg","bs","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("385","bg","bg","Български");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("386","bg","ca","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("387","bg","cs","Bulharština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("388","bg","sk","Bulharčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("389","bg","cy","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("390","bg","da","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("391","bg","el","Βουλγαρικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("392","bg","eo","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("393","bg","et","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("394","bg","eu","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("395","bg","fa","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("396","bg","fi","bulgaria");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("397","bg","ga","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("398","bg","he","בולגרית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("399","bg","hi","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("400","bg","hr","Bugarski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("401","bg","hu","bolgár");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("402","bg","hy","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("403","bg","id","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("404","bg","is","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("405","bg","it","Bulgaro");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("406","bg","ja","ブルガリア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("407","bg","ko","불가리아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("408","bg","ku","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("409","bg","la","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("410","bg","lv","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("411","bg","lt","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("412","bg","mk","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("413","bg","mt","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("414","bg","mn","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("415","bg","ne","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("416","bg","nl","Bulgaars");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("417","bg","nb","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("418","bg","pa","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("419","bg","pl","bułgarski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("420","bg","pt-pt","Búlgaro");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("421","bg","pt-br","Búlgaro");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("422","bg","qu","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("423","bg","ro","Bulgară");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("424","bg","ru","Болгарский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("425","bg","sl","Bolgarščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("426","bg","so","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("427","bg","sq","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("428","bg","sr","бугарски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("429","bg","sv","Bulgariska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("430","bg","ta","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("431","bg","th","บัลแกเรียน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("432","bg","tr","Bulgarca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("433","bg","uk","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("434","bg","ur","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("435","bg","uz","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("436","bg","vi","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("437","bg","yi","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("438","bg","zh-hans","保加利亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("439","bg","zu","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("440","bg","zh-hant","保加利亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("441","bg","ms","Bulgarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("442","ca","en","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("443","ca","es","Catalán");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("444","ca","de","Katalanisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("445","ca","fr","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("446","ca","ar","الكاتالوينية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("447","ca","bs","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("448","ca","bg","Каталонски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("449","ca","ca","Català");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("450","ca","cs","Katalánština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("451","ca","sk","Katalánčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("452","ca","cy","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("453","ca","da","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("454","ca","el","Καταλανικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("455","ca","eo","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("456","ca","et","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("457","ca","eu","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("458","ca","fa","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("459","ca","fi","katalaani");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("460","ca","ga","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("461","ca","he","קטלאנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("462","ca","hi","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("463","ca","hr","Katalonski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("464","ca","hu","katalán");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("465","ca","hy","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("466","ca","id","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("467","ca","is","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("468","ca","it","Catalano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("469","ca","ja","カタルーニャ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("470","ca","ko","카탈로니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("471","ca","ku","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("472","ca","la","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("473","ca","lv","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("474","ca","lt","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("475","ca","mk","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("476","ca","mt","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("477","ca","mn","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("478","ca","ne","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("479","ca","nl","Catalaans");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("480","ca","nb","catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("481","ca","pa","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("482","ca","pl","kataloński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("483","ca","pt-pt","Catalão");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("484","ca","pt-br","Catalão");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("485","ca","qu","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("486","ca","ro","Catalană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("487","ca","ru","Каталанский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("488","ca","sl","Katalonščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("489","ca","so","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("490","ca","sq","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("491","ca","sr","каталонски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("492","ca","sv","Katalanska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("493","ca","ta","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("494","ca","th","คะตะลาน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("495","ca","tr","Katalan dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("496","ca","uk","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("497","ca","ur","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("498","ca","uz","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("499","ca","vi","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("500","ca","yi","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("501","ca","zh-hans","加泰罗尼亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("502","ca","zu","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("503","ca","zh-hant","加泰羅尼亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("504","ca","ms","Catalan");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("505","cs","en","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("506","cs","es","Checo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("507","cs","de","Tschechisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("508","cs","fr","Tchèque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("509","cs","ar","التشيكية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("510","cs","bs","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("511","cs","bg","Чешки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("512","cs","ca","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("513","cs","cs","Čeština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("514","cs","sk","Čeština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("515","cs","cy","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("516","cs","da","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("517","cs","el","Τσεχικη");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("518","cs","eo","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("519","cs","et","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("520","cs","eu","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("521","cs","fa","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("522","cs","fi","tsekki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("523","cs","ga","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("524","cs","he","צ\'כית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("525","cs","hi","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("526","cs","hr","češki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("527","cs","hu","cseh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("528","cs","hy","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("529","cs","id","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("530","cs","is","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("531","cs","it","Ceco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("532","cs","ja","チェコ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("533","cs","ko","체코슬로바키아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("534","cs","ku","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("535","cs","la","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("536","cs","lv","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("537","cs","lt","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("538","cs","mk","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("539","cs","mt","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("540","cs","mn","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("541","cs","ne","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("542","cs","nl","Tsjechisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("543","cs","nb","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("544","cs","pa","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("545","cs","pl","czeski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("546","cs","pt-pt","Tcheco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("547","cs","pt-br","Tcheco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("548","cs","qu","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("549","cs","ro","Cehă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("550","cs","ru","Чешский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("551","cs","sl","Češčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("552","cs","so","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("553","cs","sq","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("554","cs","sr","чешки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("555","cs","sv","Tjeckiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("556","cs","ta","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("557","cs","th","เช็ก");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("558","cs","tr","Çekçe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("559","cs","uk","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("560","cs","ur","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("561","cs","uz","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("562","cs","vi","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("563","cs","yi","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("564","cs","zh-hans","捷克语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("565","cs","zu","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("566","cs","zh-hant","捷克語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("567","cs","ms","Czech");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("568","sk","en","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("569","sk","es","Eslavo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("570","sk","de","Slowakisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("571","sk","fr","Slave");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("572","sk","ar","السلافية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("573","sk","bs","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("574","sk","bg","Словашки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("575","sk","ca","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("576","sk","cs","Slovenština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("577","sk","sk","Slovenčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("578","sk","cy","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("579","sk","da","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("580","sk","el","Σλαβικη");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("581","sk","eo","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("582","sk","et","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("583","sk","eu","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("584","sk","fa","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("585","sk","fi","slaavi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("586","sk","ga","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("587","sk","he","סלאבית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("588","sk","hi","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("589","sk","hr","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("590","sk","hu","szláv");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("591","sk","hy","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("592","sk","id","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("593","sk","is","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("594","sk","it","Slavo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("595","sk","ja","スラヴ語派");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("596","sk","ko","슬라브어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("597","sk","ku","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("598","sk","la","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("599","sk","lv","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("600","sk","lt","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("601","sk","mk","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("602","sk","mt","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("603","sk","mn","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("604","sk","ne","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("605","sk","nl","Slavisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("606","sk","nb","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("607","sk","pa","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("608","sk","pl","słowacki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("609","sk","pt-pt","Eslavo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("610","sk","pt-br","Eslavo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("611","sk","qu","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("612","sk","ro","Slavă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("613","sk","ru","Славянский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("614","sk","sl","Slovaščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("615","sk","so","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("616","sk","sq","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("617","sk","sr","словачки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("618","sk","sv","Slavisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("619","sk","ta","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("620","sk","th","สลาวิก");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("621","sk","tr","Slav dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("622","sk","uk","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("623","sk","ur","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("624","sk","uz","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("625","sk","vi","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("626","sk","yi","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("627","sk","zh-hans","斯拉夫语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("628","sk","zu","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("629","sk","zh-hant","斯拉夫語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("630","sk","ms","Slovak");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("631","cy","en","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("632","cy","es","Galés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("633","cy","de","Walisisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("634","cy","fr","Gallois");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("635","cy","ar","الولزية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("636","cy","bs","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("637","cy","bg","Уелски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("638","cy","ca","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("639","cy","cs","Velšský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("640","cy","sk","Welština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("641","cy","cy","Cymraeg");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("642","cy","da","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("643","cy","el","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("644","cy","eo","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("645","cy","et","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("646","cy","eu","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("647","cy","fa","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("648","cy","fi","kymri");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("649","cy","ga","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("650","cy","he","וולשית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("651","cy","hi","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("652","cy","hr","Velški");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("653","cy","hu","vels");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("654","cy","hy","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("655","cy","id","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("656","cy","is","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("657","cy","it","Gallese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("658","cy","ja","ウェールズ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("659","cy","ko","웨일즈어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("660","cy","ku","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("661","cy","la","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("662","cy","lv","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("663","cy","lt","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("664","cy","mk","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("665","cy","mt","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("666","cy","mn","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("667","cy","ne","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("668","cy","nl","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("669","cy","nb","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("670","cy","pa","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("671","cy","pl","walijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("672","cy","pt-pt","Galês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("673","cy","pt-br","Galês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("674","cy","qu","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("675","cy","ro","Galeză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("676","cy","ru","Валлийский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("677","cy","sl","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("678","cy","so","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("679","cy","sq","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("680","cy","sr","велшки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("681","cy","sv","Walesiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("682","cy","ta","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("683","cy","th","เวลช์");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("684","cy","tr","Galce");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("685","cy","uk","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("686","cy","ur","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("687","cy","uz","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("688","cy","vi","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("689","cy","yi","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("690","cy","zh-hans","威尔士语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("691","cy","zu","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("692","cy","zh-hant","威爾士語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("693","cy","ms","Welsh");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("694","da","en","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("695","da","es","Danés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("696","da","de","Dänisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("697","da","fr","Danois");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("698","da","ar","الدانماركية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("699","da","bs","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("700","da","bg","Датски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("701","da","ca","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("702","da","cs","Dánský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("703","da","sk","Dánčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("704","da","cy","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("705","da","da","Dansk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("706","da","el","Δανεζικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("707","da","eo","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("708","da","et","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("709","da","eu","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("710","da","fa","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("711","da","fi","tanska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("712","da","ga","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("713","da","he","דנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("714","da","hi","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("715","da","hr","Danski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("716","da","hu","dán");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("717","da","hy","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("718","da","id","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("719","da","is","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("720","da","it","Danese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("721","da","ja","デンマーク語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("722","da","ko","덴마크어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("723","da","ku","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("724","da","la","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("725","da","lv","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("726","da","lt","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("727","da","mk","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("728","da","mt","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("729","da","mn","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("730","da","ne","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("731","da","nl","Deens");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("732","da","nb","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("733","da","pa","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("734","da","pl","duński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("735","da","pt-pt","Dinamarquês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("736","da","pt-br","Dinamarquês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("737","da","qu","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("738","da","ro","Daneză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("739","da","ru","Датский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("740","da","sl","Danščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("741","da","so","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("742","da","sq","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("743","da","sr","дански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("744","da","sv","Danska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("745","da","ta","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("746","da","th","เดนมาร์ก");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("747","da","tr","Danca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("748","da","uk","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("749","da","ur","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("750","da","uz","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("751","da","vi","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("752","da","yi","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("753","da","zh-hans","丹麦语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("754","da","zu","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("755","da","zh-hant","丹麥語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("756","da","ms","Danish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("757","el","en","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("758","el","es","Griego");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("759","el","de","Griechisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("760","el","fr","Grec moderne");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("761","el","ar","اليونانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("762","el","bs","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("763","el","bg","Гръцки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("764","el","ca","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("765","el","cs","Řečtina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("766","el","sk","Gréčtina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("767","el","cy","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("768","el","da","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("769","el","el","Ελληνικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("770","el","eo","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("771","el","et","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("772","el","eu","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("773","el","fa","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("774","el","fi","kreikka");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("775","el","ga","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("776","el","he","יוונית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("777","el","hi","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("778","el","hr","Grčki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("779","el","hu","görög");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("780","el","hy","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("781","el","id","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("782","el","is","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("783","el","it","Greco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("784","el","ja","ギリシア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("785","el","ko","그리스어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("786","el","ku","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("787","el","la","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("788","el","lv","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("789","el","lt","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("790","el","mk","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("791","el","mt","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("792","el","mn","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("793","el","ne","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("794","el","nl","Grieks");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("795","el","nb","Gresk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("796","el","pa","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("797","el","pl","grecki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("798","el","pt-pt","Grego");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("799","el","pt-br","Grego");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("800","el","qu","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("801","el","ro","Greacă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("802","el","ru","Греческий");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("803","el","sl","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("804","el","so","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("805","el","sq","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("806","el","sr","грчки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("807","el","sv","Grekiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("808","el","ta","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("809","el","th","กรีก");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("810","el","tr","Yunanca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("811","el","uk","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("812","el","ur","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("813","el","uz","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("814","el","vi","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("815","el","yi","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("816","el","zh-hans","希腊语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("817","el","zu","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("818","el","zh-hant","希臘語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("819","el","ms","Greek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("820","eo","en","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("821","eo","es","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("822","eo","de","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("823","eo","fr","Espéranto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("824","eo","ar","الاسبرانتو");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("825","eo","bs","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("826","eo","bg","Есперанто");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("827","eo","ca","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("828","eo","cs","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("829","eo","sk","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("830","eo","cy","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("831","eo","da","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("832","eo","el","Εσπεραντο");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("833","eo","eo","Esperanta");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("834","eo","et","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("835","eo","eu","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("836","eo","fa","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("837","eo","fi","esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("838","eo","ga","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("839","eo","he","אספרנטו");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("840","eo","hi","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("841","eo","hr","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("842","eo","hu","eszperantó");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("843","eo","hy","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("844","eo","id","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("845","eo","is","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("846","eo","it","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("847","eo","ja","エスペラント語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("848","eo","ko","에스페란토어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("849","eo","ku","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("850","eo","la","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("851","eo","lv","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("852","eo","lt","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("853","eo","mk","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("854","eo","mt","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("855","eo","mn","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("856","eo","ne","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("857","eo","nl","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("858","eo","nb","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("859","eo","pa","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("860","eo","pl","esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("861","eo","pt-pt","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("862","eo","pt-br","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("863","eo","qu","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("864","eo","ro","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("865","eo","ru","Эсперанто");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("866","eo","sl","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("867","eo","so","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("868","eo","sq","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("869","eo","sr","есперанто");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("870","eo","sv","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("871","eo","ta","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("872","eo","th","เอสเปอรันโต");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("873","eo","tr","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("874","eo","uk","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("875","eo","ur","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("876","eo","uz","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("877","eo","vi","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("878","eo","yi","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("879","eo","zh-hans","世界语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("880","eo","zu","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("881","eo","zh-hant","世界語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("882","eo","ms","Esperanto");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("883","et","en","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("884","et","es","Estonio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("885","et","de","Estnisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("886","et","fr","Estonien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("887","et","ar","الأستونية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("888","et","bs","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("889","et","bg","Естонски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("890","et","ca","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("891","et","cs","Estonština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("892","et","sk","Estónčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("893","et","cy","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("894","et","da","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("895","et","el","Εσθονικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("896","et","eo","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("897","et","et","Eesti");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("898","et","eu","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("899","et","fa","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("900","et","fi","eesti");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("901","et","ga","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("902","et","he","אסטונית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("903","et","hi","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("904","et","hr","Estonski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("905","et","hu","észt");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("906","et","hy","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("907","et","id","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("908","et","is","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("909","et","it","Estone");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("910","et","ja","エストニア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("911","et","ko","에스토니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("912","et","ku","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("913","et","la","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("914","et","lv","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("915","et","lt","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("916","et","mk","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("917","et","mt","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("918","et","mn","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("919","et","ne","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("920","et","nl","Ests");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("921","et","nb","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("922","et","pa","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("923","et","pl","estoński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("924","et","pt-pt","Estoniano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("925","et","pt-br","Estoniano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("926","et","qu","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("927","et","ro","Estoniană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("928","et","ru","Эстонский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("929","et","sl","Estonščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("930","et","so","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("931","et","sq","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("932","et","sr","естонски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("933","et","sv","Estniska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("934","et","ta","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("935","et","th","เอสโตเนียน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("936","et","tr","Estonya dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("937","et","uk","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("938","et","ur","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("939","et","uz","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("940","et","vi","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("941","et","yi","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("942","et","zh-hans","爱沙尼亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("943","et","zu","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("944","et","zh-hant","愛沙尼亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("945","et","ms","Estonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("946","eu","en","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("947","eu","es","Euskera");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("948","eu","de","Baskisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("949","eu","fr","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("950","eu","ar","لغة الباسك");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("951","eu","bs","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("952","eu","bg","Баски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("953","eu","ca","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("954","eu","cs","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("955","eu","sk","Baskičtina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("956","eu","cy","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("957","eu","da","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("958","eu","el","Βασκικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("959","eu","eo","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("960","eu","et","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("961","eu","eu","Euskara");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("962","eu","fa","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("963","eu","fi","baski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("964","eu","ga","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("965","eu","he","בסקית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("966","eu","hi","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("967","eu","hr","Baskijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("968","eu","hu","baszk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("969","eu","hy","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("970","eu","id","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("971","eu","is","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("972","eu","it","Basco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("973","eu","ja","バスク語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("974","eu","ko","바스크어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("975","eu","ku","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("976","eu","la","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("977","eu","lv","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("978","eu","lt","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("979","eu","mk","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("980","eu","mt","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("981","eu","mn","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("982","eu","ne","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("983","eu","nl","Baskisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("984","eu","nb","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("985","eu","pa","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("986","eu","pl","baskijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("987","eu","pt-pt","Basco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("988","eu","pt-br","Basco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("989","eu","qu","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("990","eu","ro","Bască");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("991","eu","ru","Баскский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("992","eu","sl","Baskovščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("993","eu","so","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("994","eu","sq","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("995","eu","sr","баскијски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("996","eu","sv","Baskiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("997","eu","ta","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("998","eu","th","บาสค์");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("999","eu","tr","Bask dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1000","eu","uk","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1001","eu","ur","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1002","eu","uz","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1003","eu","vi","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1004","eu","yi","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1005","eu","zh-hans","巴斯克语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1006","eu","zu","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1007","eu","zh-hant","巴斯克語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1008","eu","ms","Basque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1009","fa","en","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1010","fa","es","Persa");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1011","fa","de","Persisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1012","fa","fr","Perse");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1013","fa","ar","الفارسية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1014","fa","bs","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1015","fa","bg","Персийски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1016","fa","ca","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1017","fa","cs","Perský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1018","fa","sk","Perzština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1019","fa","cy","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1020","fa","da","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1021","fa","el","Περσικος");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1022","fa","eo","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1023","fa","et","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1024","fa","eu","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1025","fa","fa","فارسی");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1026","fa","fi","persia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1027","fa","ga","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1028","fa","he","פרסית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1029","fa","hi","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1030","fa","hr","Perzijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1031","fa","hu","perzsa");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1032","fa","hy","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1033","fa","id","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1034","fa","is","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1035","fa","it","Persiano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1036","fa","ja","ペルシア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1037","fa","ko","페르시아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1038","fa","ku","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1039","fa","la","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1040","fa","lv","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1041","fa","lt","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1042","fa","mk","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1043","fa","mt","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1044","fa","mn","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1045","fa","ne","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1046","fa","nl","Perzisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1047","fa","nb","Persisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1048","fa","pa","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1049","fa","pl","perski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1050","fa","pt-pt","Persa");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1051","fa","pt-br","Persa");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1052","fa","qu","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1053","fa","ro","Persană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1054","fa","ru","Персидский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1055","fa","sl","Perzijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1056","fa","so","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1057","fa","sq","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1058","fa","sr","персијски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1059","fa","sv","Persiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1060","fa","ta","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1061","fa","th","เปอร์เซียน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1062","fa","tr","Farsça");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1063","fa","uk","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1064","fa","ur","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1065","fa","uz","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1066","fa","vi","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1067","fa","yi","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1068","fa","zh-hans","波斯语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1069","fa","zu","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1070","fa","zh-hant","波斯語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1071","fa","ms","Persian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1072","fi","en","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1073","fi","es","Finlandés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1074","fi","de","Finnisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1075","fi","fr","Finnois");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1076","fi","ar","الفنلندية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1077","fi","bs","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1078","fi","bg","Фински");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1079","fi","ca","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1080","fi","cs","Finský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1081","fi","sk","Fínština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1082","fi","cy","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1083","fi","da","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1084","fi","el","Φινλανδικη");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1085","fi","eo","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1086","fi","et","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1087","fi","eu","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1088","fi","fa","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1089","fi","fi","Suomi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1090","fi","ga","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1091","fi","he","פינית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1092","fi","hi","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1093","fi","hr","Finski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1094","fi","hu","finn");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1095","fi","hy","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1096","fi","id","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1097","fi","is","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1098","fi","it","Finlandese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1099","fi","ja","フィンランド語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1100","fi","ko","핀란드어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1101","fi","ku","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1102","fi","la","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1103","fi","lv","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1104","fi","lt","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1105","fi","mk","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1106","fi","mt","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1107","fi","mn","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1108","fi","ne","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1109","fi","nl","Fins");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1110","fi","nb","Finsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1111","fi","pa","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1112","fi","pl","fiński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1113","fi","pt-pt","Finlandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1114","fi","pt-br","Finlandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1115","fi","qu","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1116","fi","ro","Finlandeză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1117","fi","ru","Финский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1118","fi","sl","Finski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1119","fi","so","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1120","fi","sq","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1121","fi","sr","фински");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1122","fi","sv","Finska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1123","fi","ta","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1124","fi","th","ฟินนิช");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1125","fi","tr","Fince");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1126","fi","uk","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1127","fi","ur","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1128","fi","uz","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1129","fi","vi","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1130","fi","yi","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1131","fi","zh-hans","芬兰语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1132","fi","zu","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1133","fi","zh-hant","芬蘭語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1134","fi","ms","Finnish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1135","ga","en","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1136","ga","es","Irlandés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1137","ga","de","Irisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1138","ga","fr","Irlandais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1139","ga","ar","الأيرلندية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1140","ga","bs","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1141","ga","bg","Ирландски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1142","ga","ca","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1143","ga","cs","Irský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1144","ga","sk","Írština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1145","ga","cy","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1146","ga","da","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1147","ga","el","Ιρλανδικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1148","ga","eo","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1149","ga","et","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1150","ga","eu","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1151","ga","fa","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1152","ga","fi","iiri");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1153","ga","ga","Gaeilge");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1154","ga","he","אירית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1155","ga","hi","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1156","ga","hr","Irci");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1157","ga","hu","ír");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1158","ga","hy","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1159","ga","id","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1160","ga","is","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1161","ga","it","Irlandese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1162","ga","ja","アイルランド語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1163","ga","ko","아일랜드어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1164","ga","ku","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1165","ga","la","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1166","ga","lv","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1167","ga","lt","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1168","ga","mk","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1169","ga","mt","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1170","ga","mn","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1171","ga","ne","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1172","ga","nl","Iers");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1173","ga","nb","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1174","ga","pa","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1175","ga","pl","irlandzki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1176","ga","pt-pt","Irlandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1177","ga","pt-br","Irlandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1178","ga","qu","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1179","ga","ro","Irlandeză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1180","ga","ru","Ирландский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1181","ga","sl","Irski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1182","ga","so","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1183","ga","sq","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1184","ga","sr","ирски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1185","ga","sv","Irländska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1186","ga","ta","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1187","ga","th","ไอริช");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1188","ga","tr","İrlanda dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1189","ga","uk","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1190","ga","ur","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1191","ga","uz","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1192","ga","vi","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1193","ga","yi","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1194","ga","zh-hans","爱尔兰语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1195","ga","zu","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1196","ga","zh-hant","愛爾蘭語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1197","ga","ms","Irish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1198","he","en","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1199","he","es","Hebreo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1200","he","de","Hebräisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1201","he","fr","Hébreu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1202","he","ar","العبرية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1203","he","bs","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1204","he","bg","Иврит");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1205","he","ca","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1206","he","cs","Hebrejština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1207","he","sk","Hebrejčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1208","he","cy","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1209","he","da","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1210","he","el","Εβραικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1211","he","eo","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1212","he","et","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1213","he","eu","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1214","he","fa","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1215","he","fi","heprea");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1216","he","ga","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1217","he","he","עברית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1218","he","hi","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1219","he","hr","Hebrejski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1220","he","hu","héber");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1221","he","hy","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1222","he","id","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1223","he","is","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1224","he","it","Ebraico");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1225","he","ja","ヘブライ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1226","he","ko","히브리어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1227","he","ku","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1228","he","la","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1229","he","lv","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1230","he","lt","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1231","he","mk","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1232","he","mt","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1233","he","mn","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1234","he","ne","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1235","he","nl","Hebreeuws");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1236","he","nb","Hebraisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1237","he","pa","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1238","he","pl","hebrajski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1239","he","pt-pt","Hebraico");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1240","he","pt-br","Hebraico");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1241","he","qu","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1242","he","ro","Ebraică");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1243","he","ru","Иврит");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1244","he","sl","Hebrejščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1245","he","so","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1246","he","sq","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1247","he","sr","Хебрејски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1248","he","sv","Hebreiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1249","he","ta","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1250","he","th","ฮิบรู");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1251","he","tr","İbranice");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1252","he","uk","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1253","he","ur","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1254","he","uz","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1255","he","vi","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1256","he","yi","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1257","he","zh-hans","希伯来语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1258","he","zu","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1259","he","zh-hant","希伯來語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1260","he","ms","Hebrew");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1261","hi","en","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1262","hi","es","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1263","hi","de","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1264","hi","fr","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1265","hi","ar","الهندية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1266","hi","bs","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1267","hi","bg","Хинди");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1268","hi","ca","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1269","hi","cs","Hindština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1270","hi","sk","Hindčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1271","hi","cy","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1272","hi","da","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1273","hi","el","Ινδικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1274","hi","eo","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1275","hi","et","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1276","hi","eu","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1277","hi","fa","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1278","hi","fi","hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1279","hi","ga","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1280","hi","he","הודית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1281","hi","hi","हिन्दी");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1282","hi","hr","Hindski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1283","hi","hu","hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1284","hi","hy","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1285","hi","id","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1286","hi","is","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1287","hi","it","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1288","hi","ja","ヒンディー語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1289","hi","ko","힌두어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1290","hi","ku","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1291","hi","la","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1292","hi","lv","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1293","hi","lt","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1294","hi","mk","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1295","hi","mt","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1296","hi","mn","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1297","hi","ne","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1298","hi","nl","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1299","hi","nb","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1300","hi","pa","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1301","hi","pl","hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1302","hi","pt-pt","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1303","hi","pt-br","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1304","hi","qu","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1305","hi","ro","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1306","hi","ru","Хинди");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1307","hi","sl","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1308","hi","so","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1309","hi","sq","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1310","hi","sr","хинди");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1311","hi","sv","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1312","hi","ta","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1313","hi","th","ฮินดิ");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1314","hi","tr","Hintçe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1315","hi","uk","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1316","hi","ur","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1317","hi","uz","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1318","hi","vi","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1319","hi","yi","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1320","hi","zh-hans","印地语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1321","hi","zu","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1322","hi","zh-hant","印地語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1323","hi","ms","Hindi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1324","hr","en","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1325","hr","es","Croata");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1326","hr","de","Kroatisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1327","hr","fr","Croate");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1328","hr","ar","الكرواتية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1329","hr","bs","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1330","hr","bg","Хърватски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1331","hr","ca","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1332","hr","cs","Chorvatský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1333","hr","sk","Chorvátština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1334","hr","cy","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1335","hr","da","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1336","hr","el","Κροατικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1337","hr","eo","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1338","hr","et","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1339","hr","eu","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1340","hr","fa","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1341","hr","fi","kroatia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1342","hr","ga","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1343","hr","he","קרוטאית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1344","hr","hi","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1345","hr","hr","Hrvatski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1346","hr","hu","horvát");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1347","hr","hy","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1348","hr","id","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1349","hr","is","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1350","hr","it","Croato");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1351","hr","ja","クロアチア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1352","hr","ko","크로아시아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1353","hr","ku","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1354","hr","la","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1355","hr","lv","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1356","hr","lt","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1357","hr","mk","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1358","hr","mt","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1359","hr","mn","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1360","hr","ne","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1361","hr","nl","Kroatisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1362","hr","nb","Kroatisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1363","hr","pa","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1364","hr","pl","chorwacki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1365","hr","pt-pt","Croata");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1366","hr","pt-br","Croata");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1367","hr","qu","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1368","hr","ro","Croată");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1369","hr","ru","Хорватский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1370","hr","sl","Hrvaški");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1371","hr","so","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1372","hr","sq","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1373","hr","sr","хрватски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1374","hr","sv","Kroatiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1375","hr","ta","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1376","hr","th","โครเอเชีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1377","hr","tr","Hırvatça");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1378","hr","uk","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1379","hr","ur","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1380","hr","uz","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1381","hr","vi","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1382","hr","yi","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1383","hr","zh-hans","克罗地亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1384","hr","zu","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1385","hr","zh-hant","克羅地亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1386","hr","ms","Croatian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1387","hu","en","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1388","hu","es","Húngaro");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1389","hu","de","Ungarisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1390","hu","fr","Hongrois");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1391","hu","ar","الهنغارية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1392","hu","bs","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1393","hu","bg","Унгарски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1394","hu","ca","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1395","hu","cs","Maďarština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1396","hu","sk","Maďarčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1397","hu","cy","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1398","hu","da","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1399","hu","el","Ουγγρικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1400","hu","eo","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1401","hu","et","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1402","hu","eu","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1403","hu","fa","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1404","hu","fi","unkari");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1405","hu","ga","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1406","hu","he","הונגרית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1407","hu","hi","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1408","hu","hr","Mađarski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1409","hu","hu","Magyar");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1410","hu","hy","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1411","hu","id","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1412","hu","is","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1413","hu","it","Ungherese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1414","hu","ja","ハンガリー語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1415","hu","ko","헝가리어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1416","hu","ku","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1417","hu","la","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1418","hu","lv","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1419","hu","lt","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1420","hu","mk","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1421","hu","mt","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1422","hu","mn","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1423","hu","ne","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1424","hu","nl","Hongaars");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1425","hu","nb","Ungarsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1426","hu","pa","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1427","hu","pl","węgierski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1428","hu","pt-pt","Húngaro");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1429","hu","pt-br","Húngaro");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1430","hu","qu","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1431","hu","ro","Ungară");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1432","hu","ru","Венгерский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1433","hu","sl","Madžarski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1434","hu","so","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1435","hu","sq","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1436","hu","sr","мађарски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1437","hu","sv","Ungerska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1438","hu","ta","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1439","hu","th","ฮังการี");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1440","hu","tr","Macarca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1441","hu","uk","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1442","hu","ur","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1443","hu","uz","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1444","hu","vi","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1445","hu","yi","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1446","hu","zh-hans","匈牙利语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1447","hu","zu","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1448","hu","zh-hant","匈牙利語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1449","hu","ms","Hungarian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1450","hy","en","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1451","hy","es","Armenio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1452","hy","de","Armenisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1453","hy","fr","Arménien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1454","hy","ar","الأرمينية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1455","hy","bs","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1456","hy","bg","Арменски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1457","hy","ca","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1458","hy","cs","Arménský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1459","hy","sk","Arménčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1460","hy","cy","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1461","hy","da","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1462","hy","el","Αρμενικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1463","hy","eo","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1464","hy","et","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1465","hy","eu","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1466","hy","fa","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1467","hy","fi","armenia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1468","hy","ga","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1469","hy","he","ארמנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1470","hy","hi","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1471","hy","hr","Armenac");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1472","hy","hu","örmény");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1473","hy","hy","Հայերեն");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1474","hy","id","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1475","hy","is","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1476","hy","it","Armeno");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1477","hy","ja","アルメニア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1478","hy","ko","아르메니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1479","hy","ku","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1480","hy","la","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1481","hy","lv","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1482","hy","lt","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1483","hy","mk","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1484","hy","mt","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1485","hy","mn","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1486","hy","ne","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1487","hy","nl","Armeens");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1488","hy","nb","Armensk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1489","hy","pa","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1490","hy","pl","ormiański");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1491","hy","pt-pt","Arménio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1492","hy","pt-br","Arménio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1493","hy","qu","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1494","hy","ro","Armeană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1495","hy","ru","Армянский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1496","hy","sl","Armenski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1497","hy","so","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1498","hy","sq","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1499","hy","sr","јерменски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1500","hy","sv","Armeniska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1501","hy","ta","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1502","hy","th","อาร์เมเนีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1503","hy","tr","Ermenice");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1504","hy","uk","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1505","hy","ur","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1506","hy","uz","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1507","hy","vi","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1508","hy","yi","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1509","hy","zh-hans","亚美尼亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1510","hy","zu","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1511","hy","zh-hant","亞美尼亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1512","hy","ms","Armenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1513","id","en","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1514","id","es","Indonesio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1515","id","de","Indonesisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1516","id","fr","Indonésien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1517","id","ar","الأندونيسية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1518","id","bs","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1519","id","bg","Индонезийски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1520","id","ca","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1521","id","cs","Indonéský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1522","id","sk","Indonézčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1523","id","cy","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1524","id","da","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1525","id","el","Ινδονησιακα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1526","id","eo","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1527","id","et","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1528","id","eu","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1529","id","fa","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1530","id","fi","indonesia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1531","id","ga","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1532","id","he","אינדונזית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1533","id","hi","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1534","id","hr","Indonezijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1535","id","hu","indonéz");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1536","id","hy","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1537","id","id","Indonesia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1538","id","is","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1539","id","it","Indonesiano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1540","id","ja","インドネシア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1541","id","ko","인도네시아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1542","id","ku","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1543","id","la","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1544","id","lv","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1545","id","lt","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1546","id","mk","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1547","id","mt","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1548","id","mn","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1549","id","ne","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1550","id","nl","Indonesisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1551","id","nb","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1552","id","pa","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1553","id","pl","indonezyjski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1554","id","pt-pt","Indonésio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1555","id","pt-br","Indonésio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1556","id","qu","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1557","id","ro","Indoneziană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1558","id","ru","Индонезийский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1559","id","sl","Indonezijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1560","id","so","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1561","id","sq","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1562","id","sr","индонезијски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1563","id","sv","Indonesiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1564","id","ta","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1565","id","th","อินโดนีเซีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1566","id","tr","Endonezya dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1567","id","uk","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1568","id","ur","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1569","id","uz","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1570","id","vi","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1571","id","yi","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1572","id","zh-hans","印度尼西亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1573","id","zu","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1574","id","zh-hant","印尼語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1575","id","ms","Indonesian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1576","is","en","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1577","is","es","Islandés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1578","is","de","Isländisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1579","is","fr","Islandais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1580","is","ar","الأيسلاندية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1581","is","bs","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1582","is","bg","Исландски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1583","is","ca","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1584","is","cs","Islandský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1585","is","sk","Islančina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1586","is","cy","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1587","is","da","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1588","is","el","Ισλανδικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1589","is","eo","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1590","is","et","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1591","is","eu","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1592","is","fa","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1593","is","fi","islanti");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1594","is","ga","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1595","is","he","איסלנדית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1596","is","hi","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1597","is","hr","Islandski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1598","is","hu","izlandi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1599","is","hy","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1600","is","id","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1601","is","is","Íslenska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1602","is","it","Islandese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1603","is","ja","アイスランド語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1604","is","ko","아이슬랜드어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1605","is","ku","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1606","is","la","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1607","is","lv","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1608","is","lt","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1609","is","mk","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1610","is","mt","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1611","is","mn","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1612","is","ne","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1613","is","nl","Ijslands");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1614","is","nb","Islandsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1615","is","pa","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1616","is","pl","islandzki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1617","is","pt-pt","Islandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1618","is","pt-br","Islandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1619","is","qu","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1620","is","ro","Islandeză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1621","is","ru","Исландский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1622","is","sl","Islandski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1623","is","so","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1624","is","sq","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1625","is","sr","исландски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1626","is","sv","Isländska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1627","is","ta","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1628","is","th","ไอซ์แลนด์");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1629","is","tr","İzlandaca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1630","is","uk","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1631","is","ur","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1632","is","uz","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1633","is","vi","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1634","is","yi","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1635","is","zh-hans","冰岛语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1636","is","zu","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1637","is","zh-hant","冰島語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1638","is","ms","Icelandic");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1639","it","en","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1640","it","es","Italiano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1641","it","de","Italienisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1642","it","fr","Italien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1643","it","ar","الإيطالية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1644","it","bs","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1645","it","bg","Италиански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1646","it","ca","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1647","it","cs","Ital");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1648","it","sk","Taliančina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1649","it","cy","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1650","it","da","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1651","it","el","Ιταλικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1652","it","eo","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1653","it","et","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1654","it","eu","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1655","it","fa","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1656","it","fi","italia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1657","it","ga","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1658","it","he","איטלקית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1659","it","hi","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1660","it","hr","Talijanski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1661","it","hu","olasz");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1662","it","hy","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1663","it","id","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1664","it","is","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1665","it","it","Italiano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1666","it","ja","イタリア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1667","it","ko","이태리어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1668","it","ku","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1669","it","la","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1670","it","lv","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1671","it","lt","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1672","it","mk","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1673","it","mt","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1674","it","mn","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1675","it","ne","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1676","it","nl","Italiaans");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1677","it","nb","Italiensk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1678","it","pa","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1679","it","pl","włoski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1680","it","pt-pt","Italiano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1681","it","pt-br","Italiano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1682","it","qu","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1683","it","ro","Italiană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1684","it","ru","Итальянский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1685","it","sl","Italijanski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1686","it","so","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1687","it","sq","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1688","it","sr","италијански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1689","it","sv","Italienska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1690","it","ta","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1691","it","th","อิตาลี");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1692","it","tr","İtalyanca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1693","it","uk","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1694","it","ur","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1695","it","uz","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1696","it","vi","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1697","it","yi","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1698","it","zh-hans","意大利语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1699","it","zu","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1700","it","zh-hant","義大利語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1701","it","ms","Italian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1702","ja","en","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1703","ja","es","Japonés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1704","ja","de","Japanisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1705","ja","fr","Japonais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1706","ja","ar","اليابانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1707","ja","bs","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1708","ja","bg","Японски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1709","ja","ca","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1710","ja","cs","Japonský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1711","ja","sk","Japonština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1712","ja","cy","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1713","ja","da","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1714","ja","el","Ιαπωνικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1715","ja","eo","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1716","ja","et","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1717","ja","eu","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1718","ja","fa","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1719","ja","fi","japani");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1720","ja","ga","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1721","ja","he","יפנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1722","ja","hi","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1723","ja","hr","Japanski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1724","ja","hu","japán");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1725","ja","hy","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1726","ja","id","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1727","ja","is","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1728","ja","it","Giapponese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1729","ja","ja","日本語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1730","ja","ko","일어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1731","ja","ku","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1732","ja","la","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1733","ja","lv","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1734","ja","lt","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1735","ja","mk","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1736","ja","mt","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1737","ja","mn","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1738","ja","ne","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1739","ja","nl","Japans");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1740","ja","nb","Japansk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1741","ja","pa","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1742","ja","pl","japoński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1743","ja","pt-pt","Japonês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1744","ja","pt-br","Japonês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1745","ja","qu","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1746","ja","ro","Japoneză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1747","ja","ru","Японский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1748","ja","sl","Japonski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1749","ja","so","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1750","ja","sq","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1751","ja","sr","јапански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1752","ja","sv","Japanska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1753","ja","ta","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1754","ja","th","ญี่ปุ่น");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1755","ja","tr","Japonca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1756","ja","uk","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1757","ja","ur","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1758","ja","uz","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1759","ja","vi","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1760","ja","yi","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1761","ja","zh-hans","日语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1762","ja","zu","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1763","ja","zh-hant","日語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1764","ja","ms","Japanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1765","ko","en","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1766","ko","es","Coreano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1767","ko","de","Koreanisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1768","ko","fr","Coréen");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1769","ko","ar","الكورية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1770","ko","bs","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1771","ko","bg","Корейски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1772","ko","ca","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1773","ko","cs","Korejský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1774","ko","sk","Kórejčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1775","ko","cy","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1776","ko","da","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1777","ko","el","Κορεατικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1778","ko","eo","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1779","ko","et","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1780","ko","eu","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1781","ko","fa","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1782","ko","fi","korea");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1783","ko","ga","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1784","ko","he","קוראנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1785","ko","hi","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1786","ko","hr","Korejski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1787","ko","hu","koreai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1788","ko","hy","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1789","ko","id","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1790","ko","is","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1791","ko","it","Coreano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1792","ko","ja","韓国語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1793","ko","ko","한국어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1794","ko","ku","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1795","ko","la","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1796","ko","lv","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1797","ko","lt","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1798","ko","mk","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1799","ko","mt","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1800","ko","mn","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1801","ko","ne","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1802","ko","nl","Koreaans");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1803","ko","nb","Koreanske");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1804","ko","pa","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1805","ko","pl","koreański");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1806","ko","pt-pt","Coreano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1807","ko","pt-br","Coreano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1808","ko","qu","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1809","ko","ro","Coreană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1810","ko","ru","Корейский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1811","ko","sl","Korejski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1812","ko","so","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1813","ko","sq","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1814","ko","sr","корејски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1815","ko","sv","Koreanska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1816","ko","ta","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1817","ko","th","เกาหลี");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1818","ko","tr","Kore dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1819","ko","uk","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1820","ko","ur","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1821","ko","uz","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1822","ko","vi","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1823","ko","yi","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1824","ko","zh-hans","韩语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1825","ko","zu","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1826","ko","zh-hant","韓語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1827","ko","ms","Korean");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1828","ku","en","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1829","ku","es","Kurdo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1830","ku","de","Kurdisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1831","ku","fr","Kurde");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1832","ku","ar","الكردية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1833","ku","bs","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1834","ku","bg","Кюрдски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1835","ku","ca","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1836","ku","cs","Kurdský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1837","ku","sk","Kurdština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1838","ku","cy","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1839","ku","da","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1840","ku","el","Κουρδικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1841","ku","eo","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1842","ku","et","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1843","ku","eu","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1844","ku","fa","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1845","ku","fi","kurdi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1846","ku","ga","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1847","ku","he","כורדית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1848","ku","hi","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1849","ku","hr","Kurdski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1850","ku","hu","kurd");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1851","ku","hy","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1852","ku","id","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1853","ku","is","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1854","ku","it","Curdo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1855","ku","ja","クルド語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1856","ku","ko","쿠르드어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1857","ku","ku","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1858","ku","la","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1859","ku","lv","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1860","ku","lt","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1861","ku","mk","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1862","ku","mt","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1863","ku","mn","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1864","ku","ne","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1865","ku","nl","Koerdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1866","ku","nb","Kurdisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1867","ku","pa","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1868","ku","pl","kurdyjski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1869","ku","pt-pt","Curdo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1870","ku","pt-br","Curdo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1871","ku","qu","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1872","ku","ro","Kurdă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1873","ku","ru","Курдский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1874","ku","sl","Kurdščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1875","ku","so","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1876","ku","sq","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1877","ku","sr","курдски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1878","ku","sv","Kurdiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1879","ku","ta","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1880","ku","th","เคอร์ดิช");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1881","ku","tr","Kürtçe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1882","ku","uk","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1883","ku","ur","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1884","ku","uz","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1885","ku","vi","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1886","ku","yi","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1887","ku","zh-hans","库尔德语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1888","ku","zu","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1889","ku","zh-hant","庫爾德語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1890","ku","ms","Kurdish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1891","la","en","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1892","la","es","Latín");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1893","la","de","Latein");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1894","la","fr","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1895","la","ar","اللاتينية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1896","la","bs","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1897","la","bg","Латински");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1898","la","ca","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1899","la","cs","Latina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1900","la","sk","Latinčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1901","la","cy","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1902","la","da","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1903","la","el","Λατινικη");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1904","la","eo","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1905","la","et","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1906","la","eu","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1907","la","fa","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1908","la","fi","latina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1909","la","ga","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1910","la","he","לטינית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1911","la","hi","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1912","la","hr","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1913","la","hu","latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1914","la","hy","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1915","la","id","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1916","la","is","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1917","la","it","Latino");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1918","la","ja","ラテン語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1919","la","ko","라틴어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1920","la","ku","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1921","la","la","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1922","la","lv","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1923","la","lt","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1924","la","mk","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1925","la","mt","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1926","la","mn","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1927","la","ne","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1928","la","nl","Latijn");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1929","la","nb","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1930","la","pa","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1931","la","pl","łaciński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1932","la","pt-pt","Latim");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1933","la","pt-br","Latim");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1934","la","qu","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1935","la","ro","Latină");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1936","la","ru","Латинский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1937","la","sl","Latinščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1938","la","so","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1939","la","sq","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1940","la","sr","латински");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1941","la","sv","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1942","la","ta","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1943","la","th","ละติน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1944","la","tr","Latince");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1945","la","uk","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1946","la","ur","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1947","la","uz","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1948","la","vi","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1949","la","yi","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1950","la","zh-hans","拉丁语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1951","la","zu","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1952","la","zh-hant","拉丁語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1953","la","ms","Latin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1954","lv","en","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1955","lv","es","Letón");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1956","lv","de","Lettisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1957","lv","fr","Letton");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1958","lv","ar","اللاتفية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1959","lv","bs","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1960","lv","bg","Латвийски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1961","lv","ca","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1962","lv","cs","Lotyština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1963","lv","sk","Lotyština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1964","lv","cy","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1965","lv","da","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1966","lv","el","Λετονικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1967","lv","eo","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1968","lv","et","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1969","lv","eu","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1970","lv","fa","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1971","lv","fi","latvia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1972","lv","ga","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1973","lv","he","לטבית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1974","lv","hi","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1975","lv","hr","Letonski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1976","lv","hu","lett");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1977","lv","hy","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1978","lv","id","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1979","lv","is","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1980","lv","it","Lettone");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1981","lv","ja","ラトビア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1982","lv","ko","라트비아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1983","lv","ku","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1984","lv","la","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1985","lv","lv","Latviešu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1986","lv","lt","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1987","lv","mk","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1988","lv","mt","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1989","lv","mn","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1990","lv","ne","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1991","lv","nl","Lets");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1992","lv","nb","Latvisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1993","lv","pa","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1994","lv","pl","łotewski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1995","lv","pt-pt","Letão");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1996","lv","pt-br","Letão");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1997","lv","qu","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1998","lv","ro","Letoniană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("1999","lv","ru","латышский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2000","lv","sl","Latvijščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2001","lv","so","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2002","lv","sq","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2003","lv","sr","летонски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2004","lv","sv","Lettiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2005","lv","ta","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2006","lv","th","ลัตเวีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2007","lv","tr","Letonca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2008","lv","uk","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2009","lv","ur","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2010","lv","uz","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2011","lv","vi","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2012","lv","yi","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2013","lv","zh-hans","拉脱维亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2014","lv","zu","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2015","lv","zh-hant","拉脫維亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2016","lv","ms","Latvian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2017","lt","en","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2018","lt","es","Lituano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2019","lt","de","Litauisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2020","lt","fr","Lituanien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2021","lt","ar","اللتوانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2022","lt","bs","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2023","lt","bg","Литовски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2024","lt","ca","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2025","lt","cs","litevský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2026","lt","sk","Litovčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2027","lt","cy","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2028","lt","da","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2029","lt","el","Λιθουανικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2030","lt","eo","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2031","lt","et","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2032","lt","eu","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2033","lt","fa","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2034","lt","fi","liettua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2035","lt","ga","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2036","lt","he","ליטאית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2037","lt","hi","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2038","lt","hr","Litvanski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2039","lt","hu","litván");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2040","lt","hy","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2041","lt","id","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2042","lt","is","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2043","lt","it","Lituano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2044","lt","ja","リトアニア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2045","lt","ko","리투아니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2046","lt","ku","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2047","lt","la","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2048","lt","lv","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2049","lt","lt","Lietuvos");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2050","lt","mk","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2051","lt","mt","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2052","lt","mn","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2053","lt","ne","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2054","lt","nl","Litouws");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2055","lt","nb","Litauisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2056","lt","pa","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2057","lt","pl","litewski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2058","lt","pt-pt","Lituano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2059","lt","pt-br","Lituano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2060","lt","qu","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2061","lt","ro","Lituaniană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2062","lt","ru","Литовский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2063","lt","sl","Litovščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2064","lt","so","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2065","lt","sq","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2066","lt","sr","литвански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2067","lt","sv","Litauiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2068","lt","ta","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2069","lt","th","ลิธัวเนีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2070","lt","tr","Litvanyaca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2071","lt","uk","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2072","lt","ur","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2073","lt","uz","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2074","lt","vi","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2075","lt","yi","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2076","lt","zh-hans","立陶宛语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2077","lt","zu","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2078","lt","zh-hant","立陶宛語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2079","lt","ms","Lithuanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2080","mk","en","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2081","mk","es","Macedonio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2082","mk","de","Mazedonisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2083","mk","fr","Macédonien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2084","mk","ar","المقدونية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2085","mk","bs","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2086","mk","bg","Македонски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2087","mk","ca","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2088","mk","cs","Makedonský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2089","mk","sk","Macedónština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2090","mk","cy","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2091","mk","da","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2092","mk","el","Μακεδονικο");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2093","mk","eo","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2094","mk","et","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2095","mk","eu","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2096","mk","fa","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2097","mk","fi","makedonia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2098","mk","ga","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2099","mk","he","מקדונית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2100","mk","hi","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2101","mk","hr","Makedonski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2102","mk","hu","macedón");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2103","mk","hy","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2104","mk","id","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2105","mk","is","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2106","mk","it","Macedone");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2107","mk","ja","マケドニア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2108","mk","ko","마케도니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2109","mk","ku","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2110","mk","la","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2111","mk","lv","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2112","mk","lt","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2113","mk","mk","македонски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2114","mk","mt","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2115","mk","mn","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2116","mk","ne","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2117","mk","nl","Macedonisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2118","mk","nb","Makedonsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2119","mk","pa","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2120","mk","pl","macedoński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2121","mk","pt-pt","Macedônio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2122","mk","pt-br","Macedônio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2123","mk","qu","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2124","mk","ro","Macedoniană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2125","mk","ru","Македонский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2126","mk","sl","Makedonski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2127","mk","so","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2128","mk","sq","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2129","mk","sr","македонски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2130","mk","sv","Makedonska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2131","mk","ta","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2132","mk","th","มาซิโดเนีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2133","mk","tr","Makedonyaca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2134","mk","uk","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2135","mk","ur","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2136","mk","uz","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2137","mk","vi","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2138","mk","yi","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2139","mk","zh-hans","马其顿语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2140","mk","zu","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2141","mk","zh-hant","馬其頓語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2142","mk","ms","Macedonian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2143","mt","en","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2144","mt","es","Maltés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2145","mt","de","Maltesisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2146","mt","fr","Maltais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2147","mt","ar","المالطية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2148","mt","bs","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2149","mt","bg","Малтийски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2150","mt","ca","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2151","mt","cs","Maltština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2152","mt","sk","Maltézština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2153","mt","cy","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2154","mt","da","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2155","mt","el","Μαλτεζικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2156","mt","eo","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2157","mt","et","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2158","mt","eu","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2159","mt","fa","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2160","mt","fi","malta");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2161","mt","ga","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2162","mt","he","מלטזית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2163","mt","hi","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2164","mt","hr","Malteški");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2165","mt","hu","máltai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2166","mt","hy","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2167","mt","id","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2168","mt","is","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2169","mt","it","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2170","mt","ja","マルタ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2171","mt","ko","몰타어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2172","mt","ku","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2173","mt","la","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2174","mt","lv","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2175","mt","lt","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2176","mt","mk","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2177","mt","mt","Malti");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2178","mt","mn","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2179","mt","ne","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2180","mt","nl","Maltees");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2181","mt","nb","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2182","mt","pa","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2183","mt","pl","maltański");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2184","mt","pt-pt","Maltês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2185","mt","pt-br","Maltês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2186","mt","qu","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2187","mt","ro","Malteză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2188","mt","ru","Мальтийский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2189","mt","sl","Malteški");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2190","mt","so","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2191","mt","sq","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2192","mt","sr","малтешки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2193","mt","sv","Maltesiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2194","mt","ta","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2195","mt","th","มอลทีส");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2196","mt","tr","Malta dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2197","mt","uk","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2198","mt","ur","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2199","mt","uz","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2200","mt","vi","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2201","mt","yi","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2202","mt","zh-hans","马耳他语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2203","mt","zu","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2204","mt","zh-hant","馬爾他語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2205","mt","ms","Maltese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2206","mn","en","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2207","mn","es","Mongol");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2208","mn","de","Mongolisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2209","mn","fr","Mongol");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2210","mn","ar","المنغولية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2211","mn","bs","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2212","mn","bg","Монголски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2213","mn","ca","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2214","mn","cs","Mongolský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2215","mn","sk","Mongolština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2216","mn","cy","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2217","mn","da","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2218","mn","el","Μογγολικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2219","mn","eo","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2220","mn","et","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2221","mn","eu","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2222","mn","fa","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2223","mn","fi","mongoli");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2224","mn","ga","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2225","mn","he","מונגולית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2226","mn","hi","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2227","mn","hr","Mongolski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2228","mn","hu","mongol");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2229","mn","hy","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2230","mn","id","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2231","mn","is","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2232","mn","it","Mongolo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2233","mn","ja","モンゴル語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2234","mn","ko","몽골어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2235","mn","ku","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2236","mn","la","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2237","mn","lv","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2238","mn","lt","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2239","mn","mk","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2240","mn","mt","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2241","mn","mn","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2242","mn","ne","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2243","mn","nl","Mongools");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2244","mn","nb","Mongolsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2245","mn","pa","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2246","mn","pl","mongolski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2247","mn","pt-pt","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2248","mn","pt-br","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2249","mn","qu","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2250","mn","ro","Mongoleză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2251","mn","ru","Монгольский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2252","mn","sl","Mongolski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2253","mn","so","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2254","mn","sq","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2255","mn","sr","монголски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2256","mn","sv","Mongoliska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2257","mn","ta","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2258","mn","th","มองโกเลีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2259","mn","tr","Mongolca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2260","mn","uk","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2261","mn","ur","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2262","mn","uz","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2263","mn","vi","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2264","mn","yi","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2265","mn","zh-hans","蒙古语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2266","mn","zu","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2267","mn","zh-hant","蒙古語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2268","mn","ms","Mongolian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2269","ne","en","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2270","ne","es","Nepalí");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2271","ne","de","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2272","ne","fr","Népalais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2273","ne","ar","النيبالية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2274","ne","bs","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2275","ne","bg","Непалски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2276","ne","ca","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2277","ne","cs","Nepálský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2278","ne","sk","Nepálčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2279","ne","cy","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2280","ne","da","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2281","ne","el","Νεπαλι");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2282","ne","eo","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2283","ne","et","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2284","ne","eu","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2285","ne","fa","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2286","ne","fi","nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2287","ne","ga","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2288","ne","he","נפאלית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2289","ne","hi","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2290","ne","hr","Nepalski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2291","ne","hu","nepáli");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2292","ne","hy","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2293","ne","id","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2294","ne","is","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2295","ne","it","Nepalese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2296","ne","ja","ネパール語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2297","ne","ko","네팔어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2298","ne","ku","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2299","ne","la","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2300","ne","lv","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2301","ne","lt","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2302","ne","mk","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2303","ne","mt","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2304","ne","mn","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2305","ne","ne","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2306","ne","nl","Nepalees");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2307","ne","nb","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2308","ne","pa","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2309","ne","pl","nepalski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2310","ne","pt-pt","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2311","ne","pt-br","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2312","ne","qu","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2313","ne","ro","Nepaleză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2314","ne","ru","Непальский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2315","ne","sl","Nepalščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2316","ne","so","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2317","ne","sq","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2318","ne","sr","непалски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2319","ne","sv","Nepalesiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2320","ne","ta","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2321","ne","th","เนปาล");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2322","ne","tr","Nepal dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2323","ne","uk","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2324","ne","ur","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2325","ne","uz","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2326","ne","vi","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2327","ne","yi","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2328","ne","zh-hans","尼泊尔语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2329","ne","zu","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2330","ne","zh-hant","尼泊爾語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2331","ne","ms","Nepali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2332","nl","en","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2333","nl","es","Holandés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2334","nl","de","Niederländisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2335","nl","fr","Néerlandais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2336","nl","ar","الهولندية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2337","nl","bs","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2338","nl","bg","Холандски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2339","nl","ca","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2340","nl","cs","Holandský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2341","nl","sk","Holandčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2342","nl","cy","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2343","nl","da","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2344","nl","el","Ολλανδικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2345","nl","eo","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2346","nl","et","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2347","nl","eu","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2348","nl","fa","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2349","nl","fi","hollanti");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2350","nl","ga","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2351","nl","he","הולנדית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2352","nl","hi","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2353","nl","hr","Holandski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2354","nl","hu","holland");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2355","nl","hy","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2356","nl","id","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2357","nl","is","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2358","nl","it","Olandese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2359","nl","ja","オランダ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2360","nl","ko","화란어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2361","nl","ku","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2362","nl","la","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2363","nl","lv","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2364","nl","lt","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2365","nl","mk","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2366","nl","mt","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2367","nl","mn","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2368","nl","ne","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2369","nl","nl","Nederlands");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2370","nl","nb","Nederlandsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2371","nl","pa","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2372","nl","pl","holenderski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2373","nl","pt-pt","Holandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2374","nl","pt-br","Holandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2375","nl","qu","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2376","nl","ro","Olaneză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2377","nl","ru","Голландский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2378","nl","sl","Nizozemščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2379","nl","so","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2380","nl","sq","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2381","nl","sr","холандски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2382","nl","sv","Nederländska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2383","nl","ta","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2384","nl","th","ดัตช์");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2385","nl","tr","Hollandaca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2386","nl","uk","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2387","nl","ur","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2388","nl","uz","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2389","nl","vi","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2390","nl","yi","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2391","nl","zh-hans","荷兰语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2392","nl","zu","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2393","nl","zh-hant","荷蘭語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2394","nl","ms","Dutch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2395","nb","en","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2396","nb","es","Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2397","nb","de","Norwegisch (Buchsprache)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2398","nb","fr","Norvégien Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2399","nb","ar","البوكمالية النرويجية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2400","nb","bs","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2401","nb","bg","Норвежки книжовен");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2402","nb","ca","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2403","nb","cs","Norwegian bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2404","nb","sk","Nórsky jazyk Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2405","nb","cy","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2406","nb","da","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2407","nb","el","Νορβηγικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2408","nb","eo","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2409","nb","et","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2410","nb","eu","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2411","nb","fa","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2412","nb","fi","kirjanorja");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2413","nb","ga","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2414","nb","he","נורווגית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2415","nb","hi","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2416","nb","hr","Književni norveški");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2417","nb","hu","norvég bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2418","nb","hy","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2419","nb","id","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2420","nb","is","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2421","nb","it","Norvegese Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2422","nb","ja","ノルウェー・ブークモール");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2423","nb","ko","노르웨이 보크말어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2424","nb","ku","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2425","nb","la","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2426","nb","lv","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2427","nb","lt","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2428","nb","mk","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2429","nb","mt","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2430","nb","mn","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2431","nb","ne","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2432","nb","nl","Noors Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2433","nb","nb","Norsk bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2434","nb","pa","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2435","nb","pl","norweski bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2436","nb","pt-pt","Norueguês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2437","nb","pt-br","Norueguês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2438","nb","qu","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2439","nb","ro","Bokmål (norvegiană)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2440","nb","ru","Норвежский букмол");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2441","nb","sl","Knjižna norveščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2442","nb","so","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2443","nb","sq","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2444","nb","sr","Норвешки бокмал");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2445","nb","sv","Norskt Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2446","nb","ta","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2447","nb","th","นอร์วิเจียนบอกมาล");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2448","nb","tr","Bokmal Norveç dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2449","nb","uk","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2450","nb","ur","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2451","nb","uz","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2452","nb","vi","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2453","nb","yi","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2454","nb","zh-hans","挪威布克莫尔语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2455","nb","zu","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2456","nb","zh-hant","挪威布克莫爾語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2457","nb","ms","Norwegian Bokmål");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2458","pa","en","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2459","pa","es","Panyabí");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2460","pa","de","Pandschabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2461","pa","fr","Panjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2462","pa","ar","البنجابية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2463","pa","bs","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2464","pa","bg","Панджабски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2465","pa","ca","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2466","pa","cs","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2467","pa","sk","Pandžábčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2468","pa","cy","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2469","pa","da","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2470","pa","el","Panjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2471","pa","eo","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2472","pa","et","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2473","pa","eu","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2474","pa","fa","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2475","pa","fi","pandzabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2476","pa","ga","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2477","pa","he","פנג\'אבית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2478","pa","hi","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2479","pa","hr","Pendžabljanin");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2480","pa","hu","pandzsábi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2481","pa","hy","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2482","pa","id","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2483","pa","is","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2484","pa","it","Panjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2485","pa","ja","パンジャーブ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2486","pa","ko","펀자브어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2487","pa","ku","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2488","pa","la","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2489","pa","lv","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2490","pa","lt","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2491","pa","mk","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2492","pa","mt","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2493","pa","mn","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2494","pa","ne","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2495","pa","nl","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2496","pa","nb","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2497","pa","pa","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2498","pa","pl","pendżabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2499","pa","pt-pt","Panjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2500","pa","pt-br","Panjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2501","pa","qu","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2502","pa","ro","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2503","pa","ru","Панджаби");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2504","pa","sl","Pandžabščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2505","pa","so","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2506","pa","sq","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2507","pa","sr","панџаби");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2508","pa","sv","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2509","pa","ta","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2510","pa","th","ปัญจาบ");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2511","pa","tr","Pencapça");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2512","pa","uk","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2513","pa","ur","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2514","pa","uz","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2515","pa","vi","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2516","pa","yi","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2517","pa","zh-hans","旁遮普语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2518","pa","zu","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2519","pa","zh-hant","旁遮普語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2520","pa","ms","Punjabi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2521","pl","en","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2522","pl","es","Polaco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2523","pl","de","Polnisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2524","pl","fr","Polonais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2525","pl","ar","البولندية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2526","pl","bs","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2527","pl","bg","Полски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2528","pl","ca","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2529","pl","cs","Polský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2530","pl","sk","Polština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2531","pl","cy","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2532","pl","da","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2533","pl","el","Πολωνικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2534","pl","eo","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2535","pl","et","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2536","pl","eu","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2537","pl","fa","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2538","pl","fi","puola");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2539","pl","ga","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2540","pl","he","פולנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2541","pl","hi","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2542","pl","hr","Poljski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2543","pl","hu","lengyel");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2544","pl","hy","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2545","pl","id","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2546","pl","is","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2547","pl","it","Polacco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2548","pl","ja","ポーランド語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2549","pl","ko","폴란드어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2550","pl","ku","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2551","pl","la","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2552","pl","lv","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2553","pl","lt","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2554","pl","mk","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2555","pl","mt","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2556","pl","mn","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2557","pl","ne","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2558","pl","nl","Pools");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2559","pl","nb","Polsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2560","pl","pa","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2561","pl","pl","polski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2562","pl","pt-pt","Polonês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2563","pl","pt-br","Polonês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2564","pl","qu","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2565","pl","ro","Poloneză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2566","pl","ru","Польский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2567","pl","sl","Poljski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2568","pl","so","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2569","pl","sq","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2570","pl","sr","пољски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2571","pl","sv","Polska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2572","pl","ta","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2573","pl","th","โปแลนด์");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2574","pl","tr","Polonyaca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2575","pl","uk","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2576","pl","ur","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2577","pl","uz","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2578","pl","vi","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2579","pl","yi","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2580","pl","zh-hans","波兰语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2581","pl","zu","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2582","pl","zh-hant","波蘭語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2583","pl","ms","Polish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2584","pt-pt","en","Portuguese (Portugal)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2585","pt-pt","es","Portugués, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2586","pt-pt","de","Portugiesisch, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2587","pt-pt","fr","Portugais - du Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2588","pt-pt","ar","البرتغالية ، البرتغال");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2589","pt-pt","bs","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2590","pt-pt","bg","Португалски (Португалия)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2591","pt-pt","ca","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2592","pt-pt","cs","Portugalština ( Portugalsko)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2593","pt-pt","sk","Portugalština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2594","pt-pt","cy","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2595","pt-pt","da","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2596","pt-pt","el","Πορτογαλικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2597","pt-pt","eo","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2598","pt-pt","et","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2599","pt-pt","eu","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2600","pt-pt","fa","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2601","pt-pt","fi","portugali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2602","pt-pt","ga","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2603","pt-pt","he","פורטוגזית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2604","pt-pt","hi","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2605","pt-pt","hr","Portugalski (Portugal)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2606","pt-pt","hu","portugál");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2607","pt-pt","hy","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2608","pt-pt","id","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2609","pt-pt","is","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2610","pt-pt","it","Portoghese, Portogallo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2611","pt-pt","ja","ポルトガル語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2612","pt-pt","ko","포르투갈 포르투갈어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2613","pt-pt","ku","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2614","pt-pt","la","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2615","pt-pt","lv","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2616","pt-pt","lt","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2617","pt-pt","mk","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2618","pt-pt","mt","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2619","pt-pt","mn","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2620","pt-pt","ne","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2621","pt-pt","nl","Portugees, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2622","pt-pt","nb","Portugisisk (Portugal)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2623","pt-pt","pa","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2624","pt-pt","pl","portugalski, Portugalia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2625","pt-pt","pt-pt","Português");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2626","pt-pt","pt-br","Português");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2627","pt-pt","qu","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2628","pt-pt","ro","Portugheză (Portugalia)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2629","pt-pt","ru","Португальский, Португалия");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2630","pt-pt","sl","Portugalščina ( Portugalska )");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2631","pt-pt","so","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2632","pt-pt","sq","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2633","pt-pt","sr","Португалски (Португалија)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2634","pt-pt","sv","Portugisiska, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2635","pt-pt","ta","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2636","pt-pt","th","โปรตุเกส");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2637","pt-pt","tr","Portekizce, Portekiz");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2638","pt-pt","uk","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2639","pt-pt","ur","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2640","pt-pt","uz","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2641","pt-pt","vi","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2642","pt-pt","yi","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2643","pt-pt","zh-hans","葡萄牙语（葡萄牙）");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2644","pt-pt","zu","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2645","pt-pt","zh-hant","葡萄牙語（葡萄牙）");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2646","pt-pt","ms","Portuguese, Portugal");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2647","pt-br","en","Portuguese (Brazil)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2648","pt-br","es","Portugués, Brasil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2649","pt-br","de","Portugiesisch, Brasilien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2650","pt-br","fr","Portugais - du Brésil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2651","pt-br","ar","البرتغالية ،البرازيل");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2652","pt-br","bs","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2653","pt-br","bg","Португалски (Бразилия)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2654","pt-br","ca","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2655","pt-br","cs","Portugalština ( Brazílie)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2656","pt-br","sk","Brazílska Portugalština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2657","pt-br","cy","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2658","pt-br","da","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2659","pt-br","el","Πορτογαλικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2660","pt-br","eo","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2661","pt-br","et","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2662","pt-br","eu","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2663","pt-br","fa","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2664","pt-br","fi","Brasilian portugali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2665","pt-br","ga","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2666","pt-br","he","פורטוגזית - ברזיל");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2667","pt-br","hi","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2668","pt-br","hr","Portugalski (Brazil)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2669","pt-br","hu","brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2670","pt-br","hy","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2671","pt-br","id","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2672","pt-br","is","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2673","pt-br","it","Portoghese, Brasile");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2674","pt-br","ja","ポルトガル語（ブラジル）");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2675","pt-br","ko","브라질 포르투갈어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2676","pt-br","ku","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2677","pt-br","la","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2678","pt-br","lv","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2679","pt-br","lt","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2680","pt-br","mk","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2681","pt-br","mt","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2682","pt-br","mn","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2683","pt-br","ne","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2684","pt-br","nl","Portugees, Brazilië");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2685","pt-br","nb","Portugisisk (Brasil)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2686","pt-br","pa","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2687","pt-br","pl","portugalski, Brazylia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2688","pt-br","pt-pt","Português");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2689","pt-br","pt-br","Português");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2690","pt-br","qu","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2691","pt-br","ro","Portugheză (Brazilia)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2692","pt-br","ru","Португальский, Бразилия");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2693","pt-br","sl","Portugalščina ( Brazilija )");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2694","pt-br","so","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2695","pt-br","sq","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2696","pt-br","sr","Португалски (Бразил)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2697","pt-br","sv","Portugisiska, Brasilien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2698","pt-br","ta","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2699","pt-br","th","โปรตุเกสบราซิล");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2700","pt-br","tr","Portekizce, Brezilya");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2701","pt-br","uk","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2702","pt-br","ur","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2703","pt-br","uz","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2704","pt-br","vi","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2705","pt-br","yi","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2706","pt-br","zh-hans","葡萄牙语（巴西）");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2707","pt-br","zu","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2708","pt-br","zh-hant","葡萄牙語（巴西）");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2709","pt-br","ms","Portuguese, Brazil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2710","qu","en","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2711","qu","es","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2712","qu","de","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2713","qu","fr","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2714","qu","ar","الكويتشوا");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2715","qu","bs","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2716","qu","bg","Кечуа");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2717","qu","ca","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2718","qu","cs","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2719","qu","sk","Jazyk Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2720","qu","cy","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2721","qu","da","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2722","qu","el","Κετσουα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2723","qu","eo","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2724","qu","et","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2725","qu","eu","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2726","qu","fa","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2727","qu","fi","ketsua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2728","qu","ga","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2729","qu","he","קצ\'ואה");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2730","qu","hi","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2731","qu","hr","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2732","qu","hu","quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2733","qu","hy","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2734","qu","id","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2735","qu","is","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2736","qu","it","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2737","qu","ja","ケチュア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2738","qu","ko","케추아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2739","qu","ku","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2740","qu","la","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2741","qu","lv","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2742","qu","lt","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2743","qu","mk","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2744","qu","mt","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2745","qu","mn","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2746","qu","ne","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2747","qu","nl","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2748","qu","nb","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2749","qu","pa","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2750","qu","pl","keczua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2751","qu","pt-pt","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2752","qu","pt-br","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2753","qu","qu","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2754","qu","ro","Quechuană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2755","qu","ru","Кечуа");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2756","qu","sl","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2757","qu","so","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2758","qu","sq","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2759","qu","sr","Кечуа");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2760","qu","sv","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2761","qu","ta","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2762","qu","th","คิวชัว");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2763","qu","tr","Quechua dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2764","qu","uk","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2765","qu","ur","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2766","qu","uz","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2767","qu","vi","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2768","qu","yi","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2769","qu","zh-hans","盖丘亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2770","qu","zu","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2771","qu","zh-hant","蓋丘亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2772","qu","ms","Quechua");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2773","ro","en","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2774","ro","es","Rumano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2775","ro","de","Rumänisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2776","ro","fr","Roumain");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2777","ro","ar","الرومانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2778","ro","bs","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2779","ro","bg","Румънски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2780","ro","ca","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2781","ro","cs","Rumunština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2782","ro","sk","Rumunčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2783","ro","cy","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2784","ro","da","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2785","ro","el","Ρουμανικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2786","ro","eo","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2787","ro","et","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2788","ro","eu","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2789","ro","fa","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2790","ro","fi","romania");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2791","ro","ga","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2792","ro","he","רומנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2793","ro","hi","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2794","ro","hr","Rumunjski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2795","ro","hu","román");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2796","ro","hy","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2797","ro","id","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2798","ro","is","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2799","ro","it","Rumeno");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2800","ro","ja","ルーマニア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2801","ro","ko","로마니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2802","ro","ku","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2803","ro","la","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2804","ro","lv","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2805","ro","lt","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2806","ro","mk","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2807","ro","mt","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2808","ro","mn","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2809","ro","ne","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2810","ro","nl","Roemeens");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2811","ro","nb","Rumensk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2812","ro","pa","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2813","ro","pl","rumuński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2814","ro","pt-pt","Romeno");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2815","ro","pt-br","Romeno");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2816","ro","qu","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2817","ro","ro","Română");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2818","ro","ru","Румынский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2819","ro","sl","Romunščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2820","ro","so","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2821","ro","sq","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2822","ro","sr","румунски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2823","ro","sv","Rumänska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2824","ro","ta","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2825","ro","th","โรมาเนีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2826","ro","tr","Rumence");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2827","ro","uk","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2828","ro","ur","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2829","ro","uz","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2830","ro","vi","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2831","ro","yi","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2832","ro","zh-hans","罗马尼亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2833","ro","zu","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2834","ro","zh-hant","羅馬尼亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2835","ro","ms","Romanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2836","ru","en","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2837","ru","es","Ruso");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2838","ru","de","Russisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2839","ru","fr","Russe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2840","ru","ar","الروسية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2841","ru","bs","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2842","ru","bg","Руски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2843","ru","ca","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2844","ru","cs","Ruský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2845","ru","sk","Ruština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2846","ru","cy","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2847","ru","da","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2848","ru","el","Ρωσικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2849","ru","eo","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2850","ru","et","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2851","ru","eu","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2852","ru","fa","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2853","ru","fi","venäjä");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2854","ru","ga","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2855","ru","he","רוסית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2856","ru","hi","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2857","ru","hr","Ruski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2858","ru","hu","orosz");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2859","ru","hy","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2860","ru","id","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2861","ru","is","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2862","ru","it","Russo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2863","ru","ja","ロシア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2864","ru","ko","러시아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2865","ru","ku","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2866","ru","la","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2867","ru","lv","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2868","ru","lt","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2869","ru","mk","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2870","ru","mt","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2871","ru","mn","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2872","ru","ne","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2873","ru","nl","Russisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2874","ru","nb","Russisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2875","ru","pa","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2876","ru","pl","rosyjski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2877","ru","pt-pt","Russo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2878","ru","pt-br","Russo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2879","ru","qu","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2880","ru","ro","Rusă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2881","ru","ru","Русский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2882","ru","sl","Ruščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2883","ru","so","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2884","ru","sq","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2885","ru","sr","руски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2886","ru","sv","Ryska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2887","ru","ta","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2888","ru","th","รัสเซีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2889","ru","tr","Rusça");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2890","ru","uk","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2891","ru","ur","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2892","ru","uz","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2893","ru","vi","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2894","ru","yi","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2895","ru","zh-hans","俄语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2896","ru","zu","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2897","ru","zh-hant","俄語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2898","ru","ms","Russian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2899","sl","en","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2900","sl","es","Esloveno");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2901","sl","de","Slowenisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2902","sl","fr","Slovène");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2903","sl","ar","السلوفانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2904","sl","bs","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2905","sl","bg","Словенски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2906","sl","ca","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2907","sl","cs","Slovinština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2908","sl","sk","Slovinčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2909","sl","cy","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2910","sl","da","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2911","sl","el","Σλοβενικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2912","sl","eo","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2913","sl","et","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2914","sl","eu","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2915","sl","fa","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2916","sl","fi","sloveeni");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2917","sl","ga","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2918","sl","he","סלובנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2919","sl","hi","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2920","sl","hr","Slovenac");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2921","sl","hu","szlovén");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2922","sl","hy","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2923","sl","id","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2924","sl","is","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2925","sl","it","Sloveno");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2926","sl","ja","スロベニア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2927","sl","ko","슬로베니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2928","sl","ku","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2929","sl","la","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2930","sl","lv","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2931","sl","lt","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2932","sl","mk","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2933","sl","mt","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2934","sl","mn","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2935","sl","ne","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2936","sl","nl","Sloveens");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2937","sl","nb","Slovensk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2938","sl","pa","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2939","sl","pl","słoweński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2940","sl","pt-pt","Esloveno");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2941","sl","pt-br","Esloveno");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2942","sl","qu","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2943","sl","ro","Slovenă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2944","sl","ru","Словенский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2945","sl","sl","Slovenščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2946","sl","so","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2947","sl","sq","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2948","sl","sr","словеначки");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2949","sl","sv","Slovenska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2950","sl","ta","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2951","sl","th","สโลวีเนียน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2952","sl","tr","Sloven dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2953","sl","uk","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2954","sl","ur","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2955","sl","uz","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2956","sl","vi","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2957","sl","yi","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2958","sl","zh-hans","斯洛文尼亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2959","sl","zu","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2960","sl","zh-hant","斯洛文尼亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2961","sl","ms","Slovenian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2962","so","en","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2963","so","es","Somalí");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2964","so","de","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2965","so","fr","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2966","so","ar","الصومالية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2967","so","bs","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2968","so","bg","Сомалийски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2969","so","ca","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2970","so","cs","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2971","so","sk","Somálčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2972","so","cy","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2973","so","da","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2974","so","el","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2975","so","eo","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2976","so","et","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2977","so","eu","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2978","so","fa","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2979","so","fi","somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2980","so","ga","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2981","so","he","סומלית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2982","so","hi","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2983","so","hr","Somalijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2984","so","hu","szomáli");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2985","so","hy","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2986","so","id","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2987","so","is","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2988","so","it","Somalo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2989","so","ja","ソマリ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2990","so","ko","소말리아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2991","so","ku","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2992","so","la","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2993","so","lv","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2994","so","lt","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2995","so","mk","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2996","so","mt","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2997","so","mn","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2998","so","ne","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("2999","so","nl","Somalisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3000","so","nb","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3001","so","pa","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3002","so","pl","somalijski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3003","so","pt-pt","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3004","so","pt-br","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3005","so","qu","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3006","so","ro","Somaleză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3007","so","ru","Сомалийский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3008","so","sl","Somalski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3009","so","so","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3010","so","sq","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3011","so","sr","Сомалијски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3012","so","sv","Somaliska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3013","so","ta","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3014","so","th","โซมาลี");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3015","so","tr","Somalice");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3016","so","uk","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3017","so","ur","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3018","so","uz","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3019","so","vi","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3020","so","yi","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3021","so","zh-hans","索马里语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3022","so","zu","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3023","so","zh-hant","索馬里語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3024","so","ms","Somali");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3025","sq","en","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3026","sq","es","Albanés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3027","sq","de","Albanisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3028","sq","fr","Albanais");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3029","sq","ar","الألبانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3030","sq","bs","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3031","sq","bg","Албански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3032","sq","ca","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3033","sq","cs","Albánský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3034","sq","sk","Albánčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3035","sq","cy","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3036","sq","da","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3037","sq","el","Αλβανικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3038","sq","eo","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3039","sq","et","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3040","sq","eu","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3041","sq","fa","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3042","sq","fi","albania");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3043","sq","ga","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3044","sq","he","אלבנית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3045","sq","hi","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3046","sq","hr","Albanac");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3047","sq","hu","albán");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3048","sq","hy","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3049","sq","id","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3050","sq","is","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3051","sq","it","Albanese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3052","sq","ja","アルバニア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3053","sq","ko","알바니아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3054","sq","ku","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3055","sq","la","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3056","sq","lv","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3057","sq","lt","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3058","sq","mk","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3059","sq","mt","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3060","sq","mn","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3061","sq","ne","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3062","sq","nl","Albaans");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3063","sq","nb","Albansk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3064","sq","pa","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3065","sq","pl","albański");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3066","sq","pt-pt","Albanês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3067","sq","pt-br","Albanês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3068","sq","qu","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3069","sq","ro","Albaneză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3070","sq","ru","Албанский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3071","sq","sl","Albanski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3072","sq","so","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3073","sq","sq","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3074","sq","sr","албански");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3075","sq","sv","Albanska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3076","sq","ta","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3077","sq","th","อัลเบเนีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3078","sq","tr","Arnavutça");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3079","sq","uk","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3080","sq","ur","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3081","sq","uz","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3082","sq","vi","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3083","sq","yi","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3084","sq","zh-hans","阿尔巴尼亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3085","sq","zu","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3086","sq","zh-hant","阿爾巴尼亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3087","sq","ms","Albanian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3088","sr","en","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3089","sr","es","Serbio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3090","sr","de","Serbisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3091","sr","fr","Serbe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3092","sr","ar","الصربية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3093","sr","bs","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3094","sr","bg","Сръбски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3095","sr","ca","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3096","sr","cs","Srbský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3097","sr","sk","Srbština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3098","sr","cy","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3099","sr","da","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3100","sr","el","Σερβικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3101","sr","eo","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3102","sr","et","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3103","sr","eu","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3104","sr","fa","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3105","sr","fi","serbia");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3106","sr","ga","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3107","sr","he","סרבית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3108","sr","hi","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3109","sr","hr","Srpski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3110","sr","hu","szerb");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3111","sr","hy","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3112","sr","id","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3113","sr","is","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3114","sr","it","Serbo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3115","sr","ja","セルビア語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3116","sr","ko","세르비아어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3117","sr","ku","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3118","sr","la","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3119","sr","lv","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3120","sr","lt","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3121","sr","mk","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3122","sr","mt","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3123","sr","mn","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3124","sr","ne","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3125","sr","nl","Servisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3126","sr","nb","Serbisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3127","sr","pa","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3128","sr","pl","serbski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3129","sr","pt-pt","Sérvio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3130","sr","pt-br","Sérvio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3131","sr","qu","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3132","sr","ro","Sârbă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3133","sr","ru","Сербский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3134","sr","sl","Srbski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3135","sr","so","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3136","sr","sq","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3137","sr","sr","српски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3138","sr","sv","Serbiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3139","sr","ta","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3140","sr","th","เซอร์เบีย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3141","sr","tr","Sırpça");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3142","sr","uk","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3143","sr","ur","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3144","sr","uz","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3145","sr","vi","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3146","sr","yi","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3147","sr","zh-hans","赛尔维亚语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3148","sr","zu","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3149","sr","zh-hant","賽爾維亞語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3150","sr","ms","Serbian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3151","sv","en","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3152","sv","es","Sueco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3153","sv","de","Schwedisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3154","sv","fr","Suédois");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3155","sv","ar","السويدية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3156","sv","bs","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3157","sv","bg","Шведски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3158","sv","ca","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3159","sv","cs","Švédský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3160","sv","sk","Švédština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3161","sv","cy","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3162","sv","da","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3163","sv","el","Σουηδικη");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3164","sv","eo","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3165","sv","et","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3166","sv","eu","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3167","sv","fa","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3168","sv","fi","ruotsi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3169","sv","ga","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3170","sv","he","שוודית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3171","sv","hi","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3172","sv","hr","švedski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3173","sv","hu","svéd");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3174","sv","hy","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3175","sv","id","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3176","sv","is","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3177","sv","it","Svedese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3178","sv","ja","スウェーデン語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3179","sv","ko","스웨덴어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3180","sv","ku","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3181","sv","la","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3182","sv","lv","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3183","sv","lt","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3184","sv","mk","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3185","sv","mt","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3186","sv","mn","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3187","sv","ne","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3188","sv","nl","Zweeds");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3189","sv","nb","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3190","sv","pa","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3191","sv","pl","szwedzki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3192","sv","pt-pt","Sueco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3193","sv","pt-br","Sueco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3194","sv","qu","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3195","sv","ro","Suedeză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3196","sv","ru","Шведский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3197","sv","sl","Švedščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3198","sv","so","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3199","sv","sq","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3200","sv","sr","шведски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3201","sv","sv","Svenska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3202","sv","ta","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3203","sv","th","สวีเดน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3204","sv","tr","İsveççe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3205","sv","uk","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3206","sv","ur","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3207","sv","uz","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3208","sv","vi","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3209","sv","yi","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3210","sv","zh-hans","瑞典语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3211","sv","zu","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3212","sv","zh-hant","瑞典語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3213","sv","ms","Swedish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3214","ta","en","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3215","ta","es","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3216","ta","de","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3217","ta","fr","Tamoul");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3218","ta","ar","التاميلية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3219","ta","bs","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3220","ta","bg","Тамилски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3221","ta","ca","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3222","ta","cs","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3223","ta","sk","Tamilčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3224","ta","cy","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3225","ta","da","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3226","ta","el","Ταμιλ");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3227","ta","eo","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3228","ta","et","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3229","ta","eu","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3230","ta","fa","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3231","ta","fi","tamili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3232","ta","ga","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3233","ta","he","טמילית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3234","ta","hi","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3235","ta","hr","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3236","ta","hu","tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3237","ta","hy","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3238","ta","id","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3239","ta","is","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3240","ta","it","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3241","ta","ja","タミル語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3242","ta","ko","타밀어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3243","ta","ku","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3244","ta","la","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3245","ta","lv","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3246","ta","lt","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3247","ta","mk","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3248","ta","mt","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3249","ta","mn","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3250","ta","ne","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3251","ta","nl","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3252","ta","nb","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3253","ta","pa","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3254","ta","pl","tamilski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3255","ta","pt-pt","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3256","ta","pt-br","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3257","ta","qu","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3258","ta","ro","Tamilă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3259","ta","ru","Тамильский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3260","ta","sl","Tamilščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3261","ta","so","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3262","ta","sq","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3263","ta","sr","тамилски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3264","ta","sv","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3265","ta","ta","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3266","ta","th","ทมิฬ");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3267","ta","tr","Tamil dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3268","ta","uk","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3269","ta","ur","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3270","ta","uz","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3271","ta","vi","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3272","ta","yi","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3273","ta","zh-hans","泰米尔语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3274","ta","zu","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3275","ta","zh-hant","泰米爾語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3276","ta","ms","Tamil");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3277","th","en","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3278","th","es","Tailandés");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3279","th","de","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3280","th","fr","Thaï");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3281","th","ar","التايلندية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3282","th","bs","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3283","th","bg","Тайски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3284","th","ca","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3285","th","cs","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3286","th","sk","Thajština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3287","th","cy","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3288","th","da","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3289","th","el","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3290","th","eo","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3291","th","et","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3292","th","eu","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3293","th","fa","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3294","th","fi","thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3295","th","ga","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3296","th","he","תאילנדית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3297","th","hi","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3298","th","hr","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3299","th","hu","tájföldi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3300","th","hy","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3301","th","id","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3302","th","is","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3303","th","it","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3304","th","ja","タイ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3305","th","ko","태국어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3306","th","ku","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3307","th","la","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3308","th","lv","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3309","th","lt","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3310","th","mk","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3311","th","mt","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3312","th","mn","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3313","th","ne","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3314","th","nl","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3315","th","nb","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3316","th","pa","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3317","th","pl","tajski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3318","th","pt-pt","Tailandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3319","th","pt-br","Tailandês");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3320","th","qu","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3321","th","ro","Tailandeză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3322","th","ru","Тайский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3323","th","sl","Tajski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3324","th","so","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3325","th","sq","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3326","th","sr","Тајландски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3327","th","sv","Thailändska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3328","th","ta","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3329","th","th","ไทย");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3330","th","tr","Tayca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3331","th","uk","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3332","th","ur","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3333","th","uz","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3334","th","vi","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3335","th","yi","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3336","th","zh-hans","泰语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3337","th","zu","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3338","th","zh-hant","泰語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3339","th","ms","Thai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3340","tr","en","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3341","tr","es","Turco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3342","tr","de","Türkisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3343","tr","fr","Turc");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3344","tr","ar","التركية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3345","tr","bs","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3346","tr","bg","Турски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3347","tr","ca","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3348","tr","cs","Turečtina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3349","tr","sk","Turečtina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3350","tr","cy","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3351","tr","da","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3352","tr","el","Τουρκικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3353","tr","eo","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3354","tr","et","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3355","tr","eu","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3356","tr","fa","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3357","tr","fi","turkki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3358","tr","ga","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3359","tr","he","תורכית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3360","tr","hi","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3361","tr","hr","Turski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3362","tr","hu","török");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3363","tr","hy","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3364","tr","id","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3365","tr","is","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3366","tr","it","Turco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3367","tr","ja","トルコ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3368","tr","ko","터어키어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3369","tr","ku","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3370","tr","la","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3371","tr","lv","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3372","tr","lt","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3373","tr","mk","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3374","tr","mt","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3375","tr","mn","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3376","tr","ne","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3377","tr","nl","Turks");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3378","tr","nb","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3379","tr","pa","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3380","tr","pl","turecki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3381","tr","pt-pt","Turco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3382","tr","pt-br","Turco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3383","tr","qu","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3384","tr","ro","Turcă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3385","tr","ru","Турецкий");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3386","tr","sl","Turščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3387","tr","so","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3388","tr","sq","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3389","tr","sr","турски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3390","tr","sv","Turkiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3391","tr","ta","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3392","tr","th","ตุรกี");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3393","tr","tr","Türkçe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3394","tr","uk","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3395","tr","ur","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3396","tr","uz","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3397","tr","vi","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3398","tr","yi","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3399","tr","zh-hans","土耳其语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3400","tr","zu","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3401","tr","zh-hant","土耳其語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3402","tr","ms","Turkish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3403","uk","en","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3404","uk","es","Ucraniano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3405","uk","de","Ukrainisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3406","uk","fr","Ukrainien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3407","uk","ar","الأوكرانية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3408","uk","bs","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3409","uk","bg","Украински");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3410","uk","ca","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3411","uk","cs","Ukrajinský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3412","uk","sk","Ukrajinčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3413","uk","cy","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3414","uk","da","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3415","uk","el","Ουκρανικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3416","uk","eo","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3417","uk","et","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3418","uk","eu","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3419","uk","fa","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3420","uk","fi","ukraina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3421","uk","ga","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3422","uk","he","אוקראינית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3423","uk","hi","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3424","uk","hr","Ukrajinski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3425","uk","hu","ukrán");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3426","uk","hy","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3427","uk","id","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3428","uk","is","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3429","uk","it","Ucraino");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3430","uk","ja","ウクライナ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3431","uk","ko","우크라이나어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3432","uk","ku","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3433","uk","la","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3434","uk","lv","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3435","uk","lt","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3436","uk","mk","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3437","uk","mt","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3438","uk","mn","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3439","uk","ne","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3440","uk","nl","Oekraïens");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3441","uk","nb","Ukrainsk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3442","uk","pa","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3443","uk","pl","ukraiński");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3444","uk","pt-pt","Ucraniano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3445","uk","pt-br","Ucraniano");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3446","uk","qu","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3447","uk","ro","Ucrainiană");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3448","uk","ru","Украинский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3449","uk","sl","Ukrajinski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3450","uk","so","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3451","uk","sq","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3452","uk","sr","украјински");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3453","uk","sv","Ukrainska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3454","uk","ta","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3455","uk","th","ยูเครน");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3456","uk","tr","Ukraynaca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3457","uk","uk","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3458","uk","ur","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3459","uk","uz","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3460","uk","vi","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3461","uk","yi","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3462","uk","zh-hans","乌克兰语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3463","uk","zu","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3464","uk","zh-hant","烏克蘭語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3465","uk","ms","Ukrainian");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3466","ur","en","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3467","ur","es","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3468","ur","de","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3469","ur","fr","Ourdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3470","ur","ar","الأردية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3471","ur","bs","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3472","ur","bg","Урду");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3473","ur","ca","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3474","ur","cs","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3475","ur","sk","Urdština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3476","ur","cy","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3477","ur","da","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3478","ur","el","Ουρντου");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3479","ur","eo","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3480","ur","et","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3481","ur","eu","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3482","ur","fa","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3483","ur","fi","urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3484","ur","ga","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3485","ur","he","אורדו");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3486","ur","hi","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3487","ur","hr","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3488","ur","hu","urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3489","ur","hy","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3490","ur","id","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3491","ur","is","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3492","ur","it","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3493","ur","ja","ウルドゥー語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3494","ur","ko","우르두어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3495","ur","ku","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3496","ur","la","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3497","ur","lv","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3498","ur","lt","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3499","ur","mk","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3500","ur","mt","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3501","ur","mn","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3502","ur","ne","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3503","ur","nl","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3504","ur","nb","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3505","ur","pa","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3506","ur","pl","urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3507","ur","pt-pt","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3508","ur","pt-br","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3509","ur","qu","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3510","ur","ro","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3511","ur","ru","Урду");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3512","ur","sl","Urdujščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3513","ur","so","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3514","ur","sq","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3515","ur","sr","урду");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3516","ur","sv","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3517","ur","ta","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3518","ur","th","อุรดู");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3519","ur","tr","Urduca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3520","ur","uk","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3521","ur","ur","اردو ");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3522","ur","uz","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3523","ur","vi","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3524","ur","yi","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3525","ur","zh-hans","乌尔都语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3526","ur","zu","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3527","ur","zh-hant","烏爾都語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3528","ur","ms","Urdu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3529","uz","en","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3530","uz","es","Uzbeko");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3531","uz","de","Usbekisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3532","uz","fr","Ouzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3533","uz","ar","الاوزباكية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3534","uz","bs","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3535","uz","bg","Узбекски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3536","uz","ca","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3537","uz","cs","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3538","uz","sk","Uzbekčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3539","uz","cy","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3540","uz","da","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3541","uz","el","Ουζμπεκικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3542","uz","eo","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3543","uz","et","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3544","uz","eu","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3545","uz","fa","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3546","uz","fi","uzbekki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3547","uz","ga","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3548","uz","he","אוזבקית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3549","uz","hi","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3550","uz","hr","Uzbečki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3551","uz","hu","üzbég");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3552","uz","hy","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3553","uz","id","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3554","uz","is","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3555","uz","it","Uzbeco");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3556","uz","ja","ウズベク語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3557","uz","ko","우즈베크어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3558","uz","ku","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3559","uz","la","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3560","uz","lv","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3561","uz","lt","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3562","uz","mk","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3563","uz","mt","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3564","uz","mn","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3565","uz","ne","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3566","uz","nl","Oezbeeks");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3567","uz","nb","Usbekisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3568","uz","pa","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3569","uz","pl","uzbecki");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3570","uz","pt-pt","Uzbeque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3571","uz","pt-br","Uzbeque");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3572","uz","qu","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3573","uz","ro","Uzbecă");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3574","uz","ru","Узбекский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3575","uz","sl","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3576","uz","so","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3577","uz","sq","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3578","uz","sr","Узбек");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3579","uz","sv","Uzbekiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3580","uz","ta","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3581","uz","th","อุซเบก");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3582","uz","tr","Özbekçe");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3583","uz","uk","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3584","uz","ur","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3585","uz","uz","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3586","uz","vi","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3587","uz","yi","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3588","uz","zh-hans","乌兹别克语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3589","uz","zu","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3590","uz","zh-hant","烏茲別克語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3591","uz","ms","Uzbek");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3592","vi","en","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3593","vi","es","Vietnamita");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3594","vi","de","Vietnamesisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3595","vi","fr","Vietnamien");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3596","vi","ar","الفيتنامية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3597","vi","bs","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3598","vi","bg","Виетнамски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3599","vi","ca","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3600","vi","cs","Vietnamský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3601","vi","sk","Vietnamčina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3602","vi","cy","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3603","vi","da","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3604","vi","el","Βιετναμεζικα");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3605","vi","eo","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3606","vi","et","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3607","vi","eu","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3608","vi","fa","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3609","vi","fi","vietnam");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3610","vi","ga","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3611","vi","he","וייטנאמית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3612","vi","hi","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3613","vi","hr","Vijetnamski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3614","vi","hu","vietnámi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3615","vi","hy","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3616","vi","id","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3617","vi","is","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3618","vi","it","Vietnamita");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3619","vi","ja","ベトナム語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3620","vi","ko","베트남어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3621","vi","ku","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3622","vi","la","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3623","vi","lv","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3624","vi","lt","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3625","vi","mk","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3626","vi","mt","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3627","vi","mn","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3628","vi","ne","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3629","vi","nl","Vietnamees");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3630","vi","nb","Vietnamesisk");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3631","vi","pa","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3632","vi","pl","wietnamski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3633","vi","pt-pt","Vietnamita");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3634","vi","pt-br","Vietnamita");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3635","vi","qu","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3636","vi","ro","Vietnameză");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3637","vi","ru","Вьетнамский");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3638","vi","sl","Vietnamščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3639","vi","so","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3640","vi","sq","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3641","vi","sr","вијетнамски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3642","vi","sv","Vietnamesiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3643","vi","ta","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3644","vi","th","เวียดนาม");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3645","vi","tr","Vietnamca");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3646","vi","uk","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3647","vi","ur","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3648","vi","uz","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3649","vi","vi","Tiếng Việt");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3650","vi","yi","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3651","vi","zh-hans","越南语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3652","vi","zu","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3653","vi","zh-hant","越南語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3654","vi","ms","Vietnamese");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3655","yi","en","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3656","yi","es","Yidis");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3657","yi","de","Jiddisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3658","yi","fr","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3659","yi","ar","اليديشية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3660","yi","bs","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3661","yi","bg","Идиш");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3662","yi","ca","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3663","yi","cs","Jidiš");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3664","yi","sk","Jidiš");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3665","yi","cy","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3666","yi","da","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3667","yi","el","Γιντις");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3668","yi","eo","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3669","yi","et","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3670","yi","eu","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3671","yi","fa","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3672","yi","fi","jiddi");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3673","yi","ga","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3674","yi","he","יידיש");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3675","yi","hi","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3676","yi","hr","Jidiš");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3677","yi","hu","jiddis");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3678","yi","hy","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3679","yi","id","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3680","yi","is","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3681","yi","it","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3682","yi","ja","イディッシュ語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3683","yi","ko","이디시어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3684","yi","ku","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3685","yi","la","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3686","yi","lv","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3687","yi","lt","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3688","yi","mk","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3689","yi","mt","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3690","yi","mn","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3691","yi","ne","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3692","yi","nl","Jiddisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3693","yi","nb","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3694","yi","pa","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3695","yi","pl","jidysz");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3696","yi","pt-pt","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3697","yi","pt-br","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3698","yi","qu","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3699","yi","ro","Idiş");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3700","yi","ru","Идиш");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3701","yi","sl","Jidiš");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3702","yi","so","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3703","yi","sq","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3704","yi","sr","јидиш");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3705","yi","sv","Jiddisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3706","yi","ta","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3707","yi","th","ยิชดิช");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3708","yi","tr","Eski İbranice");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3709","yi","uk","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3710","yi","ur","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3711","yi","uz","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3712","yi","vi","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3713","yi","yi","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3714","yi","zh-hans","依地语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3715","yi","zu","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3716","yi","zh-hant","依地語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3717","yi","ms","Yiddish");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3718","zh-hans","en","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3719","zh-hans","es","Chino simplificado");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3720","zh-hans","de","Vereinfachtes Chinesisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3721","zh-hans","fr","Chinois simplifié");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3722","zh-hans","ar","الصينية المبسطة");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3723","zh-hans","bs","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3724","zh-hans","bg","Китайски  (опростен)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3725","zh-hans","ca","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3726","zh-hans","cs","Čínština ( Zjednodušený )");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3727","zh-hans","sk","Zjednodušená Čínština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3728","zh-hans","cy","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3729","zh-hans","da","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3730","zh-hans","el","Κινεζικα (Απλοποιημένα)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3731","zh-hans","eo","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3732","zh-hans","et","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3733","zh-hans","eu","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3734","zh-hans","fa","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3735","zh-hans","fi","kiina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3736","zh-hans","ga","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3737","zh-hans","he","סינית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3738","zh-hans","hi","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3739","zh-hans","hr","Kineski (pojednostavljeni)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3740","zh-hans","hu","egyszerűsített kínai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3741","zh-hans","hy","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3742","zh-hans","id","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3743","zh-hans","is","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3744","zh-hans","it","Cinese semplificato");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3745","zh-hans","ja","簡体中国語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3746","zh-hans","ko","중국어 간체");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3747","zh-hans","ku","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3748","zh-hans","la","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3749","zh-hans","lv","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3750","zh-hans","lt","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3751","zh-hans","mk","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3752","zh-hans","mt","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3753","zh-hans","mn","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3754","zh-hans","ne","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3755","zh-hans","nl","Vereenvoudigd Chinees");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3756","zh-hans","nb","Kinesisk (forenklet)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3757","zh-hans","pa","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3758","zh-hans","pl","chiński uproszczony");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3759","zh-hans","pt-pt","Chinês (Simplificado)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3760","zh-hans","pt-br","Chinês (Simplificado)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3761","zh-hans","qu","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3762","zh-hans","ro","Chineza simplificată");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3763","zh-hans","ru","Китайский (упрощенный)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3764","zh-hans","sl","Kitajščina (poenostavljena )");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3765","zh-hans","so","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3766","zh-hans","sq","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3767","zh-hans","sr","Кинески (поједностављени)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3768","zh-hans","sv","Förenklad kinesiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3769","zh-hans","ta","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3770","zh-hans","th","จีนประยุกต์");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3771","zh-hans","tr","Modern Çince");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3772","zh-hans","uk","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3773","zh-hans","ur","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3774","zh-hans","uz","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3775","zh-hans","vi","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3776","zh-hans","yi","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3777","zh-hans","zh-hans","简体中文");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3778","zh-hans","zu","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3779","zh-hans","zh-hant","簡體中文");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3780","zh-hans","ms","Chinese (Simplified)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3781","zu","en","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3782","zu","es","Zulú");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3783","zu","de","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3784","zu","fr","Zoulou");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3785","zu","ar","الزولو");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3786","zu","bs","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3787","zu","bg","Зулу");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3788","zu","ca","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3789","zu","cs","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3790","zu","sk","Jazyk Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3791","zu","cy","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3792","zu","da","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3793","zu","el","Ζουλου");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3794","zu","eo","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3795","zu","et","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3796","zu","eu","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3797","zu","fa","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3798","zu","fi","zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3799","zu","ga","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3800","zu","he","זולו ");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3801","zu","hi","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3802","zu","hr","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3803","zu","hu","zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3804","zu","hy","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3805","zu","id","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3806","zu","is","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3807","zu","it","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3808","zu","ja","ズールー語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3809","zu","ko","줄루어");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3810","zu","ku","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3811","zu","la","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3812","zu","lv","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3813","zu","lt","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3814","zu","mk","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3815","zu","mt","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3816","zu","mn","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3817","zu","ne","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3818","zu","nl","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3819","zu","nb","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3820","zu","pa","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3821","zu","pl","zuluski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3822","zu","pt-pt","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3823","zu","pt-br","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3824","zu","qu","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3825","zu","ro","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3826","zu","ru","Зулу");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3827","zu","sl","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3828","zu","so","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3829","zu","sq","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3830","zu","sr","зулу");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3831","zu","sv","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3832","zu","ta","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3833","zu","th","ซูลู");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3834","zu","tr","Zulu dili");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3835","zu","uk","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3836","zu","ur","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3837","zu","uz","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3838","zu","vi","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3839","zu","yi","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3840","zu","zh-hans","祖鲁语");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3841","zu","zu","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3842","zu","zh-hant","祖魯語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3843","zu","ms","Zulu");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3844","zh-hant","en","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3845","zh-hant","es","Chino tradicional");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3846","zh-hant","de","Traditionelles Chinesisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3847","zh-hant","fr","Chinois traditionnel");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3848","zh-hant","ar","الصينية التقليدية");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3849","zh-hant","bs","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3850","zh-hant","bg","Китайски (традиционен)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3851","zh-hant","ca","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3852","zh-hant","cs","Čínština (tradiční )");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3853","zh-hant","sk","Tradičná Čínština");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3854","zh-hant","cy","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3855","zh-hant","da","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3856","zh-hant","el","Κινεζικα (Παραδοσιακά)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3857","zh-hant","eo","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3858","zh-hant","et","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3859","zh-hant","eu","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3860","zh-hant","fa","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3861","zh-hant","fi","perinteinen kiina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3862","zh-hant","ga","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3863","zh-hant","he","סינית מסורתית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3864","zh-hant","hi","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3865","zh-hant","hr","Kineski (tradicionalni)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3866","zh-hant","hu","hagyományos kínai");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3867","zh-hant","hy","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3868","zh-hant","id","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3869","zh-hant","is","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3870","zh-hant","it","Cinese tradizionale");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3871","zh-hant","ja","繁体中国語");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3872","zh-hant","ko","중국어 번체");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3873","zh-hant","ku","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3874","zh-hant","la","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3875","zh-hant","lv","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3876","zh-hant","lt","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3877","zh-hant","mk","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3878","zh-hant","mt","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3879","zh-hant","mn","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3880","zh-hant","ne","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3881","zh-hant","nl","Traditioneel Chinees");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3882","zh-hant","nb","Kinesisk (tradisjonell)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3883","zh-hant","pa","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3884","zh-hant","pl","chiński tradycyjny");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3885","zh-hant","pt-pt","Chinês (Tradicional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3886","zh-hant","pt-br","Chinês (Tradicional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3887","zh-hant","qu","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3888","zh-hant","ro","Chineza tradiţională");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3889","zh-hant","ru","Китайский (традиционный)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3890","zh-hant","sl","Kitajščina (tradicionalna)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3891","zh-hant","so","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3892","zh-hant","sq","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3893","zh-hant","sr","Кинески (традиционални)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3894","zh-hant","sv","Traditionell kinesiska");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3895","zh-hant","ta","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3896","zh-hant","th","จีนดั้งเดิม");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3897","zh-hant","tr","Klasik Çince");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3898","zh-hant","uk","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3899","zh-hant","ur","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3900","zh-hant","uz","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3901","zh-hant","vi","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3902","zh-hant","yi","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3903","zh-hant","zh-hans","繁体中文");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3904","zh-hant","zu","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3905","zh-hant","zh-hant","繁體中文");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3906","zh-hant","ms","Chinese (Traditional)");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3907","ms","en","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3908","ms","es","Malayo");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3909","ms","de","Malaiisch");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3910","ms","fr","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3911","ms","ar","لغة الملايو");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3912","ms","bs","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3913","ms","bg","Малайски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3914","ms","ca","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3915","ms","cs","Malajský");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3916","ms","sk","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3917","ms","cy","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3918","ms","da","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3919","ms","el","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3920","ms","eo","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3921","ms","et","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3922","ms","eu","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3923","ms","fa","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3924","ms","fi","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3925","ms","ga","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3926","ms","he","מלאית");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3927","ms","hi","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3928","ms","hr","Malajski");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3929","ms","hu","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3930","ms","hy","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3931","ms","id","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3932","ms","is","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3933","ms","it","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3934","ms","ja","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3935","ms","ko","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3936","ms","ku","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3937","ms","la","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3938","ms","lv","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3939","ms","lt","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3940","ms","mk","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3941","ms","mt","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3942","ms","mn","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3943","ms","ne","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3944","ms","nl","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3945","ms","nb","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3946","ms","pa","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3947","ms","pl","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3948","ms","pt-pt","Malaio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3949","ms","pt-br","Malaio");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3950","ms","qu","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3951","ms","ro","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3952","ms","ru","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3953","ms","sl","Malajščina");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3954","ms","so","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3955","ms","sq","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3956","ms","sr","малајски");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3957","ms","sv","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3958","ms","ta","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3959","ms","th","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3960","ms","tr","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3961","ms","uk","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3962","ms","ur","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3963","ms","uz","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3964","ms","vi","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3965","ms","yi","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3966","ms","zh-hans","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3967","ms","zu","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3968","ms","zh-hant","Malay");
INSERT INTO `a3rfa_icl_languages_translations` VALUES("3969","ms","ms","Melayu");


DROP TABLE IF EXISTS `a3rfa_icl_locale_map`;

CREATE TABLE `a3rfa_icl_locale_map` (
  `code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(35) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `code` (`code`,`locale`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_icl_locale_map` VALUES("en","en_US");
INSERT INTO `a3rfa_icl_locale_map` VALUES("fa","fa_IR");


DROP TABLE IF EXISTS `a3rfa_icl_message_status`;

CREATE TABLE `a3rfa_icl_message_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `object_id` bigint(20) unsigned NOT NULL,
  `from_language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `to_language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_type` varchar(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rid` (`rid`),
  KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_node`;

CREATE TABLE `a3rfa_icl_node` (
  `nid` bigint(20) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_reminders`;

CREATE TABLE `a3rfa_icl_reminders` (
  `id` bigint(20) NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `can_delete` tinyint(4) NOT NULL,
  `show` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_string_positions`;

CREATE TABLE `a3rfa_icl_string_positions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) NOT NULL,
  `kind` tinyint(4) DEFAULT NULL,
  `position_in_page` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_id` (`string_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_string_status`;

CREATE TABLE `a3rfa_icl_string_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) NOT NULL,
  `string_translation_id` bigint(20) NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `string_translation_id` (`string_translation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_string_translations`;

CREATE TABLE `a3rfa_icl_string_translations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `string_id` bigint(20) unsigned NOT NULL,
  `language` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` tinyint(4) NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci,
  `translator_id` bigint(20) unsigned DEFAULT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `batch_id` int(11) NOT NULL DEFAULT '0',
  `translation_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `string_language` (`string_id`,`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_strings`;

CREATE TABLE `a3rfa_icl_strings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `language` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` varchar(160) CHARACTER SET utf8 NOT NULL,
  `name` varchar(160) CHARACTER SET utf8 NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `string_package_id` bigint(20) unsigned DEFAULT NULL,
  `location` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'LINE',
  `title` varchar(160) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` tinyint(4) NOT NULL,
  `gettext_context` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `domain_name_context_md5` varchar(32) CHARACTER SET latin1 NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uc_domain_name_context_md5` (`domain_name_context_md5`),
  KEY `language_context` (`language`,`context`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_translate`;

CREATE TABLE `a3rfa_icl_translate` (
  `tid` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `job_id` bigint(20) unsigned NOT NULL,
  `content_id` bigint(20) unsigned NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `field_type` varchar(160) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_format` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_translate` tinyint(4) NOT NULL,
  `field_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_data_translated` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_finished` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `job_id` (`job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_translate_job`;

CREATE TABLE `a3rfa_icl_translate_job` (
  `job_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rid` bigint(20) unsigned NOT NULL,
  `translator_id` int(10) unsigned NOT NULL,
  `translated` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `manager_id` int(10) unsigned NOT NULL,
  `revision` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`job_id`),
  KEY `rid` (`rid`,`translator_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_translation_batches`;

CREATE TABLE `a3rfa_icl_translation_batches` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `batch_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `ts_url` text COLLATE utf8mb4_unicode_520_ci,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_translation_status`;

CREATE TABLE `a3rfa_icl_translation_status` (
  `rid` bigint(20) NOT NULL AUTO_INCREMENT,
  `translation_id` bigint(20) NOT NULL,
  `status` tinyint(4) NOT NULL,
  `translator_id` bigint(20) NOT NULL,
  `needs_update` tinyint(4) NOT NULL,
  `md5` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `translation_service` varchar(16) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `batch_id` int(11) NOT NULL DEFAULT '0',
  `translation_package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `links_fixed` tinyint(4) NOT NULL DEFAULT '0',
  `_prevstate` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `translation_id` (`translation_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_icl_translations`;

CREATE TABLE `a3rfa_icl_translations` (
  `translation_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `element_type` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post_post',
  `element_id` bigint(20) DEFAULT NULL,
  `trid` bigint(20) NOT NULL,
  `language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source_language_code` varchar(7) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`translation_id`),
  UNIQUE KEY `trid_lang` (`trid`,`language_code`),
  UNIQUE KEY `el_type_id` (`element_type`,`element_id`),
  KEY `trid` (`trid`),
  KEY `id_type_language` (`element_id`,`element_type`,`language_code`)
) ENGINE=MyISAM AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_icl_translations` VALUES("1","post_avada_portfolio","160","160","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("2","post_avada_portfolio","162","162","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("3","post_avada_portfolio","164","164","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("4","post_avada_portfolio","166","166","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("5","post_avada_portfolio","168","168","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("6","post_avada_portfolio","170","170","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("7","post_avada_portfolio","173","173","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("8","post_avada_portfolio","172","172","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("9","post_avada_portfolio","174","174","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("10","post_avada_portfolio","175","175","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("11","post_avada_portfolio","176","176","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("12","post_avada_portfolio","177","177","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("13","post_nav_menu_item","17","17","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("14","post_nav_menu_item","18","18","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("15","post_nav_menu_item","19","19","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("16","post_nav_menu_item","20","20","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("17","post_nav_menu_item","21","21","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("18","post_nav_menu_item","454","454","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("19","post_nav_menu_item","628","628","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("20","post_nav_menu_item","649","649","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("21","post_nav_menu_item","650","650","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("22","post_nav_menu_item","651","651","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("23","post_nav_menu_item","652","652","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("24","post_page","7","7","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("25","post_page","9","9","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("26","post_page","11","11","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("27","post_page","13","13","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("28","post_page","15","15","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("29","post_page","444","444","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("30","post_page","555","555","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("31","post_page","639","639","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("32","post_page","641","641","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("33","post_page","643","643","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("34","post_page","645","645","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("35","post_post","442","442","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("36","post_post","478","478","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("37","post_post","480","480","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("38","post_post","482","482","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("39","post_post","484","484","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("40","post_post","489","489","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("41","post_slide","22","22","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("42","post_slide","78","78","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("43","post_slide","119","119","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("44","post_slide","159","159","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("45","post_slide","312","312","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("46","post_slide","319","319","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("47","post_slide","323","323","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("48","post_slide","328","328","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("49","post_slide","330","330","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("50","post_slide","332","332","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("51","post_slide","334","334","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("52","post_slide","336","336","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("53","post_slide","338","338","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("54","post_slide","340","340","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("55","post_slide","342","342","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("56","post_slide","344","344","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("57","post_slide","487","487","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("58","post_wpcf7_contact_form","153","153","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("59","post_wpcf7_contact_form","413","413","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("60","post_wpcf7_contact_form","702","702","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("61","post_wpcf7_contact_form","703","703","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("62","post_wpcf7_contact_form","4","4","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("63","tax_category","1","705","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("64","tax_category","2","706","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("65","tax_category","3","707","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("66","tax_category","4","708","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("67","tax_category","5","709","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("68","tax_category","6","710","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("69","tax_nav_menu","14","725","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("70","tax_portfolio_category","7","726","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("71","tax_portfolio_category","9","727","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("72","tax_portfolio_category","10","728","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("73","tax_portfolio_category","13","729","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("74","tax_portfolio_skills","8","730","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("75","tax_portfolio_skills","11","731","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("76","tax_portfolio_skills","12","732","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("77","tax_slide-page","15","733","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("78","tax_slide-page","16","734","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("79","tax_slide-page","17","735","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("80","tax_slide-page","18","736","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("81","tax_slide-page","19","737","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("82","tax_slide-page","20","738","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("83","tax_slide-page","21","739","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("84","tax_slide-page","22","740","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("85","tax_slide-page","23","741","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("86","tax_slide-page","24","742","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("87","tax_slide-page","25","743","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("88","tax_slide-page","26","744","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("89","tax_slide-page","27","745","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("90","tax_slide-page","28","746","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("91","tax_slide-page","29","747","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("92","tax_slide-page","30","748","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("93","tax_slide-page","31","749","fa","");
INSERT INTO `a3rfa_icl_translations` VALUES("94","tax_category","32","705","en","fa");


DROP TABLE IF EXISTS `a3rfa_links`;

CREATE TABLE `a3rfa_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;



DROP TABLE IF EXISTS `a3rfa_options`;

CREATE TABLE `a3rfa_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=19007 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_options` VALUES("1","siteurl","http://demo.iranavada.ir/architecture","yes");
INSERT INTO `a3rfa_options` VALUES("2","home","http://demo.iranavada.ir/architecture","yes");
INSERT INTO `a3rfa_options` VALUES("3","blogname","IranAvada Architecture","yes");
INSERT INTO `a3rfa_options` VALUES("4","blogdescription","قدرتمندترین قالب وردپرس تا به امروز","yes");
INSERT INTO `a3rfa_options` VALUES("5","users_can_register","0","yes");
INSERT INTO `a3rfa_options` VALUES("6","admin_email","YourEmail@yahoo.com","yes");
INSERT INTO `a3rfa_options` VALUES("7","start_of_week","6","yes");
INSERT INTO `a3rfa_options` VALUES("8","use_balanceTags","0","yes");
INSERT INTO `a3rfa_options` VALUES("9","use_smilies","1","yes");
INSERT INTO `a3rfa_options` VALUES("10","require_name_email","1","yes");
INSERT INTO `a3rfa_options` VALUES("11","comments_notify","1","yes");
INSERT INTO `a3rfa_options` VALUES("12","posts_per_rss","10","yes");
INSERT INTO `a3rfa_options` VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO `a3rfa_options` VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO `a3rfa_options` VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO `a3rfa_options` VALUES("16","mailserver_pass","password","yes");
INSERT INTO `a3rfa_options` VALUES("17","mailserver_port","110","yes");
INSERT INTO `a3rfa_options` VALUES("18","default_category","1","yes");
INSERT INTO `a3rfa_options` VALUES("19","default_comment_status","open","yes");
INSERT INTO `a3rfa_options` VALUES("20","default_ping_status","open","yes");
INSERT INTO `a3rfa_options` VALUES("21","default_pingback_flag","1","yes");
INSERT INTO `a3rfa_options` VALUES("22","posts_per_page","10","yes");
INSERT INTO `a3rfa_options` VALUES("23","date_format","F j, Y","yes");
INSERT INTO `a3rfa_options` VALUES("24","time_format","g:i a","yes");
INSERT INTO `a3rfa_options` VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO `a3rfa_options` VALUES("26","comment_moderation","0","yes");
INSERT INTO `a3rfa_options` VALUES("27","moderation_notify","1","yes");
INSERT INTO `a3rfa_options` VALUES("28","permalink_structure","/%postname%/","yes");
INSERT INTO `a3rfa_options` VALUES("29","rewrite_rules","a:280:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"portfolio/?$\";s:35:\"index.php?post_type=avada_portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=avada_portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=avada_portfolio&paged=$matches[1]\";s:12:\"faq-items/?$\";s:29:\"index.php?post_type=avada_faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=avada_faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=avada_faq&paged=$matches[1]\";s:44:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"fusion_tb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"fusion_tb_layout/([^/]+)/embed/?$\";s:49:\"index.php?fusion_tb_layout=$matches[1]&embed=true\";s:37:\"fusion_tb_layout/([^/]+)/trackback/?$\";s:43:\"index.php?fusion_tb_layout=$matches[1]&tb=1\";s:45:\"fusion_tb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&paged=$matches[2]\";s:52:\"fusion_tb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?fusion_tb_layout=$matches[1]&cpage=$matches[2]\";s:41:\"fusion_tb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?fusion_tb_layout=$matches[1]&page=$matches[2]\";s:33:\"fusion_tb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"fusion_tb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"fusion_tb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"fusion_tb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_tb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"fusion_tb_section/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"fusion_tb_section/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"fusion_tb_section/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"fusion_tb_section/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"fusion_tb_section/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"fusion_tb_section/([^/]+)/embed/?$\";s:50:\"index.php?fusion_tb_section=$matches[1]&embed=true\";s:38:\"fusion_tb_section/([^/]+)/trackback/?$\";s:44:\"index.php?fusion_tb_section=$matches[1]&tb=1\";s:46:\"fusion_tb_section/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&paged=$matches[2]\";s:53:\"fusion_tb_section/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?fusion_tb_section=$matches[1]&cpage=$matches[2]\";s:42:\"fusion_tb_section/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?fusion_tb_section=$matches[1]&page=$matches[2]\";s:34:\"fusion_tb_section/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"fusion_tb_section/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"fusion_tb_section/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"fusion_tb_section/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_tb_section/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"fusion_tb_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\";s:54:\"fusion_tb_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?fusion_tb_category=$matches[1]&feed=$matches[2]\";s:35:\"fusion_tb_category/([^/]+)/embed/?$\";s:51:\"index.php?fusion_tb_category=$matches[1]&embed=true\";s:47:\"fusion_tb_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?fusion_tb_category=$matches[1]&paged=$matches[2]\";s:29:\"fusion_tb_category/([^/]+)/?$\";s:40:\"index.php?fusion_tb_category=$matches[1]\";s:39:\"fusion_form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"fusion_form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"fusion_form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"fusion_form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"fusion_form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"fusion_form/([^/]+)/embed/?$\";s:44:\"index.php?fusion_form=$matches[1]&embed=true\";s:32:\"fusion_form/([^/]+)/trackback/?$\";s:38:\"index.php?fusion_form=$matches[1]&tb=1\";s:40:\"fusion_form/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&paged=$matches[2]\";s:47:\"fusion_form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?fusion_form=$matches[1]&cpage=$matches[2]\";s:36:\"fusion_form/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?fusion_form=$matches[1]&page=$matches[2]\";s:28:\"fusion_form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"fusion_form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"fusion_form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"fusion_form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"fusion_form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:48:\"index.php?avada_portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:42:\"index.php?avada_portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?avada_portfolio=$matches[1]&cpage=$matches[2]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?avada_portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:57:\"portfolio_skills/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:52:\"portfolio_skills/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?portfolio_skills=$matches[1]&feed=$matches[2]\";s:33:\"portfolio_skills/([^/]+)/embed/?$\";s:49:\"index.php?portfolio_skills=$matches[1]&embed=true\";s:45:\"portfolio_skills/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?portfolio_skills=$matches[1]&paged=$matches[2]\";s:27:\"portfolio_skills/([^/]+)/?$\";s:38:\"index.php?portfolio_skills=$matches[1]\";s:55:\"portfolio_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:50:\"portfolio_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?portfolio_tags=$matches[1]&feed=$matches[2]\";s:31:\"portfolio_tags/([^/]+)/embed/?$\";s:47:\"index.php?portfolio_tags=$matches[1]&embed=true\";s:43:\"portfolio_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?portfolio_tags=$matches[1]&paged=$matches[2]\";s:25:\"portfolio_tags/([^/]+)/?$\";s:36:\"index.php?portfolio_tags=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"faq-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"faq-items/([^/]+)/embed/?$\";s:42:\"index.php?avada_faq=$matches[1]&embed=true\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:36:\"index.php?avada_faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?avada_faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?avada_faq=$matches[1]&cpage=$matches[2]\";s:34:\"faq-items/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?avada_faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"faq-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:29:\"faq_category/([^/]+)/embed/?$\";s:45:\"index.php?faq_category=$matches[1]&embed=true\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:33:\"slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"slide/([^/]+)/embed/?$\";s:38:\"index.php?slide=$matches[1]&embed=true\";s:26:\"slide/([^/]+)/trackback/?$\";s:32:\"index.php?slide=$matches[1]&tb=1\";s:34:\"slide/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&paged=$matches[2]\";s:41:\"slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:45:\"index.php?slide=$matches[1]&cpage=$matches[2]\";s:30:\"slide/([^/]+)(?:/([0-9]+))?/?$\";s:44:\"index.php?slide=$matches[1]&page=$matches[2]\";s:22:\"slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:51:\"slide-page/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?slide-page=$matches[1]&feed=$matches[2]\";s:46:\"slide-page/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?slide-page=$matches[1]&feed=$matches[2]\";s:27:\"slide-page/([^/]+)/embed/?$\";s:43:\"index.php?slide-page=$matches[1]&embed=true\";s:39:\"slide-page/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?slide-page=$matches[1]&paged=$matches[2]\";s:21:\"slide-page/([^/]+)/?$\";s:32:\"index.php?slide-page=$matches[1]\";s:43:\"fusion_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"fusion_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"fusion_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"fusion_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"fusion_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"fusion_template/([^/]+)/embed/?$\";s:48:\"index.php?fusion_template=$matches[1]&embed=true\";s:36:\"fusion_template/([^/]+)/trackback/?$\";s:42:\"index.php?fusion_template=$matches[1]&tb=1\";s:44:\"fusion_template/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&paged=$matches[2]\";s:51:\"fusion_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?fusion_template=$matches[1]&cpage=$matches[2]\";s:40:\"fusion_template/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?fusion_template=$matches[1]&page=$matches[2]\";s:32:\"fusion_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"fusion_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"fusion_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"fusion_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"fusion_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"fusion_element/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"fusion_element/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"fusion_element/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"fusion_element/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"fusion_element/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"fusion_element/([^/]+)/embed/?$\";s:47:\"index.php?fusion_element=$matches[1]&embed=true\";s:35:\"fusion_element/([^/]+)/trackback/?$\";s:41:\"index.php?fusion_element=$matches[1]&tb=1\";s:43:\"fusion_element/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&paged=$matches[2]\";s:50:\"fusion_element/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?fusion_element=$matches[1]&cpage=$matches[2]\";s:39:\"fusion_element/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?fusion_element=$matches[1]&page=$matches[2]\";s:31:\"fusion_element/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"fusion_element/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"fusion_element/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"fusion_element/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"fusion_element/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"element_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?element_category=$matches[1]&feed=$matches[2]\";s:52:\"element_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?element_category=$matches[1]&feed=$matches[2]\";s:33:\"element_category/([^/]+)/embed/?$\";s:49:\"index.php?element_category=$matches[1]&embed=true\";s:45:\"element_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?element_category=$matches[1]&paged=$matches[2]\";s:27:\"element_category/([^/]+)/?$\";s:38:\"index.php?element_category=$matches[1]\";s:58:\"template_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?template_category=$matches[1]&feed=$matches[2]\";s:53:\"template_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?template_category=$matches[1]&feed=$matches[2]\";s:34:\"template_category/([^/]+)/embed/?$\";s:50:\"index.php?template_category=$matches[1]&embed=true\";s:46:\"template_category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?template_category=$matches[1]&paged=$matches[2]\";s:28:\"template_category/([^/]+)/?$\";s:39:\"index.php?template_category=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=7&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes");
INSERT INTO `a3rfa_options` VALUES("30","hack_file","0","yes");
INSERT INTO `a3rfa_options` VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO `a3rfa_options` VALUES("32","moderation_keys","","no");
INSERT INTO `a3rfa_options` VALUES("33","active_plugins","a:4:{i:0;s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";i:2;s:33:\"fusion-builder/fusion-builder.php\";i:3;s:27:\"fusion-core/fusion-core.php\";i:4;s:23:\"wp-jalali/wp-jalali.php\";}","yes");
INSERT INTO `a3rfa_options` VALUES("34","category_base","","yes");
INSERT INTO `a3rfa_options` VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `a3rfa_options` VALUES("36","comment_max_links","2","yes");
INSERT INTO `a3rfa_options` VALUES("37","gmt_offset","","yes");
INSERT INTO `a3rfa_options` VALUES("38","default_email_category","1","yes");
INSERT INTO `a3rfa_options` VALUES("39","recently_edited","","no");
INSERT INTO `a3rfa_options` VALUES("40","template","IranAvada","yes");
INSERT INTO `a3rfa_options` VALUES("41","stylesheet","IranAvada-Child","yes");
INSERT INTO `a3rfa_options` VALUES("15539","finished_updating_comment_type","1","yes");
INSERT INTO `a3rfa_options` VALUES("44","comment_registration","0","yes");
INSERT INTO `a3rfa_options` VALUES("45","html_type","text/html","yes");
INSERT INTO `a3rfa_options` VALUES("46","use_trackback","0","yes");
INSERT INTO `a3rfa_options` VALUES("47","default_role","subscriber","yes");
INSERT INTO `a3rfa_options` VALUES("48","db_version","51917","yes");
INSERT INTO `a3rfa_options` VALUES("49","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `a3rfa_options` VALUES("50","upload_path","","yes");
INSERT INTO `a3rfa_options` VALUES("51","blog_public","0","yes");
INSERT INTO `a3rfa_options` VALUES("52","default_link_category","2","yes");
INSERT INTO `a3rfa_options` VALUES("53","show_on_front","page","yes");
INSERT INTO `a3rfa_options` VALUES("54","tag_base","","yes");
INSERT INTO `a3rfa_options` VALUES("55","show_avatars","1","yes");
INSERT INTO `a3rfa_options` VALUES("56","avatar_rating","G","yes");
INSERT INTO `a3rfa_options` VALUES("57","upload_url_path","","yes");
INSERT INTO `a3rfa_options` VALUES("58","thumbnail_size_w","150","yes");
INSERT INTO `a3rfa_options` VALUES("59","thumbnail_size_h","150","yes");
INSERT INTO `a3rfa_options` VALUES("60","thumbnail_crop","1","yes");
INSERT INTO `a3rfa_options` VALUES("61","medium_size_w","300","yes");
INSERT INTO `a3rfa_options` VALUES("62","medium_size_h","300","yes");
INSERT INTO `a3rfa_options` VALUES("63","avatar_default","mystery","yes");
INSERT INTO `a3rfa_options` VALUES("64","large_size_w","1024","yes");
INSERT INTO `a3rfa_options` VALUES("65","large_size_h","1024","yes");
INSERT INTO `a3rfa_options` VALUES("66","image_default_link_type","none","yes");
INSERT INTO `a3rfa_options` VALUES("67","image_default_size","","yes");
INSERT INTO `a3rfa_options` VALUES("68","image_default_align","","yes");
INSERT INTO `a3rfa_options` VALUES("69","close_comments_for_old_posts","0","yes");
INSERT INTO `a3rfa_options` VALUES("70","close_comments_days_old","14","yes");
INSERT INTO `a3rfa_options` VALUES("71","thread_comments","1","yes");
INSERT INTO `a3rfa_options` VALUES("72","thread_comments_depth","5","yes");
INSERT INTO `a3rfa_options` VALUES("73","page_comments","0","yes");
INSERT INTO `a3rfa_options` VALUES("74","comments_per_page","50","yes");
INSERT INTO `a3rfa_options` VALUES("75","default_comments_page","newest","yes");
INSERT INTO `a3rfa_options` VALUES("76","comment_order","asc","yes");
INSERT INTO `a3rfa_options` VALUES("77","sticky_posts","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("78","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("79","widget_text","a:3:{i:3;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:447:\"[fusion_imageframe lightbox=\"no\" lightbox_image=\"\" style_type=\"none\" hover_type=\"liftup\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"http://iranavada.ir\" linktarget=\"_blank\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" hide_on_mobile=\"no\" class=\"\" id=\"\"] <img src=\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/sidebar_ad.jpg\" alt=\"themeforest\" />[/fusion_imageframe]\";s:6:\"filter\";b:1;s:6:\"visual\";b:1;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}i:4;a:12:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:2877:\"[fusion_button link=\"\" color=\"custom\" size=\"large\" type=\"\" shape=\"\" target=\"_self\" title=\"\" gradient_colors=\"#2b2e35\" gradient_hover_colors=\"#2f333a\" accent_color=\"#fff\" accent_hover_color=\"#fff\" bevel_color=\"\" border_width=\"0px\" icon=\"\" icon_position=\"left\" icon_divider=\"no\" modal=\"contact\" animation_type=\"0\" animation_direction=\"left\" animation_speed=\"1\" alignment=\"right\" class=\"\" id=\"\"]با ما تماس بگیرید[/fusion_button]



[fusion_modal name=\"contact\" title=\"\" size=\"large\" background=\"#373d4d\" border_color=\"#31343c\" show_footer=\"no\" class=\"\" id=\"\"][fusion_builder_container background_color=\"\" background_image=\"\" background_parallax=\"left\" enable_mobile=\"no\" parallax_speed=\"0.7\" background_repeat=\"no-repeat\" background_position=\"center center\" video_url=\"\" video_aspect_ratio=\"16:9\" video_webm=\"\" video_mp4=\"\" video_ogv=\"\" video_preview_image=\"\" overlay_color=\"\" overlay_opacity=\"0.5\" video_mute=\"yes\" video_loop=\"yes\" fade=\"no\" border_size=\"0px\" border_color=\"transparent\" border_style=\"solid\" padding_top=\"\" padding_bottom=\"\" padding_left=\"\" padding_right=\"\" hundred_percent=\"no\" equal_height_columns=\"no\" hide_on_mobile=\"no\" menu_anchor=\"\" class=\"\" id=\"\"][fusion_builder_row][fusion_builder_column type=\"2_5\" last=\"no\" class=\"\" id=\"\"]

[fusion_separator style_type=\"none\" top_margin=\"25\" bottom_margin=\"0\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"]

[fusion_imageframe lightbox=\"no\" style_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" class=\"\" id=\"\"]<img src=\"http://avada.theme-fusion.com/architecture/wp-content/uploads/sites/21/2015/02/logo-avada-architect-retina.png\" alt=\"\" />[/fusion_imageframe]

[fusion_separator style_type=\"none\" top_margin=\"25\" bottom_margin=\"0\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"]

[fusion_imageframe lightbox=\"no\" lightbox_image=\"\" style_type=\"none\" hover_type=\"none\" bordercolor=\"\" bordersize=\"0px\" borderradius=\"0\" stylecolor=\"\" align=\"none\" link=\"\" linktarget=\"_self\" animation_type=\"0\" animation_direction=\"down\" animation_speed=\"0.1\" hide_on_mobile=\"no\" class=\"\" id=\"\"] <img alt=\"\" src=\"http://avada.theme-fusion.com/architecture/wp-content/uploads/sites/21/2015/02/image10.jpg\" />[/fusion_imageframe]

[fusion_separator style_type=\"none\" top_margin=\"5\" bottom_margin=\"5\" sep_color=\"\" icon=\"\" width=\"\" class=\"\" id=\"\"]

<p style=\"color: #fff;\">لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است. 
</p>
[/fusion_builder_column]

[fusion_builder_column type=\"3_5\" last=\"yes\" class=\"\" id=\"\"]
[contact-form-7 id=\"413\" title=\"Contact Form Popup\"]
[/fusion_builder_column][/fusion_builder_row][/fusion_builder_container][/fusion_modal]\";s:6:\"filter\";b:0;s:6:\"visual\";b:0;s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("80","widget_rss","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("81","uninstall_plugins","a:1:{s:29:\"z-wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";}","no");
INSERT INTO `a3rfa_options` VALUES("82","timezone_string","Atlantic/Azores","yes");
INSERT INTO `a3rfa_options` VALUES("83","page_for_posts","0","yes");
INSERT INTO `a3rfa_options` VALUES("84","page_on_front","7","yes");
INSERT INTO `a3rfa_options` VALUES("85","default_post_format","0","yes");
INSERT INTO `a3rfa_options` VALUES("86","link_manager_enabled","0","yes");
INSERT INTO `a3rfa_options` VALUES("87","finished_splitting_shared_terms","1","yes");
INSERT INTO `a3rfa_options` VALUES("88","site_icon","0","yes");
INSERT INTO `a3rfa_options` VALUES("89","medium_large_size_w","768","yes");
INSERT INTO `a3rfa_options` VALUES("90","medium_large_size_h","0","yes");
INSERT INTO `a3rfa_options` VALUES("91","initial_db_version","38590","yes");
INSERT INTO `a3rfa_options` VALUES("92","a3rfa_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:76:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:34:\"wpml_manage_translation_management\";b:1;s:21:\"wpml_manage_languages\";b:1;s:41:\"wpml_manage_theme_and_plugin_localization\";b:1;s:19:\"wpml_manage_support\";b:1;s:36:\"wpml_manage_woocommerce_multilingual\";b:1;s:37:\"wpml_operate_woocommerce_multilingual\";b:1;s:29:\"wpml_manage_media_translation\";b:1;s:22:\"wpml_manage_navigation\";b:1;s:24:\"wpml_manage_sticky_links\";b:1;s:30:\"wpml_manage_string_translation\";b:1;s:33:\"wpml_manage_translation_analytics\";b:1;s:25:\"wpml_manage_wp_menus_sync\";b:1;s:32:\"wpml_manage_taxonomy_translation\";b:1;s:27:\"wpml_manage_troubleshooting\";b:1;s:31:\"wpml_manage_translation_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO `a3rfa_options` VALUES("93","fresh_site","0","yes");
INSERT INTO `a3rfa_options` VALUES("94","WPLANG","fa_IR","yes");
INSERT INTO `a3rfa_options` VALUES("95","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("96","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("97","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("98","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("99","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("100","sidebars_widgets","a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:12:\"categories-2\";i:3;s:6:\"text-3\";i:4;s:21:\"recent_works-widget-2\";}s:21:\"avada-footer-widget-1\";a:1:{i:0;s:21:\"social_links-widget-2\";}s:21:\"avada-footer-widget-2\";a:1:{i:0;s:6:\"text-4\";}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `a3rfa_options` VALUES("101","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("102","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("103","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("104","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("105","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("106","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("107","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("108","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("109","cron","a:13:{i:1666344057;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1666344624;a:1:{s:21:\"wpo_plugin_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1666351404;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1666357425;a:1:{s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1666362384;a:1:{s:23:\"aiowps_daily_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1666387451;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1666388637;a:1:{s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1666391425;a:1:{s:29:\"wpo_smush_clear_backup_images\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1666393225;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1666527534;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1666527984;a:1:{s:24:\"aiowps_hourly_cron_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1666875825;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `a3rfa_options` VALUES("110","theme_mods_twentyseventeen","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1512595513;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO `a3rfa_options` VALUES("153","widget_flickr-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("4706","db_upgraded","","yes");
INSERT INTO `a3rfa_options` VALUES("148","widget_ad_125_125-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("149","widget_contact_info-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("150","widget_pyre_tabs-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("151","widget_recent_works-widget","a:2:{i:2;a:10:{s:5:\"title\";s:28:\"نمونه‌های اخیر\";s:6:\"number\";s:1:\"9\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("152","widget_tweets-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("144","current_theme","Avada Child","yes");
INSERT INTO `a3rfa_options` VALUES("215","fusion_builder_version","3.6.1","yes");
INSERT INTO `a3rfa_options` VALUES("216","fusion_core_version","5.6.1","yes");
INSERT INTO `a3rfa_options` VALUES("136","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:19:\"YourEmail@yahoo.com\";s:7:\"version\";s:5:\"5.9.5\";s:9:\"timestamp\";i:1666079772;}","no");
INSERT INTO `a3rfa_options` VALUES("145","theme_mods_IranAvada-Child-Theme","a:4:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:1:{s:15:\"main_navigation\";i:14;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1647124848;s:4:\"data\";a:6:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:5:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:12:\"categories-2\";i:3;s:6:\"text-3\";i:4;s:21:\"recent_works-widget-2\";}s:21:\"avada-footer-widget-1\";a:1:{i:0;s:21:\"social_links-widget-2\";}s:21:\"avada-footer-widget-2\";a:1:{i:0;s:6:\"text-4\";}s:25:\"avada-slidingbar-widget-1\";a:0:{}s:25:\"avada-slidingbar-widget-2\";a:0:{}}}}","yes");
INSERT INTO `a3rfa_options` VALUES("146","theme_switched","","yes");
INSERT INTO `a3rfa_options` VALUES("147","avada_version","7.6.1","yes");
INSERT INTO `a3rfa_options` VALUES("154","widget_social_links-widget","a:2:{i:2;a:48:{s:5:\"title\";s:0:\"\";s:10:\"linktarget\";s:0:\"\";s:15:\"icons_font_size\";s:4:\"18px\";s:10:\"icon_color\";s:7:\"#828c8e\";s:10:\"boxed_icon\";s:3:\"Yes\";s:11:\"boxed_color\";s:7:\"#2b2e35\";s:10:\"color_type\";s:6:\"custom\";s:17:\"boxed_icon_radius\";s:3:\"50%\";s:18:\"boxed_icon_padding\";s:4:\"12px\";s:11:\"tooltip_pos\";s:3:\"Top\";s:11:\"show_custom\";s:2:\"No\";s:7:\"fb_link\";s:1:\"#\";s:11:\"flickr_link\";s:0:\"\";s:8:\"rss_link\";s:1:\"#\";s:12:\"twitter_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:12:\"youtube_link\";s:0:\"\";s:14:\"instagram_link\";s:0:\"\";s:14:\"pinterest_link\";s:0:\"\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:9:\"digg_link\";s:0:\"\";s:13:\"linkedin_link\";s:1:\"#\";s:12:\"blogger_link\";s:0:\"\";s:10:\"skype_link\";s:0:\"\";s:11:\"forrst_link\";s:0:\"\";s:12:\"myspace_link\";s:0:\"\";s:15:\"deviantart_link\";s:0:\"\";s:10:\"yahoo_link\";s:0:\"\";s:11:\"reddit_link\";s:0:\"\";s:11:\"paypal_link\";s:0:\"\";s:12:\"dropbox_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:9:\"xing_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:10:\"email_link\";s:0:\"\";s:6:\"use_to\";s:2:\"No\";s:20:\"fusion_padding_color\";s:0:\"\";s:15:\"fusion_bg_color\";s:0:\"\";s:21:\"fusion_bg_radius_size\";s:0:\"\";s:18:\"fusion_border_size\";s:0:\"\";s:19:\"fusion_border_style\";s:0:\"\";s:19:\"fusion_border_color\";s:0:\"\";s:12:\"fusion_align\";s:0:\"\";s:19:\"fusion_align_mobile\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("155","widget_facebook-like-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("156","widget_menu-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("157","widget_avada-vertical-menu-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("227","fusion_supported_plugins_active","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("4884","avada_page_options","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("4714","fusion_dynamic_css_ids","a:18:{i:7;s:32:\"ba6eac19f80a99d44896bc0d2fe5fd1e\";i:555;s:32:\"cbe43932c4959fc52fa8de47f3fd5376\";i:9;s:32:\"ba6eac19f80a99d44896bc0d2fe5fd1e\";i:645;s:32:\"cbe43932c4959fc52fa8de47f3fd5376\";i:13;s:32:\"ba6eac19f80a99d44896bc0d2fe5fd1e\";i:444;s:32:\"da5f5cc36c05196b1e59414a5e1f1a9e\";i:15;s:32:\"ba6eac19f80a99d44896bc0d2fe5fd1e\";i:11;s:32:\"ba6eac19f80a99d44896bc0d2fe5fd1e\";i:177;s:32:\"f04f0a497575648fabd6835298bb1eeb\";i:639;s:32:\"cbe43932c4959fc52fa8de47f3fd5376\";i:643;s:32:\"cbe43932c4959fc52fa8de47f3fd5376\";i:478;s:32:\"b6e24c0bc383ee10896ba88146a04bfc\";i:172;s:32:\"f04f0a497575648fabd6835298bb1eeb\";i:641;s:32:\"cbe43932c4959fc52fa8de47f3fd5376\";i:170;s:32:\"f04f0a497575648fabd6835298bb1eeb\";s:9:\"7-archive\";s:32:\"70d04539b0525ff04999b6e3f64527a8\";s:10:\"10-archive\";s:32:\"70d04539b0525ff04999b6e3f64527a8\";i:175;s:32:\"f04f0a497575648fabd6835298bb1eeb\";}","yes");
INSERT INTO `a3rfa_options` VALUES("15546","https_detection_errors","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("252","fusion_dynamic_css_time","1613384520","yes");
INSERT INTO `a3rfa_options` VALUES("339","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("160","shop_catalog_image_size","a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO `a3rfa_options` VALUES("161","shop_single_image_size","a:3:{s:5:\"width\";i:700;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO `a3rfa_options` VALUES("162","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:120;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO `a3rfa_options` VALUES("163","fusion_dynamic_css_posts","a:18:{i:7;b:1;i:555;b:1;i:9;b:1;i:645;b:1;i:13;b:1;i:444;b:1;i:15;b:1;i:11;b:1;i:177;b:1;i:639;b:1;i:643;b:1;i:478;b:1;i:172;b:1;i:641;b:1;i:170;b:1;s:9:\"7-archive\";b:1;s:10:\"10-archive\";b:1;i:175;b:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("202","recently_activated","a:1:{s:25:\"duplicator/duplicator.php\";i:1647125273;}","yes");
INSERT INTO `a3rfa_options` VALUES("16672","duplicator_settings","a:15:{s:7:\"version\";s:6:\"1.3.28\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("359","fusion_options-transients","a:2:{s:14:\"changed_values\";a:0:{}s:9:\"last_save\";i:1647125087;}","yes");
INSERT INTO `a3rfa_options` VALUES("356","avada_permalinks","a:3:{s:23:\"portfolio_category_base\";s:0:\"\";s:21:\"portfolio_skills_base\";s:0:\"\";s:19:\"portfolio_tags_base\";s:0:\"\";}","yes");
INSERT INTO `a3rfa_options` VALUES("274","fusion_demo_history","a:1:{s:12:\"architecture\";a:11:{s:5:\"terms\";a:13:{i:0;a:2:{s:7:\"term_id\";i:2;s:8:\"taxonomy\";s:8:\"category\";}i:1;a:2:{s:7:\"term_id\";i:3;s:8:\"taxonomy\";s:8:\"category\";}i:2;a:2:{s:7:\"term_id\";i:4;s:8:\"taxonomy\";s:8:\"category\";}i:3;a:2:{s:7:\"term_id\";i:5;s:8:\"taxonomy\";s:8:\"category\";}i:4;a:2:{s:7:\"term_id\";i:6;s:8:\"taxonomy\";s:8:\"category\";}i:5;a:2:{s:7:\"term_id\";i:7;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:6;a:2:{s:7:\"term_id\";i:8;s:8:\"taxonomy\";s:16:\"portfolio_skills\";}i:7;a:2:{s:7:\"term_id\";i:9;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:8;a:2:{s:7:\"term_id\";i:10;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:9;a:2:{s:7:\"term_id\";i:11;s:8:\"taxonomy\";s:16:\"portfolio_skills\";}i:10;a:2:{s:7:\"term_id\";i:12;s:8:\"taxonomy\";s:16:\"portfolio_skills\";}i:11;a:2:{s:7:\"term_id\";i:13;s:8:\"taxonomy\";s:18:\"portfolio_category\";}i:12;a:2:{s:7:\"term_id\";i:14;s:8:\"taxonomy\";s:8:\"nav_menu\";}}s:14:\"fusion_sliders\";a:17:{i:0;a:2:{s:7:\"term_id\";i:15;s:8:\"taxonomy\";s:10:\"slide-page\";}i:1;a:2:{s:7:\"term_id\";i:16;s:8:\"taxonomy\";s:10:\"slide-page\";}i:2;a:2:{s:7:\"term_id\";i:17;s:8:\"taxonomy\";s:10:\"slide-page\";}i:3;a:2:{s:7:\"term_id\";i:18;s:8:\"taxonomy\";s:10:\"slide-page\";}i:4;a:2:{s:7:\"term_id\";i:19;s:8:\"taxonomy\";s:10:\"slide-page\";}i:5;a:2:{s:7:\"term_id\";i:20;s:8:\"taxonomy\";s:10:\"slide-page\";}i:6;a:2:{s:7:\"term_id\";i:21;s:8:\"taxonomy\";s:10:\"slide-page\";}i:7;a:2:{s:7:\"term_id\";i:22;s:8:\"taxonomy\";s:10:\"slide-page\";}i:8;a:2:{s:7:\"term_id\";i:23;s:8:\"taxonomy\";s:10:\"slide-page\";}i:9;a:2:{s:7:\"term_id\";i:24;s:8:\"taxonomy\";s:10:\"slide-page\";}i:10;a:2:{s:7:\"term_id\";i:25;s:8:\"taxonomy\";s:10:\"slide-page\";}i:11;a:2:{s:7:\"term_id\";i:26;s:8:\"taxonomy\";s:10:\"slide-page\";}i:12;a:2:{s:7:\"term_id\";i:27;s:8:\"taxonomy\";s:10:\"slide-page\";}i:13;a:2:{s:7:\"term_id\";i:28;s:8:\"taxonomy\";s:10:\"slide-page\";}i:14;a:2:{s:7:\"term_id\";i:29;s:8:\"taxonomy\";s:10:\"slide-page\";}i:15;a:2:{s:7:\"term_id\";i:30;s:8:\"taxonomy\";s:10:\"slide-page\";}i:16;a:2:{s:7:\"term_id\";i:31;s:8:\"taxonomy\";s:10:\"slide-page\";}}s:13:\"theme_options\";b:0;s:7:\"widgets\";a:26:{i:0;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"148\";s:11:\"option_name\";s:24:\"widget_ad_125_125-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:1;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"98\";s:11:\"option_name\";s:15:\"widget_archives\";s:12:\"option_value\";s:94:\"a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:2;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"157\";s:11:\"option_name\";s:33:\"widget_avada-vertical-menu-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:3;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"102\";s:11:\"option_name\";s:15:\"widget_calendar\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:4;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"78\";s:11:\"option_name\";s:17:\"widget_categories\";s:12:\"option_value\";s:118:\"a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:5;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"149\";s:11:\"option_name\";s:26:\"widget_contact_info-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:6;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"108\";s:11:\"option_name\";s:18:\"widget_custom_html\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:7;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"155\";s:11:\"option_name\";s:27:\"widget_facebook-like-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:8;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"153\";s:11:\"option_name\";s:20:\"widget_flickr-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:9;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"103\";s:11:\"option_name\";s:18:\"widget_media_audio\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:10;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"104\";s:11:\"option_name\";s:18:\"widget_media_image\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:11;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"105\";s:11:\"option_name\";s:18:\"widget_media_video\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:12;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"156\";s:11:\"option_name\";s:18:\"widget_menu-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:13;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"99\";s:11:\"option_name\";s:11:\"widget_meta\";s:12:\"option_value\";s:59:\"a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:14;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"107\";s:11:\"option_name\";s:15:\"widget_nav_menu\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:15;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"101\";s:11:\"option_name\";s:12:\"widget_pages\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:16;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"150\";s:11:\"option_name\";s:23:\"widget_pyre_tabs-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:17;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"151\";s:11:\"option_name\";s:26:\"widget_recent_works-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:18;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"97\";s:11:\"option_name\";s:22:\"widget_recent-comments\";s:12:\"option_value\";s:76:\"a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:19;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"96\";s:11:\"option_name\";s:19:\"widget_recent-posts\";s:12:\"option_value\";s:76:\"a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:20;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"80\";s:11:\"option_name\";s:10:\"widget_rss\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:21;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"95\";s:11:\"option_name\";s:13:\"widget_search\";s:12:\"option_value\";s:59:\"a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:22;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"154\";s:11:\"option_name\";s:26:\"widget_social_links-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:23;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"106\";s:11:\"option_name\";s:16:\"widget_tag_cloud\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}i:24;O:8:\"stdClass\":4:{s:9:\"option_id\";s:2:\"79\";s:11:\"option_name\";s:11:\"widget_text\";s:12:\"option_value\";s:6:\"a:0:{}\";s:8:\"autoload\";s:3:\"yes\";}i:25;O:8:\"stdClass\":4:{s:9:\"option_id\";s:3:\"152\";s:11:\"option_name\";s:20:\"widget_tweets-widget\";s:12:\"option_value\";s:30:\"a:1:{s:12:\"_multiwidget\";i:1;}\";s:8:\"autoload\";s:3:\"yes\";}}s:16:\"sidebars_widgets\";a:11:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"avada-footer-widget-1\";a:0:{}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";N;s:21:\"avada-footer-widget-4\";N;s:25:\"avada-slidingbar-widget-1\";N;s:25:\"avada-slidingbar-widget-2\";N;s:25:\"avada-slidingbar-widget-3\";N;s:25:\"avada-slidingbar-widget-4\";N;s:13:\"array_version\";i:3;}s:12:\"sbg_sidebars\";b:0;s:8:\"blogname\";s:22:\"IranAvada Architecture\";s:13:\"page_on_front\";s:1:\"0\";s:13:\"show_on_front\";s:5:\"posts\";s:18:\"nav_menu_locations\";b:0;s:12:\"general_data\";s:8:\"imported\";}}","no");
INSERT INTO `a3rfa_options` VALUES("275","fusion_import_data","a:13:{s:4:\"post\";a:1:{i:0;s:12:\"architecture\";}s:4:\"page\";a:1:{i:0;s:12:\"architecture\";}s:15:\"avada_portfolio\";a:1:{i:0;s:12:\"architecture\";}s:9:\"avada_faq\";a:0:{}s:10:\"attachment\";a:1:{i:0;s:12:\"architecture\";}s:7:\"product\";a:0:{}s:5:\"event\";a:0:{}s:5:\"forum\";a:0:{}s:7:\"sliders\";a:1:{i:0;s:12:\"architecture\";}s:7:\"widgets\";a:1:{i:0;s:12:\"architecture\";}s:13:\"theme_options\";a:1:{i:0;s:12:\"architecture\";}s:12:\"general_data\";a:1:{i:0;s:12:\"architecture\";}s:3:\"all\";a:1:{i:0;s:12:\"architecture\";}}","no");
INSERT INTO `a3rfa_options` VALUES("929","category_children_","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("289","element_category_children","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("290","template_category_children","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("376","avada_disable_encoding","0","yes");
INSERT INTO `a3rfa_options` VALUES("308","fusion_options","a:973:{s:8:\"last_tab\";s:0:\"\";s:6:\"layout\";s:4:\"wide\";s:10:\"site_width\";s:6:\"1170px\";s:13:\"margin_offset\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";}s:13:\"scroll_offset\";s:4:\"full\";s:18:\"boxed_modal_shadow\";s:4:\"none\";s:12:\"main_padding\";a:2:{s:3:\"top\";s:4:\"90px\";s:6:\"bottom\";s:4:\"45px\";}s:16:\"hundredp_padding\";s:4:\"40px\";s:13:\"sidebar_width\";s:3:\"25%\";s:14:\"sidebar_gutter\";s:4:\"80px\";s:17:\"sidebar_2_1_width\";s:3:\"21%\";s:17:\"sidebar_2_2_width\";s:3:\"21%\";s:19:\"dual_sidebar_gutter\";s:4:\"40px\";s:10:\"responsive\";s:1:\"1\";s:21:\"grid_main_break_point\";s:4:\"1099\";s:23:\"side_header_break_point\";s:3:\"920\";s:19:\"content_break_point\";s:3:\"800\";s:19:\"sidebar_break_point\";s:3:\"800\";s:11:\"mobile_zoom\";s:1:\"1\";s:16:\"visibility_small\";s:3:\"640\";s:17:\"visibility_medium\";s:4:\"1024\";s:22:\"typography_sensitivity\";s:4:\"0.54\";s:17:\"typography_factor\";s:3:\"1.5\";s:13:\"color_palette\";a:17:{s:6:\"color1\";a:2:{s:5:\"color\";s:19:\"rgba(255,255,255,1)\";s:5:\"label\";s:7:\"Color 1\";}s:6:\"color2\";a:2:{s:5:\"color\";s:19:\"rgba(246,246,246,1)\";s:5:\"label\";s:7:\"Color 2\";}s:6:\"color3\";a:2:{s:5:\"color\";s:19:\"rgba(224,222,222,1)\";s:5:\"label\";s:7:\"Color 3\";}s:6:\"color4\";a:2:{s:5:\"color\";s:18:\"rgba(43,160,163,1)\";s:5:\"label\";s:7:\"Color 4\";}s:6:\"color5\";a:2:{s:5:\"color\";s:19:\"rgba(116,116,116,1)\";s:5:\"label\";s:7:\"Color 5\";}s:6:\"color6\";a:2:{s:5:\"color\";s:16:\"rgba(51,51,51,1)\";s:5:\"label\";s:7:\"Color 6\";}s:6:\"color7\";a:2:{s:5:\"color\";s:16:\"rgba(36,41,48,1)\";s:5:\"label\";s:7:\"Color 7\";}s:6:\"color8\";a:2:{s:5:\"color\";s:16:\"rgba(36,39,45,1)\";s:5:\"label\";s:7:\"Color 8\";}s:8:\"custom10\";a:2:{s:5:\"color\";s:16:\"rgba(90,93,98,1)\";s:5:\"label\";s:9:\"Custom 10\";}s:8:\"custom11\";a:2:{s:5:\"color\";s:18:\"rgba(160,206,78,1)\";s:5:\"label\";s:9:\"Custom 11\";}s:8:\"custom12\";a:2:{s:5:\"color\";s:16:\"rgba(41,45,51,1)\";s:5:\"label\";s:9:\"Custom 12\";}s:8:\"custom13\";a:2:{s:5:\"color\";s:19:\"rgba(235,234,234,1)\";s:5:\"label\";s:9:\"Custom 13\";}s:8:\"custom14\";a:2:{s:5:\"color\";s:19:\"rgba(248,248,248,1)\";s:5:\"label\";s:9:\"Custom 14\";}s:8:\"custom15\";a:2:{s:5:\"color\";s:16:\"rgba(43,46,53,1)\";s:5:\"label\";s:9:\"Custom 15\";}s:8:\"custom16\";a:2:{s:5:\"color\";s:19:\"rgba(158,158,158,1)\";s:5:\"label\";s:9:\"Custom 16\";}s:8:\"custom17\";a:2:{s:5:\"color\";s:18:\"rgba(46,50,58,0.8)\";s:5:\"label\";s:9:\"Custom 17\";}s:8:\"custom18\";a:2:{s:5:\"color\";s:16:\"rgba(46,50,58,1)\";s:5:\"label\";s:9:\"Custom 18\";}}s:13:\"primary_color\";s:7:\"#2ba0a3\";s:15:\"header_position\";s:3:\"top\";s:13:\"header_layout\";s:2:\"v1\";s:15:\"slider_position\";s:5:\"below\";s:19:\"header_left_content\";s:12:\"contact_info\";s:20:\"header_right_content\";s:10:\"navigation\";s:17:\"header_v4_content\";s:18:\"tagline_and_search\";s:13:\"header_number\";s:28:\"Call Us Today! 1.555.555.555\";s:12:\"header_email\";s:19:\"info@yourdomain.com\";s:14:\"header_tagline\";s:19:\"Insert Tagline Here\";s:18:\"header_banner_code\";s:0:\"\";s:15:\"header_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"header_bg_full\";s:1:\"0\";s:18:\"header_bg_parallax\";s:1:\"1\";s:16:\"header_bg_repeat\";s:6:\"repeat\";s:17:\"side_header_width\";s:3:\"280\";s:14:\"header_padding\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"header_shadow\";s:1:\"0\";s:16:\"header_100_width\";s:1:\"0\";s:15:\"header_bg_color\";s:7:\"#24272d\";s:23:\"archive_header_bg_color\";s:13:\"rgb(36,39,45)\";s:19:\"header_border_color\";s:7:\"#ffffff\";s:19:\"header_top_bg_color\";s:7:\"#2ba0a3\";s:17:\"tagline_font_size\";s:4:\"16px\";s:18:\"tagline_font_color\";s:7:\"#ffffff\";s:13:\"header_sticky\";s:1:\"1\";s:20:\"header_sticky_tablet\";s:1:\"0\";s:20:\"header_sticky_mobile\";s:1:\"0\";s:23:\"header_sticky_shrinkage\";s:1:\"0\";s:26:\"header_sticky_type2_layout\";s:9:\"menu_only\";s:20:\"header_sticky_shadow\";s:1:\"1\";s:22:\"header_sticky_bg_color\";s:7:\"#24272d\";s:24:\"header_sticky_menu_color\";s:7:\"#ffffff\";s:25:\"header_sticky_nav_padding\";s:2:\"45\";s:27:\"header_sticky_nav_font_size\";s:4:\"15px\";s:10:\"nav_height\";s:2:\"96\";s:20:\"menu_highlight_style\";s:3:\"bar\";s:25:\"menu_highlight_background\";s:7:\"#a0ce4e\";s:15:\"menu_arrow_size\";a:2:{s:5:\"width\";s:4:\"23px\";s:6:\"height\";s:4:\"12px\";}s:20:\"nav_highlight_border\";s:1:\"1\";s:11:\"nav_padding\";s:2:\"45\";s:18:\"mobile_nav_padding\";s:2:\"25\";s:15:\"megamenu_shadow\";s:1:\"1\";s:28:\"main_menu_sub_menu_animation\";s:4:\"fade\";s:29:\"dropdown_menu_top_border_size\";s:1:\"3\";s:19:\"dropdown_menu_width\";s:3:\"180\";s:34:\"mainmenu_dropdown_vertical_padding\";s:2:\"12\";s:33:\"mainmenu_dropdown_display_divider\";s:1:\"1\";s:31:\"menu_display_dropdown_indicator\";s:6:\"parent\";s:20:\"main_nav_search_icon\";s:1:\"0\";s:22:\"main_nav_search_layout\";s:8:\"dropdown\";s:20:\"main_nav_icon_circle\";s:1:\"0\";s:25:\"main_nav_highlight_radius\";s:3:\"0px\";s:17:\"menu_sub_bg_color\";s:7:\"#24272d\";s:19:\"menu_bg_hover_color\";s:7:\"#292d33\";s:18:\"menu_sub_sep_color\";s:7:\"#292d33\";s:17:\"menu_h45_bg_color\";s:7:\"#ffffff\";s:14:\"nav_typography\";a:7:{s:11:\"font-family\";s:8:\"iranSans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"15px\";s:14:\"letter-spacing\";s:3:\"0px\";s:5:\"color\";s:7:\"#ffffff\";}s:15:\"menu_text_align\";s:4:\"left\";s:22:\"menu_hover_first_color\";s:7:\"#ffffff\";s:14:\"menu_sub_color\";s:7:\"#ffffff\";s:22:\"nav_dropdown_font_size\";s:4:\"14px\";s:18:\"side_nav_font_size\";s:4:\"14px\";s:26:\"flyout_menu_icon_font_size\";s:4:\"20px\";s:24:\"flyout_nav_icons_padding\";s:2:\"45\";s:22:\"flyout_menu_icon_color\";s:7:\"#333333\";s:28:\"flyout_menu_icon_hover_color\";s:7:\"#a0ce4e\";s:28:\"flyout_menu_background_color\";s:22:\"rgba(255,255,255,0.95)\";s:21:\"flyout_menu_direction\";s:4:\"fade\";s:24:\"flyout_menu_item_padding\";s:2:\"30\";s:23:\"topmenu_dropwdown_width\";s:3:\"180\";s:29:\"header_top_first_border_color\";s:7:\"#e5e5e5\";s:23:\"header_top_sub_bg_color\";s:7:\"#ffffff\";s:30:\"header_top_menu_bg_hover_color\";s:7:\"#fafafa\";s:29:\"header_top_menu_sub_sep_color\";s:7:\"#e5e5e5\";s:14:\"snav_font_size\";s:4:\"14px\";s:11:\"sec_menu_lh\";s:4:\"44px\";s:10:\"snav_color\";s:7:\"#747474\";s:25:\"header_top_menu_sub_color\";s:7:\"#747474\";s:31:\"header_top_menu_sub_hover_color\";s:7:\"#333333\";s:18:\"mobile_menu_design\";s:6:\"modern\";s:28:\"mobile_menu_icons_top_margin\";s:1:\"3\";s:22:\"mobile_menu_nav_height\";s:2:\"48\";s:27:\"mobile_nav_submenu_slideout\";s:1:\"1\";s:18:\"mobile_menu_search\";s:1:\"0\";s:29:\"mobile_menu_submenu_indicator\";s:1:\"1\";s:22:\"mobile_header_bg_color\";s:13:\"rgb(36,39,45)\";s:30:\"mobile_archive_header_bg_color\";s:13:\"rgb(36,39,45)\";s:28:\"mobile_menu_background_color\";s:7:\"#24272d\";s:23:\"mobile_menu_hover_color\";s:7:\"#292d33\";s:24:\"mobile_menu_border_color\";s:7:\"#292d33\";s:24:\"mobile_menu_toggle_color\";s:7:\"#ffffff\";s:22:\"mobile_menu_typography\";a:8:{s:11:\"font-family\";s:8:\"iranSans\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"48px\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#ffffff\";}s:28:\"mobile_menu_font_hover_color\";s:7:\"#ffffff\";s:22:\"mobile_menu_text_align\";s:4:\"left\";s:14:\"megamenu_width\";s:12:\"custom_width\";s:18:\"megamenu_max_width\";s:4:\"1100\";s:31:\"megamenu_interior_content_width\";s:14:\"viewport_width\";s:19:\"megamenu_title_size\";s:4:\"18px\";s:30:\"megamenu_item_vertical_padding\";s:1:\"5\";s:29:\"megamenu_item_display_divider\";s:1:\"0\";s:18:\"menu_icon_position\";s:4:\"left\";s:14:\"menu_icon_size\";s:2:\"14\";s:15:\"menu_icon_color\";s:7:\"#ffffff\";s:21:\"menu_icon_hover_color\";s:7:\"#2ba0a3\";s:19:\"menu_thumbnail_size\";a:2:{s:5:\"width\";s:4:\"26px\";s:6:\"height\";s:4:\"14px\";}s:14:\"logo_alignment\";s:4:\"left\";s:11:\"logo_margin\";a:4:{s:3:\"top\";s:4:\"31px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"31px\";s:4:\"left\";s:3:\"0px\";}s:15:\"logo_background\";s:1:\"0\";s:21:\"logo_background_color\";s:7:\"#a0ce4e\";s:16:\"logo_custom_link\";s:0:\"\";s:4:\"logo\";a:5:{s:3:\"url\";s:89:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2015/02/logo-avada-architect.png\";s:2:\"id\";s:3:\"230\";s:6:\"height\";s:2:\"34\";s:5:\"width\";s:3:\"240\";s:9:\"thumbnail\";s:89:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2015/02/logo-avada-architect.png\";}s:11:\"logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"sticky_header_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"sticky_header_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"mobile_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"mobile_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"favicon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"iphone_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"iphone_icon_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:9:\"ipad_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"ipad_icon_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"page_title_bar\";s:4:\"hide\";s:17:\"page_title_bar_bs\";s:11:\"breadcrumbs\";s:19:\"page_title_bar_text\";s:1:\"1\";s:20:\"page_title_100_width\";s:1:\"0\";s:17:\"page_title_height\";s:4:\"87px\";s:24:\"page_title_mobile_height\";s:4:\"70px\";s:19:\"page_title_bg_color\";s:7:\"#2ba0a3\";s:23:\"page_title_border_color\";s:7:\"#2ba0a3\";s:20:\"page_title_font_size\";s:4:\"18px\";s:22:\"page_title_line_height\";s:4:\"1.33\";s:16:\"page_title_color\";s:7:\"#ffffff\";s:30:\"page_title_subheader_font_size\";s:4:\"14px\";s:26:\"page_title_subheader_color\";s:7:\"#ffffff\";s:20:\"page_title_alignment\";s:4:\"left\";s:13:\"page_title_bg\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"page_title_bg_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"page_title_bg_full\";s:1:\"0\";s:22:\"page_title_bg_parallax\";s:1:\"0\";s:17:\"page_title_fading\";s:1:\"0\";s:17:\"breadcrumb_mobile\";s:1:\"0\";s:16:\"breacrumb_prefix\";s:0:\"\";s:20:\"breadcrumb_separator\";s:1:\"/\";s:21:\"breadcrumbs_font_size\";s:4:\"10px\";s:22:\"breadcrumbs_text_color\";s:7:\"#ffffff\";s:28:\"breadcrumbs_text_hover_color\";s:7:\"#ffffff\";s:26:\"breadcrumb_show_categories\";s:1:\"1\";s:33:\"breadcrumb_show_post_type_archive\";s:1:\"0\";s:18:\"slidingbar_widgets\";s:1:\"0\";s:25:\"mobile_slidingbar_widgets\";s:1:\"1\";s:23:\"slidingbar_open_on_load\";s:1:\"0\";s:19:\"slidingbar_position\";s:3:\"top\";s:16:\"slidingbar_width\";s:5:\"300px\";s:17:\"slidingbar_sticky\";s:1:\"0\";s:26:\"slidingbar_widgets_columns\";s:1:\"2\";s:27:\"slidingbar_column_alignment\";s:7:\"stacked\";s:26:\"slidingbar_content_padding\";a:4:{s:3:\"top\";s:4:\"35px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"35px\";s:4:\"left\";s:4:\"30px\";}s:24:\"slidingbar_content_align\";s:4:\"left\";s:23:\"slidingbar_toggle_style\";s:8:\"triangle\";s:19:\"slidingbar_bg_color\";s:19:\"rgba(36,39,45,0.95)\";s:24:\"slidingbar_divider_color\";s:7:\"#282a2b\";s:28:\"slidingbar_toggle_icon_color\";s:7:\"#ffffff\";s:20:\"slidingbar_font_size\";s:4:\"18px\";s:25:\"slidingbar_headings_color\";s:7:\"#dddddd\";s:21:\"slidingbar_text_color\";s:7:\"#8c8989\";s:21:\"slidingbar_link_color\";s:7:\"#bfbfbf\";s:27:\"slidingbar_link_color_hover\";s:7:\"#2ba0a3\";s:17:\"slidingbar_border\";s:1:\"0\";s:14:\"footer_widgets\";s:1:\"1\";s:22:\"footer_widgets_columns\";s:1:\"2\";s:29:\"footer_widgets_center_content\";s:1:\"0\";s:22:\"footer_special_effects\";s:4:\"none\";s:16:\"footer_copyright\";s:1:\"1\";s:31:\"footer_copyright_center_content\";s:1:\"0\";s:11:\"footer_text\";s:454:\"قالب آوادا توسط ايران آوادا - <script>document.write(new Date().getFullYear());</script>   |   تمام حقوق محفوظ مي‌باشد   |   قدرت گرفته از وردپرس

<span style=\"float:left;color:#fff\"><i class=\"fa fa-phone\"></i>  021.200.555.67         <a href=\"mailto:support@iranavada.com\" style=\"color:#fff;text-transform:uppercase;\"><i class=\"fa fa-envelope-o\"></i> ایمیل ما  </a></span>\";s:16:\"footerw_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"footerw_bg_full\";s:1:\"0\";s:17:\"footerw_bg_repeat\";s:6:\"repeat\";s:14:\"footerw_bg_pos\";s:13:\"center center\";s:16:\"footer_100_width\";s:1:\"0\";s:19:\"footer_area_padding\";a:4:{s:3:\"top\";s:4:\"43px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"40px\";s:4:\"left\";s:3:\"0px\";}s:15:\"footer_bg_color\";s:7:\"#24272d\";s:18:\"footer_border_size\";s:2:\"12\";s:19:\"footer_border_color\";s:7:\"#24272d\";s:19:\"footer_divider_line\";s:1:\"0\";s:24:\"footer_divider_line_size\";s:1:\"1\";s:25:\"footer_divider_line_style\";s:5:\"solid\";s:20:\"footer_divider_color\";s:7:\"#505152\";s:22:\"footer_widgets_padding\";s:4:\"15px\";s:17:\"copyright_padding\";a:2:{s:3:\"top\";s:4:\"18px\";s:6:\"bottom\";s:4:\"18px\";}s:18:\"copyright_bg_color\";s:7:\"#2b2e35\";s:21:\"copyright_border_size\";s:1:\"1\";s:22:\"copyright_border_color\";s:7:\"#2b2e35\";s:26:\"footer_headings_typography\";a:8:{s:11:\"font-family\";s:8:\"iranSans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#ffffff\";}s:17:\"footer_text_color\";s:7:\"#5a5d62\";s:17:\"footer_link_color\";s:7:\"#868a92\";s:23:\"footer_link_color_hover\";s:7:\"#2ba0a3\";s:20:\"copyright_text_color\";s:7:\"#5a5d62\";s:20:\"copyright_link_color\";s:7:\"#868a92\";s:26:\"copyright_link_color_hover\";s:7:\"#2ba0a3\";s:19:\"copyright_font_size\";s:4:\"12px\";s:24:\"responsive_sidebar_order\";s:25:\"content,sidebar,sidebar-2\";s:14:\"sidebar_sticky\";s:4:\"none\";s:15:\"sidebar_padding\";s:2:\"3%\";s:16:\"sidebar_bg_color\";s:7:\"#f8f8f8\";s:23:\"sidebar_widget_bg_color\";s:19:\"rgba(255,255,255,0)\";s:15:\"sidew_font_size\";s:4:\"18px\";s:21:\"sidebar_heading_color\";s:7:\"#333333\";s:13:\"pages_sidebar\";s:4:\"None\";s:15:\"pages_sidebar_2\";s:4:\"None\";s:20:\"pages_global_sidebar\";s:1:\"0\";s:19:\"default_sidebar_pos\";s:4:\"Left\";s:17:\"portfolio_sidebar\";s:4:\"None\";s:19:\"portfolio_sidebar_2\";s:4:\"None\";s:24:\"portfolio_global_sidebar\";s:1:\"0\";s:26:\"portfolio_sidebar_position\";s:4:\"Left\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:27:\"portfolio_archive_sidebar_2\";s:4:\"None\";s:13:\"posts_sidebar\";s:12:\"Blog Sidebar\";s:15:\"posts_sidebar_2\";s:4:\"None\";s:20:\"posts_global_sidebar\";s:1:\"1\";s:21:\"blog_sidebar_position\";s:4:\"Left\";s:20:\"blog_archive_sidebar\";s:12:\"Blog Sidebar\";s:22:\"blog_archive_sidebar_2\";s:4:\"None\";s:14:\"search_sidebar\";s:12:\"Blog Sidebar\";s:16:\"search_sidebar_2\";s:4:\"None\";s:23:\"search_sidebar_position\";s:4:\"Left\";s:8:\"bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"bg_full\";s:1:\"0\";s:9:\"bg_repeat\";s:6:\"repeat\";s:8:\"bg_color\";s:7:\"#ffffff\";s:17:\"bg_pattern_option\";s:1:\"0\";s:10:\"bg_pattern\";s:8:\"pattern1\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:16:\"content_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"content_bg_full\";s:1:\"0\";s:17:\"content_bg_repeat\";s:6:\"repeat\";s:15:\"typography_sets\";a:5:{s:11:\"typography1\";a:8:{s:5:\"label\";s:8:\"Headings\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:0:\"\";s:7:\"variant\";s:3:\"600\";s:9:\"font-size\";s:4:\"46px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:8:\"-0.015em\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography2\";a:8:{s:5:\"label\";s:11:\"Subheadings\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:0:\"\";s:7:\"variant\";s:3:\"600\";s:9:\"font-size\";s:4:\"24px\";s:11:\"line-height\";s:3:\"1.1\";s:14:\"letter-spacing\";s:1:\"0\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography3\";a:8:{s:5:\"label\";s:4:\"Lead\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:0:\"\";s:7:\"variant\";s:3:\"500\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:3:\"1.2\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography4\";a:8:{s:5:\"label\";s:4:\"Body\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:0:\"\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:4:\"1.72\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}s:11:\"typography5\";a:8:{s:5:\"label\";s:5:\"Small\";s:11:\"font-family\";s:5:\"Inter\";s:11:\"font-backup\";s:0:\"\";s:7:\"variant\";s:3:\"400\";s:9:\"font-size\";s:4:\"13px\";s:11:\"line-height\";s:4:\"1.72\";s:14:\"letter-spacing\";s:7:\"0.015em\";s:14:\"text-transform\";s:4:\"none\";}}s:15:\"body_typography\";a:8:{s:11:\"font-family\";s:8:\"iranSans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"16px\";s:11:\"line-height\";s:4:\"2.27\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#5a5d62\";}s:10:\"link_color\";s:7:\"#2ba0a3\";s:13:\"h1_typography\";a:10:{s:11:\"font-family\";s:5:\"Dinar\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"60px\";s:11:\"line-height\";s:4:\"1.33\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"0.67em\";s:13:\"margin-bottom\";s:6:\"0.67em\";s:5:\"color\";s:7:\"#ffffff\";}s:13:\"h2_typography\";a:10:{s:11:\"font-family\";s:5:\"Dinar\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"44px\";s:11:\"line-height\";s:4:\"1.25\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h3_typography\";a:10:{s:11:\"font-family\";s:8:\"iranSans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"22px\";s:11:\"line-height\";s:4:\"1.91\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"5px\";s:13:\"margin-bottom\";s:3:\"5px\";s:5:\"color\";s:7:\"#5a5d62\";}s:13:\"h4_typography\";a:10:{s:11:\"font-family\";s:12:\"IranSansBold\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:4:\"2.11\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"5px\";s:13:\"margin-bottom\";s:4:\"10px\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h5_typography\";a:10:{s:11:\"font-family\";s:12:\"IranSansBold\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"1.29\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"5px\";s:13:\"margin-bottom\";s:3:\"5px\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h6_typography\";a:10:{s:11:\"font-family\";s:12:\"IranSansBold\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"11px\";s:11:\"line-height\";s:4:\"1.55\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"5px\";s:13:\"margin-bottom\";s:3:\"5px\";s:5:\"color\";s:7:\"#242930\";}s:21:\"post_title_typography\";a:8:{s:11:\"font-family\";s:5:\"Dinar\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"32px\";s:11:\"line-height\";s:4:\"32px\";s:14:\"letter-spacing\";s:3:\"0px\";s:5:\"color\";s:7:\"#242930\";}s:29:\"post_titles_extras_typography\";a:8:{s:11:\"font-family\";s:8:\"iranSans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"23px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:3:\"0px\";s:5:\"color\";s:7:\"#5a5d62\";}s:12:\"custom_fonts\";a:7:{s:25:\"fusionredux_repeater_data\";a:3:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"name\";a:3:{i:0;s:8:\"iranSans\";i:1;s:12:\"IranSansBold\";i:2;s:5:\"Dinar\";}s:5:\"woff2\";a:3:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:4:\"woff\";a:3:{i:0;a:5:{s:3:\"url\";s:86:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.woff\";s:2:\"id\";s:3:\"685\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:86:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.woff\";s:2:\"id\";s:3:\"688\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:75:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.woff\";s:2:\"id\";s:3:\"694\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}s:3:\"ttf\";a:3:{i:0;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.ttf\";s:2:\"id\";s:3:\"684\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.ttf\";s:2:\"id\";s:3:\"687\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:74:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.ttf\";s:2:\"id\";s:3:\"696\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}s:3:\"eot\";a:3:{i:0;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.eot\";s:2:\"id\";s:3:\"686\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.eot\";s:2:\"id\";s:3:\"689\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:74:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.eot\";s:2:\"id\";s:3:\"695\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}s:3:\"svg\";a:3:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:19:\"blog_page_title_bar\";s:4:\"hide\";s:24:\"blog_show_page_title_bar\";s:4:\"hide\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:11:\"blog_layout\";s:5:\"large\";s:19:\"blog_archive_layout\";s:6:\"medium\";s:20:\"blog_pagination_type\";s:10:\"pagination\";s:36:\"blog_load_more_posts_button_bg_color\";s:7:\"#2e323a\";s:38:\"blog_load_more_posts_button_text_color\";s:4:\"#fff\";s:42:\"blog_load_more_posts_hover_button_bg_color\";s:18:\"rgba(46,50,58,0.8)\";s:44:\"blog_load_more_posts_hover_button_text_color\";s:4:\"#fff\";s:25:\"blog_archive_grid_columns\";s:1:\"2\";s:32:\"blog_archive_grid_column_spacing\";s:2:\"40\";s:18:\"blog_equal_heights\";s:1:\"0\";s:25:\"blog_archive_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:21:\"blog_layout_alignment\";s:0:\"\";s:14:\"content_length\";s:7:\"excerpt\";s:19:\"excerpt_length_blog\";s:2:\"55\";s:18:\"strip_html_excerpt\";s:1:\"1\";s:15:\"featured_images\";s:1:\"1\";s:15:\"dates_box_color\";s:7:\"#4194ce\";s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:14:\"blog_width_100\";s:1:\"0\";s:22:\"featured_images_single\";s:1:\"1\";s:11:\"blog_pn_nav\";s:1:\"0\";s:15:\"blog_post_title\";s:5:\"below\";s:23:\"blog_post_meta_position\";s:13:\"below_article\";s:18:\"social_sharing_box\";s:1:\"1\";s:11:\"author_info\";s:1:\"0\";s:13:\"related_posts\";s:1:\"1\";s:13:\"blog_comments\";s:1:\"0\";s:9:\"post_meta\";s:1:\"1\";s:16:\"post_meta_author\";s:1:\"0\";s:14:\"post_meta_date\";s:1:\"1\";s:14:\"post_meta_cats\";s:1:\"1\";s:18:\"post_meta_comments\";s:1:\"1\";s:14:\"post_meta_read\";s:1:\"1\";s:14:\"post_meta_tags\";s:1:\"0\";s:14:\"meta_font_size\";s:4:\"12px\";s:11:\"date_format\";s:7:\"jS F, Y\";s:24:\"portfolio_archive_layout\";s:4:\"grid\";s:37:\"portfolio_archive_featured_image_size\";s:4:\"full\";s:25:\"portfolio_archive_columns\";s:1:\"3\";s:32:\"portfolio_archive_column_spacing\";s:2:\"30\";s:23:\"portfolio_equal_heights\";s:1:\"0\";s:42:\"portfolio_archive_one_column_text_position\";s:5:\"below\";s:23:\"portfolio_archive_items\";s:2:\"10\";s:29:\"portfolio_archive_text_layout\";s:7:\"no_text\";s:32:\"portfolio_archive_content_length\";s:7:\"excerpt\";s:32:\"portfolio_archive_excerpt_length\";s:1:\"0\";s:36:\"portfolio_archive_strip_html_excerpt\";s:1:\"1\";s:31:\"portfolio_archive_title_display\";s:3:\"all\";s:32:\"portfolio_archive_text_alignment\";s:4:\"left\";s:32:\"portfolio_archive_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:33:\"portfolio_archive_pagination_type\";s:15:\"infinite_scroll\";s:49:\"portfolio_archive_load_more_posts_button_bg_color\";s:7:\"#ebeaea\";s:51:\"portfolio_archive_load_more_posts_button_text_color\";s:4:\"#333\";s:55:\"portfolio_archive_load_more_posts_hover_button_bg_color\";s:21:\"rgba(235,234,234,0.8)\";s:57:\"portfolio_archive_load_more_posts_hover_button_text_color\";s:4:\"#333\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:24:\"portfolio_meta_font_size\";s:4:\"18px\";s:16:\"portfolio_pn_nav\";s:1:\"0\";s:19:\"portfolio_width_100\";s:1:\"0\";s:30:\"portfolio_featured_image_width\";s:4:\"full\";s:25:\"portfolio_featured_images\";s:1:\"1\";s:25:\"show_first_featured_image\";s:1:\"1\";s:28:\"portfolio_project_desc_title\";s:1:\"1\";s:25:\"portfolio_project_details\";s:1:\"1\";s:26:\"portfolio_link_icon_target\";s:1:\"0\";s:16:\"portfolio_author\";s:1:\"0\";s:28:\"portfolio_social_sharing_box\";s:1:\"0\";s:23:\"portfolio_related_posts\";s:1:\"1\";s:18:\"portfolio_comments\";s:1:\"0\";s:18:\"social_media_icons\";a:6:{s:25:\"fusionredux_repeater_data\";a:3:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"icon\";a:3:{i:0;s:8:\"facebook\";i:1;s:9:\"instagram\";i:2;s:9:\"pinterest\";}s:9:\"icon_mark\";a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}s:3:\"url\";a:3:{i:0;s:1:\"#\";i:1;s:1:\"#\";i:2;s:1:\"#\";}s:12:\"custom_title\";a:3:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";}s:13:\"custom_source\";a:3:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:29:\"header_social_links_font_size\";s:4:\"16px\";s:37:\"header_social_links_tooltip_placement\";s:6:\"bottom\";s:30:\"header_social_links_color_type\";s:6:\"custom\";s:30:\"header_social_links_icon_color\";s:7:\"#bebdbd\";s:25:\"header_social_links_boxed\";s:1:\"0\";s:29:\"header_social_links_box_color\";s:7:\"#e8e8e8\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:33:\"header_social_links_boxed_padding\";s:3:\"8px\";s:12:\"icons_footer\";s:1:\"0\";s:29:\"footer_social_links_font_size\";s:4:\"16px\";s:37:\"footer_social_links_tooltip_placement\";s:5:\"right\";s:30:\"footer_social_links_color_type\";s:6:\"custom\";s:30:\"footer_social_links_icon_color\";s:7:\"#828c8e\";s:25:\"footer_social_links_boxed\";s:1:\"1\";s:29:\"footer_social_links_box_color\";s:7:\"#2c3038\";s:32:\"footer_social_links_boxed_radius\";s:3:\"50%\";s:33:\"footer_social_links_boxed_padding\";s:3:\"8px\";s:22:\"sharing_social_tagline\";s:51:\"اشتراک در شبکه‌های اجتماعی!\";s:30:\"sharing_box_tagline_text_color\";s:7:\"#333333\";s:15:\"social_bg_color\";s:7:\"#f8f8f8\";s:14:\"social_sharing\";a:4:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:8:\"linkedin\";i:3;s:9:\"pinterest\";}s:30:\"sharing_social_links_font_size\";s:4:\"18px\";s:38:\"sharing_social_links_tooltip_placement\";s:3:\"top\";s:31:\"sharing_social_links_color_type\";s:6:\"custom\";s:31:\"sharing_social_links_icon_color\";s:7:\"#828c8e\";s:26:\"sharing_social_links_boxed\";s:1:\"1\";s:30:\"sharing_social_links_box_color\";s:7:\"#2b2e35\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"50%\";s:34:\"sharing_social_links_boxed_padding\";s:4:\"12px\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";s:1:\"1\";s:23:\"slideshow_smooth_height\";s:1:\"1\";s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";s:1:\"0\";s:25:\"slider_nav_box_dimensions\";a:2:{s:5:\"width\";s:4:\"25px\";s:6:\"height\";s:4:\"65px\";}s:17:\"slider_arrow_size\";s:4:\"14px\";s:15:\"tfes_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"400px\";}s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";s:1:\"1\";s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"150\";s:18:\"es_title_font_size\";s:4:\"42px\";s:20:\"es_caption_font_size\";s:4:\"20px\";s:14:\"es_title_color\";s:7:\"#333333\";s:16:\"es_caption_color\";s:7:\"#747474\";s:15:\"status_lightbox\";s:1:\"1\";s:22:\"status_lightbox_single\";s:1:\"1\";s:17:\"lightbox_behavior\";s:3:\"all\";s:13:\"lightbox_skin\";s:11:\"metro-black\";s:13:\"lightbox_path\";s:8:\"vertical\";s:24:\"lightbox_animation_speed\";s:4:\"fast\";s:15:\"lightbox_arrows\";s:1:\"1\";s:16:\"lightbox_gallery\";s:1:\"1\";s:17:\"lightbox_autoplay\";s:1:\"0\";s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:5:\"0.925\";s:14:\"lightbox_title\";s:1:\"0\";s:13:\"lightbox_desc\";s:1:\"0\";s:15:\"lightbox_social\";s:1:\"0\";s:20:\"lightbox_deeplinking\";s:1:\"1\";s:20:\"lightbox_post_images\";s:1:\"1\";s:25:\"lightbox_video_dimensions\";a:2:{s:5:\"width\";s:6:\"1280px\";s:6:\"height\";s:5:\"720px\";}s:17:\"form_input_height\";s:4:\"40px\";s:14:\"form_text_size\";s:4:\"13px\";s:13:\"form_bg_color\";s:7:\"#373d4d\";s:15:\"form_text_color\";s:7:\"#ffffff\";s:17:\"form_border_width\";a:4:{s:3:\"top\";s:3:\"1px\";s:5:\"right\";s:3:\"1px\";s:6:\"bottom\";s:3:\"1px\";s:4:\"left\";s:3:\"1px\";}s:17:\"form_border_color\";s:20:\"rgba(255,255,255,.5)\";s:23:\"form_focus_border_color\";s:20:\"rgba(255,255,255,.5)\";s:18:\"form_border_radius\";s:1:\"0\";s:19:\"form_views_counting\";s:3:\"all\";s:17:\"recaptcha_version\";s:2:\"v2\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:5:\"light\";s:15:\"recaptcha_score\";s:3:\"0.5\";s:24:\"recaptcha_badge_position\";s:6:\"inline\";s:20:\"recaptcha_login_form\";s:1:\"0\";s:11:\"hubspot_api\";s:3:\"off\";s:11:\"hubspot_key\";s:0:\"\";s:13:\"mailchimp_api\";s:3:\"off\";s:13:\"mailchimp_key\";s:0:\"\";s:13:\"email_address\";s:0:\"\";s:24:\"contact_comment_position\";s:5:\"below\";s:29:\"contact_form_privacy_checkbox\";s:1:\"0\";s:26:\"contact_form_privacy_label\";s:152:\"By checking this box, you confirm that you have read and are agreeing to our terms of use regarding the storage of the data submitted through this form.\";s:8:\"gmap_api\";s:0:\"\";s:13:\"gmap_api_type\";s:2:\"js\";s:18:\"gmap_embed_address\";s:0:\"\";s:19:\"gmap_embed_map_type\";s:7:\"roadmap\";s:12:\"gmap_address\";s:49:\"775 New York Ave, Brooklyn, Kings, New York 11203\";s:9:\"gmap_type\";s:7:\"roadmap\";s:15:\"gmap_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"415px\";}s:14:\"gmap_topmargin\";s:4:\"55px\";s:14:\"map_zoom_level\";s:1:\"8\";s:7:\"map_pin\";s:1:\"1\";s:18:\"gmap_pin_animation\";s:1:\"1\";s:9:\"map_popup\";s:1:\"0\";s:15:\"map_scrollwheel\";s:1:\"1\";s:9:\"map_scale\";s:1:\"1\";s:15:\"map_zoomcontrol\";s:1:\"1\";s:11:\"map_styling\";s:7:\"default\";s:17:\"map_overlay_color\";s:7:\"#2ba0a3\";s:19:\"map_infobox_styling\";s:7:\"default\";s:19:\"map_infobox_content\";s:0:\"\";s:20:\"map_infobox_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"map_infobox_text_color\";s:7:\"#747474\";s:22:\"map_custom_marker_icon\";s:0:\"\";s:21:\"search_filter_results\";s:1:\"1\";s:14:\"search_content\";a:6:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:15:\"avada_portfolio\";i:3;s:9:\"avada_faq\";i:4;s:7:\"product\";i:5;s:12:\"tribe_events\";}s:27:\"search_limit_to_post_titles\";s:1:\"0\";s:18:\"search_form_design\";s:7:\"classic\";s:11:\"live_search\";s:1:\"0\";s:26:\"live_search_min_char_count\";s:1:\"4\";s:28:\"live_search_results_per_page\";s:3:\"100\";s:26:\"live_search_results_height\";s:3:\"250\";s:34:\"live_search_display_featured_image\";s:1:\"1\";s:29:\"live_search_display_post_type\";s:1:\"1\";s:13:\"search_layout\";s:4:\"grid\";s:23:\"search_results_per_page\";s:2:\"10\";s:22:\"search_pagination_type\";s:10:\"pagination\";s:19:\"search_grid_columns\";s:1:\"2\";s:26:\"search_grid_column_spacing\";s:2:\"40\";s:21:\"search_content_length\";s:7:\"excerpt\";s:21:\"search_excerpt_length\";s:2:\"55\";s:25:\"search_strip_html_excerpt\";s:1:\"1\";s:22:\"search_featured_images\";s:1:\"1\";s:11:\"search_meta\";a:5:{i:0;s:6:\"author\";i:1;s:4:\"date\";i:2;s:10:\"categories\";i:3;s:8:\"comments\";i:4;s:9:\"read_more\";}s:26:\"search_new_search_position\";s:3:\"top\";s:18:\"gfonts_load_method\";s:3:\"cdn\";s:14:\"privacy_embeds\";s:1:\"0\";s:14:\"privacy_expiry\";s:2:\"30\";s:19:\"privacy_embed_types\";a:8:{i:0;s:7:\"youtube\";i:1;s:5:\"vimeo\";i:2;s:10:\"soundcloud\";i:3;s:8:\"facebook\";i:4;s:6:\"flickr\";i:5;s:7:\"twitter\";i:6;s:5:\"gmaps\";i:7;s:8:\"tracking\";}s:22:\"privacy_embed_defaults\";a:0:{}s:16:\"privacy_bg_color\";s:15:\"rgba(0,0,0,0.1)\";s:13:\"privacy_color\";s:15:\"rgba(0,0,0,0.3)\";s:11:\"privacy_bar\";s:1:\"0\";s:19:\"privacy_bar_padding\";a:4:{s:3:\"top\";s:4:\"15px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:4:\"15px\";s:4:\"left\";s:4:\"30px\";}s:20:\"privacy_bar_bg_color\";s:7:\"#363839\";s:21:\"privacy_bar_font_size\";s:4:\"13px\";s:17:\"privacy_bar_color\";s:7:\"#8C8989\";s:22:\"privacy_bar_link_color\";s:7:\"#bfbfbf\";s:28:\"privacy_bar_link_hover_color\";s:7:\"#a0ce4e\";s:16:\"privacy_bar_text\";s:51:\"This website uses cookies and third party services.\";s:23:\"privacy_bar_button_text\";s:2:\"Ok\";s:23:\"privacy_bar_button_save\";s:1:\"0\";s:16:\"privacy_bar_more\";s:1:\"0\";s:21:\"privacy_bar_more_text\";s:14:\"تنظیمات\";s:23:\"privacy_bar_update_text\";s:33:\"تنظیمات بروزرسانی\";s:30:\"privacy_bar_headings_font_size\";s:4:\"13px\";s:26:\"privacy_bar_headings_color\";s:7:\"#dddddd\";s:19:\"privacy_bar_content\";a:4:{s:25:\"fusionredux_repeater_data\";a:1:{i:0;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"type\";a:1:{i:0;s:0:\"\";}s:5:\"title\";a:1:{i:0;s:0:\"\";}s:11:\"description\";a:1:{i:0;s:0:\"\";}}s:16:\"sidenav_behavior\";s:5:\"hover\";s:26:\"featured_image_placeholder\";s:1:\"1\";s:12:\"excerpt_base\";s:5:\"words\";s:16:\"disable_excerpts\";s:1:\"1\";s:24:\"excerpt_read_more_symbol\";s:5:\"[...]\";s:14:\"link_read_more\";s:1:\"0\";s:12:\"avatar_shape\";s:6:\"square\";s:14:\"comments_pages\";s:1:\"0\";s:21:\"featured_images_pages\";s:1:\"1\";s:21:\"nofollow_social_links\";s:1:\"0\";s:16:\"social_icons_new\";s:1:\"1\";s:14:\"totop_position\";s:4:\"left\";s:19:\"totop_border_radius\";s:1:\"4\";s:22:\"totop_scroll_down_only\";s:1:\"0\";s:16:\"custom_scrollbar\";s:1:\"0\";s:20:\"scrollbar_background\";s:7:\"#f2f3f5\";s:16:\"scrollbar_handle\";s:7:\"#65bc7b\";s:8:\"faq_slug\";s:9:\"faq-items\";s:20:\"related_posts_layout\";s:17:\"title_below_image\";s:20:\"number_related_posts\";s:1:\"5\";s:21:\"related_posts_columns\";s:1:\"3\";s:28:\"related_posts_column_spacing\";s:2:\"10\";s:24:\"related_posts_image_size\";s:7:\"cropped\";s:22:\"related_posts_autoplay\";s:1:\"1\";s:19:\"related_posts_speed\";s:4:\"2500\";s:24:\"related_posts_navigation\";s:1:\"0\";s:19:\"related_posts_swipe\";s:1:\"1\";s:25:\"related_posts_swipe_items\";s:1:\"1\";s:14:\"image_rollover\";s:1:\"1\";s:24:\"image_rollover_direction\";s:6:\"bottom\";s:24:\"image_rollover_icon_size\";s:4:\"20px\";s:20:\"image_rollover_icons\";s:8:\"linkzoom\";s:20:\"title_image_rollover\";s:1:\"1\";s:19:\"cats_image_rollover\";s:1:\"0\";s:26:\"icon_circle_image_rollover\";s:1:\"1\";s:24:\"image_gradient_top_color\";s:21:\"rgba(43,160,163,0.85)\";s:27:\"image_gradient_bottom_color\";s:7:\"#2ba0a3\";s:25:\"image_rollover_text_color\";s:15:\"rgba(0,0,0,.65)\";s:25:\"image_rollover_icon_color\";s:7:\"#ffffff\";s:17:\"pagination_sizing\";s:7:\"padding\";s:23:\"pagination_width_height\";s:2:\"30\";s:22:\"pagination_box_padding\";a:2:{s:5:\"width\";s:3:\"6px\";s:6:\"height\";s:3:\"2px\";}s:23:\"pagination_border_width\";s:1:\"1\";s:24:\"pagination_border_radius\";s:1:\"0\";s:23:\"pagination_text_display\";s:1:\"1\";s:20:\"pagination_font_size\";s:4:\"12px\";s:16:\"pagination_range\";s:1:\"1\";s:26:\"pagination_start_end_range\";s:1:\"0\";s:17:\"timeline_bg_color\";s:19:\"rgba(255,255,255,0)\";s:14:\"timeline_color\";s:7:\"#ebeaea\";s:25:\"grid_separator_style_type\";s:12:\"double|solid\";s:20:\"grid_separator_color\";s:7:\"#e0dede\";s:18:\"masonry_grid_ratio\";s:3:\"1.0\";s:20:\"masonry_width_double\";s:4:\"2000\";s:23:\"enable_language_updates\";s:1:\"0\";s:19:\"dependencies_status\";s:1:\"1\";s:27:\"disable_code_block_encoding\";s:1:\"0\";s:16:\"disable_megamenu\";s:1:\"1\";s:19:\"status_avada_studio\";s:1:\"1\";s:16:\"avada_rev_styles\";s:1:\"0\";s:22:\"avada_styles_dropdowns\";s:1:\"1\";s:27:\"disable_mobile_image_hovers\";s:1:\"1\";s:9:\"status_yt\";s:1:\"0\";s:12:\"status_vimeo\";s:1:\"0\";s:11:\"status_gmap\";s:1:\"0\";s:12:\"status_totop\";s:18:\"desktop_and_mobile\";s:18:\"status_fontawesome\";a:3:{i:0;s:3:\"fab\";i:1;s:3:\"far\";i:2;s:3:\"fas\";}s:28:\"fontawesome_v4_compatibility\";s:1:\"0\";s:22:\"status_fontawesome_pro\";s:1:\"0\";s:14:\"status_outline\";s:1:\"0\";s:16:\"status_opengraph\";s:1:\"1\";s:31:\"disable_date_rich_snippet_pages\";s:1:\"1\";s:26:\"disable_rich_snippet_title\";s:1:\"1\";s:27:\"disable_rich_snippet_author\";s:1:\"1\";s:25:\"disable_rich_snippet_date\";s:1:\"1\";s:24:\"disable_rich_snippet_faq\";s:1:\"1\";s:34:\"enable_block_editor_backend_styles\";s:1:\"0\";s:17:\"load_block_styles\";s:3:\"off\";s:16:\"google_analytics\";s:0:\"\";s:10:\"space_head\";s:0:\"\";s:10:\"space_body\";s:0:\"\";s:20:\"status_fusion_slider\";s:1:\"1\";s:14:\"status_eslider\";s:1:\"0\";s:19:\"status_fusion_forms\";s:1:\"1\";s:21:\"status_awb_Off_Canvas\";s:1:\"1\";s:23:\"status_fusion_portfolio\";s:1:\"1\";s:18:\"status_fusion_faqs\";s:1:\"1\";s:15:\"pw_jpeg_quality\";s:3:\"100\";s:27:\"wp_big_image_size_threshold\";s:4:\"2560\";s:9:\"lazy_load\";s:4:\"none\";s:17:\"lazy_load_iframes\";s:4:\"none\";s:17:\"font_face_display\";s:5:\"block\";s:13:\"preload_fonts\";s:4:\"none\";s:22:\"preload_fonts_variants\";a:1:{i:0;s:3:\"400\";}s:21:\"preload_fonts_subsets\";a:1:{i:0;s:5:\"latin\";}s:15:\"emojis_disabled\";s:7:\"enabled\";s:23:\"jquery_migrate_disabled\";s:7:\"enabled\";s:12:\"defer_jquery\";s:1:\"0\";s:12:\"defer_styles\";s:1:\"0\";s:11:\"gzip_status\";s:1:\"0\";s:12:\"video_facade\";s:3:\"off\";s:16:\"css_cache_method\";s:4:\"file\";s:30:\"css_combine_third_party_assets\";s:1:\"1\";s:19:\"media_queries_async\";s:1:\"0\";s:12:\"critical_css\";s:1:\"0\";s:15:\"cache_server_ip\";s:0:\"\";s:11:\"js_compiler\";s:1:\"0\";s:10:\"custom_css\";s:0:\"\";s:13:\"info_bg_color\";s:7:\"#ffffff\";s:17:\"info_accent_color\";s:19:\"rgba(128,128,128,1)\";s:15:\"danger_bg_color\";s:7:\"#f2dede\";s:19:\"danger_accent_color\";s:17:\"rgba(166,66,66,1)\";s:16:\"success_bg_color\";s:7:\"#dff0d8\";s:20:\"success_accent_color\";s:17:\"rgba(92,163,64,1)\";s:16:\"warning_bg_color\";s:7:\"#fcf8e3\";s:20:\"warning_accent_color\";s:18:\"rgba(217,185,23,1)\";s:20:\"alert_box_text_align\";s:6:\"center\";s:24:\"alert_box_text_transform\";s:10:\"capitalize\";s:21:\"alert_box_dismissable\";s:3:\"yes\";s:16:\"alert_box_shadow\";s:2:\"no\";s:17:\"alert_border_size\";s:3:\"1px\";s:16:\"animation_offset\";s:13:\"top-into-view\";s:21:\"status_css_animations\";s:7:\"desktop\";s:15:\"audio_max_width\";s:4:\"100%\";s:22:\"audio_background_color\";s:7:\"#222222\";s:23:\"audio_progressbar_color\";s:7:\"#ffffff\";s:27:\"audio_controls_color_scheme\";s:5:\"light\";s:17:\"audio_border_size\";s:1:\"0\";s:18:\"audio_border_color\";s:0:\"\";s:19:\"audio_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:17:\"blog_grid_columns\";s:1:\"3\";s:24:\"blog_grid_column_spacing\";s:2:\"40\";s:17:\"blog_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:12:\"blog_excerpt\";s:3:\"yes\";s:19:\"blog_excerpt_length\";s:2:\"10\";s:44:\"blog_element_load_more_posts_button_bg_color\";s:7:\"#2e323a\";s:46:\"blog_element_load_more_posts_button_text_color\";s:4:\"#fff\";s:50:\"blog_element_load_more_posts_hover_button_bg_color\";s:18:\"rgba(46,50,58,0.8)\";s:52:\"blog_element_load_more_posts_hover_button_text_color\";s:4:\"#fff\";s:14:\"button_padding\";a:4:{s:3:\"top\";s:4:\"13px\";s:5:\"right\";s:4:\"29px\";s:6:\"bottom\";s:4:\"13px\";s:4:\"left\";s:4:\"29px\";}s:11:\"button_span\";s:2:\"no\";s:11:\"button_type\";s:4:\"Flat\";s:17:\"button_typography\";a:8:{s:11:\"font-family\";s:8:\"iranSans\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"17px\";s:14:\"letter-spacing\";s:3:\"0px\";s:14:\"text-transform\";s:9:\"uppercase\";}s:25:\"button_gradient_top_color\";s:19:\"rgba(255,255,255,0)\";s:28:\"button_gradient_bottom_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"button_gradient_top_color_hover\";s:22:\"rgba(255,255,255,.035)\";s:34:\"button_gradient_bottom_color_hover\";s:22:\"rgba(255,255,255,.035)\";s:21:\"button_gradient_start\";s:1:\"0\";s:19:\"button_gradient_end\";s:3:\"100\";s:20:\"button_gradient_type\";s:6:\"linear\";s:21:\"button_gradient_angle\";s:3:\"180\";s:23:\"button_radial_direction\";s:13:\"center center\";s:19:\"button_accent_color\";s:21:\"rgba(255,255,255,.75)\";s:25:\"button_accent_hover_color\";s:20:\"rgba(255,255,255,.9)\";s:18:\"button_bevel_color\";s:7:\"#ffffff\";s:24:\"button_bevel_color_hover\";s:7:\"#ffffff\";s:19:\"button_border_width\";a:4:{s:3:\"top\";s:3:\"1px\";s:5:\"right\";s:3:\"1px\";s:6:\"bottom\";s:3:\"1px\";s:4:\"left\";s:3:\"1px\";}s:20:\"button_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:19:\"button_border_color\";s:21:\"rgba(255,255,255,.75)\";s:25:\"button_border_hover_color\";s:20:\"rgba(255,255,255,.9)\";s:14:\"button_presets\";s:1:\"1\";s:18:\"carousel_nav_color\";s:15:\"rgba(0,0,0,.85)\";s:20:\"carousel_hover_color\";s:15:\"rgba(0,0,0,.95)\";s:14:\"carousel_speed\";s:4:\"2500\";s:21:\"chart_legend_position\";s:3:\"top\";s:19:\"chart_show_tooltips\";s:3:\"yes\";s:14:\"chart_bg_color\";s:19:\"rgba(255,255,255,0)\";s:21:\"chart_axis_text_color\";s:7:\"#666666\";s:20:\"chart_gridline_color\";s:15:\"rgba(0,0,0,0.1)\";s:21:\"checklist_icons_color\";s:7:\"#ffffff\";s:16:\"checklist_circle\";s:1:\"1\";s:22:\"checklist_circle_color\";s:19:\"rgba(255,255,255,0)\";s:20:\"checklist_text_color\";s:7:\"#5a5d62\";s:19:\"checklist_item_size\";s:4:\"14px\";s:22:\"checklist_item_padding\";a:4:{s:3:\"top\";s:6:\"0.35em\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:6:\"0.35em\";s:4:\"left\";s:1:\"0\";}s:17:\"checklist_divider\";s:2:\"no\";s:23:\"checklist_divider_color\";s:7:\"#e0dede\";s:25:\"checklist_odd_row_bgcolor\";s:19:\"rgba(255,255,255,0)\";s:26:\"checklist_even_row_bgcolor\";s:19:\"rgba(255,255,255,0)\";s:10:\"col_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";}s:11:\"col_spacing\";s:2:\"4%\";s:16:\"col_width_medium\";s:3:\"1_1\";s:15:\"col_width_small\";s:3:\"1_1\";s:25:\"container_padding_default\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:21:\"container_padding_100\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:4:\"30px\";}s:19:\"full_width_bg_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"full_width_gradient_start_color\";s:19:\"rgba(255,255,255,0)\";s:29:\"full_width_gradient_end_color\";s:19:\"rgba(255,255,255,0)\";s:23:\"full_width_border_sizes\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:23:\"full_width_border_color\";s:7:\"#eae9e9\";s:29:\"container_scroll_nav_bg_color\";s:18:\"rgba(0, 0, 0, 0.2)\";s:33:\"container_scroll_nav_bullet_color\";s:7:\"#eeeeee\";s:44:\"container_hundred_percent_scroll_sensitivity\";s:3:\"450\";s:39:\"container_hundred_percent_height_mobile\";s:1:\"0\";s:24:\"container_legacy_support\";s:1:\"1\";s:20:\"content_box_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"content_box_title_size\";s:2:\"18\";s:23:\"content_box_title_color\";s:7:\"#242930\";s:22:\"content_box_body_color\";s:7:\"#747474\";s:21:\"content_box_icon_size\";s:4:\"21px\";s:22:\"content_box_icon_color\";s:7:\"#ffffff\";s:23:\"content_box_icon_circle\";s:3:\"yes\";s:30:\"content_box_icon_circle_radius\";s:3:\"50%\";s:25:\"content_box_icon_bg_color\";s:7:\"#333333\";s:38:\"content_box_icon_bg_inner_border_color\";s:7:\"#333333\";s:37:\"content_box_icon_bg_inner_border_size\";s:1:\"1\";s:38:\"content_box_icon_bg_outer_border_color\";s:19:\"rgba(255,255,255,0)\";s:37:\"content_box_icon_bg_outer_border_size\";s:1:\"0\";s:27:\"content_box_icon_hover_type\";s:4:\"fade\";s:40:\"content_box_hover_animation_accent_color\";s:7:\"#2ba0a3\";s:21:\"content_box_link_type\";s:4:\"text\";s:23:\"content_box_button_span\";s:2:\"no\";s:21:\"content_box_link_area\";s:9:\"link-icon\";s:23:\"content_box_link_target\";s:5:\"_self\";s:18:\"content_box_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"60px\";}s:18:\"countdown_timezone\";s:9:\"site_time\";s:16:\"countdown_layout\";s:7:\"floated\";s:20:\"countdown_show_weeks\";s:2:\"no\";s:24:\"countdown_label_position\";s:9:\"text_flow\";s:26:\"countdown_background_color\";s:7:\"#a0ce4e\";s:26:\"countdown_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"countdown_background_repeat\";s:9:\"no-repeat\";s:29:\"countdown_background_position\";s:13:\"center center\";s:29:\"countdown_counter_box_spacing\";s:4:\"10px\";s:27:\"countdown_counter_box_color\";s:7:\"#333333\";s:25:\"countdown_counter_padding\";a:4:{s:3:\"top\";s:5:\"0.6em\";s:5:\"right\";s:5:\"1.1em\";s:6:\"bottom\";s:5:\"0.6em\";s:4:\"left\";s:5:\"1.1em\";}s:29:\"countdown_counter_border_size\";s:1:\"0\";s:30:\"countdown_counter_border_color\";s:7:\"#1d242d\";s:31:\"countdown_counter_border_radius\";s:3:\"4px\";s:27:\"countdown_counter_font_size\";s:4:\"18px\";s:28:\"countdown_counter_text_color\";s:7:\"#ffffff\";s:25:\"countdown_label_font_size\";s:4:\"18px\";s:21:\"countdown_label_color\";s:7:\"#ffffff\";s:27:\"countdown_heading_font_size\";s:4:\"18px\";s:28:\"countdown_heading_text_color\";s:7:\"#ffffff\";s:30:\"countdown_subheading_font_size\";s:4:\"14px\";s:31:\"countdown_subheading_text_color\";s:7:\"#ffffff\";s:25:\"countdown_link_text_color\";s:7:\"#ffffff\";s:21:\"countdown_link_target\";s:5:\"_self\";s:17:\"counter_box_speed\";s:4:\"1000\";s:17:\"counter_box_color\";s:7:\"#9e9e9e\";s:22:\"counter_box_title_size\";s:4:\"50px\";s:21:\"counter_box_icon_size\";s:4:\"50px\";s:22:\"counter_box_body_color\";s:7:\"#747474\";s:21:\"counter_box_body_size\";s:4:\"13px\";s:24:\"counter_box_border_color\";s:7:\"#e0dede\";s:20:\"counter_box_icon_top\";s:2:\"no\";s:20:\"counter_filled_color\";s:7:\"#9e9e9e\";s:22:\"counter_unfilled_color\";s:7:\"#f6f6f6\";s:13:\"dropcap_color\";s:7:\"#2ba0a3\";s:18:\"dropcap_text_color\";s:4:\"#fff\";s:18:\"faq_featured_image\";s:1:\"0\";s:11:\"faq_filters\";s:3:\"yes\";s:18:\"faq_accordion_type\";s:10:\"accordions\";s:24:\"faq_accordion_boxed_mode\";s:1:\"0\";s:25:\"faq_accordion_border_size\";s:1:\"1\";s:26:\"faq_accordian_border_color\";s:7:\"#cccccc\";s:30:\"faq_accordian_background_color\";s:7:\"#ffffff\";s:25:\"faq_accordian_hover_color\";s:7:\"#f9f9f9\";s:26:\"faq_accordion_divider_line\";s:1:\"1\";s:29:\"faq_accordion_title_font_size\";s:4:\"18px\";s:23:\"faq_accordion_icon_size\";s:2:\"13\";s:24:\"faq_accordian_icon_color\";s:7:\"#ffffff\";s:24:\"faq_accordion_icon_boxed\";s:1:\"1\";s:28:\"faq_accordian_inactive_color\";s:7:\"#333333\";s:24:\"faq_accordion_icon_align\";s:4:\"left\";s:26:\"faq_accordian_active_color\";s:7:\"#2ba0a3\";s:22:\"flip_boxes_flip_effect\";s:7:\"classic\";s:25:\"flip_boxes_flip_direction\";s:5:\"right\";s:24:\"flip_boxes_flip_duration\";s:3:\"0.4\";s:24:\"flip_boxes_equal_heights\";s:2:\"no\";s:19:\"flip_boxes_front_bg\";s:7:\"#f6f6f6\";s:24:\"flip_boxes_front_heading\";s:7:\"#333333\";s:21:\"flip_boxes_front_text\";s:7:\"#747474\";s:18:\"flip_boxes_back_bg\";s:7:\"#9e9e9e\";s:23:\"flip_boxes_back_heading\";s:7:\"#eeeded\";s:20:\"flip_boxes_back_text\";s:7:\"#ffffff\";s:22:\"flip_boxes_border_size\";s:1:\"1\";s:23:\"flip_boxes_border_color\";s:19:\"rgba(255,255,255,0)\";s:24:\"flip_boxes_border_radius\";s:3:\"4px\";s:20:\"gallery_picture_size\";s:4:\"auto\";s:14:\"gallery_layout\";s:4:\"grid\";s:15:\"gallery_columns\";s:1:\"3\";s:22:\"gallery_column_spacing\";s:2:\"10\";s:18:\"gallery_hover_type\";s:4:\"none\";s:24:\"gallery_lightbox_content\";s:4:\"none\";s:19:\"gallery_border_size\";s:1:\"0\";s:20:\"gallery_border_color\";s:7:\"#f6f6f6\";s:21:\"gallery_border_radius\";s:3:\"0px\";s:19:\"google_map_api_type\";s:2:\"js\";s:9:\"icon_size\";s:2:\"32\";s:10:\"icon_color\";s:7:\"#ffffff\";s:16:\"icon_color_hover\";s:7:\"#ffffff\";s:11:\"icon_circle\";s:3:\"yes\";s:17:\"icon_circle_color\";s:7:\"#2ba0a3\";s:23:\"icon_circle_color_hover\";s:7:\"#2ba0a3\";s:16:\"icon_border_size\";s:1:\"1\";s:17:\"icon_border_color\";s:7:\"#2ba0a3\";s:23:\"icon_border_color_hover\";s:7:\"#2ba0a3\";s:18:\"icon_border_radius\";a:4:{s:8:\"top_left\";s:3:\"50%\";s:9:\"top_right\";s:3:\"50%\";s:12:\"bottom_right\";s:3:\"50%\";s:11:\"bottom_left\";s:3:\"50%\";}s:15:\"icon_hover_type\";s:4:\"fade\";s:17:\"before_after_type\";s:12:\"before_after\";s:22:\"before_after_font_size\";s:2:\"13\";s:25:\"before_after_accent_color\";s:7:\"#ffffff\";s:28:\"before_after_label_placement\";s:14:\"image-centered\";s:24:\"before_after_handle_type\";s:7:\"default\";s:25:\"before_after_handle_color\";s:7:\"#ffffff\";s:22:\"before_after_handle_bg\";s:19:\"rgba(255,255,255,0)\";s:19:\"before_after_offset\";s:2:\"50\";s:24:\"before_after_orientation\";s:10:\"horizontal\";s:28:\"before_after_handle_movement\";s:10:\"drag_click\";s:28:\"before_after_transition_time\";s:3:\"0.5\";s:24:\"before_after_border_size\";s:1:\"0\";s:25:\"before_after_border_color\";s:7:\"#e2e2e2\";s:26:\"before_after_border_radius\";s:3:\"0px\";s:21:\"imageframe_style_type\";s:4:\"none\";s:15:\"imageframe_blur\";s:1:\"3\";s:20:\"imgframe_style_color\";s:7:\"#000000\";s:22:\"imageframe_border_size\";s:1:\"0\";s:21:\"imgframe_border_color\";s:7:\"#f6f6f6\";s:24:\"imageframe_border_radius\";s:1:\"0\";s:14:\"modal_bg_color\";s:7:\"#f6f6f6\";s:18:\"modal_border_color\";s:7:\"#ebebeb\";s:13:\"person_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:23:\"person_background_color\";s:13:\"rgba(0,0,0,0)\";s:16:\"person_pic_style\";s:4:\"none\";s:21:\"person_pic_style_blur\";s:1:\"3\";s:18:\"person_style_color\";s:7:\"#000000\";s:19:\"person_border_color\";s:7:\"#f6f6f6\";s:18:\"person_border_size\";s:1:\"0\";s:20:\"person_border_radius\";s:1:\"0\";s:16:\"person_alignment\";s:4:\"Left\";s:20:\"person_icon_position\";s:3:\"Top\";s:24:\"popover_heading_bg_color\";s:7:\"#f6f6f6\";s:24:\"popover_content_bg_color\";s:7:\"#ffffff\";s:20:\"popover_border_color\";s:7:\"#ebebeb\";s:18:\"popover_text_color\";s:7:\"#747474\";s:17:\"popover_placement\";s:3:\"Top\";s:29:\"portfolio_featured_image_size\";s:4:\"full\";s:17:\"portfolio_columns\";s:1:\"3\";s:24:\"portfolio_column_spacing\";s:2:\"30\";s:15:\"portfolio_items\";s:2:\"12\";s:21:\"portfolio_text_layout\";s:7:\"unboxed\";s:24:\"portfolio_content_length\";s:7:\"excerpt\";s:24:\"portfolio_excerpt_length\";s:1:\"0\";s:28:\"portfolio_strip_html_excerpt\";s:1:\"1\";s:23:\"portfolio_title_display\";s:3:\"all\";s:24:\"portfolio_text_alignment\";s:4:\"left\";s:24:\"portfolio_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:25:\"portfolio_pagination_type\";s:15:\"infinite_scroll\";s:49:\"portfolio_element_load_more_posts_button_bg_color\";s:7:\"#2e323a\";s:51:\"portfolio_element_load_more_posts_button_text_color\";s:4:\"#fff\";s:55:\"portfolio_element_load_more_posts_hover_button_bg_color\";s:18:\"rgba(46,50,58,0.8)\";s:57:\"portfolio_element_load_more_posts_hover_button_text_color\";s:4:\"#fff\";s:36:\"full_boxed_pricing_box_heading_color\";s:7:\"#242930\";s:29:\"sep_pricing_box_heading_color\";s:7:\"#ffffff\";s:17:\"pricing_box_color\";s:7:\"#5a5d62\";s:16:\"pricing_bg_color\";s:7:\"#ffffff\";s:30:\"pricing_background_color_hover\";s:7:\"#f8f8f8\";s:20:\"pricing_border_color\";s:7:\"#f8f8f8\";s:21:\"pricing_divider_color\";s:7:\"#ffffff\";s:25:\"progressbar_text_position\";s:6:\"on_bar\";s:22:\"progressbar_text_color\";s:7:\"#ffffff\";s:18:\"progressbar_height\";s:4:\"37px\";s:24:\"progressbar_filled_color\";s:19:\"rgba(255,255,255,0)\";s:26:\"progressbar_unfilled_color\";s:19:\"rgba(255,255,255,0)\";s:30:\"progressbar_filled_border_size\";s:1:\"2\";s:31:\"progressbar_filled_border_color\";s:7:\"#ffffff\";s:24:\"scroll_progress_position\";s:4:\"flow\";s:22:\"scroll_progress_height\";s:4:\"10px\";s:32:\"scroll_progress_background_color\";s:7:\"#f2f3f5\";s:30:\"scroll_progress_progress_color\";s:7:\"#65bc7b\";s:27:\"scroll_progress_border_size\";s:1:\"0\";s:28:\"scroll_progress_border_color\";s:7:\"#ffffff\";s:29:\"scroll_progress_border_radius\";a:4:{s:8:\"top_left\";s:3:\"0px\";s:9:\"top_right\";s:3:\"0px\";s:12:\"bottom_right\";s:3:\"0px\";s:11:\"bottom_left\";s:3:\"0px\";}s:23:\"section_sep_border_size\";s:1:\"1\";s:14:\"section_sep_bg\";s:7:\"#f6f6f6\";s:24:\"section_sep_border_color\";s:7:\"#f6f6f6\";s:20:\"separator_style_type\";s:6:\"double\";s:9:\"sep_color\";s:7:\"#e0dede\";s:21:\"separator_border_size\";s:1:\"1\";s:19:\"separator_icon_size\";s:2:\"16\";s:20:\"separator_icon_color\";s:0:\"\";s:16:\"separator_circle\";s:1:\"1\";s:25:\"separator_circle_bg_color\";s:19:\"rgba(255,255,255,0)\";s:19:\"social_links_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:30:\"social_links_tooltip_placement\";s:3:\"Top\";s:22:\"social_links_font_size\";s:4:\"16px\";s:23:\"social_links_color_type\";s:6:\"custom\";s:23:\"social_links_icon_color\";s:7:\"#bebdbd\";s:29:\"social_links_icon_color_hover\";s:21:\"rgba(190,189,189,0.8)\";s:18:\"social_links_boxed\";s:1:\"0\";s:26:\"social_links_boxed_padding\";s:3:\"8px\";s:22:\"social_links_box_color\";s:7:\"#e8e8e8\";s:28:\"social_links_box_color_hover\";s:21:\"rgba(232,232,232,0.8)\";s:19:\"social_links_border\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:25:\"social_links_boxed_radius\";s:3:\"4px\";s:25:\"social_links_border_color\";s:17:\"var(--awb-color3)\";s:31:\"social_links_border_color_hover\";s:17:\"var(--awb-color4)\";s:24:\"syntax_highlighter_theme\";s:7:\"default\";s:31:\"syntax_highlighter_line_numbers\";s:3:\"yes\";s:47:\"syntax_highlighter_line_number_background_color\";s:0:\"\";s:41:\"syntax_highlighter_line_number_text_color\";s:0:\"\";s:32:\"syntax_highlighter_line_wrapping\";s:6:\"scroll\";s:36:\"syntax_highlighter_copy_to_clipboard\";s:3:\"yes\";s:41:\"syntax_highlighter_copy_to_clipboard_text\";s:17:\"Copy to Clipboard\";s:28:\"syntax_highlighter_font_size\";s:2:\"14\";s:35:\"syntax_highlighter_background_color\";s:0:\"\";s:30:\"syntax_highlighter_border_size\";s:1:\"1\";s:31:\"syntax_highlighter_border_color\";s:7:\"#e0dede\";s:31:\"syntax_highlighter_border_style\";s:5:\"solid\";s:25:\"syntax_highlighter_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"tabs_bg_color\";s:7:\"#ffffff\";s:19:\"tabs_inactive_color\";s:7:\"#ebeaea\";s:17:\"tabs_border_color\";s:7:\"#ebeaea\";s:18:\"tabs_icon_position\";s:4:\"left\";s:14:\"tabs_icon_size\";s:2:\"13\";s:11:\"tagcloud_bg\";s:22:\"rgba(255, 255, 255, 0)\";s:17:\"tagcloud_bg_hover\";s:17:\"var(--awb-color4)\";s:14:\"tagcloud_color\";s:97:\"hsla(var(--awb-color1-h),var(--awb-color1-s),var(--awb-color1-l),calc(var(--awb-color1-a) - 20%))\";s:20:\"tagcloud_color_hover\";s:17:\"var(--awb-color1)\";s:21:\"tagcloud_border_color\";s:17:\"var(--awb-color8)\";s:27:\"tagcloud_border_color_hover\";s:17:\"var(--awb-color4)\";s:10:\"tagline_bg\";s:7:\"#f6f6f6\";s:20:\"tagline_border_color\";s:7:\"#f6f6f6\";s:14:\"tagline_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"84px\";}s:20:\"testimonial_bg_color\";s:7:\"#f6f6f6\";s:22:\"testimonial_text_color\";s:7:\"#747474\";s:18:\"testimonials_speed\";s:4:\"4000\";s:19:\"testimonials_random\";s:1:\"0\";s:12:\"text_columns\";s:1:\"1\";s:21:\"text_column_min_width\";s:5:\"100px\";s:19:\"text_column_spacing\";s:3:\"2em\";s:15:\"text_rule_style\";s:4:\"none\";s:14:\"text_rule_size\";s:1:\"1\";s:15:\"text_rule_color\";s:7:\"#e0dede\";s:20:\"title_text_transform\";s:4:\"none\";s:16:\"title_style_type\";s:4:\"none\";s:18:\"title_border_color\";s:7:\"#e0dede\";s:12:\"title_margin\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"30px\";s:4:\"left\";s:3:\"0px\";}s:19:\"title_margin_mobile\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:3:\"0px\";}s:14:\"accordion_type\";s:10:\"accordions\";s:20:\"accordion_boxed_mode\";s:1:\"0\";s:21:\"accordion_border_size\";s:1:\"1\";s:22:\"accordian_border_color\";s:7:\"#cccccc\";s:26:\"accordian_background_color\";s:7:\"#ffffff\";s:21:\"accordian_hover_color\";s:7:\"#f9f9f9\";s:22:\"accordion_divider_line\";s:1:\"1\";s:23:\"accordion_divider_color\";s:7:\"#e0dede\";s:29:\"accordion_divider_hover_color\";s:7:\"#e0dede\";s:26:\"accordion_title_typography\";a:6:{s:11:\"font-family\";s:12:\"IranSansBold\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"18px\";s:5:\"color\";s:7:\"#2ba0a3\";}s:19:\"accordion_icon_size\";s:2:\"13\";s:20:\"accordian_icon_color\";s:7:\"#ffffff\";s:20:\"accordion_icon_boxed\";s:1:\"1\";s:24:\"accordian_inactive_color\";s:7:\"#333333\";s:28:\"accordion_content_typography\";a:6:{s:11:\"font-family\";s:8:\"iranSans\";s:11:\"font-backup\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-size\";s:4:\"16px\";s:5:\"color\";s:7:\"#5a5d62\";}s:22:\"accordian_active_color\";s:7:\"#2ba0a3\";s:29:\"accordian_active_accent_color\";s:0:\"\";s:20:\"accordion_icon_align\";s:4:\"left\";s:21:\"user_login_text_align\";s:6:\"center\";s:28:\"user_login_form_field_layout\";s:7:\"stacked\";s:27:\"user_login_form_show_labels\";s:2:\"no\";s:33:\"user_login_form_show_placeholders\";s:3:\"yes\";s:32:\"user_login_form_show_remember_me\";s:2:\"no\";s:32:\"user_login_form_background_color\";s:7:\"#f6f6f6\";s:15:\"video_max_width\";s:4:\"100%\";s:14:\"video_controls\";s:3:\"yes\";s:13:\"video_preload\";s:4:\"auto\";s:22:\"widget_area_title_size\";s:4:\"18px\";s:23:\"widget_area_title_color\";s:7:\"#242930\";}","yes");
INSERT INTO `a3rfa_options` VALUES("309","avada_imported_demo","false","yes");
INSERT INTO `a3rfa_options` VALUES("908","icl_sitepress_version","3.7.1","yes");
INSERT INTO `a3rfa_options` VALUES("909","icl_sitepress_settings","a:54:{s:19:\"hide_upgrade_notice\";s:5:\"3.7.1\";s:25:\"icl_capabilities_verified\";b:1;s:21:\"interview_translators\";i:1;s:34:\"existing_content_language_verified\";i:1;s:25:\"language_negotiation_type\";s:1:\"1\";s:23:\"theme_localization_type\";i:2;s:18:\"icl_lso_link_empty\";i:0;s:18:\"sync_page_ordering\";i:1;s:16:\"sync_page_parent\";i:1;s:18:\"sync_page_template\";i:1;s:16:\"sync_ping_status\";i:1;s:19:\"sync_comment_status\";i:1;s:16:\"sync_sticky_flag\";i:1;s:13:\"sync_password\";i:1;s:17:\"sync_private_flag\";i:1;s:16:\"sync_post_format\";i:1;s:11:\"sync_delete\";i:0;s:15:\"sync_delete_tax\";i:0;s:20:\"sync_post_taxonomies\";i:1;s:14:\"sync_post_date\";i:0;s:21:\"sync_taxonomy_parents\";i:0;s:25:\"translation_pickup_method\";i:0;s:15:\"notify_complete\";i:1;s:26:\"translated_document_status\";i:1;s:17:\"remote_management\";i:0;s:15:\"auto_adjust_ids\";i:1;s:11:\"alert_delay\";i:0;s:12:\"promote_wpml\";i:0;s:18:\"automatic_redirect\";i:0;s:17:\"remember_language\";i:24;s:28:\"icl_lang_sel_copy_parameters\";s:0:\"\";s:28:\"translated_document_page_url\";s:13:\"auto-generate\";s:28:\"sync_comments_on_duplicates \";i:0;s:3:\"seo\";a:3:{s:10:\"head_langs\";i:1;s:27:\"canonicalization_duplicates\";i:1;s:19:\"head_langs_priority\";i:1;}s:22:\"posts_slug_translation\";a:1:{s:2:\"on\";i:0;}s:15:\"languages_order\";a:2:{i:0;s:2:\"fa\";i:1;s:2:\"en\";}s:4:\"urls\";a:5:{s:30:\"directory_for_default_language\";i:0;s:12:\"show_on_root\";s:0:\"\";s:19:\"root_html_file_path\";s:0:\"\";s:9:\"root_page\";i:0;s:23:\"hide_language_switchers\";i:1;}s:12:\"xdomain_data\";s:1:\"1\";s:16:\"active_languages\";a:2:{i:0;s:2:\"en\";i:1;s:2:\"fa\";}s:22:\"admin_default_language\";s:9:\"_default_\";s:32:\"theme_localization_type_previous\";i:1;s:22:\"taxonomy_names_checked\";b:1;s:14:\"setup_complete\";i:1;s:18:\"ajx_health_checked\";b:1;s:18:\"default_categories\";a:2:{s:2:\"fa\";s:1:\"1\";s:2:\"en\";i:32;}s:16:\"default_language\";s:2:\"fa\";s:17:\"setup_wizard_step\";i:4;s:22:\"translation-management\";a:13:{s:12:\"notification\";a:5:{s:7:\"new-job\";i:1;s:9:\"completed\";i:1;s:8:\"resigned\";i:1;s:9:\"dashboard\";b:1;s:9:\"purge-old\";i:7;}s:25:\"custom_fields_translation\";a:133:{s:5:\"title\";i:2;s:11:\"description\";i:2;s:8:\"keywords\";i:2;s:10:\"_edit_last\";i:0;s:10:\"_edit_lock\";i:0;s:17:\"_wp_page_template\";i:0;s:23:\"_wp_attachment_metadata\";i:0;s:16:\"original_post_id\";i:0;s:22:\"_wpml_original_post_id\";i:0;s:12:\"_wp_old_slug\";i:0;s:20:\"_icl_translator_note\";i:0;s:14:\"_alp_processed\";i:0;s:7:\"_pingme\";i:0;s:10:\"_encloseme\";i:0;s:22:\"_icl_lang_duplicate_of\";i:0;s:13:\"_thumbnail_id\";i:0;s:17:\"_wp_attached_file\";i:0;s:22:\"avada_post_views_count\";i:3;s:12:\"pyre_address\";i:3;s:14:\"pyre_caption_1\";i:3;s:14:\"pyre_caption_2\";i:3;s:13:\"pyre_copy_url\";i:2;s:18:\"pyre_copy_url_text\";i:2;s:19:\"pyre_displayed_menu\";i:3;s:22:\"pyre_display_copyright\";i:3;s:19:\"pyre_display_footer\";i:3;s:19:\"pyre_display_header\";i:3;s:18:\"pyre_elasticslider\";i:3;s:10:\"pyre_email\";i:3;s:13:\"pyre_fallback\";i:3;s:16:\"pyre_fimg_height\";i:3;s:15:\"pyre_fimg_width\";i:3;s:15:\"pyre_flexslider\";i:3;s:15:\"pyre_full_width\";i:3;s:9:\"pyre_gmap\";i:3;s:14:\"pyre_header_bg\";i:3;s:20:\"pyre_header_bg_color\";i:3;s:19:\"pyre_header_bg_full\";i:3;s:21:\"pyre_header_bg_repeat\";i:3;s:21:\"pyre_hundredp_padding\";i:3;s:25:\"pyre_image_rollover_icons\";i:3;s:21:\"pyre_link_icon_target\";i:3;s:18:\"pyre_link_icon_url\";i:2;s:24:\"pyre_main_bottom_padding\";i:3;s:21:\"pyre_main_top_padding\";i:3;s:18:\"pyre_overall_score\";i:3;s:12:\"pyre_page_bg\";i:3;s:18:\"pyre_page_bg_color\";i:3;s:17:\"pyre_page_bg_full\";i:3;s:19:\"pyre_page_bg_layout\";i:3;s:19:\"pyre_page_bg_repeat\";i:3;s:15:\"pyre_page_title\";i:3;s:22:\"pyre_page_title_bar_bg\";i:3;s:28:\"pyre_page_title_bar_bg_color\";i:3;s:27:\"pyre_page_title_bar_bg_full\";i:3;s:29:\"pyre_page_title_bar_bg_retina\";i:3;s:27:\"pyre_page_title_bg_parallax\";i:3;s:32:\"pyre_page_title_custom_subheader\";i:3;s:27:\"pyre_page_title_custom_text\";i:2;s:20:\"page_title_text_size\";i:3;s:25:\"page_title_text_alignment\";i:3;s:37:\"page_title_custom_subheader_text_size\";i:3;s:33:\"page_title_breadcrumbs_search_bar\";i:3;s:20:\"pyre_page_title_text\";i:3;s:10:\"pyre_phone\";i:3;s:23:\"pyre_portfolio_category\";i:3;s:22:\"pyre_portfolio_excerpt\";i:3;s:22:\"pyre_portfolio_filters\";i:3;s:25:\"pyre_portfolio_full_width\";i:3;s:31:\"pyre_portfolio_sidebar_position\";i:3;s:24:\"pyre_portfolio_width_100\";i:3;s:23:\"pyre_project_desc_title\";i:3;s:20:\"pyre_project_details\";i:3;s:16:\"pyre_project_url\";i:3;s:21:\"pyre_project_url_text\";i:2;s:18:\"pyre_related_posts\";i:3;s:14:\"pyre_revslider\";i:3;s:30:\"pyre_show_first_featured_image\";i:3;s:12:\"pyre_sidebar\";i:3;s:21:\"pyre_sidebar_position\";i:3;s:11:\"pyre_slider\";i:3;s:20:\"pyre_slider_position\";i:3;s:16:\"pyre_slider_type\";i:3;s:23:\"pyre_transparent_header\";i:3;s:10:\"pyre_video\";i:2;s:14:\"pyre_video_url\";i:2;s:17:\"pyre_wide_page_bg\";i:3;s:23:\"pyre_wide_page_bg_color\";i:3;s:22:\"pyre_wide_page_bg_full\";i:3;s:24:\"pyre_wide_page_bg_repeat\";i:3;s:10:\"pyre_width\";i:3;s:14:\"pyre_wooslider\";i:3;s:20:\"sbg_selected_sidebar\";i:3;s:32:\"sbg_selected_sidebar_replacement\";i:3;s:22:\"sbg_selected_sidebar_2\";i:3;s:34:\"sbg_selected_sidebar_2_replacement\";i:3;s:14:\"slide_template\";i:3;s:21:\"pyre_avada_rev_styles\";i:3;s:21:\"pyre_footer_100_width\";i:3;s:21:\"pyre_header_100_width\";i:3;s:25:\"pyre_page_title_100_width\";i:3;s:38:\"pyre_page_title_breadcrumbs_search_bar\";i:3;s:30:\"pyre_page_title_text_alignment\";i:3;s:12:\"pyre_heading\";i:2;s:12:\"pyre_caption\";i:2;s:9:\"pyre_type\";i:3;s:22:\"pyre_content_alignment\";i:3;s:9:\"pyre_webm\";i:3;s:8:\"pyre_mp4\";i:3;s:8:\"pyre_ogv\";i:3;s:18:\"pyre_preview_image\";i:3;s:19:\"pyre_video_bg_color\";i:3;s:15:\"pyre_mute_video\";i:3;s:19:\"pyre_autoplay_video\";i:3;s:15:\"pyre_loop_video\";i:3;s:24:\"pyre_hide_video_controls\";i:3;s:15:\"pyre_youtube_id\";i:2;s:17:\"pyre_aspect_ratio\";i:3;s:18:\"pyre_video_display\";i:3;s:13:\"pyre_vimeo_id\";i:2;s:22:\"pyre_heading_font_size\";i:3;s:18:\"pyre_heading_color\";i:3;s:15:\"pyre_heading_bg\";i:3;s:21:\"pyre_heading_bg_color\";i:3;s:22:\"pyre_caption_font_size\";i:3;s:18:\"pyre_caption_color\";i:3;s:15:\"pyre_caption_bg\";i:3;s:21:\"pyre_caption_bg_color\";i:3;s:14:\"pyre_link_type\";i:3;s:13:\"pyre_button_1\";i:2;s:13:\"pyre_button_2\";i:2;s:15:\"pyre_slide_link\";i:3;s:17:\"pyre_slide_target\";i:3;}s:29:\"custom_fields_readonly_config\";a:133:{i:0;s:5:\"title\";i:1;s:11:\"description\";i:2;s:8:\"keywords\";i:3;s:10:\"_edit_last\";i:4;s:10:\"_edit_lock\";i:5;s:17:\"_wp_page_template\";i:6;s:23:\"_wp_attachment_metadata\";i:7;s:16:\"original_post_id\";i:8;s:22:\"_wpml_original_post_id\";i:9;s:12:\"_wp_old_slug\";i:10;s:20:\"_icl_translator_note\";i:11;s:14:\"_alp_processed\";i:12;s:7:\"_pingme\";i:13;s:10:\"_encloseme\";i:14;s:22:\"_icl_lang_duplicate_of\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:22:\"avada_post_views_count\";i:18;s:12:\"pyre_address\";i:19;s:14:\"pyre_caption_1\";i:20;s:14:\"pyre_caption_2\";i:21;s:13:\"pyre_copy_url\";i:22;s:18:\"pyre_copy_url_text\";i:23;s:19:\"pyre_displayed_menu\";i:24;s:22:\"pyre_display_copyright\";i:25;s:19:\"pyre_display_footer\";i:26;s:19:\"pyre_display_header\";i:27;s:18:\"pyre_elasticslider\";i:28;s:10:\"pyre_email\";i:29;s:13:\"pyre_fallback\";i:30;s:16:\"pyre_fimg_height\";i:31;s:15:\"pyre_fimg_width\";i:32;s:15:\"pyre_flexslider\";i:33;s:15:\"pyre_full_width\";i:34;s:9:\"pyre_gmap\";i:35;s:14:\"pyre_header_bg\";i:36;s:20:\"pyre_header_bg_color\";i:37;s:19:\"pyre_header_bg_full\";i:38;s:21:\"pyre_header_bg_repeat\";i:39;s:21:\"pyre_hundredp_padding\";i:40;s:25:\"pyre_image_rollover_icons\";i:41;s:21:\"pyre_link_icon_target\";i:42;s:18:\"pyre_link_icon_url\";i:43;s:24:\"pyre_main_bottom_padding\";i:44;s:21:\"pyre_main_top_padding\";i:45;s:18:\"pyre_overall_score\";i:46;s:12:\"pyre_page_bg\";i:47;s:18:\"pyre_page_bg_color\";i:48;s:17:\"pyre_page_bg_full\";i:49;s:19:\"pyre_page_bg_layout\";i:50;s:19:\"pyre_page_bg_repeat\";i:51;s:15:\"pyre_page_title\";i:52;s:22:\"pyre_page_title_bar_bg\";i:53;s:28:\"pyre_page_title_bar_bg_color\";i:54;s:27:\"pyre_page_title_bar_bg_full\";i:55;s:29:\"pyre_page_title_bar_bg_retina\";i:56;s:27:\"pyre_page_title_bg_parallax\";i:57;s:32:\"pyre_page_title_custom_subheader\";i:58;s:27:\"pyre_page_title_custom_text\";i:59;s:20:\"page_title_text_size\";i:60;s:25:\"page_title_text_alignment\";i:61;s:37:\"page_title_custom_subheader_text_size\";i:62;s:33:\"page_title_breadcrumbs_search_bar\";i:63;s:20:\"pyre_page_title_text\";i:64;s:10:\"pyre_phone\";i:65;s:23:\"pyre_portfolio_category\";i:66;s:22:\"pyre_portfolio_excerpt\";i:67;s:22:\"pyre_portfolio_filters\";i:68;s:25:\"pyre_portfolio_full_width\";i:69;s:31:\"pyre_portfolio_sidebar_position\";i:70;s:24:\"pyre_portfolio_width_100\";i:71;s:23:\"pyre_project_desc_title\";i:72;s:20:\"pyre_project_details\";i:73;s:16:\"pyre_project_url\";i:74;s:21:\"pyre_project_url_text\";i:75;s:18:\"pyre_related_posts\";i:76;s:14:\"pyre_revslider\";i:77;s:30:\"pyre_show_first_featured_image\";i:78;s:12:\"pyre_sidebar\";i:79;s:21:\"pyre_sidebar_position\";i:80;s:11:\"pyre_slider\";i:81;s:20:\"pyre_slider_position\";i:82;s:16:\"pyre_slider_type\";i:83;s:23:\"pyre_transparent_header\";i:84;s:10:\"pyre_video\";i:85;s:14:\"pyre_video_url\";i:86;s:17:\"pyre_wide_page_bg\";i:87;s:23:\"pyre_wide_page_bg_color\";i:88;s:22:\"pyre_wide_page_bg_full\";i:89;s:24:\"pyre_wide_page_bg_repeat\";i:90;s:10:\"pyre_width\";i:91;s:14:\"pyre_wooslider\";i:92;s:20:\"sbg_selected_sidebar\";i:93;s:32:\"sbg_selected_sidebar_replacement\";i:94;s:22:\"sbg_selected_sidebar_2\";i:95;s:34:\"sbg_selected_sidebar_2_replacement\";i:96;s:14:\"slide_template\";i:97;s:21:\"pyre_avada_rev_styles\";i:98;s:21:\"pyre_footer_100_width\";i:99;s:21:\"pyre_header_100_width\";i:100;s:25:\"pyre_page_title_100_width\";i:101;s:38:\"pyre_page_title_breadcrumbs_search_bar\";i:102;s:30:\"pyre_page_title_text_alignment\";i:104;s:12:\"pyre_heading\";i:105;s:12:\"pyre_caption\";i:106;s:9:\"pyre_type\";i:107;s:22:\"pyre_content_alignment\";i:108;s:9:\"pyre_webm\";i:109;s:8:\"pyre_mp4\";i:110;s:8:\"pyre_ogv\";i:111;s:18:\"pyre_preview_image\";i:112;s:19:\"pyre_video_bg_color\";i:113;s:15:\"pyre_mute_video\";i:114;s:19:\"pyre_autoplay_video\";i:115;s:15:\"pyre_loop_video\";i:116;s:24:\"pyre_hide_video_controls\";i:117;s:15:\"pyre_youtube_id\";i:118;s:17:\"pyre_aspect_ratio\";i:119;s:18:\"pyre_video_display\";i:120;s:13:\"pyre_vimeo_id\";i:121;s:22:\"pyre_heading_font_size\";i:122;s:18:\"pyre_heading_color\";i:123;s:15:\"pyre_heading_bg\";i:124;s:21:\"pyre_heading_bg_color\";i:125;s:22:\"pyre_caption_font_size\";i:126;s:18:\"pyre_caption_color\";i:127;s:15:\"pyre_caption_bg\";i:128;s:21:\"pyre_caption_bg_color\";i:129;s:14:\"pyre_link_type\";i:130;s:13:\"pyre_button_1\";i:131;s:13:\"pyre_button_2\";i:132;s:15:\"pyre_slide_link\";i:133;s:17:\"pyre_slide_target\";}s:32:\"custom_fields_translation_custom\";a:0:{}s:41:\"custom_fields_translation_custom_readonly\";a:0:{}s:22:\"doc_translation_method\";i:0;s:35:\"__custom_types_readonly_config_prev\";a:0:{}s:28:\"custom_types_readonly_config\";a:0:{}s:36:\"__custom_fields_readonly_config_prev\";a:133:{i:0;s:5:\"title\";i:1;s:11:\"description\";i:2;s:8:\"keywords\";i:3;s:10:\"_edit_last\";i:4;s:10:\"_edit_lock\";i:5;s:17:\"_wp_page_template\";i:6;s:23:\"_wp_attachment_metadata\";i:7;s:16:\"original_post_id\";i:8;s:22:\"_wpml_original_post_id\";i:9;s:12:\"_wp_old_slug\";i:10;s:20:\"_icl_translator_note\";i:11;s:14:\"_alp_processed\";i:12;s:7:\"_pingme\";i:13;s:10:\"_encloseme\";i:14;s:22:\"_icl_lang_duplicate_of\";i:15;s:13:\"_thumbnail_id\";i:16;s:17:\"_wp_attached_file\";i:17;s:22:\"avada_post_views_count\";i:18;s:12:\"pyre_address\";i:19;s:14:\"pyre_caption_1\";i:20;s:14:\"pyre_caption_2\";i:21;s:13:\"pyre_copy_url\";i:22;s:18:\"pyre_copy_url_text\";i:23;s:19:\"pyre_displayed_menu\";i:24;s:22:\"pyre_display_copyright\";i:25;s:19:\"pyre_display_footer\";i:26;s:19:\"pyre_display_header\";i:27;s:18:\"pyre_elasticslider\";i:28;s:10:\"pyre_email\";i:29;s:13:\"pyre_fallback\";i:30;s:16:\"pyre_fimg_height\";i:31;s:15:\"pyre_fimg_width\";i:32;s:15:\"pyre_flexslider\";i:33;s:15:\"pyre_full_width\";i:34;s:9:\"pyre_gmap\";i:35;s:14:\"pyre_header_bg\";i:36;s:20:\"pyre_header_bg_color\";i:37;s:19:\"pyre_header_bg_full\";i:38;s:21:\"pyre_header_bg_repeat\";i:39;s:21:\"pyre_hundredp_padding\";i:40;s:25:\"pyre_image_rollover_icons\";i:41;s:21:\"pyre_link_icon_target\";i:42;s:18:\"pyre_link_icon_url\";i:43;s:24:\"pyre_main_bottom_padding\";i:44;s:21:\"pyre_main_top_padding\";i:45;s:18:\"pyre_overall_score\";i:46;s:12:\"pyre_page_bg\";i:47;s:18:\"pyre_page_bg_color\";i:48;s:17:\"pyre_page_bg_full\";i:49;s:19:\"pyre_page_bg_layout\";i:50;s:19:\"pyre_page_bg_repeat\";i:51;s:15:\"pyre_page_title\";i:52;s:22:\"pyre_page_title_bar_bg\";i:53;s:28:\"pyre_page_title_bar_bg_color\";i:54;s:27:\"pyre_page_title_bar_bg_full\";i:55;s:29:\"pyre_page_title_bar_bg_retina\";i:56;s:27:\"pyre_page_title_bg_parallax\";i:57;s:32:\"pyre_page_title_custom_subheader\";i:58;s:27:\"pyre_page_title_custom_text\";i:59;s:20:\"page_title_text_size\";i:60;s:25:\"page_title_text_alignment\";i:61;s:37:\"page_title_custom_subheader_text_size\";i:62;s:33:\"page_title_breadcrumbs_search_bar\";i:63;s:20:\"pyre_page_title_text\";i:64;s:10:\"pyre_phone\";i:65;s:23:\"pyre_portfolio_category\";i:66;s:22:\"pyre_portfolio_excerpt\";i:67;s:22:\"pyre_portfolio_filters\";i:68;s:25:\"pyre_portfolio_full_width\";i:69;s:31:\"pyre_portfolio_sidebar_position\";i:70;s:24:\"pyre_portfolio_width_100\";i:71;s:23:\"pyre_project_desc_title\";i:72;s:20:\"pyre_project_details\";i:73;s:16:\"pyre_project_url\";i:74;s:21:\"pyre_project_url_text\";i:75;s:18:\"pyre_related_posts\";i:76;s:14:\"pyre_revslider\";i:77;s:30:\"pyre_show_first_featured_image\";i:78;s:12:\"pyre_sidebar\";i:79;s:21:\"pyre_sidebar_position\";i:80;s:11:\"pyre_slider\";i:81;s:20:\"pyre_slider_position\";i:82;s:16:\"pyre_slider_type\";i:83;s:23:\"pyre_transparent_header\";i:84;s:10:\"pyre_video\";i:85;s:14:\"pyre_video_url\";i:86;s:17:\"pyre_wide_page_bg\";i:87;s:23:\"pyre_wide_page_bg_color\";i:88;s:22:\"pyre_wide_page_bg_full\";i:89;s:24:\"pyre_wide_page_bg_repeat\";i:90;s:10:\"pyre_width\";i:91;s:14:\"pyre_wooslider\";i:92;s:20:\"sbg_selected_sidebar\";i:93;s:32:\"sbg_selected_sidebar_replacement\";i:94;s:22:\"sbg_selected_sidebar_2\";i:95;s:34:\"sbg_selected_sidebar_2_replacement\";i:96;s:14:\"slide_template\";i:97;s:21:\"pyre_avada_rev_styles\";i:98;s:21:\"pyre_footer_100_width\";i:99;s:21:\"pyre_header_100_width\";i:100;s:25:\"pyre_page_title_100_width\";i:101;s:38:\"pyre_page_title_breadcrumbs_search_bar\";i:102;s:30:\"pyre_page_title_text_alignment\";i:104;s:12:\"pyre_heading\";i:105;s:12:\"pyre_caption\";i:106;s:9:\"pyre_type\";i:107;s:22:\"pyre_content_alignment\";i:108;s:9:\"pyre_webm\";i:109;s:8:\"pyre_mp4\";i:110;s:8:\"pyre_ogv\";i:111;s:18:\"pyre_preview_image\";i:112;s:19:\"pyre_video_bg_color\";i:113;s:15:\"pyre_mute_video\";i:114;s:19:\"pyre_autoplay_video\";i:115;s:15:\"pyre_loop_video\";i:116;s:24:\"pyre_hide_video_controls\";i:117;s:15:\"pyre_youtube_id\";i:118;s:17:\"pyre_aspect_ratio\";i:119;s:18:\"pyre_video_display\";i:120;s:13:\"pyre_vimeo_id\";i:121;s:22:\"pyre_heading_font_size\";i:122;s:18:\"pyre_heading_color\";i:123;s:15:\"pyre_heading_bg\";i:124;s:21:\"pyre_heading_bg_color\";i:125;s:22:\"pyre_caption_font_size\";i:126;s:18:\"pyre_caption_color\";i:127;s:15:\"pyre_caption_bg\";i:128;s:21:\"pyre_caption_bg_color\";i:129;s:14:\"pyre_link_type\";i:130;s:13:\"pyre_button_1\";i:131;s:13:\"pyre_button_2\";i:132;s:15:\"pyre_slide_link\";i:133;s:17:\"pyre_slide_target\";}s:41:\"__custom_term_fields_readonly_config_prev\";a:0:{}s:34:\"custom_term_fields_readonly_config\";a:0:{}s:26:\"taxonomies_readonly_config\";a:6:{s:18:\"portfolio_category\";i:1;s:12:\"faq_category\";i:1;s:16:\"portfolio_skills\";i:1;s:14:\"portfolio_tags\";i:1;s:21:\"themefusion_es_groups\";i:1;s:10:\"slide-page\";i:1;}s:28:\"custom-types_readonly_config\";a:6:{s:19:\"themefusion_elastic\";i:1;s:5:\"slide\";i:1;s:11:\"layerslider\";i:1;s:9:\"revslider\";i:1;s:9:\"avada_faq\";i:1;s:15:\"avada_portfolio\";i:1;}}s:24:\"custom_posts_sync_option\";a:6:{s:19:\"themefusion_elastic\";i:1;s:5:\"slide\";i:1;s:11:\"layerslider\";i:1;s:9:\"revslider\";i:1;s:9:\"avada_faq\";i:1;s:15:\"avada_portfolio\";i:1;}s:22:\"taxonomies_sync_option\";a:6:{s:18:\"portfolio_category\";i:1;s:12:\"faq_category\";i:1;s:16:\"portfolio_skills\";i:1;s:14:\"portfolio_tags\";i:1;s:21:\"themefusion_es_groups\";i:1;s:10:\"slide-page\";i:1;}s:24:\"custom-types_sync_option\";a:6:{s:19:\"themefusion_elastic\";i:1;s:5:\"slide\";i:1;s:11:\"layerslider\";i:1;s:9:\"revslider\";i:1;s:9:\"avada_faq\";i:1;s:15:\"avada_portfolio\";i:1;}s:29:\"language_selector_initialized\";i:1;s:21:\"site_does_not_use_icl\";b:1;s:31:\"language_per_domain_sso_enabled\";b:0;}","yes");
INSERT INTO `a3rfa_options` VALUES("383","ztjalali_options","{\"force_timezone\":false,\"change_date_to_jalali\":true,\"change_jdate_number_to_persian\":false,\"change_url_date_to_jalali\":false,\"afghan_month_name\":false,\"disallow_month_short_name\":true,\"change_title_number_to_persian\":false,\"change_content_number_to_persian\":false,\"change_excerpt_number_to_persian\":false,\"change_comment_number_to_persian\":false,\"change_commentcount_number_to_persian\":false,\"change_category_number_to_persian\":false,\"change_point_to_persian\":false,\"change_arabic_to_persian\":true,\"change_archive_title\":true,\"save_changes_in_db\":false,\"ztjalali_admin_style\":false,\"persian_planet\":true}","yes");
INSERT INTO `a3rfa_options` VALUES("384","ztjalali_version","5.0.1","yes");
INSERT INTO `a3rfa_options` VALUES("386","widget_ztjalali_archive","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("387","widget_ztjalali_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("989","slide-page_children","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("419","new_admin_email","YourEmail@yahoo.com","yes");
INSERT INTO `a3rfa_options` VALUES("928","category_children_all","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("1065","category_children","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("933","fusion_options_fa","a:698:{s:8:\"last_tab\";s:0:\"\";s:6:\"layout\";s:4:\"Wide\";s:10:\"site_width\";s:6:\"1170px\";s:13:\"margin_offset\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";}s:13:\"scroll_offset\";s:4:\"full\";s:18:\"boxed_modal_shadow\";s:4:\"None\";s:12:\"main_padding\";a:2:{s:3:\"top\";s:4:\"90px\";s:6:\"bottom\";s:4:\"45px\";}s:16:\"hundredp_padding\";s:4:\"40px\";s:13:\"sidebar_width\";s:3:\"25%\";s:17:\"sidebar_2_1_width\";s:3:\"21%\";s:17:\"sidebar_2_2_width\";s:3:\"21%\";s:10:\"nav_height\";s:2:\"96\";s:20:\"menu_highlight_style\";s:3:\"bar\";s:25:\"menu_highlight_background\";s:7:\"#a0ce4e\";s:15:\"menu_arrow_size\";a:2:{s:5:\"width\";s:4:\"23px\";s:6:\"height\";s:4:\"12px\";}s:20:\"nav_highlight_border\";s:1:\"1\";s:11:\"nav_padding\";s:2:\"45\";s:15:\"megamenu_shadow\";s:1:\"1\";s:19:\"dropdown_menu_width\";s:3:\"180\";s:34:\"mainmenu_dropdown_vertical_padding\";s:2:\"12\";s:33:\"mainmenu_dropdown_display_divider\";s:1:\"1\";s:31:\"menu_display_dropdown_indicator\";s:1:\"1\";s:20:\"main_nav_search_icon\";s:1:\"0\";s:20:\"main_nav_icon_circle\";s:1:\"0\";s:25:\"main_nav_highlight_radius\";s:3:\"0px\";s:17:\"menu_sub_bg_color\";s:7:\"#24272d\";s:19:\"menu_bg_hover_color\";s:7:\"#292d33\";s:18:\"menu_sub_sep_color\";s:7:\"#292d33\";s:17:\"menu_h45_bg_color\";s:7:\"#ffffff\";s:14:\"nav_typography\";a:10:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:14:\"letter-spacing\";s:3:\"0px\";s:5:\"color\";s:7:\"#ffffff\";}s:22:\"menu_hover_first_color\";s:7:\"#ffffff\";s:22:\"nav_dropdown_font_size\";s:4:\"13px\";s:18:\"side_nav_font_size\";s:4:\"14px\";s:15:\"menu_text_align\";s:4:\"left\";s:14:\"menu_sub_color\";s:7:\"#ffffff\";s:26:\"flyout_menu_icon_font_size\";s:4:\"20px\";s:24:\"flyout_nav_icons_padding\";s:2:\"45\";s:22:\"flyout_menu_icon_color\";s:7:\"#333333\";s:28:\"flyout_menu_icon_hover_color\";s:7:\"#a0ce4e\";s:28:\"flyout_menu_background_color\";s:22:\"rgba(255,255,255,0.95)\";s:21:\"flyout_menu_direction\";s:4:\"fade\";s:23:\"topmenu_dropwdown_width\";s:3:\"180\";s:29:\"header_top_first_border_color\";s:7:\"#e5e5e5\";s:23:\"header_top_sub_bg_color\";s:7:\"#ffffff\";s:30:\"header_top_menu_bg_hover_color\";s:7:\"#fafafa\";s:29:\"header_top_menu_sub_sep_color\";s:7:\"#e5e5e5\";s:14:\"snav_font_size\";s:4:\"14px\";s:11:\"sec_menu_lh\";s:4:\"44px\";s:10:\"snav_color\";s:7:\"#747474\";s:25:\"header_top_menu_sub_color\";s:7:\"#747474\";s:31:\"header_top_menu_sub_hover_color\";s:7:\"#333333\";s:18:\"mobile_menu_design\";s:6:\"modern\";s:18:\"mobile_nav_padding\";s:2:\"25\";s:28:\"mobile_menu_icons_top_margin\";s:1:\"3\";s:22:\"mobile_menu_nav_height\";s:2:\"48\";s:27:\"mobile_nav_submenu_slideout\";s:1:\"1\";s:22:\"mobile_header_bg_color\";s:7:\"#24272d\";s:28:\"mobile_menu_background_color\";s:7:\"#24272d\";s:23:\"mobile_menu_hover_color\";s:7:\"#292d33\";s:24:\"mobile_menu_border_color\";s:7:\"#292d33\";s:24:\"mobile_menu_toggle_color\";s:7:\"#ffffff\";s:22:\"mobile_menu_typography\";a:11:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"48px\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#ffffff\";}s:28:\"mobile_menu_font_hover_color\";s:7:\"#ffffff\";s:22:\"mobile_menu_text_align\";s:4:\"left\";s:18:\"megamenu_max_width\";s:4:\"1100\";s:19:\"megamenu_title_size\";s:4:\"18px\";s:30:\"megamenu_item_vertical_padding\";s:1:\"5\";s:29:\"megamenu_item_display_divider\";s:1:\"0\";s:18:\"menu_icon_position\";s:4:\"left\";s:14:\"menu_icon_size\";s:2:\"14\";s:15:\"menu_icon_color\";s:7:\"#ffffff\";s:21:\"menu_icon_hover_color\";s:7:\"#2ba0a3\";s:19:\"menu_thumbnail_size\";a:2:{s:5:\"width\";s:4:\"26px\";s:6:\"height\";s:4:\"14px\";}s:10:\"responsive\";s:1:\"1\";s:21:\"grid_main_break_point\";s:4:\"1099\";s:23:\"side_header_break_point\";s:3:\"920\";s:19:\"content_break_point\";s:3:\"800\";s:19:\"sidebar_break_point\";s:3:\"800\";s:11:\"mobile_zoom\";s:1:\"1\";s:21:\"typography_responsive\";s:1:\"1\";s:22:\"typography_sensitivity\";s:4:\"0.60\";s:17:\"typography_factor\";s:3:\"1.5\";s:13:\"primary_color\";s:7:\"#2ba0a3\";s:15:\"header_position\";s:3:\"Top\";s:13:\"header_layout\";s:2:\"v1\";s:15:\"slider_position\";s:5:\"Below\";s:19:\"header_left_content\";s:12:\"Contact Info\";s:20:\"header_right_content\";s:10:\"Navigation\";s:17:\"header_v4_content\";s:18:\"Tagline And Search\";s:13:\"header_number\";s:28:\"Call Us Today! 1.555.555.555\";s:12:\"header_email\";s:19:\"info@yourdomain.com\";s:14:\"header_tagline\";s:19:\"Insert Tagline Here\";s:18:\"header_banner_code\";s:0:\"\";s:15:\"header_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"header_bg_full\";s:1:\"0\";s:18:\"header_bg_parallax\";s:1:\"1\";s:16:\"header_bg_repeat\";s:6:\"repeat\";s:17:\"side_header_width\";s:3:\"280\";s:14:\"header_padding\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"header_shadow\";s:1:\"0\";s:16:\"header_100_width\";s:1:\"0\";s:15:\"header_bg_color\";s:7:\"#24272d\";s:19:\"header_border_color\";s:7:\"#ffffff\";s:19:\"header_top_bg_color\";s:7:\"#2ba0a3\";s:17:\"tagline_font_size\";s:4:\"16px\";s:18:\"tagline_font_color\";s:7:\"#ffffff\";s:13:\"header_sticky\";s:1:\"1\";s:20:\"header_sticky_tablet\";s:1:\"0\";s:20:\"header_sticky_mobile\";s:1:\"0\";s:23:\"header_sticky_shrinkage\";s:1:\"0\";s:26:\"header_sticky_type2_layout\";s:9:\"menu_only\";s:22:\"header_sticky_bg_color\";s:7:\"#24272d\";s:24:\"header_sticky_menu_color\";s:7:\"#ffffff\";s:25:\"header_sticky_nav_padding\";s:2:\"45\";s:27:\"header_sticky_nav_font_size\";s:4:\"14px\";s:14:\"logo_alignment\";s:4:\"Left\";s:11:\"logo_margin\";a:4:{s:3:\"top\";s:4:\"31px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"31px\";s:4:\"left\";s:3:\"0px\";}s:15:\"logo_background\";s:1:\"0\";s:21:\"logo_background_color\";s:7:\"#a0ce4e\";s:4:\"logo\";a:5:{s:3:\"url\";s:89:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2015/02/logo-avada-architect.png\";s:2:\"id\";s:3:\"230\";s:6:\"height\";s:2:\"34\";s:5:\"width\";s:3:\"240\";s:9:\"thumbnail\";s:89:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2015/02/logo-avada-architect.png\";}s:11:\"logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"sticky_header_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"sticky_header_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"mobile_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"mobile_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"favicon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"iphone_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"iphone_icon_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:9:\"ipad_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"ipad_icon_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"page_title_bar\";s:4:\"hide\";s:19:\"page_title_bar_text\";s:1:\"1\";s:20:\"page_title_100_width\";s:1:\"0\";s:17:\"page_title_height\";s:4:\"87px\";s:24:\"page_title_mobile_height\";s:4:\"70px\";s:19:\"page_title_bg_color\";s:7:\"#2ba0a3\";s:23:\"page_title_border_color\";s:7:\"#2ba0a3\";s:20:\"page_title_font_size\";s:4:\"18px\";s:22:\"page_title_line_height\";s:4:\"1.33\";s:16:\"page_title_color\";s:7:\"#ffffff\";s:30:\"page_title_subheader_font_size\";s:4:\"14px\";s:20:\"page_title_alignment\";s:4:\"left\";s:13:\"page_title_bg\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"page_title_bg_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"page_title_bg_full\";s:1:\"0\";s:22:\"page_title_bg_parallax\";s:1:\"0\";s:17:\"page_title_fading\";s:1:\"0\";s:17:\"page_title_bar_bs\";s:11:\"Breadcrumbs\";s:17:\"breadcrumb_mobile\";s:1:\"0\";s:16:\"breacrumb_prefix\";s:0:\"\";s:20:\"breadcrumb_separator\";s:1:\"/\";s:21:\"breadcrumbs_font_size\";s:4:\"10px\";s:22:\"breadcrumbs_text_color\";s:7:\"#ffffff\";s:26:\"breadcrumb_show_categories\";s:1:\"1\";s:33:\"breadcrumb_show_post_type_archive\";s:1:\"0\";s:18:\"slidingbar_widgets\";s:1:\"0\";s:25:\"mobile_slidingbar_widgets\";s:1:\"1\";s:19:\"slidingbar_position\";s:3:\"top\";s:17:\"slidingbar_sticky\";s:1:\"0\";s:23:\"slidingbar_open_on_load\";s:1:\"0\";s:26:\"slidingbar_widgets_columns\";s:1:\"2\";s:24:\"slidingbar_content_align\";s:4:\"left\";s:23:\"slidingbar_toggle_style\";s:8:\"triangle\";s:19:\"slidingbar_bg_color\";s:19:\"rgba(36,39,45,0.95)\";s:24:\"slidingbar_divider_color\";s:7:\"#282a2b\";s:28:\"slidingbar_toggle_icon_color\";s:7:\"#ffffff\";s:20:\"slidingbar_font_size\";s:4:\"18px\";s:25:\"slidingbar_headings_color\";s:7:\"#dddddd\";s:21:\"slidingbar_text_color\";s:7:\"#8c8989\";s:21:\"slidingbar_link_color\";s:7:\"#bfbfbf\";s:17:\"slidingbar_border\";s:1:\"0\";s:14:\"footer_widgets\";s:1:\"1\";s:22:\"footer_widgets_columns\";s:1:\"2\";s:29:\"footer_widgets_center_content\";s:1:\"0\";s:22:\"footer_special_effects\";s:4:\"none\";s:16:\"footer_copyright\";s:1:\"1\";s:31:\"footer_copyright_center_content\";s:1:\"0\";s:11:\"footer_text\";s:658:\"   |   © Copyright 2012 - <script>document.write(new Date().getFullYear());</script>   |   قالب آوادا توسط <a href=\'http://theme-fusion.com\' target=\'_blank\' rel=\"nofollow\">تم فیوژن</a>   |   تمام حقوق محفوظ می‌باشد   |   قدرت گرفته از <a href=\'http://wordpress.org\' target=\'_blank\' rel=\"nofollow\">وردپرس</a>         

<span style=\"float:right;color:#fff\"><i class=\"fa fa-phone\"></i>  021.200.555.67         <a href=\"mailto:support@iranavada.com\" style=\"color:#fff;text-transform:uppercase;\"><i class=\"fa fa-envelope-o\"></i> ایمیل ما  </a></span>\";s:16:\"footerw_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"footerw_bg_full\";s:1:\"0\";s:17:\"footerw_bg_repeat\";s:6:\"repeat\";s:14:\"footerw_bg_pos\";s:13:\"center center\";s:16:\"footer_100_width\";s:1:\"0\";s:19:\"footer_area_padding\";a:4:{s:3:\"top\";s:4:\"43px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"40px\";s:4:\"left\";s:3:\"0px\";}s:15:\"footer_bg_color\";s:7:\"#24272d\";s:18:\"footer_border_size\";s:2:\"12\";s:19:\"footer_border_color\";s:7:\"#24272d\";s:20:\"footer_divider_color\";s:7:\"#505152\";s:17:\"copyright_padding\";a:2:{s:3:\"top\";s:4:\"18px\";s:6:\"bottom\";s:4:\"18px\";}s:18:\"copyright_bg_color\";s:7:\"#2b2e35\";s:21:\"copyright_border_size\";s:1:\"1\";s:22:\"copyright_border_color\";s:7:\"#2b2e35\";s:26:\"footer_headings_typography\";a:11:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#ffffff\";}s:17:\"footer_text_color\";s:7:\"#5a5d62\";s:17:\"footer_link_color\";s:7:\"#868a92\";s:23:\"footer_link_color_hover\";s:7:\"#2ba0a3\";s:20:\"copyright_text_color\";s:7:\"#5a5d62\";s:20:\"copyright_link_color\";s:7:\"#868a92\";s:26:\"copyright_link_color_hover\";s:7:\"#2ba0a3\";s:19:\"copyright_font_size\";s:4:\"12px\";s:14:\"sidebar_sticky\";s:4:\"none\";s:15:\"sidebar_padding\";s:2:\"3%\";s:16:\"sidebar_bg_color\";s:7:\"#f8f8f8\";s:23:\"sidebar_widget_bg_color\";s:19:\"rgba(255,255,255,0)\";s:15:\"sidew_font_size\";s:4:\"18px\";s:21:\"sidebar_heading_color\";s:7:\"#333333\";s:20:\"pages_global_sidebar\";s:1:\"0\";s:13:\"pages_sidebar\";s:4:\"None\";s:15:\"pages_sidebar_2\";s:4:\"None\";s:19:\"default_sidebar_pos\";s:5:\"Right\";s:24:\"portfolio_global_sidebar\";s:1:\"0\";s:17:\"portfolio_sidebar\";s:4:\"None\";s:19:\"portfolio_sidebar_2\";s:4:\"None\";s:26:\"portfolio_sidebar_position\";s:5:\"Right\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:27:\"portfolio_archive_sidebar_2\";s:4:\"None\";s:20:\"posts_global_sidebar\";s:1:\"1\";s:13:\"posts_sidebar\";s:12:\"Blog Sidebar\";s:15:\"posts_sidebar_2\";s:4:\"None\";s:21:\"blog_sidebar_position\";s:4:\"Left\";s:20:\"blog_archive_sidebar\";s:12:\"Blog Sidebar\";s:22:\"blog_archive_sidebar_2\";s:4:\"None\";s:14:\"search_sidebar\";s:12:\"Blog Sidebar\";s:16:\"search_sidebar_2\";s:4:\"None\";s:23:\"search_sidebar_position\";s:5:\"Right\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:16:\"content_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"content_bg_full\";s:1:\"0\";s:17:\"content_bg_repeat\";s:6:\"repeat\";s:8:\"bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"bg_full\";s:1:\"0\";s:9:\"bg_repeat\";s:6:\"repeat\";s:8:\"bg_color\";s:7:\"#d7d6d6\";s:17:\"bg_pattern_option\";s:1:\"0\";s:10:\"bg_pattern\";s:8:\"pattern1\";s:15:\"body_typography\";a:11:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"15px\";s:11:\"line-height\";s:4:\"2.27\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#5a5d62\";}s:10:\"link_color\";s:7:\"#2ba0a3\";s:13:\"h1_typography\";a:13:{s:11:\"font-family\";s:5:\"Dinar\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"60px\";s:11:\"line-height\";s:4:\"1.33\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"0.67em\";s:13:\"margin-bottom\";s:6:\"0.67em\";s:5:\"color\";s:7:\"#ffffff\";}s:13:\"h2_typography\";a:13:{s:11:\"font-family\";s:5:\"Dinar\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"1.25\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"1.0em\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h3_typography\";a:13:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"22px\";s:11:\"line-height\";s:4:\"1.91\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"1em\";s:13:\"margin-bottom\";s:3:\"0em\";s:5:\"color\";s:7:\"#5a5d62\";}s:13:\"h4_typography\";a:13:{s:11:\"font-family\";s:12:\"IranSansBold\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:4:\"2.11\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"1.33em\";s:13:\"margin-bottom\";s:6:\"1.33em\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h5_typography\";a:13:{s:11:\"font-family\";s:12:\"IranSansBold\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"1.29\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"1.67em\";s:13:\"margin-bottom\";s:6:\"1.67em\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h6_typography\";a:13:{s:11:\"font-family\";s:12:\"IranSansBold\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"11px\";s:11:\"line-height\";s:4:\"1.55\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"2.33em\";s:13:\"margin-bottom\";s:6:\"2.33em\";s:5:\"color\";s:7:\"#242930\";}s:21:\"post_titles_font_size\";s:4:\"22px\";s:19:\"post_titles_font_lh\";s:4:\"32px\";s:28:\"post_titles_extras_font_size\";s:4:\"22px\";s:12:\"custom_fonts\";a:7:{s:25:\"fusionredux_repeater_data\";a:3:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"name\";a:3:{i:0;s:8:\"iranSans\";i:1;s:12:\"IranSansBold\";i:2;s:5:\"Dinar\";}s:4:\"woff\";a:3:{i:0;a:5:{s:3:\"url\";s:86:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.woff\";s:2:\"id\";s:3:\"685\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:86:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.woff\";s:2:\"id\";s:3:\"688\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:75:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.woff\";s:2:\"id\";s:3:\"694\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}s:5:\"woff2\";a:3:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"ttf\";a:3:{i:0;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.ttf\";s:2:\"id\";s:3:\"684\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.ttf\";s:2:\"id\";s:3:\"687\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:74:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.ttf\";s:2:\"id\";s:3:\"696\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}s:3:\"svg\";a:3:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"eot\";a:3:{i:0;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.eot\";s:2:\"id\";s:3:\"686\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.eot\";s:2:\"id\";s:3:\"689\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:74:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.eot\";s:2:\"id\";s:3:\"695\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}}s:19:\"blog_page_title_bar\";s:4:\"hide\";s:24:\"blog_show_page_title_bar\";s:4:\"hide\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:11:\"blog_layout\";s:5:\"Large\";s:19:\"blog_archive_layout\";s:6:\"Medium\";s:20:\"blog_pagination_type\";s:10:\"Pagination\";s:36:\"blog_load_more_posts_button_bg_color\";s:7:\"#2e323a\";s:17:\"blog_grid_columns\";s:1:\"3\";s:24:\"blog_grid_column_spacing\";s:2:\"40\";s:18:\"blog_equal_heights\";s:1:\"0\";s:25:\"blog_archive_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:14:\"content_length\";s:7:\"Excerpt\";s:19:\"excerpt_length_blog\";s:2:\"55\";s:18:\"strip_html_excerpt\";s:1:\"1\";s:15:\"featured_images\";s:1:\"1\";s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:14:\"blog_width_100\";s:1:\"0\";s:22:\"featured_images_single\";s:1:\"1\";s:11:\"blog_pn_nav\";s:1:\"0\";s:15:\"blog_post_title\";s:5:\"below\";s:23:\"blog_post_meta_position\";s:13:\"below_article\";s:11:\"author_info\";s:1:\"0\";s:18:\"social_sharing_box\";s:1:\"1\";s:13:\"related_posts\";s:1:\"1\";s:13:\"blog_comments\";s:1:\"0\";s:9:\"post_meta\";s:1:\"1\";s:16:\"post_meta_author\";s:1:\"1\";s:14:\"post_meta_date\";s:1:\"1\";s:14:\"post_meta_cats\";s:1:\"1\";s:18:\"post_meta_comments\";s:1:\"1\";s:14:\"post_meta_read\";s:1:\"1\";s:14:\"post_meta_tags\";s:1:\"0\";s:14:\"meta_font_size\";s:4:\"12px\";s:11:\"date_format\";s:7:\"F jS, Y\";s:24:\"portfolio_archive_layout\";s:4:\"grid\";s:37:\"portfolio_archive_featured_image_size\";s:4:\"full\";s:25:\"portfolio_archive_columns\";s:1:\"3\";s:32:\"portfolio_archive_column_spacing\";s:2:\"30\";s:23:\"portfolio_equal_heights\";s:1:\"0\";s:42:\"portfolio_archive_one_column_text_position\";s:5:\"below\";s:23:\"portfolio_archive_items\";s:2:\"10\";s:29:\"portfolio_archive_text_layout\";s:7:\"no_text\";s:32:\"portfolio_archive_content_length\";s:7:\"excerpt\";s:32:\"portfolio_archive_excerpt_length\";s:1:\"0\";s:36:\"portfolio_archive_strip_html_excerpt\";s:1:\"1\";s:31:\"portfolio_archive_title_display\";s:3:\"all\";s:32:\"portfolio_archive_text_alignment\";s:4:\"left\";s:32:\"portfolio_archive_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:33:\"portfolio_archive_pagination_type\";s:15:\"infinite_scroll\";s:49:\"portfolio_archive_load_more_posts_button_bg_color\";s:7:\"#ebeaea\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:24:\"portfolio_meta_font_size\";s:4:\"18px\";s:16:\"portfolio_pn_nav\";s:1:\"0\";s:25:\"portfolio_featured_images\";s:1:\"1\";s:38:\"portfolio_disable_first_featured_image\";s:1:\"1\";s:30:\"portfolio_featured_image_width\";s:4:\"full\";s:19:\"portfolio_width_100\";s:1:\"0\";s:28:\"portfolio_project_desc_title\";s:1:\"1\";s:25:\"portfolio_project_details\";s:1:\"1\";s:26:\"portfolio_link_icon_target\";s:1:\"0\";s:18:\"portfolio_comments\";s:1:\"0\";s:16:\"portfolio_author\";s:1:\"0\";s:28:\"portfolio_social_sharing_box\";s:1:\"0\";s:23:\"portfolio_related_posts\";s:1:\"1\";s:18:\"social_media_icons\";a:5:{s:25:\"fusionredux_repeater_data\";a:7:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}i:5;a:1:{s:5:\"title\";s:0:\"\";}i:6;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"icon\";a:7:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:6:\"flickr\";i:3;s:7:\"youtube\";i:4;s:9:\"instagram\";i:5;s:9:\"pinterest\";i:6;s:5:\"gplus\";}s:3:\"url\";a:7:{i:0;s:1:\"#\";i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";i:4;s:1:\"#\";i:5;s:1:\"#\";i:6;s:1:\"#\";}s:12:\"custom_title\";a:7:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";}s:13:\"custom_source\";a:7:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:3;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:4;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:5;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:6;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:29:\"header_social_links_font_size\";s:4:\"16px\";s:37:\"header_social_links_tooltip_placement\";s:6:\"Bottom\";s:30:\"header_social_links_color_type\";s:6:\"custom\";s:30:\"header_social_links_icon_color\";s:7:\"#bebdbd\";s:25:\"header_social_links_boxed\";s:1:\"0\";s:29:\"header_social_links_box_color\";s:7:\"#e8e8e8\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:33:\"header_social_links_boxed_padding\";s:3:\"8px\";s:12:\"icons_footer\";s:1:\"0\";s:29:\"footer_social_links_font_size\";s:4:\"16px\";s:37:\"footer_social_links_tooltip_placement\";s:5:\"Right\";s:30:\"footer_social_links_color_type\";s:6:\"custom\";s:30:\"footer_social_links_icon_color\";s:7:\"#828c8e\";s:25:\"footer_social_links_boxed\";s:1:\"1\";s:29:\"footer_social_links_box_color\";s:7:\"#2c3038\";s:32:\"footer_social_links_boxed_radius\";s:3:\"50%\";s:33:\"footer_social_links_boxed_padding\";s:3:\"8px\";s:22:\"sharing_social_tagline\";s:50:\"اشتراک در شبکه‌های اجتماعی\";s:30:\"sharing_box_tagline_text_color\";s:7:\"#333333\";s:15:\"social_bg_color\";s:7:\"#f8f8f8\";s:30:\"sharing_social_links_font_size\";s:4:\"18px\";s:38:\"sharing_social_links_tooltip_placement\";s:3:\"Top\";s:31:\"sharing_social_links_color_type\";s:6:\"custom\";s:31:\"sharing_social_links_icon_color\";s:7:\"#828c8e\";s:26:\"sharing_social_links_boxed\";s:1:\"1\";s:30:\"sharing_social_links_box_color\";s:7:\"#2b2e35\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"50%\";s:34:\"sharing_social_links_boxed_padding\";s:4:\"12px\";s:16:\"sharing_facebook\";s:1:\"1\";s:15:\"sharing_twitter\";s:1:\"1\";s:14:\"sharing_reddit\";s:1:\"0\";s:16:\"sharing_linkedin\";s:1:\"1\";s:14:\"sharing_google\";s:1:\"1\";s:14:\"sharing_tumblr\";s:1:\"0\";s:17:\"sharing_pinterest\";s:1:\"1\";s:10:\"sharing_vk\";s:1:\"0\";s:13:\"sharing_email\";s:1:\"0\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";s:1:\"1\";s:23:\"slideshow_smooth_height\";s:1:\"1\";s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";s:1:\"0\";s:25:\"slider_nav_box_dimensions\";a:2:{s:5:\"width\";s:4:\"25px\";s:6:\"height\";s:4:\"65px\";}s:17:\"slider_arrow_size\";s:4:\"14px\";s:15:\"tfes_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"400px\";}s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";s:1:\"1\";s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"150\";s:18:\"es_title_font_size\";s:4:\"42px\";s:20:\"es_caption_font_size\";s:4:\"20px\";s:14:\"es_title_color\";s:7:\"#333333\";s:16:\"es_caption_color\";s:7:\"#747474\";s:15:\"status_lightbox\";s:1:\"1\";s:22:\"status_lightbox_single\";s:1:\"1\";s:17:\"lightbox_behavior\";s:3:\"all\";s:13:\"lightbox_skin\";s:11:\"metro-black\";s:13:\"lightbox_path\";s:8:\"vertical\";s:24:\"lightbox_animation_speed\";s:4:\"Fast\";s:15:\"lightbox_arrows\";s:1:\"1\";s:16:\"lightbox_gallery\";s:1:\"1\";s:17:\"lightbox_autoplay\";s:1:\"0\";s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:5:\"0.925\";s:14:\"lightbox_title\";s:1:\"0\";s:13:\"lightbox_desc\";s:1:\"0\";s:15:\"lightbox_social\";s:1:\"0\";s:20:\"lightbox_deeplinking\";s:1:\"1\";s:20:\"lightbox_post_images\";s:1:\"1\";s:25:\"lightbox_video_dimensions\";a:2:{s:5:\"width\";s:6:\"1280px\";s:6:\"height\";s:5:\"720px\";}s:13:\"email_address\";s:0:\"\";s:24:\"contact_comment_position\";s:5:\"below\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:5:\"light\";s:8:\"gmap_api\";s:0:\"\";s:12:\"gmap_address\";s:49:\"775 New York Ave, Brooklyn, Kings, New York 11203\";s:9:\"gmap_type\";s:7:\"roadmap\";s:15:\"gmap_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"415px\";}s:14:\"gmap_topmargin\";s:4:\"55px\";s:14:\"map_zoom_level\";s:1:\"8\";s:7:\"map_pin\";s:1:\"1\";s:18:\"gmap_pin_animation\";s:1:\"1\";s:9:\"map_popup\";s:1:\"0\";s:15:\"map_scrollwheel\";s:1:\"1\";s:9:\"map_scale\";s:1:\"1\";s:15:\"map_zoomcontrol\";s:1:\"1\";s:11:\"map_styling\";s:7:\"default\";s:17:\"map_overlay_color\";s:7:\"#2ba0a3\";s:19:\"map_infobox_styling\";s:7:\"default\";s:19:\"map_infobox_content\";s:0:\"\";s:20:\"map_infobox_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"map_infobox_text_color\";s:7:\"#747474\";s:22:\"map_custom_marker_icon\";s:0:\"\";s:13:\"search_layout\";s:4:\"Grid\";s:14:\"search_content\";s:15:\"Posts and Pages\";s:14:\"search_excerpt\";s:1:\"1\";s:23:\"search_results_per_page\";s:2:\"10\";s:22:\"search_featured_images\";s:1:\"1\";s:26:\"search_new_search_position\";s:3:\"top\";s:16:\"sidenav_behavior\";s:5:\"Hover\";s:26:\"featured_image_placeholder\";s:1:\"1\";s:12:\"excerpt_base\";s:5:\"Words\";s:16:\"disable_excerpts\";s:1:\"1\";s:14:\"link_read_more\";s:1:\"0\";s:14:\"comments_pages\";s:1:\"0\";s:21:\"featured_images_pages\";s:1:\"1\";s:21:\"nofollow_social_links\";s:1:\"0\";s:16:\"social_icons_new\";s:1:\"1\";s:20:\"related_posts_layout\";s:17:\"title_below_image\";s:20:\"number_related_posts\";s:1:\"5\";s:21:\"related_posts_columns\";s:1:\"3\";s:28:\"related_posts_column_spacing\";s:2:\"10\";s:24:\"related_posts_image_size\";s:7:\"cropped\";s:22:\"related_posts_autoplay\";s:1:\"1\";s:19:\"related_posts_speed\";s:4:\"2500\";s:24:\"related_posts_navigation\";s:1:\"0\";s:19:\"related_posts_swipe\";s:1:\"1\";s:25:\"related_posts_swipe_items\";s:1:\"1\";s:14:\"image_rollover\";s:1:\"1\";s:24:\"image_rollover_direction\";s:6:\"bottom\";s:24:\"image_rollover_icon_size\";s:4:\"20px\";s:19:\"link_image_rollover\";s:1:\"1\";s:19:\"zoom_image_rollover\";s:1:\"1\";s:20:\"title_image_rollover\";s:1:\"1\";s:19:\"cats_image_rollover\";s:1:\"0\";s:26:\"icon_circle_image_rollover\";s:1:\"1\";s:24:\"image_gradient_top_color\";s:21:\"rgba(43,160,163,0.85)\";s:27:\"image_gradient_bottom_color\";s:7:\"#2ba0a3\";s:25:\"image_rollover_text_color\";s:15:\"rgba(0,0,0,.65)\";s:25:\"image_rollover_icon_color\";s:7:\"#ffffff\";s:22:\"pagination_box_padding\";a:2:{s:5:\"width\";s:3:\"6px\";s:6:\"height\";s:3:\"2px\";}s:23:\"pagination_text_display\";s:1:\"1\";s:20:\"pagination_font_size\";s:4:\"12px\";s:17:\"form_input_height\";s:4:\"40px\";s:13:\"form_bg_color\";s:7:\"#373d4d\";s:15:\"form_text_color\";s:7:\"#ffffff\";s:17:\"form_border_color\";s:20:\"rgba(255,255,255,.5)\";s:17:\"timeline_bg_color\";s:19:\"rgba(255,255,255,0)\";s:14:\"timeline_color\";s:7:\"#ebeaea\";s:25:\"grid_separator_style_type\";s:12:\"double|solid\";s:20:\"grid_separator_color\";s:7:\"#e0dede\";s:16:\"google_analytics\";s:0:\"\";s:10:\"space_head\";s:0:\"\";s:10:\"space_body\";s:0:\"\";s:19:\"dependencies_status\";s:1:\"1\";s:15:\"pw_jpeg_quality\";s:3:\"100\";s:16:\"smooth_scrolling\";s:1:\"0\";s:27:\"disable_code_block_encoding\";s:1:\"1\";s:16:\"disable_megamenu\";s:1:\"1\";s:16:\"avada_rev_styles\";s:1:\"1\";s:22:\"avada_styles_dropdowns\";s:1:\"1\";s:15:\"use_animate_css\";s:1:\"1\";s:26:\"disable_mobile_animate_css\";s:1:\"0\";s:27:\"disable_mobile_image_hovers\";s:1:\"1\";s:9:\"status_yt\";s:1:\"1\";s:12:\"status_vimeo\";s:1:\"1\";s:11:\"status_gmap\";s:1:\"1\";s:12:\"status_totop\";s:1:\"1\";s:19:\"status_totop_mobile\";s:1:\"1\";s:20:\"status_fusion_slider\";s:1:\"1\";s:14:\"status_eslider\";s:1:\"1\";s:18:\"status_fontawesome\";s:1:\"1\";s:16:\"status_opengraph\";s:1:\"1\";s:31:\"disable_date_rich_snippet_pages\";s:1:\"1\";s:26:\"disable_rich_snippet_title\";s:1:\"1\";s:27:\"disable_rich_snippet_author\";s:1:\"1\";s:25:\"disable_rich_snippet_date\";s:1:\"1\";s:16:\"css_cache_method\";s:4:\"file\";s:15:\"cache_server_ip\";s:0:\"\";s:11:\"js_compiler\";s:1:\"0\";s:10:\"custom_css\";s:1313:\"/* top border on dropdown */
.fusion-main-menu .sub-menu { border-top: 1px solid #ffffff; }

/* Center footer widgets on mobile */
@media only screen and (max-width: 800px) {
.fusion-footer #text-4 .fusion-button-wrapper.fusion-alignright {  float: none; margin: 0; }
.fusion-footer #social_links-widget-2 .fusion-social-networks.boxed-icons { text-align: center;}
.fusion-footer .widget .fusion-social-networks.boxed-icons .fusion-social-network-icon:last-child { margin-right: 0;}
.fusion-footer #text-4 { text-align: center; }
.fusion-footer .fusion-columns .fusion-column { margin-bottom: 25px;}
}








/* Architectuer */

.fusion-layout-column.fusion-spacing-yes {
    margin-right: 0;
    margin-left: 4%;
}
.wpcf7-select-parent .select-arrow {
    border-right: 1px solid #dadada;
    border-left: 0;
    left: 1px;
    right: auto;
}
select.wpcf7-form-control.wpcf7-select {
    direction: rtl;
}
.wpcf7-form label {
    direction: rtl;
    display: inline-block;
    width: 100%;
}
.full-boxed-pricing .panel-body .price .integer-part {
    font-size: 42px;
}
.fusion-pricing-table .panel-body .price .time.pos-right {
    margin-right: 12px;
}
.fusion-pricing-table .panel-body .price .currency.pos-right.price-without-decimal {
    margin-right: 6px;
}\";s:13:\"info_bg_color\";s:7:\"#ffffff\";s:15:\"danger_bg_color\";s:7:\"#f2dede\";s:16:\"success_bg_color\";s:7:\"#dff0d8\";s:16:\"warning_bg_color\";s:7:\"#fcf8e3\";s:16:\"alert_box_shadow\";s:2:\"no\";s:17:\"alert_border_size\";s:3:\"1px\";s:16:\"animation_offset\";s:13:\"top-into-view\";s:15:\"dates_box_color\";s:7:\"#4194ce\";s:17:\"blog_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:12:\"blog_excerpt\";s:3:\"yes\";s:19:\"blog_excerpt_length\";s:2:\"10\";s:11:\"button_size\";s:5:\"Large\";s:11:\"button_span\";s:2:\"no\";s:12:\"button_shape\";s:6:\"Square\";s:11:\"button_type\";s:4:\"Flat\";s:17:\"button_typography\";a:8:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"letter-spacing\";s:3:\"0px\";}s:25:\"button_gradient_top_color\";s:19:\"rgba(255,255,255,0)\";s:28:\"button_gradient_bottom_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"button_gradient_top_color_hover\";s:22:\"rgba(255,255,255,.035)\";s:34:\"button_gradient_bottom_color_hover\";s:22:\"rgba(255,255,255,.035)\";s:19:\"button_accent_color\";s:21:\"rgba(255,255,255,.75)\";s:25:\"button_accent_hover_color\";s:20:\"rgba(255,255,255,.9)\";s:18:\"button_bevel_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:1:\"1\";s:18:\"carousel_nav_color\";s:15:\"rgba(0,0,0,.85)\";s:20:\"carousel_hover_color\";s:15:\"rgba(0,0,0,.95)\";s:14:\"carousel_speed\";s:4:\"2500\";s:21:\"checklist_icons_color\";s:7:\"#ffffff\";s:16:\"checklist_circle\";s:1:\"1\";s:22:\"checklist_circle_color\";s:19:\"rgba(255,255,255,0)\";s:10:\"col_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";}s:25:\"container_padding_default\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:21:\"container_padding_100\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:4:\"30px\";}s:19:\"full_width_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"full_width_border_size\";s:1:\"0\";s:23:\"full_width_border_color\";s:7:\"#eae9e9\";s:29:\"container_scroll_nav_bg_color\";s:18:\"rgba(0, 0, 0, 0.2)\";s:33:\"container_scroll_nav_bullet_color\";s:7:\"#eeeeee\";s:39:\"container_hundred_percent_height_mobile\";s:1:\"0\";s:20:\"content_box_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"content_box_title_size\";s:4:\"18px\";s:23:\"content_box_title_color\";s:7:\"#242930\";s:22:\"content_box_body_color\";s:7:\"#747474\";s:21:\"content_box_icon_size\";s:4:\"21px\";s:22:\"content_box_icon_color\";s:7:\"#ffffff\";s:23:\"content_box_icon_circle\";s:3:\"yes\";s:30:\"content_box_icon_circle_radius\";s:3:\"50%\";s:25:\"content_box_icon_bg_color\";s:7:\"#333333\";s:38:\"content_box_icon_bg_inner_border_color\";s:7:\"#333333\";s:37:\"content_box_icon_bg_inner_border_size\";s:1:\"1\";s:38:\"content_box_icon_bg_outer_border_color\";s:19:\"rgba(255,255,255,0)\";s:37:\"content_box_icon_bg_outer_border_size\";s:1:\"0\";s:27:\"content_box_icon_hover_type\";s:4:\"fade\";s:40:\"content_box_hover_animation_accent_color\";s:7:\"#2ba0a3\";s:21:\"content_box_link_type\";s:4:\"text\";s:21:\"content_box_link_area\";s:9:\"link-icon\";s:23:\"content_box_link_target\";s:5:\"_self\";s:18:\"content_box_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"60px\";}s:18:\"countdown_timezone\";s:9:\"site_time\";s:20:\"countdown_show_weeks\";s:2:\"no\";s:26:\"countdown_background_color\";s:7:\"#a0ce4e\";s:26:\"countdown_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"countdown_background_repeat\";s:9:\"no-repeat\";s:29:\"countdown_background_position\";s:13:\"center center\";s:27:\"countdown_counter_box_color\";s:7:\"#333333\";s:28:\"countdown_counter_text_color\";s:7:\"#ffffff\";s:28:\"countdown_heading_text_color\";s:7:\"#ffffff\";s:31:\"countdown_subheading_text_color\";s:7:\"#ffffff\";s:25:\"countdown_link_text_color\";s:7:\"#ffffff\";s:21:\"countdown_link_target\";s:5:\"_self\";s:17:\"counter_box_speed\";s:4:\"1000\";s:17:\"counter_box_color\";s:7:\"#9e9e9e\";s:22:\"counter_box_title_size\";s:4:\"50px\";s:21:\"counter_box_icon_size\";s:4:\"50px\";s:22:\"counter_box_body_color\";s:7:\"#747474\";s:21:\"counter_box_body_size\";s:4:\"13px\";s:24:\"counter_box_border_color\";s:7:\"#e0dede\";s:20:\"counter_box_icon_top\";s:2:\"no\";s:20:\"counter_filled_color\";s:7:\"#9e9e9e\";s:22:\"counter_unfilled_color\";s:7:\"#f6f6f6\";s:13:\"dropcap_color\";s:7:\"#2ba0a3\";s:18:\"faq_featured_image\";s:1:\"0\";s:11:\"faq_filters\";s:3:\"yes\";s:18:\"faq_accordion_type\";s:10:\"accordions\";s:24:\"faq_accordion_boxed_mode\";s:1:\"0\";s:25:\"faq_accordion_border_size\";s:1:\"1\";s:26:\"faq_accordian_border_color\";s:7:\"#cccccc\";s:30:\"faq_accordian_background_color\";s:7:\"#ffffff\";s:25:\"faq_accordian_hover_color\";s:7:\"#f9f9f9\";s:26:\"faq_accordion_divider_line\";s:1:\"1\";s:23:\"faq_accordion_icon_size\";s:2:\"13\";s:24:\"faq_accordian_icon_color\";s:7:\"#ffffff\";s:24:\"faq_accordion_icon_boxed\";s:1:\"1\";s:28:\"faq_accordian_inactive_color\";s:7:\"#333333\";s:26:\"faq_accordian_active_color\";s:7:\"#2ba0a3\";s:24:\"faq_accordion_icon_align\";s:4:\"left\";s:19:\"flip_boxes_front_bg\";s:7:\"#f6f6f6\";s:24:\"flip_boxes_front_heading\";s:7:\"#333333\";s:21:\"flip_boxes_front_text\";s:7:\"#747474\";s:18:\"flip_boxes_back_bg\";s:7:\"#9e9e9e\";s:23:\"flip_boxes_back_heading\";s:7:\"#eeeded\";s:20:\"flip_boxes_back_text\";s:7:\"#ffffff\";s:22:\"flip_boxes_border_size\";s:1:\"1\";s:23:\"flip_boxes_border_color\";s:19:\"rgba(255,255,255,0)\";s:24:\"flip_boxes_border_radius\";s:3:\"4px\";s:20:\"gallery_picture_size\";s:4:\"auto\";s:14:\"gallery_layout\";s:4:\"grid\";s:15:\"gallery_columns\";s:1:\"3\";s:22:\"gallery_column_spacing\";s:2:\"10\";s:18:\"gallery_hover_type\";s:4:\"none\";s:24:\"gallery_lightbox_content\";s:4:\"none\";s:17:\"icon_circle_color\";s:7:\"#2ba0a3\";s:17:\"icon_border_color\";s:7:\"#2ba0a3\";s:10:\"icon_color\";s:7:\"#ffffff\";s:21:\"imgframe_border_color\";s:7:\"#f6f6f6\";s:22:\"imageframe_border_size\";s:1:\"0\";s:24:\"imageframe_border_radius\";s:1:\"0\";s:20:\"imgframe_style_color\";s:7:\"#000000\";s:14:\"modal_bg_color\";s:7:\"#f6f6f6\";s:18:\"modal_border_color\";s:7:\"#ebebeb\";s:23:\"person_background_color\";s:13:\"rgba(0,0,0,0)\";s:19:\"person_border_color\";s:7:\"#f6f6f6\";s:18:\"person_border_size\";s:1:\"0\";s:20:\"person_border_radius\";s:1:\"0\";s:18:\"person_style_color\";s:7:\"#000000\";s:16:\"person_alignment\";s:4:\"Left\";s:20:\"person_icon_position\";s:3:\"Top\";s:24:\"popover_heading_bg_color\";s:7:\"#f6f6f6\";s:24:\"popover_content_bg_color\";s:7:\"#ffffff\";s:20:\"popover_border_color\";s:7:\"#ebebeb\";s:18:\"popover_text_color\";s:7:\"#747474\";s:17:\"popover_placement\";s:3:\"Top\";s:29:\"portfolio_featured_image_size\";s:4:\"full\";s:24:\"portfolio_column_spacing\";s:2:\"30\";s:15:\"portfolio_items\";s:2:\"12\";s:21:\"portfolio_text_layout\";s:7:\"unboxed\";s:24:\"portfolio_content_length\";s:7:\"excerpt\";s:24:\"portfolio_excerpt_length\";s:1:\"0\";s:28:\"portfolio_strip_html_excerpt\";s:1:\"1\";s:23:\"portfolio_title_display\";s:3:\"all\";s:24:\"portfolio_text_alignment\";s:4:\"left\";s:24:\"portfolio_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:25:\"portfolio_pagination_type\";s:15:\"infinite_scroll\";s:41:\"portfolio_load_more_posts_button_bg_color\";s:7:\"#2e323a\";s:36:\"full_boxed_pricing_box_heading_color\";s:7:\"#242930\";s:29:\"sep_pricing_box_heading_color\";s:7:\"#ffffff\";s:17:\"pricing_box_color\";s:7:\"#5a5d62\";s:16:\"pricing_bg_color\";s:7:\"#ffffff\";s:30:\"pricing_background_color_hover\";s:7:\"#f8f8f8\";s:20:\"pricing_border_color\";s:7:\"#f8f8f8\";s:21:\"pricing_divider_color\";s:7:\"#ffffff\";s:18:\"progressbar_height\";s:4:\"37px\";s:25:\"progressbar_text_position\";s:6:\"on_bar\";s:24:\"progressbar_filled_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"progressbar_filled_border_color\";s:7:\"#ffffff\";s:30:\"progressbar_filled_border_size\";s:1:\"2\";s:26:\"progressbar_unfilled_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"progressbar_text_color\";s:7:\"#ffffff\";s:23:\"section_sep_border_size\";s:1:\"1\";s:14:\"section_sep_bg\";s:7:\"#f6f6f6\";s:24:\"section_sep_border_color\";s:7:\"#f6f6f6\";s:20:\"separator_style_type\";s:6:\"double\";s:9:\"sep_color\";s:7:\"#e0dede\";s:16:\"separator_circle\";s:1:\"1\";s:21:\"separator_border_size\";s:1:\"1\";s:22:\"social_links_font_size\";s:4:\"16px\";s:23:\"social_links_color_type\";s:6:\"custom\";s:23:\"social_links_icon_color\";s:7:\"#bebdbd\";s:18:\"social_links_boxed\";s:1:\"0\";s:22:\"social_links_box_color\";s:7:\"#e8e8e8\";s:25:\"social_links_boxed_radius\";s:3:\"4px\";s:26:\"social_links_boxed_padding\";s:3:\"8px\";s:30:\"social_links_tooltip_placement\";s:3:\"Top\";s:13:\"tabs_bg_color\";s:7:\"#ffffff\";s:19:\"tabs_inactive_color\";s:7:\"#ebeaea\";s:17:\"tabs_border_color\";s:7:\"#ebeaea\";s:18:\"tabs_icon_position\";s:4:\"left\";s:14:\"tabs_icon_size\";s:2:\"13\";s:10:\"tagline_bg\";s:7:\"#f6f6f6\";s:20:\"tagline_border_color\";s:7:\"#f6f6f6\";s:14:\"tagline_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"84px\";}s:20:\"testimonial_bg_color\";s:7:\"#f6f6f6\";s:22:\"testimonial_text_color\";s:7:\"#747474\";s:18:\"testimonials_speed\";s:4:\"4000\";s:19:\"testimonials_random\";s:1:\"0\";s:16:\"title_style_type\";s:4:\"none\";s:18:\"title_border_color\";s:7:\"#e0dede\";s:12:\"title_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"30px\";}s:14:\"accordion_type\";s:10:\"accordions\";s:20:\"accordion_boxed_mode\";s:1:\"0\";s:21:\"accordion_border_size\";s:1:\"1\";s:22:\"accordian_border_color\";s:7:\"#cccccc\";s:26:\"accordian_background_color\";s:7:\"#ffffff\";s:21:\"accordian_hover_color\";s:7:\"#f9f9f9\";s:22:\"accordion_divider_line\";s:1:\"1\";s:19:\"accordion_icon_size\";s:2:\"13\";s:20:\"accordian_icon_color\";s:7:\"#ffffff\";s:20:\"accordion_icon_boxed\";s:1:\"1\";s:24:\"accordian_inactive_color\";s:7:\"#333333\";s:22:\"accordian_active_color\";s:7:\"#2ba0a3\";s:20:\"accordion_icon_align\";s:4:\"left\";s:21:\"user_login_text_align\";s:6:\"center\";s:32:\"user_login_form_background_color\";s:7:\"#f6f6f6\";s:16:\"visibility_small\";s:3:\"640\";s:17:\"visibility_medium\";s:4:\"1024\";s:22:\"widget_area_title_size\";s:4:\"18px\";s:23:\"widget_area_title_color\";s:7:\"#242930\";s:11:\"scheme_type\";s:0:\"\";s:12:\"color_scheme\";s:5:\"Green\";s:19:\"reset_caches_button\";s:0:\"\";}","yes");
INSERT INTO `a3rfa_options` VALUES("4715","widget_fusion_author-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("15510","widget_form-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("2035","avada_previous_version","a:7:{i:0;s:5:\"5.3.1\";i:1;s:5:\"5.4.0\";i:2;s:5:\"5.4.2\";i:3;s:5:\"5.7.2\";i:4;s:5:\"6.1.2\";i:5;s:5:\"7.4.1\";i:6;s:5:\"7.5.0\";}","yes");
INSERT INTO `a3rfa_options` VALUES("910","wpml_dependencies:needs_validation","1","yes");
INSERT INTO `a3rfa_options` VALUES("911","wpml_dependencies:valid_plugins","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("912","wpml_dependencies:invalid_plugins","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("913","wpml_config_index","O:8:\"stdClass\":2:{s:7:\"plugins\";a:47:{i:0;O:8:\"stdClass\":5:{s:4:\"name\";s:33:\"10bit WooCommerce Gateway Yaadpay\";s:14:\"override_local\";b:1;s:4:\"path\";s:61:\"wpml-config/10bit-woocommerce-gateway-yaadpay/wpml-config.xml\";s:7:\"updated\";i:1464939797;s:4:\"hash\";s:32:\"ebdce80f3b6bfa13112b1d4c6a31b560\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Book Now\";s:14:\"override_local\";b:0;s:4:\"path\";s:36:\"wpml-config/book-now/wpml-config.xml\";s:7:\"updated\";i:1505319882;s:4:\"hash\";s:32:\"d123c0bb22d447095c3c443cb41c273a\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:11:\"Cornerstone\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/cornerstone/wpml-config.xml\";s:7:\"updated\";i:1481889544;s:4:\"hash\";s:32:\"2d9e51efc45379582ded5ac0d8ef3f98\";}i:3;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"Divi Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/divi-builder/wpml-config.xml\";s:7:\"updated\";i:1509452259;s:4:\"hash\";s:32:\"cdae85bf882ab542374811b3a5bf0201\";}i:4;O:8:\"stdClass\":5:{s:4:\"name\";s:18:\"Event Tickets Plus\";s:14:\"override_local\";b:0;s:4:\"path\";s:46:\"wpml-config/event-tickets-plus/wpml-config.xml\";s:7:\"updated\";i:1477310599;s:4:\"hash\";s:32:\"f333802d6c6c9836466d3ff52cfe2bd7\";}i:5;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WPBakery Visual Composer\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/js_composer/wpml-config.xml\";s:7:\"updated\";i:1507744705;s:4:\"hash\";s:32:\"dcf00db80767fd97e294fb1468f0dd53\";}i:6;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WPBakery Page Builder\";s:14:\"override_local\";b:1;s:4:\"path\";s:39:\"wpml-config/js_composer/wpml-config.xml\";s:7:\"updated\";i:1507744705;s:4:\"hash\";s:32:\"dcf00db80767fd97e294fb1468f0dd53\";}i:7;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"MailChimp for WordPress\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/mailchimp-for-wp/wpml-config.xml\";s:7:\"updated\";i:1509614699;s:4:\"hash\";s:32:\"c4f8573312cdf0f71d9329ae82d4ec49\";}i:8;O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Members\";s:14:\"override_local\";b:0;s:4:\"path\";s:35:\"wpml-config/members/wpml-config.xml\";s:7:\"updated\";i:1497367678;s:4:\"hash\";s:32:\"37e638f5a56f59208150c3649c291e41\";}i:9;O:8:\"stdClass\":5:{s:4:\"name\";s:46:\"Multibanco (IfthenPay gateway) for WooCommerce\";s:14:\"override_local\";b:0;s:4:\"path\";s:72:\"wpml-config/multibanco-ifthenpay-gateway-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1441014803;s:4:\"hash\";s:32:\"3cddef77fd163e090472f995aa2388d4\";}i:10;O:8:\"stdClass\":5:{s:4:\"name\";s:25:\"NW ADCart for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:53:\"wpml-config/nw-adcart-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1409734282;s:4:\"hash\";s:32:\"91d62df0659fc7b561a3932a7a52de6a\";}i:11;O:8:\"stdClass\":5:{s:4:\"name\";s:22:\"PayPal for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:50:\"wpml-config/paypal-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1504696994;s:4:\"hash\";s:32:\"8d98b39c86e95094e6b7727fda7a6f00\";}i:12;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"Product Enquiry Pro for WooCommerce\";s:14:\"override_local\";b:1;s:4:\"path\";s:63:\"wpml-config/product-enquiry-pro-for-woocommerce/wpml-config.xml\";s:7:\"updated\";i:1409734532;s:4:\"hash\";s:32:\"305232f06370d52a29c346d6b711f50a\";}i:13;O:8:\"stdClass\":5:{s:4:\"name\";s:12:\"ProductPrint\";s:14:\"override_local\";b:1;s:4:\"path\";s:40:\"wpml-config/productprint/wpml-config.xml\";s:7:\"updated\";i:1447155250;s:4:\"hash\";s:32:\"8003e16bcd6efca83d3b83dc3e01dc89\";}i:14;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Sensei\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/sensei/wpml-config.xml\";s:7:\"updated\";i:1452081042;s:4:\"hash\";s:32:\"e7418cf9fc79f7cdd57193d593774fed\";}i:15;O:8:\"stdClass\":5:{s:4:\"name\";s:19:\"The Events Calendar\";s:14:\"override_local\";b:0;s:4:\"path\";s:47:\"wpml-config/the-events-calendar/wpml-config.xml\";s:7:\"updated\";i:1493194728;s:4:\"hash\";s:32:\"c234d45f2ba5d1d5c89871d202616e06\";}i:16;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"Woocomerce Brands Pro\";s:14:\"override_local\";b:0;s:4:\"path\";s:37:\"wpml-config/woo-brand/wpml-config.xml\";s:7:\"updated\";i:1442243437;s:4:\"hash\";s:32:\"dc7eeb10cd6e0eb80b7960eb8b6058a4\";}i:17;O:8:\"stdClass\":5:{s:4:\"name\";s:39:\"WooCommerce Additional Variation Images\";s:14:\"override_local\";b:1;s:4:\"path\";s:67:\"wpml-config/woocommerce-additional-variation-images/wpml-config.xml\";s:7:\"updated\";i:1479214880;s:4:\"hash\";s:32:\"39b5f72684021b09b12b53b7ff9c7100\";}i:18;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"WooCommerce Advanced Product Labels\";s:14:\"override_local\";b:0;s:4:\"path\";s:63:\"wpml-config/woocommerce-advanced-product-labels/wpml-config.xml\";s:7:\"updated\";i:1441177110;s:4:\"hash\";s:32:\"4b29c29516a1a33b328d90ffc5c4aad7\";}i:19;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce Bookings\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/woocommerce-bookings/wpml-config.xml\";s:7:\"updated\";i:1477397087;s:4:\"hash\";s:32:\"b0f553ab77565d57e9a65a5d50174d5d\";}i:20;O:8:\"stdClass\":5:{s:4:\"name\";s:38:\"WooCommerce Catalog Visibility Options\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-catalog-visibility-options/wpml-config.xml\";s:7:\"updated\";i:1408625615;s:4:\"hash\";s:32:\"d10bd6388a88521e488f7e4ba295c94c\";}i:21;O:8:\"stdClass\":5:{s:4:\"name\";s:30:\"WooCommerce Composite Products\";s:14:\"override_local\";b:0;s:4:\"path\";s:58:\"wpml-config/woocommerce-composite-products/wpml-config.xml\";s:7:\"updated\";i:1491207947;s:4:\"hash\";s:32:\"a6c0ed6554be69f56779f64506ab96d1\";}i:22;O:8:\"stdClass\":5:{s:4:\"name\";s:30:\"WooCommerce Currency Converter\";s:14:\"override_local\";b:1;s:4:\"path\";s:58:\"wpml-config/woocommerce-currency-converter/wpml-config.xml\";s:7:\"updated\";i:1452009183;s:4:\"hash\";s:32:\"b2191d7affaf1efe74e6a3ca4b0494c6\";}i:23;O:8:\"stdClass\":5:{s:4:\"name\";s:32:\"WooCommerce DIBS FlexWin Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:60:\"wpml-config/woocommerce-dibs-flexwin-gateway/wpml-config.xml\";s:7:\"updated\";i:1459514491;s:4:\"hash\";s:32:\"d9237f895f0f133c8e11f4753d96eeca\";}i:24;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WooCommerce Embed Slides\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/woocommerce-embed-slides/wpml-config.xml\";s:7:\"updated\";i:1499457331;s:4:\"hash\";s:32:\"243e3a54d920cc2ddf96f17f4ff38f2d\";}i:25;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"WooCommerce Local Pickup Plus\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/woocommerce-local-pickup-plus/wpml-config.xml\";s:7:\"updated\";i:1442582863;s:4:\"hash\";s:32:\"816774f477bfa1c481cdba021d33f705\";}i:26;O:8:\"stdClass\":5:{s:4:\"name\";s:24:\"WooCommerce Multilingual\";s:14:\"override_local\";b:1;s:4:\"path\";s:52:\"wpml-config/woocommerce-multilingual/wpml-config.xml\";s:7:\"updated\";i:1503560850;s:4:\"hash\";s:32:\"1dafd38816e5d995e75ef7d5c32563d8\";}i:27;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"WooCommerce Memberships\";s:14:\"override_local\";b:1;s:4:\"path\";s:51:\"wpml-config/woocommerce-memberships/wpml-config.xml\";s:7:\"updated\";i:1509008320;s:4:\"hash\";s:32:\"216897217946e73b59e0e4f8958cad88\";}i:28;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Name Your Price\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-name-your-price/wpml-config.xml\";s:7:\"updated\";i:1455548370;s:4:\"hash\";s:32:\"ef484afbeeff24b6cad5b5d477528e83\";}i:29;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Paymill Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-paymill-gateway/wpml-config.xml\";s:7:\"updated\";i:1408626573;s:4:\"hash\";s:32:\"46409842584ff8df43a2aa922ad1d388\";}i:30;O:8:\"stdClass\":5:{s:4:\"name\";s:40:\"WooCommerce PDF Invoices & Packing Slips\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-pdf-invoices-packing-slips/wpml-config.xml\";s:7:\"updated\";i:1461579342;s:4:\"hash\";s:32:\"34ecf8066c5c9042a0bd60b5d40c4c55\";}i:31;O:8:\"stdClass\":5:{s:4:\"name\";s:17:\"WooCommerce Plivo\";s:14:\"override_local\";b:1;s:4:\"path\";s:45:\"wpml-config/woocommerce-plivo/wpml-config.xml\";s:7:\"updated\";i:1409734706;s:4:\"hash\";s:32:\"539d172825c4714d69b8a42ad1826c5d\";}i:32;O:8:\"stdClass\":5:{s:4:\"name\";s:20:\"WooCommerce PostePay\";s:14:\"override_local\";b:1;s:4:\"path\";s:48:\"wpml-config/woocommerce-postepay/wpml-config.xml\";s:7:\"updated\";i:1409063138;s:4:\"hash\";s:32:\"b08722979a25b15ba4a02a16fb555ccc\";}i:33;O:8:\"stdClass\":5:{s:4:\"name\";s:28:\"WooCommerce Price by Country\";s:14:\"override_local\";b:1;s:4:\"path\";s:56:\"wpml-config/woocommerce-price-by-country/wpml-config.xml\";s:7:\"updated\";i:1415282920;s:4:\"hash\";s:32:\"9b296d64ba8afee80cb1ff4fac80144b\";}i:34;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Product Add-ons\";s:14:\"override_local\";b:1;s:4:\"path\";s:55:\"wpml-config/woocommerce-product-add-ons/wpml-config.xml\";s:7:\"updated\";i:1476961788;s:4:\"hash\";s:32:\"69f94bed6e4b3546cc7be2fbd2bf392b\";}i:35;O:8:\"stdClass\":5:{s:4:\"name\";s:27:\"WooCommerce Product Bundles\";s:14:\"override_local\";b:0;s:4:\"path\";s:55:\"wpml-config/woocommerce-product-bundles/wpml-config.xml\";s:7:\"updated\";i:1487080751;s:4:\"hash\";s:32:\"7cddba745169acd899b12f24e3580dcc\";}i:36;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"WooCommerce Product Gift Wrap\";s:14:\"override_local\";b:1;s:4:\"path\";s:57:\"wpml-config/woocommerce-product-gift-wrap/wpml-config.xml\";s:7:\"updated\";i:1429640014;s:4:\"hash\";s:32:\"dd3371d64d2ee01e6e42fd7e0bd134cf\";}i:37;O:8:\"stdClass\":5:{s:4:\"name\";s:38:\"Woocommerce Social Media Share Buttons\";s:14:\"override_local\";b:1;s:4:\"path\";s:66:\"wpml-config/woocommerce-social-media-share-buttons/wpml-config.xml\";s:7:\"updated\";i:1464934858;s:4:\"hash\";s:32:\"3130bbf2a35424d9ecd8d6c3255bf817\";}i:38;O:8:\"stdClass\":5:{s:4:\"name\";s:26:\"WooCommerce Stripe Gateway\";s:14:\"override_local\";b:1;s:4:\"path\";s:54:\"wpml-config/woocommerce-gateway-stripe/wpml-config.xml\";s:7:\"updated\";i:1409061505;s:4:\"hash\";s:32:\"4139e23bcdd0bb3e78cb079fa851ce85\";}i:39;O:8:\"stdClass\":5:{s:4:\"name\";s:23:\"WooCommerce Tab Manager\";s:14:\"override_local\";b:1;s:4:\"path\";s:51:\"wpml-config/woocommerce-tab-manager/wpml-config.xml\";s:7:\"updated\";i:1505158182;s:4:\"hash\";s:32:\"477be025d13abe1c1b89bb7666564ed6\";}i:40;O:8:\"stdClass\":5:{s:4:\"name\";s:21:\"WooCommerce Video Tab\";s:14:\"override_local\";b:1;s:4:\"path\";s:49:\"wpml-config/woocommerce-video-tab/wpml-config.xml\";s:7:\"updated\";i:1415284345;s:4:\"hash\";s:32:\"7f9769bc2769e07ae730f3b4cd307741\";}i:41;O:8:\"stdClass\":5:{s:4:\"name\";s:14:\"WP Job Manager\";s:14:\"override_local\";b:0;s:4:\"path\";s:42:\"wpml-config/wp-job-manager/wpml-config.xml\";s:7:\"updated\";i:1499098270;s:4:\"hash\";s:32:\"36842c6b8a11a733ef00ef8d9bc410b9\";}i:42;O:8:\"stdClass\":5:{s:4:\"name\";s:16:\"WPML Test Config\";s:14:\"override_local\";b:1;s:4:\"path\";s:44:\"wpml-config/wpml-test-config/wpml-config.xml\";s:7:\"updated\";i:1429103326;s:4:\"hash\";s:32:\"9c3bb313d5a4f028bebfa8fc8af990a3\";}i:43;O:8:\"stdClass\":5:{s:4:\"name\";s:29:\"YITH WooCommerce Catalog Mode\";s:14:\"override_local\";b:0;s:4:\"path\";s:57:\"wpml-config/yith-woocommerce-catalog-mode/wpml-config.xml\";s:7:\"updated\";i:1441961343;s:4:\"hash\";s:32:\"ca50a47d4254cbd04254c4448c511e22\";}i:44;O:8:\"stdClass\":5:{s:4:\"name\";s:49:\"YITH WooCommerce Minimum Maximum Quantity Premium\";s:14:\"override_local\";b:1;s:4:\"path\";s:77:\"wpml-config/yith-woocommerce-minimum-maximum-quantity-premium/wpml-config.xml\";s:7:\"updated\";i:1459278737;s:4:\"hash\";s:32:\"8e8c7961e72461a498849880ad418163\";}i:45;O:8:\"stdClass\":5:{s:4:\"name\";s:35:\"YITH WooCommerce Quick View Premium\";s:14:\"override_local\";b:0;s:4:\"path\";s:63:\"wpml-config/yith-woocommerce-quick-view-premium/wpml-config.xml\";s:7:\"updated\";i:1439206202;s:4:\"hash\";s:32:\"656f1dcbcad67f5a4cbc7747520ef4e2\";}i:46;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Yoast SEO\";s:14:\"override_local\";b:1;s:4:\"path\";s:37:\"wpml-config/yoast-seo/wpml-config.xml\";s:7:\"updated\";i:1458560027;s:4:\"hash\";s:32:\"a4a501904fb15a86d6c72a28a232a1e9\";}}s:6:\"themes\";a:18:{i:0;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Avada\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/avada/wpml-config.xml\";s:7:\"updated\";i:1508341293;s:4:\"hash\";s:32:\"ecc23b17e102d057c9cc81284a4b6dac\";}i:1;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Canvas\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/canvas/wpml-config.xml\";s:7:\"updated\";i:1476729671;s:4:\"hash\";s:32:\"ea1da43b18f87c4aa73982113067cd95\";}i:2;O:8:\"stdClass\":5:{s:4:\"name\";s:9:\"Customizr\";s:14:\"override_local\";b:0;s:4:\"path\";s:37:\"wpml-config/customizr/wpml-config.xml\";s:7:\"updated\";i:1440909044;s:4:\"hash\";s:32:\"d63f73a0df72ab558bdbfaadaeb9c737\";}i:3;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Divi\";s:14:\"override_local\";b:1;s:4:\"path\";s:32:\"wpml-config/divi/wpml-config.xml\";s:7:\"updated\";i:1509452259;s:4:\"hash\";s:32:\"41e54561585d442f537ce69fb388517f\";}i:4;O:8:\"stdClass\":5:{s:4:\"name\";s:5:\"Extra\";s:14:\"override_local\";b:1;s:4:\"path\";s:33:\"wpml-config/extra/wpml-config.xml\";s:7:\"updated\";i:1511282463;s:4:\"hash\";s:32:\"2b0f42fbfa01d7fc41d8ddd1ab2b4dce\";}i:5;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Emerald CV\";s:14:\"override_local\";b:1;s:4:\"path\";s:38:\"wpml-config/emerald-cv/wpml-config.xml\";s:7:\"updated\";i:1460387184;s:4:\"hash\";s:32:\"3ab5fd101b71e7b306e48a07801c7557\";}i:6;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Enfold\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/enfold/wpml-config.xml\";s:7:\"updated\";i:1507112260;s:4:\"hash\";s:32:\"3846bd4c1ed97ba60b504082f8ab304b\";}i:7;O:8:\"stdClass\":5:{s:4:\"name\";s:8:\"Function\";s:14:\"override_local\";b:1;s:4:\"path\";s:36:\"wpml-config/function/wpml-config.xml\";s:7:\"updated\";i:1476729764;s:4:\"hash\";s:32:\"bb6dd583fb2a28ee5c4e2a264a770d60\";}i:8;O:8:\"stdClass\":5:{s:4:\"name\";s:7:\"Genesis\";s:14:\"override_local\";b:1;s:4:\"path\";s:35:\"wpml-config/genesis/wpml-config.xml\";s:7:\"updated\";i:1456825681;s:4:\"hash\";s:32:\"795657d127a84e450ad21218284bdd28\";}i:9;O:8:\"stdClass\":5:{s:4:\"name\";s:36:\"IDStore - Responsive WordPress Theme\";s:14:\"override_local\";b:1;s:4:\"path\";s:62:\"wpml-config/idstore-responsive-wordpress-theme/wpml-config.xml\";s:7:\"updated\";i:1499457250;s:4:\"hash\";s:32:\"1c49e6754e661e5eb1c301f8874829da\";}i:10;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Kleo\";s:14:\"override_local\";b:0;s:4:\"path\";s:32:\"wpml-config/kleo/wpml-config.xml\";s:7:\"updated\";i:1424767836;s:4:\"hash\";s:32:\"442023138b716c2f410690eabeeab185\";}i:11;O:8:\"stdClass\":5:{s:4:\"name\";s:4:\"Port\";s:14:\"override_local\";b:1;s:4:\"path\";s:32:\"wpml-config/port/wpml-config.xml\";s:7:\"updated\";i:1426496204;s:4:\"hash\";s:32:\"788cce209545b94cfede660d543d7013\";}i:12;O:8:\"stdClass\":5:{s:4:\"name\";s:3:\"Pro\";s:14:\"override_local\";b:1;s:4:\"path\";s:31:\"wpml-config/pro/wpml-config.xml\";s:7:\"updated\";i:1506334535;s:4:\"hash\";s:32:\"2d9e51efc45379582ded5ac0d8ef3f98\";}i:13;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Resort\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/resort/wpml-config.xml\";s:7:\"updated\";i:1491314298;s:4:\"hash\";s:32:\"363adea9467157a4e0b49d50c2be3b3f\";}i:14;O:8:\"stdClass\":5:{s:4:\"name\";s:6:\"Reveal\";s:14:\"override_local\";b:1;s:4:\"path\";s:34:\"wpml-config/reveal/wpml-config.xml\";s:7:\"updated\";i:1461596007;s:4:\"hash\";s:32:\"58db88b09a090c9fcff3d65bd031d14a\";}i:15;O:8:\"stdClass\":5:{s:4:\"name\";s:13:\"ReWalk Parent\";s:14:\"override_local\";b:0;s:4:\"path\";s:41:\"wpml-config/rewalk-parent/wpml-config.xml\";s:7:\"updated\";i:1480345058;s:4:\"hash\";s:32:\"7b17377ed5e4226bc7e3d44270bc7924\";}i:16;O:8:\"stdClass\":5:{s:4:\"name\";s:10:\"Scrollider\";s:14:\"override_local\";b:0;s:4:\"path\";s:38:\"wpml-config/scrollider/wpml-config.xml\";s:7:\"updated\";i:1479395978;s:4:\"hash\";s:32:\"83fbe85052a8e7eb7ac61496187c7271\";}i:17;O:8:\"stdClass\":5:{s:4:\"name\";s:1:\"X\";s:14:\"override_local\";b:1;s:4:\"path\";s:29:\"wpml-config/x/wpml-config.xml\";s:7:\"updated\";i:1501682088;s:4:\"hash\";s:32:\"67376ea42cf961311cf1079efb5e4b41\";}}}","yes");
INSERT INTO `a3rfa_options` VALUES("914","wpml_config_index_updated","1512665735","yes");
INSERT INTO `a3rfa_options` VALUES("915","wpml_config_files_arr","O:8:\"stdClass\":2:{s:6:\"themes\";a:1:{s:5:\"Avada\";s:24045:\"<wpml-config>
    <admin-texts>
        <key name=\"avada_theme_options\">
            <key name=\"google_analytics\"/>
            <key name=\"space_head\"/>
            <key name=\"space_body\"/>
            <key name=\"header_number\"/>
            <key name=\"header_email\"/>
            <key name=\"header_tagline\"/>
            <key name=\"breacrumb_prefix\"/>
            <key name=\"footer_text\"/>
            <key name=\"blog_title\"/>
            <key name=\"portfolio_slug\"/>
            <key name=\"gmap_address\"/>
            <key name=\"email_address\"/>
            <key name=\"blog_subtitle\"/>
            <key name=\"date_format\"/>
            <key name=\"map_infobox_content\"/>
            <key name=\"sharing_social_tagline\"/>
        </key>
    </admin-texts>
    <custom-types>
        <custom-type translate=\"1\">themefusion_elastic</custom-type>
        <custom-type translate=\"1\">slide</custom-type>
        <custom-type translate=\"1\">layerslider</custom-type>
        <custom-type translate=\"1\">revslider</custom-type>
        <custom-type translate=\"1\">avada_faq</custom-type>
        <custom-type translate=\"1\">avada_portfolio</custom-type>
    </custom-types>
    <taxonomies>
        <taxonomy translate=\"1\">portfolio_category</taxonomy>
        <taxonomy translate=\"1\">faq_category</taxonomy>
        <taxonomy translate=\"1\">portfolio_skills</taxonomy>
        <taxonomy translate=\"1\">portfolio_tags</taxonomy>
        <taxonomy translate=\"1\">themefusion_es_groups</taxonomy>
        <taxonomy translate=\"1\">slide-page</taxonomy>
    </taxonomies>
    <custom-fields>
        <custom-field action=\"copy-once\">avada_post_views_count</custom-field>
        <custom-field action=\"copy-once\">pyre_address</custom-field>
        <custom-field action=\"copy-once\">pyre_caption_1</custom-field>
        <custom-field action=\"copy-once\">pyre_caption_2</custom-field>
        <custom-field action=\"translate\">pyre_copy_url</custom-field>
        <custom-field action=\"translate\">pyre_copy_url_text</custom-field>
        <custom-field action=\"copy-once\">pyre_displayed_menu</custom-field>
        <custom-field action=\"copy-once\">pyre_display_copyright</custom-field>
        <custom-field action=\"copy-once\">pyre_display_footer</custom-field>
        <custom-field action=\"copy-once\">pyre_display_header</custom-field>
        <custom-field action=\"copy-once\">pyre_elasticslider</custom-field>
        <custom-field action=\"copy-once\">pyre_email</custom-field>
        <custom-field action=\"copy-once\">pyre_fallback</custom-field>
        <custom-field action=\"copy-once\">pyre_fimg_height</custom-field>
        <custom-field action=\"copy-once\">pyre_fimg_width</custom-field>
        <custom-field action=\"copy-once\">pyre_flexslider</custom-field>
        <custom-field action=\"copy-once\">pyre_full_width</custom-field>
        <custom-field action=\"copy-once\">pyre_gmap</custom-field>
        <custom-field action=\"copy-once\">pyre_header_bg</custom-field>
        <custom-field action=\"copy-once\">pyre_header_bg_color</custom-field>
        <custom-field action=\"copy-once\">pyre_header_bg_full</custom-field>
        <custom-field action=\"copy-once\">pyre_header_bg_repeat</custom-field>
        <custom-field action=\"copy-once\">pyre_hundredp_padding</custom-field>
        <custom-field action=\"copy-once\">pyre_image_rollover_icons</custom-field>
        <custom-field action=\"copy-once\">pyre_link_icon_target</custom-field>
        <custom-field action=\"translate\">pyre_link_icon_url</custom-field>
        <custom-field action=\"copy-once\">pyre_main_bottom_padding</custom-field>
        <custom-field action=\"copy-once\">pyre_main_top_padding</custom-field>
        <custom-field action=\"copy-once\">pyre_overall_score</custom-field>
        <custom-field action=\"copy-once\">pyre_page_bg</custom-field>
        <custom-field action=\"copy-once\">pyre_page_bg_color</custom-field>
        <custom-field action=\"copy-once\">pyre_page_bg_full</custom-field>
        <custom-field action=\"copy-once\">pyre_page_bg_layout</custom-field>
        <custom-field action=\"copy-once\">pyre_page_bg_repeat</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_bar_bg</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_bar_bg_color</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_bar_bg_full</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_bar_bg_retina</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_bg_parallax</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_custom_subheader</custom-field>
        <custom-field action=\"translate\">pyre_page_title_custom_text</custom-field>
        <custom-field action=\"copy-once\">page_title_text_size</custom-field>
        <custom-field action=\"copy-once\">page_title_text_alignment</custom-field>
        <custom-field action=\"copy-once\">page_title_custom_subheader_text_size</custom-field>
        <custom-field action=\"copy-once\">page_title_breadcrumbs_search_bar</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_text</custom-field>
        <custom-field action=\"copy-once\">pyre_phone</custom-field>
        <custom-field action=\"copy-once\">pyre_portfolio_category</custom-field>
        <custom-field action=\"copy-once\">pyre_portfolio_excerpt</custom-field>
        <custom-field action=\"copy-once\">pyre_portfolio_filters</custom-field>
        <custom-field action=\"copy-once\">pyre_portfolio_full_width</custom-field>
        <custom-field action=\"copy-once\">pyre_portfolio_sidebar_position</custom-field>
        <custom-field action=\"copy-once\">pyre_portfolio_width_100</custom-field>
        <custom-field action=\"copy-once\">pyre_project_desc_title</custom-field>
        <custom-field action=\"copy-once\">pyre_project_details</custom-field>
        <custom-field action=\"copy-once\">pyre_project_url</custom-field>
        <custom-field action=\"translate\">pyre_project_url_text</custom-field>
        <custom-field action=\"copy-once\">pyre_related_posts</custom-field>
        <custom-field action=\"copy-once\">pyre_revslider</custom-field>
        <custom-field action=\"copy-once\">pyre_show_first_featured_image</custom-field>
        <custom-field action=\"copy-once\">pyre_sidebar</custom-field>
        <custom-field action=\"copy-once\">pyre_sidebar_position</custom-field>
        <custom-field action=\"copy-once\">pyre_slider</custom-field>
        <custom-field action=\"copy-once\">pyre_slider_position</custom-field>
        <custom-field action=\"copy-once\">pyre_slider_type</custom-field>
        <custom-field action=\"copy-once\">pyre_transparent_header</custom-field>
        <custom-field action=\"translate\">pyre_video</custom-field>
        <custom-field action=\"translate\">pyre_video_url</custom-field>
        <custom-field action=\"copy-once\">pyre_wide_page_bg</custom-field>
        <custom-field action=\"copy-once\">pyre_wide_page_bg_color</custom-field>
        <custom-field action=\"copy-once\">pyre_wide_page_bg_full</custom-field>
        <custom-field action=\"copy-once\">pyre_wide_page_bg_repeat</custom-field>
        <custom-field action=\"copy-once\">pyre_width</custom-field>
        <custom-field action=\"copy-once\">pyre_wooslider</custom-field>
        <custom-field action=\"copy-once\">sbg_selected_sidebar</custom-field>
        <custom-field action=\"copy-once\">sbg_selected_sidebar_replacement</custom-field>
        <custom-field action=\"copy-once\">sbg_selected_sidebar_2</custom-field>
        <custom-field action=\"copy-once\">sbg_selected_sidebar_2_replacement</custom-field>
        <custom-field action=\"copy-once\">slide_template</custom-field>
        <custom-field action=\"copy-once\">pyre_avada_rev_styles</custom-field>
        <custom-field action=\"copy-once\">pyre_footer_100_width</custom-field>
        <custom-field action=\"copy-once\">pyre_header_100_width</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_100_width</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_breadcrumbs_search_bar</custom-field>
        <custom-field action=\"copy-once\">pyre_page_title_text_alignment</custom-field>
        <custom-field action=\"translate\">pyre_project_url_text</custom-field>
        <custom-field action=\"translate\">pyre_heading</custom-field>
        <custom-field action=\"translate\">pyre_caption</custom-field>
        <custom-field action=\"copy-once\">pyre_type</custom-field>
        <custom-field action=\"copy-once\">pyre_content_alignment</custom-field>
        <custom-field action=\"copy-once\">pyre_webm</custom-field>
        <custom-field action=\"copy-once\">pyre_mp4</custom-field>
        <custom-field action=\"copy-once\">pyre_ogv</custom-field>
        <custom-field action=\"copy-once\">pyre_preview_image</custom-field>
        <custom-field action=\"copy-once\">pyre_video_bg_color</custom-field>
        <custom-field action=\"copy-once\">pyre_mute_video</custom-field>
        <custom-field action=\"copy-once\">pyre_autoplay_video</custom-field>
        <custom-field action=\"copy-once\">pyre_loop_video</custom-field>
        <custom-field action=\"copy-once\">pyre_hide_video_controls</custom-field>
        <custom-field action=\"translate\">pyre_youtube_id</custom-field>
        <custom-field action=\"copy-once\">pyre_aspect_ratio</custom-field>
        <custom-field action=\"copy-once\">pyre_video_display</custom-field>
        <custom-field action=\"translate\">pyre_vimeo_id</custom-field>
        <custom-field action=\"copy-once\">pyre_heading_font_size</custom-field>
        <custom-field action=\"copy-once\">pyre_heading_color</custom-field>
        <custom-field action=\"copy-once\">pyre_heading_bg</custom-field>
        <custom-field action=\"copy-once\">pyre_heading_bg_color</custom-field>
        <custom-field action=\"copy-once\">pyre_caption_font_size</custom-field>
        <custom-field action=\"copy-once\">pyre_caption_color</custom-field>
        <custom-field action=\"copy-once\">pyre_caption_bg</custom-field>
        <custom-field action=\"copy-once\">pyre_caption_bg_color</custom-field>
        <custom-field action=\"copy-once\">pyre_link_type</custom-field>
        <custom-field action=\"translate\">pyre_button_1</custom-field>
        <custom-field action=\"translate\">pyre_button_2</custom-field>
        <custom-field action=\"copy-once\">pyre_slide_link</custom-field>
        <custom-field action=\"copy-once\">pyre_slide_target</custom-field>
    </custom-fields>
    <shortcodes>
        <shortcode>
            <tag>fusion_alert</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_blog</tag>
            <attributes>
                <attribute type=\"link\">title_link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_button</tag>
            <attributes>
                <attribute type=\"link\">link</attribute>
                <attribute>title</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_checklist</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_li_item</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_code</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_builder_row</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_builder_column</tag>
            <attributes>
                <attribute>background_image</attribute>
                <attribute type=\"link\">link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_builder_column</tag>
            <attributes>
                <attribute>background_image</attribute>
                <attribute type=\"link\">link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_builder_container</tag>
            <attributes>
                <attribute>menu_anchor</attribute>
                <attribute>background_image</attribute>
                <attribute>video_mp4</attribute>
                <attribute>video_url</attribute>
                <attribute>video_preview_image</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_builder_container</tag>
            <attributes>
                <attribute>menu_anchor</attribute>
                <attribute>background_image</attribute>
                <attribute>video_mp4</attribute>
                <attribute>video_url</attribute>
                <attribute>video_preview_image</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_content_boxes</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_content_box</tag>
            <attributes>
                <attribute>title</attribute>
                <attribute>image</attribute>
                <attribute type=\"link\">link</attribute>
                <attribute>linktext</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_countdown</tag>
            <attributes>
                <attribute>heading_text</attribute>
                <attribute>subheading_text</attribute>
                <attribute type=\"link\">link_url</attribute>
                <attribute>link_text</attribute>
                <attribute>background_image</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_counters_box</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_counter_box</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_counters_circle</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_counter_circle</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_dropcap</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_events</tag>
            <attributes>
                <attribute>cat_slug</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_faq</tag>
            <attributes>
                <attribute>featured_image</attribute>
                <attribute>cats_slug</attribute>
                <attribute>exclude_cats</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_flip_boxes</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_flip_box</tag>
            <attributes>
                <attribute>title_front</attribute>
                <attribute>title_back</attribute>
                <attribute>text_front</attribute>
                <attribute>image</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_fontawesome</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_fusionslider</tag>
            <attributes>
                <attribute>name</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_map</tag>
            <attributes>
                <attribute>address</attribute>
                <attribute>infobox_content</attribute>
                <attribute>infobox</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_images</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_image</tag>
            <attributes>
                <attribute type=\"link\">link</attribute>
                <attribute>image</attribute>
                <attribute>alt</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_imageframe</tag>
            <attributes>
                <attribute>image_id</attribute>
                <attribute>gallery_id</attribute>
                <attribute>lightbox_image</attribute>
                <attribute>alt</attribute>
                <attribute type=\"link\">link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>layerslider</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_lightbox</tag>
            <attributes>
                <attribute>title</attribute>
                <attribute type=\"link\">href</attribute>
                <attribute>data-rel</attribute>
                <attribute>img src</attribute>
                <attribute>alt</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_menu_anchor</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_modal</tag>
            <attributes>
                <attribute>title</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_modal_text_link</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_one_page_text_link</tag>
            <attributes>
                <attribute type=\"link\">link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_person</tag>
            <attributes>
                <attribute>name</attribute>
                <attribute>title</attribute>
                <attribute>picture</attribute>
                <attribute>pic_link</attribute>
                <attribute>email</attribute>
                <attribute>social links</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_popover</tag>
            <attributes>
                <attribute>title</attribute>
                <attribute>content</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_popover</tag>
            <attributes>
                <attribute>title</attribute>
                <attribute>content</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_portfolio</tag>
            <attributes>
                <attribute>cat_slug</attribute>
                <attribute>exclude_cats</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_postslider</tag>
            <attributes>
                <attribute>excerpt</attribute>
                <attribute>category</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_pricing_table</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_pricing_column</tag>
            <attributes>
                <attribute>title</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_pricing_price</tag>
            <attributes>
                <attribute>currency</attribute>
                <attribute>price</attribute>
                <attribute>time</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_pricing_row</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_pricing_footer</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_progress</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_recent_posts</tag>
            <attributes>
                <attribute>cat_slug</attribute>
                <attribute>exclude_cats</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>rev_slider</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_section_separator</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_separator</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_sharing</tag>
            <attributes>
                <attribute>tagline</attribute>
                <attribute>title</attribute>
                <attribute type=\"link\">link</attribute>
                <attribute>description</attribute>
                <attribute>pinterest_image</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_slider</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_slide</tag>
            <attributes>
                <attribute type=\"link\">link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_social_links</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_soundcloud</tag>
            <attributes>
                <attribute type=\"link\">url</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_soundcloud</tag>
            <attributes>
                <attribute type=\"link\">url</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_tabs</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_tab</tag>
            <attributes>
                <attribute>title</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_tagline_box</tag>
            <attributes>
                <attribute type=\"link\">link</attribute>
                <attribute>title</attribute>
                <attribute>description</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_testimonials</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_testimonial</tag>
            <attributes>
                <attribute>name</attribute>
                <attribute>image</attribute>
                <attribute>company</attribute>
                <attribute type=\"link\">link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_text</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_title</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_accordion</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_toggle</tag>
            <attributes>
                <attribute>title</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_tooltip</tag>
            <attributes>
                <attribute>title</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_login</tag>
            <attributes>
                <attribute>heading</attribute>
                <attribute>caption</attribute>
                <attribute>redirection_link</attribute>
                <attribute type=\"link\">register_link</attribute>
                <attribute>lost_password_link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_lost_password</tag>
            <attributes>
                <attribute>heading</attribute>
                <attribute>caption</attribute>
                <attribute type=\"link\">redirection_link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_register</tag>
            <attributes>
                <attribute>heading</attribute>
                <attribute>caption</attribute>
                <attribute type=\"link\">redirection_link</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_vimeo</tag>
            <attributes>
                <attribute>id</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_widget_area</tag>
            <attributes>
                <attribute>name</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_products_slider</tag>
            <attributes>
                <attribute>cat_slug</attribute>
            </attributes>
        </shortcode>
        <shortcode>
            <tag>fusion_featured_products_slider</tag>
        </shortcode>
        <shortcode>
            <tag>fusion_youtube</tag>
            <attributes>
                <attribute>id</attribute>
            </attributes>
        </shortcode>
    </shortcodes>
</wpml-config>\";}s:7:\"plugins\";a:0:{}}","yes");
INSERT INTO `a3rfa_options` VALUES("917","icl_admin_messages","a:2:{s:8:\"messages\";a:0:{}s:16:\"instant_messages\";a:0:{}}","yes");
INSERT INTO `a3rfa_options` VALUES("918","fusion_options_","a:698:{s:8:\"last_tab\";s:0:\"\";s:6:\"layout\";s:4:\"Wide\";s:10:\"site_width\";s:6:\"1170px\";s:13:\"margin_offset\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";}s:13:\"scroll_offset\";s:4:\"full\";s:18:\"boxed_modal_shadow\";s:4:\"None\";s:12:\"main_padding\";a:2:{s:3:\"top\";s:4:\"90px\";s:6:\"bottom\";s:4:\"45px\";}s:16:\"hundredp_padding\";s:4:\"40px\";s:13:\"sidebar_width\";s:3:\"25%\";s:17:\"sidebar_2_1_width\";s:3:\"21%\";s:17:\"sidebar_2_2_width\";s:3:\"21%\";s:10:\"nav_height\";s:2:\"96\";s:20:\"menu_highlight_style\";s:3:\"bar\";s:25:\"menu_highlight_background\";s:7:\"#a0ce4e\";s:15:\"menu_arrow_size\";a:2:{s:5:\"width\";s:4:\"23px\";s:6:\"height\";s:4:\"12px\";}s:20:\"nav_highlight_border\";s:1:\"1\";s:11:\"nav_padding\";s:2:\"45\";s:15:\"megamenu_shadow\";s:1:\"1\";s:19:\"dropdown_menu_width\";s:3:\"180\";s:34:\"mainmenu_dropdown_vertical_padding\";s:2:\"12\";s:33:\"mainmenu_dropdown_display_divider\";s:1:\"1\";s:31:\"menu_display_dropdown_indicator\";s:1:\"1\";s:20:\"main_nav_search_icon\";s:1:\"0\";s:20:\"main_nav_icon_circle\";s:1:\"0\";s:25:\"main_nav_highlight_radius\";s:3:\"0px\";s:17:\"menu_sub_bg_color\";s:7:\"#24272d\";s:19:\"menu_bg_hover_color\";s:7:\"#292d33\";s:18:\"menu_sub_sep_color\";s:7:\"#292d33\";s:17:\"menu_h45_bg_color\";s:7:\"#ffffff\";s:14:\"nav_typography\";a:10:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:14:\"letter-spacing\";s:3:\"0px\";s:5:\"color\";s:7:\"#ffffff\";}s:22:\"menu_hover_first_color\";s:7:\"#ffffff\";s:22:\"nav_dropdown_font_size\";s:4:\"13px\";s:18:\"side_nav_font_size\";s:4:\"14px\";s:15:\"menu_text_align\";s:4:\"left\";s:14:\"menu_sub_color\";s:7:\"#ffffff\";s:26:\"flyout_menu_icon_font_size\";s:4:\"20px\";s:24:\"flyout_nav_icons_padding\";s:2:\"45\";s:22:\"flyout_menu_icon_color\";s:7:\"#333333\";s:28:\"flyout_menu_icon_hover_color\";s:7:\"#a0ce4e\";s:28:\"flyout_menu_background_color\";s:22:\"rgba(255,255,255,0.95)\";s:21:\"flyout_menu_direction\";s:4:\"fade\";s:23:\"topmenu_dropwdown_width\";s:3:\"180\";s:29:\"header_top_first_border_color\";s:7:\"#e5e5e5\";s:23:\"header_top_sub_bg_color\";s:7:\"#ffffff\";s:30:\"header_top_menu_bg_hover_color\";s:7:\"#fafafa\";s:29:\"header_top_menu_sub_sep_color\";s:7:\"#e5e5e5\";s:14:\"snav_font_size\";s:4:\"14px\";s:11:\"sec_menu_lh\";s:4:\"44px\";s:10:\"snav_color\";s:7:\"#747474\";s:25:\"header_top_menu_sub_color\";s:7:\"#747474\";s:31:\"header_top_menu_sub_hover_color\";s:7:\"#333333\";s:18:\"mobile_menu_design\";s:6:\"modern\";s:18:\"mobile_nav_padding\";s:2:\"25\";s:28:\"mobile_menu_icons_top_margin\";s:1:\"3\";s:22:\"mobile_menu_nav_height\";s:2:\"48\";s:27:\"mobile_nav_submenu_slideout\";s:1:\"1\";s:22:\"mobile_header_bg_color\";s:7:\"#24272d\";s:28:\"mobile_menu_background_color\";s:7:\"#24272d\";s:23:\"mobile_menu_hover_color\";s:7:\"#292d33\";s:24:\"mobile_menu_border_color\";s:7:\"#292d33\";s:24:\"mobile_menu_toggle_color\";s:7:\"#ffffff\";s:22:\"mobile_menu_typography\";a:11:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"12px\";s:11:\"line-height\";s:4:\"48px\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#ffffff\";}s:28:\"mobile_menu_font_hover_color\";s:7:\"#ffffff\";s:22:\"mobile_menu_text_align\";s:4:\"left\";s:18:\"megamenu_max_width\";s:4:\"1100\";s:19:\"megamenu_title_size\";s:4:\"18px\";s:30:\"megamenu_item_vertical_padding\";s:1:\"5\";s:29:\"megamenu_item_display_divider\";s:1:\"0\";s:18:\"menu_icon_position\";s:4:\"left\";s:14:\"menu_icon_size\";s:2:\"14\";s:15:\"menu_icon_color\";s:7:\"#ffffff\";s:21:\"menu_icon_hover_color\";s:7:\"#2ba0a3\";s:19:\"menu_thumbnail_size\";a:2:{s:5:\"width\";s:4:\"26px\";s:6:\"height\";s:4:\"14px\";}s:10:\"responsive\";s:1:\"1\";s:21:\"grid_main_break_point\";s:4:\"1099\";s:23:\"side_header_break_point\";s:3:\"920\";s:19:\"content_break_point\";s:3:\"800\";s:19:\"sidebar_break_point\";s:3:\"800\";s:11:\"mobile_zoom\";s:1:\"1\";s:21:\"typography_responsive\";s:1:\"1\";s:22:\"typography_sensitivity\";s:4:\"0.60\";s:17:\"typography_factor\";s:3:\"1.5\";s:13:\"primary_color\";s:7:\"#2ba0a3\";s:15:\"header_position\";s:3:\"Top\";s:13:\"header_layout\";s:2:\"v1\";s:15:\"slider_position\";s:5:\"Below\";s:19:\"header_left_content\";s:12:\"Contact Info\";s:20:\"header_right_content\";s:10:\"Navigation\";s:17:\"header_v4_content\";s:18:\"Tagline And Search\";s:13:\"header_number\";s:28:\"Call Us Today! 1.555.555.555\";s:12:\"header_email\";s:19:\"info@yourdomain.com\";s:14:\"header_tagline\";s:19:\"Insert Tagline Here\";s:18:\"header_banner_code\";s:0:\"\";s:15:\"header_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"header_bg_full\";s:1:\"0\";s:18:\"header_bg_parallax\";s:1:\"1\";s:16:\"header_bg_repeat\";s:6:\"repeat\";s:17:\"side_header_width\";s:3:\"280\";s:14:\"header_padding\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:13:\"header_shadow\";s:1:\"0\";s:16:\"header_100_width\";s:1:\"0\";s:15:\"header_bg_color\";s:7:\"#24272d\";s:19:\"header_border_color\";s:7:\"#ffffff\";s:19:\"header_top_bg_color\";s:7:\"#2ba0a3\";s:17:\"tagline_font_size\";s:4:\"16px\";s:18:\"tagline_font_color\";s:7:\"#ffffff\";s:13:\"header_sticky\";s:1:\"1\";s:20:\"header_sticky_tablet\";s:1:\"0\";s:20:\"header_sticky_mobile\";s:1:\"0\";s:23:\"header_sticky_shrinkage\";s:1:\"0\";s:26:\"header_sticky_type2_layout\";s:9:\"menu_only\";s:22:\"header_sticky_bg_color\";s:7:\"#24272d\";s:24:\"header_sticky_menu_color\";s:7:\"#ffffff\";s:25:\"header_sticky_nav_padding\";s:2:\"45\";s:27:\"header_sticky_nav_font_size\";s:4:\"14px\";s:14:\"logo_alignment\";s:4:\"Left\";s:11:\"logo_margin\";a:4:{s:3:\"top\";s:4:\"31px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"31px\";s:4:\"left\";s:3:\"0px\";}s:15:\"logo_background\";s:1:\"0\";s:21:\"logo_background_color\";s:7:\"#a0ce4e\";s:4:\"logo\";a:5:{s:3:\"url\";s:89:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2015/02/logo-avada-architect.png\";s:2:\"id\";s:3:\"230\";s:6:\"height\";s:2:\"34\";s:5:\"width\";s:3:\"240\";s:9:\"thumbnail\";s:89:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2015/02/logo-avada-architect.png\";}s:11:\"logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"sticky_header_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:25:\"sticky_header_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"mobile_logo\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"mobile_logo_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"favicon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:11:\"iphone_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"iphone_icon_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:9:\"ipad_icon\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:16:\"ipad_icon_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:14:\"page_title_bar\";s:4:\"hide\";s:19:\"page_title_bar_text\";s:1:\"1\";s:20:\"page_title_100_width\";s:1:\"0\";s:17:\"page_title_height\";s:4:\"87px\";s:24:\"page_title_mobile_height\";s:4:\"70px\";s:19:\"page_title_bg_color\";s:7:\"#2ba0a3\";s:23:\"page_title_border_color\";s:7:\"#2ba0a3\";s:20:\"page_title_font_size\";s:4:\"18px\";s:22:\"page_title_line_height\";s:4:\"1.33\";s:16:\"page_title_color\";s:7:\"#ffffff\";s:30:\"page_title_subheader_font_size\";s:4:\"14px\";s:20:\"page_title_alignment\";s:4:\"left\";s:13:\"page_title_bg\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:20:\"page_title_bg_retina\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:18:\"page_title_bg_full\";s:1:\"0\";s:22:\"page_title_bg_parallax\";s:1:\"0\";s:17:\"page_title_fading\";s:1:\"0\";s:17:\"page_title_bar_bs\";s:11:\"Breadcrumbs\";s:17:\"breadcrumb_mobile\";s:1:\"0\";s:16:\"breacrumb_prefix\";s:0:\"\";s:20:\"breadcrumb_separator\";s:1:\"/\";s:21:\"breadcrumbs_font_size\";s:4:\"10px\";s:22:\"breadcrumbs_text_color\";s:7:\"#ffffff\";s:26:\"breadcrumb_show_categories\";s:1:\"1\";s:33:\"breadcrumb_show_post_type_archive\";s:1:\"0\";s:18:\"slidingbar_widgets\";s:1:\"0\";s:25:\"mobile_slidingbar_widgets\";s:1:\"1\";s:19:\"slidingbar_position\";s:3:\"top\";s:17:\"slidingbar_sticky\";s:1:\"0\";s:23:\"slidingbar_open_on_load\";s:1:\"0\";s:26:\"slidingbar_widgets_columns\";s:1:\"2\";s:24:\"slidingbar_content_align\";s:4:\"left\";s:23:\"slidingbar_toggle_style\";s:8:\"triangle\";s:19:\"slidingbar_bg_color\";s:19:\"rgba(36,39,45,0.95)\";s:24:\"slidingbar_divider_color\";s:7:\"#282a2b\";s:28:\"slidingbar_toggle_icon_color\";s:7:\"#ffffff\";s:20:\"slidingbar_font_size\";s:4:\"18px\";s:25:\"slidingbar_headings_color\";s:7:\"#dddddd\";s:21:\"slidingbar_text_color\";s:7:\"#8c8989\";s:21:\"slidingbar_link_color\";s:7:\"#bfbfbf\";s:17:\"slidingbar_border\";s:1:\"0\";s:14:\"footer_widgets\";s:1:\"1\";s:22:\"footer_widgets_columns\";s:1:\"2\";s:29:\"footer_widgets_center_content\";s:1:\"0\";s:22:\"footer_special_effects\";s:4:\"none\";s:16:\"footer_copyright\";s:1:\"1\";s:31:\"footer_copyright_center_content\";s:1:\"0\";s:11:\"footer_text\";s:658:\"   |   © Copyright 2012 - <script>document.write(new Date().getFullYear());</script>   |   قالب آوادا توسط <a href=\'http://theme-fusion.com\' target=\'_blank\' rel=\"nofollow\">تم فیوژن</a>   |   تمام حقوق محفوظ می‌باشد   |   قدرت گرفته از <a href=\'http://wordpress.org\' target=\'_blank\' rel=\"nofollow\">وردپرس</a>         

<span style=\"float:right;color:#fff\"><i class=\"fa fa-phone\"></i>  021.200.555.67         <a href=\"mailto:support@iranavada.com\" style=\"color:#fff;text-transform:uppercase;\"><i class=\"fa fa-envelope-o\"></i> ایمیل ما  </a></span>\";s:16:\"footerw_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"footerw_bg_full\";s:1:\"0\";s:17:\"footerw_bg_repeat\";s:6:\"repeat\";s:14:\"footerw_bg_pos\";s:13:\"center center\";s:16:\"footer_100_width\";s:1:\"0\";s:19:\"footer_area_padding\";a:4:{s:3:\"top\";s:4:\"43px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:4:\"40px\";s:4:\"left\";s:3:\"0px\";}s:15:\"footer_bg_color\";s:7:\"#24272d\";s:18:\"footer_border_size\";s:2:\"12\";s:19:\"footer_border_color\";s:7:\"#24272d\";s:20:\"footer_divider_color\";s:7:\"#505152\";s:17:\"copyright_padding\";a:2:{s:3:\"top\";s:4:\"18px\";s:6:\"bottom\";s:4:\"18px\";}s:18:\"copyright_bg_color\";s:7:\"#2b2e35\";s:21:\"copyright_border_size\";s:1:\"1\";s:22:\"copyright_border_color\";s:7:\"#2b2e35\";s:26:\"footer_headings_typography\";a:11:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:3:\"1.5\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#ffffff\";}s:17:\"footer_text_color\";s:7:\"#5a5d62\";s:17:\"footer_link_color\";s:7:\"#868a92\";s:23:\"footer_link_color_hover\";s:7:\"#2ba0a3\";s:20:\"copyright_text_color\";s:7:\"#5a5d62\";s:20:\"copyright_link_color\";s:7:\"#868a92\";s:26:\"copyright_link_color_hover\";s:7:\"#2ba0a3\";s:19:\"copyright_font_size\";s:4:\"12px\";s:14:\"sidebar_sticky\";s:4:\"none\";s:15:\"sidebar_padding\";s:2:\"3%\";s:16:\"sidebar_bg_color\";s:7:\"#f8f8f8\";s:23:\"sidebar_widget_bg_color\";s:19:\"rgba(255,255,255,0)\";s:15:\"sidew_font_size\";s:4:\"18px\";s:21:\"sidebar_heading_color\";s:7:\"#333333\";s:20:\"pages_global_sidebar\";s:1:\"0\";s:13:\"pages_sidebar\";s:4:\"None\";s:15:\"pages_sidebar_2\";s:4:\"None\";s:19:\"default_sidebar_pos\";s:5:\"Right\";s:24:\"portfolio_global_sidebar\";s:1:\"0\";s:17:\"portfolio_sidebar\";s:4:\"None\";s:19:\"portfolio_sidebar_2\";s:4:\"None\";s:26:\"portfolio_sidebar_position\";s:5:\"Right\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:27:\"portfolio_archive_sidebar_2\";s:4:\"None\";s:20:\"posts_global_sidebar\";s:1:\"1\";s:13:\"posts_sidebar\";s:12:\"Blog Sidebar\";s:15:\"posts_sidebar_2\";s:4:\"None\";s:21:\"blog_sidebar_position\";s:4:\"Left\";s:20:\"blog_archive_sidebar\";s:12:\"Blog Sidebar\";s:22:\"blog_archive_sidebar_2\";s:4:\"None\";s:14:\"search_sidebar\";s:12:\"Blog Sidebar\";s:16:\"search_sidebar_2\";s:4:\"None\";s:23:\"search_sidebar_position\";s:5:\"Right\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:16:\"content_bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:15:\"content_bg_full\";s:1:\"0\";s:17:\"content_bg_repeat\";s:6:\"repeat\";s:8:\"bg_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:7:\"bg_full\";s:1:\"0\";s:9:\"bg_repeat\";s:6:\"repeat\";s:8:\"bg_color\";s:7:\"#d7d6d6\";s:17:\"bg_pattern_option\";s:1:\"0\";s:10:\"bg_pattern\";s:8:\"pattern1\";s:15:\"body_typography\";a:11:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"15px\";s:11:\"line-height\";s:4:\"2.27\";s:14:\"letter-spacing\";s:1:\"0\";s:5:\"color\";s:7:\"#5a5d62\";}s:10:\"link_color\";s:7:\"#2ba0a3\";s:13:\"h1_typography\";a:13:{s:11:\"font-family\";s:5:\"Dinar\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"60px\";s:11:\"line-height\";s:4:\"1.33\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"0.67em\";s:13:\"margin-bottom\";s:6:\"0.67em\";s:5:\"color\";s:7:\"#ffffff\";}s:13:\"h2_typography\";a:13:{s:11:\"font-family\";s:5:\"Dinar\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"48px\";s:11:\"line-height\";s:4:\"1.25\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"1.0em\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h3_typography\";a:13:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"22px\";s:11:\"line-height\";s:4:\"1.91\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:3:\"1em\";s:13:\"margin-bottom\";s:3:\"0em\";s:5:\"color\";s:7:\"#5a5d62\";}s:13:\"h4_typography\";a:13:{s:11:\"font-family\";s:12:\"IranSansBold\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"18px\";s:11:\"line-height\";s:4:\"2.11\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"1.33em\";s:13:\"margin-bottom\";s:6:\"1.33em\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h5_typography\";a:13:{s:11:\"font-family\";s:12:\"IranSansBold\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"14px\";s:11:\"line-height\";s:4:\"1.29\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"1.67em\";s:13:\"margin-bottom\";s:6:\"1.67em\";s:5:\"color\";s:7:\"#242930\";}s:13:\"h6_typography\";a:13:{s:11:\"font-family\";s:12:\"IranSansBold\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:9:\"font-size\";s:4:\"11px\";s:11:\"line-height\";s:4:\"1.55\";s:14:\"letter-spacing\";s:3:\"0px\";s:10:\"margin-top\";s:6:\"2.33em\";s:13:\"margin-bottom\";s:6:\"2.33em\";s:5:\"color\";s:7:\"#242930\";}s:21:\"post_titles_font_size\";s:4:\"22px\";s:19:\"post_titles_font_lh\";s:4:\"32px\";s:28:\"post_titles_extras_font_size\";s:4:\"22px\";s:12:\"custom_fonts\";a:7:{s:25:\"fusionredux_repeater_data\";a:3:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"name\";a:3:{i:0;s:8:\"iranSans\";i:1;s:12:\"IranSansBold\";i:2;s:5:\"Dinar\";}s:4:\"woff\";a:3:{i:0;a:5:{s:3:\"url\";s:86:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.woff\";s:2:\"id\";s:3:\"685\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:86:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.woff\";s:2:\"id\";s:3:\"688\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:75:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.woff\";s:2:\"id\";s:3:\"694\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}s:5:\"woff2\";a:3:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"ttf\";a:3:{i:0;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.ttf\";s:2:\"id\";s:3:\"684\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.ttf\";s:2:\"id\";s:3:\"687\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:74:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.ttf\";s:2:\"id\";s:3:\"696\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}s:3:\"svg\";a:3:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}s:3:\"eot\";a:3:{i:0;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWebFaNum.eot\";s:2:\"id\";s:3:\"686\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:1;a:5:{s:3:\"url\";s:85:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/IRANSansWeb_Bold.eot\";s:2:\"id\";s:3:\"689\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}i:2;a:5:{s:3:\"url\";s:74:\"http://demo.iranavada.ir/architecture/wp-content/uploads/2017/12/dinar.eot\";s:2:\"id\";s:3:\"695\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:74:\"http://demo.iranavada.ir/architecture/wp-includes/images/media/default.png\";}}}s:19:\"blog_page_title_bar\";s:4:\"hide\";s:24:\"blog_show_page_title_bar\";s:4:\"hide\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:11:\"blog_layout\";s:5:\"Large\";s:19:\"blog_archive_layout\";s:6:\"Medium\";s:20:\"blog_pagination_type\";s:10:\"Pagination\";s:36:\"blog_load_more_posts_button_bg_color\";s:7:\"#2e323a\";s:17:\"blog_grid_columns\";s:1:\"3\";s:24:\"blog_grid_column_spacing\";s:2:\"40\";s:18:\"blog_equal_heights\";s:1:\"0\";s:25:\"blog_archive_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:14:\"content_length\";s:7:\"Excerpt\";s:19:\"excerpt_length_blog\";s:2:\"55\";s:18:\"strip_html_excerpt\";s:1:\"1\";s:15:\"featured_images\";s:1:\"1\";s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:14:\"blog_width_100\";s:1:\"0\";s:22:\"featured_images_single\";s:1:\"1\";s:11:\"blog_pn_nav\";s:1:\"0\";s:15:\"blog_post_title\";s:5:\"below\";s:23:\"blog_post_meta_position\";s:13:\"below_article\";s:11:\"author_info\";s:1:\"0\";s:18:\"social_sharing_box\";s:1:\"1\";s:13:\"related_posts\";s:1:\"1\";s:13:\"blog_comments\";s:1:\"0\";s:9:\"post_meta\";s:1:\"1\";s:16:\"post_meta_author\";s:1:\"1\";s:14:\"post_meta_date\";s:1:\"1\";s:14:\"post_meta_cats\";s:1:\"1\";s:18:\"post_meta_comments\";s:1:\"1\";s:14:\"post_meta_read\";s:1:\"1\";s:14:\"post_meta_tags\";s:1:\"0\";s:14:\"meta_font_size\";s:4:\"12px\";s:11:\"date_format\";s:7:\"F jS, Y\";s:24:\"portfolio_archive_layout\";s:4:\"grid\";s:37:\"portfolio_archive_featured_image_size\";s:4:\"full\";s:25:\"portfolio_archive_columns\";s:1:\"3\";s:32:\"portfolio_archive_column_spacing\";s:2:\"30\";s:23:\"portfolio_equal_heights\";s:1:\"0\";s:42:\"portfolio_archive_one_column_text_position\";s:5:\"below\";s:23:\"portfolio_archive_items\";s:2:\"10\";s:29:\"portfolio_archive_text_layout\";s:7:\"no_text\";s:32:\"portfolio_archive_content_length\";s:7:\"excerpt\";s:32:\"portfolio_archive_excerpt_length\";s:1:\"0\";s:36:\"portfolio_archive_strip_html_excerpt\";s:1:\"1\";s:31:\"portfolio_archive_title_display\";s:3:\"all\";s:32:\"portfolio_archive_text_alignment\";s:4:\"left\";s:32:\"portfolio_archive_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:33:\"portfolio_archive_pagination_type\";s:15:\"infinite_scroll\";s:49:\"portfolio_archive_load_more_posts_button_bg_color\";s:7:\"#ebeaea\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:24:\"portfolio_meta_font_size\";s:4:\"18px\";s:16:\"portfolio_pn_nav\";s:1:\"0\";s:25:\"portfolio_featured_images\";s:1:\"1\";s:38:\"portfolio_disable_first_featured_image\";s:1:\"1\";s:30:\"portfolio_featured_image_width\";s:4:\"full\";s:19:\"portfolio_width_100\";s:1:\"0\";s:28:\"portfolio_project_desc_title\";s:1:\"1\";s:25:\"portfolio_project_details\";s:1:\"1\";s:26:\"portfolio_link_icon_target\";s:1:\"0\";s:18:\"portfolio_comments\";s:1:\"0\";s:16:\"portfolio_author\";s:1:\"0\";s:28:\"portfolio_social_sharing_box\";s:1:\"0\";s:23:\"portfolio_related_posts\";s:1:\"1\";s:18:\"social_media_icons\";a:5:{s:25:\"fusionredux_repeater_data\";a:7:{i:0;a:1:{s:5:\"title\";s:0:\"\";}i:1;a:1:{s:5:\"title\";s:0:\"\";}i:2;a:1:{s:5:\"title\";s:0:\"\";}i:3;a:1:{s:5:\"title\";s:0:\"\";}i:4;a:1:{s:5:\"title\";s:0:\"\";}i:5;a:1:{s:5:\"title\";s:0:\"\";}i:6;a:1:{s:5:\"title\";s:0:\"\";}}s:4:\"icon\";a:7:{i:0;s:8:\"facebook\";i:1;s:7:\"twitter\";i:2;s:6:\"flickr\";i:3;s:7:\"youtube\";i:4;s:9:\"instagram\";i:5;s:9:\"pinterest\";i:6;s:5:\"gplus\";}s:3:\"url\";a:7:{i:0;s:1:\"#\";i:1;s:1:\"#\";i:2;s:1:\"#\";i:3;s:1:\"#\";i:4;s:1:\"#\";i:5;s:1:\"#\";i:6;s:1:\"#\";}s:12:\"custom_title\";a:7:{i:0;s:0:\"\";i:1;s:0:\"\";i:2;s:0:\"\";i:3;s:0:\"\";i:4;s:0:\"\";i:5;s:0:\"\";i:6;s:0:\"\";}s:13:\"custom_source\";a:7:{i:0;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:1;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:2;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:3;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:4;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:5;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}i:6;a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}}}s:29:\"header_social_links_font_size\";s:4:\"16px\";s:37:\"header_social_links_tooltip_placement\";s:6:\"Bottom\";s:30:\"header_social_links_color_type\";s:6:\"custom\";s:30:\"header_social_links_icon_color\";s:7:\"#bebdbd\";s:25:\"header_social_links_boxed\";s:1:\"0\";s:29:\"header_social_links_box_color\";s:7:\"#e8e8e8\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:33:\"header_social_links_boxed_padding\";s:3:\"8px\";s:12:\"icons_footer\";s:1:\"0\";s:29:\"footer_social_links_font_size\";s:4:\"16px\";s:37:\"footer_social_links_tooltip_placement\";s:5:\"Right\";s:30:\"footer_social_links_color_type\";s:6:\"custom\";s:30:\"footer_social_links_icon_color\";s:7:\"#828c8e\";s:25:\"footer_social_links_boxed\";s:1:\"1\";s:29:\"footer_social_links_box_color\";s:7:\"#2c3038\";s:32:\"footer_social_links_boxed_radius\";s:3:\"50%\";s:33:\"footer_social_links_boxed_padding\";s:3:\"8px\";s:22:\"sharing_social_tagline\";s:39:\"Share This Story, Choose Your Platform!\";s:30:\"sharing_box_tagline_text_color\";s:7:\"#333333\";s:15:\"social_bg_color\";s:7:\"#f8f8f8\";s:30:\"sharing_social_links_font_size\";s:4:\"18px\";s:38:\"sharing_social_links_tooltip_placement\";s:3:\"Top\";s:31:\"sharing_social_links_color_type\";s:6:\"custom\";s:31:\"sharing_social_links_icon_color\";s:7:\"#828c8e\";s:26:\"sharing_social_links_boxed\";s:1:\"1\";s:30:\"sharing_social_links_box_color\";s:7:\"#2b2e35\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"50%\";s:34:\"sharing_social_links_boxed_padding\";s:4:\"12px\";s:16:\"sharing_facebook\";s:1:\"1\";s:15:\"sharing_twitter\";s:1:\"1\";s:14:\"sharing_reddit\";s:1:\"0\";s:16:\"sharing_linkedin\";s:1:\"1\";s:14:\"sharing_google\";s:1:\"1\";s:14:\"sharing_tumblr\";s:1:\"0\";s:17:\"sharing_pinterest\";s:1:\"1\";s:10:\"sharing_vk\";s:1:\"0\";s:13:\"sharing_email\";s:1:\"0\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";s:1:\"1\";s:23:\"slideshow_smooth_height\";s:1:\"1\";s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";s:1:\"0\";s:25:\"slider_nav_box_dimensions\";a:2:{s:5:\"width\";s:4:\"25px\";s:6:\"height\";s:4:\"65px\";}s:17:\"slider_arrow_size\";s:4:\"14px\";s:15:\"tfes_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"400px\";}s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";s:1:\"1\";s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"150\";s:18:\"es_title_font_size\";s:4:\"42px\";s:20:\"es_caption_font_size\";s:4:\"20px\";s:14:\"es_title_color\";s:7:\"#333333\";s:16:\"es_caption_color\";s:7:\"#747474\";s:15:\"status_lightbox\";s:1:\"1\";s:22:\"status_lightbox_single\";s:1:\"1\";s:17:\"lightbox_behavior\";s:3:\"all\";s:13:\"lightbox_skin\";s:11:\"metro-black\";s:13:\"lightbox_path\";s:8:\"vertical\";s:24:\"lightbox_animation_speed\";s:4:\"Fast\";s:15:\"lightbox_arrows\";s:1:\"1\";s:16:\"lightbox_gallery\";s:1:\"1\";s:17:\"lightbox_autoplay\";s:1:\"0\";s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:5:\"0.925\";s:14:\"lightbox_title\";s:1:\"0\";s:13:\"lightbox_desc\";s:1:\"0\";s:15:\"lightbox_social\";s:1:\"0\";s:20:\"lightbox_deeplinking\";s:1:\"1\";s:20:\"lightbox_post_images\";s:1:\"1\";s:25:\"lightbox_video_dimensions\";a:2:{s:5:\"width\";s:6:\"1280px\";s:6:\"height\";s:5:\"720px\";}s:13:\"email_address\";s:0:\"\";s:24:\"contact_comment_position\";s:5:\"below\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:5:\"light\";s:8:\"gmap_api\";s:0:\"\";s:12:\"gmap_address\";s:49:\"775 New York Ave, Brooklyn, Kings, New York 11203\";s:9:\"gmap_type\";s:7:\"roadmap\";s:15:\"gmap_dimensions\";a:2:{s:5:\"width\";s:4:\"100%\";s:6:\"height\";s:5:\"415px\";}s:14:\"gmap_topmargin\";s:4:\"55px\";s:14:\"map_zoom_level\";s:1:\"8\";s:7:\"map_pin\";s:1:\"1\";s:18:\"gmap_pin_animation\";s:1:\"1\";s:9:\"map_popup\";s:1:\"0\";s:15:\"map_scrollwheel\";s:1:\"1\";s:9:\"map_scale\";s:1:\"1\";s:15:\"map_zoomcontrol\";s:1:\"1\";s:11:\"map_styling\";s:7:\"default\";s:17:\"map_overlay_color\";s:7:\"#2ba0a3\";s:19:\"map_infobox_styling\";s:7:\"default\";s:19:\"map_infobox_content\";s:0:\"\";s:20:\"map_infobox_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"map_infobox_text_color\";s:7:\"#747474\";s:22:\"map_custom_marker_icon\";s:0:\"\";s:13:\"search_layout\";s:4:\"Grid\";s:14:\"search_content\";s:15:\"Posts and Pages\";s:14:\"search_excerpt\";s:1:\"1\";s:23:\"search_results_per_page\";s:2:\"10\";s:22:\"search_featured_images\";s:1:\"1\";s:26:\"search_new_search_position\";s:3:\"top\";s:16:\"sidenav_behavior\";s:5:\"Hover\";s:26:\"featured_image_placeholder\";s:1:\"1\";s:12:\"excerpt_base\";s:5:\"Words\";s:16:\"disable_excerpts\";s:1:\"1\";s:14:\"link_read_more\";s:1:\"0\";s:14:\"comments_pages\";s:1:\"0\";s:21:\"featured_images_pages\";s:1:\"1\";s:21:\"nofollow_social_links\";s:1:\"0\";s:16:\"social_icons_new\";s:1:\"1\";s:20:\"related_posts_layout\";s:17:\"title_below_image\";s:20:\"number_related_posts\";s:1:\"5\";s:21:\"related_posts_columns\";s:1:\"3\";s:28:\"related_posts_column_spacing\";s:2:\"10\";s:24:\"related_posts_image_size\";s:7:\"cropped\";s:22:\"related_posts_autoplay\";s:1:\"1\";s:19:\"related_posts_speed\";s:4:\"2500\";s:24:\"related_posts_navigation\";s:1:\"0\";s:19:\"related_posts_swipe\";s:1:\"1\";s:25:\"related_posts_swipe_items\";s:1:\"1\";s:14:\"image_rollover\";s:1:\"1\";s:24:\"image_rollover_direction\";s:6:\"bottom\";s:24:\"image_rollover_icon_size\";s:4:\"20px\";s:19:\"link_image_rollover\";s:1:\"1\";s:19:\"zoom_image_rollover\";s:1:\"1\";s:20:\"title_image_rollover\";s:1:\"1\";s:19:\"cats_image_rollover\";s:1:\"0\";s:26:\"icon_circle_image_rollover\";s:1:\"1\";s:24:\"image_gradient_top_color\";s:21:\"rgba(43,160,163,0.85)\";s:27:\"image_gradient_bottom_color\";s:7:\"#2ba0a3\";s:25:\"image_rollover_text_color\";s:15:\"rgba(0,0,0,.65)\";s:25:\"image_rollover_icon_color\";s:7:\"#ffffff\";s:22:\"pagination_box_padding\";a:2:{s:5:\"width\";s:3:\"6px\";s:6:\"height\";s:3:\"2px\";}s:23:\"pagination_text_display\";s:1:\"1\";s:20:\"pagination_font_size\";s:4:\"12px\";s:17:\"form_input_height\";s:4:\"40px\";s:13:\"form_bg_color\";s:7:\"#373d4d\";s:15:\"form_text_color\";s:7:\"#ffffff\";s:17:\"form_border_color\";s:20:\"rgba(255,255,255,.5)\";s:17:\"timeline_bg_color\";s:19:\"rgba(255,255,255,0)\";s:14:\"timeline_color\";s:7:\"#ebeaea\";s:25:\"grid_separator_style_type\";s:12:\"double|solid\";s:20:\"grid_separator_color\";s:7:\"#e0dede\";s:16:\"google_analytics\";s:0:\"\";s:10:\"space_head\";s:0:\"\";s:10:\"space_body\";s:0:\"\";s:19:\"dependencies_status\";s:1:\"1\";s:15:\"pw_jpeg_quality\";s:3:\"100\";s:16:\"smooth_scrolling\";s:1:\"0\";s:27:\"disable_code_block_encoding\";s:1:\"1\";s:16:\"disable_megamenu\";s:1:\"1\";s:16:\"avada_rev_styles\";s:1:\"1\";s:22:\"avada_styles_dropdowns\";s:1:\"1\";s:15:\"use_animate_css\";s:1:\"1\";s:26:\"disable_mobile_animate_css\";s:1:\"0\";s:27:\"disable_mobile_image_hovers\";s:1:\"1\";s:9:\"status_yt\";s:1:\"1\";s:12:\"status_vimeo\";s:1:\"1\";s:11:\"status_gmap\";s:1:\"1\";s:12:\"status_totop\";s:1:\"1\";s:19:\"status_totop_mobile\";s:1:\"1\";s:20:\"status_fusion_slider\";s:1:\"1\";s:14:\"status_eslider\";s:1:\"1\";s:18:\"status_fontawesome\";s:1:\"1\";s:16:\"status_opengraph\";s:1:\"1\";s:31:\"disable_date_rich_snippet_pages\";s:1:\"1\";s:26:\"disable_rich_snippet_title\";s:1:\"1\";s:27:\"disable_rich_snippet_author\";s:1:\"1\";s:25:\"disable_rich_snippet_date\";s:1:\"1\";s:16:\"css_cache_method\";s:4:\"file\";s:15:\"cache_server_ip\";s:0:\"\";s:11:\"js_compiler\";s:1:\"0\";s:10:\"custom_css\";s:1313:\"/* top border on dropdown */
.fusion-main-menu .sub-menu { border-top: 1px solid #ffffff; }

/* Center footer widgets on mobile */
@media only screen and (max-width: 800px) {
.fusion-footer #text-4 .fusion-button-wrapper.fusion-alignright {  float: none; margin: 0; }
.fusion-footer #social_links-widget-2 .fusion-social-networks.boxed-icons { text-align: center;}
.fusion-footer .widget .fusion-social-networks.boxed-icons .fusion-social-network-icon:last-child { margin-right: 0;}
.fusion-footer #text-4 { text-align: center; }
.fusion-footer .fusion-columns .fusion-column { margin-bottom: 25px;}
}








/* Architectuer */

.fusion-layout-column.fusion-spacing-yes {
    margin-right: 0;
    margin-left: 4%;
}
.wpcf7-select-parent .select-arrow {
    border-right: 1px solid #dadada;
    border-left: 0;
    left: 1px;
    right: auto;
}
select.wpcf7-form-control.wpcf7-select {
    direction: rtl;
}
.wpcf7-form label {
    direction: rtl;
    display: inline-block;
    width: 100%;
}
.full-boxed-pricing .panel-body .price .integer-part {
    font-size: 42px;
}
.fusion-pricing-table .panel-body .price .time.pos-right {
    margin-right: 12px;
}
.fusion-pricing-table .panel-body .price .currency.pos-right.price-without-decimal {
    margin-right: 6px;
}\";s:13:\"info_bg_color\";s:7:\"#ffffff\";s:15:\"danger_bg_color\";s:7:\"#f2dede\";s:16:\"success_bg_color\";s:7:\"#dff0d8\";s:16:\"warning_bg_color\";s:7:\"#fcf8e3\";s:16:\"alert_box_shadow\";s:2:\"no\";s:17:\"alert_border_size\";s:3:\"1px\";s:16:\"animation_offset\";s:13:\"top-into-view\";s:15:\"dates_box_color\";s:7:\"#4194ce\";s:17:\"blog_grid_padding\";a:4:{s:3:\"top\";s:4:\"30px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"20px\";s:4:\"left\";s:4:\"25px\";}s:12:\"blog_excerpt\";s:3:\"yes\";s:19:\"blog_excerpt_length\";s:2:\"10\";s:11:\"button_size\";s:5:\"Large\";s:11:\"button_span\";s:2:\"no\";s:12:\"button_shape\";s:6:\"Square\";s:11:\"button_type\";s:4:\"Flat\";s:17:\"button_typography\";a:8:{s:11:\"font-family\";s:8:\"iranSans\";s:12:\"font-options\";s:0:\"\";s:6:\"google\";s:1:\"1\";s:11:\"font-backup\";s:28:\"Arial, Helvetica, sans-serif\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:7:\"subsets\";s:0:\"\";s:14:\"letter-spacing\";s:3:\"0px\";}s:25:\"button_gradient_top_color\";s:19:\"rgba(255,255,255,0)\";s:28:\"button_gradient_bottom_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"button_gradient_top_color_hover\";s:22:\"rgba(255,255,255,.035)\";s:34:\"button_gradient_bottom_color_hover\";s:22:\"rgba(255,255,255,.035)\";s:19:\"button_accent_color\";s:21:\"rgba(255,255,255,.75)\";s:25:\"button_accent_hover_color\";s:20:\"rgba(255,255,255,.9)\";s:18:\"button_bevel_color\";s:7:\"#ffffff\";s:19:\"button_border_width\";s:1:\"1\";s:18:\"carousel_nav_color\";s:15:\"rgba(0,0,0,.85)\";s:20:\"carousel_hover_color\";s:15:\"rgba(0,0,0,.95)\";s:14:\"carousel_speed\";s:4:\"2500\";s:21:\"checklist_icons_color\";s:7:\"#ffffff\";s:16:\"checklist_circle\";s:1:\"1\";s:22:\"checklist_circle_color\";s:19:\"rgba(255,255,255,0)\";s:10:\"col_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"20px\";}s:25:\"container_padding_default\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:3:\"0px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:3:\"0px\";}s:21:\"container_padding_100\";a:4:{s:3:\"top\";s:3:\"0px\";s:5:\"right\";s:4:\"30px\";s:6:\"bottom\";s:3:\"0px\";s:4:\"left\";s:4:\"30px\";}s:19:\"full_width_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"full_width_border_size\";s:1:\"0\";s:23:\"full_width_border_color\";s:7:\"#eae9e9\";s:29:\"container_scroll_nav_bg_color\";s:18:\"rgba(0, 0, 0, 0.2)\";s:33:\"container_scroll_nav_bullet_color\";s:7:\"#eeeeee\";s:39:\"container_hundred_percent_height_mobile\";s:1:\"0\";s:20:\"content_box_bg_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"content_box_title_size\";s:4:\"18px\";s:23:\"content_box_title_color\";s:7:\"#242930\";s:22:\"content_box_body_color\";s:7:\"#747474\";s:21:\"content_box_icon_size\";s:4:\"21px\";s:22:\"content_box_icon_color\";s:7:\"#ffffff\";s:23:\"content_box_icon_circle\";s:3:\"yes\";s:30:\"content_box_icon_circle_radius\";s:3:\"50%\";s:25:\"content_box_icon_bg_color\";s:7:\"#333333\";s:38:\"content_box_icon_bg_inner_border_color\";s:7:\"#333333\";s:37:\"content_box_icon_bg_inner_border_size\";s:1:\"1\";s:38:\"content_box_icon_bg_outer_border_color\";s:19:\"rgba(255,255,255,0)\";s:37:\"content_box_icon_bg_outer_border_size\";s:1:\"0\";s:27:\"content_box_icon_hover_type\";s:4:\"fade\";s:40:\"content_box_hover_animation_accent_color\";s:7:\"#2ba0a3\";s:21:\"content_box_link_type\";s:4:\"text\";s:21:\"content_box_link_area\";s:9:\"link-icon\";s:23:\"content_box_link_target\";s:5:\"_self\";s:18:\"content_box_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"60px\";}s:18:\"countdown_timezone\";s:9:\"site_time\";s:20:\"countdown_show_weeks\";s:2:\"no\";s:26:\"countdown_background_color\";s:7:\"#a0ce4e\";s:26:\"countdown_background_image\";a:5:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"height\";s:0:\"\";s:5:\"width\";s:0:\"\";s:9:\"thumbnail\";s:0:\"\";}s:27:\"countdown_background_repeat\";s:9:\"no-repeat\";s:29:\"countdown_background_position\";s:13:\"center center\";s:27:\"countdown_counter_box_color\";s:7:\"#333333\";s:28:\"countdown_counter_text_color\";s:7:\"#ffffff\";s:28:\"countdown_heading_text_color\";s:7:\"#ffffff\";s:31:\"countdown_subheading_text_color\";s:7:\"#ffffff\";s:25:\"countdown_link_text_color\";s:7:\"#ffffff\";s:21:\"countdown_link_target\";s:5:\"_self\";s:17:\"counter_box_speed\";s:4:\"1000\";s:17:\"counter_box_color\";s:7:\"#9e9e9e\";s:22:\"counter_box_title_size\";s:4:\"50px\";s:21:\"counter_box_icon_size\";s:4:\"50px\";s:22:\"counter_box_body_color\";s:7:\"#747474\";s:21:\"counter_box_body_size\";s:4:\"13px\";s:24:\"counter_box_border_color\";s:7:\"#e0dede\";s:20:\"counter_box_icon_top\";s:2:\"no\";s:20:\"counter_filled_color\";s:7:\"#9e9e9e\";s:22:\"counter_unfilled_color\";s:7:\"#f6f6f6\";s:13:\"dropcap_color\";s:7:\"#2ba0a3\";s:18:\"faq_featured_image\";s:1:\"0\";s:11:\"faq_filters\";s:3:\"yes\";s:18:\"faq_accordion_type\";s:10:\"accordions\";s:24:\"faq_accordion_boxed_mode\";s:1:\"0\";s:25:\"faq_accordion_border_size\";s:1:\"1\";s:26:\"faq_accordian_border_color\";s:7:\"#cccccc\";s:30:\"faq_accordian_background_color\";s:7:\"#ffffff\";s:25:\"faq_accordian_hover_color\";s:7:\"#f9f9f9\";s:26:\"faq_accordion_divider_line\";s:1:\"1\";s:23:\"faq_accordion_icon_size\";s:2:\"13\";s:24:\"faq_accordian_icon_color\";s:7:\"#ffffff\";s:24:\"faq_accordion_icon_boxed\";s:1:\"1\";s:28:\"faq_accordian_inactive_color\";s:7:\"#333333\";s:26:\"faq_accordian_active_color\";s:7:\"#2ba0a3\";s:24:\"faq_accordion_icon_align\";s:4:\"left\";s:19:\"flip_boxes_front_bg\";s:7:\"#f6f6f6\";s:24:\"flip_boxes_front_heading\";s:7:\"#333333\";s:21:\"flip_boxes_front_text\";s:7:\"#747474\";s:18:\"flip_boxes_back_bg\";s:7:\"#9e9e9e\";s:23:\"flip_boxes_back_heading\";s:7:\"#eeeded\";s:20:\"flip_boxes_back_text\";s:7:\"#ffffff\";s:22:\"flip_boxes_border_size\";s:1:\"1\";s:23:\"flip_boxes_border_color\";s:19:\"rgba(255,255,255,0)\";s:24:\"flip_boxes_border_radius\";s:3:\"4px\";s:20:\"gallery_picture_size\";s:4:\"auto\";s:14:\"gallery_layout\";s:4:\"grid\";s:15:\"gallery_columns\";s:1:\"3\";s:22:\"gallery_column_spacing\";s:2:\"10\";s:18:\"gallery_hover_type\";s:4:\"none\";s:24:\"gallery_lightbox_content\";s:4:\"none\";s:17:\"icon_circle_color\";s:7:\"#2ba0a3\";s:17:\"icon_border_color\";s:7:\"#2ba0a3\";s:10:\"icon_color\";s:7:\"#ffffff\";s:21:\"imgframe_border_color\";s:7:\"#f6f6f6\";s:22:\"imageframe_border_size\";s:1:\"0\";s:24:\"imageframe_border_radius\";s:1:\"0\";s:20:\"imgframe_style_color\";s:7:\"#000000\";s:14:\"modal_bg_color\";s:7:\"#f6f6f6\";s:18:\"modal_border_color\";s:7:\"#ebebeb\";s:23:\"person_background_color\";s:13:\"rgba(0,0,0,0)\";s:19:\"person_border_color\";s:7:\"#f6f6f6\";s:18:\"person_border_size\";s:1:\"0\";s:20:\"person_border_radius\";s:1:\"0\";s:18:\"person_style_color\";s:7:\"#000000\";s:16:\"person_alignment\";s:4:\"Left\";s:20:\"person_icon_position\";s:3:\"Top\";s:24:\"popover_heading_bg_color\";s:7:\"#f6f6f6\";s:24:\"popover_content_bg_color\";s:7:\"#ffffff\";s:20:\"popover_border_color\";s:7:\"#ebebeb\";s:18:\"popover_text_color\";s:7:\"#747474\";s:17:\"popover_placement\";s:3:\"Top\";s:29:\"portfolio_featured_image_size\";s:4:\"full\";s:24:\"portfolio_column_spacing\";s:2:\"30\";s:15:\"portfolio_items\";s:2:\"12\";s:21:\"portfolio_text_layout\";s:7:\"unboxed\";s:24:\"portfolio_content_length\";s:7:\"excerpt\";s:24:\"portfolio_excerpt_length\";s:1:\"0\";s:28:\"portfolio_strip_html_excerpt\";s:1:\"1\";s:23:\"portfolio_title_display\";s:3:\"all\";s:24:\"portfolio_text_alignment\";s:4:\"left\";s:24:\"portfolio_layout_padding\";a:4:{s:3:\"top\";s:4:\"25px\";s:5:\"right\";s:4:\"25px\";s:6:\"bottom\";s:4:\"25px\";s:4:\"left\";s:4:\"25px\";}s:25:\"portfolio_pagination_type\";s:15:\"infinite_scroll\";s:41:\"portfolio_load_more_posts_button_bg_color\";s:7:\"#2e323a\";s:36:\"full_boxed_pricing_box_heading_color\";s:7:\"#242930\";s:29:\"sep_pricing_box_heading_color\";s:7:\"#ffffff\";s:17:\"pricing_box_color\";s:7:\"#5a5d62\";s:16:\"pricing_bg_color\";s:7:\"#ffffff\";s:30:\"pricing_background_color_hover\";s:7:\"#f8f8f8\";s:20:\"pricing_border_color\";s:7:\"#f8f8f8\";s:21:\"pricing_divider_color\";s:7:\"#ffffff\";s:18:\"progressbar_height\";s:4:\"37px\";s:25:\"progressbar_text_position\";s:6:\"on_bar\";s:24:\"progressbar_filled_color\";s:19:\"rgba(255,255,255,0)\";s:31:\"progressbar_filled_border_color\";s:7:\"#ffffff\";s:30:\"progressbar_filled_border_size\";s:1:\"2\";s:26:\"progressbar_unfilled_color\";s:19:\"rgba(255,255,255,0)\";s:22:\"progressbar_text_color\";s:7:\"#ffffff\";s:23:\"section_sep_border_size\";s:1:\"1\";s:14:\"section_sep_bg\";s:7:\"#f6f6f6\";s:24:\"section_sep_border_color\";s:7:\"#f6f6f6\";s:20:\"separator_style_type\";s:6:\"double\";s:9:\"sep_color\";s:7:\"#e0dede\";s:16:\"separator_circle\";s:1:\"1\";s:21:\"separator_border_size\";s:1:\"1\";s:22:\"social_links_font_size\";s:4:\"16px\";s:23:\"social_links_color_type\";s:6:\"custom\";s:23:\"social_links_icon_color\";s:7:\"#bebdbd\";s:18:\"social_links_boxed\";s:1:\"0\";s:22:\"social_links_box_color\";s:7:\"#e8e8e8\";s:25:\"social_links_boxed_radius\";s:3:\"4px\";s:26:\"social_links_boxed_padding\";s:3:\"8px\";s:30:\"social_links_tooltip_placement\";s:3:\"Top\";s:13:\"tabs_bg_color\";s:7:\"#ffffff\";s:19:\"tabs_inactive_color\";s:7:\"#ebeaea\";s:17:\"tabs_border_color\";s:7:\"#ebeaea\";s:18:\"tabs_icon_position\";s:4:\"left\";s:14:\"tabs_icon_size\";s:2:\"13\";s:10:\"tagline_bg\";s:7:\"#f6f6f6\";s:20:\"tagline_border_color\";s:7:\"#f6f6f6\";s:14:\"tagline_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"84px\";}s:20:\"testimonial_bg_color\";s:7:\"#f6f6f6\";s:22:\"testimonial_text_color\";s:7:\"#747474\";s:18:\"testimonials_speed\";s:4:\"4000\";s:19:\"testimonials_random\";s:1:\"0\";s:16:\"title_style_type\";s:4:\"none\";s:18:\"title_border_color\";s:7:\"#e0dede\";s:12:\"title_margin\";a:2:{s:3:\"top\";s:3:\"0px\";s:6:\"bottom\";s:4:\"30px\";}s:14:\"accordion_type\";s:10:\"accordions\";s:20:\"accordion_boxed_mode\";s:1:\"0\";s:21:\"accordion_border_size\";s:1:\"1\";s:22:\"accordian_border_color\";s:7:\"#cccccc\";s:26:\"accordian_background_color\";s:7:\"#ffffff\";s:21:\"accordian_hover_color\";s:7:\"#f9f9f9\";s:22:\"accordion_divider_line\";s:1:\"1\";s:19:\"accordion_icon_size\";s:2:\"13\";s:20:\"accordian_icon_color\";s:7:\"#ffffff\";s:20:\"accordion_icon_boxed\";s:1:\"1\";s:24:\"accordian_inactive_color\";s:7:\"#333333\";s:22:\"accordian_active_color\";s:7:\"#2ba0a3\";s:20:\"accordion_icon_align\";s:4:\"left\";s:21:\"user_login_text_align\";s:6:\"center\";s:32:\"user_login_form_background_color\";s:7:\"#f6f6f6\";s:16:\"visibility_small\";s:3:\"640\";s:17:\"visibility_medium\";s:4:\"1024\";s:22:\"widget_area_title_size\";s:4:\"18px\";s:23:\"widget_area_title_color\";s:7:\"#242930\";s:11:\"scheme_type\";s:0:\"\";s:12:\"color_scheme\";s:5:\"Green\";s:19:\"reset_caches_button\";s:0:\"\";}","yes");
INSERT INTO `a3rfa_options` VALUES("919","wp_installer_settings","eJzs/ftuHNmVJ4z+3Qb8DgHO2EVNM3m/SKxy9WFRUpluqYotUqX2mTOgg5lBMkqZGemMTFF0ow78GDPADDAv8uED5lH8AucVzrruvfYlMpNylV39oXsG3SVmXHbsy7r+1m+Vx/vH/9Ye7+wer02rSdPWs2ZaV+3a5+XxLv6wf7x2PxkN8d878u9BOSvp33QB3FgP1j5vj/ee8qW92V3Vu2+mg8m0atveaD6c1cN6fDsvh73JcH5bj/FqeM64HFX0n9vHa+/OX78qesXlXVW8g1vP8dbitbm1OHe34lgn02Yw78967hn8CBrH8dp8OqQLD4/X7mazSXu8tYUj22ymt/j3XbgaPrS6el89tFejclzeVqNqPLuS+/Z20vu2yn6/mY9nW3hju6XjaOeTSTOdXc3K21bmqD7eNpO3cIB7zzIvummm81G7NWsmdb8Hz6Vf4IU//NAewxRPyv57GK+uUH28f7CzvfMU/nUULAd+fDD3/VEbTTxeEszx6esL+jt8/6Bq+9N6MqsbnvNteDCuTr8ZTYbVrCpkHBvFbdMMChh0UY4fCvvGAqdqo6jH/eF8AH8qymHbhFe8a5rTZjSqpv2qkKncxNfBvNQjeLquyGFuRe4nvX4znsHCbc0nw6YctFu72zv7W9tP6ZresLltdnrbO5uTMS37wfEabK1quvY5LhE8FCdzCrfrH566feX3/+5BOo09+NresL6p/Ckws4p3xLNK88N3ZKcXToCMcDKt+5Xskp1nB3T9Ee6za3fD1exhUuGYD492d/CFu5nfr2bVx9lqw4kfX49vGroTfrgwPxT39eyuGDdF9XFSTx/okqe5V1d/nNcfyiHNrPs2v+sPtjOL+U/lYNCbNb1+OZ39Zudwd3vv2a/L0eTz6/nD1bi5/83OGi8QrFd1DxsJp377+N/4TMwnt9NyUJk/wtBZ1vCplGMJAz7ko5+RTXQ+6mOa0T0RZe1sCr/2ZtNy3A5LXq36eFcmh6Wd/63nRQletieTK0+q++8fYNeM39Nr9kWA0I+4p8blB/z7gSwo/X1UDeoyfvsh3nkgV5TDYa8e4bnBn45EuN03TV+OVfCNeM1T2RMwYx/q2QPshFGbXPSMN2PZvxnRv3do7nZ0WGU97N/Ba+kg3E9ANtGRHTT3YzqHug4/dImhzLF5hDDKnBaYsaNnSw7LzrOlh6VzEF1nZAc++/dVOR0+FPb3n/psHCw9G6SscS8kwkuuwosOYtG1n5EV7npeiz5sud2yH61FZpWewVy++AjieVA8NPNpkTxYNGpx/QCqowGrYVo8wFRuFCCEP9SkMVC+1+N5M29VPcClg0LP+2ZmG+w9+6QZPYpn9IdUtLABtLtAIfTk8t7NtBnpVj+KTYHdBRJZv63AJ9gzsPK87+zAx1+UH6pi1IyrB5qwu7JthxXOND8e53bWFCW9claPKl2MzeL3zRwE/XAI696v6g9uQC09SFcBh0s2G/xH9aGaJiuB6mvncBX19dil2t9JNz++w9kZV6SfqgFL8x/+Qxv8XLTBDz+ItXqYWqtH0am6BustNlePonPzlVyTOQQHYq5el23d550Ku7SFX43BGpii+ML252N8kqzpmJWc9nzE3OTV5+5S9fl0ufrsHMXPTH/ur6g/Y+Mf53+hAo2NbZyAT9egRws0KD35p1GhOwefNKmHK6hQ3rd7K6tQ3fCJDt1bWYfak7C6Ej2AA/rWPmbmpEm6DKBK8eebOajNZFSvVMWKx4xXq26F9cNAB6piuLW5IUn1WQuaezAfisq9mY9pwOUQBPRCfXv40+jb7cfpW3hDzuxcaVn3cgboj7CaGGj5cVbzx1jE3Jk72F7Fe3n0mXz6V9pKh480lRbaKrvdtsreCrbKfmSGHHyqFZL5hcR9aiYu/264bjtWAjsSz8x5khh6hHesrTCl2a38dPtQng7zdF2PYX8FZowYJUU5n901aK5y1GbS3FdT2NGFWZLCG6ibxdmMr2nhCVNYlXJWUfyOt28NyqPGwF9RjZv57R2JWjzEt3DH5i9/8cVg+OUvf1H8wxeD2ZeX8+m4NVFcO7wvtuACvnDw5QuQYw9FNaQRFPXY3HNdwddFn7ZZXN7BOHjrojS9rVpQdE07g/+D8deNog+jvqX4Nfz3vJ3hQYcDxN8AYnNc0OYaz9pNGMnADfm7ejrDyRuW+CY43QM4E32OhNO9+gO+Hn68uanQdCsGDWy7cRt8FfpP/RKvaifD8sFOON399s0r1MT9u6Jsiy+q0ZfVxxJndhOGtlW1W19swd82kl9upvxLARNfj10YFuymZDgbeA1IkZ779wTsAv2E8MtPmzFMS413252Bu2jaDMMve3cHEwiGSPGhru5JRA5rmHyUeLQYNFOyHnDZZyAM26oq7u/KGUjDcjityoGfj2pA1+OvBZgu7HjixIEMCyfNCWx8XY9eDh94f1fjdhzUM7VycB/Lx8H/GX4ptnz/Dr68ErWxu320D0fwi7v9L/c2n27uf7EF//XF3d6XL+uPFXwu/NcvfwH3z2k/w/98MazxN/jCKRzvGR8QNLlgzHCAZiBz4PWw0v3qrhkO/O+wSPeTwfXxMRxvtPS/2IIn+We+qdpm+KHCo9XOaV/NyPqHv4Axx2PGZ1xXd+CZofUH0wyi4Kr943D9SXha9uFL9qLn4/eAldfiboY77ydXgwblffl9+bGAFRZviFbPP4m+AOYalmF/8yj7yHIwgpezK9zSLFxXFNwfDOBX0Z26fuU1rJFcuwFLBhtoUN2A1IIr76YkSfByOav/SlJtfFPfzqe09tkBwCtBbbb0gPtxPBPPcPrwmSQjYffPQNGUEr7+UzkdZJ9Ji4DfPSvu4VjCaCYTipHAg05gP34ND0FhdT2fzeBJtCPvm+l7vAZF4TfVx6/h2+Sy6BX4gLtqOKErX4z7DUgvkgK4/1+pyLkECYYLg698Abva/dLS6Uq2z6j5QJMxBn8EfCLQ4TC1E/AVqnH/AVf17Rh3I0jzavN7kjzkf7LhQnuvOAUhAlNzXZNlyRtxwfSQIrmA3Qgf3VazGW0AeO7apR7pAh1B+pvskv60qkCb0hfw8sPWGqBAR+tpDlsQhtFcfw/CNv9mXmxd6/IGDqDKPl2fm3raznIrTfP7zbffnL64ujh5dYlbC67Bo8n7VnZi18GsPvYrk/e4nzb4wgrejV8qm34yGda87dtJ1a9vwKA85c18DoKwuETtk/2w6zlM3rRiQQi3cxCB9tMQdwLuFTkWTvlED/qmGcPU9O+q/nueW5IaNCwSwyB09dZlq3oH2hbDHTCZQ5ziaTUDLU7WA302/kSv+IyGDKv2GZq3FRkGoMH7MzePX2yB7FT5ureqfIXh3IC4GBbVdApf3vRhc5D1wks+nwxKWvASt3ENHwmX4jdu5mUUKBIWzOYb3Um7gH/20VWmLwLX3Kh3ENQFehQfcF3ih//XC9yzcFb+W/EdGPIDp8RALpcTkmlV8aEcwhvLtq1vx14g4uegktU3bcA9uGFgyz7wOFA7smD5+sUlKrjzby8uCzzbFWjUzeJ0irqO9sUM7aDbpiKf43fN/H1TnD+MQRTAY9bVKXg/rN+/rzdv6ifwfDzzaGrLGGHm2hpFM1j/w6Z2sxis3S6vHUhv2AG6fvKvrjVsYR/h8KaDHug8ECpiTxe6uVkGsajZoLDFDI/UTALSeBlL7usKPV3KKXNcg5+UXW6yDZrbuo/75yOZ03Rs72qwsgagtPsolG7008HSndIC01GDDVANaCavQVU9jPsgasb1nxK5cEL67a5p3tPFFcdlrLLDdzYTZ+jRT9V0RDZKToabwevWJN3Q8Ei/aab31W0NO979DO9dGzdrxTptaJBfYB7Dl8N3VyiR+ffrq2++XXvScS7sIeNtNx/TOadJx2Xfph1N/7wgxV1cmu/b3Tzc3Ime/XbCJwEHDWMqzaBwt7YYrzDGdSsLA85GVYxgK7AgJ9Me488ykVNQFfxMFkGwu7vOeqrG+MTfVrMrXIEr2GdoJpyjpbRMFK6dDL4HuVucPW/TIHHgxq+huj753cm/ulOaO0Y7jzpGTvuUYIiwBO6X85atwgWfCt/2smzBXZsVpyD6qgLsoVE9H+WPTZeOe1cPbnEb1bMhLRPsjwsx9OwmEP1JcnKpaoGND9Ka34EPfM5OSeCT5FVkXiHQQ08fpnuvylnXZ51eXJAhOaz7M74B99F8AtOHjxDbl01fD0DZQ5G3xPqpyilsXZAwsCt4FryqRFssMHxXswTM4yuMYqBGBU1BqsBbtmxQsZ/FtkcrXrM/IpG2D7bhdrgNqxJGvXAnnldTOo1oY4DrPwVzkzxnXkWOeeEwEA12XbbxPmBxiWOjU2imBRyR/pwedYXxMrE4OHrW3KNZUd88qHEXzCfJbnHob9hMkVQmXLmG/+g14yGcy0VOBA8sPkr9IWhsOu9fN80tvAt9kYsadFM5afOHyH+hPRsvQZtcl2CRcfSvw2w3lrocX3jdOYr4r+Y1+mAbGB2gcwYzUk1vcZ+MYY5SkZwd1e+bkuw/MZ9Z4JYtqC6QJdOWDU4Oh8IH1GBs/Pa8+E6OxTqoyhrvnjUNeoSxLtEZ9Ct3De7ve/TO2a8hG59FFq3MyTWcyzno21eU72RdXayj4q0G6hWWQ3e67aGEaZqA4zprn+RNPZr/+9ofahjO/3dnc28XFBnuqQ9NPciJzZZfBZ8XuMIwD9mvtXnvM3Y1qilMEZrc42q4wZtXrBiNLHLojK+GQzsrQ68b15yumOHxxr0bC4j03WxXso1vzQK0k+5Jem8Ert6wHoHxQZpZ4lEYDKAL0dsE49O6Ll3yOBwH3OEd9uhKihHp8eNhwufDJix+ewmfS34g7OyymDYNG0UbPBEEOfggVjWbA+JjqinYsudZx1L/uXxYPf5Qz/gQ4kzBxunxZp+CFQVizp4WEo0o8+A/V9TMb9uKLflhVY5dmJWk9AuwW4bo0tHRVXMeX1rRHNBX668SDUk3czEAHxBs2Jl4cLSyGJGo8dSqmJN32Ud2mEXX0+Y9DEROKWwKFMR4H5hD8H9nd+tPnO3w5W8y8Z7nFbjvINmL8Xx0XVEACswcionSJ3KEhbWgLnliNgc6Du+iQfMnvju/+pc5hlVYRZcfm3EzenA4E9J7PPzWxN+yL/CGu5iPNyA2x3M5CPRijGYjEAYk87TiGNfuEgsEZgwjGi7ahcEO+uovi0sdrRHFazkr/xzzdej5iQckHtFWd+R/C/669b25AuM3LggK/zGe9aqxCE6cfBakS9674H0a1Gi3dDp6rfjI8Kfqtuw/9AbTZoJybYuzETikxe93xpjTQXD1bPqgMrIiFHHpl518JdZUsqnEpbmuTNA4c26c/4UmEGgYeOSU5BvGyVlQ3dTVcCAjRm+SAhd+H4BvIX47u9fgl6C0fl/FoTzeFvQS3AsqE0457xAE+wu2WUgUlW2N4tjslOi5Z2M+aok72Lyvq4KnHL3WZkrGSsnygK0+3pzBq+vQL8l+BCcH1ICUXckxIHFycO4pwh1EMOQ+UPR5uTO2Bm2Jw6K9VsDY2jsNcMJGpDh+11PQHFH/h0NboEJVBN5PrtDWuGJjWEeb2Rg4SbAEf5w3s8qOSmQoOad3oNHI6y5nMI/XYKXEosCHWv0+LoPpJsVsVg1MAgqLO0Mg2bav0ZIltw4TVxQwnc8ah62vx5P5jGJRorXJ/MPMHKal/JvAOoxPfemtcjQ57iuUfJiAQLUqCSEasE8bmazXYPzZjALbCCABD22YPwBRHAHnFFfsaHMHlNjUhRNsTPYxvjvOMNxbTVUV4myFAhDkX/aJGk+4bgZi1FcUVXfmBo9WxALrWJF+i7cznAWYkHES8NGdTI8N04Qy2ajOLi6+BYMEBUIqJnl3UegQvqqZbt3Xo1uXgXzwHw5Ow7DBraAYBHQR0E4nO06saVpakPzDZkJp1cl8CtO31EtX2wBU/RWJt0hc9zFPOCX7PkiIcgB4hkNxGrrTTm8reMyghG/CeDM9KxIPHKW5ePEtqSvwvTqf1VeRKxfygFkuGusynxUbVx8nFLMuMKiKE+1CIJxNGOIMsre9ROGAofH87LszVWN1hyXBQo+jjmgQIxorMlnYSGnm6PXUrQ/m0/qvyc1rFOObzK9BAt7FWsS/Cmy/+5YcZPN5ovzMMthVRBmU5JLTSMLRigGtLo3wXd0SGgLOPWxLdKHYG8HhTV2ukIODakPjR92D7NXReKsPrp5g4P3iu69Zkhp7HL0zFOzXw6b/nr5vVI7x3QEEAq7IfeTScAl/5T9ofs/6aCyuKJJZYLio/lC5gLCbcTWw5OX0oFPK+vrsNzwLlc4NOQUwWAoP6ZNhH6BLZe9/7SSJM6riTcauN8eWTkFEw1NQVNun+LgGA1TxP0cVBhPKUaX5jEF1Pb+1AdvgCRTIQceSUkMstV1WywtJGgYI0J7mhFGtp0OBDbTGscatesz/sWbcGhoeYw9csgHMBf1izkHSaBDBUt88yLDiQfO7QA33QAxWU+dHXMBTVRz6c38J1qr6ZTlfIHU0u11Ns5cSwYwDKtDn7+EBtZIXA6hijOFA0QGVU69RBvt5/GBywmUrrp3Ej6b/buYzCRLR8mDoQjQZyp4GXIdJ+twS7QXQbiP10tEcesBH0cSdfKjL4hX/QQJcxXPeQW2kF5NZcMlkHJSRWOPia1jY99FtGI4FD/WDiGY6ijVFotCyxZR0Ivy6XuwDc5E9zo4FRtkHMPgPNawiY4qKd6yDKMNFHgwhpNB223D3UqADU01wvDH6hW/53QXNPyePMCXYMSbjeH+mUcnihkEbNUZV2ofRdTPESA7ocPuQN9VN2ec3tvPxtG6rzcndpPAmvloroJzY7OJkyP39/Vo6GJc/hIEbG/AOvBwUeA89FDu9ETibCDj6PrMRrf14insMI5JjlQPOAwFTHy0TTo5fgS5bf1KkD6NzSRgms3JR8twJXGfvkV1IvjCaEOlTwYwHuYk5RatFbfAwQoWFkLHYBKEnv/hI4LVBEOLEq7/m+oviJRZgeJOPz0agsTCbKIqhHzz77HbMDm3FjqmxIMkmlMScjHnNhdecXeBt5EFTtegJVB8xpqupQhYe9APcm07YFE3ZkhCwap1hEDnCv13Ph++LMhG/Yr7rchTeCKUjiHEbP91occ4naHQGZop50P8HY/eUOTk+vsLdeMX74YoiAbjbOEgNj5rWqCzQI4Y9mcmEHyqKYYnFY95OafDbIW048bYkfJLux8zhMGN3KcySspJX9YABPLNSpDiDZ/Dv9Y34AJsFDdH5Qu9OC6ksKT6U8LWzvG6QRNs4jjCxjhOHrngNLkKLOCg+AvXYOa2wKPOMaqBATomGicMMsQudi2T7Q4rFaRTBkzgCGR+kp+BQoF1nNOH6b6vraXW/UZzeISC22ig2NzefpEOhZcnmAqxd4geBJiN+bkbiYIYUPmtczwLz/esKM2bF+qB6/uIJHezncA04NuuD8vnJkwhoguE4kFoZ+VrO7iSxyGkU3AaE0aFfxEE2xrwfPNV20IrlnNH0VbmEPU5TCY4AeUhxhNTeG4SQJCT+KSEkNsAES8WrRKZwyw4hwQJJex4XCPa+mlbopUzpVU6fgkyAF5JVi5NwVfeHV/LGKzc94dXgNsOpUYXtlHVOtHkNQMIZfVcth09Qw5RUcVfEktdcts74MVEnXv7SUcpsYKs1baCFri/WwVeaFLtPSBLgo1RLs/8+JlMc7X0rk2M7VaXcyfnZIgvVmFm3DHoEUU9Vc5qbdf5rAAvJ2FxseAc5EkE0cr5ZzAjams/rDzUb/FmjZMaIOpRvdzXjLSnvrqYSu9hsoRJQudP2I2c0UF0ITUY/dVC3Mpmau1QMcukyOJyqXvzwkmN+vcEU5qvg/11rbt/BxyhXli5Xahjit1rbl9QCxdTFtTfbT318in2T5uc4sZGoBpkoNpgoGnpiZmua0J0B6z3w/qQTxpqXTg8juvCvC6x+SQsSktNEPA3qmg0F/YmOZkVBJAo7Lng0jYe9Ci8ZwoAXBbXsryYvgUtHbmjoHnQdpQVgCxocPQQT/S3ssS5d5K1WEbdSdSrmf2AIeih5SfBG8mfBKfDB7vw7SLbqn69yEYrnEtDm1VVNw1XLlAHc/DgachDExA5E4X8o6yGas13zFMCRuyZL46UnH8pBGUgNwtBXt+y4b9pRu1RUNw7gs8t7GO5DcUFJs6oa/8HEFQKA3w2SFMEP30467Kgk0fBZG0o3fCQuSyZxg6H3m6GL6uefKmkN9tZFqH3L552xX96pVuNt7/I0OyG/i3FSJ6cvi/NpsyH6n27+/cXZu99/LTm0rsVTaGy4bu5HhgC2chE8K7Ghs3rHxkyGnPzNb4tfD9s/Xn+OGxEB7729Zzt7v57inwpWL7S1nXi+khNxJUuAcQG0OtAIYmlPRjZVdWDYHfQ1SUM0KboeknMcFkNozfBfJWfRGctoKKJwEMQV5RRRho4a2MY5q8wtKGzVDOYZV5ncrAmlxjCfPzDRa66n8M4pJp8wajAGrXm7SAWJWtOptLkfrM+CbZkZTOm9FOfzZsLT5AgEkdJhVU6tkesnrt8MG5AF+GiU1U4ZmbSjfdIFDpasfI45k3xXSUVuCKninJMSytx8eBe0bQl2JU8AukFaQoLjA1OCT6lYTLBqVFGCYYaZMy8VX1+0wyawKb4xsWFWGzZAGQtHtF9wH11TUhFnPRdz6wSYSs5UU89r7zg7e1ycvXr14uuTV8XF5Zuzb74uvn358uLFZfHZq5Nvvn578vWLq9Nvn7/4bC2SPhyJ4niXgIQ5GKG2lPdn2khRZ+WYGSjHLsnrnJWkzZ1dD2doCjaxi3UZ9zYpogvwqfadb3VDmcgBCE1C6uBZFdDCZ/1m8vAZCHQMlxCEt0XM+BRzU/dOiT//6hFLQKA+So6hBvlqPhg8MDZUFwUD5W/H8K/bu5mH9ibxuzZAtBITSXFXlaSaJhM5WDLAd2x/mZk6vYOD2h00JSHgZKTUA/LRumPDmwJU3xDong4nhqIoI5ZdWZt1n0hyu6ToQdOvqRIFZn3KuDaDDyU/h9FF9rEKinnhcc8a/aKArvHNFNg0reg7OORW3IP6im0YlfarJcaCuKVam+hYcMZ9Rl+CUGIx4Y1hDZY4eL1o9IL06AzDWScx3Q3FX/7838/GBLQ7md4SDtdNxl/+/D8CY0+cts5IqhY7qIqqMRwiR4JFGstzdE6D4rsOnSfxFpx6hR+gzXpvc5ecH/VG/43Adfi2jG/T4XpmEIBvQRovtD2fq7zG514YYV5n4npGg4fS3QEYg82zvfrmURM4lxa5YV+D1DBVb7v6DlMjeUTVFfXtnRijUlKN6AkxnyVPyDW2njLq3bkUYbvXtLLwbHizw+hfVc9Aed0EtjgmnTBj2KfKJ4eUJWO7DbN4pv4RE7iEsmG3y/20mW5/H0JW5O2ioon9zcN/FMGmeZFcdmuJTDbhodyQwgz4wvx8HLrjwFB1S3khE74t1qvN200wmnqnJ0+CV35rkhpsdlCwjWYkMipBYQ05vQ6eOqHhJKiExeN6w3ySnRHcIOM0M+I3XpQh8QBRH7bPPjh95Dfwpo+objGvGT531cfavNCw0WoNjZIQ9I83GIjYPxIklX/KPCrADCX5dawy098EGkNgR5JBkVNK7sWguBg3YCpIBYLbIaC9fjubTfjPj9uTFK0h0bz+Ga7FfDr87Ennwgh6p3PqMDpx9RWcwGo8uHrDgSLOS2Ap+ZWEjihskLn7r0zDBPKOI1XobfXVFacQ7gtwhzHGjl8Rx1o54ucWiYUYqYvNfGjIlY4HcL/BwIUM2VFREFr3XqOqBoPo5pvJTLxD1aFMFIJw9SbTgkeiNBbjnUvuUQFoPTyjKTjQSa/BgDzndLnSFEOyU1+aiCmMxUdFjXJB8CPfh6nknghwaEI5D/gUlOeE6s19QifQjyWeVN1gCczFBGzD4rJphjTWkwkZZlhkj3JgM2POUSpijv5aOYLRtFSSi0kiMWRT3fz2zatFKzc1FoYtSlSzi9JZPAnevFVLEbEOhL5FFRe85TLrIcIANfhUf8TQ02coipqZ+Mf9OXryN4960Mv6Jn0QFuRyvfFdPRggEp/Lc9p6UF2X0+AFZ+LF90v0W9YVTrQhtDIbBVVpKN8H2dwO6vRko8MVVjsSM7sEix5NZiFkWp12h3oNTQdKgcIMY2qF6DU4Bgr6QpJlLMJtbUKcKc6sumMkAHlCKESFWaAHRwWYFkO+GduPK1uPDt1F9irnNNrZw5DEzgWIKFg2FIovA6qoDETJIaPLawTUqDRgGxi0jwyfZCMi2y3Kz+hLTSDCLZ0ftSx0/aYaVFronl3zdQx0spx6e7ZBYc+T87Mnm6kJfLC5px5U7CdNbCmicV0vvuUvzUGigm/Nvy5+mTPvx+xXOjgVVyVpqIICTMUErPkwBKRl0OZy2FF/oMhj3V7Rn6/uqo9X9IA/BDlSLn0EU55uoSPBAfQ/0CH7w/T2+g8S2cp9isQZJ19+ca2uw/WXX2xNzHIVcR7cAooUNkuGI1t+QQmlK73regguh0xXzxhwufsWFTEbH+XwH8ObX4xb2rWcaWYcfOwMUqGUSuYWtHMcXv++uSZ9GwK4m48P4bu+pfQUwtMoTh2dDp5mUx7bOdtwOigLg2NOa6i08oI0CCIftVSszY1m0lGOmx2cP7b5gb1tbUSQTflcbEylqJEaiNNqK+uc+TO3XhN0sOUqjXoM3t0mft5rkXb31XV6+nXMRn7mB33GX02kRrJ3xPu3dlCxhshMD0WLLfS13OT6J9qpzZ20HZVR+u/gX9vmX/v+WgeI1g1RqhNMNgJtybPTcvyKcauV+DpUczBmqXYHWz0jxfaDAezrANwL3ZyhymQMf+t8Td55GDamLHGQ7SYT1UdTkLKu9TEVpWAxgGytwsSf76bVDW4QrqIi3jXLvnFHWj54H5U7DxvKfHNNQ1r7ZcNu0QszoSnBdlB11vml8cW6n/gvcjBj55jLFjMeewJeJSkHp1QKeIbldTVUqI/Es9D6qZQWpp7ylR7n8qWnfTLPdL6iaoj//NvLy/OrNyfvrpAl5ur5yeXJH1iG/mFyNzne2qLH/iEBzLuJIubpgvq9aMEYhX5JvvS+FJgXqrs3l6+iCHzmYOwhr0aquukJx8Wly12TxegIIczwbMpJsQeSJHTXiPkjJxVBLcySRgEVpkmbqkj4y5//J4a0W/JL//Ln/8VbkUoEwOz17LhokBCni3nPV/OPwavtZx6Z47a3eUj/oogYDJpqZb3TJTlPp0Y2uByB6ofRJB0PuoU6yr6LSgqOlb9uc4RzMnRuaoD/3XCli8RbSsX4CMRkHNWmjviARuxZRjTGoqViAraasnGPhKfflB82FEoE27dy5PEh5wSTis1Z68vL9hPxJ6812WpH0hTud7mQmUIRJkNldFMCLSeXi0EiE25tEueHpZeTuZyEbxKjiIoHWx+aRvs6N9JWuSLs69+dY7aGHHMKFCaDsBcvTkEJK09hI5uS1MJwnU9cmHewcoOj20yZbyzZ1kiJeHS8JmpBaGmJGFG4Sik/Izzdu9s7R70dJDUvdnaOt3eOd/ZCnuj9gxwnrcZ4f3O4/fTpr+VVv3EvwW4FN9Oq6jXj3v2EOjQ5QnTkFXGsqkvZUp8y1+O4Mgze8AlIvOC4umM+yJ2dp7tKB/lsc7t3rbY0UpY5KyrLWuZ16xmdvYTtZUMLQxQSfhoUI6O7buxQwZOgPg55Y4Vp4ILSKGQfyhjEjvElxBLEx32qpY9SroNHiE9QlgiwGxdTX3JgHv3T6IUsjm+U74RqU5rbW/Gkb8qaMttM7yVHamDgQxzNGzWxr0EirlVpFiUFEj91CbPcbzm6GBgl6yhy4fsvy9snaG7M7hsQazOh9hxQlwyJI0ZffIG0kGK+2c8ATfPhoSAe4iv+liswfquPazT03N/vJxKhTYuN88xM/BAKtaHqXnMZmJCCyFanEmJgfhu9IEM6popDuRYb1I+0MHGxqy529Mx3pAnUMqIH+CghHgcX1W4Rxa1Q7q1faZnAr7Z+hdfhD78q3EeuOjfEm1OLnfbbRkBbX7loJdmy7u0tl3MRAxms/vW0KiktF54BnvQa1mxMeRBwjoZ4Itdwb/+umk3SWcjleujrGdtJ5UB161CjpNU4kkjGKlfQgAk2u67K2WIh/QyFtIgr+VUkn9Jsd4juXRDdh8fbu/DHSHTnOtF1im73auLSXtgfJcePvScM1imZUcyQvejJWXrsowNk91UsGUZV2gAV4whKaWujfGG+HEMxKIzXkgpwIYkTtIE3I2zapBxzDO83axSdOcZT8Pkam4RYkTUWZh95NvFsC7qZ3WRUcUT23EEZzqTPKKvn9HZ4I70bQ8AZfj4tDZeUbhsUpkocHz9v8ACrAf9N88HmJv/IE1QSXGM66HGlBVFP4Wixyp+jLpvITzjCcDKFex/oFiN62HraHDUszzd8ychs4cjlaRibCHg/CnA574QFAB/TsT74Jc/tt5GThkTjszsWkEqoU017CDZC922T+k6icYH1SuUtzH8lq6cU3AXbUsG00Sc3NzMk2Wnmfs8wcNTlWteH9Xt+ukTjn+gGk/22SZge3XzKbz5C9HTwPjHxmZwPH4E+TY/SZTmq653tvUOhut5duYhJhRmWEP3onNcSzZVKUS+7v1KMGqVeNsiHu6d63XpYTrWwBHnNNaSNktvsDZl4V7iUfa+m+Bw4OmGO5u0Zgn3fcpG6ETPZh7ORza8QwkbJpQtzAgdYL5FNSFkWm/C0w3eBeFg0PC77GWhGkSFn+jiMqlxXXN+QsEyc4SYecapMqXFtMQTNHruWNw1+tju4tOdqNXWNw5qdBq0HxQASmEpjV0gafIkwgSPcfVw7Bhu2iNnk+7W0ew1rudNX5jDUbcMzYwNVwu5DfrpUVXFwCB1dsqKCcNSC/cO7VtiVMZPFuDHPg16PPzhuYOGKIZegVrhbfneK8RXCnUbVFRUFMVsbbKMpZ+4Y/EGMoAwD5oufxBGL3RUxyEVH/teQvN9KLphbdlRSyOG3iQ65nspc0xFVowuFv6sR+zgT9Kv4u0FAtpOa9Pz5te4tfhdIiBomg6BEEXMp1a36if6HwPDF/SXbhqQWVw4Iqp+3XfEqZRAIHhbyNVH2phroU1sM4YpIUnZM8DoI34wfTzzH41v87yeZIToUneYnhPWpHufUJjXiIO8lZ8ESFXMRUjGXY52G3HZ5HF1tsmWCIDImVM0WCsClNuCX41lx+wBNjmDdHWhS6UFk8dljxYwoHUDTEiJ4MJZGl6ZkHGt9ZlQ4jcvCED00lBy28PW3XlLZkHHnHIQdEpzAcbiARZytnQ+9SAWdpRjUtwlX4mngUROMQMp0E5r23RR8+FeQw+J2lKGeS6PqOGxAqc5l9Ige8elSBoQbJl8qAgw7Ui3mSU24VDVQSlZsh+MRe/pYHgrSBwzc4uLS23LwAPncBaqwc3LqkEJEE8Dxd0geGl/8BdrfXwoN4Rdb9C/hIIeHKfCpYw/9VqFVMnhhP3aFFgmJ5yewYp5lLINWT86//Ztx3n74wdef5T3nbGJYA9OWIIH9+6rEHNlXjnSzpm8dC7dklPbNxq5Idvt0Aifh72ajoWNlW4EeTiHlIGQZRqq3YGkLfpdCOOfGlu0MyjjiHsodZfrg0P7t5fknLbG6CFysqF4kWuI617BuRk0YHzzhg+M1PFm6NWtjH8DWnk6zDOm1hA2F1pNaovDVzTS3rm2jdGaaso76AwUermxpJbglJ4m7sEWjuKQCfmThZcMhrU1y9nTAQgV2Yj1KnpZlxYsZg1SyBSW9EX1eKpwPNIuyAt8WVkWhpplPhL4pI1cZjJ6cD87yRyrChDxdxRgTsVf2mNPOCF7G6E7Rc3aDviDykiQNkow23PfVjLh2UIGCsOq9OT/NPqFT3EiQNNWWLh5xW3NzMLZOsdajHKV0Yz62xxBByaHWY21fgY+iACTHP/EwfAbHUHFrLglsFUEzzthhB7G7vpiAjASXM1KQ+1aXS0PoyHbQz5Td6zlUp6lUZUmUlhzJwEMnzkeV2VhulpUTGSNNGnI1Tnoo+j6NGMvbTVEFkW+TZUuVGjC8prCFx5l6JVDtlAgYFGAyYrb+RqmILpvipK9p8YivrgMPnk6GQxW2DZcdYgNWe+hK3hxDio+rkHX+qvcWM4hF0ltY9HT1vnq4ImenXX9SMKmhIWIsdgXwQBdvFGPMDPNWdxjCgO9Fizf79bQ/H2GzpH6uwpQPwYQVn4YPsjS0MIgbrKEl1YW+LV4yn/gPpuoVbPRRIuki1lIEiMVJWWem3CI2Uz5BPpZIz/sVVeesbRRrknn7LWevJS+jvFO82GtFv/J54mz1BvN6jxpmOMP2diJHmCmNEbZ9r+c/zjg/y4eMJJgrPg0O+2qtdqIdwHUKrPIp3c/Yz4zUfe36PII/2t5dN1EllvD/fEQ1Ku7ZRP16U8oXSE2v7OVTo/I9huxrlooZAWw5Kkkb3uJtLCkm+TMxyYZRHo1Z/XrazCfmc4x+VwdSV2+rgwZz1yO/lkuuN2WtgQJOvBI/1tDQGY+GYYMMPBRXGNy9klRx3CND8NH2vDE4aMo4lyYfD83Y9500L0hqySxd0osMbQs5vfMxmX2aa3D7Aj+E+OOkJP5KrriyDPzc9ZHK8alY4Iqf5q4N+fGDKX9EjVzu6GYiB6WKLdrT22iboeZfVMNFZEpUbGAtCljTIJgrZmUUg8g9zzUdNBHTiIqkX45jBz/qgcfVldohVcItEpWS2q7MGFxwqqsfFPJTLRw8h6RHKjiGSLxebKrwWFoK9/zFy5O3ry4p/IbnTbd7kw1mvX64+JdXxcHmUQYUD5sA1wRUTMO0vBw6fFNxVQb60s+/EnoMOmRC8dCD78UfpRtKZsSfnfITzr+lj/os6scN6r2e+XQbBSlG7W1/9nG2phqD2zNmni09Bbm5zbS6qT/qLVp6o7RrrqQvgeovoM4ITjOaPLhz4CoXQZAm0Hwcwa/Sc2uU+IL3hRDonBCxkF0u1mVk62ctQU8wj9hGuQAxWBufjeXMJe3+sEbFhR4I0GhYaUagfUA1Yr/H+Wiiltyl0NjiFRzm/SyiisUHLfjeZYol6ZLiZLOxC/Uca0+vQCsmCN/dzf3N3bQs4tym0LLdchTak9Hz6Gra4rbvwChpGbdN4ckUnxmMZtVSA7c83IBP02nYH4iJ7zXuSlT1GJ7rD3X/zafDCATvmIDlYGNRJRfCkSEWVcJRj2SByG1pJEMcG10A3XGrQ/91CiwGfDeAYO96CPaqHo3mVSxqR1QSyVaYFDJ6+oz3Y4gNuJDsx+PPqoZk8nJnZCSBbhB0Jk4X9KBkIY7dUSUm5HJjWOtLWFJjKOXO4z9X1QQ/o/+eegyRXaqTTRAcNsyZjI57lI8J5MtoJP0x9RgLt2o5r9nMJZhuvNTcE1X5Z+2FESSSV5nz8R3I/yUSwCzoN9V9cd18NFhumG9qFckZfTWUxV1A/I81jDaLU2YrxNU1zgWtgb+Y5t9D1DI7dG/zmdmRITTbnyWpfdZssPIPj6gG15GEdW7PFJgdkweQfkXAOjmoPuwSMcLeMOCDLsp9i0dc588U/Zw5WGHFPcYu8cAT2qqoSmyHRoRKyoAOqyW5P5cfy+Werb/kjaZIe21lVFdB8wLPu2taJqqk+pgcNTIZ+2JUJtVLUts0FHKutZdTQ82xFm7cLxZFkNJ5O6HazuK6bmAhJ3eUVyU8gLA8BL34smcyt36aUuxAyTeUHf65QOR3HUQ+g1p/DBi99OybZiNiFc60Qg4ZmDjthx4V2bR35dTCFXmScSPNr0OmsS5xllsFDiL3Cns2tM7C8cybzyKuG2lw7huQSsRGktkac3niWFhKPPeuzfbV1fOzN1dXhWneCbsYzQ/fBs/3m8f6Tx3tXjDaoJczH6p35y+QXJTjR63etjiM0isskQCZ3o5fZu2cCZJbWQRD5BSg0DYUycB4N9+9FnEPFp2oyodfKxuInIOXPkdwXJwS6cNnxLHw7vz5V1cEN6LZJ0iZe47rksi9qdU16J2iBeWY6nuYq5whxa30ZpWJ4RP4XwpnkzEBALdzYM0f0cImrDWwcmtvuNWNcvMSASTHX3/5i+jhjIq5L6eUcrTJQbftuXzLeeCM79O+nt6zBu9qnfWIjzK28nzX4IgfIcHsJ/LZRgnuSqkO7YljEBy8II7ErB5fUYz0cVFUFEHWCYIHS3iuaRi/hw5r0DNPY56fCa0Za3/LxineO4ZBtbwxIr3Rt2SMP1a6iB+Lik7NQH75i7M0he2xGnYXuEtDOczgIMRRB9fuFKfMaQH/dzgsJ22VLS8hMOLy8pL9453dR5aXPNt1GGX3kpXLSxZDjT+ltmTv8EDhl0dxacmCmoVTDxhkrJSDCwatqO1v4LrjcWQUM3k+sqQcG8JrlmPpuamxxH9p98JSaqXy/eQq8s8kbEG72tUsYgDtuW2EMLUUPcswLr6Wl6F0nrGCpfQi4Ew3Ut7N/qcg5feOt7cfiZQPduFRiJQ/kk1mdldv5KLzebT8kaDl8xH9GDG/7A1Z1PzO3va2h81fdqcPNOR7Vw0nxC0WZWpJkGEM0OM9iXTo54Kb/2IgAYrB7Ev9RKxxbRDVBX/j3wZfIm0Rb0XGHBC5CHxSPUZeUv9xTDbJ8Hj3uHaz8M/m+wm4jHBz32tXnVsX/3Wc35xIHoWMnhSJg5Hp6E/xcApjknUS8LHTZhh8zQl/CEkKl+WnlC7pc/LWSwS0lkNsov1gvT2K1uMQx5RvDdDRU1H/hJ9nzD4CcPynhUwLttOwmS2lWO5T08FbangafKrdi6DDyNw2X/cCnTmDp7gjgAVdSKSQAglC7ylcmAFxc+J3MfaveS/8Mdxda9BsoPGBuXtYn3rma9LC4V3Ug6p3/dC7oPR40qklGOu7CBSyUTw0c5g02M+NCECX7oqZp91KsJIZbBa/h3v73IwYrJGaQwdo4grL+rgqHM8WPRr1wwa3eiKYizOgJIuKv1CXF9wX0So44j7psWq9PvOF3RMM7gScHeasocywlMJrjsT0gS4DkkDeZD5CRBFOIkcgfZcGjMJldt0Rw5AsmcCoQ4mOu+HyEFDvlX42/B/WKLFef3p0eKiKfd+ZmYuV+ifA43PkYdNmfnu3KL/7PMrvBlh5wXh43F9UeYmCV5pw1GDIDWqYJxdq5EqBZSr8X1+dvXwpqWOPiS9nM26XhdEwbGKH5fGhgPD4XmZ5QyMcrV6J96ZUC5mg9EprQEU9avOMSnZx7Wz+DsMsCG3zrW3mE7KPPmAGRlNuKawp36A+5GEO85EGC8oIgny/gZknPsUikWxM+tNR/nTgmRmhYlD8BHfAfIxHsSYnOaTDsq3PQ3L4uKY5hHtJUKrtJIy3wzwpbpAiPyKMTz/80dBlD/20I32pZcwMF0ys5ZGkMlCbVOP+g+kOZ6HGxGMi4bIRw5HJOFgKOD4nRgraLtyOxkFnMF7OGUiitUMbonQ4x7DxAtexRWcaT1TdclQMV5Tfif/jMF1k67sgrcKFDZ8gs8RQbHMzKD7/BMSwngqPv/IyQ0JRjsQPo7FduFt9DvraYDRUYLa4uLPv0eLxK62cKQ7tJNZJx9MxWvUNJ8u0ui+2Rvh0+KgtJfXITO5ACi/CUhrkk4Yf6nGYJPyMNWGHtAmpZmOQ5yjsCSTi7bqiEB+OoRTI+X9SsHlnn2+bR0TFpGVLCsFGZpU4ep19EpsTjdQHjUbzsfY7xQpupxPwH6gFiDRQYvSOcECZ9BfPiUWsEfkBGqshFBYNPZLHxvZu4o7GX2GdCIoD1dBShwPWRDVF0y2He17IfubK0dnHwRHsEoiSDJ6yP5sbQyjahd1YcguS5p7DMY82QapQHU4nCyrUuJAgBjjbRY9fR6RqDoiSa/wShiZXQTe7kIUdhAsMcJ8nVDhcbucZCEhIU5yUexdKCDWAOZ91QZU3dNNUQpPdSiL7M3agP9uA/0JH9jO2q1GPbqAIgP3Q50oEjdqIuanY6HYGrhYfOVCiv393Jko0SSUMkZYNHRmQCJSYyWL8eLihps53bgn2SAYjbuw2Y1qzkOtGYts1fWTzZIWuSYMo6k2Px5kMcmp5bLsgJ8nZRwGIs33rDzZ3qaUrBuN7HD0Z9a6xzrk3rTA43qNh9GSeKEHShYrlBUCFjcO3qo3OuEt8vbj8V+LjzQCTKZvjOqsuNak0wn3016HjTCVwcJLr/vv5xPbJXoCvM/Ys9TFVSlya6bDFqUwEXksGqJSMZPKhrTb5Rvus1Tbx8TilLWqw1W2yNtlHQuxLZ5R80o6WTEZvdVAFY2vrosa0F5feYE6TqkQ8jy31yZwKdIMmCz1sSuCegL/r4qdr8eZegrXKo62iuL79mlEGCpxxKDRf8tiO1TQfzr5BodcWt9SKRdYwkE+IcvCOw8JakVX6o0jvKtcOxZ51q88pbs3C5haxwG2Rm4CDRx8nynw2w8ofXDvz12X7vpqFNhLJGNHxY/C4BDtWeaK+ALxCXY9EcNOtEdNpE8zfOelg5GHC/kvwhg9NPbB4boqI2ed7Om19JFtbYJFx9aLx7rObZj+Fqrl+bbA44coJRdUxp1O1MSfG/NUYxnuup5i+ED8k+84M8aCAJ8JyLDL+qQSZ/VQkGIcFIWIOmkcMxZGVORaWU+w3wcQW93cN16D6MOO0IVqQGywin7bSaoHfNcK8Jr1J9zVHqph/v0Qx4ZnBg4/ZWxVd94JaCcnhAblS1WQZocuW7oGAgHKKHqyBo/40xMDdjGIngw8omBwb2kv+BonzZ54X8im/LvvFtxfFn1icZDbkz4vCN1jdldvBrSDowDCphCUzr/Hum+lAaFkS4ZdlNA/pFxbQNJdKvElAN25TEdGqUGOVAKUNQ37DQyYki+xc7RyEkTUcmChy9kuYd0HCjwF1XAoRpIHlY6IRWDyst6iu0P28mmHSamYLLRCXmEacO8vZdOIdJMRVIQm1FG0RirwHBe42eyYc9mhcw2ld3PX1G3AlvsayaG6+m1us5bjHT4M5ssXuOx/ZWXfhZ3awuR9rUM1FPTrqMe+TRFRl8d0CgWlDbadc3h0qLy0ReHuWUO6E3IqX5bUvsdG6C0o43zVDx+A01W2hSTGcyxh3q0z9fpYEY3j5Gv+XiXmbebKhcAJFkzi3xNA5obKjYqVjhcwLHvPQn5i6etfD2uVfMXX1j8B5jNFQsKhgDGvYXPxhLV6P3pd2+7TFevCvf8Ho3hOSTwiFI83N6KAgdoBvWTslxDHMyBqDjy0OeKW3TLi78b1gOxnWbnwPfRNFgLC48RUWSzKGyz6OPBBqToDgrDV6pLghraKJCD5SE7iwHE186BHDJuTu2Xfm80zCG9/6w1l9lLykx3IEAShMNvdtTXVC58wFiPjhW65ikk75YyYy3Wg74hlre+GhAcwVRF39E0FJd9SJ+lTsckDOoNaONize/qxY/1M1bYjD1KlBR/3QxxRXziTMK0Z+7x8CcGKmeeBnXa0DP5PGsoJW/OyS28o2VJfjQX6iX6mVGzU5ZKamse/Y9NkfUjka1HxoYN95mSbCv349H1IKp6J+VyBsv2KvS6rmVHekyIoO/54ocNV1D9q8aYNDu8XLD5VUm3CynnBKqPm36HSTZRPE7o2JGVmYz79yRiYGwjtNy0eDvH+LCZ/2ASbdERFbPCYl+AKaYopqUoMALC1NF0eD3j09LMYm3zD61DBRiSyQ2Daj8C3ywXRnCs7xwb8nIPlON/35akDyFbHdOxFa+ueN7VZrpSeEmmCUhaYrF+QQxttgIvYRRy1FPnrf7ZCYWlp98OJMAt3u5BMW8TpTNWyjFONaW73XiAR9DA5T78OZ1dzpFh6KMU8DzvYdNRuQgdIwO5Cx+6sgYw+ODx6NjN03mMT9RyJjl0MKPwUde3D4TEE0B48jXqeSlwgxo/jwPrOfDarXNeeHKEuTgl+5ATUB8jGF5KowQBit2Saq+TBz9LxTCXOXnPQENyLybYzhhFvG/nQhsjDxxVYDs3R76V+BaKpm4BEh+lthFEEYzXF43VjkCQhX7g/HES2W5mKaud/wsAfGF2fCJ11EdhGZI/dt8wFGixpiva0xXJQoQlWypHEBIX0P/hqk737czmAp0teeqoMA6btz5ODk2F+7R2ofz8KzCN67c+TIsKkR9yu+MAD1djwsC+V9+swQYF/Op2P2JAhPgrpV4xIY4RwT+TlGhCRliZpak0CDpj8fKUD1MwUHufY1PxdE7y9/gfibdoMjLKD3mVK+JuMDQU2o+8Wi4dbgOB3c3kiahWJNMkFn4P1Un+zDPWiVcJ3k2XNkvEb2Y+qn6HGYrcujImQMVN5twyfn7Dm+6x79rmlF/bG0qGtDiEtvHrRmUEUNfOcms3vXGhJVAmEeuAsr4dVgJMogk0+B00vA1dIOD6NtLiVF4NYpO9mtKcElFJQ81lPx06jeaZScYMM8AkKwfoblqmBCfTa/HT58RlBaFwPbLH7b3CMD94YmvtqaQhz0kAekbHKtih/ALpkPBzptrVhl80kPbCUPAqXBOPArxyKpbmvD9P0Sm4/Hj/7HvE9CHf/uZzJcIPJtAoPwi5IaR/xmbeufcA6v6sFvDp7tr31pTyunCm7nNaZIyy/zZNxHe0es7nY8XnF10NpPB0BzluTOiijCoNchWd1uULVY/Nc+/j80pR0NZgOVMNBXr9GCkGhIrNudR9bT2xZnxC9Ai+QajqoYCLuyyF9dI9MwdDju3xFGXfxqT9dleL29zKFg8RC3km1gYRJhgZiPqERMtXAcVQ4407Ejl5bPIUKOKmYmPkKqdKeth7qAYTJDkx+LgeI8vrNm2Q72HaA8DkSgt+K3Jx3W02Xb29zxNej0z6fhP4+cb/Qozyh8BYdX3lFsLgzp7LlrDjqv2XXX7IdjY3/quT9qQidAyFAFNQ2ptoV6UXNDhaocyhuwrG80HzniF3WJNt0bdjsGtWsGtdN5zY67ZrvrGr2CFwEc9Zq3mbhXsEtJ0dE9GIZRJllEpMCmkZraHUce4AxIDm/oj0cd79/B5k56Udcq4UV6Tdcq7SDZj1zDq8SSR4qA5ZpDaUAa8Dl0N8yU5+2Z58UeJ8wc88QQOujA3dO1cCio5Brz1KB+Q1+sHuBX81vMMUkgQ3/bdmWq5E64eBC171KnnkL6KnwCgVLbenKsNufe1aCET4Zt43n8zU2Gn6Uee8IqGs+OLv9Mw7Qy3Kz7Spqty33dftbb3i+2j473nh3vPbZv2LNtZ2i7l6zqvnYYz2ij78ov/VHbG5cfsub5rpjn0govtsyTR2SN8kMcrKow9haRaOxDfStepYCfNgSm8CC2DXq1HMEZPzD++udidttCuq+waKw/hb2K+70Oa88u7rAFT8m/BMblnRKlpuVU1+XUTE9Yy+bqYdEE14kiTmB+rLYzxw9t6eUUF2BqFUmzCAv/uKpv766bqQ2tmpE8nzaTHu5CaqmW+Sp+HXeNgUuHyFOspjYDlGswOu7AMJPHEz5/EDxW+aJaom/sETOXbgOOnLJ9Uv9JHTNHs3rDjJVL65V2jvZ3je258zM1PndXtvT+htZnYMbsh2bMvjNjHpHg+cN/RkOz9yWhTtAP+gMd0wLPUI9K1RiZRlCBO/KG2A7D4GKap0Cd50OwDou95rqLrQmLI6PLmdyPocoaYqFZhJPe++bkOwYbU55Y2tcwQnxAqPiFaRLa4Z8JxaU3HaWUK63bovlb2ECVcUQ+jP/TROppHAefZo5aNDVneyRZ/frh7OLkNdjNRFISYoJxNFhLDyrjCoTcVd+TEsY27r7apgts3H01WBfYuPtqcrp/7vy0Nu7+AtvUD+pZt4nrnvN0sYm7LzZo1kDdX2h77rt3LLc+939k63P/E6zP/RWsz/xu2d18JgkYtU+D2K0UcasJemRMUO2py1koV40nRHvulsO8lag/5+eXqvekFZqwZ1qLF0PpEohPCdo2UwP0UAzQnaUW6P522rn2cJkFehhaoDuPMkETKxG5IPSPVGi7tGki/EEMNLw8Zn1Y8Ky8QboNQ+esRNT4PdyJ9DKhlRXBygXaipFyvDzIVcVhfUJswW3Fej3i0Gw5H9TNBlamk46uZv3NJ6GrYoew4WiY76QkgYha+eE+2+9clSAyCYoD/CIZACH3FHc34bHQF4VNM/CDGhwJ5aNR2vuX1HGdoAuvOsiwToGfNbSmbxmYx9Yz0X/OytsNP1c8NzKbDitMjOT2Zfhx6ZBLdOZYxRNqkY/JQB8awxvwIWczATF1zTvBJlpDKsBFp8HmAHk2p5J8pH5Q5qtcJXTODN09ONjTjN9uHGr8u1uhjy9h7cy8rfGCvaqvp8gWctK2NSXN1xTAyJSKHLdzebdWG4/AUKOikGy/Z4tMLkeE8yVicTQmXA862t8E5HYZNzoanTWDDr4aNwduqQ+miagjBo3K7VgghV3SApzf48vBThGGVLrWLp9Y8fU3chMI1LBak5bO0imiQner48pb176d3pbjGgTM6EGWUHJ3IxB+dz268AFkR++amtGx0duuGdaE+Zgsu5AIGNtbdVWHMlcDZf5qS/+f/eyV6xVy1cm+74QJhVCI2Q3h04H7J4OS8G++VmZYj2C38j4QvErMrCbWiIOyk1hHbr7XL56fnVx9dXJ5+turV2evzy49EgaRrr45CkwZNUfK4pd2vRFO/4wxtsLKbqqKsYglEO6enZfLztaeO1UVXRiprTVyAOvbcTOt0hpT9zXRy3k70r4QHzCoHo7ot9yHbX8i7tFLHcYJOsb9UKK2HK/MzrE47P9uQGI7Tz/N9Qw/uisQL14iXdOdLdl113RnS3bcNfvBJv5psyX0hiXZErpmQbbEP2hhugSveNblS+66UPgiX9JjjbuzHR4W3O1veqzjj+NvejDi6v6mBxZ2+5sedXeBncBxSJjS0AysGfX25k4H4m13cyWH7eBxKYOj/SOLzZGXrIx4W+hOfQrYbWfvmTd9d3vXrvZhFZCXrfxymhFjzkQm7kNt7QPV1TVSf2EqPV8bm28RfErG9inwqf3j3WePgk8lSySvZvjUgawAbKseE9RmszMH4hSjvXwml4UJmtyDsi7x0eHxGj8i5Nk0ZHbuxGwWbzSF8u7cvLz4NVjJn9Omz7pAB3u7ug22s4Wr7KuANTEn40WoeUFtfCintbQJEaJiJOCuYHAD1IjOgklV4rYWlcYvwtPOeP8XBJVsjBnKL85UFXo+nNawa3D7GRX2N0hrexdanGqLvx3Xf4TN/M8VVXzIv84YDVU7Dghqfpn7lF0Tm3J1vcPKtKBhqDrnT0I+46l43iWX5SnY3Fdayzt2Ot5hqJfly+3Kl9dIKqTPYE0jhPKzZkZOMzN/z9AFrFFOq5zc2dzuEI6wSTqF41P4/8X2M6IoPYpO3tHik7e7vbu7Y86evGblcFbuTGFEC8Z53zR9aUbSs8cod3rxetu85HVwfRjgWvjo7HneOzxAJOSETcFf/6enuzuHn9+CaU7/efS5Wmuj8j2iTmeesJ1znWS2PYSyoOrpCKSWm4MgDiTmJh0ExYQEBc68cGhtmQ/YWvvSfDmixkgBBw8yi7eGpuxv1sYNQzTh5nNs2lt+uYmuD5WA4IkyuOn9L0mVBCVc1Kg8bLytwmS9rdG933ByZoOpERAmqAUeXFpFT3xRtg9dtBLU6k2ea+GY7EKHbF70MOwbYlrFOx/Ash2STYkhQXgy1ov4uy/A7GyVVBBJrYY19Vpmh514T2ttTB9QBnMNGk4nXvGBGtA+MA+p0jLiCwkiS4kwL3ixrCkQuDwpY+4rpR20Sjzmt8MqmHFuecOGrxYwCQlY7R62RSt350vWTBMs+7AXrspAVnwCHzSihN2Hinhq4xdTlx/ygnyFwmbRdQhRoPMpiCMlk2ZCbQ79UzZ8O6lj3pS6/dLToSJJIca0h+zx6Pnn9oIw25bhmOnZG64Zctr2uqTEVnqGzFd/JbfjmfIr+jcZOSX+elM4J732rp5M4t9X/4hLMhDeULszedLf4XuwTYXK4U9djgv7jL/DN8hZ70nE7xO/QnpKFCcaN/x77C2p1Jl++p6S6pWpGT8LqMmXrwTojTKf67JM4RP3E8ZgVdUqk3QsR1CP/VPhAitKSPijTk7yfRqKCRqnZcadG2yodN8SbvZszOjyQBC/JDBvNcHCCvq/tbmqaHwaACNPoZXR3jWTDTBPKHZ126BW6zIMovkQgCDuXyxaCEyORyx6oANeU86HTBQBa01Y03ADMkYAE6iEHyVtOlCnS+kgpsNaYlhgP8EhykIyZtZQkqZzTQO41MLbDQqKidqyMEKZUxjEVSNK9YHSWtzdijl4pETPfQdn89DLq8fzSlFkYi9qWxi1GcmqGD/kq0zMIB04bd76GXNJSmKNQAr9jWXLCwdrPmq3Zs2k7sNpvg1tyJXXUHsS0uPCLfxcvAK/c8leVt8kOibBU+9NYMhc8+vb2ecFJfj4szGhKEnjtuFvf7Sdixmb24oW0GVq0nyey5t01N5xTNLD66Yh3VTnKkzmU3Dj28yMx2hJOSbE/urn+LWEOF1prIuMUbdKHpWb/875JiNY9hbFlV29lq+5vfHPFfghFvKO2SSeai+ZyELLAj+FJJh2/s7nBeGvVXlJwVoy//YGyvsFN3Ssir9hN7qBo/7J//gbdiJ99C4EDlA2ncq6HPCtezPjDhWkXem9QF7EXCzn8Omuwir3HQTGzGleiQYOEQgoESwzZd0OOYZAfwcOxkAq08xEWgbH+fWoltwy0f1OpNVcJk5U/Nd358h0ruP6b8Yn4sZP+K2a75mUD3yA4Ag2A0YxMH2iDoIplS3LoeREyDMz69pl5bnkieFskzbW6fD987B+hYPZTi4Wzx/G5ajug/1V9xW1mLw8MFNZZr1WdAPTwt2Oe6CybiqXxAihjPrEru/p0TPdNDp9hEdz6szka+9aYkSNGSOmhm66X0r+m115DCWBn6z0+hLypeXHf5OxR7HgWdN/b/YOloAwlAYfWHyNafyx+rQsU6UOymkxaQhE/jOlFCbUBWBcz7hFZHz5mIJrzIohXat4a6hZl1+I4BRaESGMnjyPrwWXYEnjTJgweWpkezuZQa1QmInjdthcY8+LwQCPCHONMWAcKX/rZi6pXNpf+HFbGmFqlJRMEkRmNxoScAql0JcMGlkuKsEyAZLieo7MyuF2xm0GQ8YGYxUz/1I7aF44uHE0mcVxgn0HsvMCiJEUYsfc90fDq7t6UF3hU65g/8D/BuEKskxNG099ptYCXs9vpesFoVIT3Tbe6Yd9Wo7x84T75FzUJX5yVayjvcS2lyUWeQKnW1hPiJncbxNzvLCjKgOKGSwjYR6q3p2Pe0ZS3lW+/TMcLSrZZThDiLJBSINDP8HUSuGsf6VuHKyFwU8nMp0B1tKydFYuGNOpAfeNm5pMYKhb5vHePrenEAOwIOBhgolwctxEwtdEvoRI7oZ7Q9Ink96vZ8PKFSxGpLzFm+pmPhY+XDPG85QHuvX71hvqiFHzYoPC4KfYoTxsz2GQBS1lBpmrQ+vNok8iCUPfHcijiiguNSYCE9/OwoPi0CTc1YSZTKz+QASPnXtyMF4QlUE1tVwICYwbjIjJfGY5MH20zivweuwbe7fxg3LwMBzQKZg1iHHFD+MPVanP3z6fGpH2ljZ5e2cCkE4sk2BgQiJFOjqioJrXJZovyhk785HVTL8c9ufOlqDV1i1O5WCja2kGLob+qYuV0WaDfz+v4NUYP4/m83X5kWccOXmpeCmmeiH2lHEd6Tg9Djw+RK0MmjmVnzZyJnMDk1FxHtsLf8VrRcJyPxaW7Lmas2KWWdFgfq0Njz7FzbGkmPiaiPMerzfHNBENW84WMIJdOUfsksJwBliZrBNCRbrSIFNvjLed4Km7sIkMVDUh5LfFdyeXxTcMu3ZRECO8vEkS5RzdV7CcRYI9PqfYLSc5Dmbz4ZKaVgwlmybugLlAuxorZWqQUvWxE8FsUmlAJbWaPPise2Jy0eBj4cV7QJ9CnEQMTDi7l7Uxc6x5FaADoA+9njbvK4EqScIChbs1oZSGK2J7s8a0B9uuZDoZ6uxo4+9krQSy1zwRH+0tHpvPTXCQD5Wx53VHqlK8982Li8vi5PwstoSIVyrFGTo+QpZ8TqCNu7/ObQoK3k0CH+CcN6fjvrNGsau68VrLDgg/IB28GpvWqZD6enyHfj0iqYV3I+OYhNzTnnQXaTOFoo/Ah+4YeQBwBTIlsCufm1Zg3HbJzBNPH49n2IToXWb8FByaS3nLTJgZ/O25NiZjBnvqqiHuF1tQni5LnA3dC8zgx4LHkMjp40pc1/go2rIxYTbAV0goagWcA9/rLTkQk0i6gB6KNfUSm+QksA/Wka8FTh+M/LaaXUmN6BX7Ak947K62DsfBFWljrqZvdYLAk+Y5apVcQYziqWvQyn5FqOjRpciIyVagVFLhCgOE/T/z20R3B3z9wIcPqDYicL6xfkaisx7sbs58qosl4+umPidA1YwZco+VtiWa6UojEw4pWtTWa1WBSEgItiETPYIipk+hXTLvr4n6WWh01SEjEAWXATi7EFSv2chE4mGLOxo/R1gOySNUA+Ercr/amDGjytlydtMOJMIgJopttYRSUR0/6oDoXk/OX3Y3R3uGlbtQ1TouokzXW2fZmaFxFIDbtJgxkavc2k5P1IqTooqO8qFrvdnFaahtzaD+UA84TOIPmBx+PY1mAkRrUmY/ETs49G7Vo+LA84IFAiJFRImBCu6IHrHK6sHIJXFbua2ws86sYiiv9E/Nv06VfvoZbN4wOPs7//kkTUfloAof5qIk9bQwsBWSONKCyVgMpwp+4KiHdPpJaBMXCNmU3NMbdHoGzpNTj2TphrBVQwleKV4FQbQrmZgrerZs+1AIcG8xCkZMy3u+8IqLV7TfmLywbyufyQAn35sod6hMy2w3LxrvhLBbq/2JmEl/zplD26uYQ977vQDruKrR0m9pvfLUQas8qe20AplytqOwyjrs1oUWpx/ny6y1j5i8bobDGjwxvknWpnV+uKBq4l1ljFbkSCw1miJd36jl2fhDDYKJsMbUJ5wyK6Et7DRy4xdDdSfVgKD+2JAlRx02n8y8ES34y9aeB+MJcHhIxIwRPOQ3OrZgx7NG1hMfPIsONP4Ol2gN/U1uzEibRqE77NQoJMaODV3prwsUJRwhB5uy+OcXv9ctfV+yey29DsKTESUtXdaGhUfODCNvUIu65viVSOM0rTF+Dc6sf7wVR7k4bxseNgMbLtuOSQrNKGljOLDhElQWHmDu8lPrQsS8j7W/T1xUFi6aXaEJNp8OQSpUiCIPzBsyMsMZ4/kQI5S7vcF4dUJwCpR9VqfmwX4AmrxBf5jA2DNfQis5QGcV3fNLbPaS85NfNkEnYo+A41AL6yOvRMj4Y/Vgm0TxluYuaLCv3HxZe38PZi6cCi/Mw3RJ5LwtgQ6H1yAfReLf8YCdY2qO5MWFczNSh0YXRrdIJkuvh6MjilgW35cfStY1UXLorplE/uDZzD3OYjodRSx2UQqDLhxvFFuGAeXfl8gm17xnBu6h2Tu5NIMo0WP5jwGRuWg7kSQfoKNTRzVq1WkOmou1jWA40keRtQmnJvBJLjDCVoWEUxAQZ80jF03BtrrUncxMmLo2ZSukQLQNHeu6hjmI/Y2QGRoAYcq4NPYSR8UDNaCfLxzU4V7OHZEN31JtIz0uoWHsDhEJhg3dJkg8hKWGqRGwkwYDSXXz1nGqW4S462VZnOrWvYj9dhRHs7uWTg9KsN1tzr/02yuO7VFY8WrWXGGHEbpiR/Mv4WTI3afN5IGNHnTqBlNYaL2LSnFxQtHDpJm+b3h59cutLRwdFJJZngzxznQArKajq5oceljXvoS46K9ywwP8zMItQNknHly/T1ynXDUOekAg8JnN5/zqjajRqBoGxDAQFiOWqTXunldPUdNRkeiG6SiZiidv07MemWj5ZzAMI+wSBZoSRYtsZ1eOD6YtoOwOxVz4nW4f6VWKRqYfbEiKWwfxjOxv78cj7pCIsqedzMfOxeTRxrK1I/5IgbdCQn0c6cidr93ofLFIZ18gaDhxSoCNpuCwzJiIJMi6pRrcd+dXoIKOj+U3cRhiTZHXQL5IyouPqCGj/0TKWrBhSmmL+BUrjVypPYv7/hUr86sBONzgeq4/6Rg6+5BKy4R96iV6SPX7t1O2bDpDpPB6RW3BrKdRbdhvFNwwnuWCGeu3jvLZaO5x06He3bTmNkAcdNbPnWByiGoO93Ppsvy8c/URdifxjaQG1cdjNx4QTB0TnFs4bEJY/OXP/522GGzl6i9//h9cxQReqT4oaIY3JgPNAuTOo0yb5N1Bcku7FPR8jF198c9vVX6bJZYGrI3ACsKgNa0m3PfX7cV3p27zua4fIhbtTuF4tSZ2BTuVW9jYfX4xvuPefgmrhbU2lITSWZWW5uEXtlrMDmp388hvEhA51ppf7Gs7C4hKw+pALQYeThIvct8TSXfKvVKFGTIJhg788ufb0M7iAo84TrkuwaEN2aHTeIaeLHy0Nkhdp7rhxdfm8mGr3XheXHBS9GI+/VA9pDfBzj0OuwcYcubALXUtgnFG56MhuNs+XmkSPmL72JgC2Hqb0StRtRbCy+P4d2zS6A5upJBMpBBIUyAoh3kj2C5uVOdTchqG0LgWPfGLz1wHIerHCG8nrFRqLmim2Qc2AmubmxjXUsHT1rO5MstmPlRj8m3YFEq0f/SFIACfu3ia9wiJK8hZrCgZM90//Xu/pSELlMorWni4i0EU/wnPzrlJgeBTTTd0Yq23diteE7+IEgpBINN9Y06/x7Em+/UwuA0cQonsY6KhNSQcHFVZSY6b32AvHDQwR87CtGN2JhqzLHdaaPHjEe/ETZPd9wgutNNYWU3OuME7y9gPXHaFyUwZ7IOWwQmBK4dWsAX3bTWupiSkUYM7Qrh0nQiJ6BhmjOfrTpv/NpQDSVw/fuhXkgQSZewExgb56c59cZI4ztHqenAeSQOClCrFKtf4de/C+Q56kREFO701TEIkQfbOuIwi1j3YZXsjXNcPUTbBhBCTjZ2bfz9ggrVqsiPKrlAstwxrpmNHfdlCpRbCduJbf8WsFcfS+MWju8gOU0fWSdd/mdeweSTjYXb+0rI3F0DR9+Xj6Sb0SdlBl6uiLlARj9qSbJZ7FcNzr92mwC4bxPAr0bNm6tCJEiC6HePlVu5KKSXKpNLysvtiVrTiMi8vaZTeEdje3I32LcbBZINqMUz6pdH20J0g7TKSyI1/fTawymvKcMFOAH6p2VdKfgf2qL49Ss66tyqU19sOSpkQHZwYZS8/h0ccYWUfKiZiuCn75Cpz9CRFkLSZ0dR5bxs5qh3ISetVLcwbxk9NU6k153rHbldb7EnmxbKqyPuOpxyc52pqPh4r0rE762BhdK47rqrtuKeEjQ6xVKoraPmPosIMkQV7WTcwiPS4bnSgIBBT51+iRXhBizmQmnDXAWKf09fFYQftyRtbbP5k3FAiN+i1YUFYaSzmCpN+om0Q0FYOefTeW7esIQWR1aYDzbvHbp65d7phJcNYsjnf2/EK+U/Iwe3cbiPNxy6+uBUMJaY4G2yU9lii2IzCwJb3rDO736eIntiKCDlqnOK3SPhA+tQ2IJ2bsu68rV9NX0LYkaVrXcoiUzLoP/JbeOKIxkvnwn2AQwNQA8vranaPZq/T274EK7TzjaufAm1y38ExxFUi663JsNZpMjoMscyzVFB+i1pPfd6qY11SCUzQikK5AMxJrQwxwapjmE/gt1ja7drhLG159/sGWxhfvPgW9/uono+OizcCp21dO68o8hpC+m7CLJ5XIY8YRUfl13Hx20ukyimZCG2CSKtGMeatCb2HYYYSi8Aysj4PlqOP4fPqVA1nA+TzaQutG3/rj/MS5MLsQYjpcmqFPNHeBExdh/OSdr7EKV/1ptUtYgAZJjdrq+GNdK0ormFrvudcVXyM9zafJTUrNg5qBB6IA7x6n+WZyDKDb6ISyGXWKD0h/76AlTK03ddTvPMT5Xv0Lpip11JvwwmTFDfYjbOKt8/JHLyvKciezW9ABJycvS6+hn0JJlhxh5zB40yquj8lU4WhEwIc6jCHCe8X7R0QkEjFbfwiR+iPTq+JQzzmSLypPjTDOd17MUTwRATmEJlHDdyFAsp5GFxBVZmqGdzKIGFKOLM28zJs80G8aJJtEx1O1mHMQv2QHMK9rtq/3vfIeDphuKL2iUoXolj9rcyuYFsMqHyL0JZZAOHqAu18isf/bPyhcU1LI5xk9AgxCxk5FWuD0uLLphhwx9FPsRwau8vX/fQGsyaMj21oHtGpkehN9uTnbc+oKEFTL/mMyKxxEBm3aI213nEFHE+Rxs/61RSDmAuOv4mf2Gx1FKciuzqfMRoxQRG5Lo4+XyfD2TiJYGKDTGQZ9nTN7cAOqIZDvgSTHFvc7gC8bYPCfXQttB562gwFxuA8cWkJ3ukpcjeexacMnQfnNk4mw84YWhm8R+1qdiyoqjt5TxK5JjFVz2Ix5UPL5Qf79swjfZ2j4PVaYRx0DFYilTvcEds1MHzyyVKQk3NVksKCYNL3NveKdYTdYIWgsRI0lCtdpgiHqLhXKaOgB/Pn+eZIgQ4JdlGaL3Rfk8uTRgXj3HU88BIVRHWwefgk+8IFssFoi5kLZtrSd41mhvGxsj/FRjpLAgVaq8W5AV9s7FSy1B3xWzWQokLCQQE7zgJBQzR0EUXLo8BeoGxzi5J1t/qLs0aYsFtXGI5UhWHvB0x97m1/bvbQmW7vmY/r2yadbdv0a9/O3uLYFpZEhYLC+1YRtCekofEF7dRSNr4/uldOJpt4ZOATHYxGdWIlstjTo9V1+sQVSyx5khBQxjW1YVcPPIKjRqJ5uBSOzrIJSjbHD8bZs0TC5iJyCRdOPDJRYG8z6oecXJpdlvuGwE2IKK/63s4jOAalDuTPx6GHHeqm3ElwtlKrRRBJ3hCsYKvIJ66sm1LgPjDZcdA8ppllHBarwKfoIfPBXNLQ1T3KBz5AGVfdPdmrckwZekoQ5jctW4+JEwSc7BSZLrSOc7HJAOpX5k1sMcFxetD5n8DqGA9nESo99BlbfURwrlo+WDbpF5VCuacEwlBTUeqZYR25Mg1wscyTDCDN1bPJQpeOC/TltHJcoOssWKLHfaKN7MtHH5GjDJJEcc2COyY3jNgRXz4YDPsVMSYg4G9b/DVBEA+fDyOjah6xid7tXZ7G+nCBWFrmESxkyosV0NOEXweLbgJuANv7mRfGZWphsAwzyplzUhbMOjh8YgBsytrm3kGmKCv2Uh901LflhBOFWRcaxi51L0mEBNWSOzYeESwA+QQdqx8xqNnklqhokAiQThwRxpGe13FUmXW06hFMQfhfZnAYIsymDorhrGL38k0k18T2nSnIP7cd8pGjETHI8T4OYpSmWXewxPmS9jr1bDEvs+C4BDQTqMUvaqJ+/S4TQHRTlg195wEpkesyKqfvFSP4USgf9GmldFsNgohjJmCBr8iMI4Zcp3GJpsFYonNPVbgz0CPcUimIizDa1P2MAvKbH0fDEEZCVskx5uYeVFQy6DydHaKQ4ykInVKhrrDGzLf0yVzsx40S1BXm0hGX38vtr868ddKuQnovqbZXPo0E15ANK617A8GHgDz9EIuzjNPyNAlosH6wFpueoUzWO0j3+qJAQbAFWheNrFwYXOIx7Krb5zEbDXFb4SYJZJbUcn2akviubtG21DrF4tTtISzlZhtIFkPIez5VgYf8IVgmnlTSJo9e7RsQL9cQeUVXkTVZZygXV3ugJy5OjrUJcnimjNZnhh32ROwh7EuMWQW1iRpTk9pqbiQFOXHmF7HfGzYkMZ9aS7sbMBCJ4y5MX65eKZcl7A67ho/vPKbmcMrc4QZ30TRXYhqH03KWxWAQgnhtDkYmf6xX1RGEC2SuhMSGaCRT9Ue2GsHP5MJ8fuTZ8LfFBAp8kgcZJCDuAoLs2BRyZhA/qnjM+i8OSulMz4fRdTPMG2tq6js2knNTm9xRsoDStTOSSdOo/Fhpua1Di1qGsEUZIGMMdDLs1NZ30FR9gmnMsORwYmqdlwv7AnqXVPoDVoNcwi/MVXSiZKNkaVBemOAMc+fT3xuBVYPI4ay6k9YZlaQGDPme+1TtS5h7UQJB9K7zMksrZB2i52gTzMUiN5ARCgdFfGF4Ol12QS1xjgFFcjRe7LyRxTk/WmjwYu80h4JKGiw2QaOgarEKpCPNQt136dQcBxyCCnxhi4Er+Nuk1p+f4rCGEroJNgw5NMbg0C4TSXQvsP/yub3VVGUua7a3uf2Py039DjMh4hllhUM151biBXhGFI+9HDlVJpYaOcXHTuy40+i3SU6G5cPaK38dVcAiH4kIPQEKpMIo0OuPfIkPlXjB7qBxhooom5pqbm8JkKzQm5DqcQUXLuJFi6u8Z7nir+VPmU/no/y93fsUb/S2oTNxY0o9b1pgY0APweaAWljwmUOE+5UjWoE5tV/KCUwnHzV0RSwiagTxwsyvZ4RJHRTbm9s7/imvibHAvFsoVTxfUq4DDZkmXI7EELeEmdPjsPDrtdAfqwl+e+40FYoS2A9U1uhb4mWOR+w+cWlthbS/GyL/hhi6QDvtpqqGQk86Mig6EqXc385wY/OTMnMf2c9mf1L6b+ITitY1c259pnPOCTxbK5S4q+JAKsxC/1ocdeJb7IiXvyhbbL8VxQ2wfMEmGqgf3oxiuTgPIc5OOSRpVzdBMDqqz1dYmaGlTzZGysp2gRUIt3czuPoeCTBsSwHt2dSVkbB7nAv0z5gaC77ZNYCqbuDRM7L3Ba4rYscZs9LJKdyTotjygCzK6iAXq2ReKCFCQPsEP87xCrbZiEyG2nBfV5YTiXKE7QoG86XZQkGfCwqzqSahcMotKimq2DKK9Zs5XI8xiLDNpGw3mxEyh+pIm4z6c7Wksmx38xBcd8MoRCXmIHxKTty0ijn9VFc+p/TXIyxO5G6mrmbORr402fesuRzamN4zCdcuo63cKzKKUhoMnkzIWuYwD4Gm26CVH+nHPN1+5j0Mm8yQUXrzJbXFQlMs3ARdsL4gZPrVyemFS1reCqzNelaMTwkIMXNFcTmMurhbK1qFUYIk/JYOyKDhLbQwxVz47ljZl+IMrc3AR56DmNyvA9qmJLsTdrLLDj8OE/rNZWIPZVJAAd+CdWjKXJmSaHagyiQBB4eYMT2eKZOiwN0Udl0nevGKHYfoFrIKpw/i6fiwY4YlQkGBQkz++Bcz6a2bjztMZGIhmJtLkF8JhQP8LeQ1Im/Pp59TbzrRmn4jKFhAzk7rpTqVtzEkN3LTg2y/+o7sJRIEzwB5KUBltIgTn39qxqINdCMHDqY0uI7Jtz2WKtygeXIIA8xzBFiuIqWVYkpfRyncsR7EfhCvNFgMY5ocX2LCmXQz5QITWohsyKEmsgI7uGvY9MthordNdE2lrXAtxFixcMo64VHkf3bjwg3lEHdzGD4476OTDy1EOljBe9PY9k/Bx4fYE7Hush+uTnIZ1JV4LRvgY4RU4YJBUMurLnMmkhIvxBCo+wrTRAvKGgP/iOH6UXo/4htGN0DFQ3Do8ZX+oW+kEBV9W7Jrl8CqfK+f4UAZznwnHLSTKeMVPiXMf5lSiwVHJtLXpNqwuUhpy99TXuYO0E+ID+KAUHZ3x6U9OhjL2ukHlEsSir+1jtoN/0LcKM3wupyqmfcYa/J1NaKYGoVcL8A9vyWg8nGcBwHRP+3fYeFglpcHZFXHoVISWSIK1m0ZkQ8oPLA1rUOjFmdZiVQnzF6cB8GdcDamiJvMkBPvi1MkSS3zQgPWGzVo4JfCIJZU2W9YAgg+Taw6aaapDoe/3QFoMH81Im6TRbDagNdsI6NdkxpRb6Z7nJAFYbrc2MLC6yqijooxtyG9JDfsCtuUiLCDt2OLaTfH0euDfkZayhvaw3n/6xKjU23xmppoDMCoweYcKQGs1cWWsN/ArBt1UClBZSjuFB2TVN9LDbUrv5IN/2J8CyLkLv9yh9C3gamgolFmC1PpmzAMpTgt2vkNVnXyOIP0EO+zRwiCr6cg9eFPLxu0G2x09tscZOkoQc1GhSjyBcEhFyJqb2V0JTnjZzUUkCGWNQVGgyDuCxG0krH788gMIgqQityw7NfEETObefAWpJofiy0CSuvoadwMumUv27opKc3O5jNsMqTguIbkU0YHWrOedaeq0k8NLgTNfCTfbNqGuZyn76eCl+xm8X1/zYvLBOQPnsDtLVn/g/nUaZKoifayRN1LN5+rekjRuFxWb8NC7GCGtK9arp3Ip2I2ZAtLgVx7LFvc5ky8U7TVl7IzOhIYo+4ulTM6Qv1ZZlMaP6RwBTKvWuozijK+Ml1BtR/VwMAn80n0DgIBHjN14Si0JFhN4mpm7F7ttuWyx5qyVOO38WHL0hOTdXrJIe9WZy5nPnyP3Hn997a747qRzjlNejMsbyNC1Fy4DT7ug0U98swrDwoqHzjvDKeED+vuZBBYXlgkRHAeQVro/uhgFvXKx4E3OlbK9MuaLbRQsP0okvCT6DA9vLSdmVrsU9u1K5cAVMOCoZOCK71rKC4hsFRB7eXJf3MS/2ix/krK5kIxRL5uPXM4GvyMlzBWOpbZ9FhYB2tjDyiaBhTmhxWjlDIiFRff3wlTim8z96Q9BbQN3Dr78BYQGy0AgxLSRnCF2c4K4nY1j1eoK6/4D63n6asTfCOFlo2PVwW2qyHq5uErIX1uWTNIakrWgzbk9DujZ72P5aAVcZSSmaBibhpCOSwpcpZyII0qcG2QBztLwV4QV9L0OaKLBFSkLZmkJ5gHpOdgWSumb5ds0dgWDgJTruQqaE5tvCflICD57KMgAdcLJxT3Nnf+MYP7POoumV8UPsBnRqQpe5u7xXqmhi4nfNVO8NRn5E5mCXZEQ/pvVo539WdAa/4KT++vVAOYOhAKHFu2ADuKDCvmDTdXwl7Osxk76ZSiJLFH/MODilpKativ1EBgsR5Qo+IeOC6eHT7dSW3BaONSk0qqyC0fzvHAaHC+A/xjjo8CLi0cszSATNnDCPlZPApXk+9x+dqEyMF1yum0fHBItwAcZ2f8jjq1YlAGH5fbccsyICYYEyY+CtuXsUxD9a70NPfWPL45yBinAGYjndfDmsYnjssehn2DfHccF8rFxRe/yqd2y+ugEnS9I1fwI74a5pXEPfe7a+ZTKoTK0kP9+N/LvWq5pVjwzoil9PGvJrqYtKKUe7n6UXU9Lil6SpE0qxvZxNediyviYSXqdVv5I1wyVPwzv8YARjaMnYbhMtbJXQ0KeNq/e2BvllBkT4xp3B+TSlylsJg1IdfRcjdYQof4Aj8ilpEFZZKZNDbG5C4cnM4gLrspzGM+MkkpM12DwByJIR6rTe0MY+cPBB73pfCJ7O+bOQU1mLhttc/v6C2hoX6X/LD8U1aZ6fr+mPkGg6ZP++GV1GEb9nmJpstyeqP1VJaS3vFXILAxp8q5EQE6u1fN+Mq5forrbK/q8ZXrXWnZBgx9tTMDmB4sbVQeCPI8DVtMo6WOjigvacwxCLzEdXADQJqG5SmLNsSjS7c8HDEEIRLbMhnpnDqMwfUZYO6j352B/63nPStacCwx5p/6cU3JIhPOJAKWNeTjg2POoEbjjflgwx4R/UogjzIocU9LqILT1XoQASdac/OUqfhmTghNuSlfU+LsVceQHARxbLcjS/xVJv4fr1LKLsmGDdNT64HoaKXnTx4FE4K5VbpnVxHpJE9wmY9VIRgDvXkvgwdSx0NHGv5MjGKEHi4fJiHuzegGqozEycAe1CT/kyCQN+sCLUd9H/MKMGpcF2b1FsLCfHYyG+ClPtMrqnc1TsH5bXhfO6e60xrNDHip8alxRWLITsplNgN4mIFl4K5zaEJ2FOEJkvso1t/wT63zAv/xr69Bt0yjpU0mWcwbwhPw8BfrUzeEfKz96Y8wJHLKWHgxJakwEIhtwD5bmDLAcqhPG5u4aS74bVpaZuwE29DSCDWfq5QSZe6nRElNvhT8HviPNn/hoFkUVF29FNHUlAlRAKpgj7AwvMQaaEaRWU9bT15b3pZc0puDlSchHfwIrcbBZ9W+V841tgjrT+ejay8QrKCnkCnSKJMpgU2A6j63KSHRMU4o81JgWK7sCwWQfjCYBTOOB7qMZOzpegKufJLDgZEzcZPOjF8OqO10KjpIKbwD095g37IFdYfI8qCocgnoI0is5CxtePEVhzc3v2+JG9p2XcNVwyCwaC52fTwgZVxVgy6/pQyjPkpOLnwgnWZDF80FpQN8lW6gRIIHuJuzRMdcR6wXIhdiadLrLgarlSH4mg9cPkynFbt2MEokaZO1qB1Irs4rtgrYrEH0NMyY4BbKghKxXPLUlalLtdBhCvXyVuVKMXjOOI3DdCcrF2d/rO9t7mw+861DwgHEaBw3BaeB8xMGW2LqM0ZGgX3heOrEzL9AL1AAg2rqM/dKZtLPPfgox19VeiBO1MgMhE8BmsPLntqEvrhYa5IXOzrMu2ZiI2l+v/luaxr7dkIxjZZjmJgqAP/RD5VHrptvPh3SFZmhxCvfnQ/XgKuoChyiq8RzxoAtRRaSHvJMK9YoNkJ4n9MUlxb7RVxPngbF4AxTS/wRehAHeF4NBkgu3BGNb2cPBD7ku7TUOdiatvgwdfZjNGy7qkSOgl6eL1UhHETdmpm5C5dF7IhAsQkiCZb5bRLpKoO2w6uS6udOdwxQ8UctOtV5LKmQqgTy3ex5R0Bs211o4+sIG7wv3kNmvkz72jxRikvKG7RZEg6m9WsnyObvvTQ5tKMu6NrsLmFn+6uafXDwB5s3RbMZd08bhry4fLRcd+UAd1lOM3yknfvB3caqDamCwC1tCL8DPz9/cXGa2yhJtZxUCWMXa2620AU3jZZ582OxnizOhgeK5JS9755kebQMOhHfk63zwVydWhfDB8EHwTSqIsRPO8i9cqFcpX320MxdbqlUseqFgBSqboiQFecqqdlXj6dz8y8cSNyaxI+DJYNHS/I4U7d94liu+JLHjsC9T30LUoxVQj5um1wsY+1YPvdl8l5ba5KugRvMxHOAmMqUhaNRC4BgLf8ycwk1ZshT8T2EXytX5pIlkO/GPB8m4QZvZDkJuwo9hHeSUrW7WVSbt5voyRTfffNc6NnH+N/HL96+Cfsi4F7a297Y3t4+3sktEAWyPL9LQmGdYTewytfZPrb7Q3lr057B7OTxCh3Uzdx/RpO8Ic+vyYL7JHjujXGO/YUEBWLR6rZnKP2SdoZZ/towHMXRQSn+jMCqihtLKrDcmeI9f9/kYlGZYZxwo+isz0NBEFAOfjkd+EYvZ92xkUxHLNgz+hrDh4utSXtkbsp6yHEyNCdNlEG6E7P7p1/sqHniNsXOpOOKH5pxjN6QCGDfcBFNGxpsC7jaNIo2bgwZm7JAuJObM3vnE86+rYatjA3OdTrQdFkXwCoTDWNgrKF4jTnxY6J2Pw0kAl27iHzPRM4IBb0MBXYWlQImbHHGzQuxyCntRVTbJr0osvll99SvOYZ/YizCDIguRygMe3BZaUFyU6b3Yg4PlDuauIngWofiUIUzE5ikw4/GPCkZahHDAu5K5SSti2Up3l5c1GXaVrV0nQ4XfdOKwEQxJM0Ys3xUq7VTCOde3TyTieLch5jN7Xw0Qm3pWPYcjQWCuIpayxG8aUnyu3UBek17EdszTEo+vWPrab1MMsKMDDSZXWSYwA8e2n73fnWJxpIsp8yL3qLi7S7DSTjXTK1fDFAqOe4ayLR1x7mkdNFPgmiAjXhWd5LHXOkIhstG/8lsBEFvkQWnfVnoIEitJuQ8USwTI4gfYSEw3ELnoBTtixRTrNvQQvd9GcWKrDkDjHG2PkX58WVM6ICbGSRpU2ZjeZ2MkufltK20ebP0PaN/bRTzcfVxwjDyy6vzk5PXJ78/e331zYt/fvv820v8b2zlE7bJOdzcyTtRMQdZV/iBuv6pFHBtLGLIYsyDt9lp7SypxY/UWm7mFvXuWG73xdFPadgN+oz27GWyZ4N3dxLBnXhJSflkdn0WOT4G/p/PGuaUYcz+ohzmHZyx+UbIKzOyGfWYe0/mFYrqHLg9owqLK9om5bjK6c9Lzt7cBr2fM0JMX5fojyiSIRw3HW/K96wPWeYiFS7MNa7JghZorkfxg+xpw3cSRVM5oH7G9cCDu0uOkFCzDQ3EB4XIeCru+1fwMse2RoZrx3tkBVoToyYYctJoTELeJm3nzR3lXwkOfu5MW0vdmQhg9E2o2qG7YezCqoOcixQI87Ycg9D6U3XFaLYo2wDPfg4XtHeU3Pka8ba2p4FrV4CYzJGwa7tyyZmJjqO6M7sByf+Z3Mg/7bniJHjjMtqYM/v3wlgilu4GmhayxTb48OcpjX00oluIhmkd5/VGdaWMAzZ7Sski4SP9nt0VIIm7uuSEJlvt/g5GKsOXOgr4NoPtOEywHbYwUL2wwMWMsV9sZqmK0EafAoHYzcwJPpk7JvFUoJBoDY0GE6MNw5rYBSWpdVCC6jGK9aBSt0ZTjbig+YXi0LZz04nCV8UOA3a1LpLElyNLCS7Et9w242qzOEFqJrJCgtCMg2TJ+6ZVT/M81Z17TnZ8luc+eCFv2wlyF7mFj4l5eP8yzyklIRwXT9avyw3AmNl1kKjJ0ZyaxGEZhPkcWiz3CnadcAyEY9AHstIVephu0DgVFRmEQ5t7hYv2J/jdTimIERUx4xaVNXgyBrcxJ/glqYZIEh3ML0JpfyZegbPTlUoJcjnOEWTBkpXSCoO9vKtbH31qtdQGVbJtU4R7fT4uP4Blj+/aFABsly5xOD7ETVSh5FI7w4anHCmr916jiJiLbi/Ak5xEmSEOAmH/JfnYbcXt8l8zrTu6oZ/uLa8bsPLQYcBWI95JtiWHAkNMmDwT11K7J2R1iMinAMfOAGvtsz6c3+aEd2cbXY0Paf8ozUa6HugdxL8Z0yxG+39KVq17ss89y2PAfn9c3FT3yKt7XfxxTmmqDeLGhTncLN5O8NX7278CtUoFnw1yL0xvK65YNOf+IqIoFGsLt5Zj37L1OzkKQ0wAWVjst+7jScNYleQNVSofbqbxHu+IwqiVwASWYTpchgzHelw5XKffPe4zmkmPVegi8XdChP8O0kAlKA6Os6wfVy7erPcqQWnskbqi29xo5NPOxlII7L4lyK6qD4F4KKrDCtNRLrZBpjq1wOiyfLtgVuWQIpWMtsrdfMEMnN8KySez+J0iJLFAgg8r3ZtwE33L4dMF0Tfp7wvDOzv/BsNDrgxY4mDeZvDeso8H+pS86nzuxkh1brl3Gmir6wdsKG98lfQy8pt3NjuTGGVRYF+Ms43wNGhtHeNqPL25Xp6ReQdJekcGVA0cqqmMwsQBxiyqhUkyMnb1EK/0wY83FoiXYFznoYeWmcmYwBcVSAi8SHqMKe2Fbc+mfGnvqwfVZpZhs4+icjisBldkwF2pkawKzxYS+6e+oEidlqVzZRaXq9Nm4zlRaLrHs3cVqvOq/+XP//1U9tlf/vw/BPlFTRwXbHpcJo3zlNdoemhVML9TQMK0k+VcqgBIifjDDCFoh+EggBoF+6Yjgkf7pvRoSumJkspGcihzMjCa63Q/nmOe/pI4YbEbRMvaa78Lvn6QhMzMI7UjuiHrpR0nW+X3MGx1+yhfrvuCalVZAXeuC9cfoRs9MLxusV7MI1K6JyEjcFS4iGtH9TkYpl80iVKGVlIaUvP1PvzemZ8/SIKAS5hpdjf3Nj9mR7Jk7hVniNM9kfrgJTP+SsVlvxnOR+N8XCslacs+S4ON1MHSibx89V9CS+3iUPWfVA1nX/JSKrvAWCOiK1eeSKBcJzBQUpKrssymsCy3l51b6Nsx4X8QBz+7Q2M8lvDOX+mmy7Q78s6Y8yHVz0JIHOXpUu62znckZmHItb2u1QlsT2gRgq9B4PJRsAibqcX/ZOoeOhpc4kAQew4yFYUYylYUDKY9l3a7ZP4D16oGpVM+hoiPdHZbC5NFRlmI/lXTVTDbYhuGzGFRbFo4ziNfOf96LbrMURt11ufp6YBNlsYt8aknmfKx0iufIP7iAPRqh3ZugY4SB5vutNgRza7aPuRBFUTcgyYQdB3MoiQcrJ/lMbriW0m30swzl1ZSOcZM60bmEpvoJJr1lNJxQ0hueeT7KyibYv3G9QVKggYb6uqbhojD8vZJMgLjyno4RITRHPuMmulrTPZKfoeqs5HGQ0wbjhw8V7hEqLya08hoPCOu211pdt2TJW/n8tBkDEaiYZaCvCK6dP0Jfav7I/aIkL9r+sNkE4VNv2gE3p1xu3A078z2ZrYFeglbezLCEG4gh8B3l9RTwCHvoKtk5sSFGkorwW6pW8AD/1W0RgPCflrDNhgro4WqyEUF6l4EGff8n6vK5W90S2FsG96Kwe338LPzujFM6ZsOjyn060IjG3ERDMfxeQ8vlIfF96AFucwoTjSouAl7IpnAbb4tqNdjrKekp3F3mkhP8NLuanbYP54AZyYirfGgXL+FrgjNWBzv8tld+JdwwsEHUGkwAZQczWICcevY8daDbGaKk3CCKCIWXPqMaYXSNoqGJBW/+UkxTrr3SbmwlvLqG6G+0VqSse7r6uOEil1bZu7QLc77C858G+7KUD/4BMr0dj4SN2pa3nPfKeHNSpXO/iL/x8PJ09pOhqlqxNF/b7fAABfWWDHGi41COonRQtF2aUCa3wUX7gT7abA5JoQwqorQtBNDkITSF8F4HW4ImWzi+XO8jQtxRXiGXWBiHdMxEf/zO2HjizP0KH3/8uf/ZVkHE/dB+rKBqh5K7NMZ4xmPuUNt2Rwjp+/rviyFaZuXW4pOn8gVE7jsm6+Apwxl3SpbayZ2Hx9E2C0t7uvrB9wpHIy8bWQxr4eNrsWC8+iDxzxNfnNQTbwCydQHrLVnz9DtnjTjSPmx3DFKuDv6aFc1kt/N5XYt+79PQgUP7aSv7zKgmxHHExG54CoIEe9AC5N2U1MY3eIut6xd0UICxxP+b5mxiOOIz4k/XNaEDTzjLtbbRMiloJRcHyTtWsjoE1ffE0gmj1IxL3nrML6+GscmbuRwp6VS3WFM9sOSD5FekpbGpcV0pLb+TNKVtqlY6IvmD/ZZZ9NPt+elWtfYeys/KmzNY4g4kobly3LcFGxiE0JknSjBFx8Je8rTQhhpW07qm92o0eFMjs3iwt1igiP8uK4RpGCnkFteLQBP1O+jH3ypRIpW+d7Lu7DotZ1N4eAiRQv2E56IkespElesV8zDYfCFr4XLNtte1y+V8HOywCiDnVesp0XrTxCtAwox/84Xuf4y2CDMFB3Tr6AFA8J2VHvMAyFswDKlEd27rlQmXZEKITZ7EfxoYPu4Rr0lJauOAfLXw9nnxe7m7uZ/yb0vtp2WRjt3bbTzBGFvygK+uCkIx5zIwaJ2eykq7NyFCNv09qCNIINSy/fY5o6gdV07bFNhzeYtSmhB/AYJug3T3hvGf7/lslzr1PsoKHGfwiTBJpDkA7niCScoUuSlCFTuB6/W9kL2dAzjKUA7FsiaHhHzmpuaJVCoifnsOEkjnk5XL83j4iu8yYlQccs10BhCobzO7CBlNVaWNGTDHGzs1HOUa1nng5zzGx625OXpPkog9N4FzHRZ7qYvybxANKkz/YtBUxkmjn4zeYgqksICouCkZnsnuejqK+8u0nZwwFwK67ehjsvCSnzQWoYd1LjkWvGacm3sXijoFlezUpoSqShiILe/JkDlCbG5ksPnmocGtG9i3tozTJS8WN5BPUTpDTcmODdvFcCSBV8Hj0/3p6DJSHsqpjYAt65CHxIuzykutWQHo+h33nfsCCo9556pXSpFT4wKud/8+haEv8E/xcDpEww4uZ7PJnHMPrccyCturOGqk2L5RmqiE2K/6DUU67hCIXeFcsDtWhC3i6+GXYYm8acPyW1Bx2ZRB2QWxpCVhN1gWrIiQFtHM3ewCo7Bj2f7Ah2FDq4yzE2FB8srEykybrx8cJ/Tfe5CG09DVJ096fMVAdJr12jbVYA9rQP9C2oQS7YFYSVQTkZZSRwQDqjHiqFcyOCsUxowepJGr9i6y3QUTqXwKdNaFC856J9mUFL1dOJRcCg/kK/UO85hu6/FPkIgtmMH+CJpVBGtXtSHwFbQOe4/TfZspnaNs2SoZlvXZSknrVyPrcv+f//3/8USiUyJOoBNrgjcScfVxiH1GBeuI3WIIg1tu+uCtJGcyfChDr2A8+SwutJdqmpx4OoWuRhRUmtyOW3m2Iz2rmlYWWa6V0o635jkuCm/zbeKD/CFzSTDuhxa2Dv/6JEP/l6nSJCKfo4lkxwSibQJ3SY+i99NsLbBiphii7tGwplJ1TJtGAtc6C7YtDs+2u/dkM3GtfhGEjUyTCXBmCIyqSyTInNzba3Yj+gSDCiqIRj4B+6V/fXbM7r+dZgHb2J6Nb0uidS0WAaEPjgX7KDLnBjh+bxgcsY0y4jdGlweH8TjOKg77pgy9oNOX7+6usQKoeNjpx+u9AVXNIvr5YemHtjuFNyR0oz6AgvFWH7bgkzphU1Rpk5D93k1QQJvTgXxMVrQDXMasVzu2N6D2NnCaClPr46f6oxHD/Ck8gzThRIxVgQVZrAHiA0jeZ433F+CbA9vKFKvKJ/LYpKl9CuVyg+kYX9YlZjuKwgnJVYc/J3kDPzfFifTNIKBD8Bf0UxA3zgIQwu6IRQqr8V1Y4Qb5hnvpzV2XffuDvIBTUbDHmNCuE8qpXyrj6gba6MCXyEwHwbwXFbQeRc4KIkjs7GRN2Vtz3nvACV138wk6uq6K/aD2ypxL0XZxeIlimn4vtoYclfCnzrbHyWE0byjBjB3E5gUbEz2xzl1SkDqpTx4RKAMdBX566aEJAwImeFFgdS451BBc0t91d2UBtE3wlpnEO1MtFBKtrzRogaXxx40Rh+rYRegus0ozBTDHhMwMdcGBBHfRIuTVauy6Q50g8IyXTK9y612vkXxigodPHJ2Pg65FsRIil3B13DOpq5KOPRfuO0CnXrYX8wi32lU+kfChMkfeyoYcXny9A/xXGwGzyFxq6OhQ92IZyijkbOAa+QezXAIDOOSUwO/GVtbepozENY1eWol3dmdCncOvjQ5ZEaQ/1c1fqLlawhM6Ei3dVdU/Mu8hv1H0fSwZlUWhGKi8dGFLzpFMYqW8liT3zIT706vLjj7e/XbEqu8p8fHoDHXnwTT8DJtDxJ0GyAuB06GwEtQBsuMBU9xwe86BuQ52i5Wgn6nw66sh/TLtLoBteRa3UYLD4YHDOEEd73undI1jah8ySiyIZoBqXFusiTSjjF37Ew5ArWRyweV1NxJArOmxJVAySQofDcy+KdJYZ157YofhAeLYq2BxDumdgIM02TzBFa1DJpJaDkWTITCqKJHIBoQLoS3UOJ59MDriW9tsiVn7GXD7+4vVJvHgaSwa06w/PS2c1cVQKS3d4RTUNbODij6il7M6sugZrEqsWOjzjDIKTJjUGERSRRMWgYRPSYTAwunLBwFZ5O+ugmh5hIYFdx04ATQD7yZu7POvtOxMFwIhpk9ijtwCcLyWne1NiHLsUDnGRDUfPJaKL/gyq2dJmsCD+wl8eWXs7u4+l7a11Qjca82Pz6J95D75ClBC00YyJEKB7QpsfqPH/h1bB7wkUJ4UabS5rh4fm2zTtJwfAkwIyyd88I+enQus1BlkhmWNTOIKsVDrVzKzrhKBOXQWHN9QwIWNBv1TMjXvN0o4sy2QYbVRmgc/J/N6LU+letOFhdrGgRLNUihHYh/YTxUEFL2Dl1YjRg1lnNjW49c9HQP/djzfK6t+VzUKcmJuTyrhvedw+QTG3BTR5uiRAVHDrLoVMuRD+uSiQHgERUe3DrFlntjnwDJWSUmvbMygzwlymKJlt2I24cc+4kFG1Yt9O+aFk9S6LJkXqC7gyvJdFO4DK4s35Znv0j9JBP82E3CfVlfJx97k0fXs7Rl0Cfkf3c3tzd3tzNDXJ7wnU/g2Zm4lDHaw60i8JhjV7EQ0ABPLJfQCs9IuMa97vBPTUNEMXMyJQODVG2x7tvzxcf3BdvhdB5NdWsSShcrAgFK2AGXHTdTxZYvujlmZ0ya+DHAEz36MNS7vH8Bm2iRH84JVAQ3Ma7EMOZlQ8oLBFcQuSGi7zBjqT6iDWA203iAb13WBCuRZY87LlUrhvvI54H2Am6cYe2UGnO35p8Qy0kue51WWJ/YmgaN+BzH/taYqY33kDkcSbDe4L4iO229Bs+HA2HEh6Cz+6T46sXlSbo9OzvtITjgDKz3Vxikw6jh+qSj9Z3Zs98ujDfao0A858ZDWWi/uq1FmHvC7VO7vjaCtlczlLZ36N/VwhEifV1zkv84pwV9waA7PNlbbbHlLTdYcfkQdlGCjEgrHH8PdCCov18rpZ6TDLaB33ExeyBCDd2DxDGkVFD4cSfT8rrux/eiRYYdMG2MPKC3Y+c++8qUnUNVGuseLhoUr5a64YVBKIswNI81sPeho7rRIJT++JwaGxJlaXoEtpNDACqSe0qbnibf/8sc0y6u3dIQdP56wkBKQwqcOsegTFt9sDw02rETcGElBXRq+PHRAXGlzU1nApWfZ6E4AhPFwWmbcU1InXVIZYnAtBVyZj5J0JbyRFIg7aQZ287Gxj6MWNASqIOUPQzr27HLAYDBxbRLW9hSA80vSf7ElBxL8Qk8Ec+TnRduu0XFA8Heq1OIC4eODZFLPrNp0Dx+Zc84pMwhDscoJKlSYmH0XvMDDP4mYZ95U7XNkGXMgk7QoAFbcFavy2mAtCDFb7ScY0vqnl7igcMgS59Ai+tR711PrkybNbk9f4DOEn7vYt2YRCTbgr7nkqulyiE8dE9s2ttcWImEpBpO0/JRPtBImBe+8O4YWyIR1D5xqVbffG/ERInAz2zmr2tEsVSIAYK23QswDSKGJiHinkSTjiJFunKwoxrAPigLtf6PzIL2xB1yhCQ6xKT2bDMTMOxziqnmykSDoYXjijiEu0lBhfh6wxkFP24eVA7AqN6PMRmkdXBUuotRHfimGnTpHLa546TCsvxO7oBi3cLRPTocQ3f4F3hNpr1P0ttnqlBMTHzif2OK4WbY3Odtl6psH7JVAP5yg0qJsvspTCGPAoiHvZtBqMLJAAVCvQ8pAGbxU9li0uBQEWHDxGPSWpuaGArjBRMuhGnKynJiKKmL0GK0Ren3e1iWjrdyODt0ITBn6AahWQACe0blRxdIhm7wqK0/20jVRmz4eqTDLxWfu/y+/OgewNqqCGqpooUOOO+n1ObO2YDF+t1sNjne2rq/v9+8bxqp5ATJuqXnfuua7tkysuwM+RyjKgqrfF+kqokGz/Gt0paGzaVvD+7XHI87bQ7jT3H1CxoI4n2F6e7cfosdZFqAEgn61EIT6IAlM/WGrREaQkMOhxMfsT5AJUTSowGR8USVAu0A2lM+mWUcV+0qFkBatBNuANtNLEImzcU7sWxyOsbEE7rBIRNGeAITDNNuBsMkIJhxJgSBxLwHaaOF3eQYv6mEUznouj02QUXO5iiNr0f+0MkLGUHDsqATXxaKWcOBIl3Et/FmDrOji4kQ8ZbUM7QozCbW1oExcAmzwbzQqZdDGCZyo1z/P0sSTlvSprMCtkHjLBmXvjQc+YSNE2XZRbX/3AAKhaDWRzh9bU309QHM2j8MgScBFt609xAIZdAmoBzZwIMFFvjEFMuiFOWfd54QHo7TMC4/uPKVOggBu6hoKEPVR1YFdBpLTbNXYxFwrgQOjnZfs4eaV3IY8bzSEVE8suEVw/42k8wnRUMYbwxX+4ibGVp8FNEY8zgejZi5rrNibQQTH8hhibFIkShFqTIg3Fdor56XbQuK1rXpTv1pD9MSl9iHW+xxzlkMx8UEE9G2KkH6d5hYEux79/Zb8DiRzXTGxKgI7mvzDybpG9c4uAwWQsWmlj5hN7dfzzwM65hJ0393sXV6ccHynJ4V9NU0KxYbXjhPofjFwYX0DfldZEsa+UYy99B07VCFbj2wHwEV6NGacJdcuylILjgjgTApOrJ3p0VY84M7Ti1u7K4Y5anENgtPoL7BJWulTKHNveFU8VZ9nwt1E7qTsIywYBhppZgeJ8M+myJljK68LN8LWnBGXikzxss2a2l60858zBqRFEeSA0RkhqwSox4Ki4wFs8NamyNYqqndDGSWL9/TL7yTzrnADDmW1jK8jFpgGKJmv3gBMVFkd6CPIKSnCZUrHzdQEuFuZ0NoZIk4HVAogieKlvM5Q4cWoTpoGLZ5ikL42uoDMUS7PUestYL/NUEt3G6b0TaEXeheFvIxEX84GVdwILQCW1RzYkXtpNXFBEuMewqLoCOApxJHOhIfK3iDzxRnOmnM4hJnoZmVvVfmCFavp5mm5beTjKFHTN35j8mkpaKPIGYeRxLQrkZUOmpneyOY2qkk9eJiBNcRwM+eSppkyacb42LrQu0bZkdXTsBxM+4tAITh5040L+sgEL7cFdOfbF7dURupiO2CBhOza+jr/OnyRbVle18Nh/Fx5UJrpf3Mcnd39uSMnoUrmxYRoRftU8vrN9pJEeXik/QBrW1XjfiV+VCbRtvoc+dz3lSIds30BCMZdsyRPv/HOkB9xIu/wYLvugLBham2sq2raSwS3G43bUR4h4oRlRdFAkhjyaE+++oSyQiDjiYnhEy2tAWxr5FDo8RqgAONqAI4xBmd3uz1wrfEtTJSQO5yXlFXV9F9XdrH1epwesr1rk9NmqT3F4f5sLdCOa064iniI6ksSHqW3HPM+JrLalxIPM7jpkuSsF+QQr+rhpOb+bAYNH2ipJFloHB7G2v/EVgSbDDYPuHmM8JIZXz7JJmPBatmd2QVEjjWBkQcO3Cy0dLhqXY1YeAOoxJ+SbrvSPWvdcrpaUQgmInr7eT8mGoQ51g7tlrGAzdftCA0VCXGag42xRf+7sLT5Ccke/HF0sX5lvgS3ZXr48b1HFeP7AmfyvgBbye9FkR9u3WKKo3/W4N160qzNBzmTNkkaeD7mN+niQZLvzitJgItsmMyi5RxXfzz3xAnK6WgZ2DO6UPfvnkVD8hrGOU5j+lJ1G0nlEY2T2uxhlMW4vAmXZxMQi33ALcyj7iVbXGqNw4oHXko5kHhBxiEpFPsko5Ne/jEM7+dNOt+SdkH0HuVbxhPl6993h4fHa+JZ43/Ojhe29/c3TzE/94/XkNdhf+5u3O8tru9c9Tb2ent7hT7x/vPJqPi69eX+OPe8dp8OqRnwX9ijLc93tpSYod2E91+JI1qN5vp7RYHFbZMZW7PRjY26fWbf6on+MAdeODNtKp6YFrdT+D2tc/r4x344enxGs4WpjxofDDWrieuff4DXAAfdjsFU272gEjmNrqiPH52/G/0xe6Jh8drX/MN2AoXTLbXwR10Mbp2dPHip8N3wPwZ+5VmbQ++7YQp+6RolBvyYLgxePOGaUEaBoEa0Cl9UrajdvOXv/jlLy75QTPqv0ETvYFoys+QOL6CTYpv+KwtvgArsRnffpkrcZafSBLqdTbeznA71DX+Wjbb2s3iW6o64xor7Gt022jeM/coB5NwT9pEkphp5QataPngSzcKJJF5SDwLnNVnx2ucKR42vDLwP8drYjdt7nAXCx2LEAy37vU4hXhqfvmLAv7HeoGK1ukrWA6XijhHvprXTG5XtnxG78GDmt6SKsUmqfkq8l/yCcQXwn/qeJievXMwprKyu0vexXz6oXrAPGvv2+BdbhIOwkmIXsqv/AeJslORg/RsxBYzQq8aZ0flBu3nREMcmEq/jY7OTWRqjKvWtYDFee2dUgkmO8c9VcPxV+wv/IrgO6zRQ010sbrIJVfrBAMsFnz8Rra73T/Z5vti8uUX1/r66y+/2JrYhaPXU9E27dwCRLAAzO5qUM4J6T0ZAhu0ifrlOGIlYMgITtnaRSlsOK6i9xVcMl0T4/KJfkBhvj9sDEYaRjMDJvjA6/J2XFPHCjhLU1hq0A/5KdlZdSt5JKqD6PnwP8ckbShg0+6qbykHMqrHMOxrBe9nh7MdrNCz4F9P3b/yw6WfM2MWqAdzEkjlYytWhLSQL2l1j6VSPAx/aMM3ucF+FxKREASMc+kfZ+oauJvAeRg+pL5M9NncE556LomOZ3mJQAE6iW7SOPvSUVNNCoR6ibn+t5kUHX7jv8zrP8nZpJsuVEqr5N0cDTjCpbAOhlQoDagacPh5jHnFU8l0gJv6VSKq8TuHBotDdazUMJFaqEw3ETzB8o/mJpgZlnTvmun71ohtJlaQS/aDTcJH3Ca0kchByDXwAaBdmnoOTv5asS59L9llwDzrE33Mbsd7MTmke7Xzkh3r5b9VxgV0DM9ZAAfpb5GZdKf4ovL6lD87tGd2Np9tftzE1ZNGIbRF3EN2Oh5C0Vd5Ej9I5Cj+KD6Xe8rqzwhv7Ho5IU6Cr2C3X9ZAq+aEzYqfBvawTKa35T2MjNPon2E4+T1ZHRJ4kxt33Y1YWOTrRq3GJdJeNMecsCxos081EuOell/0XWS6ZH13DYdxM7XKwRZl8yUyy3eeiVm+/ay3vV9sHx3v7x1v74RG+f6hN8rx9JAV/k9qnv/m6dOnu7+Wd/3GvyVreW9nLO/Fpu8P5FKU/ZtR1sregx9PlGtBojMveTstMLf9E7OW9c7u9vEaicPPbuFYfqbihyMs9UziegHG0yyHtmFByVhLC17FY0oHQ7o4P+6cEbqzu3fERui2EWuiBc58V+aA636IyQ1+byz0tx3/fqqtRq4dlo2lwY5lIUa1Z7kHdjzO4xzN/Y5kgIoVTbOUMfaEHmPTVB8JshqPH/pxWN/csH7g9ps0RKOW0ltG5Ufq2zOuuEZpCC51YMlYkh+OTCBJKo4s/db9/LcGbOCu2yEDH5FjhAsUhdXNo0vWYZ16WK4NMzDFwJu71YMtnqRfJLPmQm+kjpO+k5lF+wcf8Apku3DZdHzzXvzNZfKEk9OXiG9Qy1H+B6+Vyuj1J65ohAwa7qrj2iE03OSpHhCI3qqokIRNBsABfYu/W7Zuu/E3cL9erGdn7gveWO6bXN/kvPvKnqlzlDeLM648RAfab1Fp+4v5J4nithGYfkNQNPSuK5jFq399dfby5dXF2/Pzb99cOnaxecU8HMLCQYYLviGxrLfTw60gOBvDMdvJVREM5uypxYE7c4JR42F7qGNuFfUtrdoG+7Kv6vH7jeJNJSHdu3qyUVwKahP/zutjx5vqKtAb20n8yCsq+P+Hxc4+/uXg6aMU1c72s6ODp8+crpK3rKqovNL4geNZZEliGqZ/B1KzB0cA7s8qKRjXa7juFK+LYLOLgkLd78irLfwSUlt/+fN/R8WFxN9/verqGrns+qy+2ldtpVsxGyikn7sWGgOFRwV85v4z0PLRQj9dvND7+7u7u3ah5T0r2yTdM//DD7D6O3B9kHe8QqICXPodXPodMB+oF0HJS0N/ro+fHR7swH/v0iW7+MkP7ZUkMvCtcBcNEmZG/noldqj7ld8O90oNi3vB9vG/yS+jcvq+Qtl/1Z/4X2CG78r2jqYRLto52N/f3u3vDZ6Vh/2dZ3vbh9v9Qbl/OBjc7B3uH93gm2jBZk0zbKuZ+zReKf5U+hB4WD2gNdlxV/cE98WTpsHb3gB1bjNBESiLrvO9jxuX7y16xblg1MPtFt2Nn6o0K/qYI/eUcLugOee3S4+kF6KGNfCLLHNX7ytYjZET7ldyLxqYuXu3JLWyRRR1Wzok0R1XCJU2awr7RYNfOHVHuB32Dp7tHG7zv8w84t4SriUs1qe03/QhmjD8IjqwveI0viwjGWQUcLQI+K7fdrjf8W2sY1ASbIFZhDH4LTiTu1vb+1vccbCHMKudzclYzWmKjVFsfYfdDSYzwL/sHmwf7jyVSZCskT8qHV9b4lkNpSheKkJq+RfvoMzlLob/KI1kixtqxiYZMdpc9LRhTcGL4vegujV7q2QrEjSXtDhNkFQt0n9qpQfihpk7Vjsy2qrjTZkjSnPT4ED00f89CsXIFb4Ap+zgEDM0x7u7md+v0GGN9kA6I/GTkd2MboIfLswPWjZYkLyie3ef5t6KCURwkOX0yYbyR+ygayv9E4Z5Zg3BVn+zd7BzeHBAwKLr+cMVWIG/2ZHjAbului+HrRdZ8Mf5BDzDAZ8Z3g7wYrCsiKKxJ7/20E7r5TfRUbSHUEi9kvs3CnmAMfSyWwvT5btcam3FdOcxs0sNM7T37NnixT7a3/6EuTzY3tt99jSdS3yPoxK4kpY4rOdgUvdgVmFLjvsPnzJ9eyBBTujuH3/yDg+sDuCcDbOVaN6Azuz5b897dJA7NUM0/Tv7y6Z/7+gTpn//CM7o9qOn/4gMjbr/SbMPa/cV3vzvZPJBeh0unftnnzj3B88eN/dszohhIvKEbT8YMr1HM8OoxukPPZblpMPwc/a8gaP0nj14Cah7cgngbLiUtZdioIa4TGmNTT9+564xllpYMXCKelRK6QZxkFxA1t8PMJanO8+eHiR2A3zdsAT3c9ZGtgL88Mr/kFt8+LDn3Mwdqwan0pnetypG732MWrJAEuoeqLseskuaplJZ66LLclpgXcgXLDAv9h5lXthJyZgUS6cmI9Fhwo+W7Or9w/2l2jt6dZe+Rnfo91U5RWS5+f0n1tO4xY72lupptuAO3Bz35Ef87SC23g7dB2P6Xa57pJg6gD+djL30o/QKE0U8IN9a44M3HmTdJvbXPirlzYNPnZmnO/HM/JCaK+wcPfWnGM0WJ/XNpsxJeRXFBJCF+yKBH+3Zv7uK3d1dbM7uHm3vf9Jc7x4eHT5WxVoxvcJ07z5zc/JznmWUOkt8hv1nnzzJyYZ+pC596vTaIh3Jms2q291Ib4FT3KGAVaDqwxkw1BP+Sfp+kZY3SN2HEeGewojo58PlozuSz7Y4MKxLa/+26v1gZ387DQscYvSRZyPYv/D3E/f3nMiEbz4V3/QeS/w8dwOSfrYEExGntSHS0imp/7xK/ykCBtuP0uhmHjIKfdlsHMGf3jTDSr9YvXYf94kovxyvC6eIfUflRKnASu0utgtADB4stQvCL/ibmQV7K7nvT589O1rRKtjXdVpoFBzo1/4cbIKd/cQmWG1anm1v765qEmBcSk8+hkcDs4CcQb+9E9PgaKlpEO7+v79lsERppZbByjP+SP+PQ1+xYbBkwnefdhkHP7N53lligaXGwcrz/EgDLLENDh/tZy9U83uL1fz+cjV/8HNR83vPniVqHjZfnyYzDFuCDn/z4nmXUoMxf9FOyvGXBCUWpChhQHzLoIFrv6Y5PtrHxMnew+y04lbpQVnlv/t45Y/fskD17z5K9bu5ySj+xTN0CCfyRdnWoC45or/BnPNcFUrHb+GsfEoM4NneUl1vB/3z0/SZg5/V9Lu8LAv1/B5/6c9By2c8/5Vl4cqO/97+Mi2vOznR8QdLdbzd6H9lbuLxnvvKc/Xo1MTuQYd+7poqrLDJa+dPmqGfjd++8hRnMmmf5rbHqhlTi3SmSRCCHOwxhZ6q6JzqVnHXrbr3F6vug+Wq+7BbdYv7vicD15//9jr9KNHpcIMMMti+8Ofv9M85rb7vovKzCvahIx5TFmTVWIguHVYfuSYG8YOY0kU0mwAsccfmvfmujZZX6DtboNPpQ3607L+fmYxKXzI/O0dP5QLt2xbqcKJy0M5uZt4IBYU4ujuY0Q9UKP9AsL3+XdO0FdUjfFGNvjyVh13q5H+xBX91s18i9eLtUMotqdYNfqbxhBdieQKTq326KbEcDBBM1s/Pllie82dbYk82xEJjYl++9d+7NZFkjzutiYNl1oQ7RYk5cbjUnAgO2d/dk/0JLZJM6GqJRXLYYZF0TvfuUZdJ8jOa5Z/UJtn/qWwSAop5be/MEDU3ysl/JBDECtk+3E0TCH4+Yy17qX/OadlD+J53XLdXt0GJpbQx61fYrV3i6cJzh0kE2o9IbzmHaQBZ7dubXLpwOl0jLK4ef0dspwaEh3QwyISi1MQ4t/MxVnCZ6oP56EezcXjrdNo4Tx9r4si0Z0ycPZjwlzgHz3Vj0LS8xM8pFiYydhGKpXfRrFhE4kahQuOrppnhgk2wLn7EhsptWY/NguHNWrBIb96gNaRqPBjbZvHOAx7JTiqV9tM1S3FJkg2TIdngJeYCNnlIx6j0sdcUv2LG+ha3lbyA8CifAKPcf7Y84RIcgL85bHJlCyojV1dGTeLo86hJtzVzke8OoGQgLv7u9sJPhK7cP0Jc4KeEMHLoyu5pPuwAVP68JnkphvLTsAc0yY8HeOxnMZTdc3yQh03+jKb4J0RKHuw/doYTk2y/M4PTbS3tLreW9n421hIo7wya0pW+xJBBU2OSjUvA3zgRI2jK++qaAZUuLuE3BZMn5yI2BVVyTcB6umPWdKJUaHnbbhTiAXNUXXPor5n9UBraLbYCBN70Y+A8jra2D7cczg3sps32Q2I27R/EdtN2ajKRunrqtVXWajKqqWMN/iog/mJzIX75T2wx7FMOfT+yGlY9+5kYw2pmg0MvlnPYmdNQ0trFycHpTuieGE0Xrdhfm7g4WFZB8+xTUP1YVHH0aLW/x7VovcdOFhJ4nU+b4m8xYbAXlk3Y00+dsAT88kgFs7P7V+AHo7iA8/+juMD+5zHUkFyDBYmOQ31SFEk4+nxZJOHpYt34bIUP3e5WjhJl//ulOhiER1ZrJwhPfn3EBl2xTmc5es6/+ieKg8OnosH7aTJ5/1muaKsTQsfOxDIInXgQf/9w+FEKoVvZE9hN7NRMPJz22t52t7z1+zKRtjsLpG24Yf9KWXu0XDl9sqx9POztMK/FuycKTZeffpJWUEifrMEfjz142hUhWTBNzzpDJJ84UT9ZTmXZfvzkGMn+wSOn+j90/7933X8g0ZeunP1X/OOqkmDl0MfSKK5/8c+rmI50/qqw+T2NbS1JgEtA6++v8fc+XePv7yWwgM5Cuo7AqtuJKwdWg+35d4/6PV0mmD+xNv1gf/+R4LBFWYLuWe7OEvyM5hlDP3s/mQbc/2sz3v+hAf9daUCiYIpftCvF5nZZSaAv/NIMabwhQnL0kC/k8pAcbNGD8ynjZ0+FHkxpa5g7HpOvM4pLqrhHDsjpzDWYd90YlecGYXHMP123v/wFd+v+QH0Rrx+i+Pa/vn4lTyZmdoxnT5qWaFP5z1qdwO/kRlT4VCJMrBVRQJ2LsFqxueESRZkkFE3MyDoiqICDI4zh8cj33m8mD+4mjML/8hcabL/jvkzEzue7qmojtyyvGapN25uim2BvcynHHTxDljTluNvp7e4XcDphkXcj7br/rEswOfozkEp7OzuGkpVl36rcZ0toLgJAw3YG6K/71+XXQuJVB0LpZLCz9wvSwGM7uRaT+oXKHrPQkgwgQbmbtHc0kZ7bNkf5ld7d2RcSu10kRM73IinHQnBKzTOZHpEajlH3JTwYvlM392xDdkrpL38/mV3RLVey95L+8dFLHH02dlm9peaKysLe1n+ivYyUfpxggUkZVB+JgnvY4NE8/+brpK1J+OiEhpgSWDNE1vLpzLQq3dxJe4WET/YNwfaw9TzI0QdsVjKdIT881RyTxPj9xdm7339tmDvj9zxd4T3SCIjnk/i7sOXKdfOx2CrANKkb+L/cBSZ4Ucd8yC4hlkvejHi8qJkYt133Ym5/8+nmbtL2nMZ9tMK4pUUcb6C+dtzDnoHUH44Jp2fY3ce0JGbsM2406qVge71pGwW6UejR/WDhf1XTD9TFdpTt20w0ujPfmscuYhkuFZ7EBCmd6eK8q60zkonwnP7jOWjyum95uKmrQ2nqsQewRUfYzJtw8djCEX5tZpmPyDS48CcIVNERaw1z53OFdo8lLSvsi0RH61q1spekQkoUPguAUpox+H7JksWF/T4fMldtCV+CncCQv5FkEZgW1LqXMU7ZmTvoaIHNc0ev7pc0Ve9OQd+SHqTeVyFeD+Fz1MLCKEr17PLvXfGtfDh+tNfGvSpd7+tFHcm4dR71C8Au0bjrueWINkOiBLdsWuqbxAKaNlt2GB1d8vTgumZ4sJ3OzLOp1EDqDpRDaT67eTq63jeSFfZO9qVxHzj/7dzLyTVeEN558+b8ZMY7R/vRSKtB6qsymbd3Yl+hucWdWSpFCIh1hWRPt0q1LbuerS8R4dw3bcaXx93lRPXRFsABbJVBH1/tHt0gtBA+ML8isRI+DY649H8gBxFhEdifIBWJL0FYFSf3FfW1gOGoQN3fPEKjLtxU19PmfcVdy3BniWadGnrjYqbKfT6ezK9h22FTbrQ/UmXbLZIummE9bP44fyguYDe6jpHB18d61rf8ldYH+DVadEID4GYd1HAHBq8Sa6A9k9BYl/af2U7CpYxTDORZaL2XpH+wiXxpVMvJFFyoD9WGtCXX8mMHfNFBuMZNyZstoThuSdu+jVRS0D4WNdhADarLu/noegz2lhhSOHL5SRo1Dfi86O/UHzw0GLkuGIxSPNpN0ivWn55xT6Sew7v6r3QtXKq+SsDsCzIPlvHq0WPfKml5NHKfICoq1X+BJePMIJpR043EW0otNgTa1mZbKsA6H0viP1l33+AApANsZCdCqE8RymSmlGbTRacHdhPP5dmYLQ8aUth4c+kRIhJEcWylN1LZkoLCDei6CRRI86tdZer+8Erb7ND7NtSehn3laNAthT7ud+9cPMbqeNtWJ+MHkj5CnJ075MuNXJhHnixcMPwSUmDSPwY/zC9xmxwu6f3Hm/6q37qezigpgh/rP1VXIlCrmV4Fm0OtyeqjdPhZMBumW5S2Fps9INV5wWEmeis28zza3MlM5e0QGwLjJ72sp9UN7N6//Pl/ldTB5XqIzVZgyWiRm0lFjRZI5MAyUy8A2EJ/+fN/v3gPIvplVQ3QZfrLn/8HPCE37R02evE7cN8uyEG1rSLUEL4ZYrtl9StlTwXKgScHd9aCA3rHPbx4CemDqKPlgBkc5ORW0vE5ObB0Pbk01SAzicaW9v14sWnABmhfcIg2CuR5b5ggYnTt+0qwnerKNTYL6jSI/wbjqVU027hHfSZM55oN7EEFsz/k9np0MQmLSVNzywTwLMr+HTdCcCLzNWyJsnhVX0/L6UOxLsPmiJIXMyO6ipGH8A/coHU7epKRo9rNHNUCHZfXtRgvKjnFMlRJIapeujAXo7KmBli5SR2bxvTJOX9ef6jVLkYF28xRcFdjMIzntC/Zbvv+X+bYbOPtWfGdX6FQMMD/ekeG6xhOtGvRzvEP50BL6sZatyDEKi2koXpg7EcBVkG/uqP2Wa3vf0qhCuobNJxRI6Tubbp4e8suBs0GczkWeUHsWdxKhuw+av4wwORbxXFG6aQKUhPjrvQ4udX1cxrwl5lxOYsYG8ySTUEzggT8tpOM98F06NIWCF/M+gf2ErYaywmE2FdV6/FMI9n4RTtgMoJvFvZr1d7etr8Tvj0UfUs1B93n+DJ5fjiIjTtIfuipTV65H+9AKvj5v65Im/WbW+xuzw1l5v271d6OGnVDFrYspjipZ88xnAQ6AHerbHLXkV7cADGSaW+wYMKLkS8WA5TZ2Y79zLdYsW2cfiPEpohvVhmm683ON1aNSUh70IyoeZ2Gei9fPY/b2LOLYA4u97OJXmWV2m9h5wyreIFNM3jWCyJ1tlXOYHxG7WyxJVjSk/PPgZ96Fhte8XDHsHFuq14foeAUMEHJoOGo0ELhZXiBZiaFribm/ATTHvvZ0gSbO+1gIBwGg90V0Vs28wIjNZO/0IA3LeUNkZ5xRlbzA2RK64GbU+2bTT//Z95yvWjL4bHH911NsYvo9MrJzPUnxc18zBfhIvxXuuy/eaGaDAaNFCVhwMQCpiS5uU8omJiAm8VmiQ7vuMTIXFG1/XJCk6o6i5W7hKHJ6FX/RjUECpzQsUePl0wyVm/IWwCSnowF1+MWm0CSd8ZSkXcGvktasNqePuuoGGxXLvSmqPluVVKbn7PnVrW+UJOPdTWpbppyqxPagkOjNiDwNWi52mgFrevUJa6p38ykmg4fEsnUqWdt59EwxF9H+QFy7Vd+7qCmDtu+PPI/30+uJHqx9KlmBJJOo2cOq9uy/6DbmNtcUepZ97MuPQky67e0D2CFfFQbWhQZSLQJCLV/ff0qGQAc2noytz2bUO1iEB+Dbt75E3dhVL4X8UMNFdt6VA9L0m3e88nY9Y4dS4Ju2mwcLYCWbT/sPcdiDhONptc7DeLiPXrC8eZOOsbxHjaJyZzByS+w2xiTTcljYb/gspG/KYqKhSNtUdca3ltu1FSd/rwr4crkmXReNORizg0OwEUi7cjI9zcNgiOBnI84qsJptc0ma57sE+LwYSJnqfOaHLw2I5vVf+cJgM+DOeGIt8T80oiaTpINpuUXlfd0Im4ph4DaGLfTjXQcTHY2de+NDW9nXqXpEZdGp5O8aJvJLMiZiLwuMTHQJ7iuuMkc5smMtxXGKLNLCCO+owfroJwdmXlGViubGJ8cfzLesXWcy6CCnVhOnFZTk15mPXAA6sBhSKN/pDY553eFcv7qTzUJwao4OT+TWG7HXTf1mGKgV2zaXJHpesXxSLy5FL2LVhGCQ0rOY+LkaFq7D7JoExRVf9P1jqIGXyBr3lezrZ2jpzup6DX+OfWErPty8iiBXHNyH21YJguiHU7ypUdpT9h28Ost9+dLHi7tuNogW2fdlkTWuuSYN4mda+OkQNemZEk6JvthGLqxlyhSviZLzzmyLrRIuUBqBklSfczNm2nlxUjG0KPLRXW8Hu57c/nKxV1bGQ/FG7i/NDvMdBoQ9zHEd9KE9jE1MdSrmnEg/Fxec+FhTCwKWrAH16ZYLWnXXGnBs4z8NSdakR5RB3W1Sq45RBs/Nmh6bZqaCnLKqYF8tMdm2VFp+M7x1O12MqxCI564pu+qB9fIm2dbXkI5F1KynPHCOdtCxbpFX7xQy8QCis+uTwoYKZXa5GqmNMUdRnf/8uf/+dLZApI9/cuf/1cyB6F8QOFxRYsq8Ad7QhfIl7ORswMYERX4CH6tW887IdOZPMqkNjAPZe8VLQB7Fy7l4xYdVX6EiARpHOoCHdiac1j3Z63LD/rjaQjEH2CLY7FvRbZCOkAV97C45MhR7ILPvRxHGS5tKRdi5eZlYDDBqzgx186vR+xdYgdIkkYsKT/ULjKDf8Td0zmKJpdU1U1gD1kznI/GCMixCfNZgy8fM/KGzL87Acf0xZsJ0y3FonHkEzUEEmsbQ42HvthHc8xgq5IzLEEgPucgCu9JFcnA8UKH9nBfG1j9JwgMwD0uyYuNAqyzsXzwg0MAeNiPqAB52KKdKES0ZRBSzumK7jutuF1480LvOnac6anGac74o9TJXp/0DeM40izcN9T9XP6egavAIr2jbQO3SL070w6Z7R/MvYIQTd/okiOBmOwiWGFL4pN0IOw+/B58zTelVMEb8wmenB9Tt4zTEdDJM72rZRuq5pbIgU4ITjoy3cx6NjHY5l9+SioV34hZaNqiHLds9eVORZDWbfmsY+bE79p29jDM4YNSU9xFVjI6SFxSpj3847yZMa2Tc3sk1s2/ZN4mh/UOLscAanlLY73bCR5yt5u5U/J6IFirMXEhuDxh5uLzby990tj3R+6w/b0Jxw4QySXvBEmSl8AuDsMjJgKHlukJvRQTsOitY91+OJlzdLnpL0gSGfabSBOQHCJQo4XNgrZE9dlmchWJM83AJl6JVqMcktWCRZlib4w7su6wJ3pFgP6BFLXhrQzrafjKpXYct9r0HrKeiBOQkMXXQ9zaPgTizjTKUw6DgHKl/ABGceEju76PMWgONKc4Lg4LK4oajgzY+IPatwx34eG2poAeXfEJr7C387A57xLZbF5VRGPCW+bdq7fw1Wg98ITfPUzucE3d3oAZEwUUvm/RqjkEInVFYexIuOPkc8j0AaGXGFj5R+oRQnXBvhPFSKYmWxeBHxc+0xpsqMQD8KSQ4jqJInvOzRv4xJEKMubxdmIgv2FAN8Vjj4vd7Z3D3vZ+D4FancOrYxxDQLiSeelqr9yxac4P5QidLtaMp2bBXOBd3F9OhSQWQDpGsa42Iot1cfzKPU9NKD7804rKNXD6g4AjmhZq3SQm5ZIgzbSltKVESHnjOAQZQvbVlkVNLUF0icRN5l3OLrtkdIpSIS+A1ORWOAM4YwOncjvDAqLgV1EPWj0laXqUuBrN2tl8xvnGZ5s7fgbo8NAbW0TDUvMidTrSwB6FTzkbYZoYLdzEXNAA3oQLnLrD5GpTKMI0AsvBGI+Yw+oNqglaj0b8+6MtCbysg5YuToxKl+k2gshtKQI0BxmwS/1pUbxl1dfghk1f4f0KcdCyCTdavPw5HwQHfa+3/TQe5/fgT7CdiucWVwbVDXXgTEyEBeEldU5D3zQDZ8TN4q1HMNims+sKlen35ccCz1qaE6AB0HEb1uhxwl7Z3TazuVhFDCWTAxaXC4ikQViusgDPivOt0wq8Qqp+gFvSFyTQvrrPQamlRkjyKHB0YSuzz8xel+BwQottxv3VjIURmPp5lFRavkDFSyIXpaZEz7xYFgyh4Vm4bmb4mSLwUJ4uNMs435HMTSr8BITkjbYLLpxg6SYrwt0WGJ1ALrWPUKkv/SbZXh11Lur+w5fMxxhtHNjyDSnb0DoODX8gQMAlFkFBLAdb+WlOZrlxRdB0kpaBKh+tkVJtZMXDCkbAbg/LSXRQ31T3x17AkXQi33e9b8ubODomV9l87uvye8TYitoh/ALlOLWnbyfOVupiOJSSevkmzpK6+mws0L5z4XZ0c9GKu4KTPENPF8UP/A3/eYVgCPK3G79BlsNpkxAJQTqrnNutoaEW3rJB/0BTxAyD0t1hcIAfj0jEuKSrf3Ml0MgrXIsrkl9XzZgyIEHOV0ArhFeh8kuOd2BEylQc0QGjx8KuNY+0GAZbYFF+aED+yA43yCiWo1gRVU0R12YlwML4KOj2+ubBwMVMImnDHPcQ8M0wTTYncf9VIK78nC+OZbn6Ay84cwbL6fklN6/k8Dg+nawLOqcPmkNhJLtU84zn5v5zmNlGfCpBUQfPc0Ye+stSAZtagg6kAY5Iw+ESxTLEYSBwNTX25fC28GcYGoZb9BfNpdNzPlCA9Y4g9wkWHXFB99PGiy88DtSrW3KgE29sJbrULgFtmf5Q0kaE8gPn3sMEFcdB8gEE3e2wuabatGrsmoqV/Cvob1SSHDeFkw3fEEVgznV2CBPDgCcp82pt9AlzhNbugV181wxcx86hDrWLezopSiu0oIA/jo1mVqFB4NQiXsbtnMBvdJ/b3KQBp2I+yUglrnzJWST63xhGocmsb++wVGrCu7zmczhoYMPY0lXOU/PVdnlefKT8Ep1i3+hk5MoqBEsvm8/FNeTwp0aUFla0YT4C1QehfHFUXHEdmGVOFXtUx4DN+aDOkmSE3Vz0JIaMoaBMx3P9wDDluTNCCHjbMihxVFKyGquQoifj9p9g6ZyrMjMgT14HAkJZPCLuk2MNLrH5aPdRi1k+dqJNqgtfrlnHdoYHHp4bwz7xEd+gL2SGJGlQBdQ142B0rTvqsl/qlutsGgppFN/4fUbSEzk2aMmwXh9hnsU3/7jjr7H7mfHW9N3RMONiaMbWbEnBv4be6tDCLG2KmYQRGTLEiSAOf4m+8rVPIRm75mmuBi0ybQ56O7u97aPUX8mCUi3m0po6QX3gEsQXP8yAufbtU1FVmJ7AXXUUjGUw1RG23tZV2SKIQaMLpF7IvCaRB7eQWWKsEW+s1Zn8LU3n0nARTOdOb+dpPOqMrYKu5JWUg3DOx7+8K0iGY1hqrPIQTEGdZoo8glr1FCOp0ytP4fTDz8FlT3ODiYtm8oPZ3rUGrSSEQAldodK5IgNY/0UqPwtRW/IVhzCa3AiPElRPbozbvd3E8yfRxAhriVOwH2TBa/UNH4s6UwnuvrSdk49YTqdgkaDMpf8YVVNO5bLdOGxIUnGwruNLVjnM8CXb8e4jyS+aD8+AHlYqrxb539i/tgWobnS1p5xSFQhrflgrDWonmd4ymlyXB0PDLetLR3dgXRGMt6U6pbAyHk92rm6B18pX0yKLFy1S8QW++kusSputP/lii/6FayUHl3++n4zgd52mK07HSRmb3POYDXvEwow9OHD45/1Ky7jJTnEwuvOz7MwfrrK1t5/1dp8tmcmwUjMo1Fy2CIqDl/PA1DFjrZqwEYFo6CvsZRz6sm1zW82uBB4Z+GUtA7D83LPCyJ+suORk+Vjc2Ybvhr1mZDsrYzJpnF9h5ph+uAJb52oSVsNm4NwE1MksANmjdD1N93V1gwjiufTagyNN3D2Ng2J8P8dL+ejfcSUFpfaxGKCjljIj9zhYw1ktt7zVUEv8CQigp9AhV321Atpg+YABVVrdV9Rr6C1a+4K1qaQuxKZLGPLDBXLwE/kTy4Yfy5Ng6eP6l/zSbycpp+gdtvjb6QZZVGcnSoD3ZsaWrtiqy4b/6Ee3TOaU/dy47qTjc3f+fp9Lx/bkdyf/qnDVdbDcfP3CQGM/VG1nf+IekkGMdKOoZv1N+l8JQQzORgz6zs3G097estmQ7JPPPYl/wdS/nNiH86Gxb/rrIgtvFan+tLeb2Oydx9ZkxV588MWf9N/FKZJsDkoB8GKenMG6Mlxh0Fs03lVEOYz3YKXx7nK6DNbYzGfutSu91MZss/QKsmtsXJUB0pxUZcpDx+hwns2/JowNZCaSS6xYQkJ8i5/M33Weq0/OPo8yLc2NZFVnWBs2tTmiICZMygGc/OSh6kY7c68Mbkzjgi75gJk2VVTiV2t4yjr4TfJ1GqDKY+jGgoZUph/iDgk+RRUN+eHj2bTOzH1pQ8F/+fP/JNcKk231rXJ7Xa2je/UkF0ZW/F2/cQAxIn2iBHzLGxTjEorYzyyW6nWHM8envK8e0PVEU3OhZ2q+2YMf/d8ubXK1681ybPTVGnp0OUtdpHOXrMzYqPIs4hWZRZg5LV9zWYY4vmesmCgYjjUj4xaLxcb9/Oqxa5Jde/cs1TYEvGY3C4uc6CJq8btAp7DBgEtgM4jKeiHbWfNlFtfKxcIbtsAKpSIZKDJGgYVh0T3YPuH4FUyuYNSVhhj2ECrCY5yVmYwfxs3pAQIOUH51SxnWqxpWtDUbPER454djSygJaEARS8pC0DZ21RammGX5OgxJ6Jk6SNaTwRYlVgVKQa57ssXRkMpQqNlkuzVrJnV/i2MnVHpKXIwB0qPdepIZjcvCNze2rNawslAxVEIGEFHEaEH5C9ojUQabQGPZvQAzmNk+1igGf8Vv+2rMsUmYe2wbuRF3gARpd/n78xcXV28vXlxdXP7+1dk3X1+9eH52+e0bTKHhyQNlwQ23qXcUyMTNyd0klmPOO063n/kWL58Mi6MTUHnL/jU9dlRO31czLsEVUjcViwpOruCy31bDyT+5DF15HUw/Qpr8/GN5wDfVfaiUuBpxOLRjkQyMk0EPmTU148AEco8DsqE4NbddgjbGjDno45HyWrA5FeNzwk1wPlUds1FQdsKTwWK2wtDsoU8HMnfe56qzO6+J84/uBnWr1gmItxCKkYMIm8JQBKfCNhSpjxOESpYv+EomOx+UOFop4gyG2fYia9BAun57SREbyzGRf+0KkVl8bVIe+de9doVg7E/w1tVs3+29+K1hkAyPxrvzYh+rX32Fa0Cia1Q1jc2VXHF5AgGgo/xsMNAVYoPbR73dZQ4W7sCvJSt0QXTQcGzhrE7rcph/8SoRnaMgUro0WrefidYRGY7LDrHNgzmMef9OCpddQO/f8zBXCZIc9XaWOXihQPzaI+ZsKRHmLNdJ4T3hmpEWa1JTpcoEqkWWjzkwE/xDkLSlJ1YDHYEePaSnFWS96/ntVu77V4maHPW2nz1imXZy71klHnGYcaRzwVwy5U+GQ2OcU2qN+jxjZC7jeqw0n1zlinqohw/sgUXRI0+OGQmyE7hKRAM+LBBYpIeyn+Z8NG/TSoBxElvxmdiksAD5Lw0KnaU6S76VjFvdK82shyl+EEK97OqtovjgI5eFEp3ddnb66uri7PLF+ZsXFxdX3714c3H27TcrDZsbB+wc9XhJengE0GREyn5+eI/498AxoEdcyeb8a6efsBqCO3Em7Y8xz2h3OSi1oDUsKaqKvN+HFrLATca+rOL+rqELygHWhOBGIYQOHtb0NGxEZm5t/mRAx8ayf42K++sAV223yEobxIpRHw+icILClgzmO4ovcFjBRRksg9sqZxuPC//Wq7HzBKPBBr2618dNw75jDxQwbB+45vqhh8SOt830AUUrDKQHz8a8HJgHW7nPcFwKhMAL8Jpc+dVqfYqGmFZxPxJj5Xo+fK+lmRoQmTXZtbNVEI98jmUn//Sn+M21+CkUFXSsvRw3wawyRxg4sKGTptWP6K9ncG+h3+ordX38LgCmh2RtwYA8uaegsrMRrVWWzAz7xcd+NZ3MQvEiG/3UhRfbBdFTi7PgQnfusTwqP17d14PZXRgN0WpORoSSFKPQMIkFDnDQXYQ3I0BjV+2MH4JhiySSiwfB89EslMzZumSn43ldeFzlyb3+ZNaTR/bwkb2y7XHUzh5CTwgmK95knPvgw1z5aQbdfSqUz7IuhvOqJdYphp62NSakWNYvi2XFY4nFb9A/IjEi/aClSL+ZjuC/CVavigsU0p/8eaDElI0CwUF6RC7UMz+G68e04C8tCUmyaTfk7VzWa3ZsGNnYcAEnxJwZY86cZfwpCoRsFiuIeiV57LHuBfmOivca/otN1x6NEET+tJ31MB63tWRmqHikN0S9KyAMVyR7P2WaErruvFjHpDmo7sndE3YrZ+XtCiP2L+hhRJLNBdBSUzBEGefXcw/uYYlzMuJgvIqBpBGaJjrUtANjX5LQSI5IR1ojyy1bCkxYI1/3FOoJgNtY2TuajwTFhyLd1EEpXYOwSRIuMGNZHOL/W826SIjWcyaepswdggGMiNV2ldbr94Skg7uY3T+09f3DLfoKGf8AR7+Ki3kQeMKZ0b8d98s5In7fVBRM61cv0DE5pqVCOSaNB8Qa3lwuYcew0eDW3i05cQ89pqrtzafwx1nHp6ziLR5kqlj1U5hhZUs4V0ihnl8GdFmdoSF8/SpO5H4mexzKYm7thVV5SPUMR0E8WYoEnnPc8jxfbHe4IjBpf9lmfIluBAtSVtCCYWGgtULgq4GnMj43eQQ8q6vYvDu9Q/h/bVWNWmwudw2n7D13I1MJQ1axEF3CgeyV455xWDp2wSre4H4mRhfMgNoJrrg4Lh7LT/9qr+7cgBEer0MmEIo2Rt6tcKSISLqHT+vh48jfY161mZMXEqRRscGO4fctxxkSsc5YRSmRkW8QntoVej45xxU3E/XGULKMpVtn0hDhIxhdZBXIOGts8tW/6c1HPUrxJI6QhR+Q0+MOeKPkckwKHkcqOgdSj8t+f45sxE7uisbhzav1E6K6eiWajMm4bAbA20WJisvi/2Rjnl5cGEoLimMLJQ46GJq7FVRpy52EfGGUqxFZVKVErFGCE6fuIPg3OSe2JnTRM9pqBmNybDXogKLX6ml2VomDDQY9sWx78ENPC8Su+tcmzqhw/0WbAL8I7aADW+AVEe3ag9+RbA0F+PklMwOtFtMjWw+tPNwYLQwex87397jwtTdFLswZikiBkvDv6YfJuXOuAa8I7+rW+UWYUxbzWAAzylNN32uQZfAF5MhNplfwPrCmWs5oM9sCYalh3dWxxoOTu5yuRmpUyeitMCt31XBC38s+0bxu73rO4e3RF1FIOaEZWHjiBaYWeGIG5FATksaWCBqXc/GaSxYphOLSK9H9wH9vFt86PMii6k2OLhhm4hSgEWWzk5Fp6U03iAj+/22SA7gXMGh/aGaJuVrQo8vqu7RHV07j7fZ2kzScD89PiLYJ2XcZTLx4ptVb40ikUoC4KXmDcUffJgYElUJtBU+iIUytGliuNTlN02P+2R6192Bt2MPMTT2trpCRsMcV+j1sy4FyXn4b9LiMld56ZXanpinms9GVNHgQrc6MV75iP0q/2U4OeUN0FYN+N1umUo9DHPQGhSDQ9pTjMGX6OEfrw1WabCJSdRZVNM9rqn0rh5lkpjmPRKSXcnY0WUQ2ncGVDINIIvQGTdWC+YgjM4iVitCYPSG9wniq/KVqKVTebEmIQEwZLETm/1yXOihaWPneK/yWq3p8FQxaALIbWjl1dcXVd1c0NfLrk7T1ZYT4xfAljmRYWoxvfprygTnfh8x1ldXd5XAfjh13Ph2uZPhw8MLm9OqWTErkUMAjwFcgC3APP6TnAPttIqVNCNPUL2yE1bYiPd1XUMEgIdM0Bu8mR4mQSL6R9FrBOoYT3tOcOtkV6V5i50QU3rKwjBJiBwpHvolNPT4yhoMlQ8JLQQxVURrMYExXqMm4gQsCiAi8pDRui7BY7OvB9IDBiVnY82njkDHLTxpd2NOHJbPhKoe1KD4RL5sMgtiBK7CioEKXl4wV/JSb8j1HhdByaCchN0NGMWjzHBNi9QXM7MetsAlkP+OdaFWCXJiAsYy9gEE6eKFe004xn+yQXESOgyYgMbbSPy4dJIrZQoh1Pu5vBjNBVHPF27OFn+mZgJF7kiWvKx62LIWm7eJ6dbtZvMSozN2TFRY2MDLVBiXW0NwH69Z0ZzDYlLddGbkVgjX7VE2ZYu0DPhJlXOo/xDRQpi0B5SGtXSe9MbX5NhlsLpQREn746OPbM6d7Y5RibmQqtmwzK4XUiLxTHHG2C50HN3Kfqw3H0BhletpV9rUMIhTYqhrR+yB0eo/6WPSEHgUtcMlP9zBWs7u1/EWcwnSv84llNpF7xt/Zxudj5lK/OBWowYRiPxJtmcmx49ndFL0WaV83ZMwsN99qWJsJMyARDS4fPAIqksQ9tZTu3aEuqDX8ZKKpbrBEeWO6pGhqazBgRoSvm+aWMJ4Tn1fzqXWTAWNmlDERBzQEBqTsrPFUShD0E42Su8Dv0nwcJ0KdjULEKovScWx5MOGTGoGRvcFsYWqhlJ1Rso4lZQpElPjEU8MJATFGHVEATybSRVILNF1JFGLgD46pqXD9p2oTt1Af5v/uj7SyIJ+w5Ui7dbT3bG/7cKcn/d1hrQcN+7FbO0+fHRxuHxwcbiHrAtXnrLjD8TyIZ0BxyxbEJTId9jC/TigK2jo9vfqgd7TMXvAZXabma4I6EE64OaEQQTz++ok42tl5urO794iJIGACxmJQoQWCZalppFrMEBErz6an8r+haNW49wKUWt3eBc0cftQtcAQf/2zbfflqyVKXGpWyH+xPN6P+c+4DMmksm8FiF4rTkZ7WMHk+6aUySYYlJ4saGVJE8NvLry8oHqj5UQ5jgPlcrgYKumnmIKORPrm9qypwiuhk9vj09WB/Kxp12VQpQYqhwwwYfD/Yw7yC9mIlJeqkygNdTPrfswYY3auEXVNC2AT9JJDoZI4sORr/4jY7koBgzyRFoEQ27fJzgxakpDnA9g5gV+wo8dB6/VmqZTL4XBJCE2wTMv0Rj8WzHTgThwc7qx4LNkg15AJfz5vOu3Qx6VYegue9P+/8BcVuZMupn+dKqz9UCVXO+ZQ8eon8tVW2UYl9XxO+zYrYxdAt+UVzEUEGC/NaVc8lnl3fFf3dLH4mnjt4wJ68fVvCDn//WAh91haya8F+vfVFdNjIwgBCVgync2ZC3tbj1/Q+9uQ19JYevAUVWtnDipCcJxCYBzKn4L9xGIWcHpA3/bqtgvD4YlfE8ZCSoXhdYdaKkMPNDcfLcUQT0pvowEozuOX6R9lZQ34nErVqjWI5v/tdeTmynszSvO8+kYPs5aSVevQY1Wjfm3704/aeiP0pG1i08+mHilFmN9LYV9RLPeWsrAe08Pp3+Si2/EFb6Fk6oVvuN/A/2kA5E9WjxJWdo0QdWFiTWWDGyl42Owf0wp55GR6KHjcV6EnDDkrrTNjaGGM9Ug0agM7nopV2Hyik0OYVzKEJnzkL2su4riAOS/vYL1NNZV7mj7p+lbzS2ofoXS37FN4cfuTavGc+xiZRnNDhCAAKyYRS1kRGFn/mKlPKBwb7H7iYCzOp8tCuK+bWI4t/IHQS1MRaeilx4AIvaZ0Ss2bCKt4aD6q3K04lm+NmFh1VCL0AAdd9Kc56X10JE5/jLXHq9H4yuD4+RlYkvC7X/6N7VgJLwdkFCwiqJ+hek1BnO9C7UlTq0zPckstdq2hANKVsF0hNsnjDbH1xd+bKQeXIpkPS1tVsRHw6P7zXb9uePq0H+30yvwaBnJOUS8Ep+8RXkLLmgBONfEPoz3OWPb7C8WJoY15DB+gAFYkNgyEFroUP+SJzY1+a6eKxJ9gOjK/elNhn8eH4mEM4+Cda4eA3+QT6UZobNdLNrH1o0SpLnelm/DBqwGR12zhQc4Li4HOVzJhbwM1+S1yKtbQwZ8vfHUvZQgi5mCROh/Z4DefdqyE395kpffSEZvP3oO+npUtCG+KoavRlgjz5Ygv+ysyMvpOUWFchOGVR5kpiygmftPt2anfm2pxQT5PhHNtZZukEUgYLNqORuXvds01gdTn+7clCPJJ7qvZHUk7DwPwNyXs6mfJMJp+ofNlB6iDzFdS2uZDxBCQTt/JOgDRmolYufypdEkgjPT44hESnjfZOdx1Rd/Jc6zoB2DPate2qhhNkv5zWFTna/Gu+qY7sbe63picKzEE+hkTT0EzL6YP0zcV20YJvpNmoKLbHnc4wgTGpxsToDFdjgQgMIa9RwhcqAUL+ZTfz4dDBeTqpDoTiUlm4bfvlhUgWORiIziFHfUaVD8xGS5wNIDcPNrtgbNqgzQUknPbBD/IbGu1WknG4no5eJQtYD598Kylx/HhHZ854lPfVQ6sBYe6V7PNPWa0ZPpkTaOytUP03Zp9uYK959tCG/0h0BQmIwzlDMvNs7pieXY5gGY22IRthcuhLvamLJUCWzmVcCJshgP++aZZjWg+F2Zg88EQd5WlZk30vjSuZgJk6XT6YWGSIRREARhiW9J3wuP4vZhjW+n/49poCFFvzsftvLl+gk1AN4uy2sptwN2n4wO+T3gX68P93dQ1qYVhf09mhqIGkT3A/KMGfTIxcZskG7qvyvSzIlhzMqLIRNfPsjlH2mKTlBiIjGTkuYrzXOpoa+8vejrFchbCf9DSmctPBJs2IrZyzXG3SLBdnsg43j68JiZ8iy6spTl1RU6VRzgd1s8EiGecTebpVkaba/SApuhObpW9TXxQkuuLmaCmpvv/Vq5yP9FnrcE6nsEVxqqZP/utig1WcnC17z39LhK9Emdv57S3RQNYsl9zf61kmma4+MVE7hE0TSYc3qx3BTKKXo5beh6gFYMl1CVmi41R+B57fZnGBO7bGVi4ywZ4DSIWkU+4G8Y3U21PUPZlW9dQnoHglx6zFA+xHSqpawbR57LAvgVvI8BIAQRarMEfKE068tmi6qT9aE6dnoHHipoLK1vxEri+EHOXyg4UasJU1cui+rB9N98ioYqdc18A/aJlyrgeq58KwJsO0+FM+YBPhm7IbvtgG8TBKWmiApEZYXokrOW0mVOj63gXPn20LeiljLasA7oMP+J5CFA7RJh2ywtXMlJUFHQ9oiy7ksd7DLkOZyNxB4mKcKAEDMl4SJS2T88ylmtmQCuPmrwWkOHj8eLoEhVKs4wCQGICJf9jsSM9I3uzxBKQRooYnln9uvHWUbkR5EGr3KaLwDB6C0aq5yYxxhc5rkPTtGPXPUM14p6vZgWVMmPugxFj3ThRZqiyYBvPKdc9LnQZpgSdtivxZlP/SwnMWth3q7gIxZMETVB54cn+hpperuoTPyQDJXnGlSSLStCD2LZwWc714CoRKNvA2aa9gMu7sS1kz4Qy/DPlFBgXzUL14/dWL589fPL96++aVpzEgS4qMcHyP98HdPkC7IWoIymgEPAQJngsnhPSQoqOiKWaBHy6H+EPJs7y1qqWuM6Ees82KwlZFZP+RLdl1uNKIG32S1ny6RoxxdwTac51HNv9UCypSaN9P9Rr1Pf7KN5Bos+0CPvF5aNRk7mgd/yZYhdWMcSSZ3SsPIbI1LBvhJ6D16iqeBeQ0mV9fo/ElUeTBFIabUapcRur9HwVxxpca4K5HAmsjA8b9ZAVfjFQ7BQ1NRh/b1lF2lKuQQRHUfyK3lOSCvSZ4dpw7kvMhb5DEheGaxmTXg1tMqfeIPxSu7PupwdpMoooA4wwfzbQRcfbT+bdUvp0EEhAERU1RXOvVxO5IBYbsEekoSZKU8hNcqywqSmM6cpF3OJKAJQW0XBc2lf/4Hdb5lVqWrPgSnEba9ZBVcdmlLZzhwsFnwd9Sv1nhcDPEYfHNcJxnldbEUS60HOIku0+Jb7CBJFlDa8TqTBFKKKfXYI+j60P8MrJDdJd70nTiILMFhIl+Nd3S3+1dnhanz78p7jgDTbubohyIscuEKn53YT3HCRjRqAXHfaOC1E5k1DnsrhumiuCOTrhaufMSZxA0zhWcOdIhFMoW8ohpcVdRQ6JaVh++OFFK/BCdcPzqOtlFlrQACaZ9W77cYOOUgQcKEkgRhJ/l8KRov4sQTD8Q/s9Ypzn5kTXJHE13cYoV9Ry/TzaZu+g79OO7fz5Bt7/75xdqYJAnGF/3Vk0Fr8FlhwrfAl2huzN/+DDZfY+RwdDoxvmXZ3G8I9njOYvximMKwjFt97jHC8f3eUQRWTgT9q36IGgmbttwvg4j/JgAg58QWkwCic9KkvsPWlApuYX2lfLt2alpUhLx8VkZ+wUPVYlbcnybvI16D6jrcMUu0Mn5GQV4ORN5RS+lKD+1c/CRYmm/FZ8E0j8k/Yx8ImgAKBqknB9aUyN7N3vKZOKyAcnMIRzOnNQZ+Whu9pnR8cCPwxiy+bvscwWqVwybPtYaaNzCgorct+Av2Se6jK3rTmIb2LfMwUrM5rJZ9TptCopblgWWvqtuVa3kv0EAsq7dtRYWuNgytyWkT80v21g+OZwOuu3ScAS/ds2gXH6DiuayD3Vtzc0DMN7CdBAtG3if/ApnTJjDIUkmrnp2O3FK0RUD65r6H9nW7HKHbU8Fv17foGsiGHxdrxDVlvHasdyP3H2XeuaBGYRDtzMmxl/uXOqh7TBtR+XHYTW+ZZYlHGi3NaUlq+RjtGxba0CJQ8CKkmvVp8NcFgWkrb2VzS0H/t0M9vUtcbxwflpc41sXKSQFQcdYtQUXRmFQ4ex58uyw6ol6tMbBPbXy5b8LjIYTG6U2CGTHNVk4oaOUuLzauVJYgN58GzrVo0VONTMk2bkiJ8YBXTpvtLUzj7jfNcOQwMWfqmmjwDZpf4iTu+S2ql14tTAv2/c87vIlz7cnd1Q+cOjF8Rd0JRtiD+07ag+5s7kX2gz+ZWh5cIS5WCdj5uu3ZxvStoeqxdRMprIml2Dd8PmUGlNWs+iMP4kVr2zA+XSYt8DPvP3XceusnIJNnL8boz3Ze08w8Vm3HNoPz7P0lLQ2BcgUxY9kNE/qDcgJFHsZjJsWJlHTrRSBZ8dXud/wEpBdZnLU9p+Pe+MKZSUmD+RQiqTkxMJbAgIIp0jwoR526p0LFDDUwMYeGutKGH82aI8QNfIl6i3eiqkDMK0RcGMlRGTkxrdQaygdrbQIWmSoeBfbeBu/u/CXPSfwiZXBqFrdK9Yl+E+XSUjGzP2pP4iqsllnBhEUMUf9baTj24dx/27ajDXIy9MWw2BM623UHmqvrHdYBhuByQDDGPO74QcGn5AyJDPZ/PhklZXBQfc6bMl0X1+W15h+5TRrKmTiUE36AM9Emn8Zz5QFurSS7QJXMH+L8BVopNUdhOTCN1WJ4DvweVEpLbhw3FzBRpk1feRNCJhOQErlNctzbk3I84pL/tz2KvRXf8WRDokU4yPpQu6syLsy+2jOXLdJOvzE7WPxdqSiocxsTTxlrHF5q2jr3cBnzA7BHAiNnqD5gerTOaZiIZICVnRFNNjwYZ2P8npDILRjl3uNP1zjti+F1aVs26Zf8+bhT9Vx1WPhLouH87uLYN0krm7kW96xCQibOThvom3c5wvWzAr0D9wnQhlonHJrNZQyQJgYxzUSCcnDcmpeSjdnmjvOBPXOjdS3cViQfmo/g+M9H2L0HyaB43deQZtjvbu50xGoSbujDagSU+eC+hQRuTt4IqMkKyG0gmxFM7yy+tivEAi1Xazjnkhk2LS8/40koGbTuStOohPNT6CSXdlLM/U0FiBcbbjfoxUEVjoEwTwPI3iWdUB/FsCwB8rjiuqz7AuSz6kmCLmZOn97PCiyQCV7lMKlyYfH0+zryenLDW2x5vqqEfTc0Duy9yIwGsouOkyhAlOWlTm9axph6KsKalLesqaSh2HzR27kiojGjKxKV2XJC9vEDfRg30b83nQBo4ew10OGnuoFaSSx5MbE01Oapw9X7qf0Ec6T4Q1gAkSINfdxkj63s1oyBjjkD1hHhf83SHcveLF7HQrbyrQDw509yAa+7b7LanoKyZOynkoHDunHZLZ4LMKZqcRX9i65PIhH6h7xGAnPRZCN/auR0HDDOktrqvVy7giHnePJ38qHPWHhsf6LS0q4HkyZCp5nXNGo7fGofF9h8VIVV6cYPDRnuzPc1VjDoM154rV2EU1aA3Fw0t2acTlaAgeNrq/guazR4b+l05pzgxI9Ci7gBfd1U8h7KuzGflsYnxD2IEIsZlk4vLv72w6QcHwduTcExacKXxy+dQ0S8WK6k2HEvRxrd1iYnQyn8XMGjQc/C7dx/BIGRapV5Mk0XIs3rWB+xI25LC4dBuYRSU8qWOWJ8x/YFBbZQIaIQekc5J+XTzGJzq1GasghzzEBcDAHRN298HPYc8J/LjrbWpkb0JJI2f8HcHsN/iIaXF4hhllChCGem++LBKQBe0k0bCo8SQ1TQFRjYYnEEDH3Lm+b7HCWekQuJYdadlYlCUMeFzp5PHt3gkByPkESUEIl0I4w9k1+Mt51O0Ssmn3sBfiprAg0EkSDjb9gO9k7iJCEadQoFRaTYtm8OdxKFuobAjjqa7Xt7amNHihJiGxM6sLMmx92puHJdhY10MqEhxo3d3e8wcMm7bp8WQWeCXVbGGHVhwUeLrjrPKYQ8VSgtw3VHMFBv73LNVvtwjowREILelWA8GwYQqj8ff1mPp4FvlFjivDiOy9mnPLrajssf/eVgBseBqc8Wa1FdieIbuOLYrMU8h7Fk9y2yQcLns0tcU5MtIEt7M/QBi+IhtHRZUTYa2nqInOjte/L20tjkzklQ0DkE2+PnMmhNatCsZZW5OUfLnh36rZOmXUneqoUo5AKqdthc42BwiE42CyGsACOSU6HqSUhgRlUxEFUdIHxkb4T08QnF6dnZxEKBanD8BOSfLH14/ABF5NyXLd3G0LstVF8XaE7vAEG1HQ2vwV/qtoozmagZrDpDnzU8zkIyU8Qp26dtzefZcBQqlm+BwtJOt+ikgkpRidmCaLn5RVaSWyHQkDgzfqEgSj7zKVaKSlJC0WS4u98Z0gy3uIlIdsZg4ZDjGHic6ndjOf98u3QTc28p4BtplaygJYZISxqYCrWWZ9gbiL3nftZSwVP+Q0VWmc6A/JtXVPuOsYOLLG0TzEro7SrSqVgTiJZ24YrA50MJ0uJfH/BoVVc+8XdVQN+fV8avSjtpw1cDZXMndIX08jEsXQNlbN7L97JGcHi1Erm5TgLQubh30Ooo9Ts8mLXB/d/5w8MudQUXQjCZNlR522u0sG3FUqBGy7ftTQjSjP3WoK5gJQwL8uUpMmzDkbVZ+zq+ce8GNYjYjYbKAdGK7A6zPghfxtv/nAXcu1hpC8xj+zwxnCOBg+MHI7qcYVjjGCULtUDv5owpi+1y+D7MzY5Lkg+WKARhmD4mRdJG2mDadKYLuZ+YybDKAckH40uredQILvZo9yCTmTpzlRRkThHe9Ekt3yoFVxPTWuI5kGq6mb3tUX32XuYoxVdHo3somsv+jneWChDe1K7nNSr5scfZ3yiErdgtWLZxy99kU/on7jaZqkLdYD0TG3RZU5HlMXmpOFigDimw76XqzDKDDYR01PWVFglby9f+7w9PjpeE6pG/Nfh8druJvy/bfzH/vEa7gz8z91d+GF754iYNfeLne3jnb1yVHz9+hJ/3Ttem0+H+F8HB8drWlOHcXdMwrabYXUdW4NMh7fJb9v8Uz3B23fgSdjyCckg7mElbtc+r4934Ienx2sY48CTSK85XqPb1/gnTBSOqyH8szzeOf43Gjno4hL/fYD/fsbX3FbD5pY+Z+dg+3gNZ2t3c693zScR5+uXv/gHY+M48XIjTM4ESoaNo3avqAtWl3LvizGFrUqH+ZXmChy38DvBFVYTXyRTdVhrInioBECY3AFkGfcbkIWjOBhIt8wdY3AsbkuN+UbDFpBgcJtGuwyx8tpFeVMNsbZNuwuucYWoZl1CHjP7NPHaJGFrANhz12zKYyQotFgJwQXVN1u1GX2cCvWwiqn+U4nNFIkWGEHjomv6zXBYTlrx0pgwLzNZw+q27D8ks8Qtn3ZHAc4Mr4iWXcDzKFCnhBlmgpAQIVD6/aOjnpsqHrCeK9fXz3M+BMOkaDTYFvfITYMThph4eAu5WkQNBWPFkL3MM8wx96UnHBUcLy1KdSGJDD+nr2XMjIAKeNoG6X/8JwbfRJHazOKLfsU8EipV3/zV1z0m3+qitGZP5p4d3H4p7Ac1blyGN2KI7ab3fVNnCdCJU5HyUzZr4M3K4OlYbs1AfFKf3txvGvRDlQglXPpm6kz8csGZcQoKGwbYCUZKK7nbltvcU729i9QTUY9WPMA3zLFTZ7hTP/aHc3ENqURGgpzqabyR/X8q+9/zVAoBFLGKnjPmMVq1N9HZ4S04/oxOOtvaYHPhzEquoR5/aIaOBI5j3Ry/Z0hq557ISDIcH4jBg829zF2Kn4nvvH5gVUrVdwQmQoB3uCRfRbZf6akhgorU6Nkbms5AW6YmnKoDCmpXHCTZ9Nn5jYIi+TrRwiQMRhOR+YKlVyfi2hw62whSD79n/g3UEZruyczbjj9/sx0jopcqfRlpGQiSOtVa8vTMUwwOy/hbbpjBg5dJnTVq4GhvWVMOMlpPJLZzGpA5OdbmoAPAwFvTR5KV1WFkodkhP4n5grbObmh27TxTs2u3t31QbD873js63n8W2lz7z7zNFZCe/ZNaYL85PDj4tQzgN/rqH374gYwnuIUgDmQ8bYv1pIYWGmTKIvEdX0W/o/Eixpe/Hy7fgbF7Ajv609PD6BFaGOAW1C2QY1A0cJmWTg4ixmBOsLQFVd8DNo2mrjybv/wFzHM1+lL33qX33JGxye9/ySFOtOgCb6LxhBfiIWq5vBD7pOAnJNbj7uHOUzUfNRBlrEfwhCbEYIffhH5i5XNStgU2apuTD+WglItsmw0mc9TELP8OQp2hKjRhPJccD8pqkHEAVnxASYc9CTTQDIq/jyEPEcRrnKm4wrVcKyy0k6q9+RpM33M4/Qr/E6+9cpnJK46mrknAPSeDpUgpdJKtF/Zd3YLCwl6GIGL8M+ggyXzzbN/tEBRXWqK2FispJZNwBdx4t/flZbgCzseDn+ACZCkY3wrwlx4vf9mAxXDsLHrZK+Lqxgt3NtyVGP9CTpM2TMPTa13zaJQZGJm/rnRV0SDjiEm8dbmU2vnUJ9wqrd0sLu9q5AcBX5CPQDmOtoi+blJNexpb4kvJ297AGJs3V5z25GwePE2bfftr5Il0zrRXO2gl3tw8td/KS1upRELSI/jxupmhqyv7K/7I/DeGfYHppS9pLpG5yrqxG7L/ZcaZdO6mUaQFzUZ7/Mtf8LEsaBN+URZ3YDP+Ji8tByC6cevQ2dyaVkxfjLzV/LAtstOV8pgJl0vYASX/vrX25Qn+64ut8kvZtT/KW/V9MF29EoUF/yCs8S39XRvX6f7piWHfg2MJY8ah4Z0/9tAyE3JbjSvsaUjevpuYr+WvEkr6aSZoUH+oe0a8wnufw59+7NfpvOOXgmiN3vg1//VvMNNNH8QAPkXm+Fv897tz82YSmr/8RST+0Lh+X03EckXR0DJjC79qszi7EfVKpHwPCOEZ4XnnQkVsQ0WFlRzXF8WFwk2NVRVBlAVLjz39NTn3G5Qwo5f5AIkO+R7Z8a8p8Ae6rhJmWCRvBv+AZTwh6qjgmmCH85rI/iNZzxJDI71OclDgP7xPAKSpZD52chfEPbXChAkQDz7SXfilX1Ul6s6v+LmBDEXGAqGD1MahGUXgyJn/z/9WFfRyjmacPlPi9Xy8VR/BA/31eAj0aneJTBuqUJkHVM8PsAW5LMfiQmnuns8JxDAADT5sJiPybu4rIT+IKGTHgpolp3ceQ6lJn+KgYKtJPoiGyIw2SC3BcbbS9LNVFF49ddurmSo8/F4abk+I2kTNm+rjhCrvJMe7yS8RwkghKVX9h1ntOdLsjSeo3CXU75Pyo7jFzgavmdpjxHDU/nGOZ+t6CoejQvTwLXEUCJMwGF88fuqeDnexL1d8VbY11uU9bLCSY+wx4+yoPwhNxXDI6lbMaL86tKXIKqgx3EBBIRxFLUQv3ls1wDJe503sTq9a1P+oEnxgiMHd1vNATrGcdceJZ3TTzDF2R26c3qSDvjBbSm+DeWBCCbKUm4k0nLgupxvu1KcDwjgcfhF/Bs5AMIuV+VUXoI2XR5o1u/Sh6eJK0oy6d/EusRuHCT+LiybYnrT+X+B/fvlv/waGsZCEYLnUDz98sUU/wKeguY2lAju7e5/z/w6vxb8dfM7/mw7o7pdfzW8JAwSncPfL0Jp5rTjq6uNs0IwwIarwbAYlegQhW/uIdCC/pm0xIC+piZGEaXRDBWpL3/Fb5EDFruJBuCOV7uHdFxxfSDv3EAWmjwmw88+kpVOCl6n85TgDqxdTXF0Wa+dzIXhZk2reDSJiY1b6KVmu3MWtlOYMdIy1XhWuxu5fEpW7mZPNayhm9Qu8J+U/YFzdclkn52Zb7b9JU83HyVax5qfEiUsNbsAXp9KfdYzia0JlsqFhcvfukt5eDBs4RzRllHxxQo5PD6JPst8YlMi44YnbQq8hm14iIBy9ClCXXoT47LqP7WPlCeFMlBuNwyqLN4yZHAkzVR/A92lr60Zv4KrG/VuQrxGPg6H0olC+qAo/LovgKn1LLG52LM8J/dnunUFb21SruodpbYunFwncQlZcldadmLi9H6ejeM64xPtpCML3iTDrsubEDdHSNPMW+XTer9FO8j+O4dPlBxeR4Mgao4IpXmgSS3R8A29fYS7gr229Kjnqhyl7KdPjYk1uljNT/9Bc0vVA7hQjSlpbFF2jyikpnqSRDIHhbPE+pP9eYyNkWrfNWPWNV0gIlMm8L1AKuB9MAoIUFjfEJsZUl5BiCeA4e4LHBsn7t//K+4GwPw45mAoBBe2pMk4sagrKdr/H608yPZBWYj5x36ANmdwedfh+qoKzFJy5hyMa5wY3iMy9mNjZ8IXfRMz/jSJ3PkVbeWAT9nLowGCagtLSryZh7hnUy/zZDAdIuhCW1lWBUVpLYRJsjjEeUmk7teCwzecfMO1Ty5dzKxpLAPOgPe0Zjxcvk+vlSdFjbstBbk4tbO/aexaPGBc53Lj22XFkz6SF+Cm2vOhaKKYEpM3S+/qBI4IwWyiu1Sq7Q5yV6YVJzWCrbNIvkXXv9k6L77jSmHbTVKrbxpKpLgbsNAT7TPafqVC2tcBYmsCRdVd/Y3Ub9q/sMDkWjhQFvIovsCsHmFABk/+a7abWV/m05Q3KYWZM5+bRWGbs+OoN1JQVGTGUyOanlCabtMyrol+x0hhj4xq2YDlsbt15QEZJTTy8rypqnlDPnG5rbVc4zkrS7Xg5dWZfOIopGDVThjdgU3JFGtDSrL389s3pi6uLi1dXJ89fn32zpnIQObEqBqG55VXbEF87QLpzOAq/vbzMYRPSKfiqaWYYQ5sUL9S1sikX1+SvMk0eJQBOOX82Fa59ER1ufMYK+nlhAhEmwn8opDHkKqOTLepaDBiN1cJqjKtp3KIu5HV2Ydwf8WXa+90esaXPd4sVStzASuEaY9cg2DVOSPomLPmORAxqSZucxlTfyTvJ7fAKa8NvfrjgAwsHWOzQnV42ooxSMhOLc1v7qAshwpin4c0rX9Pqu5Fn0/ZwkvAF8jw31Z4lUWaZ3+Fx6hvW2nXZfC5JLzncrtEDOCLzProsS78341K4Qj4BNZn+BEyuQtJnpbVdQ4FI/vJYbEj/BzJbwOUe5iwvTAC6divWApcsLVr5M/3dOLHdRsmpDTEde0qLrGAVmcJJRhKSNdbFg0ULpsBLohKL0mrW2DamdmGMRS+7TIdu8bqR1zS2swKpmbGPQ3fDk+dZYihUsb4mK3kFxpwcAnTDluFm0SdFat59LU0iPPeAi1V2GY48xdmVKiLXxDts9ZgABoTeRxtfrVOubrPiiYxuBbnD3G5EIJt6tsLnyG7jWImbzw2cMMIMuB8dzQWGhG8ZYUWdPSWZ3JomEou+T5PLzpIFx25WTk2IjeNGErqgNvI//LBRmGhSOZ/BSH/4gVaA/85XdQZvgk+3DlwLplelpWLXD3YP4aWv6lHNWv3bmxsKN0pez2PCNqRk0VnSbJ6Zbazk11Rag3YAc6RhMZDBXGQGipC2vo60HiM0ErQGBjVaa++ambluBg/BNHg3TBExEWmiSLp8sCftk/onbuVNU0c++K6x/WTbU9SF8YdxkIymhigfOHdU9KvhcMVXo+ZxYWYxM79i8YViBiZW8RNx9oGZ2WeM6eFgSSXl7Mvidp2j+dWvvjl5/eJXvwo8YyIGiIWBqwXlyJGeHXrSr351+u3bby5/9avVIirKF2E8BgfMlRlh+kfv6HKwXfYI/HjbzHoa9qTWubBdRMLwNaCxq/SSroO1sq3DGCJwHBx0iNv5gBWDkDhT9TdqBuJaYiDYW7cULJJU3L3EuawzgyeLIK3E8KwtF1YYb+mhaP8KPtd38yFOnqZo/Dkjv8Z7II0V8hZvtvyNuo5MASJpEeu28kMxo3QjBuKK874Wa/gUqUVBv8HAxxKjLJrQxWCG9brMwU60ujsBif+N5EVuREnULxCk7kw65jCNvLWN+5vGIQnVgfhl1G3yGzvBRr/9aO9I3qCNfT/tRXQBgUO8Y1oO7wk7NibqMVPQwxlkSXvJwzTT3P1+X2nDyLBcNHNcfpBUxvWDQIKcIdHHjouYouJiUWavkK24kk0fILlkD3GQxTCBzQQ0boOSCf48kVIiD+hGiXSYWqiVoGUyIDl1mJCpHM6UR9n0+3PSC1jREgFpecMz5Q78V+KkLXRGXAtVfqvMAjXt4zB8YJd2RCYdGFRCJapB/pV7KaoE4b7zK7lGLyiuSKFZJ42y0QAno1AjuDBw53XV1FROSc17Bk9RvEpNjdyAbf4hxfWzi+iKuhUMpyKKKaW59zcmXxkS0oGpDV9ZKaKYwRdoG9LBqAxc15h49JvVyOpZcd8apvTS9Bb2TZyG+qN753CG0dAF4icofD4hKKQGSSNEBUq3r1q7d52Hjs99Pbit1HVZPoqyuJ427ys2W3k3oiQRnul2wxsESijMV9atg2Qr/cDiDdqEPQ9kFo3pzLoIoz96Ql33bs9ALNgeU4WQDYVgs8d3aRGUX1ts0AZ/CRZWa1L8tY5OyJMOMj65A7ktmf+7+vZuiHU4JBzHnvXGMPKwl0+OH2omF4Kg8h0X8cHavpxJ0BEJ6NZVnqCjA+DZ4Uj2y4lRP55AJPCVWPhTZvpU6CLZWzVeOUauqIDa5E+7Xmqby1JHygdbKTBe+CEbUVWoK1Tb39ymW3Bx4pRq/tUVJ/UlU8SMT5oLyAm+UN1R1l+MVk15PIcDc92A4ZV7vYV1GAGEPfl6RN8FmzVy6Llfn+tKk6II9MnSps0QZ0Zijo5YcBpcAhbOWitanqO/Xc6JvsyRec5DPnEb06hVppB9b6NyK25FUOezSt2A6qPkljSrQjECl2TZkNj8XPN9mmahsM34UbiUtJRcwqlBdS1pkjJgZw+OQyoJV9iQDJNnMVFKERCyM04nMzehTKur3t5d9UCKQ0xPucZDyWKpSFtBHmk3Q25wOTvDGZb018BLa4M87cbqyPPcq78q+4odOEWrKXl/R0ZrebhsUmpluiVL8rElLIauNWSPbczB4MMihdyTucu3bXIqo+O2v5ytIbQXLQ23oIfHNe9b7ffHZ8SQipVBjLwICmdpbR1t3xpyp+G5/y9+dpyB8+OvTH4QEi5BG6Mc9EutWlNUoWStNcZG9kgrwCOYgUe9M8+4S3Xs8uH+cfubh4rdeZBebvcaCR74Weo300pz4wvihitE+ZVNiJRCAK0J0pdNLP0Wv0ceTsgCzA25kKjDhJDcI4LjsJT5cU/3HqU8TP1qESgMneS9ZFJJGlfwmaRM6HPVMRjHjR1uUeyOIRRkdz2ZC1FBgi1lSecNsEXxauNdysngDwwPjXO4xPLxuwu3zYLnBw59LnjXejcLW7KXEzkfXlpL9KZZbAotGINRdEjjrXsQZdGMggilKWcJevdQefFdVVFqiYjuuWkVRV0pEb7gtdfVXfmhbpjMK4rR4IZh/gK7AIwOGOJn8WzVSJczn/a7Zjiqg8pMLm9ajIJcP3i0FF2MboNpKzDWQ4p4uD7SIFfUFUcxfayQKzTjcQVyJ4UbXWvUeMHUCHhLV4Lvw6AgrYaQTRPlDSYo2WCyqsWcu0ftBOHMuWBDzOka/9LSQZR4pRY8y1YYwmphwiAAjnZlhuFldxyQ1r5zVihqJzvOKk7nrRNztIy0aK7+aMHoYEYQl09k3X6gtK+iYbL8iZIanUMnhgMPFpNOzmFVByGkqYNgrtCC9b9EtvGo55MiTHLmQnBESbolNEijCkP1dSu42WpaKm5WbD9qyEhGpODYKN+GoeB3LEyce3/jOru5xvCmkXg4KFp1du/BOxj8Zu0/Sx7xCr9/zVr82plbfGL+WubBJn5YZ2QtjLzT1yn9tXIMSDwIM1YeIiHNi7KAE7Fp/DtXDPcn+sn7NgEaTxB6Bk/i8rZ/nDf5pBernqQ61b/8uZRUS/8p5Tb0mQa0Q++nrHPdxd5xTnZefpd1jkELUDluVN/gRIPkgxG8BGfqpvm4AeqauVXaigtX0HUk+GGNLorgifAhCqvAMEwHvrl7ILFQcXFY3VMYABNz0hWyBKH8HDhghVWIXuyRa+7hhLnWzpu4Jdivwn8G+fMwr75its/DkErh9FnA1JHNCnpiQxd6b8Y9JkYRUjQSjVUKdizOnncMDmzt27F0Qws27Nlzl3L60d2NrhOqWWBbL97OyulM/4Ea08PO9a+wbOEFHk53UzvQn2fUVVebu5dQUKjDWY7lJO/WQQWCYeimwjQiunGBMtq/fhzS0Iz9J25m6S8tW/OMhdojKGyopwNCwj9YE37D4HZ93HdXGEbbKgpl+D21cIXknrVz70zjIlwQIKQF+4MNjzVznNccF6CUea85PAhogJJKPnG/o5FGCFQXqs7cqVnwUlvDLd5PfhD8lWfeYljjcqSylYURK3AggG7mbFLNpKvCx3UWVMq79cvumPsmoCfAsXRVoUTFKpbrXwwfKu7g4rh+NUWlVPTraX8+ktzwCpOhPnuAoAsieoKblm3jahwI+0SbGYvDiIy4ubkxFSm6lxzcirouGij2akc/YGX3+1NN2g35jkx+y1m9Bg/meDINO5A7kc4wwq6p1dSzHC0eIdktpWt2sPYam0jDOy+DXJ0LP6jCxUzaYyP4XUOQKdYt4cUL4VDc9+hx7Zcc+A4aBUgUnJaJIX38MAl2M70Wm7/CZ+k5HRarOiMmmRixOH11VqxjUTq+iAxorC9F8sEndtszH6gOflD1hwTVZpbkhTMTnZ00qh8ilWnXeqdRRSR+Mlg5+NeS9TTNnpQDapjL4b+7bQ9nTNMGeYOL4jYGLhZDx/tDGI3qITR7OfUwrKlDKopWPaC2jmOV70+ZhSOAlabT9D3phNkIHoEMmlG19RWGcew8LJ4AJaaqBpYSn818rcsYh/Pqmvs4SIZ8C/IGqFgqZ48YRDQ1FNOWI2DBT9kIwxzD6xyEL4dtUwzzz1Gh6pgHyCNbaKEnu4RZvY3ohNlv3O5Ap2CK8xWEkZ2KmE8QNTG/ptlb4nux/LRJTC7VIICFM5LENM1Fz11FzbhqXSJZEObusNAf7zSuRPjNBSsV8Fdw5loPz7lPvqyFWssZ0kPOAnPq3ZnClFleBiwL4Qus+hmCA6uP1smwVaOxj2ug6+FyTXFxeRyyXLYUHrdFEggpPeMM5fmJyEaF1dCxpUtl1rmelv/EXHEtox0f8e1htp2NDPzL0ebORrAlTH0dK1UCHC4scWUuXt1f5tuXpi9xeQUB6jIpgiDg3ByDCnT38U94E8mVaZlV6amEnsIDqH+4nKcwrLAWYApJgDvRzRara5np+1cuP/WhSkqi3DbS0LoYsk//SqmhbEBeGqXoYzprD7zIZGRzpgV3MA2GpU5qrjYgQ4I54yJ7D/fnWC+fW88qIDJUOr6i7ls4uNCTiXoMGSix3yuaXnf2HwXOPDG4fp0AKzaYgYF6cnTMVGTUBLluGlk1HVFHEWmBTiUruBRYPYadfIvnJ5cveNVWj5RoQwByv5ldliXM63JCmrQnHhh7gSya0BPUVnMYrVHp8nXT4I6iW0/Oz1YfRdJ/Lq7qZykSamW3GXyHlClm672ZbaAwuyk6diEjuskBHuVBlx086sXe5uHmdjdOUys8qH+rmg6pOO88Qr8eEkHI5/eT0bDHG/7XU/6TPeJesUr/L/Ywp6agVcDdZcDT92O93zAs6EgSR9cfV0kLZCPfqw4MH/F9e4Xyckbcf16+Xmn366COia6UQfpG7tjmEM5uxEibBajnbBd+nI84D23f6AVFVOYtBDgUtB2bCtSoyhgwK82FX6h8hUG6arwt7DFEmHJKtpp9Y3dMWxSMIk8WQy4WfJKPQqns4Vk9bYbNFKH/1w8SVeaiH/bqlp8ocl5RoRBk44Mh+Wz7d2CiKUsyFkIKUHB2VynGQiOktzUqaoIor4RO9u/PIfDJAHYfNmoG8CEmkKz4fU6zfvob4uQOvUhAtVTwYVqpWXqmHBpd5fsAqfW8JVP3qxhaaXfmNaw95iepFus3a1g7d+VA92vpHl36rWHLdz6OKHpQvTNrFtZrZTWEVCvwv8x/7wR1DKTNGAv8m7XJztqXX7QTZLnkP7Twh7dkdSxQEEjhCfd8mQ7CDoFbT72rhkSCCjJAGUC3N4qTfz4pTmd38+HdXDrW7ZpB4twwL5Mno+SAFcP9h3NPgMck4l4wubZnhI1j4jnKlU1RlwhtDQUceQ7d4HEMbvTwD521kwHR2yRzgTtBAY9kMfCp3tTb7bO069ci5RuGZfY395BJa4zYZnmGeaA2yzj1hbCJ2kf4LF9Ml74uv0cQ30Q7kchqOJSGnWE2cqjPhyvodN22ZDxPZQhfYY8FJNDSv/Oqn+MI4hbfFERDyYJPdI09dBIZrcBPOQqny2NJiIXW5N+DlJ20h6cnHEod8cVMb7XktSll9AFSRh9s7qx18UNrW47dvePt3Ygf+ulSfui97aeGH1rek23GsZ0244g4oD+tH8ee8ikf9q472Iw6dmXI1z9tvgfpplHQIOCQc3kCgffJr2mzTEKL2L/xKz+N/Xvv6aPZv8PV5VcT+/fO7vGakoqOQEjg+jyLGcB3PX33a7omIABPH5FlAT+AW16UrXRjYEZumEdKiXOdr8PQIFOY93SyBNw7+3v7vF92Ouvxec0m4GA3CEVkGKKwG/eIVELY4ahMWeNelLmVPqt0y7r05waL8R4RKFPmqMSEUavBsYA14uLi1ZMuhCt8OlkIuiN75PMTrFj+giPmsbXqL7ubuJEaGUKTph53gpW5sNMj6PH74DvXsc6sRzbN4InDhHJBlk5W7TzO1R7+f/43Ym/FKccHSOMLGDozl6hR8ruLb7+J7KkIpMsN0QvX1ihsXIjQTeXdcc3n8x4wNyWEndWoUUwV9+bB8LbV8jTog4At2J9WProJuxX2ZfHrcjT5HP6LttHZ85QpYieoD1ksX/R8sSmIxtLRSnIppNXHktDt9L44dAB7dbQMot2GVd0BjCrzpRn3XzoKuvK/oMdpFMko3leSseUxSJ8dIQqsBhvcCRVN9O+lXoCjdbg7ZsQbMeZewPwvDq0xHFDUqvK9ZkX714jFIvzMPW4dZKW5A4Mt+6HWcAoMsuCXndi4DEyxHYzJoo351XTegvfQWhLXkg+3mpbUFdvcbA2hazVuNtiUHMeE+Mq3b22LTdt5NegMJuRA86FnBwsmjCeUXR6pOaXejMO5hhyUKz5VeqCvQFR3Wi+g344KUBv7R8fbh4/XbweHRwd7TsXJi1Y1X1IN9gONXoi+szrxwOvEV3pZoBbt/VmFeAR/OkEyUp5EZKiTUIylG+PgBDNNO6PXm9GMCMxqyIPDp0dqUunO/JFbJmR7Ifyf/53pmpA2V9Bf/qOJwqOaKOiU604JMlCy4XyB1SyYCiUn3PyPpgr/0VThP5oq/NVNFdr/hzdVSMjHe0WW8aR08VL0jQSCfStR0cbzt9Xjh9enL5RpBSRcKMw42Y9v0YKyl4TlfQHDesFXOA4d9IB8iwHlSdnsHiKBYQjZIe+kfGwjtdmEDmKqA8bxG+6k6iNW0dWzIRHHFmvPG+RpQK+HX7pm3xpyDZ5/10WQ7dE7zgYlnMRXDfal8BwHYbpAs3RuorLBaE47XyI18TsmIQhIcNAbtAU//N0UeIM//5//7TeReAgk+1yhV+d7X2P7PHkj0/NjbE4cMBkIkVGsvEg4gP3tfUlG3lhk9FToL/BsdT+Pq0xm5TWSPGI4SuujCPZCf3esK7jUUu/lRwi2TPTI//O/g72uuAVicLkQZK7b9m6zSRWL7OJkFkLODTDgbhXF49nwHe2xHv1XfssnnPI0VgR/KJ4AJ08Hw9NMSHFliPX5A7jpKBibD20KJEy+WJZIQfbEQ6E5Pi5F0409rP7/zX3bchtHtuVzO8L/UMOHI6lNkAR4Z9ueoElLrXMsWyNK9vS8IApAkSwLRKFRgCi6wxH+jDkRZyL8Lf4Uf8nkvubOrCwAlCnP9INbJKsys/Kyc1/WXvtyzjm6CI0Tn5m8Soe6dV/dTsEIn/7262O/M9EsB7+52wjT6/q3X1nhesLAD/mDAUySSzleBuj0RQ6wLNgCivT0VMRYfxmkwOSfi2JRjIRqfgxJtATF5i1+zczNFg5Fq1MMF7PIwXuSuQ/B+CjXcQeBabLjWWTSjQXSCk6zu2NyIh88k9/rVvoDnSS+WkLCFCcJeS7c/+DqfVmgw24yLE6y72C94T1hcIFVeH5ORfSkTIMqo6qmSsZvDSXBCfbhdg/w4N+4C2B2J1lcQA41A09VMQgzoHgo7pbquGvqJPNAD9lbgNLBG9fp+zmWkYnOj14+Ame64wrjDCbH6dZbVjh1oAnjQorHIfdXTuCecphtgFHtNIzR/HrDzxRe9uDYgBYv3dmQqiS7jVAsH7ub9b6+ouR4A8LeYF/cRvbs+VP6WOYWw5AqsEghHm1GeAAP9jbBs52Ek4fO3QkdIiWUg8M2DsQN44OVyqhCByqeJrVRqLgGuwADER9GJdv7DNeW97pdy3gly8l9OnwO9jecLPccNwCqE2xSsfgkw1y+3twvqFlsU75g5oytsljKYMsFTVOFEgVUpBIdNCQaWTXTON/DNZ3Xd9l5eVVCkpNktNWpfsiQjXqzs+ZU3vImFzM7HIHSP7lveH3rnr/LLsr3czeaTf0ZxRn+hk2CTap8tYk1etwPYCvSH2E5M74ugMkUFHmnkgXjfVM7A1/9wiovTdCPQP+QQ0cUU1n+I9YUcrdBPSd6mtk7KkwgMocQcyJ2Hjuhu4lHvhxtWiH5BKuTgIabNXPhkqP7BmC1rJSBo8T9y92DsxKwC1TUlIHZRH5WJ7j74iZlJ9Q3BQJtrP7wZjKqtl8Vo0p5K8pYZY82GbVSS7OXkEuCvnjtgHdZQ/dva+gMZ3GU/aNavF4M5LOL9znsKVB1h/K7ZmGXfHJ3U0V0eqcvn7tGOa1fYMiVGGBjTMAjOLgpPLSAXSn5Oqx2tTYK3mzXohv3aAyeumoo2rutCQSCT2YA1Bo07GOc518a4r2O8HzatuD2YLsGWr6pD8CoNCQj5M2JFThoY9PGWbofo5umBVooQyFYcWhd0PhIM8Q/e1PHoFQ79+7f6h5M08ecQtghMCGNOTRPKMZ6WlHxp/PvXgi9rsCQaMd9+GQMnbntrrM7jbCxlu0vRRUVZMhWUzdBuBaDcYWpIzBUxd0bfZ0QT0qqIDHLcXNPtg/v6hoMTYoBmQNtzRaiNJKEQnYykhUW3OaxSkfqw3tOylJsu6ZpCbMbKdB3/M87SuhyggxAMojq852AsxZYv2jU4MOZjXjfqqz2Ic6R1eBIB0uUlgbaT/CvkiZPLZsS7KDuE68aQZaBcoJw2OG8rLsd8Abxhgh58d9rVQN3jdaemu4iqyeQnEdUUi8g4gk6Ly1BpN5cY+6jkJ3RYMFCrhfgt6ZU0kVdLN235APB+4LkqEkjbnQoXotZhvwkQOEG3iPGOy0TWwNKi/gmoRNq+p9lJtDkAqxqRyCOUTkCzwvVf5tD0oghFt8kIH95aTfXbV5bavMKYYUsDVeNFteO0mJJiKAVCrCFkH8j0I8bOLZY85JALk1rAygEY8dig6QfUeISBkMNLxIlRxAHnEwolc7U3JEQE8wJ/+z7gM2cz6K8imiYcu3CeACegOX63tQyFbTfAsii2Sywj19Hth7HXPhTsCyMxyuiXoXmh5uLaykfATcXXhLyro3jVhjWHEdKdaBPhh/47I27o19DvFtvmMiniLnbkcyInBxUwClsODpPhgNAZKIX36Xpgh22/gq/uHb3AKpxUpttfKcpO6GET/YceX98Gi4WbHgvP42NYk+H3w+wDhN9fvtVGXwn85KpUgmxgxk6cogVyQg4nrngCyRLt23QwAM9ovlAscjXt8n2kwpcSuSFuoS+oX82jIqwcPR0utfv8xnMbKyWMkCweaIb5zlWoOlAg6cTfHQcRLSVQMaLG4jplT+hpsU7KhhcukmkHcYbzVki83IK7f9zUQ7fjoXeqJBKWui3txngHkpFeUR4BS3tUzwWI8xhIISFVh3g6gIIzEACUaJZ0kKQQIosSQ7BOyi8SfuJpE1DwbeSVvY/dgO1CL0BMvT0eViOD3Qk7dMNxc08Tfy4HMxy4GYasuGS2zyjZbIvZRwHJyvQuzHC7H9mWknOuQqKV8TcFaVJ05b71Ra0oBPqfnNbVR2+xTroszYpihmX0131OS1mgwQU3PhwwLF7hC58SvJa1kmMDhPkGQWvPI+9SezK6VKBqMc23ix4C1RQVhuSzO/1SXhlMjoJ1QgBntk8eoyvyB2F+wxmOYSigSHHFL6cGOZGrKm799mjIs6wlBOG/OZIRCtFDkuit7xp6z8B49NxxKskNYaYDBwS0fMr9D9njEHpl6Mvnp9vLP/YbGM0GneYfoWvif7grg/f2wepv2FginKNoMk8ICyn21YDraR1SVLnEa/B/G6bcjuneTlbdo2Z5FJ/VhgXr+7DAFX9uNi62kpua3rtybLuwHDYvkZhWikZuFVPeecqe8o35sOFS2eN7zGRjPjjmlGJpurdBKIdN9GFsRIXOboDOCVG4/gBlKdiftElHyn+nluQnMMm2+K1SeakT1jmb+LrEjOHMIWdIxNogEAy1rKX5ZLi3C2wmS4YhpZ8P1qJhpcr5TFGrwScNKhpmpr1dhe49XOKg0XVbeyMUTUw4BelKP6cFLDSSSeIOzv6RkjFWvGYd+VNNsZUShFLI5jCRpIzeMEZTnKtalV7cr+AiU5VcWUAfEYVsku/X2Ux81uQRwefejrS2PmwrsP6AEa3wNLZcJlo1gixopGaAqCKx6G38cmSccS8CiZ3OdQJxFMe+L4mxPUb+0VkVpb062Qkkz8EGOSWhjbpSCKRK8+Zf98vrXHLCIfmbDEJfNhLvI2jUO+Rxhbg+jFGTWOn4dMcVptVUu2DLTcQL0t6lF1ui1Uu0Gc4cv+cIQ86s3CuIyMbiSTt0hkzzWGnaXlL1VVcV6+q283sdT7AJT4dghsKE/DyOFi0pAMCZqCJp+vqJ5LdbObusSWzYgts3U7RRyasZDPh/2i4NhX1TXRQ02IiZvCtu6gAxuSskDW7ZA0BfA94+IK+MbgDSiyQd1EQlAKQrNwkINfHLfkdcn2J7PNAWU8ahT5L0v4Ngj2o55As3CCISuXQFz9G4iWqXWIVS1DtY8nMjJkTZDmQp33l8/RwOKgIgUuOR1mOrOF1Ba7RBsiUBswqsLdFWXa3ULPC0bpBV45nABYGpSgmrlo1LLcwVFE+cswgos0HVK90HOgybIRcoxfHgeQ2zL43lGsa27rWLx7iYpdw0kqqvmGNVCbXetN0elkUI4HpaWIJdQzVh5w9QJJ3SV9tIp3x+kggLoePonpq2re0ykYn7Dw6xpuao73xFIQnIztYnG3QrgbfKDMKg0BpXTc/wRLPoO9FZUKEFX2LnancOAgYu8Q6lkQvYpHWMoKNczrUNt9lg4kSB/kMi29sQtCdwl1KReh11jkxpYL+E3OPCvgo3XUDKYV1Ytj9VE4AGjsC1Z3EDNbnrixmGx0zTN88SU3lkm2SsjM2w6ojnMpItXI52kv0b9U03XBLyvSm1kO1wHtW7FFxMFQSHBFHID4d+kQ+lfaIjCqQ3YNS3sLQPCEgHhmO/t1kv//yX6OR2p/y1O+//B+YXPfHfvqv6e4jkA9X9zNd4mq5Aw28/IzGRVWj5XPE78xBU4A/reSH4rnlQ2gcAzI4SCykRBqY2jUS0wANJbWLlHQAJzesQUzFQSk2sLpZqpPhdgDEd6ZOuzdFp+B2IJ8vTA8KD9sVy34KsQJzvZ9RTOzjsotek0uNBl3IbAZ4KgZl8WXOgbzp2099DGM8UdVYc1qHQAfB/PqCoCJCcLTPCwPeXLnmplwymSaiF+QqKg3okombwX65yC/zWbl6sF7m27pwNoTmCaFXtwZQUeKSYG3pclbUNl2fM/FSLSVhRNrq/lZvzZeMK4+iX3TNiOLDCmpCPzwKuQeOAoUxNNG94o7rwRCFGQNTxUQq3k/dRt52+2GcT7kMDf+ANwvEN9K6MG43lPrSUc3QHyfvnDYxL8GUFEaphMXhlzJgzDaekuJ9MVwRbjV2W7gXcSc+Fb5Q/5OP7OEaRNtmFfZCmwlQDUpTngvHDU2Mca1dVzdFM5IuSNYTifAzqx/TpXEZCKnkquBVhkdH6CxCV0J923dBfVugJyKaYLQrkTkiubWOWg3IV/ixHP66pEPlZlC4YIrRFfG2BiGt3Hg0+CKA6MlmGBcwlK72t2KzLQvnM97bPe73zDZswRtmq8duU196sNRUrlMfRhzLzkqtGJPBRDDITDPpeFoc981ObsPe52BN8hNeYbSg1nOBGCrGsFZS7h1Ty1nbIyOFbsOSk/FzHij5YioyCJi0m3gf3E4MRxFMw346jxkSs21wFxV/8WuAywdvSMTXYH6+BP7cQjyblaNkBV/obi+QXLvBT73gJ5tdfGT+fWj+TWsIYW5E115Kjp/m97rDWPD0IkHvu4o3JkfXIyaTKKCOfexHRDgqXM/ZmuBCa1zMi5NA1G41/vIQzAs19Ci0YkqLe5ICrCZOlfYQn0NZUWx94oWRahXNH0MaDvC81HMiRiQHM3yM0qDkjL0grIWUf0hdZdVE7VaKw8dUPrzLojxa93vkVUZGzzprwEOmFVRW4pxYKFpZ1JgvC/ld1a13ElwA037Bz235lFuiy+A999dlcD5BJLqHT3BrI+pJy1iOAmLArU8/iRu7LrCApnvAnRF3mw7JAS6ElhSQ5uHs8qY1+5Q1ypp0QgrWXzKfALK8Vu6OlLJJWtOyFvAlFUyEO9z1iQ3CJnkeT+drKj8ETZo2Kg9BURU3nc/eW8LGs9PpHkM++87xSff+fC29nYPjg11D2XIvOh6bev5zfdLbOdlwqzDqiO3bIVV2FdcLXOxRUnt7U8kU94Md5XyRxGncR5jvjqVqwxiUqd2B7B7JvPbjXu9IqF+OUzXQk3AY2ACoqYRMPVqjOqJlhVNdaP3ImN8t5aRMFIN1GkJ+M2V7HjtPVqQj/YwegJufdiRtw2jIbZwsQXVKondD8s47k36DfhaC0CDR9JzNE/x9k588cEZg7PwlyXX1VwXUd8bRkmMaREXMZ0P3LeWoSaItRUqZ/Mak33OsSYgMxUflLP9OpyMEhJn7N7gEyC8RYdkYUiJ0CVzagOYX2YaJmcaXQSMrrFFAjth084bxGNalB13N35qDO8YliepOcy0rDzcQtMrrTCmnqLwwa3ya0SbYylKwGjE676dYF4VaoswD/B2JOXEDMhCS4FLM6gjTgSESCpO583W7RucSwrG9zEsg1CzYX166OR5FDKj4hpSIz913Tlo+NCiko9ZF3GHMCA/9/4Rc8JdOjxg7u3E2KTbNMTpdgBgflzmXpl+zSsOGWyZTPAvjQLmz6pg0R0pZeCQjmfom5RcmnsptkB57qe3ebIB94y611UOBcsWEKrHYFs6i9DKzEerlRNIyTSe/vMqVSScygZPVY8XjYNm2IRhLKa5+Uihp/BnnxuFkSsVxirRufLGhzOGrnC3s9gAVgRDM5GVlWxrL7mqk4ZYrqGAEHKuf4QvMG7jq2858gmRURpzKKpM4vlVGTgI4/f2luP6Qsoj1Dy1bo1mz6UXynhmCZSo4GnAGs3DfBaWPwW+82k9l0NF59lo4ZklKosfWbXkz7HQBxeRcAZvroAKVzTDSuiaYkr79a5UuKrG7c39LBnSQdCpp2M2KQO193TZr0+fMwYX4XNmiF2/B/GvzEhxv9ZpaSFxr9ErJ6qegEWMZHrfdfeIJO3YA2CqZCoB7L5P8s5TFk8Io1k2mTWdXJplkYQa+vdfewrsSsHrNPbYcJPOGieKhQUS2XoIvo75zaj4GTSA5/Kn71eltgZ+299lKIlqElrCtL2m2PK6oxqHXrFY2GrB0uQPNaVkf3io5MZ1anOMNENYEKDkdC5tacszaGw4lbY0sRJwgSLyXwO1DQUoiHRY8TnSlrpwYnwHwFFUXjv8sxuRkYd5W9tH52gh2txi+JifiXzdADOt+oH4D3PtrNAGz4bTH56RmI8PGGSjToD86i7qzmHJFCMLA+ui2pVbKg5H8kYVh0D3vLSk2MEB3hup3ay5Nqi9Pw8Aik8Si5LVd5iUBbEgY0R9Lj83hnIu1wDRJA4T7j0ZFzMfIpkB7Jfisc/InXFZUmwDj6iIuuWpCGNnyYk9UXPA5QoqGJQgILA3G3f7EuaGjMMBpgz80J83z+AHNiv9KY954uTEqX8opAJqu8FXDtTRNcN88UKeeUASmOCeFEW965pxrpVZ/AWntHhYyqZC+fSSMP9GuxVwfrWXLm415hkBTH1Wc8eVUNUD2Mp9jmFvVKo1mxVk+de9xkS8qeM2hAbfH0AcNUDUItMgxAL8FVpXs88oWj59wjQJiQStGyVtyqZpcdJwEqYSuibxty4dOK2wsaYQNwFdAsaU8Gy2AbggvS4pQsB+VczDxRTKnagx0tI47MNtQY2I5DK5V2AM/FbMKbnTqRiL8HhZSiziPq9OpscmKWC0OhbVmUMYl+Em2y8dauoCsc2bvA4ix0c481mlU3aCHcIpgdOKDXTb5dGFB1R8O1PAN9aMPrQ1KzAmug9td00tWNu4TUrHulHwO5SQVbP8JEUVQkGgZ339LF7FJbHpRQ/8S0QEepVKtUy3hbVGgphKpVLwVaOlz3k/uK0EXbZQta22cOKIkUwLYrf5x8fyHfzyTXnz40xnd+RDLs93gO8HlKe4E8g4PiwlkdaVCw8dRTubSUwkhplW3TMk7g0sdIDhx+ScDMt1NmU1SKkUTkb4kj2s6lXqCt8NC+6JdiH7W1csnIkFmlDl+qsgG9yzc7lFAakzXElx0M1Ick4HOM6ISds9el8UMMzSGQPAhtqQwqXEhUSo898dGQiUCvFJO297k+lC48SdRgTTNCl0ZglYZEYIQHf1wI+lcL2NOkfTN2KPrV5U8e5pB+myWv4MNRFpztIpLQa7A1KrxqbNwNxqYVnMXTTyK2i27WyV0v+ON0rRZqK8XlTIz83XDawwDxmo2vlIOIU9eBuQvS3wz1KWa8bU4TIjvSHRePMn/MamGbwGo+WMtxcpXOxoWszEW0DBuOmuoYY6HnqJ1PT2cYRLRhrNC+rWXuudYhyQfuy/L13COGRc/uqz0vMMorxCNTztWzNBTpB5olgla0YUpVOrRQHz0EGCD5IAv1sSFzSO3UIXVPLn4EEVL6Frg+8ArzmsAj0CSxxNKxfxg1wpKz+chqpKMUQu89Jb4k5uuSWAly8e3+R1QuqEahH/b2dSkzSADYY29YgQR0tKB/qntPsL5eRSHl1a32vCxX8+I0KXhIRdiGrCG0QlOV/UaA2dL8H86FYui1GscZ90MIB1M6jzPKdPOrHFsJeWTuYbrYoSGENcmIhOFzRPeXiTmG6rmcrhO203GJ6wDfjZBoCvf/CzV9GGrh4/gOjZK4CN2m0meA+jI0AU+P19656GjFsKl5IjgrACg7sZCxpM1fFtxE+V4+YuJylIYuW17AeX3TTnBDDBhIgwO0PLbHG1YCOOQ85U9uVr9nZE/wvGkei6rDbGzOLk1DuIblugbv9gAV2TnFgELJ9nezs7fpORU+99fOQtpSMYsIrElVwAFuQdtUch1MrK73Y6VhtooVRXQa/+BUQYuaJRNyiBvMkuwZqotua6JsJpoZEf4RweV2gKQN2qdi2yx46w9P8dlB6dIIdwnwVnLoyD5xxlv4kA4Nfa6HLMpBurRR56plWJA6YlYpbj5M9ZOBRujPzclvVmrzJEnaM4ljudS0fEjLVRjcNLL4EulV0AX5+fbg5VtGn4yU9FPkjA0H+ZSSrwbW5iLOBCtjAiE33/5L0yfHM3cO+B/ji6CwAH7sSeHhCzXkwwx5HHdd+s+EjvrTxihX7qhDyeus25sp3pvAmkn2IpFS5j1QhN5Ehwfk//gR4JkJzvij5BQ3VqbSTx5AMKcoIvmT5hD3FLo4PV7WXdmU6UmSPyA87v016C1eBXZgvwR0sGlsa5L8PB+nJ3hlglQg/mkANYNHkEz/oHXbTqU9vBjAoLLNqXnY69r6wVw6a9QWBv0oBLHQGBHfow7MuUqN1gdowUJizgbuEol+2eNKnE7QDK5mx1KZThc60DztHo9NQR7ibrKNvgmhEF8f7Pi7PTl67O/n67V1UcXGutO0+n3p+en2f7WzmdrjRstq02Tz4WeMyeEXpRowiqzZrJgaysgP0w4Dw8CAuwoiJAwVIKDamxRNW/gIN0I7+ISyH48oFTL2KjZ9ommG59ElLNaOw8WXmO2TLXgripNccfzLQEQ5P4h/NPS5mcGL9MUlm121geMmCteaxqZt7ExCgK5ggBcJ13RXR1tXeBssrBAR5nhu8Bp9dbp0iaIB2+bq3wEOYX+VmQgQHCtINFDaje01Pgzs0o2Ibvlg0YpTlSjepiwky13xBCQEzqjmtGcZ4PSGQM31YKw8HQDiOtfbKOnsVc7TBaiWxTCpldQpYTq2VeXl6C0P6oB+gRf/6h1hDhx5HgEcEXwiYZ0SLcVE4rRp2gI0elVqfBh7Ntk3LgaXSx9n339WgopIyVKgdlIRl2hTM7iNuWQiLwR2+iJsDpkVDoF/r68GXHgYr5K0IbidvPJSA5BQfGdoMmlOdsG3HWY2pQN/JWWh5iDdC5g2ZOJlG05Rs0o2iuqGqT4bAVTq8dd5V7gDuNsOVW0ObBIh0RgEDYcnIRamVE3858kT6kX5im5TpO5qkZD8aSZUAIyBOSjoL2gw2FIrxqZPW0wmdxWZxQ30NcoAf6OZOEz5nvNoaA3PAsVRdxvLasHSow6vVEwTbUBcsiuq+qtcLLUFW3Gcs71a331oVl1hTvqq5yW8CkswRsV6oR4/vSTZOKKe35xAyXDpuVwG8AYnbyDaSKcaubMgu3l3kmyOw1eSE3RWgGSdJgV/RXCXTWiuN4YTV8daFxqvVFrnXxWdATK3qnnTjR23CsdVuSg8sy80ws+6c2kZBZ11APV1HLbzU38RHxaRAWgQnmtweKaoqupDwIPl7ejsg6jc25kTvWCtaIfubDZdUE/olG3bAW8epakJJYiJIxBIPJRN+MTcPC8U7F0epP/5F672MXzcjauFiPKWYUaCZBbvrXO5+bYSqfehUhK0SG9YvX2uXTHMXsMaac2Dv3Eg5pvFazIbP+MvwJQC6BdVjqqXwa4LAPxVs+ldSdQd6AHkciDPxulwNZLWmta8DyBSO1oTLYjSDHatkASSiHFuoMs4GCLdDBSlJg+a8N/Uw0hXq7sUKdIrnKBbMdOZJsSwVE0l5Eca33AmDopOvwSSQjcuHCukius5UnpWGHuWZ80gD5oAHggNlSPo9i3nD0ofleDlvueHKahS9J9/frzTl12oDcnDqppR9oC+Ndimhg7uAboNskn8yarBc6j0sbZQ0cJjrBtAoG4KrgzHFO5HwUmeGLVALBLhC0J5gHOzgFNby0oiFXs3GWZGHKbhlRH1qBNDcmdknJNLI3gZWxtqDmecwWFsEDAO07PoNAUg8OOU1EnCymMel0t0tCa5UbxxrOiwlLgBIbYEDfGOtvKw846PyK9PR3UjgAjOiXkeBKJf2eU19eDyk1Zh8gIO4M7PD1LpaKMEi2XYLlQQ6Pb86lmetBMYDweY3C26VcG9UJJS8jrA7Q+GIIHjpcZLF8S6Q3bcZ0pcUJ4li9mV+7C73hph4IO0KLut7CCQIcsRK98Xa+4HCYmBIsCBNT4PkKNAv8+amjIGqNFm9ZaSh9S6GCcEpYOrt6bcuS0uk51ycKaC1WtvsqCtRH92qbyCYABgJsrDwfbc8F5RYL3AB7zNHDLhTVSQmEVgxUbWe2cWRikslvEUo6F2jv5bY5UsqwRb/pqBxGgHIQUsOLnd4Sgi6A0lvurgEpVnnAMweDGx+OuRM1PhpKssa4Tfmh3a4ddbrVg0mdBJcab4mbgROd1OZXSdMJs57sxBgR/AEUhqHQjF33nPG+6r7TOQT23VAyIHZXsdFvnfUvy6Hts8CSvh7Z9T7wdXA6QgZ2mxaW2jBSq5lhIDFaUFYUCqgjV9XoDBQyNB4clxsrNnLhmJLY4KIytkDMwCTxlAkIPjhUT9K4ETXhz434zmGqWQDvqDbgGZc2nn6U+jYJXwnWTe00zcfj2mla/XSxcHXRHEAqSfHAbZ+CUomZRlm6YcyjZrchY6cYPJOMi6jWln95GmjfBb4M7C/t7pAubSmKATIMOcrZYjjsvkrzysklyY+LM5UFB7jU+MWymr3MPvtKcAeUigcu2vFqQCFhbGex29gadPacCDqm9jrsHa7QP0beDt9QaBgshXYaNPEm1fD2+JbepFOrVw/n5Wt3WMQjGf4/7xXVxVdV3NRTm2Lq5+7GYD2ZwJPELgSnCaYFvt3F09I297t7aShcdKEwN0KR3xsaAH40OYnQPq4q61ge0Lwh4ODqUtsNKet3x5VM6gPBC5a7D6h4YRviBakSlFqrhy8cFk5sYKY1hQ7I/WjOrQBXaeAbeaWTK30AzaiOtVtp6eAYCC7VyO0AymCEbrydXhfrAK7cUuWu8LwfoMTEDXUo+U0kx5gpU0Sa0FrXAEJ5SmhY2Rrtync0wqhYD0xq5ozG9zrBSwYMW6eOszlkisBB9mKUEch8EZaDkmyTJyYiMtV1V5C1D29n0gEeZm+8kjbtodIxu10qkXkdQwctBWa5/lqPG3WzXJ+RaQIatB+2hJHwZYNlBkITof/Dp+2sLSusHUL6GyK0R5IK4gQDrMB3rUgjZUOjFqIj7+TVAyce5n8KYnU7N3a6n5buJchdLtqFYsg0KD+C9CY7/7BsswuLVZ8mTWXuUA3fJ0VA5lZEUe3c/k2dgXrWIFZ8nCQRF6q0gdwZtFfTqpWRFwvBGtxE7qZtaA1NvyH2BBu862g4qwF4bwA37rW03tNp9qi+ePn+NgbJ6oZltIeLedGztEbsHWUtTpeJpWwPhyK0LBfZ61IrhIMAg0Ad4OIzzjhQ5hX+x0fTGCMy1fK1RB21Z4HxtYvxBCFabcQhQEztaTmItl0nSm5ahCxBUPR9OW9Yafk45moRORA3oggP8euX7qekIE9DW9s4EaYVYiu66ONzq3SM781mrtHOj2uhuGDxjm+BrGW1w6bO6kwi/y5VmWC3iLGCpAO/+n0hKrT3QJCtzPzFZVithWbfT3c+6Oyc7Bye9g5CwbL+3krCse3zcO1C+MtPXupxl7cxiPxMrGfbaoVqcSeayPc9cdspPBdxlzUbSnGVuRl6BhpezdsfMVMSfiXN+ifUSJBHVI6VJEnC8IUlednx8uEPcZT0gvgsstiXEzEx9b+zlUMUwNTUsuxaWpVJOe4DNadSc41ECvzItY62Q6XRcRhW/qEnwRBIzIW14UzEZOXXqu5sBEAQCUoX5rvMpuTHKqE5ZEDMnbDPp1/wiCVmY60mFtmJYIgWOYGwE06S2+Sy8R2nBxbe8MwsGrBVpqYYmZjrXwWgaVndP6QvtGgYRWSQ4gyZ5rrVHmGiqEh1OdPptt4TCeWlnlPiN0NpamXKjhRPHxbtiHDaDtgt/Ktg3qaVyEoxTcoNFm0u+zrUvvICG/PPzpUPCfHbCjBuSMBumAHgL/Dk1682TswqKJm4HkbK8g/FaJZcOU/IJ16g92LOCBQB6tGkpUzi8D0ap+9KaOj7xE2H8WcsaREUw4V0BMGAbkkL7MEOTM+mHZ2UFobtgApciSz8Q3yo1p0YzZ0XCTSP2o/9OXrIH6xRbjpBl6M+g+nMcKRal18NwTIVvz7atGbNcVE5pLZ1afbsZt3kLi0ziFKx04cWk88DHCj3QUPU5LPaUP+x2tN8vqsgG3CUb+A0bcptsOCv2XXlFugt+7IMNwRzKxn5r7HjYlo+4jJBKDlw1KGLgY5xtIFMQJ83CzcmZ8eIq5NVM1Y7d+0AJJXCfeSCB7IojycvjF7E82sz+DtICpiG+Lsk7MXePvKk5miEn22/i6KX6yQctZ1i5yJciC68brLxSjiFWRveN4GPegetoRBVqyqWQ5/uPRPjp7ZVee/IanOhNI10YreY348OK/KA+NNkQJCmCUP27oPqEjNWWm5LCYROKDWnBStFg8liHebhPmDhjC4jGMUxNRb4qqchDYQS4wOTqusSyVMAOgc+HcGgBBmvI/2FGyYQhKSFCIUH3FNAYeQg12WW//Sp0VW2pah80HGEFb25BrW1KPEzOuhgGEk7Ykh5QCVEWBguBBHZLKU0gtjSrrp5PVQwtBoY92PQo25oQRCdELUFFSWawP5WfsMv88MoZXUfgTVLGJqbV5SgN7GbkqkEs+h/cNp5RWNHLbFmWDQDNBda6hBjdvLgCnwtdISZ9TWWM1+PKj7ChQo+cYmnV5MHfcxCiwDV8iN4Ivt5QCjeD5ObiPSU3m/Ok/LAfdx4AkvgNwJojtJWvjEkOs4dSZO89HbWyvtmryJpz2M5DzUco+jgTIygZU3rf/IOswjVH0ZnHEYt1jAtOzRVcTYT2pugs3foW8vJAy0O0Fr68nJtw2+PDdUSyqM1m+yPqVbI7tRcjG6KVTsAozLtrauGxnmrYcxKNPiDrQ8OPVMwgG6vh2IHCKcaV4smgjHv4ITP4aFw8DE9IhYGOTS2SK1XjOZvBs9yL4sHkVB9jbLlVw0FxkKOep1QhUyi3bbAfY5CcI2GkoxvMgCoHseYBC+kHA3ruRxnJLL81HBfCck86V5/90h65+OzN84+yZr5UFdTq5VHQrWVtOfZ9OKVIdH7wYgAMCFIfMMkp9AE//FAtuhAlqyrzfCgfttPAQ3uaWA7QIqRKNcr2qOroA0/C/cdjGJAskA1DbjmXj8fGpMrqx0g5To6U2UHFpuWypPqIaPwEDq8eeFwQVMtJ5DBDt8QzJhWCVuHSdqOekgtGDBFGczz8DBHeOqq+wfIy8E6jULTlyXx90yp79G2lltNiMnrE5sHHHjBQ5o2E2l5MAYR8PSOtit28/8aT/P9kPJxiwj+FVxFpq+KHlarNbobfIQNi/lGuokYmqYqy2KdHAZSV9tzHmtbIwhknLBzUMnmxNbmAfv4TRhV7TDGTlEqJ1ZjZBMp/NV5wes3HHI/ZegFm0Fc3Yo2jDxpGnyMDir9AQRMf+4/CAhFNYejWa+j0s/JdzqnYH/sUGOuMKysq7B9JSydc5IkKHtAjEDgbvg1qgGMcT1lfqUYdt/dR5tOavcgVRkGgEDeQCjhReXNQMB94XOdCDh2laJvTYvONxaxqMdl6Tcw5fXh7UeAgdz2FC4vvvJDggv21VGoaBQ+hIxGlvha853Y6vGQlun/l9Gl2cvQxZk3FTI2R7JlzRgVGOPMU9WTPp0rQT+bf9vdUp/iHYgzl5eBuZnHg/rKZnf7Hqfz8bJZPsB9E9vd8Zr7PZU8AoJrThpW9BhLeUR+vJHUzv+2llqWHsm1O+Iw5q8hkF/SYDwDzVZB4goiPgITdXZAI+JXqjR4bLRbBZYnIwJXjjfV2dldcwXTgdU3T4z6BSEB41XmEh5yA9FcoQhm2DshaRifV2RjbAAmwv7XrX94zLyd9DF7l+vQTekw0Bd0ucAUrw4k8xSPZYnV6mE8oCxmS6iQNYCkYw3zhrhlkOZEU5rQ3xPp64jElP7ChWvp+bWrRkLBndZSlALE+6/aoLPOLpjB++gk1Yog+68ZAgovHjMLyU/SY+eGv2ctihlsY9iBnT+H4TrCc6w0SgcP3UvXJTR9dCEXvJRQNJXqcArLWCMUiZwU5P2D2yOT8/Zf/beKCv//yn+xOHlMjJluMc0yKtYYQ7DJ8So6E3wQHPA1P+VA1Njqc4FJqmO5v7fk3g+mjw3KBGtFgcUWHVP5IhwE4yK1xzW6bzUCK97beZ8S6NkOQGYWI7EIkyqceQvlUhMAtQST2dgCR2O2edPfvj0jsHh0emAqq2te6iMQmXhBqqcIvmTr4BvmzO1xYO4VJ7JlqqmHV4Liu6pJmkyjF7pH7is+nX57Cfqu5aD2skjdoMmpIZbDQuzYO+Safwk2mdvd5/si4AgDauOaxU70ABegTLmcFYOrcIMuriY8bepCklOWZulszWdV1d68rRV0PEmT4a/p5EmlxBwEntPEqn2RPDZX2iMqf8RWv9tUQCLUg520isEOQeew2Fwgv0FskayP6utIQVeWXaXXEHuCqlQRqqavFDAs/11IpOdnov18EFw+z0d5A2oRbOxunTef508agrO+wA3feT7LvhTnGPic4oynjk/LOT05j6fyvzWync7yZXd9N3VBIrkWwm1QXAVYcouxLx1FeylDYGidAHlUMEmL7iZ/Yn8opNprcDYftcM1ok2P6AtyKTjK7u6iYDO/CUeqLPDqt8cGeDSzBBm4jhckC1VOQsIzGiBwiuhCW94FkUdBclPZcMofzyA2gvLwzR7npPE/Oi70bDgLSPV2QC3P8IIrmPYhYVIetFWra/feNhLBP+M4U/XCCrjVmTG6OZC8YyW7wUy/4ie7BHzyTEX01cEIZOqj2v9NXSm1C+CzSSnAUXg523dUhl+ieeYXua2kTBoeP7JpHoie69ES3tRFUR3e0mvQF1yIgxjRSAXa0EttTNHZ5VhN37D6g/p00XVKkfGc/2zk82d052d+NbtidlTfs4e5xd89g/rmntRH/S+68n2mUl1KVvaPM/Mlr9tBfs1rIPXvuXwnzANoaTl60h24SvyncmXZyPJNP19LSbvLxghsK1wBev9QkIszhinBvzuSOSN19+8f7mhSQKgSjIiBH0i5UUxFpqn5LBFHBRgGkWFABz1io3cCKdI27/7VyRkzLycRJFLj9qICP9hVw6IXNJxpP3Nt82mTBohlMtnwYGtQRHZ30JeLJ0AaROIY7JmR6FKY3yDmiOibRMJKjSPTpxTM5DkzLQX6ByPTwNQz9C2sjvZfs+SCSxjSrIXIT8wHZcyP0lpBJD1Au5DGrRRnZyoyQ5tCnnho9D26zDymDUpiBMDFV18cMby85vDq6LVCUts23vTcarrMpsojMLX9iOenUd5NhJmnMsvmLodKUrGyWfS3q2Rdsnq2FEixDM9Mj/aU/VJWSiOgH43g2VSFksRle9unmXniakWjWVjQnXqIBVhwJhkWYGAWMIXGuoR7gSWaFammruKy65xkUR+5shdUEVH3J1kKiNV/zmgZiM6CXSb3ffiUq2prSwcOezpo8mlaJ4Wu0zh7TXQwW444z1+fDrSdpjQyTdzgNV3VPdApILUUnDcCPAR4I1thblDty+f7opokkFn32TT7SLJvc1xSizMaFm1EUpCw3RBEWuIcc9nXHDj+80u11UUp9Yry3ah/oQazlMDv/9kL+tnR7UCyjMyswwT74SBRPwWi9CdQy7OmsrJCXwQ37czfLTreGqg6j4qbqu7OBm6DvnrgqJ3247z/f5ofQsHP3AJJhIlcLE466UcGXu4tOihvyfCYvohZvN32trdDpQdjEYTkPGjeGHbaS2Wbcp7Hxp6fbGXz29dSEW1tWs4Ab5qy3Vn0B1mugRYvsXI8LWymdnICDbLIWeU6fx4CSaMsGTX0NNtDT3NlYYHbx8I0XGIlRQTpRqVfMS9GeocvkerXVfvTr5Tc/J6ARDhnqdbsHf6wBmgkZ9AtA4Y+Z7yx5tprT49uODqVNdfYoeBFlsU65sHthVZ88ycB9CVY6HjdV27YbWLDNGPcYkJWvFijpPSEyde4GMwP/Q3gLpvavZkORnAj1NWS+5SXBk8pDg+VRbWb1KniF6eLr79o3V+MrVg6e41tur7hh052KTme9Xw3SU1y8NfM6De7cnZE9p/sDsmKaTqyQhgu6FUI+GaLSfbxkplaZALe3EhZRooedQMmkCxOK5bpNcee+io/dbTm6KvCuYWY3KuV+gSbyMXr8zzJ7GluIRri+IsuBarLEgrF7BIJmEPRIxBYR2uKDfLGswTiXThfkp0cJ9V4+ucvNbh9CIusRsoQqy2TeeTEFgiighOP7aSCFOvsFFEEq+J7Kx31pEhzoIHcTn45ufePzs2KrMXeJbwvnDB225KxFt0wob4yjvzFTpvAZ0h7SODpwrdZb0+spHVWuUWBig4khQd3G23w2AqIV+H/ZDY2h2rPoxmMqnkZab7CdG2UjYu9Vu1qdGGzixvLS5FzcAuI5BEH6bf7OdTFZZK8wGNZKy2GPhbkwlICHZDF0aAbcWOWEcoua6O7WwdZO9tnKZ21Q/jP7sDjHVHZkiMMDRw6sjWxdtMl3P0stRKNcRvtY97d2s88SU0STH7DEGLM22P8S5E3uiV3jRdhpo8sLblNg6EM75llVASb51J3XOyciwAN9tVD3AhUeoYRfFBoS7dQrMH3pgUBz54ymeA50DRxSiBSgreVLAiF9uM3nS09EizLkra0gwdaeCH+RG++YUW7Db7MHzWNyxPkrRDevpck1NMeEguO3hTToNZfU18fffo99fbTmSdv7jDJHWFS5W7txHkCcegefDUUpNSb5jZgihgJD/kNfOTsw+xqvD+vQxgA/3FRDoI7r3E7dOr2jlWPzEa0xn+/x6Sftn7G7dcSHMBj2UTMiAKB+rE5tV1w+fzHB40mUkyW4S+G0BGWB1xBG+6kZPAxmcEV9jP1Mc3jh2w4Tn9bQfFaFK8zpCcrxTt/1EbnQpxXrU0y2X+Pnv78Z9/LZLL97/CS+w+W2jW9iKo4pul2zeknzdCRloewjuPXsDko7XGFG9oMZbnYDDpmEFy/I4XUHajFpos1NrDToci/o0u4oO+SwQ99KMviB7vRl8IJu1t2FOMRu797Bj+7B7t6RgRd07xf8aA1CQOTDfYgluUa4cTLuse/jHta59z29EEY90o2mKZDc5zOwAJL08f4rOqFnVQ6a71W51dLMR91uV4Ich201vSISiPiTbKoCnSDk2ihGPsMqkdSQSw6Dk37z2V3icjhseLAx3Blue7ePkacdhqVTgfmUNrZoRRs2Erj4pC13Hl0r8+vFzYAqvfB1r8pL9hgkF2hu2RPToomovsjfFkxCEs8S5zFR8icDrJRrtyVAe14Bp6YUNiVcZTVVzKCZzorLKGXIyHs3vyYMbq5v10LnC/94WyyLPy8bw5L+RVwa/6E4NKKRIFRB0sk4irBW73ZWKWk2PZSobUJsyecPCqTrz8r5Iy58VSexo4cmsmB0gu8mdQ61OHNnc2da24N5VPMfc/dQZ5qDCYlEATSEaPLdaKeSij4OwhmHgf6r+/W7iUSuEGi7ic50IHQdgTbb3GwCYJ9rdiH5XDATfl6E1lzjdHyX8FRuRj4s99/hAtcWgqp2BLzRw7BCEq0gk4NMFKQo8EpvZphOdAkkWsO3uv5RuETJGcCdRjNbTgyFij7ZGAXLURqq8NUmhhPEjKRkTVyyzGyOH86+D79fM9klwApeYO4HOAoTbaRcAxWIyvkQg24QHuMcoqfPG37xe45lSYzat3Q2rrDKN6Dk3bKYhsFbgMzx3IFbherWxwPmypvvmRMS7b+i8mJa3wE97YRMBoMSKYTIjU+QUu/2gaKSiQaN271OUZrxAuAF8VWRg+P9K7hSkz64RJW1dqTaw3r4bWcvOPrAQUFgxhOZYvBmP5x5QmwlJXZnCdaNAOWptr8ix9+oALsaEFWiOscX/hCAUWcXF6lG7Gww2S3l8Id5s2qXY+NXqGCVKceinAS2oVMGxZkzHna2dvGy/rFGUDC4sNy1ihispY2/NOTVNKC6/InFODX8WXJMTgp23L0JwUNqX+O0lV+S1JuqE748zb7Dy+sr4QQBdy1taOD3Lyfo10a+cTv5FyA3B3yA/sKNN4SqyErSZvRlmJTRcOZ0m7C6im6iaX6VxHkcBla6decTaYMG/IaovPbdVu/LtdPnFEyO9lGN8nkbXi9pMvovwKF8Fry6jHE2/b4QItAkkTiQZUys3zLSMZIhunUMNSDlEQDKsy1Mn2wKHc3kw6EN5UH87H+yFRlWt4seI3f2+Pj7xDVuzYRqoXxPh8fRwd79qul2+f2X/6y5sdWd+48BBmR3Zob5TEsw84elQ9SMMaCaSnAyUmMdLO461axDfNqJsS4bp/RAW+GHs/5L+vCTE5jfvoqq2hTdGEngYATKpXtZXFG4qxLHJoRL/6VNgfz3C2YbnTVCKFQgh69qtrRSjke5pFtzu76qKhSH/5adOjFRTjDQzzEp9pk3NSX7JUctX/Lj/0DTa+ExlRiU/ecC8oLcIEyNCU4Zh8yLnAJgdi+HHxR8yUk6NS0YXwM8THrDFxvTrqTe8S/q7obKfz51ZwHaJrsNDA6+WQsu8NF4hzXQrdZUPIvg7bUheMXrudS09ttSuHLZyuGceGK5BOaiOi1LxT7T2t6hShzuH94Wr8kY7mSntwW6xWUGnsNkAY94EEBZazuiIWN4noJAesAYHzVuZ7URvsBveE2Fwgge3piAhAs4pWBRvACZ9cfWhjOrkRrRbruzAqsyqWSSEAUsY1L0IuicEkLdLJUzzE2dy1zX2zyB13ysq9AowiaSC0KscqpDsg7P6uOgAhKwS4LHaukkSaUADXwatUu7ZuzkPHqUObsK2hgskD/ZT1xotyUXNGAOzsy4rWOHDgXo8sh/FapfwGFz7awPoaMNLW/mrSkveb+plXjmjWS9LWz/r7T8cRBlmWQXdPzkRExVp20eY+kh2cFzzRe0L1r19LnqGLU1VBX+JUqICflkSd1wyW4q3hfDhZD8T3IgDQ7G88i4KfuDwrVWQN2taR88Qn3If3iEO/JPHgGuQZ8npF8vbm7y2V3rSJ5LwAOucfQslBPYSiDKhVHeGOjh1qEMyJHeYazL4BrolUcKSZKT/CDKFvaOCBUDZKSSv0p+x1dRZ54PpKoLHk3w4FdXBSQUNU6lrQxpp1DaB+YgPPXJTox9UEtf1BGTd0aj1eebbpZl4q9q6T6Ed0gnyLQ4aPqTyOhwjbhNAEpdibUB3pEDWvnbqGjExHUMJSQwvZ8hEXfgmbhiLaXmyI8esAGkQ5eKfAxWsxG8bGz2ewTd1r3DQoNmf2v/s/u3YKJwKUXylSUxPzcy77XbNVMoYpXfeD8g5RwmHPyLCTkgkr7V/Sjeajy+T7kmum8pZIQs8sncngNQzCZGEUt5kT+gTRBrbU7plXlTwe2VjgOwx0x94vAZ43HIyBfuuH3Rw/mnw5R3OjD5q9EdKb5IDYCDhpsT0TvVpBN60xFSRpKOvPXip0KXf8pNb/eLE8/8yCOpNNgguFtoGRVPspEngg+ioBsEBOHI2MeG7JC+EHGL1EmCDbc9x1BC2Q4IUZVMNx++BV13W37RxOt9eMfoT/vD/d5PZOx81txZZKT81cz8D1Qcrk4g3bHALccjvO706Sfy+mu6z/HZ6/LqGoI9lPGK8Eu6s0XlRXhaHiQ4OF2ouprgs3mdPRIFS4NJmET6yHQYMA2QpcFb5RKQfOGM+zKvfzUKWGPWzqu3TqyQkXxC5RCnVtMr5XCAy9GOxexajLZj3T3D5sr1QuCVhN3VENF7nC1q13Bvq+ssGF66dND2JHs2hkgRyJXbWT6dxjvvjMmkIVckjtYBfXnqZjiv8JsBEbUAKK291dU6XfKiWNWxWqLaE1W4Eh0KlHV1s7nj6ZRh98SofFeOEPXdvPnOYpBiPG9Hn/mAeNZ109hoQu5viCwE6l6IfQ61PlIvTP55UoNsjtfrR7bauvR0koFag0o2z1y/rPuCZC7qx08aDb4owXZGC5KcM2+ex/Yh+5kxRm8WkPgiW0Zoou2UNESecjs9CJOL3Tqxd4loxoqRGE2tU/JgHX4tNdDjHgPxR96EThYcHeFK8Y01HLQm8KJZfJ9+ou2cL6bjchjHpwFACK4UWgj2xsBbbVvYC4NdGXDsbJCBk0XcryZ949cXty8cQQC2UJCD8vN5FHDHJ67gC90ePpikAraIR9fb2vUlWpG2ZIWTqfl+anGSAXHeJjo+jACT34SiHwAxENuB6H8a9gN/pHjfrovxFDiNptcAJG0HbxrL/eus210OfU8ePsK+EN1dcj+SodiCnjrc2l+SOr7bBXKWvf2Tne6HoKf29w16intaGz2VBjP9TC1gGTn5WxI31fW4qaDke4yZajaWxEu5OdiAmnxa4L0aj31p9KAnwqcmGVAO946UAWUdeJTbzDflgmpcOtX4iuiSkFDDWfotOQRUXfYky95MpJyYu+iK9yeEcnHnuQOuoMTba0a+9i3PGNKrsRrUd7sDr0T8pZOr+ItGtKPnTUUDD2zBi601pt2tro+btKZEaByLGR+Ot7ph9VPG9icG1yz040ZHAT9MM4OWN167tX6b/aNaZC+ovteGVVQaTC8vkFxNWZkSvTaTkXWTUGRccnO1IC7WdGViXYlynV3ns6tCdy7PQonX241Gu377laPHmNsbIgcsR9waSH+e3iMsRwDeuRLAPbOoogU+dfpjjgQsqWL3JLe+kvk5oYR0m+jdjFAiBjgqMqq1a7ESD1YLdevUAbIHKb+a6J0cMoHocN+0kw0o7dfaZTyztfl6plV6BQxsn+fZ9ay4/GJj+79Pv9g9ODzY6218yXO0Hxr+n2/nbiEQ5Au2nKXtQ+d5SVBCJlp39/ynnyBZn8QP83FdCQlUzblUliUhR3SNnUzO+CEP3+dw+335r39h0VhgFnvrJqnPk/Tzz59v49+toj4ZsSugDtyycA7M/HLaA1MSx1InUSZWy+Lii5gWWE6uEq8uFQ9Da6j24iXeUVT4iqzxCLgZEe4gN5qStjDfWuEeBt27lGLJCUGktDPy7p7s90vk7iPGl5ArRqASmOKMLmTg4QJ1bGiSZRA2ze/1zHuYNOe1JdbaQ7Qd+pHQpWPkIhagXspM09QudpGYZlkp2j3QLXq7J73DULeAO3KFbnF0vH9sS9Ee3EuzaF75Pzu14uBkg2IHoE70QJ3o7nv2Gmd3Q4Yh/M29H5WlNRjtC3kuqUX0gNTu1C1WAV7GCdVAm018ultngAFXcodo9p5bD9Qn4UhdgWMUOxlFLh6u05QRFxKoqLcVdlCfeAEpkdEQWubaejypbDkAGzmdFf9clG7CnlAogenZ1UZ5zo8iucR4bISx2VkcfU1pRXsHSgu3F5A/7QVckJYyalc8vvzTUfDTYfDTQfDTfvBT2OZu8FMv+MmOxD5HT6Gcv1y4j8fbbixwEKzpAGt5Et0CO92d46ONL6Nd4ywRsNuyp24Xk+MLlv6ZPhCtOCcCw6Vhb8zVg/nt1487mhaaqj0mZ3TLzQjKvhz5Lh15d+KdpTOb3znpcLC70xnMO70tk/OEYkAqQZPJ4y6juTRzcNgiOdwPTCu3vcAK7vW2E0P72zt729EB35pOcFM6aZAv3EafSW/fTdwUPKsu7mrgd5Pf4nwirbB+Shtt5bW7jePettvk485+p7eX7Ryd7O6d9I4j26u7Uj72jo+Pdw+NgNy7Jy9mSvKFdlPqiZ/J7op+30Fa7KTktFYa7zqnquHTaUrMXZSfY2C7vmVqb+TcJoFpw2TSHNWEF09cjXERZb+WlBJm9KBWEN9fAJ4f5K14jADiTzRft3m68Pdub0/kmEiL3pfnxRzuTj6CTAnv/tpzqsgZVc10YpgUL3HVYZY1K1uffjJ2Fhyoa+7IuJ/Ky+wxXfb94j3UYHmcPfrh5fl5n8Xxo+xJ9m/5zfRv+J/sv0mb/mlWD/uj0bg/9i89yf4FyhH1QuOEiyfqmQ3Kx9jnN/3vv3518fy7bx/98T6t0t2iTHQ/rvA4PP7DwoN2eoe23P8PguSgs7PndK2se3ACfpwoBW6v7Yu9INnd3esddY0g6d6L/q9dGITUuO3P/QyqWde1Wy8GKgrqPpRoRImCetrOyUbxflqSusK/Lk/2D46PVJXrwdzc1f1bikRBr+4tkWT8WzF19K/Uu3t3bMhMoYOdk3/xX27y2VusYdkfTv1f3Mdd5/U1iQUnJ/aL3tHoeL84LHZ2R4eD/d7hzt5gsHO5d7SfH/X2uScQIO5oz/uzYlrV4Moti7pPiEiY4u5+t3dwsL/f7bKDrO+OQr/b3+mjRume3Pjb4KTLW8ptfUx9GPUn+VWts+X+cju9GWN7rtv/C2Fr5Ho=","yes");
INSERT INTO `a3rfa_options` VALUES("923","wpml_dependencies:installed_plugins","a:1:{s:26:\"sitepress-multilingual-cms\";s:5:\"3.7.1\";}","yes");
INSERT INTO `a3rfa_options` VALUES("945","_wpml_dismissed_notices","a:1:{s:12:\"requirements\";a:1:{s:20:\"missing-requirements\";s:32:\"cb7be5ffdde12085a8485cdc5bd6ffbb\";}}","no");
INSERT INTO `a3rfa_options` VALUES("1136","portfolio_skills_children","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("1072","portfolio_category_children","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("924","wpml_update_statuses","a:1:{s:31:\"wpml-upgrade-localization-files\";b:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("932","wpml_language_switcher","a:9:{s:8:\"migrated\";i:0;s:18:\"converted_menu_ids\";i:0;s:15:\"languages_order\";a:2:{i:0;s:2:\"fa\";i:1;s:2:\"en\";}s:10:\"link_empty\";i:0;s:14:\"additional_css\";s:0:\"\";s:15:\"copy_parameters\";s:0:\"\";s:5:\"menus\";a:0:{}s:8:\"sidebars\";a:0:{}s:7:\"statics\";a:3:{s:6:\"footer\";O:19:\"WPML_LS_Footer_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:19:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:6:\"footer\";s:4:\"show\";i:0;s:8:\"template\";s:27:\"wpml-legacy-horizontal-list\";s:13:\"display_flags\";i:1;s:29:\"display_link_for_current_lang\";i:1;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:17:\"background_normal\";s:0:\"\";s:13:\"border_normal\";s:0:\"\";s:19:\"font_current_normal\";s:7:\"#444444\";s:18:\"font_current_hover\";s:7:\"#000000\";s:25:\"background_current_normal\";s:7:\"#ffffff\";s:24:\"background_current_hover\";s:7:\"#eeeeee\";s:17:\"font_other_normal\";s:7:\"#444444\";s:16:\"font_other_hover\";s:7:\"#000000\";s:23:\"background_other_normal\";s:7:\"#ffffff\";s:22:\"background_other_hover\";s:7:\"#eeeeee\";s:15:\"template_string\";N;}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}s:17:\"post_translations\";O:30:\"WPML_LS_Post_Translations_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:22:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:17:\"post_translations\";s:4:\"show\";i:0;s:8:\"template\";s:29:\"wpml-legacy-post-translations\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:0;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:17:\"background_normal\";N;s:13:\"border_normal\";N;s:19:\"font_current_normal\";N;s:18:\"font_current_hover\";N;s:25:\"background_current_normal\";N;s:24:\"background_current_hover\";N;s:17:\"font_other_normal\";N;s:16:\"font_other_hover\";N;s:23:\"background_other_normal\";N;s:22:\"background_other_hover\";N;s:15:\"template_string\";N;s:22:\"display_before_content\";i:1;s:21:\"display_after_content\";i:0;s:17:\"availability_text\";s:34:\"This post is also available in: %s\";}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}s:17:\"shortcode_actions\";O:30:\"WPML_LS_Shortcode_Actions_Slot\":2:{s:24:\"\0WPML_LS_Slot\0properties\";a:19:{s:10:\"slot_group\";s:7:\"statics\";s:9:\"slot_slug\";s:17:\"shortcode_actions\";s:4:\"show\";i:1;s:8:\"template\";s:27:\"wpml-legacy-horizontal-list\";s:13:\"display_flags\";i:0;s:29:\"display_link_for_current_lang\";i:1;s:28:\"display_names_in_native_lang\";i:1;s:29:\"display_names_in_current_lang\";i:1;s:17:\"background_normal\";s:0:\"\";s:13:\"border_normal\";s:0:\"\";s:19:\"font_current_normal\";s:0:\"\";s:18:\"font_current_hover\";s:0:\"\";s:25:\"background_current_normal\";s:0:\"\";s:24:\"background_current_hover\";s:0:\"\";s:17:\"font_other_normal\";s:0:\"\";s:16:\"font_other_hover\";s:0:\"\";s:23:\"background_other_normal\";s:0:\"\";s:22:\"background_other_hover\";s:0:\"\";s:15:\"template_string\";N;}s:34:\"\0WPML_LS_Slot\0protected_properties\";a:2:{i:0;s:10:\"slot_group\";i:1;s:9:\"slot_slug\";}}}}","yes");
INSERT INTO `a3rfa_options` VALUES("937","wpml_notices","a:1:{s:12:\"requirements\";a:1:{s:20:\"missing-requirements\";O:11:\"WPML_Notice\":15:{s:30:\"\0WPML_Notice\0display_callbacks\";a:3:{i:0;a:2:{i:0;O:11:\"WPML_WP_API\":0:{}i:1;s:12:\"is_core_page\";}i:1;a:2:{i:0;r:6;i:1;s:15:\"is_plugins_page\";}i:2;a:2:{i:0;r:6;i:1;s:14:\"is_themes_page\";}}s:15:\"\0WPML_Notice\0id\";s:20:\"missing-requirements\";s:17:\"\0WPML_Notice\0text\";s:749:\"	<h3>
		To easily translate Avada, you need to add the following WPML components:
	</h3>

	<div>
		<div>
			<ul class=\"wpml-status-list wpml-plugins-status-list\">
									<li>
													<i class=\"otgs-ico-warning\"></i>
												WPML Translation Management
													(<a href=\"http://demo.iranavada.ir/architecture/wp-admin/plugin-install.php?tab=commercial\">نصب</a> | <a href=\"\" target=\"_blank\">دانلود</a>)
											</li>
									<li>
													<i class=\"otgs-ico-warning\"></i>
												WPML String Translation
													(<a href=\"http://demo.iranavada.ir/architecture/wp-admin/plugin-install.php?tab=commercial\">نصب</a> | <a href=\"\" target=\"_blank\">دانلود</a>)
											</li>
							</ul>
		</div>
	</div>
\";s:27:\"\0WPML_Notice\0collapsed_text\";N;s:18:\"\0WPML_Notice\0group\";s:12:\"requirements\";s:20:\"\0WPML_Notice\0actions\";a:2:{i:0;O:18:\"WPML_Notice_Action\":8:{s:27:\"\0WPML_Notice_Action\0dismiss\";b:1;s:37:\"\0WPML_Notice_Action\0display_as_button\";b:1;s:24:\"\0WPML_Notice_Action\0hide\";b:0;s:24:\"\0WPML_Notice_Action\0text\";s:44:\"این پیغام را نادیده بگیر\";s:23:\"\0WPML_Notice_Action\0url\";s:1:\"#\";s:36:\"\0WPML_Notice_Action\0group_to_dismiss\";N;s:31:\"\0WPML_Notice_Action\0js_callback\";N;s:42:\"\0WPML_Notice_Action\0dismiss_different_text\";b:0;}i:1;O:18:\"WPML_Notice_Action\":8:{s:27:\"\0WPML_Notice_Action\0dismiss\";b:0;s:37:\"\0WPML_Notice_Action\0display_as_button\";b:0;s:24:\"\0WPML_Notice_Action\0hide\";b:0;s:24:\"\0WPML_Notice_Action\0text\";s:56:\"محتوا، ساخته شده با هر جدول ساز\";s:23:\"\0WPML_Notice_Action\0url\";s:67:\"https://wpml.org/documentation/plugins-compatibility/page-builders/\";s:36:\"\0WPML_Notice_Action\0group_to_dismiss\";N;s:31:\"\0WPML_Notice_Action\0js_callback\";N;s:42:\"\0WPML_Notice_Action\0dismiss_different_text\";b:1;}}s:28:\"\0WPML_Notice\0css_class_types\";a:0:{}s:24:\"\0WPML_Notice\0css_classes\";a:0:{}s:24:\"\0WPML_Notice\0dismissible\";b:1;s:31:\"\0WPML_Notice\0exclude_from_pages\";a:0:{}s:21:\"\0WPML_Notice\0hideable\";b:0;s:24:\"\0WPML_Notice\0collapsable\";b:0;s:30:\"\0WPML_Notice\0restrict_to_pages\";a:0:{}s:43:\"\0WPML_Notice\0dismissible_for_different_text\";b:0;s:31:\"\0WPML_Notice\0default_group_name\";s:7:\"default\";}}}","no");
INSERT INTO `a3rfa_options` VALUES("946","fusion_options_fa-transients","a:2:{s:14:\"changed_values\";a:1:{s:22:\"sharing_social_tagline\";s:39:\"Share This Story, Choose Your Platform!\";}s:9:\"last_save\";i:1512665868;}","yes");
INSERT INTO `a3rfa_options` VALUES("944","widget_icl_lang_sel_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("934","category_children_fa","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("4704","wp_page_for_privacy_policy","0","yes");
INSERT INTO `a3rfa_options` VALUES("4705","show_comments_cookies_opt_in","0","yes");
INSERT INTO `a3rfa_options` VALUES("18983","_transient_timeout_avada_premium_plugins_info","1666423092","no");
INSERT INTO `a3rfa_options` VALUES("18984","_transient_avada_premium_plugins_info","a:14:{s:11:\"fusion-core\";a:18:{s:4:\"name\";s:11:\"Fusion Core\";s:11:\"plugin_name\";s:10:\"Avada Core\";s:4:\"slug\";s:11:\"fusion-core\";s:13:\"plugin_author\";s:11:\"ThemeFusion\";s:17:\"plugin_author_url\";s:23:\"http://theme-fusion.com\";s:5:\"image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-core-thumbnail.jpg\";s:9:\"image_url\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-core-thumbnail.jpg\";s:12:\"external_url\";s:30:\"https://avada.theme-fusion.com\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"5.6.1\";s:8:\"required\";b:1;s:4:\"icon\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";s:6:\"banner\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";s:11:\"tf_cs_image\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-core-companysite.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"5.6.1\";s:6:\"Author\";s:11:\"ThemeFusion\";s:9:\"AuthorURI\";s:23:\"http://theme-fusion.com\";}s:14:\"fusion-builder\";a:18:{s:4:\"name\";s:14:\"Fusion Builder\";s:11:\"plugin_name\";s:13:\"Avada Builder\";s:4:\"slug\";s:14:\"fusion-builder\";s:13:\"plugin_author\";s:11:\"ThemeFusion\";s:17:\"plugin_author_url\";s:24:\"https://theme-fusion.com\";s:5:\"image\";s:87:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-builder-thumbnail.jpg\";s:9:\"image_url\";s:87:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-builder-thumbnail.jpg\";s:12:\"external_url\";s:30:\"https://avada.theme-fusion.com\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"3.6.1\";s:8:\"required\";b:1;s:4:\"icon\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";s:6:\"banner\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";s:11:\"tf_cs_image\";s:89:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-builder-companysite.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"3.6.1\";s:6:\"Author\";s:11:\"ThemeFusion\";s:9:\"AuthorURI\";s:24:\"https://theme-fusion.com\";}s:27:\"fusion-white-label-branding\";a:18:{s:4:\"name\";s:27:\"Fusion White Label Branding\";s:11:\"plugin_name\";s:21:\"Avada Custom Branding\";s:4:\"slug\";s:27:\"fusion-white-label-branding\";s:13:\"plugin_author\";s:11:\"ThemeFusion\";s:17:\"plugin_author_url\";s:24:\"https://theme-fusion.com\";s:5:\"image\";s:95:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/avada-custom-branding-thumbnail.jpg\";s:9:\"image_url\";s:95:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/avada-custom-branding-thumbnail.jpg\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:3:\"1.2\";s:8:\"required\";b:0;s:4:\"icon\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:96:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/avada-custombranding-companysite.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:3:\"1.2\";s:6:\"Author\";s:11:\"ThemeFusion\";s:9:\"AuthorURI\";s:24:\"https://theme-fusion.com\";}s:9:\"revslider\";a:18:{s:4:\"name\";s:17:\"Slider Revolution\";s:11:\"plugin_name\";s:17:\"Slider Revolution\";s:4:\"slug\";s:9:\"revslider\";s:13:\"plugin_author\";s:10:\"ThemePunch\";s:17:\"plugin_author_url\";s:22:\"http://themepunch.com/\";s:5:\"image\";s:83:\"https://updates.theme-fusion.com/wp-content/uploads/2016/08/slider_revolution-1.png\";s:9:\"image_url\";s:83:\"https://updates.theme-fusion.com/wp-content/uploads/2016/08/slider_revolution-1.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"6.6.3\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2016/08/slider_revolution_cs.png\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"6.6.3\";s:6:\"Author\";s:10:\"ThemePunch\";s:9:\"AuthorURI\";s:22:\"http://themepunch.com/\";}s:11:\"LayerSlider\";a:18:{s:4:\"name\";s:14:\"LayerSlider WP\";s:11:\"plugin_name\";s:14:\"LayerSlider WP\";s:4:\"slug\";s:11:\"LayerSlider\";s:13:\"plugin_author\";s:14:\"Kreatura Media\";s:17:\"plugin_author_url\";s:38:\"https://layerslider.kreaturamedia.com/\";s:5:\"image\";s:89:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/layer_slider_plugin_thumb.png\";s:9:\"image_url\";s:89:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/layer_slider_plugin_thumb.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"7.5.3\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2016/08/layerslider_company_site.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"7.5.3\";s:6:\"Author\";s:14:\"Kreatura Media\";s:9:\"AuthorURI\";s:38:\"https://layerslider.kreaturamedia.com/\";}s:26:\"advanced-custom-fields-pro\";a:18:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:11:\"plugin_name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:13:\"plugin_author\";s:13:\"Elliot Condon\";s:17:\"plugin_author_url\";s:28:\"http://www.elliotcondon.com/\";s:5:\"image\";s:71:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/acf_pro.png\";s:9:\"image_url\";s:71:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/acf_pro.png\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"6.0.3\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/acf_pro_company_site.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"6.0.3\";s:6:\"Author\";s:13:\"Elliot Condon\";s:9:\"AuthorURI\";s:28:\"http://www.elliotcondon.com/\";}s:11:\"convertplug\";a:18:{s:4:\"name\";s:12:\"Convert Plus\";s:11:\"plugin_name\";s:12:\"Convert Plus\";s:4:\"slug\";s:11:\"convertplug\";s:13:\"plugin_author\";s:16:\"Brainstorm Force\";s:17:\"plugin_author_url\";s:31:\"https://www.brainstormforce.com\";s:5:\"image\";s:85:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/convertplus_thumbnail.jpg\";s:9:\"image_url\";s:85:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/convertplus_thumbnail.jpg\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:6:\"3.5.24\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:98:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/convertplus_thumbnail_company_site.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:6:\"3.5.24\";s:6:\"Author\";s:16:\"Brainstorm Force\";s:9:\"AuthorURI\";s:31:\"https://www.brainstormforce.com\";}s:12:\"filebird-pro\";a:18:{s:4:\"name\";s:8:\"FileBird\";s:11:\"plugin_name\";s:8:\"FileBird\";s:4:\"slug\";s:12:\"filebird-pro\";s:13:\"plugin_author\";s:10:\"Ninja Team\";s:17:\"plugin_author_url\";s:54:\"https://ninjateam.org/wordpress-media-library-folders/\";s:5:\"image\";s:109:\"https://updates.theme-fusion.com/wp-content/uploads/2020/11/99966046-a7930180-2d8d-11eb-9695-a4e6bd9c870e.jpg\";s:9:\"image_url\";s:109:\"https://updates.theme-fusion.com/wp-content/uploads/2020/11/99966046-a7930180-2d8d-11eb-9695-a4e6bd9c870e.jpg\";s:12:\"external_url\";s:0:\"\";s:7:\"premium\";b:1;s:14:\"latest_version\";s:5:\"5.0.8\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:109:\"https://updates.theme-fusion.com/wp-content/uploads/2020/11/99966169-d3ae8280-2d8d-11eb-895e-0191ae051d45.jpg\";s:11:\"has_package\";b:1;s:7:\"version\";s:5:\"5.0.8\";s:6:\"Author\";s:10:\"Ninja Team\";s:9:\"AuthorURI\";s:54:\"https://ninjateam.org/wordpress-media-library-folders/\";}s:6:\"leadin\";a:15:{s:4:\"name\";s:7:\"HubSpot\";s:11:\"plugin_name\";s:7:\"HubSpot\";s:4:\"slug\";s:6:\"leadin\";s:13:\"plugin_author\";s:7:\"HubSpot\";s:17:\"plugin_author_url\";s:23:\"https://www.hubspot.com\";s:5:\"image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2019/10/hubspot_plugin_thumb.jpg\";s:9:\"image_url\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2019/10/hubspot_plugin_thumb.jpg\";s:12:\"external_url\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:84:\"https://updates.theme-fusion.com/wp-content/uploads/2019/10/hubspot_plugin_thumb.jpg\";s:11:\"has_package\";b:0;}s:11:\"woocommerce\";a:15:{s:4:\"name\";s:11:\"WooCommerce\";s:11:\"plugin_name\";s:11:\"WooCommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:13:\"plugin_author\";s:10:\"Automattic\";s:17:\"plugin_author_url\";s:23:\"https://woocommerce.com\";s:5:\"image\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/woocommerce_plugin_thumb.png\";s:9:\"image_url\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/woocommerce_plugin_thumb.png\";s:12:\"external_url\";s:54:\"https://downloads.wordpress.org/plugin/woocommerce.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:88:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/woocommerce_plugin_thumb.png\";s:11:\"has_package\";b:0;}s:19:\"the-events-calendar\";a:15:{s:4:\"name\";s:19:\"The Events Calendar\";s:11:\"plugin_name\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:13:\"plugin_author\";s:18:\"Modern Tribe, Inc.\";s:17:\"plugin_author_url\";s:18:\"http://m.tri.be/1x\";s:5:\"image\";s:92:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/events_calendar_plugin_thumb.png\";s:9:\"image_url\";s:92:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/events_calendar_plugin_thumb.png\";s:12:\"external_url\";s:68:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.6.7.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";N;s:6:\"banner\";N;s:11:\"tf_cs_image\";N;s:11:\"has_package\";b:0;}s:13:\"wordpress-seo\";a:15:{s:4:\"name\";s:9:\"Yoast SEO\";s:11:\"plugin_name\";s:9:\"Yoast SEO\";s:4:\"slug\";s:13:\"wordpress-seo\";s:13:\"plugin_author\";s:10:\"Team Yoast\";s:17:\"plugin_author_url\";s:18:\"https://yoast.com/\";s:5:\"image\";s:69:\"https://updates.theme-fusion.com/wp-content/uploads/2018/03/yoast.png\";s:9:\"image_url\";s:69:\"https://updates.theme-fusion.com/wp-content/uploads/2018/03/yoast.png\";s:12:\"external_url\";s:56:\"https://downloads.wordpress.org/plugin/wordpress-seo.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";b:0;s:6:\"banner\";b:0;s:11:\"tf_cs_image\";s:69:\"https://updates.theme-fusion.com/wp-content/uploads/2018/03/yoast.png\";s:11:\"has_package\";b:0;}s:7:\"bbpress\";a:15:{s:4:\"name\";s:7:\"bbPress\";s:11:\"plugin_name\";s:7:\"bbPress\";s:4:\"slug\";s:7:\"bbpress\";s:13:\"plugin_author\";s:21:\"The bbPress Community\";s:17:\"plugin_author_url\";s:19:\"https://bbpress.org\";s:5:\"image\";s:71:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/bbpress.png\";s:9:\"image_url\";s:71:\"https://updates.theme-fusion.com/wp-content/uploads/2017/12/bbpress.png\";s:12:\"external_url\";s:57:\"https://downloads.wordpress.org/plugin/bbpress.2.5.14.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";N;s:6:\"banner\";N;s:11:\"tf_cs_image\";N;s:11:\"has_package\";b:0;}s:3:\"pwa\";a:15:{s:4:\"name\";s:3:\"PWA\";s:11:\"plugin_name\";s:3:\"PWA\";s:4:\"slug\";s:3:\"pwa\";s:13:\"plugin_author\";s:23:\"PWA Plugin Contributors\";s:17:\"plugin_author_url\";s:49:\"https://github.com/xwp/pwa-wp/graphs/contributors\";s:5:\"image\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_880_660.jpg\";s:9:\"image_url\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_880_660.jpg\";s:12:\"external_url\";s:46:\"https://downloads.wordpress.org/plugin/pwa.zip\";s:7:\"premium\";b:0;s:14:\"latest_version\";s:0:\"\";s:8:\"required\";b:0;s:4:\"icon\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_256_256.jpg\";s:6:\"banner\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_1544_500.jpg\";s:11:\"tf_cs_image\";s:75:\"https://updates.theme-fusion.com/wp-content/uploads/2019/01/pwa_840_438.jpg\";s:11:\"has_package\";b:0;}}","no");
INSERT INTO `a3rfa_options` VALUES("5024","recovery_keys","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("4882","revslider-valid-notice","false","yes");
INSERT INTO `a3rfa_options` VALUES("4883","fusion_registration_data","a:1:{s:5:\"avada\";a:2:{s:5:\"token\";s:0:\"\";s:8:\"is_valid\";b:0;}}","yes");
INSERT INTO `a3rfa_options` VALUES("4985","wp-optimize-newly-activated","1","yes");
INSERT INTO `a3rfa_options` VALUES("5015","wp-optimize-enable-auto-backup","false","yes");
INSERT INTO `a3rfa_options` VALUES("4995","wpo_update_version","3.0.15","yes");
INSERT INTO `a3rfa_options` VALUES("4996","updraft_task_manager_dbversion","1.1","yes");
INSERT INTO `a3rfa_options` VALUES("4999","wp-optimize-corrupted-tables-count","0","yes");
INSERT INTO `a3rfa_options` VALUES("4998","wp-optimize-install-or-update-notice-show-time","1577917826","yes");
INSERT INTO `a3rfa_options` VALUES("5016","wpo_cache_config","a:15:{s:19:\"enable_page_caching\";b:0;s:23:\"page_cache_length_value\";i:24;s:22:\"page_cache_length_unit\";s:5:\"hours\";s:17:\"page_cache_length\";i:86400;s:20:\"cache_exception_urls\";a:0:{}s:23:\"cache_exception_cookies\";a:0:{}s:30:\"cache_exception_browser_agents\";a:0:{}s:22:\"enable_sitemap_preload\";b:0;s:23:\"enable_schedule_preload\";b:0;s:21:\"preload_schedule_type\";s:0:\"\";s:21:\"enable_mobile_caching\";b:0;s:19:\"enable_user_caching\";b:0;s:8:\"site_url\";s:38:\"http://demo.iranavada.ir/architecture/\";s:17:\"wpo_cache_cookies\";a:0:{}s:25:\"wpo_cache_query_variables\";a:0:{}}","yes");
INSERT INTO `a3rfa_options` VALUES("5020","admin_email_lifespan","1653310277","yes");
INSERT INTO `a3rfa_options` VALUES("15647","aiowpsec_db_version","1.9","yes");
INSERT INTO `a3rfa_options` VALUES("15648","aio_wp_security_configs","a:97:{s:19:\"aiowps_enable_debug\";s:0:\"\";s:36:\"aiowps_remove_wp_generator_meta_info\";s:1:\"1\";s:25:\"aiowps_prevent_hotlinking\";s:0:\"\";s:28:\"aiowps_enable_login_lockdown\";s:1:\"1\";s:28:\"aiowps_allow_unlock_requests\";s:0:\"\";s:25:\"aiowps_max_login_attempts\";i:8;s:24:\"aiowps_retry_time_period\";i:10;s:26:\"aiowps_lockout_time_length\";i:60;s:28:\"aiowps_set_generic_login_msg\";s:0:\"\";s:26:\"aiowps_enable_email_notify\";s:0:\"\";s:20:\"aiowps_email_address\";s:19:\"YourEmail@yahoo.com\";s:27:\"aiowps_enable_forced_logout\";s:0:\"\";s:25:\"aiowps_logout_time_period\";s:2:\"60\";s:39:\"aiowps_enable_invalid_username_lockdown\";s:0:\"\";s:43:\"aiowps_instantly_lockout_specific_usernames\";a:0:{}s:32:\"aiowps_unlock_request_secret_key\";s:20:\"y1xlta113il2qie4z56a\";s:35:\"aiowps_lockdown_enable_whitelisting\";s:0:\"\";s:36:\"aiowps_lockdown_allowed_ip_addresses\";s:0:\"\";s:26:\"aiowps_enable_whitelisting\";s:0:\"\";s:27:\"aiowps_allowed_ip_addresses\";s:0:\"\";s:27:\"aiowps_enable_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_custom_login_captcha\";s:1:\"1\";s:25:\"aiowps_captcha_secret_key\";s:20:\"2mctlebq8be5me14wr3p\";s:42:\"aiowps_enable_manual_registration_approval\";s:0:\"\";s:39:\"aiowps_enable_registration_page_captcha\";s:0:\"\";s:35:\"aiowps_enable_registration_honeypot\";s:0:\"\";s:27:\"aiowps_enable_random_prefix\";s:0:\"\";s:31:\"aiowps_enable_automated_backups\";s:1:\"1\";s:26:\"aiowps_db_backup_frequency\";i:1;s:25:\"aiowps_db_backup_interval\";s:1:\"1\";s:26:\"aiowps_backup_files_stored\";i:6;s:32:\"aiowps_send_backup_email_address\";s:1:\"1\";s:27:\"aiowps_backup_email_address\";s:0:\"\";s:27:\"aiowps_disable_file_editing\";s:0:\"\";s:37:\"aiowps_prevent_default_wp_file_access\";s:1:\"1\";s:22:\"aiowps_system_log_file\";s:9:\"error_log\";s:26:\"aiowps_enable_blacklisting\";s:0:\"\";s:26:\"aiowps_banned_ip_addresses\";s:0:\"\";s:28:\"aiowps_enable_basic_firewall\";s:1:\"1\";s:31:\"aiowps_enable_pingback_firewall\";s:1:\"1\";s:38:\"aiowps_disable_xmlrpc_pingback_methods\";s:1:\"1\";s:34:\"aiowps_block_debug_log_file_access\";s:0:\"\";s:26:\"aiowps_disable_index_views\";s:0:\"\";s:30:\"aiowps_disable_trace_and_track\";s:0:\"\";s:28:\"aiowps_forbid_proxy_comments\";s:0:\"\";s:29:\"aiowps_deny_bad_query_strings\";s:0:\"\";s:34:\"aiowps_advanced_char_string_filter\";s:0:\"\";s:25:\"aiowps_enable_5g_firewall\";s:0:\"\";s:25:\"aiowps_enable_6g_firewall\";s:0:\"\";s:26:\"aiowps_enable_custom_rules\";s:0:\"\";s:19:\"aiowps_custom_rules\";s:0:\"\";s:25:\"aiowps_enable_404_logging\";s:0:\"\";s:28:\"aiowps_enable_404_IP_lockout\";s:0:\"\";s:30:\"aiowps_404_lockout_time_length\";s:2:\"60\";s:28:\"aiowps_404_lock_redirect_url\";s:16:\"http://127.0.0.1\";s:31:\"aiowps_enable_rename_login_page\";s:0:\"\";s:28:\"aiowps_enable_login_honeypot\";s:1:\"1\";s:43:\"aiowps_enable_brute_force_attack_prevention\";s:0:\"\";s:30:\"aiowps_brute_force_secret_word\";s:0:\"\";s:24:\"aiowps_cookie_brute_test\";s:29:\"aiowps_cookie_test_g3fk9q9h1f\";s:44:\"aiowps_cookie_based_brute_force_redirect_url\";s:16:\"http://127.0.0.1\";s:59:\"aiowps_brute_force_attack_prevention_pw_protected_exception\";s:0:\"\";s:51:\"aiowps_brute_force_attack_prevention_ajax_exception\";s:0:\"\";s:19:\"aiowps_site_lockout\";s:0:\"\";s:23:\"aiowps_site_lockout_msg\";s:241:\"&amp;nbsp;
&lt;p style=&quot;text-align: center;&quot;&gt;درحال آپدیت سایت هستیم&lt;/p&gt;
&lt;p style=&quot;text-align: center;&quot;&gt;تا چند دقیقه دیگه در کنار شما خواهیم بود&lt;/p&gt;\";s:30:\"aiowps_enable_spambot_blocking\";s:1:\"1\";s:29:\"aiowps_enable_comment_captcha\";s:0:\"\";s:31:\"aiowps_enable_autoblock_spam_ip\";s:0:\"\";s:33:\"aiowps_spam_ip_min_comments_block\";s:0:\"\";s:32:\"aiowps_enable_automated_fcd_scan\";s:0:\"\";s:25:\"aiowps_fcd_scan_frequency\";i:4;s:24:\"aiowps_fcd_scan_interval\";s:1:\"2\";s:28:\"aiowps_fcd_exclude_filetypes\";s:23:\"jpg
png
bmp
zip
mp4\";s:24:\"aiowps_fcd_exclude_files\";s:0:\"\";s:26:\"aiowps_send_fcd_scan_email\";s:0:\"\";s:29:\"aiowps_fcd_scan_email_address\";s:0:\"\";s:27:\"aiowps_fcds_change_detected\";b:0;s:22:\"aiowps_copy_protection\";s:0:\"\";s:40:\"aiowps_prevent_site_display_inside_frame\";s:0:\"\";s:32:\"aiowps_prevent_users_enumeration\";s:0:\"\";s:35:\"aiowps_enable_lost_password_captcha\";s:1:\"1\";s:31:\"aiowps_enable_woo_login_captcha\";s:0:\"\";s:34:\"aiowps_enable_woo_register_captcha\";s:0:\"\";s:32:\"aiowps_place_custom_rules_at_top\";s:0:\"\";s:38:\"aiowps_enable_woo_lostpassword_captcha\";s:0:\"\";s:33:\"aiowps_enable_bp_register_captcha\";s:0:\"\";s:35:\"aiowps_enable_bbp_new_topic_captcha\";s:0:\"\";s:42:\"aiowps_disallow_unauthorized_rest_requests\";s:0:\"\";s:25:\"aiowps_ip_retrieve_method\";s:1:\"0\";s:25:\"aiowps_recaptcha_site_key\";s:0:\"\";s:27:\"aiowps_recaptcha_secret_key\";s:0:\"\";s:24:\"aiowps_default_recaptcha\";s:0:\"\";s:27:\"aiowps_max_file_upload_size\";i:10;s:26:\"aiowps_cookie_test_success\";s:1:\"1\";s:19:\"aiowps_fcd_filename\";s:26:\"aiowps_fcd_data_4mnha80hyw\";s:23:\"aiowps_last_backup_time\";s:19:\"2022-10-21 07:18:08\";s:25:\"aiowps_last_fcd_scan_time\";s:19:\"2021-11-11 11:22:41\";}","yes");
INSERT INTO `a3rfa_options` VALUES("16385","can_compress_scripts","0","no");
INSERT INTO `a3rfa_options` VALUES("15532","disallowed_keys","","no");
INSERT INTO `a3rfa_options` VALUES("15533","comment_previously_approved","1","yes");
INSERT INTO `a3rfa_options` VALUES("15534","auto_plugin_theme_update_emails","a:0:{}","no");
INSERT INTO `a3rfa_options` VALUES("15535","auto_update_core_dev","enabled","yes");
INSERT INTO `a3rfa_options` VALUES("15536","auto_update_core_minor","enabled","yes");
INSERT INTO `a3rfa_options` VALUES("15537","auto_update_core_major","unset","yes");
INSERT INTO `a3rfa_options` VALUES("15538","wp_force_deactivated_plugins","a:0:{}","yes");
INSERT INTO `a3rfa_options` VALUES("15531","widget_block","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `a3rfa_options` VALUES("16674","fusion_core_flush_permalinks","1","yes");
INSERT INTO `a3rfa_options` VALUES("16706","_transient_timeout_avada_demos","1647211251","no");
INSERT INTO `a3rfa_options` VALUES("16709","woocommerce_thumbnail_image_width","500","yes");
INSERT INTO `a3rfa_options` VALUES("16710","woocommerce_thumbnail_cropping","uncropped","yes");
INSERT INTO `a3rfa_options` VALUES("16673","duplicator_version_plugin","1.3.28","yes");
INSERT INTO `a3rfa_options` VALUES("16773","_transient_fusion_fontawesome_en",".fa,.fab,.fal,.far,.fas{-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased;display:inline-block;font-style:normal;font-variant:normal;text-rendering:auto;line-height:1}.fa-lg{font-size:1.33333em;line-height:.75em;vertical-align:-.0667em}.fa-xs{font-size:.75em}.fa-sm{font-size:.875em}.fa-1x{font-size:1em}.fa-2x{font-size:2em}.fa-3x{font-size:3em}.fa-4x{font-size:4em}.fa-5x{font-size:5em}.fa-6x{font-size:6em}.fa-7x{font-size:7em}.fa-8x{font-size:8em}.fa-9x{font-size:9em}.fa-10x{font-size:10em}.fa-fw{text-align:center;width:1.25em}.fa-ul{list-style-type:none;margin-left:2.5em;padding-left:0}.fa-ul>li{position:relative}.fa-li{left:-2em;position:absolute;text-align:center;width:2em;line-height:inherit}.fa-border{border:solid .08em #eee;border-radius:.1em;padding:.2em .25em .15em}.fa-pull-left{float:left}.fa-pull-right{float:right}.fa.fa-pull-left,.fab.fa-pull-left,.fal.fa-pull-left,.far.fa-pull-left,.fas.fa-pull-left{margin-right:.3em}.fa.fa-pull-right,.fab.fa-pull-right,.fal.fa-pull-right,.far.fa-pull-right,.fas.fa-pull-right{margin-left:.3em}.fa-spin{-webkit-animation:fa-spin 2s infinite linear;animation:fa-spin 2s infinite linear}.fa-pulse{-webkit-animation:fa-spin 1s infinite steps(8);animation:fa-spin 1s infinite steps(8)}@-webkit-keyframes fa-spin{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}@keyframes fa-spin{0%{-webkit-transform:rotate(0);transform:rotate(0)}100%{-webkit-transform:rotate(360deg);transform:rotate(360deg)}}.fa-rotate-90{-webkit-transform:rotate(90deg);transform:rotate(90deg)}.fa-rotate-180{-webkit-transform:rotate(180deg);transform:rotate(180deg)}.fa-rotate-270{-webkit-transform:rotate(270deg);transform:rotate(270deg)}.fa-flip-horizontal{-webkit-transform:scale(-1,1);transform:scale(-1,1)}.fa-flip-vertical{-webkit-transform:scale(1,-1);transform:scale(1,-1)}.fa-flip-horizontal.fa-flip-vertical{-webkit-transform:scale(-1,-1);transform:scale(-1,-1)}:root .fa-flip-horizontal,:root .fa-flip-vertical,:root .fa-rotate-180,:root .fa-rotate-270,:root .fa-rotate-90{-webkit-filter:none;filter:none}.fa-stack{display:inline-block;height:2em;line-height:2em;position:relative;vertical-align:middle;width:2.5em}.fa-stack-1x,.fa-stack-2x{left:0;position:absolute;text-align:center;width:100%}.fa-stack-1x{line-height:inherit}.fa-stack-2x{font-size:2em}.fa-inverse{color:#fff}@font-face{font-family:\"Font Awesome 5 Brands\";font-style:normal;font-weight:normal;src:url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.eot);src:url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.eot?#iefix) format(\"embedded-opentype\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.woff2) format(\"woff2\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.woff) format(\"woff\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.ttf) format(\"truetype\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-brands-400.svg#fontawesome) format(\"svg\");font-display: block;}.fab{font-family:\"Font Awesome 5 Brands\"}@font-face{font-family:\"Font Awesome 5 Free\";font-style:normal;font-weight:400;src:url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.eot);src:url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.eot?#iefix) format(\"embedded-opentype\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.woff2) format(\"woff2\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.woff) format(\"woff\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.ttf) format(\"truetype\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-regular-400.svg#fontawesome) format(\"svg\");font-display: block;}.far{font-family:\"Font Awesome 5 Free\";font-weight:400;}@font-face{font-family:\"Font Awesome 5 Free\";font-style:normal;font-weight:900;src:url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.eot);src:url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.eot?#iefix) format(\"embedded-opentype\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.woff2) format(\"woff2\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.woff) format(\"woff\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.ttf) format(\"truetype\"),url(//demo.iranavada.ir/architecture/wp-content/themes/IranAvada/includes/lib/assets/fonts/fontawesome/webfonts/fa-solid-900.svg#fontawesome) format(\"svg\");font-display: block;}.fa,.fas{font-family:\"Font Awesome 5 Free\";font-weight:900}.fa-500px:before{content:\"\\f26e\"}.fa-accessible-icon:before{content:\"\\f368\"}.fa-accusoft:before{content:\"\\f369\"}.fa-acquisitions-incorporated:before{content:\"\\f6af\"}.fa-ad:before{content:\"\\f641\"}.fa-address-book:before{content:\"\\f2b9\"}.fa-address-card:before{content:\"\\f2bb\"}.fa-adjust:before{content:\"\\f042\"}.fa-adn:before{content:\"\\f170\"}.fa-adversal:before{content:\"\\f36a\"}.fa-affiliatetheme:before{content:\"\\f36b\"}.fa-air-freshener:before{content:\"\\f5d0\"}.fa-airbnb:before{content:\"\\f834\"}.fa-algolia:before{content:\"\\f36c\"}.fa-align-center:before{content:\"\\f037\"}.fa-align-justify:before{content:\"\\f039\"}.fa-align-left:before{content:\"\\f036\"}.fa-align-right:before{content:\"\\f038\"}.fa-alipay:before{content:\"\\f642\"}.fa-allergies:before{content:\"\\f461\"}.fa-amazon:before{content:\"\\f270\"}.fa-amazon-pay:before{content:\"\\f42c\"}.fa-ambulance:before{content:\"\\f0f9\"}.fa-american-sign-language-interpreting:before{content:\"\\f2a3\"}.fa-amilia:before{content:\"\\f36d\"}.fa-anchor:before{content:\"\\f13d\"}.fa-android:before{content:\"\\f17b\"}.fa-angellist:before{content:\"\\f209\"}.fa-angle-double-down:before{content:\"\\f103\"}.fa-angle-double-left:before{content:\"\\f100\"}.fa-angle-double-right:before{content:\"\\f101\"}.fa-angle-double-up:before{content:\"\\f102\"}.fa-angle-down:before{content:\"\\f107\"}.fa-angle-left:before{content:\"\\f104\"}.fa-angle-right:before{content:\"\\f105\"}.fa-angle-up:before{content:\"\\f106\"}.fa-angry:before{content:\"\\f556\"}.fa-angrycreative:before{content:\"\\f36e\"}.fa-angular:before{content:\"\\f420\"}.fa-ankh:before{content:\"\\f644\"}.fa-app-store:before{content:\"\\f36f\"}.fa-app-store-ios:before{content:\"\\f370\"}.fa-apper:before{content:\"\\f371\"}.fa-apple:before{content:\"\\f179\"}.fa-apple-alt:before{content:\"\\f5d1\"}.fa-apple-pay:before{content:\"\\f415\"}.fa-archive:before{content:\"\\f187\"}.fa-archway:before{content:\"\\f557\"}.fa-arrow-alt-circle-down:before{content:\"\\f358\"}.fa-arrow-alt-circle-left:before{content:\"\\f359\"}.fa-arrow-alt-circle-right:before{content:\"\\f35a\"}.fa-arrow-alt-circle-up:before{content:\"\\f35b\"}.fa-arrow-circle-down:before{content:\"\\f0ab\"}.fa-arrow-circle-left:before{content:\"\\f0a8\"}.fa-arrow-circle-right:before{content:\"\\f0a9\"}.fa-arrow-circle-up:before{content:\"\\f0aa\"}.fa-arrow-down:before{content:\"\\f063\"}.fa-arrow-left:before{content:\"\\f060\"}.fa-arrow-right:before{content:\"\\f061\"}.fa-arrow-up:before{content:\"\\f062\"}.fa-arrows-alt:before{content:\"\\f0b2\"}.fa-arrows-alt-h:before{content:\"\\f337\"}.fa-arrows-alt-v:before{content:\"\\f338\"}.fa-artstation:before{content:\"\\f77a\"}.fa-assistive-listening-systems:before{content:\"\\f2a2\"}.fa-asterisk:before{content:\"\\f069\"}.fa-asymmetrik:before{content:\"\\f372\"}.fa-at:before{content:\"\\f1fa\"}.fa-atlas:before{content:\"\\f558\"}.fa-atlassian:before{content:\"\\f77b\"}.fa-atom:before{content:\"\\f5d2\"}.fa-audible:before{content:\"\\f373\"}.fa-audio-description:before{content:\"\\f29e\"}.fa-autoprefixer:before{content:\"\\f41c\"}.fa-avianex:before{content:\"\\f374\"}.fa-aviato:before{content:\"\\f421\"}.fa-award:before{content:\"\\f559\"}.fa-aws:before{content:\"\\f375\"}.fa-baby:before{content:\"\\f77c\"}.fa-baby-carriage:before{content:\"\\f77d\"}.fa-backspace:before{content:\"\\f55a\"}.fa-backward:before{content:\"\\f04a\"}.fa-bacon:before{content:\"\\f7e5\"}.fa-bacteria:before{content:\"\\e059\"}.fa-bacterium:before{content:\"\\e05a\"}.fa-bahai:before{content:\"\\f666\"}.fa-balance-scale:before{content:\"\\f24e\"}.fa-balance-scale-left:before{content:\"\\f515\"}.fa-balance-scale-right:before{content:\"\\f516\"}.fa-ban:before{content:\"\\f05e\"}.fa-band-aid:before{content:\"\\f462\"}.fa-bandcamp:before{content:\"\\f2d5\"}.fa-barcode:before{content:\"\\f02a\"}.fa-bars:before{content:\"\\f0c9\"}.fa-baseball-ball:before{content:\"\\f433\"}.fa-basketball-ball:before{content:\"\\f434\"}.fa-bath:before{content:\"\\f2cd\"}.fa-battery-empty:before{content:\"\\f244\"}.fa-battery-full:before{content:\"\\f240\"}.fa-battery-half:before{content:\"\\f242\"}.fa-battery-quarter:before{content:\"\\f243\"}.fa-battery-three-quarters:before{content:\"\\f241\"}.fa-battle-net:before{content:\"\\f835\"}.fa-bed:before{content:\"\\f236\"}.fa-beer:before{content:\"\\f0fc\"}.fa-behance:before{content:\"\\f1b4\"}.fa-behance-square:before{content:\"\\f1b5\"}.fa-bell:before{content:\"\\f0f3\"}.fa-bell-slash:before{content:\"\\f1f6\"}.fa-bezier-curve:before{content:\"\\f55b\"}.fa-bible:before{content:\"\\f647\"}.fa-bicycle:before{content:\"\\f206\"}.fa-biking:before{content:\"\\f84a\"}.fa-bimobject:before{content:\"\\f378\"}.fa-binoculars:before{content:\"\\f1e5\"}.fa-biohazard:before{content:\"\\f780\"}.fa-birthday-cake:before{content:\"\\f1fd\"}.fa-bitbucket:before{content:\"\\f171\"}.fa-bitcoin:before{content:\"\\f379\"}.fa-bity:before{content:\"\\f37a\"}.fa-black-tie:before{content:\"\\f27e\"}.fa-blackberry:before{content:\"\\f37b\"}.fa-blender:before{content:\"\\f517\"}.fa-blender-phone:before{content:\"\\f6b6\"}.fa-blind:before{content:\"\\f29d\"}.fa-blog:before{content:\"\\f781\"}.fa-blogger:before{content:\"\\f37c\"}.fa-blogger-b:before{content:\"\\f37d\"}.fa-bluetooth:before{content:\"\\f293\"}.fa-bluetooth-b:before{content:\"\\f294\"}.fa-bold:before{content:\"\\f032\"}.fa-bolt:before{content:\"\\f0e7\"}.fa-bomb:before{content:\"\\f1e2\"}.fa-bone:before{content:\"\\f5d7\"}.fa-bong:before{content:\"\\f55c\"}.fa-book:before{content:\"\\f02d\"}.fa-book-dead:before{content:\"\\f6b7\"}.fa-book-medical:before{content:\"\\f7e6\"}.fa-book-open:before{content:\"\\f518\"}.fa-book-reader:before{content:\"\\f5da\"}.fa-bookmark:before{content:\"\\f02e\"}.fa-bootstrap:before{content:\"\\f836\"}.fa-border-all:before{content:\"\\f84c\"}.fa-border-none:before{content:\"\\f850\"}.fa-border-style:before{content:\"\\f853\"}.fa-bowling-ball:before{content:\"\\f436\"}.fa-box:before{content:\"\\f466\"}.fa-box-open:before{content:\"\\f49e\"}.fa-box-tissue:before{content:\"\\e05b\"}.fa-boxes:before{content:\"\\f468\"}.fa-braille:before{content:\"\\f2a1\"}.fa-brain:before{content:\"\\f5dc\"}.fa-bread-slice:before{content:\"\\f7ec\"}.fa-briefcase:before{content:\"\\f0b1\"}.fa-briefcase-medical:before{content:\"\\f469\"}.fa-broadcast-tower:before{content:\"\\f519\"}.fa-broom:before{content:\"\\f51a\"}.fa-brush:before{content:\"\\f55d\"}.fa-btc:before{content:\"\\f15a\"}.fa-buffer:before{content:\"\\f837\"}.fa-bug:before{content:\"\\f188\"}.fa-building:before{content:\"\\f1ad\"}.fa-bullhorn:before{content:\"\\f0a1\"}.fa-bullseye:before{content:\"\\f140\"}.fa-burn:before{content:\"\\f46a\"}.fa-buromobelexperte:before{content:\"\\f37f\"}.fa-bus:before{content:\"\\f207\"}.fa-bus-alt:before{content:\"\\f55e\"}.fa-business-time:before{content:\"\\f64a\"}.fa-buy-n-large:before{content:\"\\f8a6\"}.fa-buysellads:before{content:\"\\f20d\"}.fa-calculator:before{content:\"\\f1ec\"}.fa-calendar:before{content:\"\\f133\"}.fa-calendar-alt:before{content:\"\\f073\"}.fa-calendar-check:before{content:\"\\f274\"}.fa-calendar-day:before{content:\"\\f783\"}.fa-calendar-minus:before{content:\"\\f272\"}.fa-calendar-plus:before{content:\"\\f271\"}.fa-calendar-times:before{content:\"\\f273\"}.fa-calendar-week:before{content:\"\\f784\"}.fa-camera:before{content:\"\\f030\"}.fa-camera-retro:before{content:\"\\f083\"}.fa-campground:before{content:\"\\f6bb\"}.fa-canadian-maple-leaf:before{content:\"\\f785\"}.fa-candy-cane:before{content:\"\\f786\"}.fa-cannabis:before{content:\"\\f55f\"}.fa-capsules:before{content:\"\\f46b\"}.fa-car:before{content:\"\\f1b9\"}.fa-car-alt:before{content:\"\\f5de\"}.fa-car-battery:before{content:\"\\f5df\"}.fa-car-crash:before{content:\"\\f5e1\"}.fa-car-side:before{content:\"\\f5e4\"}.fa-caravan:before{content:\"\\f8ff\"}.fa-caret-down:before{content:\"\\f0d7\"}.fa-caret-left:before{content:\"\\f0d9\"}.fa-caret-right:before{content:\"\\f0da\"}.fa-caret-square-down:before{content:\"\\f150\"}.fa-caret-square-left:before{content:\"\\f191\"}.fa-caret-square-right:before{content:\"\\f152\"}.fa-caret-square-up:before{content:\"\\f151\"}.fa-caret-up:before{content:\"\\f0d8\"}.fa-carrot:before{content:\"\\f787\"}.fa-cart-arrow-down:before{content:\"\\f218\"}.fa-cart-plus:before{content:\"\\f217\"}.fa-cash-register:before{content:\"\\f788\"}.fa-cat:before{content:\"\\f6be\"}.fa-cc-amazon-pay:before{content:\"\\f42d\"}.fa-cc-amex:before{content:\"\\f1f3\"}.fa-cc-apple-pay:before{content:\"\\f416\"}.fa-cc-diners-club:before{content:\"\\f24c\"}.fa-cc-discover:before{content:\"\\f1f2\"}.fa-cc-jcb:before{content:\"\\f24b\"}.fa-cc-mastercard:before{content:\"\\f1f1\"}.fa-cc-paypal:before{content:\"\\f1f4\"}.fa-cc-stripe:before{content:\"\\f1f5\"}.fa-cc-visa:before{content:\"\\f1f0\"}.fa-centercode:before{content:\"\\f380\"}.fa-centos:before{content:\"\\f789\"}.fa-certificate:before{content:\"\\f0a3\"}.fa-chair:before{content:\"\\f6c0\"}.fa-chalkboard:before{content:\"\\f51b\"}.fa-chalkboard-teacher:before{content:\"\\f51c\"}.fa-charging-station:before{content:\"\\f5e7\"}.fa-chart-area:before{content:\"\\f1fe\"}.fa-chart-bar:before{content:\"\\f080\"}.fa-chart-line:before{content:\"\\f201\"}.fa-chart-pie:before{content:\"\\f200\"}.fa-check:before{content:\"\\f00c\"}.fa-check-circle:before{content:\"\\f058\"}.fa-check-double:before{content:\"\\f560\"}.fa-check-square:before{content:\"\\f14a\"}.fa-cheese:before{content:\"\\f7ef\"}.fa-chess:before{content:\"\\f439\"}.fa-chess-bishop:before{content:\"\\f43a\"}.fa-chess-board:before{content:\"\\f43c\"}.fa-chess-king:before{content:\"\\f43f\"}.fa-chess-knight:before{content:\"\\f441\"}.fa-chess-pawn:before{content:\"\\f443\"}.fa-chess-queen:before{content:\"\\f445\"}.fa-chess-rook:before{content:\"\\f447\"}.fa-chevron-circle-down:before{content:\"\\f13a\"}.fa-chevron-circle-left:before{content:\"\\f137\"}.fa-chevron-circle-right:before{content:\"\\f138\"}.fa-chevron-circle-up:before{content:\"\\f139\"}.fa-chevron-down:before{content:\"\\f078\"}.fa-chevron-left:before{content:\"\\f053\"}.fa-chevron-right:before{content:\"\\f054\"}.fa-chevron-up:before{content:\"\\f077\"}.fa-child:before{content:\"\\f1ae\"}.fa-chrome:before{content:\"\\f268\"}.fa-chromecast:before{content:\"\\f838\"}.fa-church:before{content:\"\\f51d\"}.fa-circle:before{content:\"\\f111\"}.fa-circle-notch:before{content:\"\\f1ce\"}.fa-city:before{content:\"\\f64f\"}.fa-clinic-medical:before{content:\"\\f7f2\"}.fa-clipboard:before{content:\"\\f328\"}.fa-clipboard-check:before{content:\"\\f46c\"}.fa-clipboard-list:before{content:\"\\f46d\"}.fa-clock:before{content:\"\\f017\"}.fa-clone:before{content:\"\\f24d\"}.fa-closed-captioning:before{content:\"\\f20a\"}.fa-cloud:before{content:\"\\f0c2\"}.fa-cloud-download-alt:before{content:\"\\f381\"}.fa-cloud-meatball:before{content:\"\\f73b\"}.fa-cloud-moon:before{content:\"\\f6c3\"}.fa-cloud-moon-rain:before{content:\"\\f73c\"}.fa-cloud-rain:before{content:\"\\f73d\"}.fa-cloud-showers-heavy:before{content:\"\\f740\"}.fa-cloud-sun:before{content:\"\\f6c4\"}.fa-cloud-sun-rain:before{content:\"\\f743\"}.fa-cloud-upload-alt:before{content:\"\\f382\"}.fa-cloudflare:before{content:\"\\e07d\"}.fa-cloudscale:before{content:\"\\f383\"}.fa-cloudsmith:before{content:\"\\f384\"}.fa-cloudversify:before{content:\"\\f385\"}.fa-cocktail:before{content:\"\\f561\"}.fa-code:before{content:\"\\f121\"}.fa-code-branch:before{content:\"\\f126\"}.fa-codepen:before{content:\"\\f1cb\"}.fa-codiepie:before{content:\"\\f284\"}.fa-coffee:before{content:\"\\f0f4\"}.fa-cog:before{content:\"\\f013\"}.fa-cogs:before{content:\"\\f085\"}.fa-coins:before{content:\"\\f51e\"}.fa-columns:before{content:\"\\f0db\"}.fa-comment:before{content:\"\\f075\"}.fa-comment-alt:before{content:\"\\f27a\"}.fa-comment-dollar:before{content:\"\\f651\"}.fa-comment-dots:before{content:\"\\f4ad\"}.fa-comment-medical:before{content:\"\\f7f5\"}.fa-comment-slash:before{content:\"\\f4b3\"}.fa-comments:before{content:\"\\f086\"}.fa-comments-dollar:before{content:\"\\f653\"}.fa-compact-disc:before{content:\"\\f51f\"}.fa-compass:before{content:\"\\f14e\"}.fa-compress:before{content:\"\\f066\"}.fa-compress-alt:before{content:\"\\f422\"}.fa-compress-arrows-alt:before{content:\"\\f78c\"}.fa-concierge-bell:before{content:\"\\f562\"}.fa-confluence:before{content:\"\\f78d\"}.fa-connectdevelop:before{content:\"\\f20e\"}.fa-contao:before{content:\"\\f26d\"}.fa-cookie:before{content:\"\\f563\"}.fa-cookie-bite:before{content:\"\\f564\"}.fa-copy:before{content:\"\\f0c5\"}.fa-copyright:before{content:\"\\f1f9\"}.fa-cotton-bureau:before{content:\"\\f89e\"}.fa-couch:before{content:\"\\f4b8\"}.fa-cpanel:before{content:\"\\f388\"}.fa-creative-commons:before{content:\"\\f25e\"}.fa-creative-commons-by:before{content:\"\\f4e7\"}.fa-creative-commons-nc:before{content:\"\\f4e8\"}.fa-creative-commons-nc-eu:before{content:\"\\f4e9\"}.fa-creative-commons-nc-jp:before{content:\"\\f4ea\"}.fa-creative-commons-nd:before{content:\"\\f4eb\"}.fa-creative-commons-pd:before{content:\"\\f4ec\"}.fa-creative-commons-pd-alt:before{content:\"\\f4ed\"}.fa-creative-commons-remix:before{content:\"\\f4ee\"}.fa-creative-commons-sa:before{content:\"\\f4ef\"}.fa-creative-commons-sampling:before{content:\"\\f4f0\"}.fa-creative-commons-sampling-plus:before{content:\"\\f4f1\"}.fa-creative-commons-share:before{content:\"\\f4f2\"}.fa-creative-commons-zero:before{content:\"\\f4f3\"}.fa-credit-card:before{content:\"\\f09d\"}.fa-critical-role:before{content:\"\\f6c9\"}.fa-crop:before{content:\"\\f125\"}.fa-crop-alt:before{content:\"\\f565\"}.fa-cross:before{content:\"\\f654\"}.fa-crosshairs:before{content:\"\\f05b\"}.fa-crow:before{content:\"\\f520\"}.fa-crown:before{content:\"\\f521\"}.fa-crutch:before{content:\"\\f7f7\"}.fa-css3:before{content:\"\\f13c\"}.fa-css3-alt:before{content:\"\\f38b\"}.fa-cube:before{content:\"\\f1b2\"}.fa-cubes:before{content:\"\\f1b3\"}.fa-cut:before{content:\"\\f0c4\"}.fa-cuttlefish:before{content:\"\\f38c\"}.fa-d-and-d:before{content:\"\\f38d\"}.fa-d-and-d-beyond:before{content:\"\\f6ca\"}.fa-dailymotion:before{content:\"\\e052\"}.fa-dashcube:before{content:\"\\f210\"}.fa-database:before{content:\"\\f1c0\"}.fa-deaf:before{content:\"\\f2a4\"}.fa-deezer:before{content:\"\\e077\"}.fa-delicious:before{content:\"\\f1a5\"}.fa-democrat:before{content:\"\\f747\"}.fa-deploydog:before{content:\"\\f38e\"}.fa-deskpro:before{content:\"\\f38f\"}.fa-desktop:before{content:\"\\f108\"}.fa-dev:before{content:\"\\f6cc\"}.fa-deviantart:before{content:\"\\f1bd\"}.fa-dharmachakra:before{content:\"\\f655\"}.fa-dhl:before{content:\"\\f790\"}.fa-diagnoses:before{content:\"\\f470\"}.fa-diaspora:before{content:\"\\f791\"}.fa-dice:before{content:\"\\f522\"}.fa-dice-d20:before{content:\"\\f6cf\"}.fa-dice-d6:before{content:\"\\f6d1\"}.fa-dice-five:before{content:\"\\f523\"}.fa-dice-four:before{content:\"\\f524\"}.fa-dice-one:before{content:\"\\f525\"}.fa-dice-six:before{content:\"\\f526\"}.fa-dice-three:before{content:\"\\f527\"}.fa-dice-two:before{content:\"\\f528\"}.fa-digg:before{content:\"\\f1a6\"}.fa-digital-ocean:before{content:\"\\f391\"}.fa-digital-tachograph:before{content:\"\\f566\"}.fa-directions:before{content:\"\\f5eb\"}.fa-discord:before{content:\"\\f392\"}.fa-discourse:before{content:\"\\f393\"}.fa-disease:before{content:\"\\f7fa\"}.fa-divide:before{content:\"\\f529\"}.fa-dizzy:before{content:\"\\f567\"}.fa-dna:before{content:\"\\f471\"}.fa-dochub:before{content:\"\\f394\"}.fa-docker:before{content:\"\\f395\"}.fa-dog:before{content:\"\\f6d3\"}.fa-dollar-sign:before{content:\"\\f155\"}.fa-dolly:before{content:\"\\f472\"}.fa-dolly-flatbed:before{content:\"\\f474\"}.fa-donate:before{content:\"\\f4b9\"}.fa-door-closed:before{content:\"\\f52a\"}.fa-door-open:before{content:\"\\f52b\"}.fa-dot-circle:before{content:\"\\f192\"}.fa-dove:before{content:\"\\f4ba\"}.fa-download:before{content:\"\\f019\"}.fa-draft2digital:before{content:\"\\f396\"}.fa-drafting-compass:before{content:\"\\f568\"}.fa-dragon:before{content:\"\\f6d5\"}.fa-draw-polygon:before{content:\"\\f5ee\"}.fa-dribbble:before{content:\"\\f17d\"}.fa-dribbble-square:before{content:\"\\f397\"}.fa-dropbox:before{content:\"\\f16b\"}.fa-drum:before{content:\"\\f569\"}.fa-drum-steelpan:before{content:\"\\f56a\"}.fa-drumstick-bite:before{content:\"\\f6d7\"}.fa-drupal:before{content:\"\\f1a9\"}.fa-dumbbell:before{content:\"\\f44b\"}.fa-dumpster:before{content:\"\\f793\"}.fa-dumpster-fire:before{content:\"\\f794\"}.fa-dungeon:before{content:\"\\f6d9\"}.fa-dyalog:before{content:\"\\f399\"}.fa-earlybirds:before{content:\"\\f39a\"}.fa-ebay:before{content:\"\\f4f4\"}.fa-edge:before{content:\"\\f282\"}.fa-edge-legacy:before{content:\"\\e078\"}.fa-edit:before{content:\"\\f044\"}.fa-egg:before{content:\"\\f7fb\"}.fa-eject:before{content:\"\\f052\"}.fa-elementor:before{content:\"\\f430\"}.fa-ellipsis-h:before{content:\"\\f141\"}.fa-ellipsis-v:before{content:\"\\f142\"}.fa-ello:before{content:\"\\f5f1\"}.fa-ember:before{content:\"\\f423\"}.fa-empire:before{content:\"\\f1d1\"}.fa-envelope:before{content:\"\\f0e0\"}.fa-envelope-open:before{content:\"\\f2b6\"}.fa-envelope-open-text:before{content:\"\\f658\"}.fa-envelope-square:before{content:\"\\f199\"}.fa-envira:before{content:\"\\f299\"}.fa-equals:before{content:\"\\f52c\"}.fa-eraser:before{content:\"\\f12d\"}.fa-erlang:before{content:\"\\f39d\"}.fa-ethereum:before{content:\"\\f42e\"}.fa-ethernet:before{content:\"\\f796\"}.fa-etsy:before{content:\"\\f2d7\"}.fa-euro-sign:before{content:\"\\f153\"}.fa-evernote:before{content:\"\\f839\"}.fa-exchange-alt:before{content:\"\\f362\"}.fa-exclamation:before{content:\"\\f12a\"}.fa-exclamation-circle:before{content:\"\\f06a\"}.fa-exclamation-triangle:before{content:\"\\f071\"}.fa-expand:before{content:\"\\f065\"}.fa-expand-alt:before{content:\"\\f424\"}.fa-expand-arrows-alt:before{content:\"\\f31e\"}.fa-expeditedssl:before{content:\"\\f23e\"}.fa-external-link-alt:before{content:\"\\f35d\"}.fa-external-link-square-alt:before{content:\"\\f360\"}.fa-eye:before{content:\"\\f06e\"}.fa-eye-dropper:before{content:\"\\f1fb\"}.fa-eye-slash:before{content:\"\\f070\"}.fa-facebook:before{content:\"\\f09a\"}.fa-facebook-f:before{content:\"\\f39e\"}.fa-facebook-messenger:before{content:\"\\f39f\"}.fa-facebook-square:before{content:\"\\f082\"}.fa-fan:before{content:\"\\f863\"}.fa-fantasy-flight-games:before{content:\"\\f6dc\"}.fa-fast-backward:before{content:\"\\f049\"}.fa-fast-forward:before{content:\"\\f050\"}.fa-faucet:before{content:\"\\e005\"}.fa-fax:before{content:\"\\f1ac\"}.fa-feather:before{content:\"\\f52d\"}.fa-feather-alt:before{content:\"\\f56b\"}.fa-fedex:before{content:\"\\f797\"}.fa-fedora:before{content:\"\\f798\"}.fa-female:before{content:\"\\f182\"}.fa-fighter-jet:before{content:\"\\f0fb\"}.fa-figma:before{content:\"\\f799\"}.fa-file:before{content:\"\\f15b\"}.fa-file-alt:before{content:\"\\f15c\"}.fa-file-archive:before{content:\"\\f1c6\"}.fa-file-audio:before{content:\"\\f1c7\"}.fa-file-code:before{content:\"\\f1c9\"}.fa-file-contract:before{content:\"\\f56c\"}.fa-file-csv:before{content:\"\\f6dd\"}.fa-file-download:before{content:\"\\f56d\"}.fa-file-excel:before{content:\"\\f1c3\"}.fa-file-export:before{content:\"\\f56e\"}.fa-file-image:before{content:\"\\f1c5\"}.fa-file-import:before{content:\"\\f56f\"}.fa-file-invoice:before{content:\"\\f570\"}.fa-file-invoice-dollar:before{content:\"\\f571\"}.fa-file-medical:before{content:\"\\f477\"}.fa-file-medical-alt:before{content:\"\\f478\"}.fa-file-pdf:before{content:\"\\f1c1\"}.fa-file-powerpoint:before{content:\"\\f1c4\"}.fa-file-prescription:before{content:\"\\f572\"}.fa-file-signature:before{content:\"\\f573\"}.fa-file-upload:before{content:\"\\f574\"}.fa-file-video:before{content:\"\\f1c8\"}.fa-file-word:before{content:\"\\f1c2\"}.fa-fill:before{content:\"\\f575\"}.fa-fill-drip:before{content:\"\\f576\"}.fa-film:before{content:\"\\f008\"}.fa-filter:before{content:\"\\f0b0\"}.fa-fingerprint:before{content:\"\\f577\"}.fa-fire:before{content:\"\\f06d\"}.fa-fire-alt:before{content:\"\\f7e4\"}.fa-fire-extinguisher:before{content:\"\\f134\"}.fa-firefox:before{content:\"\\f269\"}.fa-firefox-browser:before{content:\"\\e007\"}.fa-first-aid:before{content:\"\\f479\"}.fa-first-order:before{content:\"\\f2b0\"}.fa-first-order-alt:before{content:\"\\f50a\"}.fa-firstdraft:before{content:\"\\f3a1\"}.fa-fish:before{content:\"\\f578\"}.fa-fist-raised:before{content:\"\\f6de\"}.fa-flag:before{content:\"\\f024\"}.fa-flag-checkered:before{content:\"\\f11e\"}.fa-flag-usa:before{content:\"\\f74d\"}.fa-flask:before{content:\"\\f0c3\"}.fa-flickr:before{content:\"\\f16e\"}.fa-flipboard:before{content:\"\\f44d\"}.fa-flushed:before{content:\"\\f579\"}.fa-fly:before{content:\"\\f417\"}.fa-folder:before{content:\"\\f07b\"}.fa-folder-minus:before{content:\"\\f65d\"}.fa-folder-open:before{content:\"\\f07c\"}.fa-folder-plus:before{content:\"\\f65e\"}.fa-font:before{content:\"\\f031\"}.fa-font-awesome:before{content:\"\\f2b4\"}.fa-font-awesome-alt:before{content:\"\\f35c\"}.fa-font-awesome-flag:before{content:\"\\f425\"}.fa-fonticons:before{content:\"\\f280\"}.fa-fonticons-fi:before{content:\"\\f3a2\"}.fa-football-ball:before{content:\"\\f44e\"}.fa-fort-awesome:before{content:\"\\f286\"}.fa-fort-awesome-alt:before{content:\"\\f3a3\"}.fa-forumbee:before{content:\"\\f211\"}.fa-forward:before{content:\"\\f04e\"}.fa-foursquare:before{content:\"\\f180\"}.fa-free-code-camp:before{content:\"\\f2c5\"}.fa-freebsd:before{content:\"\\f3a4\"}.fa-frog:before{content:\"\\f52e\"}.fa-frown:before{content:\"\\f119\"}.fa-frown-open:before{content:\"\\f57a\"}.fa-fulcrum:before{content:\"\\f50b\"}.fa-funnel-dollar:before{content:\"\\f662\"}.fa-futbol:before{content:\"\\f1e3\"}.fa-galactic-republic:before{content:\"\\f50c\"}.fa-galactic-senate:before{content:\"\\f50d\"}.fa-gamepad:before{content:\"\\f11b\"}.fa-gas-pump:before{content:\"\\f52f\"}.fa-gavel:before{content:\"\\f0e3\"}.fa-gem:before{content:\"\\f3a5\"}.fa-genderless:before{content:\"\\f22d\"}.fa-get-pocket:before{content:\"\\f265\"}.fa-gg:before{content:\"\\f260\"}.fa-gg-circle:before{content:\"\\f261\"}.fa-ghost:before{content:\"\\f6e2\"}.fa-gift:before{content:\"\\f06b\"}.fa-gifts:before{content:\"\\f79c\"}.fa-git:before{content:\"\\f1d3\"}.fa-git-alt:before{content:\"\\f841\"}.fa-git-square:before{content:\"\\f1d2\"}.fa-github:before{content:\"\\f09b\"}.fa-github-alt:before{content:\"\\f113\"}.fa-github-square:before{content:\"\\f092\"}.fa-gitkraken:before{content:\"\\f3a6\"}.fa-gitlab:before{content:\"\\f296\"}.fa-gitter:before{content:\"\\f426\"}.fa-glass-cheers:before{content:\"\\f79f\"}.fa-glass-martini:before{content:\"\\f000\"}.fa-glass-martini-alt:before{content:\"\\f57b\"}.fa-glass-whiskey:before{content:\"\\f7a0\"}.fa-glasses:before{content:\"\\f530\"}.fa-glide:before{content:\"\\f2a5\"}.fa-glide-g:before{content:\"\\f2a6\"}.fa-globe:before{content:\"\\f0ac\"}.fa-globe-africa:before{content:\"\\f57c\"}.fa-globe-americas:before{content:\"\\f57d\"}.fa-globe-asia:before{content:\"\\f57e\"}.fa-globe-europe:before{content:\"\\f7a2\"}.fa-gofore:before{content:\"\\f3a7\"}.fa-golf-ball:before{content:\"\\f450\"}.fa-goodreads:before{content:\"\\f3a8\"}.fa-goodreads-g:before{content:\"\\f3a9\"}.fa-google:before{content:\"\\f1a0\"}.fa-google-drive:before{content:\"\\f3aa\"}.fa-google-pay:before{content:\"\\e079\"}.fa-google-play:before{content:\"\\f3ab\"}.fa-google-plus:before{content:\"\\f2b3\"}.fa-google-plus-g:before{content:\"\\f0d5\"}.fa-google-plus-square:before{content:\"\\f0d4\"}.fa-google-wallet:before{content:\"\\f1ee\"}.fa-gopuram:before{content:\"\\f664\"}.fa-graduation-cap:before{content:\"\\f19d\"}.fa-gratipay:before{content:\"\\f184\"}.fa-grav:before{content:\"\\f2d6\"}.fa-greater-than:before{content:\"\\f531\"}.fa-greater-than-equal:before{content:\"\\f532\"}.fa-grimace:before{content:\"\\f57f\"}.fa-grin:before{content:\"\\f580\"}.fa-grin-alt:before{content:\"\\f581\"}.fa-grin-beam:before{content:\"\\f582\"}.fa-grin-beam-sweat:before{content:\"\\f583\"}.fa-grin-hearts:before{content:\"\\f584\"}.fa-grin-squint:before{content:\"\\f585\"}.fa-grin-squint-tears:before{content:\"\\f586\"}.fa-grin-stars:before{content:\"\\f587\"}.fa-grin-tears:before{content:\"\\f588\"}.fa-grin-tongue:before{content:\"\\f589\"}.fa-grin-tongue-squint:before{content:\"\\f58a\"}.fa-grin-tongue-wink:before{content:\"\\f58b\"}.fa-grin-wink:before{content:\"\\f58c\"}.fa-grip-horizontal:before{content:\"\\f58d\"}.fa-grip-lines:before{content:\"\\f7a4\"}.fa-grip-lines-vertical:before{content:\"\\f7a5\"}.fa-grip-vertical:before{content:\"\\f58e\"}.fa-gripfire:before{content:\"\\f3ac\"}.fa-grunt:before{content:\"\\f3ad\"}.fa-guilded:before{content:\"\\e07e\"}.fa-guitar:before{content:\"\\f7a6\"}.fa-gulp:before{content:\"\\f3ae\"}.fa-h-square:before{content:\"\\f0fd\"}.fa-hacker-news:before{content:\"\\f1d4\"}.fa-hacker-news-square:before{content:\"\\f3af\"}.fa-hackerrank:before{content:\"\\f5f7\"}.fa-hamburger:before{content:\"\\f805\"}.fa-hammer:before{content:\"\\f6e3\"}.fa-hamsa:before{content:\"\\f665\"}.fa-hand-holding:before{content:\"\\f4bd\"}.fa-hand-holding-heart:before{content:\"\\f4be\"}.fa-hand-holding-medical:before{content:\"\\e05c\"}.fa-hand-holding-usd:before{content:\"\\f4c0\"}.fa-hand-holding-water:before{content:\"\\f4c1\"}.fa-hand-lizard:before{content:\"\\f258\"}.fa-hand-middle-finger:before{content:\"\\f806\"}.fa-hand-paper:before{content:\"\\f256\"}.fa-hand-peace:before{content:\"\\f25b\"}.fa-hand-point-down:before{content:\"\\f0a7\"}.fa-hand-point-left:before{content:\"\\f0a5\"}.fa-hand-point-right:before{content:\"\\f0a4\"}.fa-hand-point-up:before{content:\"\\f0a6\"}.fa-hand-pointer:before{content:\"\\f25a\"}.fa-hand-rock:before{content:\"\\f255\"}.fa-hand-scissors:before{content:\"\\f257\"}.fa-hand-sparkles:before{content:\"\\e05d\"}.fa-hand-spock:before{content:\"\\f259\"}.fa-hands:before{content:\"\\f4c2\"}.fa-hands-helping:before{content:\"\\f4c4\"}.fa-hands-wash:before{content:\"\\e05e\"}.fa-handshake:before{content:\"\\f2b5\"}.fa-handshake-alt-slash:before{content:\"\\e05f\"}.fa-handshake-slash:before{content:\"\\e060\"}.fa-hanukiah:before{content:\"\\f6e6\"}.fa-hard-hat:before{content:\"\\f807\"}.fa-hashtag:before{content:\"\\f292\"}.fa-hat-cowboy:before{content:\"\\f8c0\"}.fa-hat-cowboy-side:before{content:\"\\f8c1\"}.fa-hat-wizard:before{content:\"\\f6e8\"}.fa-hdd:before{content:\"\\f0a0\"}.fa-head-side-cough:before{content:\"\\e061\"}.fa-head-side-cough-slash:before{content:\"\\e062\"}.fa-head-side-mask:before{content:\"\\e063\"}.fa-head-side-virus:before{content:\"\\e064\"}.fa-heading:before{content:\"\\f1dc\"}.fa-headphones:before{content:\"\\f025\"}.fa-headphones-alt:before{content:\"\\f58f\"}.fa-headset:before{content:\"\\f590\"}.fa-heart:before{content:\"\\f004\"}.fa-heart-broken:before{content:\"\\f7a9\"}.fa-heartbeat:before{content:\"\\f21e\"}.fa-helicopter:before{content:\"\\f533\"}.fa-highlighter:before{content:\"\\f591\"}.fa-hiking:before{content:\"\\f6ec\"}.fa-hippo:before{content:\"\\f6ed\"}.fa-hips:before{content:\"\\f452\"}.fa-hire-a-helper:before{content:\"\\f3b0\"}.fa-history:before{content:\"\\f1da\"}.fa-hive:before{content:\"\\e07f\"}.fa-hockey-puck:before{content:\"\\f453\"}.fa-holly-berry:before{content:\"\\f7aa\"}.fa-home:before{content:\"\\f015\"}.fa-hooli:before{content:\"\\f427\"}.fa-hornbill:before{content:\"\\f592\"}.fa-horse:before{content:\"\\f6f0\"}.fa-horse-head:before{content:\"\\f7ab\"}.fa-hospital:before{content:\"\\f0f8\"}.fa-hospital-alt:before{content:\"\\f47d\"}.fa-hospital-symbol:before{content:\"\\f47e\"}.fa-hospital-user:before{content:\"\\f80d\"}.fa-hot-tub:before{content:\"\\f593\"}.fa-hotdog:before{content:\"\\f80f\"}.fa-hotel:before{content:\"\\f594\"}.fa-hotjar:before{content:\"\\f3b1\"}.fa-hourglass:before{content:\"\\f254\"}.fa-hourglass-end:before{content:\"\\f253\"}.fa-hourglass-half:before{content:\"\\f252\"}.fa-hourglass-start:before{content:\"\\f251\"}.fa-house-damage:before{content:\"\\f6f1\"}.fa-house-user:before{content:\"\\e065\"}.fa-houzz:before{content:\"\\f27c\"}.fa-hryvnia:before{content:\"\\f6f2\"}.fa-html5:before{content:\"\\f13b\"}.fa-hubspot:before{content:\"\\f3b2\"}.fa-i-cursor:before{content:\"\\f246\"}.fa-ice-cream:before{content:\"\\f810\"}.fa-icicles:before{content:\"\\f7ad\"}.fa-icons:before{content:\"\\f86d\"}.fa-id-badge:before{content:\"\\f2c1\"}.fa-id-card:before{content:\"\\f2c2\"}.fa-id-card-alt:before{content:\"\\f47f\"}.fa-ideal:before{content:\"\\e013\"}.fa-igloo:before{content:\"\\f7ae\"}.fa-image:before{content:\"\\f03e\"}.fa-images:before{content:\"\\f302\"}.fa-imdb:before{content:\"\\f2d8\"}.fa-inbox:before{content:\"\\f01c\"}.fa-indent:before{content:\"\\f03c\"}.fa-industry:before{content:\"\\f275\"}.fa-infinity:before{content:\"\\f534\"}.fa-info:before{content:\"\\f129\"}.fa-info-circle:before{content:\"\\f05a\"}.fa-innosoft:before{content:\"\\e080\"}.fa-instagram:before{content:\"\\f16d\"}.fa-instagram-square:before{content:\"\\e055\"}.fa-instalod:before{content:\"\\e081\"}.fa-intercom:before{content:\"\\f7af\"}.fa-internet-explorer:before{content:\"\\f26b\"}.fa-invision:before{content:\"\\f7b0\"}.fa-ioxhost:before{content:\"\\f208\"}.fa-italic:before{content:\"\\f033\"}.fa-itch-io:before{content:\"\\f83a\"}.fa-itunes:before{content:\"\\f3b4\"}.fa-itunes-note:before{content:\"\\f3b5\"}.fa-java:before{content:\"\\f4e4\"}.fa-jedi:before{content:\"\\f669\"}.fa-jedi-order:before{content:\"\\f50e\"}.fa-jenkins:before{content:\"\\f3b6\"}.fa-jira:before{content:\"\\f7b1\"}.fa-joget:before{content:\"\\f3b7\"}.fa-joint:before{content:\"\\f595\"}.fa-joomla:before{content:\"\\f1aa\"}.fa-journal-whills:before{content:\"\\f66a\"}.fa-js:before{content:\"\\f3b8\"}.fa-js-square:before{content:\"\\f3b9\"}.fa-jsfiddle:before{content:\"\\f1cc\"}.fa-kaaba:before{content:\"\\f66b\"}.fa-kaggle:before{content:\"\\f5fa\"}.fa-key:before{content:\"\\f084\"}.fa-keybase:before{content:\"\\f4f5\"}.fa-keyboard:before{content:\"\\f11c\"}.fa-keycdn:before{content:\"\\f3ba\"}.fa-khanda:before{content:\"\\f66d\"}.fa-kickstarter:before{content:\"\\f3bb\"}.fa-kickstarter-k:before{content:\"\\f3bc\"}.fa-kiss:before{content:\"\\f596\"}.fa-kiss-beam:before{content:\"\\f597\"}.fa-kiss-wink-heart:before{content:\"\\f598\"}.fa-kiwi-bird:before{content:\"\\f535\"}.fa-korvue:before{content:\"\\f42f\"}.fa-landmark:before{content:\"\\f66f\"}.fa-language:before{content:\"\\f1ab\"}.fa-laptop:before{content:\"\\f109\"}.fa-laptop-code:before{content:\"\\f5fc\"}.fa-laptop-house:before{content:\"\\e066\"}.fa-laptop-medical:before{content:\"\\f812\"}.fa-laravel:before{content:\"\\f3bd\"}.fa-lastfm:before{content:\"\\f202\"}.fa-lastfm-square:before{content:\"\\f203\"}.fa-laugh:before{content:\"\\f599\"}.fa-laugh-beam:before{content:\"\\f59a\"}.fa-laugh-squint:before{content:\"\\f59b\"}.fa-laugh-wink:before{content:\"\\f59c\"}.fa-layer-group:before{content:\"\\f5fd\"}.fa-leaf:before{content:\"\\f06c\"}.fa-leanpub:before{content:\"\\f212\"}.fa-lemon:before{content:\"\\f094\"}.fa-less:before{content:\"\\f41d\"}.fa-less-than:before{content:\"\\f536\"}.fa-less-than-equal:before{content:\"\\f537\"}.fa-level-down-alt:before{content:\"\\f3be\"}.fa-level-up-alt:before{content:\"\\f3bf\"}.fa-life-ring:before{content:\"\\f1cd\"}.fa-lightbulb:before{content:\"\\f0eb\"}.fa-line:before{content:\"\\f3c0\"}.fa-link:before{content:\"\\f0c1\"}.fa-linkedin:before{content:\"\\f08c\"}.fa-linkedin-in:before{content:\"\\f0e1\"}.fa-linode:before{content:\"\\f2b8\"}.fa-linux:before{content:\"\\f17c\"}.fa-lira-sign:before{content:\"\\f195\"}.fa-list:before{content:\"\\f03a\"}.fa-list-alt:before{content:\"\\f022\"}.fa-list-ol:before{content:\"\\f0cb\"}.fa-list-ul:before{content:\"\\f0ca\"}.fa-location-arrow:before{content:\"\\f124\"}.fa-lock:before{content:\"\\f023\"}.fa-lock-open:before{content:\"\\f3c1\"}.fa-long-arrow-alt-down:before{content:\"\\f309\"}.fa-long-arrow-alt-left:before{content:\"\\f30a\"}.fa-long-arrow-alt-right:before{content:\"\\f30b\"}.fa-long-arrow-alt-up:before{content:\"\\f30c\"}.fa-low-vision:before{content:\"\\f2a8\"}.fa-luggage-cart:before{content:\"\\f59d\"}.fa-lungs:before{content:\"\\f604\"}.fa-lungs-virus:before{content:\"\\e067\"}.fa-lyft:before{content:\"\\f3c3\"}.fa-magento:before{content:\"\\f3c4\"}.fa-magic:before{content:\"\\f0d0\"}.fa-magnet:before{content:\"\\f076\"}.fa-mail-bulk:before{content:\"\\f674\"}.fa-mailchimp:before{content:\"\\f59e\"}.fa-male:before{content:\"\\f183\"}.fa-mandalorian:before{content:\"\\f50f\"}.fa-map:before{content:\"\\f279\"}.fa-map-marked:before{content:\"\\f59f\"}.fa-map-marked-alt:before{content:\"\\f5a0\"}.fa-map-marker:before{content:\"\\f041\"}.fa-map-marker-alt:before{content:\"\\f3c5\"}.fa-map-pin:before{content:\"\\f276\"}.fa-map-signs:before{content:\"\\f277\"}.fa-markdown:before{content:\"\\f60f\"}.fa-marker:before{content:\"\\f5a1\"}.fa-mars:before{content:\"\\f222\"}.fa-mars-double:before{content:\"\\f227\"}.fa-mars-stroke:before{content:\"\\f229\"}.fa-mars-stroke-h:before{content:\"\\f22b\"}.fa-mars-stroke-v:before{content:\"\\f22a\"}.fa-mask:before{content:\"\\f6fa\"}.fa-mastodon:before{content:\"\\f4f6\"}.fa-maxcdn:before{content:\"\\f136\"}.fa-mdb:before{content:\"\\f8ca\"}.fa-medal:before{content:\"\\f5a2\"}.fa-medapps:before{content:\"\\f3c6\"}.fa-medium:before{content:\"\\f23a\"}.fa-medium-m:before{content:\"\\f3c7\"}.fa-medkit:before{content:\"\\f0fa\"}.fa-medrt:before{content:\"\\f3c8\"}.fa-meetup:before{content:\"\\f2e0\"}.fa-megaport:before{content:\"\\f5a3\"}.fa-meh:before{content:\"\\f11a\"}.fa-meh-blank:before{content:\"\\f5a4\"}.fa-meh-rolling-eyes:before{content:\"\\f5a5\"}.fa-memory:before{content:\"\\f538\"}.fa-mendeley:before{content:\"\\f7b3\"}.fa-menorah:before{content:\"\\f676\"}.fa-mercury:before{content:\"\\f223\"}.fa-meteor:before{content:\"\\f753\"}.fa-microblog:before{content:\"\\e01a\"}.fa-microchip:before{content:\"\\f2db\"}.fa-microphone:before{content:\"\\f130\"}.fa-microphone-alt:before{content:\"\\f3c9\"}.fa-microphone-alt-slash:before{content:\"\\f539\"}.fa-microphone-slash:before{content:\"\\f131\"}.fa-microscope:before{content:\"\\f610\"}.fa-microsoft:before{content:\"\\f3ca\"}.fa-minus:before{content:\"\\f068\"}.fa-minus-circle:before{content:\"\\f056\"}.fa-minus-square:before{content:\"\\f146\"}.fa-mitten:before{content:\"\\f7b5\"}.fa-mix:before{content:\"\\f3cb\"}.fa-mixcloud:before{content:\"\\f289\"}.fa-mixer:before{content:\"\\e056\"}.fa-mizuni:before{content:\"\\f3cc\"}.fa-mobile:before{content:\"\\f10b\"}.fa-mobile-alt:before{content:\"\\f3cd\"}.fa-modx:before{content:\"\\f285\"}.fa-monero:before{content:\"\\f3d0\"}.fa-money-bill:before{content:\"\\f0d6\"}.fa-money-bill-alt:before{content:\"\\f3d1\"}.fa-money-bill-wave:before{content:\"\\f53a\"}.fa-money-bill-wave-alt:before{content:\"\\f53b\"}.fa-money-check:before{content:\"\\f53c\"}.fa-money-check-alt:before{content:\"\\f53d\"}.fa-monument:before{content:\"\\f5a6\"}.fa-moon:before{content:\"\\f186\"}.fa-mortar-pestle:before{content:\"\\f5a7\"}.fa-mosque:before{content:\"\\f678\"}.fa-motorcycle:before{content:\"\\f21c\"}.fa-mountain:before{content:\"\\f6fc\"}.fa-mouse:before{content:\"\\f8cc\"}.fa-mouse-pointer:before{content:\"\\f245\"}.fa-mug-hot:before{content:\"\\f7b6\"}.fa-music:before{content:\"\\f001\"}.fa-napster:before{content:\"\\f3d2\"}.fa-neos:before{content:\"\\f612\"}.fa-network-wired:before{content:\"\\f6ff\"}.fa-neuter:before{content:\"\\f22c\"}.fa-newspaper:before{content:\"\\f1ea\"}.fa-nimblr:before{content:\"\\f5a8\"}.fa-node:before{content:\"\\f419\"}.fa-node-js:before{content:\"\\f3d3\"}.fa-not-equal:before{content:\"\\f53e\"}.fa-notes-medical:before{content:\"\\f481\"}.fa-npm:before{content:\"\\f3d4\"}.fa-ns8:before{content:\"\\f3d5\"}.fa-nutritionix:before{content:\"\\f3d6\"}.fa-object-group:before{content:\"\\f247\"}.fa-object-ungroup:before{content:\"\\f248\"}.fa-octopus-deploy:before{content:\"\\e082\"}.fa-odnoklassniki:before{content:\"\\f263\"}.fa-odnoklassniki-square:before{content:\"\\f264\"}.fa-oil-can:before{content:\"\\f613\"}.fa-old-republic:before{content:\"\\f510\"}.fa-om:before{content:\"\\f679\"}.fa-opencart:before{content:\"\\f23d\"}.fa-openid:before{content:\"\\f19b\"}.fa-opera:before{content:\"\\f26a\"}.fa-optin-monster:before{content:\"\\f23c\"}.fa-orcid:before{content:\"\\f8d2\"}.fa-osi:before{content:\"\\f41a\"}.fa-otter:before{content:\"\\f700\"}.fa-outdent:before{content:\"\\f03b\"}.fa-page4:before{content:\"\\f3d7\"}.fa-pagelines:before{content:\"\\f18c\"}.fa-pager:before{content:\"\\f815\"}.fa-paint-brush:before{content:\"\\f1fc\"}.fa-paint-roller:before{content:\"\\f5aa\"}.fa-palette:before{content:\"\\f53f\"}.fa-palfed:before{content:\"\\f3d8\"}.fa-pallet:before{content:\"\\f482\"}.fa-paper-plane:before{content:\"\\f1d8\"}.fa-paperclip:before{content:\"\\f0c6\"}.fa-parachute-box:before{content:\"\\f4cd\"}.fa-paragraph:before{content:\"\\f1dd\"}.fa-parking:before{content:\"\\f540\"}.fa-passport:before{content:\"\\f5ab\"}.fa-pastafarianism:before{content:\"\\f67b\"}.fa-paste:before{content:\"\\f0ea\"}.fa-patreon:before{content:\"\\f3d9\"}.fa-pause:before{content:\"\\f04c\"}.fa-pause-circle:before{content:\"\\f28b\"}.fa-paw:before{content:\"\\f1b0\"}.fa-paypal:before{content:\"\\f1ed\"}.fa-peace:before{content:\"\\f67c\"}.fa-pen:before{content:\"\\f304\"}.fa-pen-alt:before{content:\"\\f305\"}.fa-pen-fancy:before{content:\"\\f5ac\"}.fa-pen-nib:before{content:\"\\f5ad\"}.fa-pen-square:before{content:\"\\f14b\"}.fa-pencil-alt:before{content:\"\\f303\"}.fa-pencil-ruler:before{content:\"\\f5ae\"}.fa-penny-arcade:before{content:\"\\f704\"}.fa-people-arrows:before{content:\"\\e068\"}.fa-people-carry:before{content:\"\\f4ce\"}.fa-pepper-hot:before{content:\"\\f816\"}.fa-perbyte:before{content:\"\\e083\"}.fa-percent:before{content:\"\\f295\"}.fa-percentage:before{content:\"\\f541\"}.fa-periscope:before{content:\"\\f3da\"}.fa-person-booth:before{content:\"\\f756\"}.fa-phabricator:before{content:\"\\f3db\"}.fa-phoenix-framework:before{content:\"\\f3dc\"}.fa-phoenix-squadron:before{content:\"\\f511\"}.fa-phone:before{content:\"\\f095\"}.fa-phone-alt:before{content:\"\\f879\"}.fa-phone-slash:before{content:\"\\f3dd\"}.fa-phone-square:before{content:\"\\f098\"}.fa-phone-square-alt:before{content:\"\\f87b\"}.fa-phone-volume:before{content:\"\\f2a0\"}.fa-photo-video:before{content:\"\\f87c\"}.fa-php:before{content:\"\\f457\"}.fa-pied-piper:before{content:\"\\f2ae\"}.fa-pied-piper-alt:before{content:\"\\f1a8\"}.fa-pied-piper-hat:before{content:\"\\f4e5\"}.fa-pied-piper-pp:before{content:\"\\f1a7\"}.fa-pied-piper-square:before{content:\"\\e01e\"}.fa-piggy-bank:before{content:\"\\f4d3\"}.fa-pills:before{content:\"\\f484\"}.fa-pinterest:before{content:\"\\f0d2\"}.fa-pinterest-p:before{content:\"\\f231\"}.fa-pinterest-square:before{content:\"\\f0d3\"}.fa-pizza-slice:before{content:\"\\f818\"}.fa-place-of-worship:before{content:\"\\f67f\"}.fa-plane:before{content:\"\\f072\"}.fa-plane-arrival:before{content:\"\\f5af\"}.fa-plane-departure:before{content:\"\\f5b0\"}.fa-plane-slash:before{content:\"\\e069\"}.fa-play:before{content:\"\\f04b\"}.fa-play-circle:before{content:\"\\f144\"}.fa-playstation:before{content:\"\\f3df\"}.fa-plug:before{content:\"\\f1e6\"}.fa-plus:before{content:\"\\f067\"}.fa-plus-circle:before{content:\"\\f055\"}.fa-plus-square:before{content:\"\\f0fe\"}.fa-podcast:before{content:\"\\f2ce\"}.fa-poll:before{content:\"\\f681\"}.fa-poll-h:before{content:\"\\f682\"}.fa-poo:before{content:\"\\f2fe\"}.fa-poo-storm:before{content:\"\\f75a\"}.fa-poop:before{content:\"\\f619\"}.fa-portrait:before{content:\"\\f3e0\"}.fa-pound-sign:before{content:\"\\f154\"}.fa-power-off:before{content:\"\\f011\"}.fa-pray:before{content:\"\\f683\"}.fa-praying-hands:before{content:\"\\f684\"}.fa-prescription:before{content:\"\\f5b1\"}.fa-prescription-bottle:before{content:\"\\f485\"}.fa-prescription-bottle-alt:before{content:\"\\f486\"}.fa-print:before{content:\"\\f02f\"}.fa-procedures:before{content:\"\\f487\"}.fa-product-hunt:before{content:\"\\f288\"}.fa-project-diagram:before{content:\"\\f542\"}.fa-pump-medical:before{content:\"\\e06a\"}.fa-pump-soap:before{content:\"\\e06b\"}.fa-pushed:before{content:\"\\f3e1\"}.fa-puzzle-piece:before{content:\"\\f12e\"}.fa-python:before{content:\"\\f3e2\"}.fa-qq:before{content:\"\\f1d6\"}.fa-qrcode:before{content:\"\\f029\"}.fa-question:before{content:\"\\f128\"}.fa-question-circle:before{content:\"\\f059\"}.fa-quidditch:before{content:\"\\f458\"}.fa-quinscape:before{content:\"\\f459\"}.fa-quora:before{content:\"\\f2c4\"}.fa-quote-left:before{content:\"\\f10d\"}.fa-quote-right:before{content:\"\\f10e\"}.fa-quran:before{content:\"\\f687\"}.fa-r-project:before{content:\"\\f4f7\"}.fa-radiation:before{content:\"\\f7b9\"}.fa-radiation-alt:before{content:\"\\f7ba\"}.fa-rainbow:before{content:\"\\f75b\"}.fa-random:before{content:\"\\f074\"}.fa-raspberry-pi:before{content:\"\\f7bb\"}.fa-ravelry:before{content:\"\\f2d9\"}.fa-react:before{content:\"\\f41b\"}.fa-reacteurope:before{content:\"\\f75d\"}.fa-readme:before{content:\"\\f4d5\"}.fa-rebel:before{content:\"\\f1d0\"}.fa-receipt:before{content:\"\\f543\"}.fa-record-vinyl:before{content:\"\\f8d9\"}.fa-recycle:before{content:\"\\f1b8\"}.fa-red-river:before{content:\"\\f3e3\"}.fa-reddit:before{content:\"\\f1a1\"}.fa-reddit-alien:before{content:\"\\f281\"}.fa-reddit-square:before{content:\"\\f1a2\"}.fa-redhat:before{content:\"\\f7bc\"}.fa-redo:before{content:\"\\f01e\"}.fa-redo-alt:before{content:\"\\f2f9\"}.fa-registered:before{content:\"\\f25d\"}.fa-remove-format:before{content:\"\\f87d\"}.fa-renren:before{content:\"\\f18b\"}.fa-reply:before{content:\"\\f3e5\"}.fa-reply-all:before{content:\"\\f122\"}.fa-replyd:before{content:\"\\f3e6\"}.fa-republican:before{content:\"\\f75e\"}.fa-researchgate:before{content:\"\\f4f8\"}.fa-resolving:before{content:\"\\f3e7\"}.fa-restroom:before{content:\"\\f7bd\"}.fa-retweet:before{content:\"\\f079\"}.fa-rev:before{content:\"\\f5b2\"}.fa-ribbon:before{content:\"\\f4d6\"}.fa-ring:before{content:\"\\f70b\"}.fa-road:before{content:\"\\f018\"}.fa-robot:before{content:\"\\f544\"}.fa-rocket:before{content:\"\\f135\"}.fa-rocketchat:before{content:\"\\f3e8\"}.fa-rockrms:before{content:\"\\f3e9\"}.fa-route:before{content:\"\\f4d7\"}.fa-rss:before{content:\"\\f09e\"}.fa-rss-square:before{content:\"\\f143\"}.fa-ruble-sign:before{content:\"\\f158\"}.fa-ruler:before{content:\"\\f545\"}.fa-ruler-combined:before{content:\"\\f546\"}.fa-ruler-horizontal:before{content:\"\\f547\"}.fa-ruler-vertical:before{content:\"\\f548\"}.fa-running:before{content:\"\\f70c\"}.fa-rupee-sign:before{content:\"\\f156\"}.fa-rust:before{content:\"\\e07a\"}.fa-sad-cry:before{content:\"\\f5b3\"}.fa-sad-tear:before{content:\"\\f5b4\"}.fa-safari:before{content:\"\\f267\"}.fa-salesforce:before{content:\"\\f83b\"}.fa-sass:before{content:\"\\f41e\"}.fa-satellite:before{content:\"\\f7bf\"}.fa-satellite-dish:before{content:\"\\f7c0\"}.fa-save:before{content:\"\\f0c7\"}.fa-schlix:before{content:\"\\f3ea\"}.fa-school:before{content:\"\\f549\"}.fa-screwdriver:before{content:\"\\f54a\"}.fa-scribd:before{content:\"\\f28a\"}.fa-scroll:before{content:\"\\f70e\"}.fa-sd-card:before{content:\"\\f7c2\"}.fa-search:before{content:\"\\f002\"}.fa-search-dollar:before{content:\"\\f688\"}.fa-search-location:before{content:\"\\f689\"}.fa-search-minus:before{content:\"\\f010\"}.fa-search-plus:before{content:\"\\f00e\"}.fa-searchengin:before{content:\"\\f3eb\"}.fa-seedling:before{content:\"\\f4d8\"}.fa-sellcast:before{content:\"\\f2da\"}.fa-sellsy:before{content:\"\\f213\"}.fa-server:before{content:\"\\f233\"}.fa-servicestack:before{content:\"\\f3ec\"}.fa-shapes:before{content:\"\\f61f\"}.fa-share:before{content:\"\\f064\"}.fa-share-alt:before{content:\"\\f1e0\"}.fa-share-alt-square:before{content:\"\\f1e1\"}.fa-share-square:before{content:\"\\f14d\"}.fa-shekel-sign:before{content:\"\\f20b\"}.fa-shield-alt:before{content:\"\\f3ed\"}.fa-shield-virus:before{content:\"\\e06c\"}.fa-ship:before{content:\"\\f21a\"}.fa-shipping-fast:before{content:\"\\f48b\"}.fa-shirtsinbulk:before{content:\"\\f214\"}.fa-shoe-prints:before{content:\"\\f54b\"}.fa-shopify:before{content:\"\\e057\"}.fa-shopping-bag:before{content:\"\\f290\"}.fa-shopping-basket:before{content:\"\\f291\"}.fa-shopping-cart:before{content:\"\\f07a\"}.fa-shopware:before{content:\"\\f5b5\"}.fa-shower:before{content:\"\\f2cc\"}.fa-shuttle-van:before{content:\"\\f5b6\"}.fa-sign:before{content:\"\\f4d9\"}.fa-sign-in-alt:before{content:\"\\f2f6\"}.fa-sign-language:before{content:\"\\f2a7\"}.fa-sign-out-alt:before{content:\"\\f2f5\"}.fa-signal:before{content:\"\\f012\"}.fa-signature:before{content:\"\\f5b7\"}.fa-sim-card:before{content:\"\\f7c4\"}.fa-simplybuilt:before{content:\"\\f215\"}.fa-sink:before{content:\"\\e06d\"}.fa-sistrix:before{content:\"\\f3ee\"}.fa-sitemap:before{content:\"\\f0e8\"}.fa-sith:before{content:\"\\f512\"}.fa-skating:before{content:\"\\f7c5\"}.fa-sketch:before{content:\"\\f7c6\"}.fa-skiing:before{content:\"\\f7c9\"}.fa-skiing-nordic:before{content:\"\\f7ca\"}.fa-skull:before{content:\"\\f54c\"}.fa-skull-crossbones:before{content:\"\\f714\"}.fa-skyatlas:before{content:\"\\f216\"}.fa-skype:before{content:\"\\f17e\"}.fa-slack:before{content:\"\\f198\"}.fa-slack-hash:before{content:\"\\f3ef\"}.fa-slash:before{content:\"\\f715\"}.fa-sleigh:before{content:\"\\f7cc\"}.fa-sliders-h:before{content:\"\\f1de\"}.fa-slideshare:before{content:\"\\f1e7\"}.fa-smile:before{content:\"\\f118\"}.fa-smile-beam:before{content:\"\\f5b8\"}.fa-smile-wink:before{content:\"\\f4da\"}.fa-smog:before{content:\"\\f75f\"}.fa-smoking:before{content:\"\\f48d\"}.fa-smoking-ban:before{content:\"\\f54d\"}.fa-sms:before{content:\"\\f7cd\"}.fa-snapchat:before{content:\"\\f2ab\"}.fa-snapchat-ghost:before{content:\"\\f2ac\"}.fa-snapchat-square:before{content:\"\\f2ad\"}.fa-snowboarding:before{content:\"\\f7ce\"}.fa-snowflake:before{content:\"\\f2dc\"}.fa-snowman:before{content:\"\\f7d0\"}.fa-snowplow:before{content:\"\\f7d2\"}.fa-soap:before{content:\"\\e06e\"}.fa-socks:before{content:\"\\f696\"}.fa-solar-panel:before{content:\"\\f5ba\"}.fa-sort:before{content:\"\\f0dc\"}.fa-sort-alpha-down:before{content:\"\\f15d\"}.fa-sort-alpha-down-alt:before{content:\"\\f881\"}.fa-sort-alpha-up:before{content:\"\\f15e\"}.fa-sort-alpha-up-alt:before{content:\"\\f882\"}.fa-sort-amount-down:before{content:\"\\f160\"}.fa-sort-amount-down-alt:before{content:\"\\f884\"}.fa-sort-amount-up:before{content:\"\\f161\"}.fa-sort-amount-up-alt:before{content:\"\\f885\"}.fa-sort-down:before{content:\"\\f0dd\"}.fa-sort-numeric-down:before{content:\"\\f162\"}.fa-sort-numeric-down-alt:before{content:\"\\f886\"}.fa-sort-numeric-up:before{content:\"\\f163\"}.fa-sort-numeric-up-alt:before{content:\"\\f887\"}.fa-sort-up:before{content:\"\\f0de\"}.fa-soundcloud:before{content:\"\\f1be\"}.fa-sourcetree:before{content:\"\\f7d3\"}.fa-spa:before{content:\"\\f5bb\"}.fa-space-shuttle:before{content:\"\\f197\"}.fa-speakap:before{content:\"\\f3f3\"}.fa-speaker-deck:before{content:\"\\f83c\"}.fa-spell-check:before{content:\"\\f891\"}.fa-spider:before{content:\"\\f717\"}.fa-spinner:before{content:\"\\f110\"}.fa-splotch:before{content:\"\\f5bc\"}.fa-spotify:before{content:\"\\f1bc\"}.fa-spray-can:before{content:\"\\f5bd\"}.fa-square:before{content:\"\\f0c8\"}.fa-square-full:before{content:\"\\f45c\"}.fa-square-root-alt:before{content:\"\\f698\"}.fa-squarespace:before{content:\"\\f5be\"}.fa-stack-exchange:before{content:\"\\f18d\"}.fa-stack-overflow:before{content:\"\\f16c\"}.fa-stackpath:before{content:\"\\f842\"}.fa-stamp:before{content:\"\\f5bf\"}.fa-star:before{content:\"\\f005\"}.fa-star-and-crescent:before{content:\"\\f699\"}.fa-star-half:before{content:\"\\f089\"}.fa-star-half-alt:before{content:\"\\f5c0\"}.fa-star-of-david:before{content:\"\\f69a\"}.fa-star-of-life:before{content:\"\\f621\"}.fa-staylinked:before{content:\"\\f3f5\"}.fa-steam:before{content:\"\\f1b6\"}.fa-steam-square:before{content:\"\\f1b7\"}.fa-steam-symbol:before{content:\"\\f3f6\"}.fa-step-backward:before{content:\"\\f048\"}.fa-step-forward:before{content:\"\\f051\"}.fa-stethoscope:before{content:\"\\f0f1\"}.fa-sticker-mule:before{content:\"\\f3f7\"}.fa-sticky-note:before{content:\"\\f249\"}.fa-stop:before{content:\"\\f04d\"}.fa-stop-circle:before{content:\"\\f28d\"}.fa-stopwatch:before{content:\"\\f2f2\"}.fa-stopwatch-20:before{content:\"\\e06f\"}.fa-store:before{content:\"\\f54e\"}.fa-store-alt:before{content:\"\\f54f\"}.fa-store-alt-slash:before{content:\"\\e070\"}.fa-store-slash:before{content:\"\\e071\"}.fa-strava:before{content:\"\\f428\"}.fa-stream:before{content:\"\\f550\"}.fa-street-view:before{content:\"\\f21d\"}.fa-strikethrough:before{content:\"\\f0cc\"}.fa-stripe:before{content:\"\\f429\"}.fa-stripe-s:before{content:\"\\f42a\"}.fa-stroopwafel:before{content:\"\\f551\"}.fa-studiovinari:before{content:\"\\f3f8\"}.fa-stumbleupon:before{content:\"\\f1a4\"}.fa-stumbleupon-circle:before{content:\"\\f1a3\"}.fa-subscript:before{content:\"\\f12c\"}.fa-subway:before{content:\"\\f239\"}.fa-suitcase:before{content:\"\\f0f2\"}.fa-suitcase-rolling:before{content:\"\\f5c1\"}.fa-sun:before{content:\"\\f185\"}.fa-superpowers:before{content:\"\\f2dd\"}.fa-superscript:before{content:\"\\f12b\"}.fa-supple:before{content:\"\\f3f9\"}.fa-surprise:before{content:\"\\f5c2\"}.fa-suse:before{content:\"\\f7d6\"}.fa-swatchbook:before{content:\"\\f5c3\"}.fa-swift:before{content:\"\\f8e1\"}.fa-swimmer:before{content:\"\\f5c4\"}.fa-swimming-pool:before{content:\"\\f5c5\"}.fa-symfony:before{content:\"\\f83d\"}.fa-synagogue:before{content:\"\\f69b\"}.fa-sync:before{content:\"\\f021\"}.fa-sync-alt:before{content:\"\\f2f1\"}.fa-syringe:before{content:\"\\f48e\"}.fa-table:before{content:\"\\f0ce\"}.fa-table-tennis:before{content:\"\\f45d\"}.fa-tablet:before{content:\"\\f10a\"}.fa-tablet-alt:before{content:\"\\f3fa\"}.fa-tablets:before{content:\"\\f490\"}.fa-tachometer-alt:before{content:\"\\f3fd\"}.fa-tag:before{content:\"\\f02b\"}.fa-tags:before{content:\"\\f02c\"}.fa-tape:before{content:\"\\f4db\"}.fa-tasks:before{content:\"\\f0ae\"}.fa-taxi:before{content:\"\\f1ba\"}.fa-teamspeak:before{content:\"\\f4f9\"}.fa-teeth:before{content:\"\\f62e\"}.fa-teeth-open:before{content:\"\\f62f\"}.fa-telegram:before{content:\"\\f2c6\"}.fa-telegram-plane:before{content:\"\\f3fe\"}.fa-temperature-high:before{content:\"\\f769\"}.fa-temperature-low:before{content:\"\\f76b\"}.fa-tencent-weibo:before{content:\"\\f1d5\"}.fa-tenge:before{content:\"\\f7d7\"}.fa-terminal:before{content:\"\\f120\"}.fa-text-height:before{content:\"\\f034\"}.fa-text-width:before{content:\"\\f035\"}.fa-th:before{content:\"\\f00a\"}.fa-th-large:before{content:\"\\f009\"}.fa-th-list:before{content:\"\\f00b\"}.fa-the-red-yeti:before{content:\"\\f69d\"}.fa-theater-masks:before{content:\"\\f630\"}.fa-themeco:before{content:\"\\f5c6\"}.fa-themeisle:before{content:\"\\f2b2\"}.fa-thermometer:before{content:\"\\f491\"}.fa-thermometer-empty:before{content:\"\\f2cb\"}.fa-thermometer-full:before{content:\"\\f2c7\"}.fa-thermometer-half:before{content:\"\\f2c9\"}.fa-thermometer-quarter:before{content:\"\\f2ca\"}.fa-thermometer-three-quarters:before{content:\"\\f2c8\"}.fa-think-peaks:before{content:\"\\f731\"}.fa-thumbs-down:before{content:\"\\f165\"}.fa-thumbs-up:before{content:\"\\f164\"}.fa-thumbtack:before{content:\"\\f08d\"}.fa-ticket-alt:before{content:\"\\f3ff\"}.fa-tiktok:before{content:\"\\e07b\"}.fa-times:before{content:\"\\f00d\"}.fa-times-circle:before{content:\"\\f057\"}.fa-tint:before{content:\"\\f043\"}.fa-tint-slash:before{content:\"\\f5c7\"}.fa-tired:before{content:\"\\f5c8\"}.fa-toggle-off:before{content:\"\\f204\"}.fa-toggle-on:before{content:\"\\f205\"}.fa-toilet:before{content:\"\\f7d8\"}.fa-toilet-paper:before{content:\"\\f71e\"}.fa-toilet-paper-slash:before{content:\"\\e072\"}.fa-toolbox:before{content:\"\\f552\"}.fa-tools:before{content:\"\\f7d9\"}.fa-tooth:before{content:\"\\f5c9\"}.fa-torah:before{content:\"\\f6a0\"}.fa-torii-gate:before{content:\"\\f6a1\"}.fa-tractor:before{content:\"\\f722\"}.fa-trade-federation:before{content:\"\\f513\"}.fa-trademark:before{content:\"\\f25c\"}.fa-traffic-light:before{content:\"\\f637\"}.fa-trailer:before{content:\"\\e041\"}.fa-train:before{content:\"\\f238\"}.fa-tram:before{content:\"\\f7da\"}.fa-transgender:before{content:\"\\f224\"}.fa-transgender-alt:before{content:\"\\f225\"}.fa-trash:before{content:\"\\f1f8\"}.fa-trash-alt:before{content:\"\\f2ed\"}.fa-trash-restore:before{content:\"\\f829\"}.fa-trash-restore-alt:before{content:\"\\f82a\"}.fa-tree:before{content:\"\\f1bb\"}.fa-trello:before{content:\"\\f181\"}.fa-tripadvisor:before{content:\"\\f262\"}.fa-trophy:before{content:\"\\f091\"}.fa-truck:before{content:\"\\f0d1\"}.fa-truck-loading:before{content:\"\\f4de\"}.fa-truck-monster:before{content:\"\\f63b\"}.fa-truck-moving:before{content:\"\\f4df\"}.fa-truck-pickup:before{content:\"\\f63c\"}.fa-tshirt:before{content:\"\\f553\"}.fa-tty:before{content:\"\\f1e4\"}.fa-tumblr:before{content:\"\\f173\"}.fa-tumblr-square:before{content:\"\\f174\"}.fa-tv:before{content:\"\\f26c\"}.fa-twitch:before{content:\"\\f1e8\"}.fa-twitter:before{content:\"\\f099\"}.fa-twitter-square:before{content:\"\\f081\"}.fa-typo3:before{content:\"\\f42b\"}.fa-uber:before{content:\"\\f402\"}.fa-ubuntu:before{content:\"\\f7df\"}.fa-uikit:before{content:\"\\f403\"}.fa-umbraco:before{content:\"\\f8e8\"}.fa-umbrella:before{content:\"\\f0e9\"}.fa-umbrella-beach:before{content:\"\\f5ca\"}.fa-uncharted:before{content:\"\\e084\"}.fa-underline:before{content:\"\\f0cd\"}.fa-undo:before{content:\"\\f0e2\"}.fa-undo-alt:before{content:\"\\f2ea\"}.fa-uniregistry:before{content:\"\\f404\"}.fa-unity:before{content:\"\\e049\"}.fa-universal-access:before{content:\"\\f29a\"}.fa-university:before{content:\"\\f19c\"}.fa-unlink:before{content:\"\\f127\"}.fa-unlock:before{content:\"\\f09c\"}.fa-unlock-alt:before{content:\"\\f13e\"}.fa-unsplash:before{content:\"\\e07c\"}.fa-untappd:before{content:\"\\f405\"}.fa-upload:before{content:\"\\f093\"}.fa-ups:before{content:\"\\f7e0\"}.fa-usb:before{content:\"\\f287\"}.fa-user:before{content:\"\\f007\"}.fa-user-alt:before{content:\"\\f406\"}.fa-user-alt-slash:before{content:\"\\f4fa\"}.fa-user-astronaut:before{content:\"\\f4fb\"}.fa-user-check:before{content:\"\\f4fc\"}.fa-user-circle:before{content:\"\\f2bd\"}.fa-user-clock:before{content:\"\\f4fd\"}.fa-user-cog:before{content:\"\\f4fe\"}.fa-user-edit:before{content:\"\\f4ff\"}.fa-user-friends:before{content:\"\\f500\"}.fa-user-graduate:before{content:\"\\f501\"}.fa-user-injured:before{content:\"\\f728\"}.fa-user-lock:before{content:\"\\f502\"}.fa-user-md:before{content:\"\\f0f0\"}.fa-user-minus:before{content:\"\\f503\"}.fa-user-ninja:before{content:\"\\f504\"}.fa-user-nurse:before{content:\"\\f82f\"}.fa-user-plus:before{content:\"\\f234\"}.fa-user-secret:before{content:\"\\f21b\"}.fa-user-shield:before{content:\"\\f505\"}.fa-user-slash:before{content:\"\\f506\"}.fa-user-tag:before{content:\"\\f507\"}.fa-user-tie:before{content:\"\\f508\"}.fa-user-times:before{content:\"\\f235\"}.fa-users:before{content:\"\\f0c0\"}.fa-users-cog:before{content:\"\\f509\"}.fa-users-slash:before{content:\"\\e073\"}.fa-usps:before{content:\"\\f7e1\"}.fa-ussunnah:before{content:\"\\f407\"}.fa-utensil-spoon:before{content:\"\\f2e5\"}.fa-utensils:before{content:\"\\f2e7\"}.fa-vaadin:before{content:\"\\f408\"}.fa-vector-square:before{content:\"\\f5cb\"}.fa-venus:before{content:\"\\f221\"}.fa-venus-double:before{content:\"\\f226\"}.fa-venus-mars:before{content:\"\\f228\"}.fa-vest:before{content:\"\\e085\"}.fa-vest-patches:before{content:\"\\e086\"}.fa-viacoin:before{content:\"\\f237\"}.fa-viadeo:before{content:\"\\f2a9\"}.fa-viadeo-square:before{content:\"\\f2aa\"}.fa-vial:before{content:\"\\f492\"}.fa-vials:before{content:\"\\f493\"}.fa-viber:before{content:\"\\f409\"}.fa-video:before{content:\"\\f03d\"}.fa-video-slash:before{content:\"\\f4e2\"}.fa-vihara:before{content:\"\\f6a7\"}.fa-vimeo:before{content:\"\\f40a\"}.fa-vimeo-square:before{content:\"\\f194\"}.fa-vimeo-v:before{content:\"\\f27d\"}.fa-vine:before{content:\"\\f1ca\"}.fa-virus:before{content:\"\\e074\"}.fa-virus-slash:before{content:\"\\e075\"}.fa-viruses:before{content:\"\\e076\"}.fa-vk:before{content:\"\\f189\"}.fa-vnv:before{content:\"\\f40b\"}.fa-voicemail:before{content:\"\\f897\"}.fa-volleyball-ball:before{content:\"\\f45f\"}.fa-volume-down:before{content:\"\\f027\"}.fa-volume-mute:before{content:\"\\f6a9\"}.fa-volume-off:before{content:\"\\f026\"}.fa-volume-up:before{content:\"\\f028\"}.fa-vote-yea:before{content:\"\\f772\"}.fa-vr-cardboard:before{content:\"\\f729\"}.fa-vuejs:before{content:\"\\f41f\"}.fa-walking:before{content:\"\\f554\"}.fa-wallet:before{content:\"\\f555\"}.fa-warehouse:before{content:\"\\f494\"}.fa-watchman-monitoring:before{content:\"\\e087\"}.fa-water:before{content:\"\\f773\"}.fa-wave-square:before{content:\"\\f83e\"}.fa-waze:before{content:\"\\f83f\"}.fa-weebly:before{content:\"\\f5cc\"}.fa-weibo:before{content:\"\\f18a\"}.fa-weight:before{content:\"\\f496\"}.fa-weight-hanging:before{content:\"\\f5cd\"}.fa-weixin:before{content:\"\\f1d7\"}.fa-whatsapp:before{content:\"\\f232\"}.fa-whatsapp-square:before{content:\"\\f40c\"}.fa-wheelchair:before{content:\"\\f193\"}.fa-whmcs:before{content:\"\\f40d\"}.fa-wifi:before{content:\"\\f1eb\"}.fa-wikipedia-w:before{content:\"\\f266\"}.fa-wind:before{content:\"\\f72e\"}.fa-window-close:before{content:\"\\f410\"}.fa-window-maximize:before{content:\"\\f2d0\"}.fa-window-minimize:before{content:\"\\f2d1\"}.fa-window-restore:before{content:\"\\f2d2\"}.fa-windows:before{content:\"\\f17a\"}.fa-wine-bottle:before{content:\"\\f72f\"}.fa-wine-glass:before{content:\"\\f4e3\"}.fa-wine-glass-alt:before{content:\"\\f5ce\"}.fa-wix:before{content:\"\\f5cf\"}.fa-wizards-of-the-coast:before{content:\"\\f730\"}.fa-wodu:before{content:\"\\e088\"}.fa-wolf-pack-battalion:before{content:\"\\f514\"}.fa-won-sign:before{content:\"\\f159\"}.fa-wordpress:before{content:\"\\f19a\"}.fa-wordpress-simple:before{content:\"\\f411\"}.fa-wpbeginner:before{content:\"\\f297\"}.fa-wpexplorer:before{content:\"\\f2de\"}.fa-wpforms:before{content:\"\\f298\"}.fa-wpressr:before{content:\"\\f3e4\"}.fa-wrench:before{content:\"\\f0ad\"}.fa-x-ray:before{content:\"\\f497\"}.fa-xbox:before{content:\"\\f412\"}.fa-xing:before{content:\"\\f168\"}.fa-xing-square:before{content:\"\\f169\"}.fa-y-combinator:before{content:\"\\f23b\"}.fa-yahoo:before{content:\"\\f19e\"}.fa-yammer:before{content:\"\\f840\"}.fa-yandex:before{content:\"\\f413\"}.fa-yandex-international:before{content:\"\\f414\"}.fa-yarn:before{content:\"\\f7e3\"}.fa-yelp:before{content:\"\\f1e9\"}.fa-yen-sign:before{content:\"\\f157\"}.fa-yin-yang:before{content:\"\\f6ad\"}.fa-yoast:before{content:\"\\f2b1\"}.fa-youtube:before{content:\"\\f167\"}.fa-youtube-square:before{content:\"\\f431\"}.fa-zhihu:before{content:\"\\f63f\"}","yes");
INSERT INTO `a3rfa_options` VALUES("19000","_transient_timeout_avada_dashboard_data","1666530725","no");
INSERT INTO `a3rfa_options` VALUES("19001","_transient_avada_dashboard_data","a:5:{s:7:\"on_sale\";b:0;s:5:\"price\";s:3:\"$69\";s:9:\"video_url\";s:43:\"https://www.youtube.com/watch?v=nt_ifA0dblg\";s:13:\"avada_version\";s:5:\"7.8.2\";s:13:\"bypass_active\";b:0;}","no");
INSERT INTO `a3rfa_options` VALUES("19002","_transient_doing_cron","1666527128.2409570217132568359375","yes");
INSERT INTO `a3rfa_options` VALUES("19003","_transient_timeout_global_styles_IranAvada-Child","1666527189","no");
INSERT INTO `a3rfa_options` VALUES("19004","_transient_global_styles_IranAvada-Child","body{--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--duotone--dark-grayscale: url(\'#wp-duotone-dark-grayscale\');--wp--preset--duotone--grayscale: url(\'#wp-duotone-grayscale\');--wp--preset--duotone--purple-yellow: url(\'#wp-duotone-purple-yellow\');--wp--preset--duotone--blue-red: url(\'#wp-duotone-blue-red\');--wp--preset--duotone--midnight: url(\'#wp-duotone-midnight\');--wp--preset--duotone--magenta-yellow: url(\'#wp-duotone-magenta-yellow\');--wp--preset--duotone--purple-green: url(\'#wp-duotone-purple-green\');--wp--preset--duotone--blue-orange: url(\'#wp-duotone-blue-orange\');--wp--preset--font-size--small: 12px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 24px;--wp--preset--font-size--x-large: 42px;--wp--preset--font-size--normal: 16px;--wp--preset--font-size--xlarge: 32px;--wp--preset--font-size--huge: 48px;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}","no");
INSERT INTO `a3rfa_options` VALUES("15519","fusion_form_cleanup_datetime","1666613527","yes");
INSERT INTO `a3rfa_options` VALUES("19005","_transient_timeout_global_styles_svg_filters_IranAvada-Child","1666527189","no");
INSERT INTO `a3rfa_options` VALUES("19006","_transient_global_styles_svg_filters_IranAvada-Child","<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-dark-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncG type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncB type=\"table\" tableValues=\"0 0.49803921568627\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-grayscale\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.54901960784314 0.98823529411765\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.71764705882353 0.25490196078431\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-red\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 1\" /><feFuncG type=\"table\" tableValues=\"0 0.27843137254902\" /><feFuncB type=\"table\" tableValues=\"0.5921568627451 0.27843137254902\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-midnight\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0 0\" /><feFuncG type=\"table\" tableValues=\"0 0.64705882352941\" /><feFuncB type=\"table\" tableValues=\"0 1\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-magenta-yellow\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.78039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.94901960784314\" /><feFuncB type=\"table\" tableValues=\"0.35294117647059 0.47058823529412\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-purple-green\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.65098039215686 0.40392156862745\" /><feFuncG type=\"table\" tableValues=\"0 1\" /><feFuncB type=\"table\" tableValues=\"0.44705882352941 0.4\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg><svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 0 0\" width=\"0\" height=\"0\" focusable=\"false\" role=\"none\" style=\"visibility: hidden; position: absolute; left: -9999px; overflow: hidden;\" ><defs><filter id=\"wp-duotone-blue-orange\"><feColorMatrix color-interpolation-filters=\"sRGB\" type=\"matrix\" values=\" .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 .299 .587 .114 0 0 \" /><feComponentTransfer color-interpolation-filters=\"sRGB\" ><feFuncR type=\"table\" tableValues=\"0.098039215686275 1\" /><feFuncG type=\"table\" tableValues=\"0 0.66274509803922\" /><feFuncB type=\"table\" tableValues=\"0.84705882352941 0.41960784313725\" /><feFuncA type=\"table\" tableValues=\"1 1\" /></feComponentTransfer><feComposite in2=\"SourceGraphic\" operator=\"in\" /></filter></defs></svg>","no");
INSERT INTO `a3rfa_options` VALUES("18589","_site_transient_update_themes","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1666336692;s:7:\"checked\";a:2:{s:15:\"IranAvada-Child\";s:7:\"7.6.1.2\";s:9:\"IranAvada\";s:5:\"7.6.1\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:5:\"Avada\";a:6:{s:5:\"theme\";s:5:\"Avada\";s:11:\"new_version\";s:0:\"\";s:3:\"url\";s:58:\"https://theme-fusion.com/avada-documentation/changelog.txt\";s:7:\"package\";s:0:\"\";s:8:\"required\";s:3:\"4.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}","no");
INSERT INTO `a3rfa_options` VALUES("16708","woocommerce_single_image_width","700","yes");
INSERT INTO `a3rfa_options` VALUES("16703","theme_mods_IranAvada-Child","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:15:\"main_navigation\";i:14;}s:18:\"custom_css_post_id\";i:-1;}","yes");
INSERT INTO `a3rfa_options` VALUES("18985","_site_transient_timeout_theme_roots","1666338492","no");
INSERT INTO `a3rfa_options` VALUES("18986","_site_transient_theme_roots","a:2:{s:15:\"IranAvada-Child\";s:7:\"/themes\";s:9:\"IranAvada\";s:7:\"/themes\";}","no");
INSERT INTO `a3rfa_options` VALUES("18987","_site_transient_update_plugins","O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1666336693;s:8:\"response\";a:2:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:49:\"w.org/plugins/all-in-one-wp-security-and-firewall\";s:4:\"slug\";s:35:\"all-in-one-wp-security-and-firewall\";s:6:\"plugin\";s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:11:\"new_version\";s:5:\"5.1.0\";s:3:\"url\";s:66:\"https://wordpress.org/plugins/all-in-one-wp-security-and-firewall/\";s:7:\"package\";s:84:\"https://downloads.wordpress.org/plugin/all-in-one-wp-security-and-firewall.5.1.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-256x256.png?rev=2798307\";s:2:\"1x\";s:88:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/icon-128x128.png?rev=2798307\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:91:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-1544x500.png?rev=2798307\";s:2:\"1x\";s:90:\"https://ps.w.org/all-in-one-wp-security-and-firewall/assets/banner-772x250.png?rev=2798307\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:5:\"1.5.0\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/duplicator.1.5.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2605836\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2605835\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";s:6:\"tested\";s:5:\"6.0.3\";s:12:\"requires_php\";s:5:\"5.3.8\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:23:\"wp-jalali/wp-jalali.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/wp-jalali\";s:4:\"slug\";s:9:\"wp-jalali\";s:6:\"plugin\";s:23:\"wp-jalali/wp-jalali.php\";s:11:\"new_version\";s:5:\"5.0.1\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wp-jalali/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wp-jalali.5.0.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:61:\"https://ps.w.org/wp-jalali/assets/icon-256x256.png?rev=983015\";s:2:\"1x\";s:61:\"https://ps.w.org/wp-jalali/assets/icon-128x128.png?rev=983015\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:63:\"https://ps.w.org/wp-jalali/assets/banner-772x250.png?rev=982617\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.9\";}s:33:\"fusion-builder/fusion-builder.php\";O:8:\"stdClass\":8:{s:2:\"id\";s:33:\"fusion-builder/fusion-builder.php\";s:4:\"slug\";s:14:\"fusion-builder\";s:6:\"plugin\";s:33:\"fusion-builder/fusion-builder.php\";s:11:\"new_version\";s:5:\"3.6.1\";s:3:\"url\";s:0:\"\";s:7:\"package\";s:0:\"\";s:5:\"icons\";a:2:{s:2:\"1x\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";s:2:\"2x\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";s:7:\"default\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";}}s:27:\"fusion-core/fusion-core.php\";O:8:\"stdClass\":8:{s:2:\"id\";s:27:\"fusion-core/fusion-core.php\";s:4:\"slug\";s:11:\"fusion-core\";s:6:\"plugin\";s:27:\"fusion-core/fusion-core.php\";s:11:\"new_version\";s:5:\"5.6.1\";s:3:\"url\";s:0:\"\";s:7:\"package\";s:0:\"\";s:5:\"icons\";a:2:{s:2:\"1x\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";s:2:\"2x\";s:86:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada-icon-transparent.png\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";s:7:\"default\";s:76:\"https://updates.theme-fusion.com/wp-content/uploads/2017/01/avada_banner.jpg\";}}}s:7:\"checked\";a:5:{s:51:\"all-in-one-wp-security-and-firewall/wp-security.php\";s:6:\"4.4.10\";s:33:\"fusion-builder/fusion-builder.php\";s:5:\"3.6.1\";s:27:\"fusion-core/fusion-core.php\";s:5:\"5.6.1\";s:25:\"duplicator/duplicator.php\";s:6:\"1.3.28\";s:23:\"wp-jalali/wp-jalali.php\";s:5:\"5.0.1\";}}","no");
INSERT INTO `a3rfa_options` VALUES("18988","_site_transient_timeout_php_check_2f5acf219326a8bc5331ee302b9812f4","1666941493","no");
INSERT INTO `a3rfa_options` VALUES("18989","_site_transient_php_check_2f5acf219326a8bc5331ee302b9812f4","a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}","no");
INSERT INTO `a3rfa_options` VALUES("15722","_transient_health-check-site-status-result","{\"good\":14,\"recommended\":5,\"critical\":0}","yes");
INSERT INTO `a3rfa_options` VALUES("15659","_transient_timeout_avada_studio","1637847979","no");
INSERT INTO `a3rfa_options` VALUES("18942","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:3:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.0.3.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.0.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.0.3\";s:7:\"version\";s:5:\"6.0.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.0.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.0.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.0.3\";s:7:\"version\";s:5:\"6.0.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.0.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.0.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.0.3-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.0.3\";s:7:\"version\";s:5:\"6.0.3\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.9\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1666336691;s:15:\"version_checked\";s:5:\"5.9.5\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO `a3rfa_options` VALUES("16757","duplicator_package_active","O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2022-03-12 22:44:36\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:5:\"5.9.2\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.3.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"iranavada_architecture_files\";s:4:\"Hash\";s:35:\"2cba3b54d21553188910_20220312224436\";s:8:\"NameHash\";s:64:\"iranavada_architecture_files_2cba3b54d21553188910_20220312224436\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/home/iranava1/demo.iranavada.ir/architecture/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://demo.iranavada.ir/architecture/wp-snapshots/\";s:8:\"ScanFile\";s:74:\"iranavada_architecture_files_2cba3b54d21553188910_20220312224436_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:45:\"/home/iranava1/demo.iranavada.ir/architecture\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2022-03-12 22:44:36\";s:7:\"Version\";s:6:\"1.3.28\";s:9:\"VersionWP\";s:5:\"5.9.2\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.3.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"iranavada_architecture_files\";s:4:\"Hash\";s:35:\"2cba3b54d21553188910_20220312224436\";s:8:\"NameHash\";s:64:\"iranavada_architecture_files_2cba3b54d21553188910_20220312224436\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:62:\"/home/iranava1/demo.iranavada.ir/architecture/wp-snapshots/tmp\";s:8:\"StoreURL\";s:51:\"http://demo.iranavada.ir/architecture/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":14:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:63;s:25:\"\0DUP_Database\0dbStorePath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:54:\"/home/iranava1/demo.iranavada.ir/architecture/wp-admin\";i:1;s:64:\"/home/iranava1/demo.iranavada.ir/architecture/wp-content/uploads\";i:2;s:66:\"/home/iranava1/demo.iranavada.ir/architecture/wp-content/languages\";i:3;s:63:\"/home/iranava1/demo.iranavada.ir/architecture/wp-content/themes\";i:4;s:57:\"/home/iranava1/demo.iranavada.ir/architecture/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:45:\"/home/iranava1/demo.iranavada.ir/architecture\";i:1;s:56:\"/home/iranava1/demo.iranavada.ir/architecture/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:128;}","yes");


DROP TABLE IF EXISTS `a3rfa_postmeta`;

CREATE TABLE `a3rfa_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4541 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

INSERT INTO `a3rfa_postmeta` VALUES("8","23","_wp_attached_file","2015/02/home-slide.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("9","23","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:1200;s:4:\"file\";s:22:\"2015/02/home-slide.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"home-slide-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"home-slide-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"home-slide-768x473.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"home-slide-1024x630.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:630;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"home-slide-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"home-slide-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"home-slide-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"home-slide-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"home-slide-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"home-slide-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"home-slide-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"home-slide-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"home-slide-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"home-slide-200x123.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"home-slide-400x246.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"home-slide-600x369.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:369;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"home-slide-800x492.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:23:\"home-slide-1200x738.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:738;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("10","23","_wxr_import_parent","22");
INSERT INTO `a3rfa_postmeta` VALUES("11","23","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("12","23","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("13","31","_wp_attached_file","2015/02/home-image1.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("14","31","_wp_attachment_metadata","a:5:{s:5:\"width\";i:356;s:6:\"height\";i:250;s:4:\"file\";s:23:\"2015/02/home-image1.jpg\";s:5:\"sizes\";a:7:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"home-image1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"home-image1-300x211.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:211;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:23:\"home-image1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:23:\"home-image1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:23:\"home-image1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:21:\"home-image1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:23:\"home-image1-200x140.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2817","119","pyre_caption","فضاهای بیرون با طراحی مفهومی");
INSERT INTO `a3rfa_postmeta` VALUES("2816","119","pyre_heading_bg_color","");
INSERT INTO `a3rfa_postmeta` VALUES("17","31","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("18","38","_wp_attached_file","2015/02/home-section1.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("19","38","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:1200;s:4:\"file\";s:25:\"2015/02/home-section1.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"home-section1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"home-section1-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"home-section1-768x473.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"home-section1-1024x630.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:630;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:25:\"home-section1-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:25:\"home-section1-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:25:\"home-section1-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:25:\"home-section1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:25:\"home-section1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:25:\"home-section1-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:25:\"home-section1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:25:\"home-section1-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:23:\"home-section1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:25:\"home-section1-200x123.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:25:\"home-section1-400x246.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:25:\"home-section1-600x369.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:369;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:25:\"home-section1-800x492.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:26:\"home-section1-1200x738.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:738;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2815","119","pyre_heading_bg","no");
INSERT INTO `a3rfa_postmeta` VALUES("22","38","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("23","39","_wp_attached_file","2015/02/home-section2.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("24","39","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:1200;s:4:\"file\";s:25:\"2015/02/home-section2.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"home-section2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"home-section2-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"home-section2-768x473.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"home-section2-1024x630.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:630;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:25:\"home-section2-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:25:\"home-section2-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:25:\"home-section2-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:25:\"home-section2-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:25:\"home-section2-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:25:\"home-section2-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:25:\"home-section2-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:25:\"home-section2-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:23:\"home-section2-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:25:\"home-section2-200x123.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:25:\"home-section2-400x246.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:25:\"home-section2-600x369.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:369;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:25:\"home-section2-800x492.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:26:\"home-section2-1200x738.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:738;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2814","119","pyre_heading_color","#ffffff");
INSERT INTO `a3rfa_postmeta` VALUES("27","39","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("28","47","_wp_attached_file","2015/02/home-section3.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("29","47","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:1200;s:4:\"file\";s:25:\"2015/02/home-section3.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"home-section3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"home-section3-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"home-section3-768x473.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"home-section3-1024x630.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:630;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:25:\"home-section3-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:25:\"home-section3-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:25:\"home-section3-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:25:\"home-section3-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:25:\"home-section3-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:25:\"home-section3-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:25:\"home-section3-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:25:\"home-section3-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:23:\"home-section3-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:25:\"home-section3-200x123.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:25:\"home-section3-400x246.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:25:\"home-section3-600x369.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:369;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:25:\"home-section3-800x492.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:26:\"home-section3-1200x738.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:738;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2813","119","pyre_heading_font_size","70");
INSERT INTO `a3rfa_postmeta` VALUES("32","47","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("33","49","_wp_attached_file","2015/02/home-section4.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("34","49","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:1200;s:4:\"file\";s:25:\"2015/02/home-section4.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"home-section4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"home-section4-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"home-section4-768x473.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"home-section4-1024x630.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:630;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:25:\"home-section4-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:25:\"home-section4-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:25:\"home-section4-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:25:\"home-section4-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:25:\"home-section4-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:25:\"home-section4-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:25:\"home-section4-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:25:\"home-section4-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:23:\"home-section4-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:25:\"home-section4-200x123.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:25:\"home-section4-400x246.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:25:\"home-section4-600x369.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:369;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:25:\"home-section4-800x492.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:26:\"home-section4-1200x738.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:738;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2812","119","pyre_heading","دیگر خدمات");
INSERT INTO `a3rfa_postmeta` VALUES("2811","119","pyre_content_alignment","right");
INSERT INTO `a3rfa_postmeta` VALUES("37","49","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("38","50","_wp_attached_file","2015/02/home-section5.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("39","50","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:1200;s:4:\"file\";s:25:\"2015/02/home-section5.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"home-section5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"home-section5-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"home-section5-768x473.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"home-section5-1024x630.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:630;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:25:\"home-section5-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:25:\"home-section5-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:25:\"home-section5-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:25:\"home-section5-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:25:\"home-section5-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:25:\"home-section5-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:25:\"home-section5-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:25:\"home-section5-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:23:\"home-section5-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:25:\"home-section5-200x123.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:25:\"home-section5-400x246.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:25:\"home-section5-600x369.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:369;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:25:\"home-section5-800x492.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:26:\"home-section5-1200x738.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:738;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2810","119","pyre_hide_video_controls","yes");
INSERT INTO `a3rfa_postmeta` VALUES("42","50","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("43","140","_wp_attached_file","2015/02/bg-contact.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("44","140","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:1200;s:4:\"file\";s:22:\"2015/02/bg-contact.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"bg-contact-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"bg-contact-300x185.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:185;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"bg-contact-768x473.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:473;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:23:\"bg-contact-1024x630.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:630;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"bg-contact-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"bg-contact-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"bg-contact-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"bg-contact-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"bg-contact-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"bg-contact-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"bg-contact-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"bg-contact-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"bg-contact-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"bg-contact-200x123.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"bg-contact-400x246.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"bg-contact-600x369.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:369;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"bg-contact-800x492.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:492;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:23:\"bg-contact-1200x738.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:738;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2809","119","pyre_loop_video","yes");
INSERT INTO `a3rfa_postmeta` VALUES("2808","119","pyre_autoplay_video","yes");
INSERT INTO `a3rfa_postmeta` VALUES("47","140","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("48","204","_wp_attached_file","2015/02/map-marker.png");
INSERT INTO `a3rfa_postmeta` VALUES("49","204","_wp_attachment_metadata","a:5:{s:5:\"width\";i:26;s:6:\"height\";i:25;s:4:\"file\";s:22:\"2015/02/map-marker.png\";s:5:\"sizes\";a:0:{}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("50","204","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("51","204","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("52","218","_wp_attached_file","2015/02/portfolio12.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("53","218","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:23:\"2015/02/portfolio12.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"portfolio12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"portfolio12-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"portfolio12-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:23:\"portfolio12-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:23:\"portfolio12-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:23:\"portfolio12-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:23:\"portfolio12-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:23:\"portfolio12-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:23:\"portfolio12-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:23:\"portfolio12-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:23:\"portfolio12-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:21:\"portfolio12-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:23:\"portfolio12-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:23:\"portfolio12-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:23:\"portfolio12-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:23:\"portfolio12-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2807","119","pyre_mute_video","yes");
INSERT INTO `a3rfa_postmeta` VALUES("2806","119","pyre_video_bg_color","");
INSERT INTO `a3rfa_postmeta` VALUES("56","218","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("57","219","_wp_attached_file","2015/02/portfolio11.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("58","219","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:23:\"2015/02/portfolio11.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"portfolio11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"portfolio11-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"portfolio11-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:23:\"portfolio11-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:23:\"portfolio11-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:23:\"portfolio11-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:23:\"portfolio11-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:23:\"portfolio11-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:23:\"portfolio11-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:23:\"portfolio11-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:23:\"portfolio11-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:21:\"portfolio11-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:23:\"portfolio11-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:23:\"portfolio11-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:23:\"portfolio11-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:23:\"portfolio11-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2805","119","pyre_preview_image","");
INSERT INTO `a3rfa_postmeta` VALUES("2804","119","pyre_ogv","");
INSERT INTO `a3rfa_postmeta` VALUES("61","219","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("62","220","_wp_attached_file","2015/02/portfolio10.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("63","220","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:23:\"2015/02/portfolio10.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:23:\"portfolio10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:23:\"portfolio10-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:23:\"portfolio10-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:23:\"portfolio10-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:23:\"portfolio10-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:23:\"portfolio10-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:23:\"portfolio10-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:23:\"portfolio10-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:23:\"portfolio10-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:23:\"portfolio10-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:23:\"portfolio10-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:21:\"portfolio10-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:23:\"portfolio10-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:23:\"portfolio10-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:23:\"portfolio10-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:23:\"portfolio10-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2803","119","pyre_mp4","");
INSERT INTO `a3rfa_postmeta` VALUES("2802","119","pyre_webm","");
INSERT INTO `a3rfa_postmeta` VALUES("66","220","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("67","221","_wp_attached_file","2015/02/portfolio9.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("68","221","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio9.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio9-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio9-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio9-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio9-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio9-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio9-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio9-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio9-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio9-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio9-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio9-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio9-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio9-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio9-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio9-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2801","119","pyre_vimeo_id","");
INSERT INTO `a3rfa_postmeta` VALUES("2800","119","pyre_youtube_id","");
INSERT INTO `a3rfa_postmeta` VALUES("71","221","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("72","222","_wp_attached_file","2015/02/portfolio8.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("73","222","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio8.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio8-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio8-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio8-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio8-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio8-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio8-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio8-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio8-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio8-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio8-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio8-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio8-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio8-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio8-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio8-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2799","119","pyre_type","image");
INSERT INTO `a3rfa_postmeta` VALUES("2798","119","slide_template","default");
INSERT INTO `a3rfa_postmeta` VALUES("76","222","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("77","223","_wp_attached_file","2015/02/portfolio7.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("78","223","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio7.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio7-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio7-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio7-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio7-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio7-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio7-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio7-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio7-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio7-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio7-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio7-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio7-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio7-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio7-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio7-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2797","119","_edit_last","1");
INSERT INTO `a3rfa_postmeta` VALUES("81","223","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("82","224","_wp_attached_file","2015/02/portfolio6.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("83","224","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio6.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio6-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio6-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio6-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio6-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio6-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio6-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio6-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio6-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio6-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio6-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio6-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio6-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio6-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio6-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio6-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2796","78","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("86","224","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("87","225","_wp_attached_file","2015/02/portfolio5.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("88","225","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio5.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio5-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio5-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio5-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio5-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio5-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio5-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio5-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio5-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio5-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio5-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio5-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio5-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio5-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio5-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio5-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("91","225","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("92","226","_wp_attached_file","2015/02/portfolio4.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("93","226","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio4.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio4-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio4-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio4-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio4-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio4-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio4-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio4-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio4-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio4-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio4-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio4-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio4-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio4-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio4-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio4-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2795","78","_wxr_import_term","a:3:{s:8:\"taxonomy\";s:10:\"slide-page\";s:4:\"slug\";s:18:\"architecture-about\";s:4:\"name\";s:18:\"Architecture About\";}");
INSERT INTO `a3rfa_postmeta` VALUES("2794","78","_thumbnail_id","678");
INSERT INTO `a3rfa_postmeta` VALUES("96","226","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("97","227","_wp_attached_file","2015/02/portfolio3.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("98","227","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio3.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio3-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio3-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio3-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio3-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio3-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio3-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio3-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio3-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio3-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio3-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio3-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio3-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio3-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio3-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio3-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2793","78","pyre_button_2","");
INSERT INTO `a3rfa_postmeta` VALUES("2792","78","pyre_button_1","");
INSERT INTO `a3rfa_postmeta` VALUES("101","227","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("102","228","_wp_attached_file","2015/02/portfolio2.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("103","228","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio2.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio2-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio2-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio2-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio2-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio2-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio2-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio2-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio2-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio2-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio2-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio2-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio2-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio2-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio2-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio2-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2791","78","pyre_slide_target","yes");
INSERT INTO `a3rfa_postmeta` VALUES("4336","9","sbg_selected_sidebar","a:1:{i:0;s:1:\"0\";}");
INSERT INTO `a3rfa_postmeta` VALUES("106","228","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("107","229","_wp_attached_file","2015/02/portfolio1.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("108","229","_wp_attachment_metadata","a:5:{s:5:\"width\";i:800;s:6:\"height\";i:541;s:4:\"file\";s:22:\"2015/02/portfolio1.jpg\";s:5:\"sizes\";a:16:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:22:\"portfolio1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:22:\"portfolio1-300x203.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:203;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:22:\"portfolio1-768x519.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:519;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:22:\"portfolio1-800x400.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:22:\"portfolio1-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:22:\"portfolio1-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:22:\"portfolio1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:22:\"portfolio1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:22:\"portfolio1-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:22:\"portfolio1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:22:\"portfolio1-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:20:\"portfolio1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:22:\"portfolio1-200x135.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:135;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:22:\"portfolio1-400x271.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:271;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:22:\"portfolio1-600x406.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:406;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:22:\"portfolio1-800x541.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:13:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}s:14:\"resized_images\";a:1:{s:10:\"fusion-500\";s:7:\"500x383\";}}}");
INSERT INTO `a3rfa_postmeta` VALUES("4338","9","sbg_selected_sidebar_2","a:1:{i:0;s:1:\"0\";}");
INSERT INTO `a3rfa_postmeta` VALUES("111","229","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("112","230","_wp_attached_file","2015/02/logo-avada-architect.png");
INSERT INTO `a3rfa_postmeta` VALUES("113","230","_wp_attachment_metadata","a:5:{s:5:\"width\";i:240;s:6:\"height\";i:34;s:4:\"file\";s:32:\"2015/02/logo-avada-architect.png\";s:5:\"sizes\";a:4:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:31:\"logo-avada-architect-150x34.png\";s:5:\"width\";i:150;s:6:\"height\";i:34;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:31:\"logo-avada-architect-177x34.png\";s:5:\"width\";i:177;s:6:\"height\";i:34;s:9:\"mime-type\";s:9:\"image/png\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:30:\"logo-avada-architect-66x34.png\";s:5:\"width\";i:66;s:6:\"height\";i:34;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:31:\"logo-avada-architect-200x28.png\";s:5:\"width\";i:200;s:6:\"height\";i:28;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("114","230","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("115","230","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("116","231","_wp_attached_file","2015/02/logo-avada-architect-retina.png");
INSERT INTO `a3rfa_postmeta` VALUES("117","231","_wp_attachment_metadata","a:5:{s:5:\"width\";i:480;s:6:\"height\";i:68;s:4:\"file\";s:39:\"2015/02/logo-avada-architect-retina.png\";s:5:\"sizes\";a:9:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:38:\"logo-avada-architect-retina-150x68.png\";s:5:\"width\";i:150;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:6:\"medium\";a:4:{s:4:\"file\";s:38:\"logo-avada-architect-retina-300x43.png\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:38:\"logo-avada-architect-retina-460x68.png\";s:5:\"width\";i:460;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:38:\"logo-avada-architect-retina-300x68.png\";s:5:\"width\";i:300;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:38:\"logo-avada-architect-retina-177x68.png\";s:5:\"width\";i:177;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:38:\"logo-avada-architect-retina-320x68.png\";s:5:\"width\";i:320;s:6:\"height\";i:68;s:9:\"mime-type\";s:9:\"image/png\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:37:\"logo-avada-architect-retina-66x66.png\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:38:\"logo-avada-architect-retina-200x28.png\";s:5:\"width\";i:200;s:6:\"height\";i:28;s:9:\"mime-type\";s:9:\"image/png\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:38:\"logo-avada-architect-retina-400x57.png\";s:5:\"width\";i:400;s:6:\"height\";i:57;s:9:\"mime-type\";s:9:\"image/png\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("118","231","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("119","231","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("120","288","_wp_attached_file","2015/02/services1.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("121","288","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:650;s:4:\"file\";s:21:\"2015/02/services1.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"services1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"services1-300x100.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"services1-768x256.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:256;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"services1-1024x341.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:341;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:21:\"services1-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:21:\"services1-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:21:\"services1-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:21:\"services1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:21:\"services1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:21:\"services1-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:21:\"services1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:21:\"services1-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:19:\"services1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:20:\"services1-200x67.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:21:\"services1-400x133.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:133;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:21:\"services1-600x200.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:21:\"services1-800x267.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:22:\"services1-1200x400.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2790","78","pyre_slide_link","#");
INSERT INTO `a3rfa_postmeta` VALUES("2789","78","pyre_link_type","full");
INSERT INTO `a3rfa_postmeta` VALUES("124","288","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("125","289","_wp_attached_file","2015/02/services2.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("126","289","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:650;s:4:\"file\";s:21:\"2015/02/services2.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"services2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"services2-300x100.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"services2-768x256.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:256;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"services2-1024x341.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:341;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:21:\"services2-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:21:\"services2-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:21:\"services2-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:21:\"services2-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:21:\"services2-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:21:\"services2-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:21:\"services2-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:21:\"services2-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:19:\"services2-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:20:\"services2-200x67.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:21:\"services2-400x133.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:133;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:21:\"services2-600x200.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:21:\"services2-800x267.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:22:\"services2-1200x400.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2788","78","pyre_caption_bg_color","");
INSERT INTO `a3rfa_postmeta` VALUES("2787","78","pyre_caption_bg","no");
INSERT INTO `a3rfa_postmeta` VALUES("129","289","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("130","290","_wp_attached_file","2015/02/services3.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("131","290","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:650;s:4:\"file\";s:21:\"2015/02/services3.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"services3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"services3-300x100.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"services3-768x256.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:256;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"services3-1024x341.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:341;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:21:\"services3-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:21:\"services3-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:21:\"services3-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:21:\"services3-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:21:\"services3-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:21:\"services3-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:21:\"services3-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:21:\"services3-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:19:\"services3-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:20:\"services3-200x67.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:21:\"services3-400x133.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:133;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:21:\"services3-600x200.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:21:\"services3-800x267.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:22:\"services3-1200x400.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2786","78","pyre_caption_color","fff");
INSERT INTO `a3rfa_postmeta` VALUES("2785","78","pyre_caption_font_size","28");
INSERT INTO `a3rfa_postmeta` VALUES("134","290","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("135","291","_wp_attached_file","2015/02/services4.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("136","291","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:650;s:4:\"file\";s:21:\"2015/02/services4.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"services4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"services4-300x100.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"services4-768x256.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:256;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"services4-1024x341.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:341;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:21:\"services4-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:21:\"services4-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:21:\"services4-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:21:\"services4-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:21:\"services4-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:21:\"services4-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:21:\"services4-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:21:\"services4-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:19:\"services4-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:20:\"services4-200x67.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:21:\"services4-400x133.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:133;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:21:\"services4-600x200.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:21:\"services4-800x267.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:22:\"services4-1200x400.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2784","78","pyre_caption","آوادا دموی معماری");
INSERT INTO `a3rfa_postmeta` VALUES("139","291","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("140","292","_wp_attached_file","2015/02/services5.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("141","292","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:650;s:4:\"file\";s:21:\"2015/02/services5.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"services5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"services5-300x100.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:100;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"services5-768x256.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:256;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"services5-1024x341.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:341;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:21:\"services5-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:21:\"services5-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:21:\"services5-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:21:\"services5-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:21:\"services5-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:21:\"services5-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:21:\"services5-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:21:\"services5-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:19:\"services5-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:20:\"services5-200x67.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:67;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:21:\"services5-400x133.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:133;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:21:\"services5-600x200.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:21:\"services5-800x267.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:267;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:22:\"services5-1200x400.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("2783","78","pyre_heading_bg_color","");
INSERT INTO `a3rfa_postmeta` VALUES("2782","78","pyre_heading_bg","no");
INSERT INTO `a3rfa_postmeta` VALUES("144","292","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("145","294","_wp_attached_file","2015/02/portfolio-header1.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("146","294","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:400;s:4:\"file\";s:29:\"2015/02/portfolio-header1.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:28:\"portfolio-header1-300x62.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:62;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-768x158.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:30:\"portfolio-header1-1024x210.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-700x400.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:27:\"portfolio-header1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:28:\"portfolio-header1-200x41.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:41;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:28:\"portfolio-header1-400x82.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-600x123.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:29:\"portfolio-header1-800x164.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:30:\"portfolio-header1-1200x246.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("147","294","_wxr_import_parent","159");
INSERT INTO `a3rfa_postmeta` VALUES("148","294","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("149","294","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("150","295","_wp_attached_file","2015/02/about-header1.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("151","295","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:400;s:4:\"file\";s:25:\"2015/02/about-header1.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:25:\"about-header1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:24:\"about-header1-300x62.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:62;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:25:\"about-header1-768x158.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:26:\"about-header1-1024x210.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:25:\"about-header1-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:25:\"about-header1-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:25:\"about-header1-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:25:\"about-header1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:25:\"about-header1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:25:\"about-header1-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:25:\"about-header1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:25:\"about-header1-700x400.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:23:\"about-header1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:24:\"about-header1-200x41.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:41;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:24:\"about-header1-400x82.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:25:\"about-header1-600x123.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:25:\"about-header1-800x164.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:26:\"about-header1-1200x246.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("152","295","_wxr_import_parent","119");
INSERT INTO `a3rfa_postmeta` VALUES("153","295","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("154","295","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("155","296","_wp_attached_file","2015/02/services-header1.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("156","296","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:400;s:4:\"file\";s:28:\"2015/02/services-header1.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:28:\"services-header1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:27:\"services-header1-300x62.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:62;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:28:\"services-header1-768x158.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:29:\"services-header1-1024x210.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:210;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:28:\"services-header1-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:28:\"services-header1-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:28:\"services-header1-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:28:\"services-header1-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:28:\"services-header1-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:28:\"services-header1-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:28:\"services-header1-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:28:\"services-header1-700x400.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:26:\"services-header1-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:27:\"services-header1-200x41.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:41;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:27:\"services-header1-400x82.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:82;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:28:\"services-header1-600x123.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:123;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:28:\"services-header1-800x164.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:29:\"services-header1-1200x246.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:246;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("157","296","_wxr_import_parent","119");
INSERT INTO `a3rfa_postmeta` VALUES("158","296","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("159","296","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("160","315","_wp_attached_file","2015/05/sunrise-avenue.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("161","315","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:700;s:4:\"file\";s:26:\"2015/05/sunrise-avenue.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-300x108.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:108;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-768x276.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:276;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"sunrise-avenue-1024x368.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:368;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:24:\"sunrise-avenue-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:25:\"sunrise-avenue-200x72.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:72;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-400x144.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:144;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-600x215.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:215;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:26:\"sunrise-avenue-800x287.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:287;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:27:\"sunrise-avenue-1200x431.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("162","315","_wxr_import_parent","312");
INSERT INTO `a3rfa_postmeta` VALUES("163","315","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("164","315","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("165","320","_wp_attached_file","2015/05/singapore.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("166","320","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:700;s:4:\"file\";s:21:\"2015/05/singapore.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:21:\"singapore-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:21:\"singapore-300x108.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:108;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:21:\"singapore-768x276.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:276;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:22:\"singapore-1024x368.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:368;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:21:\"singapore-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:21:\"singapore-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:21:\"singapore-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:21:\"singapore-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:21:\"singapore-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:21:\"singapore-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:21:\"singapore-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:21:\"singapore-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:19:\"singapore-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:20:\"singapore-200x72.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:72;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:21:\"singapore-400x144.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:144;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:21:\"singapore-600x215.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:215;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:21:\"singapore-800x287.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:287;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:22:\"singapore-1200x431.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("167","320","_wxr_import_parent","319");
INSERT INTO `a3rfa_postmeta` VALUES("168","320","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("169","320","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("170","324","_wp_attached_file","2015/05/st-lucia.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("171","324","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:700;s:4:\"file\";s:20:\"2015/05/st-lucia.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:20:\"st-lucia-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:20:\"st-lucia-300x108.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:108;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:20:\"st-lucia-768x276.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:276;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:21:\"st-lucia-1024x368.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:368;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:20:\"st-lucia-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:20:\"st-lucia-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:20:\"st-lucia-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:20:\"st-lucia-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:20:\"st-lucia-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:20:\"st-lucia-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:20:\"st-lucia-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:20:\"st-lucia-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:18:\"st-lucia-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:19:\"st-lucia-200x72.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:72;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:20:\"st-lucia-400x144.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:144;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:20:\"st-lucia-600x215.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:215;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:20:\"st-lucia-800x287.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:287;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:21:\"st-lucia-1200x431.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("172","324","_wxr_import_parent","323");
INSERT INTO `a3rfa_postmeta` VALUES("173","324","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("174","324","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("175","329","_wp_attached_file","2015/05/denmark.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("176","329","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:700;s:4:\"file\";s:19:\"2015/05/denmark.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:19:\"denmark-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:19:\"denmark-300x108.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:108;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:19:\"denmark-768x276.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:276;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:20:\"denmark-1024x368.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:368;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:19:\"denmark-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:19:\"denmark-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-two\";a:4:{s:4:\"file\";s:19:\"denmark-460x295.jpg\";s:5:\"width\";i:460;s:6:\"height\";i:295;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:15:\"portfolio-three\";a:4:{s:4:\"file\";s:19:\"denmark-300x214.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-five\";a:4:{s:4:\"file\";s:19:\"denmark-177x142.jpg\";s:5:\"width\";i:177;s:6:\"height\";i:142;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"blog-large\";a:4:{s:4:\"file\";s:19:\"denmark-669x272.jpg\";s:5:\"width\";i:669;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"blog-medium\";a:4:{s:4:\"file\";s:19:\"denmark-320x202.jpg\";s:5:\"width\";i:320;s:6:\"height\";i:202;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"recent-posts\";a:4:{s:4:\"file\";s:19:\"denmark-700x441.jpg\";s:5:\"width\";i:700;s:6:\"height\";i:441;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:22:\"recent-works-thumbnail\";a:4:{s:4:\"file\";s:17:\"denmark-66x66.jpg\";s:5:\"width\";i:66;s:6:\"height\";i:66;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-200\";a:4:{s:4:\"file\";s:18:\"denmark-200x72.jpg\";s:5:\"width\";i:200;s:6:\"height\";i:72;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-400\";a:4:{s:4:\"file\";s:19:\"denmark-400x144.jpg\";s:5:\"width\";i:400;s:6:\"height\";i:144;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-600\";a:4:{s:4:\"file\";s:19:\"denmark-600x215.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:215;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:10:\"fusion-800\";a:4:{s:4:\"file\";s:19:\"denmark-800x287.jpg\";s:5:\"width\";i:800;s:6:\"height\";i:287;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:11:\"fusion-1200\";a:4:{s:4:\"file\";s:20:\"denmark-1200x431.jpg\";s:5:\"width\";i:1200;s:6:\"height\";i:431;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `a3rfa_postmeta` VALUES("177","329","_wxr_import_parent","328");
INSERT INTO `a3rfa_postmeta` VALUES("178","329","_wxr_import_user_slug","admin");
INSERT INTO `a3rfa_postmeta` VALUES("179","329","fusion_demo_import","architecture");
INSERT INTO `a3rfa_postmeta` VALUES("180","331","_wp_attached_file","2015/05/japan.jpg");
INSERT INTO `a3rfa_postmeta` VALUES("181","331","_wp_attachment_metadata","a:5:{s:5:\"width\";i:1950;s:6:\"height\";i:700;s:4:\"file\";s:17:\"2015/05/japan.jpg\";s:5:\"sizes\";a:18:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:17:\"japan-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"japan-300x108.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:108;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:12:\"medium_large\";a:4:{s:4:\"file\";s:17:\"japan-768x276.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:276;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:18:\"japan-1024x368.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:368;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"portfolio-full\";a:4:{s:4:\"file\";s:17:\"japan-940x400.jpg\";s:5:\"width\";i:940;s:6:\"height\";i:400;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"portfolio-one\";a:4:{s:4:\"file\";s:17:\"japan-540x272.jpg\";s:5:\"width\";i:540;s:6:\"height\";i:272;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:13:\"port